/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

#ifndef _PORT_H
#define _PORT_H

/* ----------------------- Platform includes --------------------------------*/
#include "runtime/lib.h"
#include "kernel/uos.h"
#include <portgen.h>

#define ENTER_CRITICAL_SECTION( )   MB_PortEnterCritical()
#define EXIT_CRITICAL_SECTION( )    MB_PortExitCritical()

/*! MODBUS RTU use this macro to define an size of internal receive buffer 
 * */
//#define MB_SER_RECV_SIZE 256

/* ----------------------- Prototypes ---------------------------------------*/
extern volatile BOOL InException;
INLINE CODE_ISR 
void MB_PortSetWithinException( BOOL bInException ){InException = bInException;};

INLINE CODE_ISR 
BOOL        MB_PortIsWithinException( void ){return InException;};

void            MB_PortEnterCritical( void );
void            MB_PortExitCritical( void );

/* ----------------------- Event specific ------------------------------------*/

#define vMBPortEventClose()

/* ----------------------- ELVEES platform specifics ---------------------------*/
#include "hwconfig.h"

#include "multicore/nvcom02t/nvcom02_mem_map.h"
#include "multicore/nvcom02t/nvcom02_uart_regs.h"
#include "multicore/nvcom02t/nvcom02_system_regs.h"

/**\~russian
 *  это макро включает использование блочной отсылки буффера вместо посимвольной
 *  через xMBPortSerialPutByte 
 * */
#ifdef MC_UART_FIFO_SIZE
#define MB_USE_TXFIFO
#endif

//* same as xMBPortSerialGetByte, also returns uart error status
//* \param[out] puByte - low byte - received char, 
//*                       high byte - error info, 0 - if no errors
#define MB_HAVE_XGETBYTE

//для более компактного кода
#define MB_OPTMISE_SIZE     0
//для кода более точного к таймаутам
#define MB_OPTMISE_ACCURATE 1

#define MB_OPTMISE      MB_OPTMISE_ACCURATE


#include <protoport.h>
#include <mblocal.h>

#ifndef DEBUG_MBtx
#define DEBUG_MBtx(x)
#endif
#ifndef DEBUG_MBrx
#define DEBUG_MBrx(x)
#endif



#include <trace.h>

#endif
