/* ---------------------------------------------------------------------------- */
/*                  Atmel Microcontroller Software Support                      */
/* ---------------------------------------------------------------------------- */
/* Copyright (c) 2009, Atmel Corporation                                       */
/*                                                                              */
/* All rights reserved.                                                         */
/*                                                                              */
/* Redistribution and use in source and binary forms, with or without           */
/* modification, are permitted provided that the following condition is met:    */
/*                                                                              */
/* - Redistributions of source code must retain the above copyright notice,     */
/* this list of conditions and the disclaimer below.                            */
/*                                                                              */
/* Atmel's name may not be used to endorse or promote products derived from     */
/* this software without specific prior written permission.                     */
/*                                                                              */
/* DISCLAIMER:  THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR   */
/* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE   */
/* DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,      */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,  */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING         */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, */
/* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                           */
/* ---------------------------------------------------------------------------- */
/*                                                                              */
/* File Name    : AT91SAM3U.h */
/* Object       : AT91SAM3U definitions */
/* Generated by : AT91 SW Application Group */
/* Generated on : 2009-09-10 */

#ifndef AT91SAM3U_H
#define AT91SAM3U_H

/** \addtogroup AT91SAM3U_definitions AT91SAM3U definitions
  This file defines all structures and symbols for AT91SAM3U:
    - registers and bitfields
    - peripheral base address
    - peripheral ID
    - PIO definitions
*/
/*@{*/

#ifdef __cplusplus
 extern "C" {
#endif 

#ifndef __ASSEMBLY__
#include <stdint.h>
#ifndef __cplusplus
typedef volatile const uint32_t RoReg; /**< Read only 32-bit register (volatile const unsigned int) */
#else
typedef volatile       uint32_t RoReg; /**< Read only 32-bit register (volatile const unsigned int) */
#endif
typedef volatile       uint32_t WoReg; /**< Write only 32-bit register (volatile unsigned int) */
typedef volatile       uint32_t RwReg; /**< Read-Write 32-bit register (volatile unsigned int) */
#define CAST(type, value) ((type *) value)
#define REG_ACCESS(type, address) (*(type*)address) /**< C code: Register value */
#else
#define CAST(type, value) (value) 
#define REG_ACCESS(type, address) (address) /**< Assembly code: Register address */
#endif

/* ***************************************************************************** */
/*   CMSIS DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_cmsis CMSIS Definitions */

/*@{*/

/**
 * \brief Configuration of the Cortex-M3 Processor and Core Peripherals 
 */
#define __MPU_PRESENT             0 /**< AT91SAM3U does not provide a MPU present or not */
#define __NVIC_PRIO_BITS          4 /**< AT91SAM3U uses 4 Bits for the Priority Levels */
#define __Vendor_SysTickConfig    0 /**< Set to 1 if different SysTick Config is used */

/**< Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M3 Processor Exceptions Numbers ***************************************/
  NonMaskableInt_IRQn         = -14,    /**<  2 Non Maskable Interrupt                */
  MemoryManagement_IRQn       = -12,    /**<  4 Cortex-M3 Memory Management Interrupt */
  BusFault_IRQn               = -11,    /**<  5 Cortex-M3 Bus Fault Interrupt         */
  UsageFault_IRQn             = -10,    /**<  6 Cortex-M3 Usage Fault Interrupt       */
  SVCall_IRQn                 = -5,     /**< 11 Cortex-M3 SV Call Interrupt           */
  DebugMonitor_IRQn           = -4,     /**< 12 Cortex-M3 Debug Monitor Interrupt     */
  PendSV_IRQn                 = -2,     /**< 14 Cortex-M3 Pend SV Interrupt           */
  SysTick_IRQn                = -1,     /**< 15 Cortex-M3 System Tick Interrupt       */
/******  AT91SAM3U specific Interrupt Numbers *****************************************/
  
  SUPC_IRQn            =  0, /**<  0 AT91SAM3U Supply Controller (SUPC) */
  RSTC_IRQn            =  1, /**<  1 AT91SAM3U Reset Controller (RSTC) */
  RTC_IRQn             =  2, /**<  2 AT91SAM3U Real Time Clock (RTC) */
  RTT_IRQn             =  3, /**<  3 AT91SAM3U Real Time Timer (RTT) */
  WDT_IRQn             =  4, /**<  4 AT91SAM3U Watchdog Timer (WDT) */
  PMC_IRQn             =  5, /**<  5 AT91SAM3U Power Management Controller (PMC) */
  EFC0_IRQn            =  6, /**<  6 AT91SAM3U Enhanced Embedded Flash Controller 0 (EFC0) */
  EFC1_IRQn            =  7, /**<  7 AT91SAM3U Enhanced Embedded Flash Controller 1 (EFC1) */
  UART_IRQn            =  8, /**<  8 AT91SAM3U Universal Asynchronous Receiver Transmitter (UART) */
  SMC_IRQn             =  9, /**<  9 AT91SAM3U Static Memory Controller (SMC) */
  PIOA_IRQn            = 10, /**< 10 AT91SAM3U Parallel I/O Controller A, (PIOA) */
  PIOB_IRQn            = 11, /**< 11 AT91SAM3U Parallel I/O Controller B (PIOB) */
  PIOC_IRQn            = 12, /**< 12 AT91SAM3U Parallel I/O Controller C (PIOC) */
  USART0_IRQn          = 13, /**< 13 AT91SAM3U USART 0 (USART0) */
  USART1_IRQn          = 14, /**< 14 AT91SAM3U USART 1 (USART1) */
  USART2_IRQn          = 15, /**< 15 AT91SAM3U USART 2 (USART2) */
  USART3_IRQn          = 16, /**< 16 AT91SAM3U USART 3 (USART3) */
  HSMCI_IRQn           = 17, /**< 17 AT91SAM3U High Speed Multimedia Card Interface (HSMCI) */
  TWI0_IRQn            = 18, /**< 18 AT91SAM3U Two-Wire Interface 0 (TWI0) */
  TWI1_IRQn            = 19, /**< 19 AT91SAM3U Two-Wire Interface 1 (TWI1) */
  SPI_IRQn             = 20, /**< 20 AT91SAM3U Serial Peripheral Interface (SPI) */
  SSC_IRQn             = 21, /**< 21 AT91SAM3U Synchronous Serial Controller (SSC) */
  TC0_IRQn             = 22, /**< 22 AT91SAM3U Timer Counter 0 (TC0) */
  TC1_IRQn             = 23, /**< 23 AT91SAM3U Timer Counter 1 (TC1) */
  TC2_IRQn             = 24, /**< 24 AT91SAM3U Timer Counter 2 (TC2) */
  PWM_IRQn             = 25, /**< 25 AT91SAM3U Pulse Width Modulation Controller (PWM) */
  ADC12B_IRQn          = 26, /**< 26 AT91SAM3U 12-bit ADC Controller (ADC12B) */
  ADC_IRQn             = 27, /**< 27 AT91SAM3U 10-bit ADC Controller (ADC) */
  DMAC_IRQn            = 28, /**< 28 AT91SAM3U DMA Controller (DMAC) */
  UDPHS_IRQn           = 29, /**< 29 AT91SAM3U USB Device High Speed (UDPHS) */
} IRQn_Type;
/*@}*/

/* ***************************************************************************** */
/**  SOFTWARE PERIPHERAL API DEFINITION FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_api Peripheral Software API */

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Analog-to-digital Converter */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_ADC12B Analog-to-digital Converter */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Adc12b hardware registers */
typedef struct {
  WoReg ADC_CR;        /**< \brief (Adc12b Offset: 0x00) Control Register */
  RwReg ADC_MR;        /**< \brief (Adc12b Offset: 0x04) Mode Register */
  RwReg Reserved1[2]; 
  WoReg ADC_CHER;      /**< \brief (Adc12b Offset: 0x10) Channel Enable Register */
  WoReg ADC_CHDR;      /**< \brief (Adc12b Offset: 0x14) Channel Disable Register */
  RoReg ADC_CHSR;      /**< \brief (Adc12b Offset: 0x18) Channel Status Register */
  RoReg ADC_SR;        /**< \brief (Adc12b Offset: 0x1C) Status Register */
  RoReg ADC_LCDR;      /**< \brief (Adc12b Offset: 0x20) Last Converted Data Register */
  WoReg ADC_IER;       /**< \brief (Adc12b Offset: 0x24) Interrupt Enable Register */
  WoReg ADC_IDR;       /**< \brief (Adc12b Offset: 0x28) Interrupt Disable Register */
  RoReg ADC_IMR;       /**< \brief (Adc12b Offset: 0x2C) Interrupt Mask Register */
  RoReg ADC_CDR[8];    /**< \brief (Adc12b Offset: 0x30) Channel Data Register */
  RwReg Reserved2[5]; 
  RwReg ADC_ACR;       /**< \brief (Adc12b Offset: 0x64) Analog Control Register */
  RwReg ADC_EMR;       /**< \brief (Adc12b Offset: 0x68) Extended Mode Register */
  RwReg Reserved3[37];
  RwReg ADC_RPR;       /**< \brief (Adc12b Offset: 0x100) Receive Pointer Register */
  RwReg ADC_RCR;       /**< \brief (Adc12b Offset: 0x104) Receive Counter Register */
  RwReg ADC_TPR;       /**< \brief (Adc12b Offset: 0x108) Transmit Pointer Register */
  RwReg ADC_TCR;       /**< \brief (Adc12b Offset: 0x10C) Transmit Counter Register */
  RwReg ADC_RNPR;      /**< \brief (Adc12b Offset: 0x110) Receive Next Pointer Register */
  RwReg ADC_RNCR;      /**< \brief (Adc12b Offset: 0x114) Receive Next Counter Register */
  RwReg ADC_TNPR;      /**< \brief (Adc12b Offset: 0x118) Transmit Next Pointer Register */
  RwReg ADC_TNCR;      /**< \brief (Adc12b Offset: 0x11C) Transmit Next Counter Register */
  WoReg ADC_PTCR;      /**< \brief (Adc12b Offset: 0x120) Transfer Control Register */
  RoReg ADC_PTSR;      /**< \brief (Adc12b Offset: 0x124) Transfer Status Register */
} Adc12b;
#endif /* __ASSEMBLY__ */
/* -------- ADC_CR : (ADC12B Offset: 0x00) Control Register -------- */
#define ADC_CR_SWRST (0x1 << 0) /**< \brief (ADC_CR) Software Reset */
#define ADC_CR_START (0x1 << 1) /**< \brief (ADC_CR) Start Conversion */
/* -------- ADC_MR : (ADC12B Offset: 0x04) Mode Register -------- */
#define ADC_MR_TRGEN (0x1 << 0) /**< \brief (ADC_MR) Trigger Enable */
#define ADC_MR_TRGSEL (0x7 << 1) /**< \brief (ADC_MR) Trigger Selection */
#define ADC_MR_LOWRES (0x1 << 4) /**< \brief (ADC_MR) Resolution */
#define ADC_MR_SLEEP (0x1 << 5) /**< \brief (ADC_MR) Sleep Mode */
#define ADC_MR_PRESCAL (0xff << 8) /**< \brief (ADC_MR) Prescaler Rate Selection */
#define ADC_MR_STARTUP (0xff << 16) /**< \brief (ADC_MR) Start Up Time */
#define ADC_MR_SHTIM (0xf << 24) /**< \brief (ADC_MR) Sample & Hold Time */
/* -------- ADC_CHER : (ADC12B Offset: 0x10) Channel Enable Register -------- */
#define ADC_CHER_CH0 (0x1 << 0) /**< \brief (ADC_CHER) Channel 0 Enable */
#define ADC_CHER_CH1 (0x1 << 1) /**< \brief (ADC_CHER) Channel 1 Enable */
#define ADC_CHER_CH2 (0x1 << 2) /**< \brief (ADC_CHER) Channel 2 Enable */
#define ADC_CHER_CH3 (0x1 << 3) /**< \brief (ADC_CHER) Channel 3 Enable */
#define ADC_CHER_CH4 (0x1 << 4) /**< \brief (ADC_CHER) Channel 4 Enable */
#define ADC_CHER_CH5 (0x1 << 5) /**< \brief (ADC_CHER) Channel 5 Enable */
#define ADC_CHER_CH6 (0x1 << 6) /**< \brief (ADC_CHER) Channel 6 Enable */
#define ADC_CHER_CH7 (0x1 << 7) /**< \brief (ADC_CHER) Channel 7 Enable */
/* -------- ADC_CHDR : (ADC12B Offset: 0x14) Channel Disable Register -------- */
#define ADC_CHDR_CH0 (0x1 << 0) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH1 (0x1 << 1) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH2 (0x1 << 2) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH3 (0x1 << 3) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH4 (0x1 << 4) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH5 (0x1 << 5) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH6 (0x1 << 6) /**< \brief (ADC_CHDR)  */
#define ADC_CHDR_CH7 (0x1 << 7) /**< \brief (ADC_CHDR)  */
/* -------- ADC_CHSR : (ADC12B Offset: 0x18) Channel Status Register -------- */
#define ADC_CHSR_CH0 (0x1 << 0) /**< \brief (ADC_CHSR) Channel 0 Status */
#define ADC_CHSR_CH1 (0x1 << 1) /**< \brief (ADC_CHSR) Channel 1 Status */
#define ADC_CHSR_CH2 (0x1 << 2) /**< \brief (ADC_CHSR) Channel 2 Status */
#define ADC_CHSR_CH3 (0x1 << 3) /**< \brief (ADC_CHSR) Channel 3 Status */
#define ADC_CHSR_CH4 (0x1 << 4) /**< \brief (ADC_CHSR) Channel 4 Status */
#define ADC_CHSR_CH5 (0x1 << 5) /**< \brief (ADC_CHSR) Channel 5 Status */
#define ADC_CHSR_CH6 (0x1 << 6) /**< \brief (ADC_CHSR) Channel 6 Status */
#define ADC_CHSR_CH7 (0x1 << 7) /**< \brief (ADC_CHSR) Channel 7 Status */
/* -------- ADC_SR : (ADC12B Offset: 0x1C) Status Register -------- */
#define ADC_SR_EOC0 (0x1 << 0) /**< \brief (ADC_SR) End of Conversion 0 */
#define ADC_SR_EOC1 (0x1 << 1) /**< \brief (ADC_SR) End of Conversion 1 */
#define ADC_SR_EOC2 (0x1 << 2) /**< \brief (ADC_SR) End of Conversion 2 */
#define ADC_SR_EOC3 (0x1 << 3) /**< \brief (ADC_SR) End of Conversion 3 */
#define ADC_SR_EOC4 (0x1 << 4) /**< \brief (ADC_SR) End of Conversion 4 */
#define ADC_SR_EOC5 (0x1 << 5) /**< \brief (ADC_SR) End of Conversion 5 */
#define ADC_SR_EOC6 (0x1 << 6) /**< \brief (ADC_SR) End of Conversion 6 */
#define ADC_SR_EOC7 (0x1 << 7) /**< \brief (ADC_SR) End of Conversion 7 */
#define ADC_SR_OVRE0 (0x1 << 8) /**< \brief (ADC_SR) Overrun Error 0 */
#define ADC_SR_OVRE1 (0x1 << 9) /**< \brief (ADC_SR) Overrun Error 1 */
#define ADC_SR_OVRE2 (0x1 << 10) /**< \brief (ADC_SR) Overrun Error 2 */
#define ADC_SR_OVRE3 (0x1 << 11) /**< \brief (ADC_SR) Overrun Error 3 */
#define ADC_SR_OVRE4 (0x1 << 12) /**< \brief (ADC_SR) Overrun Error 4 */
#define ADC_SR_OVRE5 (0x1 << 13) /**< \brief (ADC_SR) Overrun Error 5 */
#define ADC_SR_OVRE6 (0x1 << 14) /**< \brief (ADC_SR) Overrun Error 6 */
#define ADC_SR_OVRE7 (0x1 << 15) /**< \brief (ADC_SR) Overrun Error 7 */
#define ADC_SR_DRDY (0x1 << 16) /**< \brief (ADC_SR) Data Ready */
#define ADC_SR_GOVRE (0x1 << 17) /**< \brief (ADC_SR) General Overrun Error */
#define ADC_SR_ENDRX (0x1 << 18) /**< \brief (ADC_SR) End of RX Buffer */
#define ADC_SR_RXBUFF (0x1 << 19) /**< \brief (ADC_SR) RX Buffer Full */
/* -------- ADC_LCDR : (ADC12B Offset: 0x20) Last Converted Data Register -------- */
#define ADC_LCDR_LDATA (0xfff << 0) /**< \brief (ADC_LCDR) Last Data Converted */
/* -------- ADC_IER : (ADC12B Offset: 0x24) Interrupt Enable Register -------- */
#define ADC_IER_EOC0 (0x1 << 0) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 0 */
#define ADC_IER_EOC1 (0x1 << 1) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 1 */
#define ADC_IER_EOC2 (0x1 << 2) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 2 */
#define ADC_IER_EOC3 (0x1 << 3) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 3 */
#define ADC_IER_EOC4 (0x1 << 4) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 4 */
#define ADC_IER_EOC5 (0x1 << 5) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 5 */
#define ADC_IER_EOC6 (0x1 << 6) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 6 */
#define ADC_IER_EOC7 (0x1 << 7) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 7 */
#define ADC_IER_OVRE0 (0x1 << 8) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 0 */
#define ADC_IER_OVRE1 (0x1 << 9) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 1 */
#define ADC_IER_OVRE2 (0x1 << 10) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 2 */
#define ADC_IER_OVRE3 (0x1 << 11) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 3 */
#define ADC_IER_OVRE4 (0x1 << 12) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 4 */
#define ADC_IER_OVRE5 (0x1 << 13) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 5 */
#define ADC_IER_OVRE6 (0x1 << 14) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 6 */
#define ADC_IER_OVRE7 (0x1 << 15) /**< \brief (ADC_IER) Overrun Error Interrupt Enable 7 */
#define ADC_IER_DRDY (0x1 << 16) /**< \brief (ADC_IER) Data Ready Interrupt Enable */
#define ADC_IER_GOVRE (0x1 << 17) /**< \brief (ADC_IER) General Overrun Error Interrupt Enable */
#define ADC_IER_ENDRX (0x1 << 18) /**< \brief (ADC_IER) End of Receive Buffer Interrupt Enable */
#define ADC_IER_RXBUFF (0x1 << 19) /**< \brief (ADC_IER) Receive Buffer Full Interrupt Enable */
/* -------- ADC_IDR : (ADC12B Offset: 0x28) Interrupt Disable Register -------- */
#define ADC_IDR_EOC0 (0x1 << 0) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 0 */
#define ADC_IDR_EOC1 (0x1 << 1) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 1 */
#define ADC_IDR_EOC2 (0x1 << 2) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 2 */
#define ADC_IDR_EOC3 (0x1 << 3) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 3 */
#define ADC_IDR_EOC4 (0x1 << 4) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 4 */
#define ADC_IDR_EOC5 (0x1 << 5) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 5 */
#define ADC_IDR_EOC6 (0x1 << 6) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 6 */
#define ADC_IDR_EOC7 (0x1 << 7) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 7 */
#define ADC_IDR_OVRE0 (0x1 << 8) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 0 */
#define ADC_IDR_OVRE1 (0x1 << 9) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 1 */
#define ADC_IDR_OVRE2 (0x1 << 10) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 2 */
#define ADC_IDR_OVRE3 (0x1 << 11) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 3 */
#define ADC_IDR_OVRE4 (0x1 << 12) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 4 */
#define ADC_IDR_OVRE5 (0x1 << 13) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 5 */
#define ADC_IDR_OVRE6 (0x1 << 14) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 6 */
#define ADC_IDR_OVRE7 (0x1 << 15) /**< \brief (ADC_IDR) Overrun Error Interrupt Disable 7 */
#define ADC_IDR_DRDY (0x1 << 16) /**< \brief (ADC_IDR) Data Ready Interrupt Disable */
#define ADC_IDR_GOVRE (0x1 << 17) /**< \brief (ADC_IDR) General Overrun Error Interrupt Disable */
#define ADC_IDR_ENDRX (0x1 << 18) /**< \brief (ADC_IDR) End of Receive Buffer Interrupt Disable */
#define ADC_IDR_RXBUFF (0x1 << 19) /**< \brief (ADC_IDR) Receive Buffer Full Interrupt Disable */
/* -------- ADC_IMR : (ADC12B Offset: 0x2C) Interrupt Mask Register -------- */
#define ADC_IMR_EOC0 (0x1 << 0) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 0 */
#define ADC_IMR_EOC1 (0x1 << 1) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 1 */
#define ADC_IMR_EOC2 (0x1 << 2) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 2 */
#define ADC_IMR_EOC3 (0x1 << 3) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 3 */
#define ADC_IMR_EOC4 (0x1 << 4) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 4 */
#define ADC_IMR_EOC5 (0x1 << 5) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 5 */
#define ADC_IMR_EOC6 (0x1 << 6) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 6 */
#define ADC_IMR_EOC7 (0x1 << 7) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 7 */
#define ADC_IMR_OVRE0 (0x1 << 8) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 0 */
#define ADC_IMR_OVRE1 (0x1 << 9) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 1 */
#define ADC_IMR_OVRE2 (0x1 << 10) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 2 */
#define ADC_IMR_OVRE3 (0x1 << 11) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 3 */
#define ADC_IMR_OVRE4 (0x1 << 12) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 4 */
#define ADC_IMR_OVRE5 (0x1 << 13) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 5 */
#define ADC_IMR_OVRE6 (0x1 << 14) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 6 */
#define ADC_IMR_OVRE7 (0x1 << 15) /**< \brief (ADC_IMR) Overrun Error Interrupt Mask 7 */
#define ADC_IMR_DRDY (0x1 << 16) /**< \brief (ADC_IMR) Data Ready Interrupt Mask */
#define ADC_IMR_GOVRE (0x1 << 17) /**< \brief (ADC_IMR) General Overrun Error Interrupt Mask */
#define ADC_IMR_ENDRX (0x1 << 18) /**< \brief (ADC_IMR) End of Receive Buffer Interrupt Mask */
#define ADC_IMR_RXBUFF (0x1 << 19) /**< \brief (ADC_IMR) Receive Buffer Full Interrupt Mask */
/* -------- ADC_CDR[8] : (ADC12B Offset: 0x30) Channel Data Register -------- */
#define ADC_CDR_DATA (0xfff << 0) /**< \brief (ADC_CDR[8]) Converted Data */
/* -------- ADC_ACR : (ADC12B Offset: 0x64) Analog Control Register -------- */
#define ADC_ACR_GAIN (0x3 << 0) /**< \brief (ADC_ACR) Input Gain */
#define ADC_ACR_IBCTL (0x3 << 6) /**< \brief (ADC_ACR) Bias Current Control */
#define ADC_ACR_DIFF (0x1 << 16) /**< \brief (ADC_ACR) Differential Mode */
#define ADC_ACR_OFFSET (0x1 << 17) /**< \brief (ADC_ACR) Input OFFSET */
/* -------- ADC_EMR : (ADC12B Offset: 0x68) Extended Mode Register -------- */
#define ADC_EMR_OFFMODES (0x1 << 0) /**< \brief (ADC_EMR) Off Mode if Sleep Bit (ADC_MR) = 1 */
#define ADC_EMR_OFF_MODE_STARTUP_TIME (0xff << 16) /**< \brief (ADC_EMR) Startup Time */
/* -------- ADC_RPR : (ADC12B Offset: 0x100) Receive Pointer Register -------- */
#define ADC_RPR_RXPTR (0xffffffff << 0) /**< \brief (ADC_RPR) Receive Pointer Register */
/* -------- ADC_RCR : (ADC12B Offset: 0x104) Receive Counter Register -------- */
#define ADC_RCR_RXCTR (0xffff << 0) /**< \brief (ADC_RCR) Receive Counter Register */
/* -------- ADC_TPR : (ADC12B Offset: 0x108) Transmit Pointer Register -------- */
#define ADC_TPR_TXPTR (0xffffffff << 0) /**< \brief (ADC_TPR) Transmit Counter Register */
/* -------- ADC_TCR : (ADC12B Offset: 0x10C) Transmit Counter Register -------- */
#define ADC_TCR_TXCTR (0xffff << 0) /**< \brief (ADC_TCR) Transmit Counter Register */
/* -------- ADC_RNPR : (ADC12B Offset: 0x110) Receive Next Pointer Register -------- */
#define ADC_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (ADC_RNPR) Receive Next Pointer */
/* -------- ADC_RNCR : (ADC12B Offset: 0x114) Receive Next Counter Register -------- */
#define ADC_RNCR_RXNCTR (0xffff << 0) /**< \brief (ADC_RNCR) Receive Next Counter */
/* -------- ADC_TNPR : (ADC12B Offset: 0x118) Transmit Next Pointer Register -------- */
#define ADC_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (ADC_TNPR) Transmit Next Pointer */
/* -------- ADC_TNCR : (ADC12B Offset: 0x11C) Transmit Next Counter Register -------- */
#define ADC_TNCR_TXNCTR (0xffff << 0) /**< \brief (ADC_TNCR) Transmit Counter Next */
/* -------- ADC_PTCR : (ADC12B Offset: 0x120) Transfer Control Register -------- */
#define ADC_PTCR_RXTEN (0x1 << 0) /**< \brief (ADC_PTCR) Receiver Transfer Enable */
#define ADC_PTCR_RXTDIS (0x1 << 1) /**< \brief (ADC_PTCR) Receiver Transfer Disable */
#define ADC_PTCR_TXTEN (0x1 << 8) /**< \brief (ADC_PTCR) Transmitter Transfer Enable */
#define ADC_PTCR_TXTDIS (0x1 << 9) /**< \brief (ADC_PTCR) Transmitter Transfer Disable */
/* -------- ADC_PTSR : (ADC12B Offset: 0x124) Transfer Status Register -------- */
#define ADC_PTSR_RXTEN (0x1 << 0) /**< \brief (ADC_PTSR) Receiver Transfer Enable */
#define ADC_PTSR_TXTEN (0x1 << 8) /**< \brief (ADC_PTSR) Transmitter Transfer Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Chip Identifier */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_CHIPID Chip Identifier */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Chipid hardware registers */
typedef struct {
  RoReg CHIPID_CIDR; /**< \brief (Chipid Offset: 0x0) Chip ID Register */
  RoReg CHIPID_EXID; /**< \brief (Chipid Offset: 0x4) Chip ID Extension Register */
} Chipid;
#endif /* __ASSEMBLY__ */
/* -------- CHIPID_CIDR : (CHIPID Offset: 0x0) Chip ID Register -------- */
#define CHIPID_CIDR_VERSION (0x1f << 0) /**< \brief (CHIPID_CIDR) Version of the Device */
#define CHIPID_CIDR_EPROC (0x7 << 5) /**< \brief (CHIPID_CIDR) Embedded Processor */
#define CHIPID_CIDR_NVPSIZ (0xf << 8) /**< \brief (CHIPID_CIDR) Nonvolatile Program Memory Size */
#define CHIPID_CIDR_NVPSIZ2 (0xf << 12) /**< \brief (CHIPID_CIDR)  */
#define CHIPID_CIDR_SRAMSIZ (0xf << 16) /**< \brief (CHIPID_CIDR) Internal SRAM Size */
#define CHIPID_CIDR_ARCH (0xff << 20) /**< \brief (CHIPID_CIDR) Architecture Identifier */
#define CHIPID_CIDR_NVPTYP (0x7 << 28) /**< \brief (CHIPID_CIDR) Nonvolatile Program Memory Type */
#define CHIPID_CIDR_EXT (0x1 << 31) /**< \brief (CHIPID_CIDR) Extension Flag */
/* -------- CHIPID_EXID : (CHIPID Offset: 0x4) Chip ID Extension Register -------- */
#define CHIPID_EXID_EXID (0xffffffff << 0) /**< \brief (CHIPID_EXID) Chip ID Extension */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR DMA Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_DMAC DMA Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief DmacCh_num hardware registers */
typedef struct {
  RwReg       DMAC_SADDR;     /**< \brief (DmacCh_num Offset: 0x0) DMAC Channel Source Address Register */
  RwReg       DMAC_DADDR;     /**< \brief (DmacCh_num Offset: 0x4) DMAC Channel Destination Address Register */
  RwReg       DMAC_DSCR;      /**< \brief (DmacCh_num Offset: 0x8) DMAC Channel Descriptor Address Register */
  RwReg       DMAC_CTRLA;     /**< \brief (DmacCh_num Offset: 0xC) DMAC Channel Control A Register */
  RwReg       DMAC_CTRLB;     /**< \brief (DmacCh_num Offset: 0x10) DMAC Channel Control B Register */
  RwReg       DMAC_CFG;       /**< \brief (DmacCh_num Offset: 0x14) DMAC Channel Configuration Register */
  RwReg       Reserved1[4];  
} DmacCh_num;
/** \brief Dmac hardware registers */
typedef struct {
  RwReg       DMAC_GCFG;      /**< \brief (Dmac Offset: 0x000) DMAC Global Configuration Register */
  RwReg       DMAC_EN;        /**< \brief (Dmac Offset: 0x004) DMAC Enable Register */
  RwReg       DMAC_SREQ;      /**< \brief (Dmac Offset: 0x008) DMAC Software Single Request Register */
  RwReg       DMAC_CREQ;      /**< \brief (Dmac Offset: 0x00C) DMAC Software Chunk Transfer Request Register */
  RwReg       DMAC_LAST;      /**< \brief (Dmac Offset: 0x010) DMAC Software Last Transfer Flag Register */
  RwReg       Reserved1[1];  
  WoReg       DMAC_EBCIER;    /**< \brief (Dmac Offset: 0x018) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register. */
  WoReg       DMAC_EBCIDR;    /**< \brief (Dmac Offset: 0x01C) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register. */
  RoReg       DMAC_EBCIMR;    /**< \brief (Dmac Offset: 0x020) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register. */
  RoReg       DMAC_EBCISR;    /**< \brief (Dmac Offset: 0x024) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register. */
  WoReg       DMAC_CHER;      /**< \brief (Dmac Offset: 0x028) DMAC Channel Handler Enable Register */
  WoReg       DMAC_CHDR;      /**< \brief (Dmac Offset: 0x02C) DMAC Channel Handler Disable Register */
  RoReg       DMAC_CHSR;      /**< \brief (Dmac Offset: 0x030) DMAC Channel Handler Status Register */
  RwReg       Reserved2[2];  
  DmacCh_num  DMAC_CH_NUM[4]; /**< \brief (Dmac Offset: 0x3C) ch_num = 0 .. 3 */
} Dmac;
#endif /* __ASSEMBLY__ */
/* -------- DMAC_GCFG : (DMAC Offset: 0x000) DMAC Global Configuration Register -------- */
#define DMAC_GCFG_ARB_CFG (0x1 << 4) /**< \brief (DMAC_GCFG)  */
/* -------- DMAC_EN : (DMAC Offset: 0x004) DMAC Enable Register -------- */
#define DMAC_EN_ENABLE (0x1 << 0) /**< \brief (DMAC_EN)  */
/* -------- DMAC_SREQ : (DMAC Offset: 0x008) DMAC Software Single Request Register -------- */
#define DMAC_SREQ_SSREQ0 (0x1 << 0) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_DSREQ0 (0x1 << 1) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_SSREQ1 (0x1 << 2) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_DSREQ1 (0x1 << 3) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_SSREQ2_ (0x1 << 4) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_DSREQ2_ (0x1 << 5) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_SSREQ3 (0x1 << 6) /**< \brief (DMAC_SREQ)  */
#define DMAC_SREQ_DSREQ3 (0x1 << 7) /**< \brief (DMAC_SREQ)  */
/* -------- DMAC_CREQ : (DMAC Offset: 0x00C) DMAC Software Chunk Transfer Request Register -------- */
#define DMAC_CREQ_SCREQ0 (0x1 << 0) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_DCREQ0 (0x1 << 1) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_SCREQ1 (0x1 << 2) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_DCREQ1 (0x1 << 3) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_SCREQ2_ (0x1 << 4) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_DCREQ2_ (0x1 << 5) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_SCREQ3 (0x1 << 6) /**< \brief (DMAC_CREQ)  */
#define DMAC_CREQ_DCREQ3 (0x1 << 7) /**< \brief (DMAC_CREQ)  */
/* -------- DMAC_LAST : (DMAC Offset: 0x010) DMAC Software Last Transfer Flag Register -------- */
#define DMAC_LAST_SLAST0 (0x1 << 0) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_DLAST0 (0x1 << 1) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_SLAST1 (0x1 << 2) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_DLAST1 (0x1 << 3) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_SLAST2 (0x1 << 4) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_DLAST2 (0x1 << 5) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_SLAST3 (0x1 << 6) /**< \brief (DMAC_LAST)  */
#define DMAC_LAST_DLAST3 (0x1 << 7) /**< \brief (DMAC_LAST)  */
/* -------- DMAC_EBCIER : (DMAC Offset: 0x018) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register. -------- */
#define DMAC_EBCIER_BTC0 (0x1 << 0) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_BTC1 (0x1 << 1) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_BTC2 (0x1 << 2) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_BTC3 (0x1 << 3) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_CBTC0 (0x1 << 8) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_CBTC1 (0x1 << 9) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_CBTC2 (0x1 << 10) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_CBTC3 (0x1 << 11) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_ERR0 (0x1 << 16) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_ERR1 (0x1 << 17) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_ERR2 (0x1 << 18) /**< \brief (DMAC_EBCIER)  */
#define DMAC_EBCIER_ERR3 (0x1 << 19) /**< \brief (DMAC_EBCIER)  */
/* -------- DMAC_EBCIDR : (DMAC Offset: 0x01C) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register. -------- */
#define DMAC_EBCIDR_BTC0 (0x1 << 0) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_BTC1 (0x1 << 1) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_BTC2 (0x1 << 2) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_BTC3 (0x1 << 3) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_CBTC0 (0x1 << 8) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_CBTC1 (0x1 << 9) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_CBTC2 (0x1 << 10) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_CBTC3 (0x1 << 11) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_ERR0 (0x1 << 16) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_ERR1 (0x1 << 17) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_ERR2 (0x1 << 18) /**< \brief (DMAC_EBCIDR)  */
#define DMAC_EBCIDR_ERR3 (0x1 << 19) /**< \brief (DMAC_EBCIDR)  */
/* -------- DMAC_EBCIMR : (DMAC Offset: 0x020) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register. -------- */
#define DMAC_EBCIMR_BTC0 (0x1 << 0) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_BTC1 (0x1 << 1) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_BTC2 (0x1 << 2) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_BTC3 (0x1 << 3) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_CBTC0 (0x1 << 8) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_CBTC1 (0x1 << 9) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_CBTC2 (0x1 << 10) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_CBTC3 (0x1 << 11) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_ERR0 (0x1 << 16) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_ERR1 (0x1 << 17) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_ERR2 (0x1 << 18) /**< \brief (DMAC_EBCIMR)  */
#define DMAC_EBCIMR_ERR3 (0x1 << 19) /**< \brief (DMAC_EBCIMR)  */
/* -------- DMAC_EBCISR : (DMAC Offset: 0x024) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register. -------- */
#define DMAC_EBCISR_BTC0 (0x1 << 0) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_BTC1 (0x1 << 1) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_BTC2 (0x1 << 2) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_BTC3 (0x1 << 3) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_CBTC0 (0x1 << 8) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_CBTC1 (0x1 << 9) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_CBTC2 (0x1 << 10) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_CBTC3 (0x1 << 11) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_ERR0 (0x1 << 16) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_ERR1 (0x1 << 17) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_ERR2 (0x1 << 18) /**< \brief (DMAC_EBCISR)  */
#define DMAC_EBCISR_ERR3 (0x1 << 19) /**< \brief (DMAC_EBCISR)  */
/* -------- DMAC_CHER : (DMAC Offset: 0x028) DMAC Channel Handler Enable Register -------- */
#define DMAC_CHER_ENA0 (0x1 << 0) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_ENA1 (0x1 << 1) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_ENA2 (0x1 << 2) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_ENA3 (0x1 << 3) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_SUSP0 (0x1 << 8) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_SUSP1 (0x1 << 9) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_SUSP2 (0x1 << 10) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_SUSP3 (0x1 << 11) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_KEEP0 (0x1 << 24) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_KEEP1 (0x1 << 25) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_KEEP2 (0x1 << 26) /**< \brief (DMAC_CHER)  */
#define DMAC_CHER_KEEP3 (0x1 << 27) /**< \brief (DMAC_CHER)  */
/* -------- DMAC_CHDR : (DMAC Offset: 0x02C) DMAC Channel Handler Disable Register -------- */
#define DMAC_CHDR_DIS0 (0x1 << 0) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_DIS1 (0x1 << 1) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_DIS2 (0x1 << 2) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_DIS3 (0x1 << 3) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_RES0 (0x1 << 8) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_RES1 (0x1 << 9) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_RES2 (0x1 << 10) /**< \brief (DMAC_CHDR)  */
#define DMAC_CHDR_RES3 (0x1 << 11) /**< \brief (DMAC_CHDR)  */
/* -------- DMAC_CHSR : (DMAC Offset: 0x030) DMAC Channel Handler Status Register -------- */
#define DMAC_CHSR_ENA0 (0x1 << 0) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_ENA1 (0x1 << 1) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_ENA2 (0x1 << 2) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_ENA3 (0x1 << 3) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_SUSP0 (0x1 << 8) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_SUSP1 (0x1 << 9) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_SUSP2 (0x1 << 10) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_SUSP3 (0x1 << 11) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_EMPT0 (0x1 << 16) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_EMPT1 (0x1 << 17) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_EMPT2 (0x1 << 18) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_EMPT3 (0x1 << 19) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_STAL0 (0x1 << 24) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_STAL1 (0x1 << 25) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_STAL2 (0x1 << 26) /**< \brief (DMAC_CHSR)  */
#define DMAC_CHSR_STAL3 (0x1 << 27) /**< \brief (DMAC_CHSR)  */
/* -------- DMAC_SADDR0 : (DMAC Offset: 0x3C) DMAC Channel Source Address Register (ch_num = 0) -------- */
#define DMAC_SADDR0_SADDRx (0xffffffff << 0) /**< \brief (DMAC_SADDR0)  */
/* -------- DMAC_DADDR0 : (DMAC Offset: 0x40) DMAC Channel Destination Address Register (ch_num = 0) -------- */
#define DMAC_DADDR0_DADDRx (0xffffffff << 0) /**< \brief (DMAC_DADDR0)  */
/* -------- DMAC_DSCR0 : (DMAC Offset: 0x44) DMAC Channel Descriptor Address Register (ch_num = 0) -------- */
#define DMAC_DSCR0_DSCRx (0x3fffffff << 2) /**< \brief (DMAC_DSCR0)  */
/* -------- DMAC_CTRLA0 : (DMAC Offset: 0x48) DMAC Channel Control A Register (ch_num = 0) -------- */
#define DMAC_CTRLA0_BTSIZE (0xfff << 0) /**< \brief (DMAC_CTRLA0)  */
#define DMAC_CTRLA0_SCSIZE (0x1 << 16) /**< \brief (DMAC_CTRLA0)  */
#define DMAC_CTRLA0_DCSIZE (0x1 << 20) /**< \brief (DMAC_CTRLA0)  */
#define DMAC_CTRLA0_SRC_WIDTH (0x3 << 24) /**< \brief (DMAC_CTRLA0)  */
#define DMAC_CTRLA0_DST_WIDTH (0x3 << 28) /**< \brief (DMAC_CTRLA0)  */
#define DMAC_CTRLA0_DONE (0x1 << 31) /**< \brief (DMAC_CTRLA0)  */
/* -------- DMAC_CTRLB0 : (DMAC Offset: 0x4C) DMAC Channel Control B Register (ch_num = 0) -------- */
#define DMAC_CTRLB0_SRC_DSCR (0x1 << 16) /**< \brief (DMAC_CTRLB0)  */
#define DMAC_CTRLB0_DST_DSCR (0x1 << 20) /**< \brief (DMAC_CTRLB0)  */
#define DMAC_CTRLB0_FC (0x3 << 21) /**< \brief (DMAC_CTRLB0)  */
#define DMAC_CTRLB0_SRC_INCR (0x3 << 24) /**< \brief (DMAC_CTRLB0)  */
#define DMAC_CTRLB0_DST_INCR (0x3 << 28) /**< \brief (DMAC_CTRLB0)  */
#define DMAC_CTRLB0_IEN (0x1 << 30) /**< \brief (DMAC_CTRLB0)  */
/* -------- DMAC_CFG0 : (DMAC Offset: 0x50) DMAC Channel Configuration Register (ch_num = 0) -------- */
#define DMAC_CFG0_SRC_PER (0xf << 0) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_DST_PER (0xf << 4) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_SRC_H2SEL (0x1 << 9) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_DST_H2SEL (0x1 << 13) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_SOD (0x1 << 16) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_LOCK_IF (0x1 << 20) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_LOCK_B (0x1 << 21) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_LOCK_IF_L (0x1 << 22) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_AHB_PROT (0x7 << 24) /**< \brief (DMAC_CFG0)  */
#define DMAC_CFG0_FIFOCFG (0x3 << 28) /**< \brief (DMAC_CFG0)  */
/* -------- DMAC_SADDR1 : (DMAC Offset: 0x64) DMAC Channel Source Address Register (ch_num = 1) -------- */
#define DMAC_SADDR1_SADDRx (0xffffffff << 0) /**< \brief (DMAC_SADDR1)  */
/* -------- DMAC_DADDR1 : (DMAC Offset: 0x68) DMAC Channel Destination Address Register (ch_num = 1) -------- */
#define DMAC_DADDR1_DADDRx (0xffffffff << 0) /**< \brief (DMAC_DADDR1)  */
/* -------- DMAC_DSCR1 : (DMAC Offset: 0x6C) DMAC Channel Descriptor Address Register (ch_num = 1) -------- */
#define DMAC_DSCR1_DSCRx (0x3fffffff << 2) /**< \brief (DMAC_DSCR1)  */
/* -------- DMAC_CTRLA1 : (DMAC Offset: 0x70) DMAC Channel Control A Register (ch_num = 1) -------- */
#define DMAC_CTRLA1_BTSIZE (0xfff << 0) /**< \brief (DMAC_CTRLA1)  */
#define DMAC_CTRLA1_SCSIZE (0x1 << 16) /**< \brief (DMAC_CTRLA1)  */
#define DMAC_CTRLA1_DCSIZE (0x1 << 20) /**< \brief (DMAC_CTRLA1)  */
#define DMAC_CTRLA1_SRC_WIDTH (0x3 << 24) /**< \brief (DMAC_CTRLA1)  */
#define DMAC_CTRLA1_DST_WIDTH (0x3 << 28) /**< \brief (DMAC_CTRLA1)  */
#define DMAC_CTRLA1_DONE (0x1 << 31) /**< \brief (DMAC_CTRLA1)  */
/* -------- DMAC_CTRLB1 : (DMAC Offset: 0x74) DMAC Channel Control B Register (ch_num = 1) -------- */
#define DMAC_CTRLB1_SRC_DSCR (0x1 << 16) /**< \brief (DMAC_CTRLB1)  */
#define DMAC_CTRLB1_DST_DSCR (0x1 << 20) /**< \brief (DMAC_CTRLB1)  */
#define DMAC_CTRLB1_FC (0x3 << 21) /**< \brief (DMAC_CTRLB1)  */
#define DMAC_CTRLB1_SRC_INCR (0x3 << 24) /**< \brief (DMAC_CTRLB1)  */
#define DMAC_CTRLB1_DST_INCR (0x3 << 28) /**< \brief (DMAC_CTRLB1)  */
#define DMAC_CTRLB1_IEN (0x1 << 30) /**< \brief (DMAC_CTRLB1)  */
/* -------- DMAC_CFG1 : (DMAC Offset: 0x78) DMAC Channel Configuration Register (ch_num = 1) -------- */
#define DMAC_CFG1_SRC_PER (0xf << 0) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_DST_PER (0xf << 4) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_SRC_H2SEL (0x1 << 9) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_DST_H2SEL (0x1 << 13) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_SOD (0x1 << 16) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_LOCK_IF (0x1 << 20) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_LOCK_B (0x1 << 21) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_LOCK_IF_L (0x1 << 22) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_AHB_PROT (0x7 << 24) /**< \brief (DMAC_CFG1)  */
#define DMAC_CFG1_FIFOCFG (0x3 << 28) /**< \brief (DMAC_CFG1)  */
/* -------- DMAC_SADDR2 : (DMAC Offset: 0x8C) DMAC Channel Source Address Register (ch_num = 2) -------- */
#define DMAC_SADDR2_SADDRx (0xffffffff << 0) /**< \brief (DMAC_SADDR2)  */
/* -------- DMAC_DADDR2 : (DMAC Offset: 0x90) DMAC Channel Destination Address Register (ch_num = 2) -------- */
#define DMAC_DADDR2_DADDRx (0xffffffff << 0) /**< \brief (DMAC_DADDR2)  */
/* -------- DMAC_DSCR2 : (DMAC Offset: 0x94) DMAC Channel Descriptor Address Register (ch_num = 2) -------- */
#define DMAC_DSCR2_DSCRx (0x3fffffff << 2) /**< \brief (DMAC_DSCR2)  */
/* -------- DMAC_CTRLA2 : (DMAC Offset: 0x98) DMAC Channel Control A Register (ch_num = 2) -------- */
#define DMAC_CTRLA2_BTSIZE (0xfff << 0) /**< \brief (DMAC_CTRLA2)  */
#define DMAC_CTRLA2_SCSIZE (0x1 << 16) /**< \brief (DMAC_CTRLA2)  */
#define DMAC_CTRLA2_DCSIZE (0x1 << 20) /**< \brief (DMAC_CTRLA2)  */
#define DMAC_CTRLA2_SRC_WIDTH (0x3 << 24) /**< \brief (DMAC_CTRLA2)  */
#define DMAC_CTRLA2_DST_WIDTH (0x3 << 28) /**< \brief (DMAC_CTRLA2)  */
#define DMAC_CTRLA2_DONE (0x1 << 31) /**< \brief (DMAC_CTRLA2)  */
/* -------- DMAC_CTRLB2 : (DMAC Offset: 0x9C) DMAC Channel Control B Register (ch_num = 2) -------- */
#define DMAC_CTRLB2_SRC_DSCR (0x1 << 16) /**< \brief (DMAC_CTRLB2)  */
#define DMAC_CTRLB2_DST_DSCR (0x1 << 20) /**< \brief (DMAC_CTRLB2)  */
#define DMAC_CTRLB2_FC (0x3 << 21) /**< \brief (DMAC_CTRLB2)  */
#define DMAC_CTRLB2_SRC_INCR (0x3 << 24) /**< \brief (DMAC_CTRLB2)  */
#define DMAC_CTRLB2_DST_INCR (0x3 << 28) /**< \brief (DMAC_CTRLB2)  */
#define DMAC_CTRLB2_IEN (0x1 << 30) /**< \brief (DMAC_CTRLB2)  */
/* -------- DMAC_CFG2 : (DMAC Offset: 0xA0) DMAC Channel Configuration Register (ch_num = 2) -------- */
#define DMAC_CFG2_SRC_PER (0xf << 0) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_DST_PER (0xf << 4) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_SRC_H2SEL (0x1 << 9) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_DST_H2SEL (0x1 << 13) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_SOD (0x1 << 16) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_LOCK_IF (0x1 << 20) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_LOCK_B (0x1 << 21) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_LOCK_IF_L (0x1 << 22) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_AHB_PROT (0x7 << 24) /**< \brief (DMAC_CFG2)  */
#define DMAC_CFG2_FIFOCFG (0x3 << 28) /**< \brief (DMAC_CFG2)  */
/* -------- DMAC_SADDR3 : (DMAC Offset: 0xB4) DMAC Channel Source Address Register (ch_num = 3) -------- */
#define DMAC_SADDR3_SADDRx (0xffffffff << 0) /**< \brief (DMAC_SADDR3)  */
/* -------- DMAC_DADDR3 : (DMAC Offset: 0xB8) DMAC Channel Destination Address Register (ch_num = 3) -------- */
#define DMAC_DADDR3_DADDRx (0xffffffff << 0) /**< \brief (DMAC_DADDR3)  */
/* -------- DMAC_DSCR3 : (DMAC Offset: 0xBC) DMAC Channel Descriptor Address Register (ch_num = 3) -------- */
#define DMAC_DSCR3_DSCRx (0x3fffffff << 2) /**< \brief (DMAC_DSCR3)  */
/* -------- DMAC_CTRLA3 : (DMAC Offset: 0xC0) DMAC Channel Control A Register (ch_num = 3) -------- */
#define DMAC_CTRLA3_BTSIZE (0xfff << 0) /**< \brief (DMAC_CTRLA3)  */
#define DMAC_CTRLA3_SCSIZE (0x1 << 16) /**< \brief (DMAC_CTRLA3)  */
#define DMAC_CTRLA3_DCSIZE (0x1 << 20) /**< \brief (DMAC_CTRLA3)  */
#define DMAC_CTRLA3_SRC_WIDTH (0x3 << 24) /**< \brief (DMAC_CTRLA3)  */
#define DMAC_CTRLA3_DST_WIDTH (0x3 << 28) /**< \brief (DMAC_CTRLA3)  */
#define DMAC_CTRLA3_DONE (0x1 << 31) /**< \brief (DMAC_CTRLA3)  */
/* -------- DMAC_CTRLB3 : (DMAC Offset: 0xC4) DMAC Channel Control B Register (ch_num = 3) -------- */
#define DMAC_CTRLB3_SRC_DSCR (0x1 << 16) /**< \brief (DMAC_CTRLB3)  */
#define DMAC_CTRLB3_DST_DSCR (0x1 << 20) /**< \brief (DMAC_CTRLB3)  */
#define DMAC_CTRLB3_FC (0x3 << 21) /**< \brief (DMAC_CTRLB3)  */
#define DMAC_CTRLB3_SRC_INCR (0x3 << 24) /**< \brief (DMAC_CTRLB3)  */
#define DMAC_CTRLB3_DST_INCR (0x3 << 28) /**< \brief (DMAC_CTRLB3)  */
#define DMAC_CTRLB3_IEN (0x1 << 30) /**< \brief (DMAC_CTRLB3)  */
/* -------- DMAC_CFG3 : (DMAC Offset: 0xC8) DMAC Channel Configuration Register (ch_num = 3) -------- */
#define DMAC_CFG3_SRC_PER (0xf << 0) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_DST_PER (0xf << 4) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_SRC_H2SEL (0x1 << 9) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_DST_H2SEL (0x1 << 13) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_SOD (0x1 << 16) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_LOCK_IF (0x1 << 20) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_LOCK_B (0x1 << 21) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_LOCK_IF_L (0x1 << 22) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_AHB_PROT (0x7 << 24) /**< \brief (DMAC_CFG3)  */
#define DMAC_CFG3_FIFOCFG (0x3 << 28) /**< \brief (DMAC_CFG3)  */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Embedded Flash Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_EFC Embedded Flash Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Efc hardware registers */
typedef struct {
  RwReg EEFC_FMR; /**< \brief (Efc Offset: 0x00) EEFC Flash Mode Register */
  WoReg EEFC_FCR; /**< \brief (Efc Offset: 0x04) EEFC Flash Command Register */
  RoReg EEFC_FSR; /**< \brief (Efc Offset: 0x08) EEFC Flash Status Register */
  RoReg EEFC_FRR; /**< \brief (Efc Offset: 0x0C) EEFC Flash Result Register */
} Efc;
#endif /* __ASSEMBLY__ */
/* -------- EEFC_FMR : (EFC Offset: 0x00) EEFC Flash Mode Register -------- */
#define EEFC_FMR_FRDY (0x1 << 0) /**< \brief (EEFC_FMR) Ready Interrupt Enable */
#define EEFC_FMR_FWS (0xf << 8) /**< \brief (EEFC_FMR) Flash Wait State */
#define EEFC_FMR_FAM (0x1 << 24) /**< \brief (EEFC_FMR) Flash Access Mode */
/* -------- EEFC_FCR : (EFC Offset: 0x04) EEFC Flash Command Register -------- */
#define EEFC_FCR_FCMD (0xff << 0) /**< \brief (EEFC_FCR) Flash Command */
#define EEFC_FCR_FARG (0xffff << 8) /**< \brief (EEFC_FCR) Flash Command Argument */
#define EEFC_FCR_FKEY (0xff << 24) /**< \brief (EEFC_FCR) Flash Writing Protection Key */
/* -------- EEFC_FSR : (EFC Offset: 0x08) EEFC Flash Status Register -------- */
#define EEFC_FSR_FRDY (0x1 << 0) /**< \brief (EEFC_FSR) Flash Ready Status */
#define EEFC_FSR_FCMDE (0x1 << 1) /**< \brief (EEFC_FSR) Flash Command Error Status */
#define EEFC_FSR_FLOCKE (0x1 << 2) /**< \brief (EEFC_FSR) Flash Lock Error Status */
/* -------- EEFC_FRR : (EFC Offset: 0x0C) EEFC Flash Result Register -------- */
#define EEFC_FRR_FVALUE (0xffffffff << 0) /**< \brief (EEFC_FRR) Flash Result Value */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR General Purpose Backup Register */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_GPBR General Purpose Backup Register */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Gpbr hardware registers */
typedef struct {
  RwReg SYS_GPBR0; /**< \brief (Gpbr Offset: 0x0) General Purpose Backup Register 0 */
  RwReg SYS_GPBR1; /**< \brief (Gpbr Offset: 0x4) General Purpose Backup Register 1 */
  RwReg SYS_GPBR2; /**< \brief (Gpbr Offset: 0x8) General Purpose Backup Register 2 */
  RwReg SYS_GPBR3; /**< \brief (Gpbr Offset: 0xC) General Purpose Backup Register 3 */
} Gpbr;
#endif /* __ASSEMBLY__ */
/* -------- SYS_GPBR0 : (GPBR Offset: 0x0) General Purpose Backup Register 0 -------- */
#define SYS_GPBR0_GPBR_VALUE0 (0xffffffff << 0) /**< \brief (SYS_GPBR0) Value of GPBR x */
/* -------- SYS_GPBR1 : (GPBR Offset: 0x4) General Purpose Backup Register 1 -------- */
#define SYS_GPBR1_GPBR_VALUE1 (0xffffffff << 0) /**< \brief (SYS_GPBR1) Value of GPBR x */
/* -------- SYS_GPBR2 : (GPBR Offset: 0x8) General Purpose Backup Register 2 -------- */
#define SYS_GPBR2_GPBR_VALUE2 (0xffffffff << 0) /**< \brief (SYS_GPBR2) Value of GPBR x */
/* -------- SYS_GPBR3 : (GPBR Offset: 0xC) General Purpose Backup Register 3 -------- */
#define SYS_GPBR3_GPBR_VALUE3 (0xffffffff << 0) /**< \brief (SYS_GPBR3) Value of GPBR x */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR MultiMedia Card Interface */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_HSMCI MultiMedia Card Interface */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Hsmci hardware registers */
typedef struct {
  WoReg HSMCI_CR;      /**< \brief (Hsmci Offset: 0x00) Control Register */
  RwReg HSMCI_MR;      /**< \brief (Hsmci Offset: 0x04) Mode Register */
  RwReg HSMCI_DTOR;    /**< \brief (Hsmci Offset: 0x08) Data Timeout Register */
  RwReg HSMCI_SDCR;    /**< \brief (Hsmci Offset: 0x0C) SD/SDIO Card Register */
  RwReg HSMCI_ARGR;    /**< \brief (Hsmci Offset: 0x10) Argument Register */
  WoReg HSMCI_CMDR;    /**< \brief (Hsmci Offset: 0x14) Command Register */
  RwReg HSMCI_BLKR;    /**< \brief (Hsmci Offset: 0x18) Block Register */
  RwReg HSMCI_CSTOR;   /**< \brief (Hsmci Offset: 0x1C) Completion Signal Timeout Register */
  RoReg HSMCI_RSPR[4]; /**< \brief (Hsmci Offset: 0x20) Response Register */
  RoReg HSMCI_RDR;     /**< \brief (Hsmci Offset: 0x30) Receive Data Register */
  WoReg HSMCI_TDR;     /**< \brief (Hsmci Offset: 0x34) Transmit Data Register */
  RwReg Reserved1[2]; 
  RoReg HSMCI_SR;      /**< \brief (Hsmci Offset: 0x40) Status Register */
  WoReg HSMCI_IER;     /**< \brief (Hsmci Offset: 0x44) Interrupt Enable Register */
  WoReg HSMCI_IDR;     /**< \brief (Hsmci Offset: 0x48) Interrupt Disable Register */
  RoReg HSMCI_IMR;     /**< \brief (Hsmci Offset: 0x4C) Interrupt Mask Register */
  RwReg HSMCI_DMA;     /**< \brief (Hsmci Offset: 0x50) DMA Configuration Register */
  RwReg HSMCI_CFG;     /**< \brief (Hsmci Offset: 0x54) Configuration Register */
  RwReg Reserved2[35];
  RwReg HSMCI_WPMR;    /**< \brief (Hsmci Offset: 0xE4) Write Protection Mode Register */
  RoReg HSMCI_WPSR;    /**< \brief (Hsmci Offset: 0xE8) Write Protection Status Register */
} Hsmci;
#endif /* __ASSEMBLY__ */
/* -------- HSMCI_CR : (HSMCI Offset: 0x00) Control Register -------- */
#define HSMCI_CR_MCIEN (0x1 << 0) /**< \brief (HSMCI_CR) Multi-Media Interface Enable */
#define HSMCI_CR_HSMCIDIS (0x1 << 1) /**< \brief (HSMCI_CR)  */
#define HSMCI_CR_PWSEN (0x1 << 2) /**< \brief (HSMCI_CR) Power Save Mode Enable */
#define HSMCI_CR_PWSDIS (0x1 << 3) /**< \brief (HSMCI_CR) Power Save Mode Disable */
#define HSMCI_CR_SWRST (0x1 << 7) /**< \brief (HSMCI_CR) Software Reset */
/* -------- HSMCI_MR : (HSMCI Offset: 0x04) Mode Register -------- */
#define HSMCI_MR_CLKDIV (0xff << 0) /**< \brief (HSMCI_MR) Clock Divider */
#define HSMCI_MR_PWSDIV (0x7 << 8) /**< \brief (HSMCI_MR) Power Saving Divider */
#define HSMCI_MR_RDPROOF (0x1 << 11) /**< \brief (HSMCI_MR)  */
#define HSMCI_MR_WRPROOF (0x1 << 12) /**< \brief (HSMCI_MR)  */
#define HSMCI_MR_FBYTE (0x1 << 13) /**< \brief (HSMCI_MR) Force Byte Transfer */
#define HSMCI_MR_PADV (0x1 << 14) /**< \brief (HSMCI_MR) Padding Value */
#define HSMCI_MR_BLKLEN (0xffff << 16) /**< \brief (HSMCI_MR) Data Block Length */
/* -------- HSMCI_DTOR : (HSMCI Offset: 0x08) Data Timeout Register -------- */
#define HSMCI_DTOR_DTOCYC (0xf << 0) /**< \brief (HSMCI_DTOR) Data Timeout Cycle Number */
#define HSMCI_DTOR_DTOMUL (0x7 << 4) /**< \brief (HSMCI_DTOR) Data Timeout Multiplier */
/* -------- HSMCI_SDCR : (HSMCI Offset: 0x0C) SD/SDIO Card Register -------- */
#define HSMCI_SDCR_SDCSEL (0x3 << 0) /**< \brief (HSMCI_SDCR) SDCard/SDIO Slot */
#define HSMCI_SDCR_SDCBUS (0x3 << 6) /**< \brief (HSMCI_SDCR) SDCard/SDIO Bus Width */
/* -------- HSMCI_ARGR : (HSMCI Offset: 0x10) Argument Register -------- */
#define HSMCI_ARGR_ARG (0xffffffff << 0) /**< \brief (HSMCI_ARGR) Command Argument */
/* -------- HSMCI_CMDR : (HSMCI Offset: 0x14) Command Register -------- */
#define HSMCI_CMDR_CMDNB (0x3f << 0) /**< \brief (HSMCI_CMDR) Command Number */
#define HSMCI_CMDR_RSPTYP (0x3 << 6) /**< \brief (HSMCI_CMDR) Response Type */
#define HSMCI_CMDR_SPCMD (0x7 << 8) /**< \brief (HSMCI_CMDR) Special Command */
#define HSMCI_CMDR_OPDCMD (0x1 << 11) /**< \brief (HSMCI_CMDR) Open Drain Command */
#define HSMCI_CMDR_MAXLAT (0x1 << 12) /**< \brief (HSMCI_CMDR) Max Latency for Command to Response */
#define HSMCI_CMDR_TRCMD (0x3 << 16) /**< \brief (HSMCI_CMDR) Transfer Command */
#define HSMCI_CMDR_TRDIR (0x1 << 18) /**< \brief (HSMCI_CMDR) Transfer Direction */
#define HSMCI_CMDR_TRTYP (0x7 << 19) /**< \brief (HSMCI_CMDR) Transfer Type */
#define HSMCI_CMDR_IOSPCMD (0x3 << 24) /**< \brief (HSMCI_CMDR) SDIO Special Command */
#define HSMCI_CMDR_ATACS (0x1 << 26) /**< \brief (HSMCI_CMDR) ATA with Command Completion Signal */
#define HSMCI_CMDR_BOOT_ACK (0x1 << 27) /**< \brief (HSMCI_CMDR) Boot Operation Acknowledge. */
/* -------- HSMCI_BLKR : (HSMCI Offset: 0x18) Block Register -------- */
#define HSMCI_BLKR_BCNT (0xffff << 0) /**< \brief (HSMCI_BLKR) MMC/SDIO Block Count - SDIO Byte Count */
#define HSMCI_BLKR_BLKLEN (0xffff << 16) /**< \brief (HSMCI_BLKR) Data Block Length */
/* -------- HSMCI_CSTOR : (HSMCI Offset: 0x1C) Completion Signal Timeout Register -------- */
#define HSMCI_CSTOR_CSTOCYC (0xf << 0) /**< \brief (HSMCI_CSTOR) Completion Signal Timeout Cycle Number */
#define HSMCI_CSTOR_CSTOMUL (0x7 << 4) /**< \brief (HSMCI_CSTOR) Completion Signal Timeout Multiplier */
/* -------- HSMCI_RSPR[4] : (HSMCI Offset: 0x20) Response Register -------- */
#define HSMCI_RSPR_RSP (0xffffffff << 0) /**< \brief (HSMCI_RSPR[4]) Response */
/* -------- HSMCI_RDR : (HSMCI Offset: 0x30) Receive Data Register -------- */
#define HSMCI_RDR_DATA (0xffffffff << 0) /**< \brief (HSMCI_RDR) Data to Read */
/* -------- HSMCI_TDR : (HSMCI Offset: 0x34) Transmit Data Register -------- */
#define HSMCI_TDR_DATA (0xffffffff << 0) /**< \brief (HSMCI_TDR) Data to Write */
/* -------- HSMCI_SR : (HSMCI Offset: 0x40) Status Register -------- */
#define HSMCI_SR_CMDRDY (0x1 << 0) /**< \brief (HSMCI_SR) Command Ready */
#define HSMCI_SR_RXRDY (0x1 << 1) /**< \brief (HSMCI_SR) Receiver Ready */
#define HSMCI_SR_TXRDY (0x1 << 2) /**< \brief (HSMCI_SR) Transmit Ready */
#define HSMCI_SR_BLKE (0x1 << 3) /**< \brief (HSMCI_SR) Data Block Ended */
#define HSMCI_SR_DTIP (0x1 << 4) /**< \brief (HSMCI_SR) Data Transfer in Progress */
#define HSMCI_SR_NOTBUSY (0x1 << 5) /**< \brief (HSMCI_SR) HSMCI Not Busy */
#define HSMCI_SR_MCI_SDIOIRQA (0x1 << 8) /**< \brief (HSMCI_SR)  */
#define HSMCI_SR_SDIOWAIT (0x1 << 12) /**< \brief (HSMCI_SR) SDIO Read Wait Operation Status */
#define HSMCI_SR_CSRCV (0x1 << 13) /**< \brief (HSMCI_SR) CE-ATA Completion Signal Received */
#define HSMCI_SR_RINDE (0x1 << 16) /**< \brief (HSMCI_SR) Response Index Error */
#define HSMCI_SR_RDIRE (0x1 << 17) /**< \brief (HSMCI_SR) Response Direction Error */
#define HSMCI_SR_RCRCE (0x1 << 18) /**< \brief (HSMCI_SR) Response CRC Error */
#define HSMCI_SR_RENDE (0x1 << 19) /**< \brief (HSMCI_SR) Response End Bit Error */
#define HSMCI_SR_RTOE (0x1 << 20) /**< \brief (HSMCI_SR) Response Time-out Error */
#define HSMCI_SR_DCRCE (0x1 << 21) /**< \brief (HSMCI_SR) Data CRC Error */
#define HSMCI_SR_DTOE (0x1 << 22) /**< \brief (HSMCI_SR) Data Time-out Error */
#define HSMCI_SR_CSTOE (0x1 << 23) /**< \brief (HSMCI_SR) Completion Signal Time-out Error */
#define HSMCI_SR_BLKOVRE (0x1 << 24) /**< \brief (HSMCI_SR) DMA Block Overrun Error */
#define HSMCI_SR_DMADONE (0x1 << 25) /**< \brief (HSMCI_SR) DMA Transfer done */
#define HSMCI_SR_FIFOEMPTY (0x1 << 26) /**< \brief (HSMCI_SR) FIFO empty flag */
#define HSMCI_SR_XFRDONE (0x1 << 27) /**< \brief (HSMCI_SR) Transfer Done flag */
#define HSMCI_SR_ACKRCV (0x1 << 28) /**< \brief (HSMCI_SR) Boot Operation Acknowledge Received */
#define HSMCI_SR_ACKRCVE (0x1 << 29) /**< \brief (HSMCI_SR) Boot Operation Acknowledge Error */
#define HSMCI_SR_OVRE (0x1 << 30) /**< \brief (HSMCI_SR) Overrun */
#define HSMCI_SR_UNRE (0x1 << 31) /**< \brief (HSMCI_SR) Underrun */
/* -------- HSMCI_IER : (HSMCI Offset: 0x44) Interrupt Enable Register -------- */
#define HSMCI_IER_CMDRDY (0x1 << 0) /**< \brief (HSMCI_IER) Command Ready Interrupt Enable */
#define HSMCI_IER_RXRDY (0x1 << 1) /**< \brief (HSMCI_IER) Receiver Ready Interrupt Enable */
#define HSMCI_IER_TXRDY (0x1 << 2) /**< \brief (HSMCI_IER) Transmit Ready Interrupt Enable */
#define HSMCI_IER_BLKE (0x1 << 3) /**< \brief (HSMCI_IER) Data Block Ended Interrupt Enable */
#define HSMCI_IER_DTIP (0x1 << 4) /**< \brief (HSMCI_IER) Data Transfer in Progress Interrupt Enable */
#define HSMCI_IER_NOTBUSY (0x1 << 5) /**< \brief (HSMCI_IER) Data Not Busy Interrupt Enable */
#define HSMCI_IER_MCI_SDIOIRQA (0x1 << 8) /**< \brief (HSMCI_IER)  */
#define HSMCI_IER_SDIOWAIT (0x1 << 12) /**< \brief (HSMCI_IER) SDIO Read Wait Operation Status Interrupt Enable */
#define HSMCI_IER_CSRCV (0x1 << 13) /**< \brief (HSMCI_IER) Completion Signal Received Interrupt Enable */
#define HSMCI_IER_RINDE (0x1 << 16) /**< \brief (HSMCI_IER) Response Index Error Interrupt Enable */
#define HSMCI_IER_RDIRE (0x1 << 17) /**< \brief (HSMCI_IER) Response Direction Error Interrupt Enable */
#define HSMCI_IER_RCRCE (0x1 << 18) /**< \brief (HSMCI_IER) Response CRC Error Interrupt Enable */
#define HSMCI_IER_RENDE (0x1 << 19) /**< \brief (HSMCI_IER) Response End Bit Error Interrupt Enable */
#define HSMCI_IER_RTOE (0x1 << 20) /**< \brief (HSMCI_IER) Response Time-out Error Interrupt Enable */
#define HSMCI_IER_DCRCE (0x1 << 21) /**< \brief (HSMCI_IER) Data CRC Error Interrupt Enable */
#define HSMCI_IER_DTOE (0x1 << 22) /**< \brief (HSMCI_IER) Data Time-out Error Interrupt Enable */
#define HSMCI_IER_CSTOE (0x1 << 23) /**< \brief (HSMCI_IER) Completion Signal Timeout Error Interrupt Enable */
#define HSMCI_IER_BLKOVRE (0x1 << 24) /**< \brief (HSMCI_IER) DMA Block Overrun Error Interrupt Enable */
#define HSMCI_IER_DMADONE (0x1 << 25) /**< \brief (HSMCI_IER) DMA Transfer completed Interrupt Enable */
#define HSMCI_IER_FIFOEMPTY (0x1 << 26) /**< \brief (HSMCI_IER) FIFO empty Interrupt enable */
#define HSMCI_IER_XFRDONE (0x1 << 27) /**< \brief (HSMCI_IER) Transfer Done Interrupt enable */
#define HSMCI_IER_ACKRCV (0x1 << 28) /**< \brief (HSMCI_IER) Boot Acknowledge Interrupt Enable */
#define HSMCI_IER_ACKRCVE (0x1 << 29) /**< \brief (HSMCI_IER) Boot Acknowledge Error Interrupt Enable */
#define HSMCI_IER_OVRE (0x1 << 30) /**< \brief (HSMCI_IER) Overrun Interrupt Enable */
#define HSMCI_IER_UNRE (0x1 << 31) /**< \brief (HSMCI_IER) Underrun Interrupt Enable */
/* -------- HSMCI_IDR : (HSMCI Offset: 0x48) Interrupt Disable Register -------- */
#define HSMCI_IDR_CMDRDY (0x1 << 0) /**< \brief (HSMCI_IDR) Command Ready Interrupt Disable */
#define HSMCI_IDR_RXRDY (0x1 << 1) /**< \brief (HSMCI_IDR) Receiver Ready Interrupt Disable */
#define HSMCI_IDR_TXRDY (0x1 << 2) /**< \brief (HSMCI_IDR) Transmit Ready Interrupt Disable */
#define HSMCI_IDR_BLKE (0x1 << 3) /**< \brief (HSMCI_IDR) Data Block Ended Interrupt Disable */
#define HSMCI_IDR_DTIP (0x1 << 4) /**< \brief (HSMCI_IDR) Data Transfer in Progress Interrupt Disable */
#define HSMCI_IDR_NOTBUSY (0x1 << 5) /**< \brief (HSMCI_IDR) Data Not Busy Interrupt Disable */
#define HSMCI_IDR_MCI_SDIOIRQA (0x1 << 8) /**< \brief (HSMCI_IDR)  */
#define HSMCI_IDR_SDIOWAIT (0x1 << 12) /**< \brief (HSMCI_IDR) SDIO Read Wait Operation Status Interrupt Disable */
#define HSMCI_IDR_CSRCV (0x1 << 13) /**< \brief (HSMCI_IDR) Completion Signal received interrupt disable */
#define HSMCI_IDR_RINDE (0x1 << 16) /**< \brief (HSMCI_IDR) Response Index Error Interrupt Disable */
#define HSMCI_IDR_RDIRE (0x1 << 17) /**< \brief (HSMCI_IDR) Response Direction Error Interrupt Disable */
#define HSMCI_IDR_RCRCE (0x1 << 18) /**< \brief (HSMCI_IDR) Response CRC Error Interrupt Disable */
#define HSMCI_IDR_RENDE (0x1 << 19) /**< \brief (HSMCI_IDR) Response End Bit Error Interrupt Disable */
#define HSMCI_IDR_RTOE (0x1 << 20) /**< \brief (HSMCI_IDR) Response Time-out Error Interrupt Disable */
#define HSMCI_IDR_DCRCE (0x1 << 21) /**< \brief (HSMCI_IDR) Data CRC Error Interrupt Disable */
#define HSMCI_IDR_DTOE (0x1 << 22) /**< \brief (HSMCI_IDR) Data Time-out Error Interrupt Disable */
#define HSMCI_IDR_CSTOE (0x1 << 23) /**< \brief (HSMCI_IDR) Completion Signal Time out Error Interrupt Disable */
#define HSMCI_IDR_BLKOVRE (0x1 << 24) /**< \brief (HSMCI_IDR) DMA Block Overrun Error Interrupt Disable */
#define HSMCI_IDR_DMADONE (0x1 << 25) /**< \brief (HSMCI_IDR) DMA Transfer completed Interrupt Disable */
#define HSMCI_IDR_FIFOEMPTY (0x1 << 26) /**< \brief (HSMCI_IDR) FIFO empty Interrupt Disable */
#define HSMCI_IDR_XFRDONE (0x1 << 27) /**< \brief (HSMCI_IDR) Transfer Done Interrupt Disable */
#define HSMCI_IDR_ACKRCV (0x1 << 28) /**< \brief (HSMCI_IDR) Boot Acknowledge Interrupt Disable */
#define HSMCI_IDR_ACKRCVE (0x1 << 29) /**< \brief (HSMCI_IDR) Boot Acknowledge Error Interrupt Disable */
#define HSMCI_IDR_OVRE (0x1 << 30) /**< \brief (HSMCI_IDR) Overrun Interrupt Disable */
#define HSMCI_IDR_UNRE (0x1 << 31) /**< \brief (HSMCI_IDR) Underrun Interrupt Disable */
/* -------- HSMCI_IMR : (HSMCI Offset: 0x4C) Interrupt Mask Register -------- */
#define HSMCI_IMR_CMDRDY (0x1 << 0) /**< \brief (HSMCI_IMR) Command Ready Interrupt Mask */
#define HSMCI_IMR_RXRDY (0x1 << 1) /**< \brief (HSMCI_IMR) Receiver Ready Interrupt Mask */
#define HSMCI_IMR_TXRDY (0x1 << 2) /**< \brief (HSMCI_IMR) Transmit Ready Interrupt Mask */
#define HSMCI_IMR_BLKE (0x1 << 3) /**< \brief (HSMCI_IMR) Data Block Ended Interrupt Mask */
#define HSMCI_IMR_DTIP (0x1 << 4) /**< \brief (HSMCI_IMR) Data Transfer in Progress Interrupt Mask */
#define HSMCI_IMR_NOTBUSY (0x1 << 5) /**< \brief (HSMCI_IMR) Data Not Busy Interrupt Mask */
#define HSMCI_IMR_MCI_SDIOIRQA (0x1 << 8) /**< \brief (HSMCI_IMR)  */
#define HSMCI_IMR_SDIOWAIT (0x1 << 12) /**< \brief (HSMCI_IMR) SDIO Read Wait Operation Status Interrupt Mask */
#define HSMCI_IMR_CSRCV (0x1 << 13) /**< \brief (HSMCI_IMR) Completion Signal Received Interrupt Mask */
#define HSMCI_IMR_RINDE (0x1 << 16) /**< \brief (HSMCI_IMR) Response Index Error Interrupt Mask */
#define HSMCI_IMR_RDIRE (0x1 << 17) /**< \brief (HSMCI_IMR) Response Direction Error Interrupt Mask */
#define HSMCI_IMR_RCRCE (0x1 << 18) /**< \brief (HSMCI_IMR) Response CRC Error Interrupt Mask */
#define HSMCI_IMR_RENDE (0x1 << 19) /**< \brief (HSMCI_IMR) Response End Bit Error Interrupt Mask */
#define HSMCI_IMR_RTOE (0x1 << 20) /**< \brief (HSMCI_IMR) Response Time-out Error Interrupt Mask */
#define HSMCI_IMR_DCRCE (0x1 << 21) /**< \brief (HSMCI_IMR) Data CRC Error Interrupt Mask */
#define HSMCI_IMR_DTOE (0x1 << 22) /**< \brief (HSMCI_IMR) Data Time-out Error Interrupt Mask */
#define HSMCI_IMR_CSTOE (0x1 << 23) /**< \brief (HSMCI_IMR) Completion Signal Time-out Error Interrupt Mask */
#define HSMCI_IMR_BLKOVRE (0x1 << 24) /**< \brief (HSMCI_IMR) DMA Block Overrun Error Interrupt Mask */
#define HSMCI_IMR_DMADONE (0x1 << 25) /**< \brief (HSMCI_IMR) DMA Transfer Completed Interrupt Mask */
#define HSMCI_IMR_FIFOEMPTY (0x1 << 26) /**< \brief (HSMCI_IMR) FIFO Empty Interrupt Mask */
#define HSMCI_IMR_XFRDONE (0x1 << 27) /**< \brief (HSMCI_IMR) Transfer Done Interrupt Mask */
#define HSMCI_IMR_ACKRCV (0x1 << 28) /**< \brief (HSMCI_IMR) Boot Operation Acknowledge Received Interrupt Mask */
#define HSMCI_IMR_ACKRCVE (0x1 << 29) /**< \brief (HSMCI_IMR) Boot Operation Acknowledge Error Interrupt Mask */
#define HSMCI_IMR_OVRE (0x1 << 30) /**< \brief (HSMCI_IMR) Overrun Interrupt Mask */
#define HSMCI_IMR_UNRE (0x1 << 31) /**< \brief (HSMCI_IMR) Underrun Interrupt Mask */
/* -------- HSMCI_DMA : (HSMCI Offset: 0x50) DMA Configuration Register -------- */
#define HSMCI_DMA_OFFSET (0x3 << 0) /**< \brief (HSMCI_DMA) DMA Write Buffer Offset */
#define HSMCI_DMA_CHKSIZE (0x1 << 4) /**< \brief (HSMCI_DMA) DMA Channel Read and Write Chunk Size */
#define HSMCI_DMA_DMAEN (0x1 << 8) /**< \brief (HSMCI_DMA) DMA Hardware Handshaking Enable */
#define HSMCI_DMA_ROPT (0x1 << 12) /**< \brief (HSMCI_DMA) Read Optimization with padding */
/* -------- HSMCI_CFG : (HSMCI Offset: 0x54) Configuration Register -------- */
#define HSMCI_CFG_FIFOMODE (0x1 << 0) /**< \brief (HSMCI_CFG) HSMCI Internal FIFO control mode */
#define HSMCI_CFG_FERRCTRL (0x1 << 4) /**< \brief (HSMCI_CFG) Flow Error flag reset control mode */
#define HSMCI_CFG_HSMODE (0x1 << 8) /**< \brief (HSMCI_CFG) High Speed Mode */
#define HSMCI_CFG_LSYNC (0x1 << 12) /**< \brief (HSMCI_CFG) Synchronize on the last block */
/* -------- HSMCI_WPMR : (HSMCI Offset: 0xE4) Write Protection Mode Register -------- */
#define HSMCI_WPMR_WP_EN (0x1 << 0) /**< \brief (HSMCI_WPMR) Write Protection Enable */
#define HSMCI_WPMR_WP_KEY (0xffffff << 8) /**< \brief (HSMCI_WPMR) Write Protection Key password */
/* -------- HSMCI_WPSR : (HSMCI Offset: 0xE8) Write Protection Status Register -------- */
#define HSMCI_WPSR_WP_VS (0xf << 0) /**< \brief (HSMCI_WPSR)  */
#define HSMCI_WPSR_WP_VSRC (0xffff << 8) /**< \brief (HSMCI_WPSR) Write Protection Violation Status */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AHB Bus Matrix */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_MATRIX AHB Bus Matrix */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Matrix hardware registers */
typedef struct {
  RwReg MATRIX_MCFG[5];  /**< \brief (Matrix Offset: 0x0000) Master Configuration Register */
  RwReg Reserved1[11];  
  RwReg MATRIX_SCFG[10]; /**< \brief (Matrix Offset: 0x0040) Slave Configuration Register */
  RwReg Reserved2[6];   
  RwReg MATRIX_PRAS0;    /**< \brief (Matrix Offset: 0x0080) Priority Register A for Slave 0 */
  RwReg Reserved3[1];   
  RwReg MATRIX_PRAS1;    /**< \brief (Matrix Offset: 0x0088) Priority Register A for Slave 1 */
  RwReg Reserved4[1];   
  RwReg MATRIX_PRAS2;    /**< \brief (Matrix Offset: 0x0090) Priority Register A for Slave 2 */
  RwReg Reserved5[1];   
  RwReg MATRIX_PRAS3;    /**< \brief (Matrix Offset: 0x0098) Priority Register A for Slave 3 */
  RwReg Reserved6[1];   
  RwReg MATRIX_PRAS4;    /**< \brief (Matrix Offset: 0x00A0) Priority Register A for Slave 4 */
  RwReg Reserved7[1];   
  RwReg MATRIX_PRAS5;    /**< \brief (Matrix Offset: 0x00A8) Priority Register A for Slave 5 */
  RwReg Reserved8[1];   
  RwReg MATRIX_PRAS6;    /**< \brief (Matrix Offset: 0x00B0) Priority Register A for Slave 6 */
  RwReg Reserved9[1];   
  RwReg MATRIX_PRAS7;    /**< \brief (Matrix Offset: 0x00B8) Priority Register A for Slave 7 */
  RwReg Reserved10[1];  
  RwReg MATRIX_PRAS8;    /**< \brief (Matrix Offset: 0x00C0) Priority Register A for Slave 8 */
  RwReg Reserved11[1];  
  RwReg MATRIX_PRAS9;    /**< \brief (Matrix Offset: 0x00C8) Priority Register A for Slave 9 */
  RwReg Reserved12[13]; 
  RwReg MATRIX_MRCR;     /**< \brief (Matrix Offset: 0x0100) Master Remap Control Register */
} Matrix;
#endif /* __ASSEMBLY__ */
/* -------- MATRIX_MCFG[5] : (MATRIX Offset: 0x0000) Master Configuration Register -------- */
#define MATRIX_MCFG_ULBT (0x7 << 0) /**< \brief (MATRIX_MCFG[5]) Undefined Length Burst Type */
/* -------- MATRIX_SCFG[10] : (MATRIX Offset: 0x0040) Slave Configuration Register -------- */
#define MATRIX_SCFG_SLOT_CYCLE (0xff << 0) /**< \brief (MATRIX_SCFG[10]) Maximum Number of Allowed Cycles for a Burst */
#define MATRIX_SCFG_DEFMSTR_TYPE (0x3 << 16) /**< \brief (MATRIX_SCFG[10]) Default Master Type */
#define MATRIX_SCFG_FIXED_DEFMSTR (0x7 << 18) /**< \brief (MATRIX_SCFG[10]) Fixed Default Master */
#define MATRIX_SCFG_ARBT (0x3 << 24) /**< \brief (MATRIX_SCFG[10]) Arbitration Type */
/* -------- MATRIX_PRAS0 : (MATRIX Offset: 0x0080) Priority Register A for Slave 0 -------- */
#define MATRIX_PRAS0_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS0) Master 0 Priority */
#define MATRIX_PRAS0_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS0) Master 1 Priority */
#define MATRIX_PRAS0_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS0) Master 2 Priority */
#define MATRIX_PRAS0_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS0) Master 3 Priority */
#define MATRIX_PRAS0_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS0) Master 4 Priority */
/* -------- MATRIX_PRAS1 : (MATRIX Offset: 0x0088) Priority Register A for Slave 1 -------- */
#define MATRIX_PRAS1_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS1) Master 0 Priority */
#define MATRIX_PRAS1_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS1) Master 1 Priority */
#define MATRIX_PRAS1_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS1) Master 2 Priority */
#define MATRIX_PRAS1_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS1) Master 3 Priority */
#define MATRIX_PRAS1_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS1) Master 4 Priority */
/* -------- MATRIX_PRAS2 : (MATRIX Offset: 0x0090) Priority Register A for Slave 2 -------- */
#define MATRIX_PRAS2_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS2) Master 0 Priority */
#define MATRIX_PRAS2_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS2) Master 1 Priority */
#define MATRIX_PRAS2_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS2) Master 2 Priority */
#define MATRIX_PRAS2_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS2) Master 3 Priority */
#define MATRIX_PRAS2_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS2) Master 4 Priority */
/* -------- MATRIX_PRAS3 : (MATRIX Offset: 0x0098) Priority Register A for Slave 3 -------- */
#define MATRIX_PRAS3_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS3) Master 0 Priority */
#define MATRIX_PRAS3_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS3) Master 1 Priority */
#define MATRIX_PRAS3_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS3) Master 2 Priority */
#define MATRIX_PRAS3_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS3) Master 3 Priority */
#define MATRIX_PRAS3_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS3) Master 4 Priority */
/* -------- MATRIX_PRAS4 : (MATRIX Offset: 0x00A0) Priority Register A for Slave 4 -------- */
#define MATRIX_PRAS4_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS4) Master 0 Priority */
#define MATRIX_PRAS4_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS4) Master 1 Priority */
#define MATRIX_PRAS4_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS4) Master 2 Priority */
#define MATRIX_PRAS4_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS4) Master 3 Priority */
#define MATRIX_PRAS4_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS4) Master 4 Priority */
/* -------- MATRIX_PRAS5 : (MATRIX Offset: 0x00A8) Priority Register A for Slave 5 -------- */
#define MATRIX_PRAS5_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS5) Master 0 Priority */
#define MATRIX_PRAS5_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS5) Master 1 Priority */
#define MATRIX_PRAS5_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS5) Master 2 Priority */
#define MATRIX_PRAS5_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS5) Master 3 Priority */
#define MATRIX_PRAS5_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS5) Master 4 Priority */
/* -------- MATRIX_PRAS6 : (MATRIX Offset: 0x00B0) Priority Register A for Slave 6 -------- */
#define MATRIX_PRAS6_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS6) Master 0 Priority */
#define MATRIX_PRAS6_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS6) Master 1 Priority */
#define MATRIX_PRAS6_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS6) Master 2 Priority */
#define MATRIX_PRAS6_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS6) Master 3 Priority */
#define MATRIX_PRAS6_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS6) Master 4 Priority */
/* -------- MATRIX_PRAS7 : (MATRIX Offset: 0x00B8) Priority Register A for Slave 7 -------- */
#define MATRIX_PRAS7_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS7) Master 0 Priority */
#define MATRIX_PRAS7_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS7) Master 1 Priority */
#define MATRIX_PRAS7_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS7) Master 2 Priority */
#define MATRIX_PRAS7_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS7) Master 3 Priority */
#define MATRIX_PRAS7_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS7) Master 4 Priority */
/* -------- MATRIX_PRAS8 : (MATRIX Offset: 0x00C0) Priority Register A for Slave 8 -------- */
#define MATRIX_PRAS8_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS8) Master 0 Priority */
#define MATRIX_PRAS8_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS8) Master 1 Priority */
#define MATRIX_PRAS8_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS8) Master 2 Priority */
#define MATRIX_PRAS8_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS8) Master 3 Priority */
#define MATRIX_PRAS8_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS8) Master 4 Priority */
/* -------- MATRIX_PRAS9 : (MATRIX Offset: 0x00C8) Priority Register A for Slave 9 -------- */
#define MATRIX_PRAS9_M0PR (0x3 << 0) /**< \brief (MATRIX_PRAS9) Master 0 Priority */
#define MATRIX_PRAS9_M1PR (0x3 << 4) /**< \brief (MATRIX_PRAS9) Master 1 Priority */
#define MATRIX_PRAS9_M2PR (0x3 << 8) /**< \brief (MATRIX_PRAS9) Master 2 Priority */
#define MATRIX_PRAS9_M3PR (0x3 << 12) /**< \brief (MATRIX_PRAS9) Master 3 Priority */
#define MATRIX_PRAS9_M4PR (0x3 << 16) /**< \brief (MATRIX_PRAS9) Master 4 Priority */
/* -------- MATRIX_MRCR : (MATRIX Offset: 0x0100) Master Remap Control Register -------- */
#define MATRIX_MRCR_RCB0 (0x1 << 0) /**< \brief (MATRIX_MRCR) Remap Command Bit for AHB Master 0 */
#define MATRIX_MRCR_RCB1 (0x1 << 1) /**< \brief (MATRIX_MRCR) Remap Command Bit for AHB Master 1 */
#define MATRIX_MRCR_RCB2 (0x1 << 2) /**< \brief (MATRIX_MRCR) Remap Command Bit for AHB Master 2 */
#define MATRIX_MRCR_RCB3 (0x1 << 3) /**< \brief (MATRIX_MRCR) Remap Command Bit for AHB Master 3 */
#define MATRIX_MRCR_RCB4 (0x1 << 4) /**< \brief (MATRIX_MRCR) Remap Command Bit for AHB Master 4 */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Peripheral DMA Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_PDC Peripheral DMA Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Pdc hardware registers */
typedef struct {
  RwReg Reserved1[64];
  RwReg PERIPH_RPR;    /**< \brief (Pdc Offset: 0x100) Receive Pointer Register */
  RwReg PERIPH_RCR;    /**< \brief (Pdc Offset: 0x104) Receive Counter Register */
  RwReg PERIPH_TPR;    /**< \brief (Pdc Offset: 0x108) Transmit Pointer Register */
  RwReg PERIPH_TCR;    /**< \brief (Pdc Offset: 0x10C) Transmit Counter Register */
  RwReg PERIPH_RNPR;   /**< \brief (Pdc Offset: 0x110) Receive Next Pointer Register */
  RwReg PERIPH_RNCR;   /**< \brief (Pdc Offset: 0x114) Receive Next Counter Register */
  RwReg PERIPH_TNPR;   /**< \brief (Pdc Offset: 0x118) Transmit Next Pointer Register */
  RwReg PERIPH_TNCR;   /**< \brief (Pdc Offset: 0x11C) Transmit Next Counter Register */
  WoReg PERIPH_PTCR;   /**< \brief (Pdc Offset: 0x120) Transfer Control Register */
  RoReg PERIPH_PTSR;   /**< \brief (Pdc Offset: 0x124) Transfer Status Register */
} Pdc;
#endif /* __ASSEMBLY__ */
/* -------- PERIPH_RPR : (PDC Offset: 0x100) Receive Pointer Register -------- */
#define PERIPH_RPR_RXPTR (0xffffffff << 0) /**< \brief (PERIPH_RPR) Receive Pointer Register */
/* -------- PERIPH_RCR : (PDC Offset: 0x104) Receive Counter Register -------- */
#define PERIPH_RCR_RXCTR (0xffff << 0) /**< \brief (PERIPH_RCR) Receive Counter Register */
/* -------- PERIPH_TPR : (PDC Offset: 0x108) Transmit Pointer Register -------- */
#define PERIPH_TPR_TXPTR (0xffffffff << 0) /**< \brief (PERIPH_TPR) Transmit Counter Register */
/* -------- PERIPH_TCR : (PDC Offset: 0x10C) Transmit Counter Register -------- */
#define PERIPH_TCR_TXCTR (0xffff << 0) /**< \brief (PERIPH_TCR) Transmit Counter Register */
/* -------- PERIPH_RNPR : (PDC Offset: 0x110) Receive Next Pointer Register -------- */
#define PERIPH_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (PERIPH_RNPR) Receive Next Pointer */
/* -------- PERIPH_RNCR : (PDC Offset: 0x114) Receive Next Counter Register -------- */
#define PERIPH_RNCR_RXNCTR (0xffff << 0) /**< \brief (PERIPH_RNCR) Receive Next Counter */
/* -------- PERIPH_TNPR : (PDC Offset: 0x118) Transmit Next Pointer Register -------- */
#define PERIPH_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (PERIPH_TNPR) Transmit Next Pointer */
/* -------- PERIPH_TNCR : (PDC Offset: 0x11C) Transmit Next Counter Register -------- */
#define PERIPH_TNCR_TXNCTR (0xffff << 0) /**< \brief (PERIPH_TNCR) Transmit Counter Next */
/* -------- PERIPH_PTCR : (PDC Offset: 0x120) Transfer Control Register -------- */
#define PERIPH_PTCR_RXTEN (0x1 << 0) /**< \brief (PERIPH_PTCR) Receiver Transfer Enable */
#define PERIPH_PTCR_RXTDIS (0x1 << 1) /**< \brief (PERIPH_PTCR) Receiver Transfer Disable */
#define PERIPH_PTCR_TXTEN (0x1 << 8) /**< \brief (PERIPH_PTCR) Transmitter Transfer Enable */
#define PERIPH_PTCR_TXTDIS (0x1 << 9) /**< \brief (PERIPH_PTCR) Transmitter Transfer Disable */
/* -------- PERIPH_PTSR : (PDC Offset: 0x124) Transfer Status Register -------- */
#define PERIPH_PTSR_RXTEN (0x1 << 0) /**< \brief (PERIPH_PTSR) Receiver Transfer Enable */
#define PERIPH_PTSR_TXTEN (0x1 << 8) /**< \brief (PERIPH_PTSR) Transmitter Transfer Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Parallel Input/Output */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_PIO Parallel Input/Output */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Pio hardware registers */
typedef struct {
  WoReg PIO_PER;       /**< \brief (Pio Offset: 0x0000) PIO Enable Register */
  WoReg PIO_PDR;       /**< \brief (Pio Offset: 0x0004) PIO Disable Register */
  RoReg PIO_PSR;       /**< \brief (Pio Offset: 0x0008) PIO Status Register */
  RwReg Reserved1[1]; 
  WoReg PIO_OER;       /**< \brief (Pio Offset: 0x0010) Output Enable Register */
  WoReg PIO_ODR;       /**< \brief (Pio Offset: 0x0014) Output Disable Register */
  RoReg PIO_OSR;       /**< \brief (Pio Offset: 0x0018) Output Status Register */
  RwReg Reserved2[1]; 
  WoReg PIO_IFER;      /**< \brief (Pio Offset: 0x0020) Glitch Input Filter Enable Register */
  WoReg PIO_IFDR;      /**< \brief (Pio Offset: 0x0024) Glitch Input Filter Disable Register */
  RoReg PIO_IFSR;      /**< \brief (Pio Offset: 0x0028) Glitch Input Filter Status Register */
  RwReg Reserved3[1]; 
  WoReg PIO_SODR;      /**< \brief (Pio Offset: 0x0030) Set Output Data Register */
  WoReg PIO_CODR;      /**< \brief (Pio Offset: 0x0034) Clear Output Data Register */
  RwReg PIO_ODSR;      /**< \brief (Pio Offset: 0x0038) Output Data Status Register */
  RoReg PIO_PDSR;      /**< \brief (Pio Offset: 0x003C) Pin Data Status Register */
  WoReg PIO_IER;       /**< \brief (Pio Offset: 0x0040) Interrupt Enable Register */
  WoReg PIO_IDR;       /**< \brief (Pio Offset: 0x0044) Interrupt Disable Register */
  RoReg PIO_IMR;       /**< \brief (Pio Offset: 0x0048) Interrupt Mask Register */
  RoReg PIO_ISR;       /**< \brief (Pio Offset: 0x004C) Interrupt Status Register */
  WoReg PIO_MDER;      /**< \brief (Pio Offset: 0x0050) Multi-driver Enable Register */
  WoReg PIO_MDDR;      /**< \brief (Pio Offset: 0x0054) Multi-driver Disable Register */
  RoReg PIO_MDSR;      /**< \brief (Pio Offset: 0x0058) Multi-driver Status Register */
  RwReg Reserved4[1]; 
  WoReg PIO_PUDR;      /**< \brief (Pio Offset: 0x0060) Pull-up Disable Register */
  WoReg PIO_PUER;      /**< \brief (Pio Offset: 0x0064) Pull-up Enable Register */
  RoReg PIO_PUSR;      /**< \brief (Pio Offset: 0x0068) Pad Pull-up Status Register */
  RwReg Reserved5[1]; 
  RwReg PIO_ABSR;      /**< \brief (Pio Offset: 0x0070) Peripheral AB Select Register */
  RwReg Reserved6[3]; 
  WoReg PIO_SCIFSR;    /**< \brief (Pio Offset: 0x0080) System Clock Glitch Input Filter Select Register */
  WoReg PIO_DIFSR;     /**< \brief (Pio Offset: 0x0084) Debouncing Input Filter Select Register */
  RoReg PIO_IFDGSR;    /**< \brief (Pio Offset: 0x0088) Glitch or Debouncing Input Filter Clock Selection Status Register */
  RwReg PIO_SCDR;      /**< \brief (Pio Offset: 0x008C) Slow Clock Divider Debouncing Register */
  RwReg Reserved7[4]; 
  WoReg PIO_OWER;      /**< \brief (Pio Offset: 0x00A0) Output Write Enable */
  WoReg PIO_OWDR;      /**< \brief (Pio Offset: 0x00A4) Output Write Disable */
  RoReg PIO_OWSR;      /**< \brief (Pio Offset: 0x00A8) Output Write Status Register */
  RwReg Reserved8[1]; 
  WoReg PIO_AIMER;     /**< \brief (Pio Offset: 0x00B0) Additional Interrupt Modes Enable Register */
  WoReg PIO_AIMDR;     /**< \brief (Pio Offset: 0x00B4) Additional Interrupt Modes Disables Register */
  RoReg PIO_AIMMR;     /**< \brief (Pio Offset: 0x00B8) Additional Interrupt Modes Mask Register */
  RwReg Reserved9[1]; 
  WoReg PIO_ESR;       /**< \brief (Pio Offset: 0x00C0) Edge Select Register */
  WoReg PIO_LSR;       /**< \brief (Pio Offset: 0x00C4) Level Select Register */
  RoReg PIO_ELSR;      /**< \brief (Pio Offset: 0x00C8) Edge/Level Status Register */
  RwReg Reserved10[1];
  WoReg PIO_FELLSR;    /**< \brief (Pio Offset: 0x00D0) Falling Edge/Low Level Select Register */
  WoReg PIO_REHLSR;    /**< \brief (Pio Offset: 0x00D4) Rising Edge/ High Level Select Register */
  RoReg PIO_FRLHSR;    /**< \brief (Pio Offset: 0x00D8) Fall/Rise - Low/High Status Register */
  RwReg Reserved11[1];
  RoReg PIO_LOCKSR;    /**< \brief (Pio Offset: 0x00E0) Lock Status */
  RwReg PIO_WPMR;      /**< \brief (Pio Offset: 0x00E4) Write Protect Mode Register */
  RoReg PIO_WPSR;      /**< \brief (Pio Offset: 0x00E8) Write Protect Status Register */
} Pio;
#endif /* __ASSEMBLY__ */
/* -------- PIO_PER : (PIO Offset: 0x0000) PIO Enable Register -------- */
#define PIO_PER_P0 (0x1 << 0) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P1 (0x1 << 1) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P2 (0x1 << 2) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P3 (0x1 << 3) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P4 (0x1 << 4) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P5 (0x1 << 5) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P6 (0x1 << 6) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P7 (0x1 << 7) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P8 (0x1 << 8) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P9 (0x1 << 9) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P10 (0x1 << 10) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P11 (0x1 << 11) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P12 (0x1 << 12) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P13 (0x1 << 13) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P14 (0x1 << 14) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P15 (0x1 << 15) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P16 (0x1 << 16) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P17 (0x1 << 17) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P18 (0x1 << 18) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P19 (0x1 << 19) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P20 (0x1 << 20) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P21 (0x1 << 21) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P22 (0x1 << 22) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P23 (0x1 << 23) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P24 (0x1 << 24) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P25 (0x1 << 25) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P26 (0x1 << 26) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P27 (0x1 << 27) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P28 (0x1 << 28) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P29 (0x1 << 29) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P30 (0x1 << 30) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P31 (0x1 << 31) /**< \brief (PIO_PER) PIO Enable */
/* -------- PIO_PDR : (PIO Offset: 0x0004) PIO Disable Register -------- */
#define PIO_PDR_P0 (0x1 << 0) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P1 (0x1 << 1) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P2 (0x1 << 2) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P3 (0x1 << 3) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P4 (0x1 << 4) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P5 (0x1 << 5) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P6 (0x1 << 6) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P7 (0x1 << 7) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P8 (0x1 << 8) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P9 (0x1 << 9) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P10 (0x1 << 10) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P11 (0x1 << 11) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P12 (0x1 << 12) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P13 (0x1 << 13) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P14 (0x1 << 14) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P15 (0x1 << 15) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P16 (0x1 << 16) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P17 (0x1 << 17) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P18 (0x1 << 18) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P19 (0x1 << 19) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P20 (0x1 << 20) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P21 (0x1 << 21) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P22 (0x1 << 22) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P23 (0x1 << 23) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P24 (0x1 << 24) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P25 (0x1 << 25) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P26 (0x1 << 26) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P27 (0x1 << 27) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P28 (0x1 << 28) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P29 (0x1 << 29) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P30 (0x1 << 30) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P31 (0x1 << 31) /**< \brief (PIO_PDR) PIO Disable */
/* -------- PIO_PSR : (PIO Offset: 0x0008) PIO Status Register -------- */
#define PIO_PSR_P0 (0x1 << 0) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P1 (0x1 << 1) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P2 (0x1 << 2) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P3 (0x1 << 3) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P4 (0x1 << 4) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P5 (0x1 << 5) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P6 (0x1 << 6) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P7 (0x1 << 7) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P8 (0x1 << 8) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P9 (0x1 << 9) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P10 (0x1 << 10) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P11 (0x1 << 11) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P12 (0x1 << 12) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P13 (0x1 << 13) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P14 (0x1 << 14) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P15 (0x1 << 15) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P16 (0x1 << 16) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P17 (0x1 << 17) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P18 (0x1 << 18) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P19 (0x1 << 19) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P20 (0x1 << 20) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P21 (0x1 << 21) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P22 (0x1 << 22) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P23 (0x1 << 23) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P24 (0x1 << 24) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P25 (0x1 << 25) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P26 (0x1 << 26) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P27 (0x1 << 27) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P28 (0x1 << 28) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P29 (0x1 << 29) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P30 (0x1 << 30) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P31 (0x1 << 31) /**< \brief (PIO_PSR) PIO Status */
/* -------- PIO_OER : (PIO Offset: 0x0010) Output Enable Register -------- */
#define PIO_OER_P0 (0x1 << 0) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P1 (0x1 << 1) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P2 (0x1 << 2) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P3 (0x1 << 3) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P4 (0x1 << 4) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P5 (0x1 << 5) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P6 (0x1 << 6) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P7 (0x1 << 7) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P8 (0x1 << 8) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P9 (0x1 << 9) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P10 (0x1 << 10) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P11 (0x1 << 11) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P12 (0x1 << 12) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P13 (0x1 << 13) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P14 (0x1 << 14) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P15 (0x1 << 15) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P16 (0x1 << 16) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P17 (0x1 << 17) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P18 (0x1 << 18) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P19 (0x1 << 19) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P20 (0x1 << 20) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P21 (0x1 << 21) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P22 (0x1 << 22) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P23 (0x1 << 23) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P24 (0x1 << 24) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P25 (0x1 << 25) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P26 (0x1 << 26) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P27 (0x1 << 27) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P28 (0x1 << 28) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P29 (0x1 << 29) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P30 (0x1 << 30) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P31 (0x1 << 31) /**< \brief (PIO_OER) Output Enable */
/* -------- PIO_ODR : (PIO Offset: 0x0014) Output Disable Register -------- */
#define PIO_ODR_P0 (0x1 << 0) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P1 (0x1 << 1) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P2 (0x1 << 2) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P3 (0x1 << 3) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P4 (0x1 << 4) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P5 (0x1 << 5) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P6 (0x1 << 6) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P7 (0x1 << 7) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P8 (0x1 << 8) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P9 (0x1 << 9) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P10 (0x1 << 10) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P11 (0x1 << 11) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P12 (0x1 << 12) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P13 (0x1 << 13) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P14 (0x1 << 14) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P15 (0x1 << 15) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P16 (0x1 << 16) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P17 (0x1 << 17) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P18 (0x1 << 18) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P19 (0x1 << 19) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P20 (0x1 << 20) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P21 (0x1 << 21) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P22 (0x1 << 22) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P23 (0x1 << 23) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P24 (0x1 << 24) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P25 (0x1 << 25) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P26 (0x1 << 26) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P27 (0x1 << 27) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P28 (0x1 << 28) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P29 (0x1 << 29) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P30 (0x1 << 30) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P31 (0x1 << 31) /**< \brief (PIO_ODR) Output Disable */
/* -------- PIO_OSR : (PIO Offset: 0x0018) Output Status Register -------- */
#define PIO_OSR_P0 (0x1 << 0) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P1 (0x1 << 1) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P2 (0x1 << 2) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P3 (0x1 << 3) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P4 (0x1 << 4) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P5 (0x1 << 5) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P6 (0x1 << 6) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P7 (0x1 << 7) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P8 (0x1 << 8) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P9 (0x1 << 9) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P10 (0x1 << 10) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P11 (0x1 << 11) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P12 (0x1 << 12) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P13 (0x1 << 13) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P14 (0x1 << 14) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P15 (0x1 << 15) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P16 (0x1 << 16) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P17 (0x1 << 17) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P18 (0x1 << 18) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P19 (0x1 << 19) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P20 (0x1 << 20) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P21 (0x1 << 21) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P22 (0x1 << 22) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P23 (0x1 << 23) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P24 (0x1 << 24) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P25 (0x1 << 25) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P26 (0x1 << 26) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P27 (0x1 << 27) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P28 (0x1 << 28) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P29 (0x1 << 29) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P30 (0x1 << 30) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P31 (0x1 << 31) /**< \brief (PIO_OSR) Output Status */
/* -------- PIO_IFER : (PIO Offset: 0x0020) Glitch Input Filter Enable Register -------- */
#define PIO_IFER_P0 (0x1 << 0) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P1 (0x1 << 1) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P2 (0x1 << 2) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P3 (0x1 << 3) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P4 (0x1 << 4) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P5 (0x1 << 5) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P6 (0x1 << 6) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P7 (0x1 << 7) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P8 (0x1 << 8) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P9 (0x1 << 9) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P10 (0x1 << 10) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P11 (0x1 << 11) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P12 (0x1 << 12) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P13 (0x1 << 13) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P14 (0x1 << 14) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P15 (0x1 << 15) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P16 (0x1 << 16) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P17 (0x1 << 17) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P18 (0x1 << 18) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P19 (0x1 << 19) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P20 (0x1 << 20) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P21 (0x1 << 21) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P22 (0x1 << 22) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P23 (0x1 << 23) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P24 (0x1 << 24) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P25 (0x1 << 25) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P26 (0x1 << 26) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P27 (0x1 << 27) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P28 (0x1 << 28) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P29 (0x1 << 29) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P30 (0x1 << 30) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P31 (0x1 << 31) /**< \brief (PIO_IFER) Input Filter Enable */
/* -------- PIO_IFDR : (PIO Offset: 0x0024) Glitch Input Filter Disable Register -------- */
#define PIO_IFDR_P0 (0x1 << 0) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P1 (0x1 << 1) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P2 (0x1 << 2) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P3 (0x1 << 3) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P4 (0x1 << 4) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P5 (0x1 << 5) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P6 (0x1 << 6) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P7 (0x1 << 7) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P8 (0x1 << 8) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P9 (0x1 << 9) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P10 (0x1 << 10) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P11 (0x1 << 11) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P12 (0x1 << 12) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P13 (0x1 << 13) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P14 (0x1 << 14) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P15 (0x1 << 15) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P16 (0x1 << 16) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P17 (0x1 << 17) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P18 (0x1 << 18) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P19 (0x1 << 19) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P20 (0x1 << 20) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P21 (0x1 << 21) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P22 (0x1 << 22) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P23 (0x1 << 23) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P24 (0x1 << 24) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P25 (0x1 << 25) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P26 (0x1 << 26) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P27 (0x1 << 27) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P28 (0x1 << 28) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P29 (0x1 << 29) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P30 (0x1 << 30) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P31 (0x1 << 31) /**< \brief (PIO_IFDR) Input Filter Disable */
/* -------- PIO_IFSR : (PIO Offset: 0x0028) Glitch Input Filter Status Register -------- */
#define PIO_IFSR_P0 (0x1 << 0) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P1 (0x1 << 1) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P2 (0x1 << 2) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P3 (0x1 << 3) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P4 (0x1 << 4) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P5 (0x1 << 5) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P6 (0x1 << 6) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P7 (0x1 << 7) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P8 (0x1 << 8) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P9 (0x1 << 9) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P10 (0x1 << 10) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P11 (0x1 << 11) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P12 (0x1 << 12) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P13 (0x1 << 13) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P14 (0x1 << 14) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P15 (0x1 << 15) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P16 (0x1 << 16) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P17 (0x1 << 17) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P18 (0x1 << 18) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P19 (0x1 << 19) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P20 (0x1 << 20) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P21 (0x1 << 21) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P22 (0x1 << 22) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P23 (0x1 << 23) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P24 (0x1 << 24) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P25 (0x1 << 25) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P26 (0x1 << 26) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P27 (0x1 << 27) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P28 (0x1 << 28) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P29 (0x1 << 29) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P30 (0x1 << 30) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P31 (0x1 << 31) /**< \brief (PIO_IFSR) Input Filer Status */
/* -------- PIO_SODR : (PIO Offset: 0x0030) Set Output Data Register -------- */
#define PIO_SODR_P0 (0x1 << 0) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P1 (0x1 << 1) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P2 (0x1 << 2) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P3 (0x1 << 3) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P4 (0x1 << 4) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P5 (0x1 << 5) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P6 (0x1 << 6) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P7 (0x1 << 7) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P8 (0x1 << 8) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P9 (0x1 << 9) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P10 (0x1 << 10) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P11 (0x1 << 11) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P12 (0x1 << 12) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P13 (0x1 << 13) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P14 (0x1 << 14) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P15 (0x1 << 15) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P16 (0x1 << 16) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P17 (0x1 << 17) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P18 (0x1 << 18) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P19 (0x1 << 19) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P20 (0x1 << 20) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P21 (0x1 << 21) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P22 (0x1 << 22) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P23 (0x1 << 23) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P24 (0x1 << 24) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P25 (0x1 << 25) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P26 (0x1 << 26) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P27 (0x1 << 27) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P28 (0x1 << 28) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P29 (0x1 << 29) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P30 (0x1 << 30) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P31 (0x1 << 31) /**< \brief (PIO_SODR) Set Output Data */
/* -------- PIO_CODR : (PIO Offset: 0x0034) Clear Output Data Register -------- */
#define PIO_CODR_P0 (0x1 << 0) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P1 (0x1 << 1) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P2 (0x1 << 2) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P3 (0x1 << 3) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P4 (0x1 << 4) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P5 (0x1 << 5) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P6 (0x1 << 6) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P7 (0x1 << 7) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P8 (0x1 << 8) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P9 (0x1 << 9) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P10 (0x1 << 10) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P11 (0x1 << 11) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P12 (0x1 << 12) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P13 (0x1 << 13) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P14 (0x1 << 14) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P15 (0x1 << 15) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P16 (0x1 << 16) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P17 (0x1 << 17) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P18 (0x1 << 18) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P19 (0x1 << 19) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P20 (0x1 << 20) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P21 (0x1 << 21) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P22 (0x1 << 22) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P23 (0x1 << 23) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P24 (0x1 << 24) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P25 (0x1 << 25) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P26 (0x1 << 26) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P27 (0x1 << 27) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P28 (0x1 << 28) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P29 (0x1 << 29) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P30 (0x1 << 30) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P31 (0x1 << 31) /**< \brief (PIO_CODR) Clear Output Data */
/* -------- PIO_ODSR : (PIO Offset: 0x0038) Output Data Status Register -------- */
#define PIO_ODSR_P0 (0x1 << 0) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P1 (0x1 << 1) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P2 (0x1 << 2) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P3 (0x1 << 3) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P4 (0x1 << 4) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P5 (0x1 << 5) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P6 (0x1 << 6) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P7 (0x1 << 7) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P8 (0x1 << 8) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P9 (0x1 << 9) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P10 (0x1 << 10) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P11 (0x1 << 11) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P12 (0x1 << 12) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P13 (0x1 << 13) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P14 (0x1 << 14) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P15 (0x1 << 15) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P16 (0x1 << 16) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P17 (0x1 << 17) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P18 (0x1 << 18) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P19 (0x1 << 19) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P20 (0x1 << 20) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P21 (0x1 << 21) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P22 (0x1 << 22) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P23 (0x1 << 23) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P24 (0x1 << 24) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P25 (0x1 << 25) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P26 (0x1 << 26) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P27 (0x1 << 27) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P28 (0x1 << 28) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P29 (0x1 << 29) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P30 (0x1 << 30) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P31 (0x1 << 31) /**< \brief (PIO_ODSR) Output Data Status */
/* -------- PIO_PDSR : (PIO Offset: 0x003C) Pin Data Status Register -------- */
#define PIO_PDSR_P0 (0x1 << 0) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P1 (0x1 << 1) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P2 (0x1 << 2) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P3 (0x1 << 3) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P4 (0x1 << 4) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P5 (0x1 << 5) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P6 (0x1 << 6) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P7 (0x1 << 7) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P8 (0x1 << 8) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P9 (0x1 << 9) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P10 (0x1 << 10) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P11 (0x1 << 11) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P12 (0x1 << 12) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P13 (0x1 << 13) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P14 (0x1 << 14) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P15 (0x1 << 15) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P16 (0x1 << 16) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P17 (0x1 << 17) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P18 (0x1 << 18) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P19 (0x1 << 19) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P20 (0x1 << 20) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P21 (0x1 << 21) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P22 (0x1 << 22) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P23 (0x1 << 23) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P24 (0x1 << 24) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P25 (0x1 << 25) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P26 (0x1 << 26) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P27 (0x1 << 27) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P28 (0x1 << 28) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P29 (0x1 << 29) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P30 (0x1 << 30) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P31 (0x1 << 31) /**< \brief (PIO_PDSR) Output Data Status */
/* -------- PIO_IER : (PIO Offset: 0x0040) Interrupt Enable Register -------- */
#define PIO_IER_P0 (0x1 << 0) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P1 (0x1 << 1) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P2 (0x1 << 2) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P3 (0x1 << 3) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P4 (0x1 << 4) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P5 (0x1 << 5) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P6 (0x1 << 6) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P7 (0x1 << 7) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P8 (0x1 << 8) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P9 (0x1 << 9) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P10 (0x1 << 10) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P11 (0x1 << 11) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P12 (0x1 << 12) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P13 (0x1 << 13) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P14 (0x1 << 14) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P15 (0x1 << 15) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P16 (0x1 << 16) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P17 (0x1 << 17) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P18 (0x1 << 18) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P19 (0x1 << 19) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P20 (0x1 << 20) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P21 (0x1 << 21) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P22 (0x1 << 22) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P23 (0x1 << 23) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P24 (0x1 << 24) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P25 (0x1 << 25) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P26 (0x1 << 26) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P27 (0x1 << 27) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P28 (0x1 << 28) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P29 (0x1 << 29) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P30 (0x1 << 30) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P31 (0x1 << 31) /**< \brief (PIO_IER) Input Change Interrupt Enable */
/* -------- PIO_IDR : (PIO Offset: 0x0044) Interrupt Disable Register -------- */
#define PIO_IDR_P0 (0x1 << 0) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P1 (0x1 << 1) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P2 (0x1 << 2) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P3 (0x1 << 3) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P4 (0x1 << 4) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P5 (0x1 << 5) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P6 (0x1 << 6) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P7 (0x1 << 7) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P8 (0x1 << 8) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P9 (0x1 << 9) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P10 (0x1 << 10) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P11 (0x1 << 11) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P12 (0x1 << 12) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P13 (0x1 << 13) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P14 (0x1 << 14) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P15 (0x1 << 15) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P16 (0x1 << 16) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P17 (0x1 << 17) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P18 (0x1 << 18) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P19 (0x1 << 19) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P20 (0x1 << 20) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P21 (0x1 << 21) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P22 (0x1 << 22) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P23 (0x1 << 23) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P24 (0x1 << 24) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P25 (0x1 << 25) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P26 (0x1 << 26) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P27 (0x1 << 27) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P28 (0x1 << 28) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P29 (0x1 << 29) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P30 (0x1 << 30) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P31 (0x1 << 31) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
/* -------- PIO_IMR : (PIO Offset: 0x0048) Interrupt Mask Register -------- */
#define PIO_IMR_P0 (0x1 << 0) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P1 (0x1 << 1) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P2 (0x1 << 2) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P3 (0x1 << 3) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P4 (0x1 << 4) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P5 (0x1 << 5) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P6 (0x1 << 6) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P7 (0x1 << 7) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P8 (0x1 << 8) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P9 (0x1 << 9) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P10 (0x1 << 10) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P11 (0x1 << 11) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P12 (0x1 << 12) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P13 (0x1 << 13) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P14 (0x1 << 14) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P15 (0x1 << 15) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P16 (0x1 << 16) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P17 (0x1 << 17) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P18 (0x1 << 18) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P19 (0x1 << 19) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P20 (0x1 << 20) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P21 (0x1 << 21) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P22 (0x1 << 22) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P23 (0x1 << 23) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P24 (0x1 << 24) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P25 (0x1 << 25) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P26 (0x1 << 26) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P27 (0x1 << 27) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P28 (0x1 << 28) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P29 (0x1 << 29) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P30 (0x1 << 30) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P31 (0x1 << 31) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
/* -------- PIO_ISR : (PIO Offset: 0x004C) Interrupt Status Register -------- */
#define PIO_ISR_P0 (0x1 << 0) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P1 (0x1 << 1) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P2 (0x1 << 2) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P3 (0x1 << 3) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P4 (0x1 << 4) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P5 (0x1 << 5) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P6 (0x1 << 6) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P7 (0x1 << 7) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P8 (0x1 << 8) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P9 (0x1 << 9) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P10 (0x1 << 10) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P11 (0x1 << 11) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P12 (0x1 << 12) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P13 (0x1 << 13) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P14 (0x1 << 14) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P15 (0x1 << 15) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P16 (0x1 << 16) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P17 (0x1 << 17) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P18 (0x1 << 18) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P19 (0x1 << 19) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P20 (0x1 << 20) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P21 (0x1 << 21) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P22 (0x1 << 22) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P23 (0x1 << 23) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P24 (0x1 << 24) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P25 (0x1 << 25) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P26 (0x1 << 26) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P27 (0x1 << 27) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P28 (0x1 << 28) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P29 (0x1 << 29) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P30 (0x1 << 30) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P31 (0x1 << 31) /**< \brief (PIO_ISR) Input Change Interrupt Status */
/* -------- PIO_MDER : (PIO Offset: 0x0050) Multi-driver Enable Register -------- */
#define PIO_MDER_P0 (0x1 << 0) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P1 (0x1 << 1) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P2 (0x1 << 2) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P3 (0x1 << 3) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P4 (0x1 << 4) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P5 (0x1 << 5) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P6 (0x1 << 6) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P7 (0x1 << 7) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P8 (0x1 << 8) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P9 (0x1 << 9) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P10 (0x1 << 10) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P11 (0x1 << 11) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P12 (0x1 << 12) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P13 (0x1 << 13) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P14 (0x1 << 14) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P15 (0x1 << 15) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P16 (0x1 << 16) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P17 (0x1 << 17) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P18 (0x1 << 18) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P19 (0x1 << 19) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P20 (0x1 << 20) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P21 (0x1 << 21) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P22 (0x1 << 22) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P23 (0x1 << 23) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P24 (0x1 << 24) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P25 (0x1 << 25) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P26 (0x1 << 26) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P27 (0x1 << 27) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P28 (0x1 << 28) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P29 (0x1 << 29) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P30 (0x1 << 30) /**< \brief (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P31 (0x1 << 31) /**< \brief (PIO_MDER) Multi Drive Enable. */
/* -------- PIO_MDDR : (PIO Offset: 0x0054) Multi-driver Disable Register -------- */
#define PIO_MDDR_P0 (0x1 << 0) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P1 (0x1 << 1) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P2 (0x1 << 2) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P3 (0x1 << 3) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P4 (0x1 << 4) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P5 (0x1 << 5) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P6 (0x1 << 6) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P7 (0x1 << 7) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P8 (0x1 << 8) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P9 (0x1 << 9) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P10 (0x1 << 10) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P11 (0x1 << 11) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P12 (0x1 << 12) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P13 (0x1 << 13) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P14 (0x1 << 14) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P15 (0x1 << 15) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P16 (0x1 << 16) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P17 (0x1 << 17) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P18 (0x1 << 18) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P19 (0x1 << 19) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P20 (0x1 << 20) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P21 (0x1 << 21) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P22 (0x1 << 22) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P23 (0x1 << 23) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P24 (0x1 << 24) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P25 (0x1 << 25) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P26 (0x1 << 26) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P27 (0x1 << 27) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P28 (0x1 << 28) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P29 (0x1 << 29) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P30 (0x1 << 30) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P31 (0x1 << 31) /**< \brief (PIO_MDDR) Multi Drive Disable. */
/* -------- PIO_MDSR : (PIO Offset: 0x0058) Multi-driver Status Register -------- */
#define PIO_MDSR_P0 (0x1 << 0) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P1 (0x1 << 1) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P2 (0x1 << 2) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P3 (0x1 << 3) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P4 (0x1 << 4) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P5 (0x1 << 5) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P6 (0x1 << 6) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P7 (0x1 << 7) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P8 (0x1 << 8) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P9 (0x1 << 9) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P10 (0x1 << 10) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P11 (0x1 << 11) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P12 (0x1 << 12) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P13 (0x1 << 13) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P14 (0x1 << 14) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P15 (0x1 << 15) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P16 (0x1 << 16) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P17 (0x1 << 17) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P18 (0x1 << 18) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P19 (0x1 << 19) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P20 (0x1 << 20) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P21 (0x1 << 21) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P22 (0x1 << 22) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P23 (0x1 << 23) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P24 (0x1 << 24) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P25 (0x1 << 25) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P26 (0x1 << 26) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P27 (0x1 << 27) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P28 (0x1 << 28) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P29 (0x1 << 29) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P30 (0x1 << 30) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P31 (0x1 << 31) /**< \brief (PIO_MDSR) Multi Drive Status. */
/* -------- PIO_PUDR : (PIO Offset: 0x0060) Pull-up Disable Register -------- */
#define PIO_PUDR_P0 (0x1 << 0) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P1 (0x1 << 1) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P2 (0x1 << 2) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P3 (0x1 << 3) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P4 (0x1 << 4) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P5 (0x1 << 5) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P6 (0x1 << 6) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P7 (0x1 << 7) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P8 (0x1 << 8) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P9 (0x1 << 9) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P10 (0x1 << 10) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P11 (0x1 << 11) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P12 (0x1 << 12) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P13 (0x1 << 13) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P14 (0x1 << 14) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P15 (0x1 << 15) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P16 (0x1 << 16) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P17 (0x1 << 17) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P18 (0x1 << 18) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P19 (0x1 << 19) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P20 (0x1 << 20) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P21 (0x1 << 21) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P22 (0x1 << 22) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P23 (0x1 << 23) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P24 (0x1 << 24) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P25 (0x1 << 25) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P26 (0x1 << 26) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P27 (0x1 << 27) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P28 (0x1 << 28) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P29 (0x1 << 29) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P30 (0x1 << 30) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P31 (0x1 << 31) /**< \brief (PIO_PUDR) Pull Up Disable. */
/* -------- PIO_PUER : (PIO Offset: 0x0064) Pull-up Enable Register -------- */
#define PIO_PUER_P0 (0x1 << 0) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P1 (0x1 << 1) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P2 (0x1 << 2) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P3 (0x1 << 3) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P4 (0x1 << 4) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P5 (0x1 << 5) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P6 (0x1 << 6) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P7 (0x1 << 7) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P8 (0x1 << 8) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P9 (0x1 << 9) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P10 (0x1 << 10) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P11 (0x1 << 11) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P12 (0x1 << 12) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P13 (0x1 << 13) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P14 (0x1 << 14) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P15 (0x1 << 15) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P16 (0x1 << 16) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P17 (0x1 << 17) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P18 (0x1 << 18) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P19 (0x1 << 19) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P20 (0x1 << 20) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P21 (0x1 << 21) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P22 (0x1 << 22) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P23 (0x1 << 23) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P24 (0x1 << 24) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P25 (0x1 << 25) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P26 (0x1 << 26) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P27 (0x1 << 27) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P28 (0x1 << 28) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P29 (0x1 << 29) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P30 (0x1 << 30) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P31 (0x1 << 31) /**< \brief (PIO_PUER) Pull Up Enable. */
/* -------- PIO_PUSR : (PIO Offset: 0x0068) Pad Pull-up Status Register -------- */
#define PIO_PUSR_P0 (0x1 << 0) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P1 (0x1 << 1) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P2 (0x1 << 2) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P3 (0x1 << 3) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P4 (0x1 << 4) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P5 (0x1 << 5) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P6 (0x1 << 6) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P7 (0x1 << 7) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P8 (0x1 << 8) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P9 (0x1 << 9) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P10 (0x1 << 10) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P11 (0x1 << 11) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P12 (0x1 << 12) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P13 (0x1 << 13) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P14 (0x1 << 14) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P15 (0x1 << 15) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P16 (0x1 << 16) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P17 (0x1 << 17) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P18 (0x1 << 18) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P19 (0x1 << 19) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P20 (0x1 << 20) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P21 (0x1 << 21) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P22 (0x1 << 22) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P23 (0x1 << 23) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P24 (0x1 << 24) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P25 (0x1 << 25) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P26 (0x1 << 26) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P27 (0x1 << 27) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P28 (0x1 << 28) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P29 (0x1 << 29) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P30 (0x1 << 30) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P31 (0x1 << 31) /**< \brief (PIO_PUSR) Pull Up Status. */
/* -------- PIO_ABSR : (PIO Offset: 0x0070) Peripheral AB Select Register -------- */
#define PIO_ABSR_P0 (0x1 << 0) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P1 (0x1 << 1) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P2 (0x1 << 2) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P3 (0x1 << 3) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P4 (0x1 << 4) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P5 (0x1 << 5) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P6 (0x1 << 6) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P7 (0x1 << 7) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P8 (0x1 << 8) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P9 (0x1 << 9) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P10 (0x1 << 10) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P11 (0x1 << 11) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P12 (0x1 << 12) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P13 (0x1 << 13) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P14 (0x1 << 14) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P15 (0x1 << 15) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P16 (0x1 << 16) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P17 (0x1 << 17) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P18 (0x1 << 18) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P19 (0x1 << 19) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P20 (0x1 << 20) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P21 (0x1 << 21) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P22 (0x1 << 22) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P23 (0x1 << 23) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P24 (0x1 << 24) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P25 (0x1 << 25) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P26 (0x1 << 26) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P27 (0x1 << 27) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P28 (0x1 << 28) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P29 (0x1 << 29) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P30 (0x1 << 30) /**< \brief (PIO_ABSR) Peripheral A Select. */
#define PIO_ABSR_P31 (0x1 << 31) /**< \brief (PIO_ABSR) Peripheral A Select. */
/* -------- PIO_SCIFSR : (PIO Offset: 0x0080) System Clock Glitch Input Filter Select Register -------- */
#define PIO_SCIFSR_P0 (0x1 << 0) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P1 (0x1 << 1) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P2 (0x1 << 2) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P3 (0x1 << 3) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P4 (0x1 << 4) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P5 (0x1 << 5) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P6 (0x1 << 6) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P7 (0x1 << 7) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P8 (0x1 << 8) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P9 (0x1 << 9) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P10 (0x1 << 10) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P11 (0x1 << 11) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P12 (0x1 << 12) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P13 (0x1 << 13) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P14 (0x1 << 14) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P15 (0x1 << 15) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P16 (0x1 << 16) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P17 (0x1 << 17) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P18 (0x1 << 18) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P19 (0x1 << 19) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P20 (0x1 << 20) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P21 (0x1 << 21) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P22 (0x1 << 22) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P23 (0x1 << 23) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P24 (0x1 << 24) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P25 (0x1 << 25) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P26 (0x1 << 26) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P27 (0x1 << 27) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P28 (0x1 << 28) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P29 (0x1 << 29) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P30 (0x1 << 30) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
#define PIO_SCIFSR_P31 (0x1 << 31) /**< \brief (PIO_SCIFSR) System Clock Glitch Filtering Select. */
/* -------- PIO_DIFSR : (PIO Offset: 0x0084) Debouncing Input Filter Select Register -------- */
#define PIO_DIFSR_P0 (0x1 << 0) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P1 (0x1 << 1) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P2 (0x1 << 2) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P3 (0x1 << 3) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P4 (0x1 << 4) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P5 (0x1 << 5) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P6 (0x1 << 6) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P7 (0x1 << 7) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P8 (0x1 << 8) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P9 (0x1 << 9) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P10 (0x1 << 10) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P11 (0x1 << 11) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P12 (0x1 << 12) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P13 (0x1 << 13) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P14 (0x1 << 14) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P15 (0x1 << 15) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P16 (0x1 << 16) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P17 (0x1 << 17) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P18 (0x1 << 18) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P19 (0x1 << 19) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P20 (0x1 << 20) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P21 (0x1 << 21) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P22 (0x1 << 22) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P23 (0x1 << 23) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P24 (0x1 << 24) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P25 (0x1 << 25) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P26 (0x1 << 26) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P27 (0x1 << 27) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P28 (0x1 << 28) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P29 (0x1 << 29) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P30 (0x1 << 30) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
#define PIO_DIFSR_P31 (0x1 << 31) /**< \brief (PIO_DIFSR) Debouncing Filtering Select. */
/* -------- PIO_IFDGSR : (PIO Offset: 0x0088) Glitch or Debouncing Input Filter Clock Selection Status Register -------- */
#define PIO_IFDGSR_P0 (0x1 << 0) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P1 (0x1 << 1) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P2 (0x1 << 2) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P3 (0x1 << 3) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P4 (0x1 << 4) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P5 (0x1 << 5) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P6 (0x1 << 6) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P7 (0x1 << 7) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P8 (0x1 << 8) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P9 (0x1 << 9) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P10 (0x1 << 10) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P11 (0x1 << 11) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P12 (0x1 << 12) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P13 (0x1 << 13) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P14 (0x1 << 14) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P15 (0x1 << 15) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P16 (0x1 << 16) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P17 (0x1 << 17) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P18 (0x1 << 18) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P19 (0x1 << 19) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P20 (0x1 << 20) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P21 (0x1 << 21) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P22 (0x1 << 22) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P23 (0x1 << 23) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P24 (0x1 << 24) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P25 (0x1 << 25) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P26 (0x1 << 26) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P27 (0x1 << 27) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P28 (0x1 << 28) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P29 (0x1 << 29) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P30 (0x1 << 30) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFDGSR_P31 (0x1 << 31) /**< \brief (PIO_IFDGSR) Glitch or Debouncing Filter Selection Status */
/* -------- PIO_SCDR : (PIO Offset: 0x008C) Slow Clock Divider Debouncing Register -------- */
#define PIO_SCDR_DIV0 (0x1 << 0) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV1 (0x1 << 1) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV2 (0x1 << 2) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV3 (0x1 << 3) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV4 (0x1 << 4) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV5 (0x1 << 5) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV6 (0x1 << 6) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV7 (0x1 << 7) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV8 (0x1 << 8) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV9 (0x1 << 9) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV10 (0x1 << 10) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV11 (0x1 << 11) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV12 (0x1 << 12) /**< \brief (PIO_SCDR)  */
#define PIO_SCDR_DIV13 (0x1 << 13) /**< \brief (PIO_SCDR)  */
/* -------- PIO_OWER : (PIO Offset: 0x00A0) Output Write Enable -------- */
#define PIO_OWER_P0 (0x1 << 0) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P1 (0x1 << 1) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P2 (0x1 << 2) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P3 (0x1 << 3) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P4 (0x1 << 4) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P5 (0x1 << 5) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P6 (0x1 << 6) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P7 (0x1 << 7) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P8 (0x1 << 8) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P9 (0x1 << 9) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P10 (0x1 << 10) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P11 (0x1 << 11) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P12 (0x1 << 12) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P13 (0x1 << 13) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P14 (0x1 << 14) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P15 (0x1 << 15) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P16 (0x1 << 16) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P17 (0x1 << 17) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P18 (0x1 << 18) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P19 (0x1 << 19) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P20 (0x1 << 20) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P21 (0x1 << 21) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P22 (0x1 << 22) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P23 (0x1 << 23) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P24 (0x1 << 24) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P25 (0x1 << 25) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P26 (0x1 << 26) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P27 (0x1 << 27) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P28 (0x1 << 28) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P29 (0x1 << 29) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P30 (0x1 << 30) /**< \brief (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P31 (0x1 << 31) /**< \brief (PIO_OWER) Output Write Enable. */
/* -------- PIO_OWDR : (PIO Offset: 0x00A4) Output Write Disable -------- */
#define PIO_OWDR_P0 (0x1 << 0) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P1 (0x1 << 1) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P2 (0x1 << 2) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P3 (0x1 << 3) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P4 (0x1 << 4) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P5 (0x1 << 5) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P6 (0x1 << 6) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P7 (0x1 << 7) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P8 (0x1 << 8) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P9 (0x1 << 9) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P10 (0x1 << 10) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P11 (0x1 << 11) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P12 (0x1 << 12) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P13 (0x1 << 13) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P14 (0x1 << 14) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P15 (0x1 << 15) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P16 (0x1 << 16) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P17 (0x1 << 17) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P18 (0x1 << 18) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P19 (0x1 << 19) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P20 (0x1 << 20) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P21 (0x1 << 21) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P22 (0x1 << 22) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P23 (0x1 << 23) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P24 (0x1 << 24) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P25 (0x1 << 25) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P26 (0x1 << 26) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P27 (0x1 << 27) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P28 (0x1 << 28) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P29 (0x1 << 29) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P30 (0x1 << 30) /**< \brief (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P31 (0x1 << 31) /**< \brief (PIO_OWDR) Output Write Disable. */
/* -------- PIO_OWSR : (PIO Offset: 0x00A8) Output Write Status Register -------- */
#define PIO_OWSR_P0 (0x1 << 0) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P1 (0x1 << 1) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P2 (0x1 << 2) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P3 (0x1 << 3) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P4 (0x1 << 4) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P5 (0x1 << 5) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P6 (0x1 << 6) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P7 (0x1 << 7) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P8 (0x1 << 8) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P9 (0x1 << 9) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P10 (0x1 << 10) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P11 (0x1 << 11) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P12 (0x1 << 12) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P13 (0x1 << 13) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P14 (0x1 << 14) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P15 (0x1 << 15) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P16 (0x1 << 16) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P17 (0x1 << 17) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P18 (0x1 << 18) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P19 (0x1 << 19) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P20 (0x1 << 20) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P21 (0x1 << 21) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P22 (0x1 << 22) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P23 (0x1 << 23) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P24 (0x1 << 24) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P25 (0x1 << 25) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P26 (0x1 << 26) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P27 (0x1 << 27) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P28 (0x1 << 28) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P29 (0x1 << 29) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P30 (0x1 << 30) /**< \brief (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P31 (0x1 << 31) /**< \brief (PIO_OWSR) Output Write Status. */
/* -------- PIO_AIMER : (PIO Offset: 0x00B0) Additional Interrupt Modes Enable Register -------- */
#define PIO_AIMER_P0 (0x1 << 0) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P1 (0x1 << 1) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P2 (0x1 << 2) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P3 (0x1 << 3) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P4 (0x1 << 4) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P5 (0x1 << 5) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P6 (0x1 << 6) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P7 (0x1 << 7) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P8 (0x1 << 8) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P9 (0x1 << 9) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P10 (0x1 << 10) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P11 (0x1 << 11) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P12 (0x1 << 12) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P13 (0x1 << 13) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P14 (0x1 << 14) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P15 (0x1 << 15) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P16 (0x1 << 16) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P17 (0x1 << 17) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P18 (0x1 << 18) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P19 (0x1 << 19) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P20 (0x1 << 20) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P21 (0x1 << 21) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P22 (0x1 << 22) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P23 (0x1 << 23) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P24 (0x1 << 24) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P25 (0x1 << 25) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P26 (0x1 << 26) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P27 (0x1 << 27) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P28 (0x1 << 28) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P29 (0x1 << 29) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P30 (0x1 << 30) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P31 (0x1 << 31) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable. */
/* -------- PIO_AIMDR : (PIO Offset: 0x00B4) Additional Interrupt Modes Disables Register -------- */
#define PIO_AIMDR_P0 (0x1 << 0) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P1 (0x1 << 1) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P2 (0x1 << 2) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P3 (0x1 << 3) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P4 (0x1 << 4) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P5 (0x1 << 5) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P6 (0x1 << 6) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P7 (0x1 << 7) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P8 (0x1 << 8) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P9 (0x1 << 9) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P10 (0x1 << 10) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P11 (0x1 << 11) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P12 (0x1 << 12) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P13 (0x1 << 13) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P14 (0x1 << 14) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P15 (0x1 << 15) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P16 (0x1 << 16) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P17 (0x1 << 17) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P18 (0x1 << 18) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P19 (0x1 << 19) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P20 (0x1 << 20) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P21 (0x1 << 21) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P22 (0x1 << 22) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P23 (0x1 << 23) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P24 (0x1 << 24) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P25 (0x1 << 25) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P26 (0x1 << 26) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P27 (0x1 << 27) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P28 (0x1 << 28) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P29 (0x1 << 29) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P30 (0x1 << 30) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P31 (0x1 << 31) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable. */
/* -------- PIO_AIMMR : (PIO Offset: 0x00B8) Additional Interrupt Modes Mask Register -------- */
#define PIO_AIMMR_P0 (0x1 << 0) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P1 (0x1 << 1) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P2 (0x1 << 2) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P3 (0x1 << 3) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P4 (0x1 << 4) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P5 (0x1 << 5) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P6 (0x1 << 6) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P7 (0x1 << 7) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P8 (0x1 << 8) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P9 (0x1 << 9) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P10 (0x1 << 10) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P11 (0x1 << 11) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P12 (0x1 << 12) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P13 (0x1 << 13) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P14 (0x1 << 14) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P15 (0x1 << 15) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P16 (0x1 << 16) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P17 (0x1 << 17) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P18 (0x1 << 18) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P19 (0x1 << 19) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P20 (0x1 << 20) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P21 (0x1 << 21) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P22 (0x1 << 22) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P23 (0x1 << 23) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P24 (0x1 << 24) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P25 (0x1 << 25) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P26 (0x1 << 26) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P27 (0x1 << 27) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P28 (0x1 << 28) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P29 (0x1 << 29) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P30 (0x1 << 30) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P31 (0x1 << 31) /**< \brief (PIO_AIMMR) Peripheral CD Status. */
/* -------- PIO_ESR : (PIO Offset: 0x00C0) Edge Select Register -------- */
#define PIO_ESR_P0 (0x1 << 0) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P1 (0x1 << 1) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P2 (0x1 << 2) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P3 (0x1 << 3) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P4 (0x1 << 4) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P5 (0x1 << 5) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P6 (0x1 << 6) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P7 (0x1 << 7) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P8 (0x1 << 8) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P9 (0x1 << 9) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P10 (0x1 << 10) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P11 (0x1 << 11) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P12 (0x1 << 12) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P13 (0x1 << 13) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P14 (0x1 << 14) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P15 (0x1 << 15) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P16 (0x1 << 16) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P17 (0x1 << 17) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P18 (0x1 << 18) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P19 (0x1 << 19) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P20 (0x1 << 20) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P21 (0x1 << 21) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P22 (0x1 << 22) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P23 (0x1 << 23) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P24 (0x1 << 24) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P25 (0x1 << 25) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P26 (0x1 << 26) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P27 (0x1 << 27) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P28 (0x1 << 28) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P29 (0x1 << 29) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P30 (0x1 << 30) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P31 (0x1 << 31) /**< \brief (PIO_ESR) Edge Interrupt Selection. */
/* -------- PIO_LSR : (PIO Offset: 0x00C4) Level Select Register -------- */
#define PIO_LSR_P0 (0x1 << 0) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P1 (0x1 << 1) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P2 (0x1 << 2) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P3 (0x1 << 3) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P4 (0x1 << 4) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P5 (0x1 << 5) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P6 (0x1 << 6) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P7 (0x1 << 7) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P8 (0x1 << 8) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P9 (0x1 << 9) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P10 (0x1 << 10) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P11 (0x1 << 11) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P12 (0x1 << 12) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P13 (0x1 << 13) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P14 (0x1 << 14) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P15 (0x1 << 15) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P16 (0x1 << 16) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P17 (0x1 << 17) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P18 (0x1 << 18) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P19 (0x1 << 19) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P20 (0x1 << 20) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P21 (0x1 << 21) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P22 (0x1 << 22) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P23 (0x1 << 23) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P24 (0x1 << 24) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P25 (0x1 << 25) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P26 (0x1 << 26) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P27 (0x1 << 27) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P28 (0x1 << 28) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P29 (0x1 << 29) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P30 (0x1 << 30) /**< \brief (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P31 (0x1 << 31) /**< \brief (PIO_LSR) Level Interrupt Selection. */
/* -------- PIO_ELSR : (PIO Offset: 0x00C8) Edge/Level Status Register -------- */
#define PIO_ELSR_P0 (0x1 << 0) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P1 (0x1 << 1) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P2 (0x1 << 2) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P3 (0x1 << 3) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P4 (0x1 << 4) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P5 (0x1 << 5) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P6 (0x1 << 6) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P7 (0x1 << 7) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P8 (0x1 << 8) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P9 (0x1 << 9) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P10 (0x1 << 10) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P11 (0x1 << 11) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P12 (0x1 << 12) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P13 (0x1 << 13) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P14 (0x1 << 14) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P15 (0x1 << 15) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P16 (0x1 << 16) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P17 (0x1 << 17) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P18 (0x1 << 18) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P19 (0x1 << 19) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P20 (0x1 << 20) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P21 (0x1 << 21) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P22 (0x1 << 22) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P23 (0x1 << 23) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P24 (0x1 << 24) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P25 (0x1 << 25) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P26 (0x1 << 26) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P27 (0x1 << 27) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P28 (0x1 << 28) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P29 (0x1 << 29) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P30 (0x1 << 30) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P31 (0x1 << 31) /**< \brief (PIO_ELSR) Edge/Level Interrupt source selection. */
/* -------- PIO_FELLSR : (PIO Offset: 0x00D0) Falling Edge/Low Level Select Register -------- */
#define PIO_FELLSR_P0 (0x1 << 0) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P1 (0x1 << 1) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P2 (0x1 << 2) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P3 (0x1 << 3) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P4 (0x1 << 4) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P5 (0x1 << 5) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P6 (0x1 << 6) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P7 (0x1 << 7) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P8 (0x1 << 8) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P9 (0x1 << 9) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P10 (0x1 << 10) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P11 (0x1 << 11) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P12 (0x1 << 12) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P13 (0x1 << 13) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P14 (0x1 << 14) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P15 (0x1 << 15) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P16 (0x1 << 16) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P17 (0x1 << 17) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P18 (0x1 << 18) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P19 (0x1 << 19) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P20 (0x1 << 20) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P21 (0x1 << 21) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P22 (0x1 << 22) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P23 (0x1 << 23) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P24 (0x1 << 24) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P25 (0x1 << 25) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P26 (0x1 << 26) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P27 (0x1 << 27) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P28 (0x1 << 28) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P29 (0x1 << 29) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P30 (0x1 << 30) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P31 (0x1 << 31) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
/* -------- PIO_REHLSR : (PIO Offset: 0x00D4) Rising Edge/ High Level Select Register -------- */
#define PIO_REHLSR_P0 (0x1 << 0) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P1 (0x1 << 1) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P2 (0x1 << 2) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P3 (0x1 << 3) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P4 (0x1 << 4) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P5 (0x1 << 5) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P6 (0x1 << 6) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P7 (0x1 << 7) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P8 (0x1 << 8) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P9 (0x1 << 9) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P10 (0x1 << 10) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P11 (0x1 << 11) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P12 (0x1 << 12) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P13 (0x1 << 13) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P14 (0x1 << 14) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P15 (0x1 << 15) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P16 (0x1 << 16) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P17 (0x1 << 17) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P18 (0x1 << 18) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P19 (0x1 << 19) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P20 (0x1 << 20) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P21 (0x1 << 21) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P22 (0x1 << 22) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P23 (0x1 << 23) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P24 (0x1 << 24) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P25 (0x1 << 25) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P26 (0x1 << 26) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P27 (0x1 << 27) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P28 (0x1 << 28) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P29 (0x1 << 29) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P30 (0x1 << 30) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P31 (0x1 << 31) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
/* -------- PIO_FRLHSR : (PIO Offset: 0x00D8) Fall/Rise - Low/High Status Register -------- */
#define PIO_FRLHSR_P0 (0x1 << 0) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P1 (0x1 << 1) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P2 (0x1 << 2) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P3 (0x1 << 3) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P4 (0x1 << 4) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P5 (0x1 << 5) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P6 (0x1 << 6) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P7 (0x1 << 7) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P8 (0x1 << 8) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P9 (0x1 << 9) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P10 (0x1 << 10) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P11 (0x1 << 11) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P12 (0x1 << 12) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P13 (0x1 << 13) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P14 (0x1 << 14) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P15 (0x1 << 15) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P16 (0x1 << 16) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P17 (0x1 << 17) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P18 (0x1 << 18) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P19 (0x1 << 19) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P20 (0x1 << 20) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P21 (0x1 << 21) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P22 (0x1 << 22) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P23 (0x1 << 23) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P24 (0x1 << 24) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P25 (0x1 << 25) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P26 (0x1 << 26) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P27 (0x1 << 27) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P28 (0x1 << 28) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P29 (0x1 << 29) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P30 (0x1 << 30) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P31 (0x1 << 31) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
/* -------- PIO_LOCKSR : (PIO Offset: 0x00E0) Lock Status -------- */
#define PIO_LOCKSR_P0 (0x1 << 0) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P1 (0x1 << 1) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P2 (0x1 << 2) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P3 (0x1 << 3) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P4 (0x1 << 4) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P5 (0x1 << 5) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P6 (0x1 << 6) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P7 (0x1 << 7) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P8 (0x1 << 8) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P9 (0x1 << 9) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P10 (0x1 << 10) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P11 (0x1 << 11) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P12 (0x1 << 12) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P13 (0x1 << 13) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P14 (0x1 << 14) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P15 (0x1 << 15) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P16 (0x1 << 16) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P17 (0x1 << 17) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P18 (0x1 << 18) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P19 (0x1 << 19) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P20 (0x1 << 20) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P21 (0x1 << 21) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P22 (0x1 << 22) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P23 (0x1 << 23) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P24 (0x1 << 24) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P25 (0x1 << 25) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P26 (0x1 << 26) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P27 (0x1 << 27) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P28 (0x1 << 28) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P29 (0x1 << 29) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P30 (0x1 << 30) /**< \brief (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P31 (0x1 << 31) /**< \brief (PIO_LOCKSR) Lock Status. */
/* -------- PIO_WPMR : (PIO Offset: 0x00E4) Write Protect Mode Register -------- */
#define PIO_WPMR_WPEN (0x1 << 0) /**< \brief (PIO_WPMR) Write Protect Enable */
#define PIO_WPMR_WPKEY (0xffffff << 8) /**< \brief (PIO_WPMR) Write Protect KEY */
/* -------- PIO_WPSR : (PIO Offset: 0x00E8) Write Protect Status Register -------- */
#define PIO_WPSR_WPVS (0x1 << 0) /**< \brief (PIO_WPSR) Write Protect Violation Status */
#define PIO_WPSR_WPVSRC (0xffff << 8) /**< \brief (PIO_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Power Management Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_PMC Power Management Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Pmc hardware registers */
typedef struct {
  WoReg PMC_SCER;     /**< \brief (Pmc Offset: 0x0000) System Clock Enable Register */
  WoReg PMC_SCDR;     /**< \brief (Pmc Offset: 0x0004) System Clock Disable Register */
  RoReg PMC_SCSR;     /**< \brief (Pmc Offset: 0x0008) System Clock Status Register */
  RwReg Reserved1[1];
  WoReg PMC_PCER;     /**< \brief (Pmc Offset: 0x0010) Peripheral Clock Enable Register */
  WoReg PMC_PCDR;     /**< \brief (Pmc Offset: 0x0014) Peripheral Clock Disable Register */
  RoReg PMC_PCSR;     /**< \brief (Pmc Offset: 0x0018) Peripheral Clock Status Register */
  RwReg CKGR_UCKR;    /**< \brief (Pmc Offset: 0x001C) UTMI Clock Register */
  RwReg CKGR_MOR;     /**< \brief (Pmc Offset: 0x0020) Main Oscillator Register */
  RoReg CKGR_MCFR;    /**< \brief (Pmc Offset: 0x0024) Main Clock Frequency Register */
  RwReg CKGR_PLLAR;   /**< \brief (Pmc Offset: 0x0028) PLLA Register */
  RwReg Reserved2[1];
  RwReg PMC_MCKR;     /**< \brief (Pmc Offset: 0x0030) Master Clock Register */
  RwReg Reserved3[3];
  RwReg PMC_PCK[3];   /**< \brief (Pmc Offset: 0x0040) Programmable Clock 0 Register */
  RwReg Reserved4[5];
  WoReg PMC_IER;      /**< \brief (Pmc Offset: 0x0060) Interrupt Enable Register */
  WoReg PMC_IDR;      /**< \brief (Pmc Offset: 0x0064) Interrupt Disable Register */
  RoReg PMC_SR;       /**< \brief (Pmc Offset: 0x0068) Status Register */
  RoReg PMC_IMR;      /**< \brief (Pmc Offset: 0x006C) Interrupt Mask Register */
  RwReg PMC_FSMR;     /**< \brief (Pmc Offset: 0x0070) Fast Startup Mode Register */
  RwReg PMC_FSPR;     /**< \brief (Pmc Offset: 0x0074) Fast Startup Polarity Register */
  WoReg PMC_FOCR;     /**< \brief (Pmc Offset: 0x0078) Fault Output Clear Register */
} Pmc;
#endif /* __ASSEMBLY__ */
/* -------- PMC_SCER : (PMC Offset: 0x0000) System Clock Enable Register -------- */
#define PMC_SCER_PCK0 (0x1 << 8) /**< \brief (PMC_SCER) Programmable Clock 0 Output Enable */
#define PMC_SCER_PCK1 (0x1 << 9) /**< \brief (PMC_SCER) Programmable Clock 1 Output Enable */
#define PMC_SCER_PCK2 (0x1 << 10) /**< \brief (PMC_SCER) Programmable Clock 2 Output Enable */
/* -------- PMC_SCDR : (PMC Offset: 0x0004) System Clock Disable Register -------- */
#define PMC_SCDR_PCK0 (0x1 << 8) /**< \brief (PMC_SCDR) Programmable Clock 0 Output Disable */
#define PMC_SCDR_PCK1 (0x1 << 9) /**< \brief (PMC_SCDR) Programmable Clock 1 Output Disable */
#define PMC_SCDR_PCK2 (0x1 << 10) /**< \brief (PMC_SCDR) Programmable Clock 2 Output Disable */
/* -------- PMC_SCSR : (PMC Offset: 0x0008) System Clock Status Register -------- */
#define PMC_SCSR_PCK0 (0x1 << 8) /**< \brief (PMC_SCSR) Programmable Clock 0 Output Status */
#define PMC_SCSR_PCK1 (0x1 << 9) /**< \brief (PMC_SCSR) Programmable Clock 1 Output Status */
#define PMC_SCSR_PCK2 (0x1 << 10) /**< \brief (PMC_SCSR) Programmable Clock 2 Output Status */
/* -------- PMC_PCER : (PMC Offset: 0x0010) Peripheral Clock Enable Register -------- */
#define PMC_PCER_PID2 (0x1 << 2) /**< \brief (PMC_PCER) Peripheral Clock 2 Enable */
#define PMC_PCER_PID3 (0x1 << 3) /**< \brief (PMC_PCER) Peripheral Clock 3 Enable */
#define PMC_PCER_PID4 (0x1 << 4) /**< \brief (PMC_PCER) Peripheral Clock 4 Enable */
#define PMC_PCER_PID5 (0x1 << 5) /**< \brief (PMC_PCER) Peripheral Clock 5 Enable */
#define PMC_PCER_PID6 (0x1 << 6) /**< \brief (PMC_PCER) Peripheral Clock 6 Enable */
#define PMC_PCER_PID7 (0x1 << 7) /**< \brief (PMC_PCER) Peripheral Clock 7 Enable */
#define PMC_PCER_PID8 (0x1 << 8) /**< \brief (PMC_PCER) Peripheral Clock 8 Enable */
#define PMC_PCER_PID9 (0x1 << 9) /**< \brief (PMC_PCER) Peripheral Clock 9 Enable */
#define PMC_PCER_PID10 (0x1 << 10) /**< \brief (PMC_PCER) Peripheral Clock 10 Enable */
#define PMC_PCER_PID11 (0x1 << 11) /**< \brief (PMC_PCER) Peripheral Clock 11 Enable */
#define PMC_PCER_PID12 (0x1 << 12) /**< \brief (PMC_PCER) Peripheral Clock 12 Enable */
#define PMC_PCER_PID13 (0x1 << 13) /**< \brief (PMC_PCER) Peripheral Clock 13 Enable */
#define PMC_PCER_PID14 (0x1 << 14) /**< \brief (PMC_PCER) Peripheral Clock 14 Enable */
#define PMC_PCER_PID15 (0x1 << 15) /**< \brief (PMC_PCER) Peripheral Clock 15 Enable */
#define PMC_PCER_PID16 (0x1 << 16) /**< \brief (PMC_PCER) Peripheral Clock 16 Enable */
#define PMC_PCER_PID17 (0x1 << 17) /**< \brief (PMC_PCER) Peripheral Clock 17 Enable */
#define PMC_PCER_PID18 (0x1 << 18) /**< \brief (PMC_PCER) Peripheral Clock 18 Enable */
#define PMC_PCER_PID19 (0x1 << 19) /**< \brief (PMC_PCER) Peripheral Clock 19 Enable */
#define PMC_PCER_PID20 (0x1 << 20) /**< \brief (PMC_PCER) Peripheral Clock 20 Enable */
#define PMC_PCER_PID21 (0x1 << 21) /**< \brief (PMC_PCER) Peripheral Clock 21 Enable */
#define PMC_PCER_PID22 (0x1 << 22) /**< \brief (PMC_PCER) Peripheral Clock 22 Enable */
#define PMC_PCER_PID23 (0x1 << 23) /**< \brief (PMC_PCER) Peripheral Clock 23 Enable */
#define PMC_PCER_PID24 (0x1 << 24) /**< \brief (PMC_PCER) Peripheral Clock 24 Enable */
#define PMC_PCER_PID25 (0x1 << 25) /**< \brief (PMC_PCER) Peripheral Clock 25 Enable */
#define PMC_PCER_PID26 (0x1 << 26) /**< \brief (PMC_PCER) Peripheral Clock 26 Enable */
#define PMC_PCER_PID27 (0x1 << 27) /**< \brief (PMC_PCER) Peripheral Clock 27 Enable */
#define PMC_PCER_PID28 (0x1 << 28) /**< \brief (PMC_PCER) Peripheral Clock 28 Enable */
#define PMC_PCER_PID29 (0x1 << 29) /**< \brief (PMC_PCER) Peripheral Clock 29 Enable */
#define PMC_PCER_PID30 (0x1 << 30) /**< \brief (PMC_PCER) Peripheral Clock 30 Enable */
#define PMC_PCER_PID31 (0x1 << 31) /**< \brief (PMC_PCER) Peripheral Clock 31 Enable */
/* -------- PMC_PCDR : (PMC Offset: 0x0014) Peripheral Clock Disable Register -------- */
#define PMC_PCDR_PID2 (0x1 << 2) /**< \brief (PMC_PCDR) Peripheral Clock 2 Disable */
#define PMC_PCDR_PID3 (0x1 << 3) /**< \brief (PMC_PCDR) Peripheral Clock 3 Disable */
#define PMC_PCDR_PID4 (0x1 << 4) /**< \brief (PMC_PCDR) Peripheral Clock 4 Disable */
#define PMC_PCDR_PID5 (0x1 << 5) /**< \brief (PMC_PCDR) Peripheral Clock 5 Disable */
#define PMC_PCDR_PID6 (0x1 << 6) /**< \brief (PMC_PCDR) Peripheral Clock 6 Disable */
#define PMC_PCDR_PID7 (0x1 << 7) /**< \brief (PMC_PCDR) Peripheral Clock 7 Disable */
#define PMC_PCDR_PID8 (0x1 << 8) /**< \brief (PMC_PCDR) Peripheral Clock 8 Disable */
#define PMC_PCDR_PID9 (0x1 << 9) /**< \brief (PMC_PCDR) Peripheral Clock 9 Disable */
#define PMC_PCDR_PID10 (0x1 << 10) /**< \brief (PMC_PCDR) Peripheral Clock 10 Disable */
#define PMC_PCDR_PID11 (0x1 << 11) /**< \brief (PMC_PCDR) Peripheral Clock 11 Disable */
#define PMC_PCDR_PID12 (0x1 << 12) /**< \brief (PMC_PCDR) Peripheral Clock 12 Disable */
#define PMC_PCDR_PID13 (0x1 << 13) /**< \brief (PMC_PCDR) Peripheral Clock 13 Disable */
#define PMC_PCDR_PID14 (0x1 << 14) /**< \brief (PMC_PCDR) Peripheral Clock 14 Disable */
#define PMC_PCDR_PID15 (0x1 << 15) /**< \brief (PMC_PCDR) Peripheral Clock 15 Disable */
#define PMC_PCDR_PID16 (0x1 << 16) /**< \brief (PMC_PCDR) Peripheral Clock 16 Disable */
#define PMC_PCDR_PID17 (0x1 << 17) /**< \brief (PMC_PCDR) Peripheral Clock 17 Disable */
#define PMC_PCDR_PID18 (0x1 << 18) /**< \brief (PMC_PCDR) Peripheral Clock 18 Disable */
#define PMC_PCDR_PID19 (0x1 << 19) /**< \brief (PMC_PCDR) Peripheral Clock 19 Disable */
#define PMC_PCDR_PID20 (0x1 << 20) /**< \brief (PMC_PCDR) Peripheral Clock 20 Disable */
#define PMC_PCDR_PID21 (0x1 << 21) /**< \brief (PMC_PCDR) Peripheral Clock 21 Disable */
#define PMC_PCDR_PID22 (0x1 << 22) /**< \brief (PMC_PCDR) Peripheral Clock 22 Disable */
#define PMC_PCDR_PID23 (0x1 << 23) /**< \brief (PMC_PCDR) Peripheral Clock 23 Disable */
#define PMC_PCDR_PID24 (0x1 << 24) /**< \brief (PMC_PCDR) Peripheral Clock 24 Disable */
#define PMC_PCDR_PID25 (0x1 << 25) /**< \brief (PMC_PCDR) Peripheral Clock 25 Disable */
#define PMC_PCDR_PID26 (0x1 << 26) /**< \brief (PMC_PCDR) Peripheral Clock 26 Disable */
#define PMC_PCDR_PID27 (0x1 << 27) /**< \brief (PMC_PCDR) Peripheral Clock 27 Disable */
#define PMC_PCDR_PID28 (0x1 << 28) /**< \brief (PMC_PCDR) Peripheral Clock 28 Disable */
#define PMC_PCDR_PID29 (0x1 << 29) /**< \brief (PMC_PCDR) Peripheral Clock 29 Disable */
#define PMC_PCDR_PID30 (0x1 << 30) /**< \brief (PMC_PCDR) Peripheral Clock 30 Disable */
#define PMC_PCDR_PID31 (0x1 << 31) /**< \brief (PMC_PCDR) Peripheral Clock 31 Disable */
/* -------- PMC_PCSR : (PMC Offset: 0x0018) Peripheral Clock Status Register -------- */
#define PMC_PCSR_PID2 (0x1 << 2) /**< \brief (PMC_PCSR) Peripheral Clock 2 Status */
#define PMC_PCSR_PID3 (0x1 << 3) /**< \brief (PMC_PCSR) Peripheral Clock 3 Status */
#define PMC_PCSR_PID4 (0x1 << 4) /**< \brief (PMC_PCSR) Peripheral Clock 4 Status */
#define PMC_PCSR_PID5 (0x1 << 5) /**< \brief (PMC_PCSR) Peripheral Clock 5 Status */
#define PMC_PCSR_PID6 (0x1 << 6) /**< \brief (PMC_PCSR) Peripheral Clock 6 Status */
#define PMC_PCSR_PID7 (0x1 << 7) /**< \brief (PMC_PCSR) Peripheral Clock 7 Status */
#define PMC_PCSR_PID8 (0x1 << 8) /**< \brief (PMC_PCSR) Peripheral Clock 8 Status */
#define PMC_PCSR_PID9 (0x1 << 9) /**< \brief (PMC_PCSR) Peripheral Clock 9 Status */
#define PMC_PCSR_PID10 (0x1 << 10) /**< \brief (PMC_PCSR) Peripheral Clock 10 Status */
#define PMC_PCSR_PID11 (0x1 << 11) /**< \brief (PMC_PCSR) Peripheral Clock 11 Status */
#define PMC_PCSR_PID12 (0x1 << 12) /**< \brief (PMC_PCSR) Peripheral Clock 12 Status */
#define PMC_PCSR_PID13 (0x1 << 13) /**< \brief (PMC_PCSR) Peripheral Clock 13 Status */
#define PMC_PCSR_PID14 (0x1 << 14) /**< \brief (PMC_PCSR) Peripheral Clock 14 Status */
#define PMC_PCSR_PID15 (0x1 << 15) /**< \brief (PMC_PCSR) Peripheral Clock 15 Status */
#define PMC_PCSR_PID16 (0x1 << 16) /**< \brief (PMC_PCSR) Peripheral Clock 16 Status */
#define PMC_PCSR_PID17 (0x1 << 17) /**< \brief (PMC_PCSR) Peripheral Clock 17 Status */
#define PMC_PCSR_PID18 (0x1 << 18) /**< \brief (PMC_PCSR) Peripheral Clock 18 Status */
#define PMC_PCSR_PID19 (0x1 << 19) /**< \brief (PMC_PCSR) Peripheral Clock 19 Status */
#define PMC_PCSR_PID20 (0x1 << 20) /**< \brief (PMC_PCSR) Peripheral Clock 20 Status */
#define PMC_PCSR_PID21 (0x1 << 21) /**< \brief (PMC_PCSR) Peripheral Clock 21 Status */
#define PMC_PCSR_PID22 (0x1 << 22) /**< \brief (PMC_PCSR) Peripheral Clock 22 Status */
#define PMC_PCSR_PID23 (0x1 << 23) /**< \brief (PMC_PCSR) Peripheral Clock 23 Status */
#define PMC_PCSR_PID24 (0x1 << 24) /**< \brief (PMC_PCSR) Peripheral Clock 24 Status */
#define PMC_PCSR_PID25 (0x1 << 25) /**< \brief (PMC_PCSR) Peripheral Clock 25 Status */
#define PMC_PCSR_PID26 (0x1 << 26) /**< \brief (PMC_PCSR) Peripheral Clock 26 Status */
#define PMC_PCSR_PID27 (0x1 << 27) /**< \brief (PMC_PCSR) Peripheral Clock 27 Status */
#define PMC_PCSR_PID28 (0x1 << 28) /**< \brief (PMC_PCSR) Peripheral Clock 28 Status */
#define PMC_PCSR_PID29 (0x1 << 29) /**< \brief (PMC_PCSR) Peripheral Clock 29 Status */
#define PMC_PCSR_PID30 (0x1 << 30) /**< \brief (PMC_PCSR) Peripheral Clock 30 Status */
#define PMC_PCSR_PID31 (0x1 << 31) /**< \brief (PMC_PCSR) Peripheral Clock 31 Status */
/* -------- CKGR_UCKR : (PMC Offset: 0x001C) UTMI Clock Register -------- */
#define CKGR_UCKR_UPLLEN (0x1 << 16) /**< \brief (CKGR_UCKR) UTMI PLL Enable */
#define CKGR_UCKR_UPLLCOUNT (0xf << 20) /**< \brief (CKGR_UCKR) UTMI PLL Start-up Time */
/* -------- CKGR_MOR : (PMC Offset: 0x0020) Main Oscillator Register -------- */
#define CKGR_MOR_MOSCXTEN (0x1 << 0) /**< \brief (CKGR_MOR) Main Crystal Oscillator Enable */
#define CKGR_MOR_MOSCXTBY (0x1 << 1) /**< \brief (CKGR_MOR) Main Crystal Oscillator Bypass */
#define CKGR_MOR_WAITMODE (0x1 << 2) /**< \brief (CKGR_MOR) Wait Mode Command */
#define CKGR_MOR_MOSCRCEN (0x1 << 3) /**< \brief (CKGR_MOR) Main On-Chip RC Oscillator Enable */
#define CKGR_MOR_MOSCRCF (0x7 << 4) /**< \brief (CKGR_MOR) Main On-Chip RC Oscillator Frequency Selection */
#define CKGR_MOR_MOSCXTST (0xff << 8) /**< \brief (CKGR_MOR) Main Crystal Oscillator Start-up Time */
#define CKGR_MOR_KEY (0xff << 16) /**< \brief (CKGR_MOR) Password */
#define CKGR_MOR_MOSCSEL (0x1 << 24) /**< \brief (CKGR_MOR) Main Oscillator Selection */
#define CKGR_MOR_CFDEN (0x1 << 25) /**< \brief (CKGR_MOR) Clock Failure Detector Enable */
/* -------- CKGR_MCFR : (PMC Offset: 0x0024) Main Clock Frequency Register -------- */
#define CKGR_MCFR_MAINF (0xffff << 0) /**< \brief (CKGR_MCFR) Main Clock Frequency */
#define CKGR_MCFR_MAINFRDY (0x1 << 16) /**< \brief (CKGR_MCFR) Main Clock Ready */
/* -------- CKGR_PLLAR : (PMC Offset: 0x0028) PLLA Register -------- */
#define CKGR_PLLAR_DIVA (0xff << 0) /**< \brief (CKGR_PLLAR) Divider */
#define CKGR_PLLAR_PLLACOUNT (0x3f << 8) /**< \brief (CKGR_PLLAR) PLLA Counter */
#define CKGR_PLLAR_STMODE (0x3 << 14) /**< \brief (CKGR_PLLAR) Start Mode */
#define CKGR_PLLAR_MULA (0x7ff << 16) /**< \brief (CKGR_PLLAR) PLLA Multiplier */
#define CKGR_PLLAR_STUCKTO1 (0x1 << 29) /**< \brief (CKGR_PLLAR)  */
/* -------- PMC_MCKR : (PMC Offset: 0x0030) Master Clock Register -------- */
#define PMC_MCKR_CSS (0x3 << 0) /**< \brief (PMC_MCKR) Master Clock Source Selection */
#define   PMC_MCKR_CSS_SLOW_CLK (0x0 << 0) /**< \brief (PMC_MCKR) Slow Clock is selected */
#define   PMC_MCKR_CSS_MAIN_CLK (0x1 << 0) /**< \brief (PMC_MCKR) Main Clock is selected */
#define   PMC_MCKR_CSS_PLLA_CLK (0x2 << 0) /**< \brief (PMC_MCKR) PLLA Clock is selected */
#define   PMC_MCKR_CSS_PLLB_CLK (0x3 << 0) /**< \brief (PMC_MCKR) UPLL Clock is selected */
#define PMC_MCKR_PRES (0x7 << 4) /**< \brief (PMC_MCKR) Processor Clock Prescaler */
#define   PMC_MCKR_PRES_CLK (0x0 << 4) /**< \brief (PMC_MCKR) Selected clock */
#define   PMC_MCKR_PRES_CLK_2 (0x1 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 2 */
#define   PMC_MCKR_PRES_CLK_4 (0x2 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 4 */
#define   PMC_MCKR_PRES_CLK_8 (0x3 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 8 */
#define   PMC_MCKR_PRES_CLK_16 (0x4 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 16 */
#define   PMC_MCKR_PRES_CLK_32 (0x5 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 32 */
#define   PMC_MCKR_PRES_CLK_64 (0x6 << 4) /**< \brief (PMC_MCKR) Selected clock divided by 64 */
/* -------- PMC_PCK[3] : (PMC Offset: 0x0040) Programmable Clock 0 Register -------- */
#define PMC_PCK_CSS (0x7 << 0) /**< \brief (PMC_PCK[3]) Master Clock Source Selection */
#define PMC_PCK_PRES (0x7 << 4) /**< \brief (PMC_PCK[3]) Programmable Clock Prescaler */
/* -------- PMC_IER : (PMC Offset: 0x0060) Interrupt Enable Register -------- */
#define PMC_IER_MOSCXTS (0x1 << 0) /**< \brief (PMC_IER) Main Crystal Oscillator Status Interrupt Enable */
#define PMC_IER_LOCKA (0x1 << 1) /**< \brief (PMC_IER) PLL A Lock Interrupt Enable */
#define PMC_IER_MCKRDY (0x1 << 3) /**< \brief (PMC_IER) Master Clock Ready Interrupt Enable */
#define PMC_IER_LOCKU (0x1 << 6) /**< \brief (PMC_IER) UTMI PLL Lock Interrupt Enable */
#define PMC_IER_PCKRDY0 (0x1 << 8) /**< \brief (PMC_IER) Programmable Clock Ready 0 Interrupt Enable */
#define PMC_IER_PCKRDY1 (0x1 << 9) /**< \brief (PMC_IER) Programmable Clock Ready 1 Interrupt Enable */
#define PMC_IER_PCKRDY2 (0x1 << 10) /**< \brief (PMC_IER) Programmable Clock Ready 2 Interrupt Enable */
#define PMC_IER_MOSCSELS (0x1 << 16) /**< \brief (PMC_IER) Main Oscillator Selection Status Interrupt Enable */
#define PMC_IER_MOSCRCS (0x1 << 17) /**< \brief (PMC_IER) Main On-Chip RC Status Interrupt Enable */
#define PMC_IER_CFDEV (0x1 << 18) /**< \brief (PMC_IER) Clock Failure Detector Event Interrupt Enable */
/* -------- PMC_IDR : (PMC Offset: 0x0064) Interrupt Disable Register -------- */
#define PMC_IDR_MOSCXTS (0x1 << 0) /**< \brief (PMC_IDR) Main Crystal Oscillator Status Interrupt Disable */
#define PMC_IDR_LOCKA (0x1 << 1) /**< \brief (PMC_IDR) PLL A Lock Interrupt Disable */
#define PMC_IDR_MCKRDY (0x1 << 3) /**< \brief (PMC_IDR) Master Clock Ready Interrupt Disable */
#define PMC_IDR_LOCKU (0x1 << 6) /**< \brief (PMC_IDR) UTMI PLL Lock Interrupt Disable */
#define PMC_IDR_PCKRDY0 (0x1 << 8) /**< \brief (PMC_IDR) Programmable Clock Ready 0 Interrupt Disable */
#define PMC_IDR_PCKRDY1 (0x1 << 9) /**< \brief (PMC_IDR) Programmable Clock Ready 1 Interrupt Disable */
#define PMC_IDR_PCKRDY2 (0x1 << 10) /**< \brief (PMC_IDR) Programmable Clock Ready 2 Interrupt Disable */
#define PMC_IDR_MOSCSELS (0x1 << 16) /**< \brief (PMC_IDR) Main Oscillator Selection Status Interrupt Disable */
#define PMC_IDR_MOSCRCS (0x1 << 17) /**< \brief (PMC_IDR) Main On-Chip RC Status Interrupt Disable */
#define PMC_IDR_CFDEV (0x1 << 18) /**< \brief (PMC_IDR) Clock Failure Detector Event Interrupt Disable */
/* -------- PMC_SR : (PMC Offset: 0x0068) Status Register -------- */
#define PMC_SR_MOSCXTS (0x1 << 0) /**< \brief (PMC_SR) Main XTAL Oscillator Status */
#define PMC_SR_LOCKA (0x1 << 1) /**< \brief (PMC_SR) PLL A Lock Status */
#define PMC_SR_MCKRDY (0x1 << 3) /**< \brief (PMC_SR) Master Clock Status */
#define PMC_SR_LOCKU (0x1 << 6) /**< \brief (PMC_SR) UTMI PLL Lock Status */
#define PMC_SR_OSCSELS (0x1 << 7) /**< \brief (PMC_SR) Slow Clock Oscillator Selection */
#define PMC_SR_PCKRDY0 (0x1 << 8) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_PCKRDY1 (0x1 << 9) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_PCKRDY2 (0x1 << 10) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_MOSCSELS (0x1 << 16) /**< \brief (PMC_SR) Main Oscillator Selection Status */
#define PMC_SR_MOSCRCS (0x1 << 17) /**< \brief (PMC_SR) Main On-Chip RC Oscillator Status */
#define PMC_SR_CFDEV (0x1 << 18) /**< \brief (PMC_SR) Clock Failure Detector Event */
#define PMC_SR_CFDS (0x1 << 19) /**< \brief (PMC_SR) Clock Failure Detector Status */
#define PMC_SR_FOS (0x1 << 20) /**< \brief (PMC_SR) Clock Failure Detector Fault Output Status */
/* -------- PMC_IMR : (PMC Offset: 0x006C) Interrupt Mask Register -------- */
#define PMC_IMR_MOSCXTS (0x1 << 0) /**< \brief (PMC_IMR) Main Crystal Oscillator Status Interrupt Mask */
#define PMC_IMR_LOCKA (0x1 << 1) /**< \brief (PMC_IMR) PLL A Lock Interrupt Mask */
#define PMC_IMR_MCKRDY (0x1 << 3) /**< \brief (PMC_IMR) Master Clock Ready Interrupt Mask */
#define PMC_IMR_LOCKU (0x1 << 6) /**< \brief (PMC_IMR) UTMI PLL Lock Interrupt Mask */
#define PMC_IMR_PCKRDY0 (0x1 << 8) /**< \brief (PMC_IMR) Programmable Clock Ready 0 Interrupt Mask */
#define PMC_IMR_PCKRDY1 (0x1 << 9) /**< \brief (PMC_IMR) Programmable Clock Ready 1 Interrupt Mask */
#define PMC_IMR_PCKRDY2 (0x1 << 10) /**< \brief (PMC_IMR) Programmable Clock Ready 2 Interrupt Mask */
#define PMC_IMR_MOSCSELS (0x1 << 16) /**< \brief (PMC_IMR) Main Oscillator Selection Status Interrupt Mask */
#define PMC_IMR_MOSCRCS (0x1 << 17) /**< \brief (PMC_IMR) Main On-Chip RC Status Interrupt Mask */
#define PMC_IMR_CFDEV (0x1 << 18) /**< \brief (PMC_IMR) Clock Failure Detector Event Interrupt Mask */
/* -------- PMC_FSMR : (PMC Offset: 0x0070) Fast Startup Mode Register -------- */
#define PMC_FSMR_FSTT0 (0x1 << 0) /**< \brief (PMC_FSMR) Fast Startup Input Enable 0 */
#define PMC_FSMR_FSTT1 (0x1 << 1) /**< \brief (PMC_FSMR) Fast Startup Input Enable 1 */
#define PMC_FSMR_FSTT2 (0x1 << 2) /**< \brief (PMC_FSMR) Fast Startup Input Enable 2 */
#define PMC_FSMR_FSTT3 (0x1 << 3) /**< \brief (PMC_FSMR) Fast Startup Input Enable 3 */
#define PMC_FSMR_FSTT4 (0x1 << 4) /**< \brief (PMC_FSMR) Fast Startup Input Enable 4 */
#define PMC_FSMR_FSTT5 (0x1 << 5) /**< \brief (PMC_FSMR) Fast Startup Input Enable 5 */
#define PMC_FSMR_FSTT6 (0x1 << 6) /**< \brief (PMC_FSMR) Fast Startup Input Enable 6 */
#define PMC_FSMR_FSTT7 (0x1 << 7) /**< \brief (PMC_FSMR) Fast Startup Input Enable 7 */
#define PMC_FSMR_FSTT8 (0x1 << 8) /**< \brief (PMC_FSMR) Fast Startup Input Enable 8 */
#define PMC_FSMR_FSTT9 (0x1 << 9) /**< \brief (PMC_FSMR) Fast Startup Input Enable 9 */
#define PMC_FSMR_FSTT10 (0x1 << 10) /**< \brief (PMC_FSMR) Fast Startup Input Enable 10 */
#define PMC_FSMR_FSTT11 (0x1 << 11) /**< \brief (PMC_FSMR) Fast Startup Input Enable 11 */
#define PMC_FSMR_FSTT12 (0x1 << 12) /**< \brief (PMC_FSMR) Fast Startup Input Enable 12 */
#define PMC_FSMR_FSTT13 (0x1 << 13) /**< \brief (PMC_FSMR) Fast Startup Input Enable 13 */
#define PMC_FSMR_FSTT14 (0x1 << 14) /**< \brief (PMC_FSMR) Fast Startup Input Enable 14 */
#define PMC_FSMR_FSTT15 (0x1 << 15) /**< \brief (PMC_FSMR) Fast Startup Input Enable 15 */
#define PMC_FSMR_RTTAL (0x1 << 16) /**< \brief (PMC_FSMR) RTT Alarm Enable */
#define PMC_FSMR_RTCAL (0x1 << 17) /**< \brief (PMC_FSMR) RTC Alarm Enable */
#define PMC_FSMR_USBAL (0x1 << 18) /**< \brief (PMC_FSMR) USB Alarm Enable */
#define PMC_FSMR_LPM (0x1 << 20) /**< \brief (PMC_FSMR) Low Power Mode */
/* -------- PMC_FSPR : (PMC Offset: 0x0074) Fast Startup Polarity Register -------- */
#define PMC_FSPR_FSTP0 (0x1 << 0) /**< \brief (PMC_FSPR) Fast Startup Input Polarity 0 */
#define PMC_FSPR_FSTP1 (0x1 << 1) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP2 (0x1 << 2) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP3 (0x1 << 3) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP4 (0x1 << 4) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP5 (0x1 << 5) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP6 (0x1 << 6) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP7 (0x1 << 7) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP8 (0x1 << 8) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP9 (0x1 << 9) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP10 (0x1 << 10) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP11 (0x1 << 11) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP12 (0x1 << 12) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP13 (0x1 << 13) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP14 (0x1 << 14) /**< \brief (PMC_FSPR)  */
#define PMC_FSPR_FSTP15 (0x1 << 15) /**< \brief (PMC_FSPR)  */
/* -------- PMC_FOCR : (PMC Offset: 0x0078) Fault Output Clear Register -------- */
#define PMC_FOCR_FOCLR (0x1 << 0) /**< \brief (PMC_FOCR) Fault Output Clear */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Pulse Width Modulation Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_PWM Pulse Width Modulation Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief PwmCh_num hardware registers */
typedef struct {
  RwReg      PWM_CMR;       /**< \brief (PwmCh_num Offset: 0x0) PWM Channel Mode Register */
  RwReg      PWM_CDTY;      /**< \brief (PwmCh_num Offset: 0x4) PWM Channel Duty Cycle Register */
  RwReg      PWM_CDTYUPD;   /**< \brief (PwmCh_num Offset: 0x8) PWM Channel Duty Cycle Update Register */
  RwReg      PWM_CPRD;      /**< \brief (PwmCh_num Offset: 0xC) PWM Channel Period Register */
  RwReg      PWM_CPRDUPD;   /**< \brief (PwmCh_num Offset: 0x10) PWM Channel Period Update Register */
  RwReg      PWM_CCNT;      /**< \brief (PwmCh_num Offset: 0x14) PWM Channel Counter Register */
  RwReg      PWM_DT;        /**< \brief (PwmCh_num Offset: 0x18) PWM Channel Dead Time Register */
  RwReg      PWM_DTUPD;     /**< \brief (PwmCh_num Offset: 0x1C) PWM Channel Dead Time Update Register */
} PwmCh_num;
/** \brief Pwm hardware registers */
typedef struct {
  RwReg      PWM_CLK;       /**< \brief (Pwm Offset: 0x00) PWM Clock Register */
  WoReg      PWM_ENA;       /**< \brief (Pwm Offset: 0x04) PWM Enable Register */
  WoReg      PWM_DIS;       /**< \brief (Pwm Offset: 0x08) PWM Disable Register */
  RoReg      PWM_SR;        /**< \brief (Pwm Offset: 0x0C) PWM Status Register */
  WoReg      PWM_IER1;      /**< \brief (Pwm Offset: 0x10) PWM Interrupt Enable Register 1 */
  WoReg      PWM_IDR1;      /**< \brief (Pwm Offset: 0x14) PWM Interrupt Disable Register 1 */
  RoReg      PWM_IMR1;      /**< \brief (Pwm Offset: 0x18) PWM Interrupt Mask Register 1 */
  RoReg      PWM_ISR1;      /**< \brief (Pwm Offset: 0x1C) PWM Interrupt Status Register 1 */
  RwReg      PWM_SCM;       /**< \brief (Pwm Offset: 0x20) PWM Sync Channels Mode Register */
  RwReg      Reserved1[1]; 
  RwReg      PWM_SCUC;      /**< \brief (Pwm Offset: 0x28) PWM Sync Channels Update Control Register */
  RwReg      PWM_SCUP;      /**< \brief (Pwm Offset: 0x2C) PWM Sync Channels Update Period Register */
  WoReg      PWM_SCUPUPD;   /**< \brief (Pwm Offset: 0x30) PWM Sync Channels Update Period Update Register */
  WoReg      PWM_IER2;      /**< \brief (Pwm Offset: 0x34) PWM Interrupt Enable Register 2 */
  WoReg      PWM_IDR2;      /**< \brief (Pwm Offset: 0x38) PWM Interrupt Disable Register 2 */
  RoReg      PWM_IMR2;      /**< \brief (Pwm Offset: 0x3C) PWM Interrupt Mask Register 2 */
  RoReg      PWM_ISR2;      /**< \brief (Pwm Offset: 0x40) PWM Interrupt Status Register 2 */
  RwReg      PWM_OOV;       /**< \brief (Pwm Offset: 0x44) PWM Output Override Value Register */
  RwReg      PWM_OS;        /**< \brief (Pwm Offset: 0x48) PWM Output Selection Register */
  WoReg      PWM_OSS;       /**< \brief (Pwm Offset: 0x4C) PWM Output Selection Set Register */
  WoReg      PWM_OSC;       /**< \brief (Pwm Offset: 0x50) PWM Output Selection Clear Register */
  WoReg      PWM_OSSUPD;    /**< \brief (Pwm Offset: 0x54) PWM Output Selection Set Update Register */
  WoReg      PWM_OSCUPD;    /**< \brief (Pwm Offset: 0x58) PWM Output Selection Clear Update Register */
  RwReg      PWM_FMR;       /**< \brief (Pwm Offset: 0x5C) PWM Fault Mode Register */
  RoReg      PWM_FSR;       /**< \brief (Pwm Offset: 0x60) PWM Fault Status Register */
  WoReg      PWM_FCR;       /**< \brief (Pwm Offset: 0x64) PWM Fault Clear Register */
  RwReg      PWM_FPV;       /**< \brief (Pwm Offset: 0x68) PWM Fault Protection Value Register */
  RwReg      PWM_FPE;       /**< \brief (Pwm Offset: 0x6C) PWM Fault Protection Enable Register */
  RwReg      Reserved2[3]; 
  RwReg      PWM_ELxMR[2];  /**< \brief (Pwm Offset: 0x7C) PWM Event Line 0 Mode Register */
  RwReg      Reserved3[24];
  WoReg      PWM_WPCR;      /**< \brief (Pwm Offset: 0xE4) PWM Write Protect Control Register */
  RoReg      PWM_WPSR;      /**< \brief (Pwm Offset: 0xE8) PWM Write Protect Status Register */
  RwReg      Reserved4[5]; 
  RwReg      PWM_RPR;       /**< \brief (Pwm Offset: 0x100) Receive Pointer Register */
  RwReg      PWM_RCR;       /**< \brief (Pwm Offset: 0x104) Receive Counter Register */
  RwReg      PWM_TPR;       /**< \brief (Pwm Offset: 0x108) Transmit Pointer Register */
  RwReg      PWM_TCR;       /**< \brief (Pwm Offset: 0x10C) Transmit Counter Register */
  RwReg      PWM_RNPR;      /**< \brief (Pwm Offset: 0x110) Receive Next Pointer Register */
  RwReg      PWM_RNCR;      /**< \brief (Pwm Offset: 0x114) Receive Next Counter Register */
  RwReg      PWM_TNPR;      /**< \brief (Pwm Offset: 0x118) Transmit Next Pointer Register */
  RwReg      PWM_TNCR;      /**< \brief (Pwm Offset: 0x11C) Transmit Next Counter Register */
  WoReg      PWM_PTCR;      /**< \brief (Pwm Offset: 0x120) Transfer Control Register */
  RoReg      PWM_PTSR;      /**< \brief (Pwm Offset: 0x124) Transfer Status Register */
  RwReg      Reserved5[2]; 
  RwReg      PWM_CMP0V;     /**< \brief (Pwm Offset: 0x130) PWM Comparison 0 Value Register */
  WoReg      PWM_CMP0VUPD;  /**< \brief (Pwm Offset: 0x134) PWM Comparison 0 Value Update Register */
  RwReg      PWM_CMP0M;     /**< \brief (Pwm Offset: 0x138) PWM Comparison 0 Mode Register */
  WoReg      PWM_CMP0MUPD;  /**< \brief (Pwm Offset: 0x13C) PWM Comparison 0 Mode Update Register */
  RwReg      PWM_CMP1V;     /**< \brief (Pwm Offset: 0x140) PWM Comparison 1 Value Register */
  WoReg      PWM_CMP1VUPD;  /**< \brief (Pwm Offset: 0x144) PWM Comparison 1 Value Update Register */
  RwReg      PWM_CMP1M;     /**< \brief (Pwm Offset: 0x148) PWM Comparison 1 Mode Register */
  WoReg      PWM_CMP1MUPD;  /**< \brief (Pwm Offset: 0x14C) PWM Comparison 1 Mode Update Register */
  RwReg      PWM_CMP2V;     /**< \brief (Pwm Offset: 0x150) PWM Comparison 2 Value Register */
  WoReg      PWM_CMP2VUPD;  /**< \brief (Pwm Offset: 0x154) PWM Comparison 2 Value Update Register */
  RwReg      PWM_CMP2M;     /**< \brief (Pwm Offset: 0x158) PWM Comparison 2 Mode Register */
  WoReg      PWM_CMP2MUPD;  /**< \brief (Pwm Offset: 0x15C) PWM Comparison 2 Mode Update Register */
  RwReg      PWM_CMP3V;     /**< \brief (Pwm Offset: 0x160) PWM Comparison 3 Value Register */
  WoReg      PWM_CMP3VUPD;  /**< \brief (Pwm Offset: 0x164) PWM Comparison 3 Value Update Register */
  RwReg      PWM_CMP3M;     /**< \brief (Pwm Offset: 0x168) PWM Comparison 3 Mode Register */
  WoReg      PWM_CMP3MUPD;  /**< \brief (Pwm Offset: 0x16C) PWM Comparison 3 Mode Update Register */
  RwReg      PWM_CMP4V;     /**< \brief (Pwm Offset: 0x170) PWM Comparison 4 Value Register */
  WoReg      PWM_CMP4VUPD;  /**< \brief (Pwm Offset: 0x174) PWM Comparison 4 Value Update Register */
  RwReg      PWM_CMP4M;     /**< \brief (Pwm Offset: 0x178) PWM Comparison 4 Mode Register */
  WoReg      PWM_CMP4MUPD;  /**< \brief (Pwm Offset: 0x17C) PWM Comparison 4 Mode Update Register */
  RwReg      PWM_CMP5V;     /**< \brief (Pwm Offset: 0x180) PWM Comparison 5 Value Register */
  WoReg      PWM_CMP5VUPD;  /**< \brief (Pwm Offset: 0x184) PWM Comparison 5 Value Update Register */
  RwReg      PWM_CMP5M;     /**< \brief (Pwm Offset: 0x188) PWM Comparison 5 Mode Register */
  WoReg      PWM_CMP5MUPD;  /**< \brief (Pwm Offset: 0x18C) PWM Comparison 5 Mode Update Register */
  RwReg      PWM_CMP6V;     /**< \brief (Pwm Offset: 0x190) PWM Comparison 6 Value Register */
  WoReg      PWM_CMP6VUPD;  /**< \brief (Pwm Offset: 0x194) PWM Comparison 6 Value Update Register */
  RwReg      PWM_CMP6M;     /**< \brief (Pwm Offset: 0x198) PWM Comparison 6 Mode Register */
  WoReg      PWM_CMP6MUPD;  /**< \brief (Pwm Offset: 0x19C) PWM Comparison 6 Mode Update Register */
  RwReg      PWM_CMP7V;     /**< \brief (Pwm Offset: 0x1A0) PWM Comparison 7 Value Register */
  WoReg      PWM_CMP7VUPD;  /**< \brief (Pwm Offset: 0x1A4) PWM Comparison 7 Value Update Register */
  RwReg      PWM_CMP7M;     /**< \brief (Pwm Offset: 0x1A8) PWM Comparison 7 Mode Register */
  WoReg      PWM_CMP7MUPD;  /**< \brief (Pwm Offset: 0x1AC) PWM Comparison 7 Mode Update Register */
  RwReg      Reserved6[20];
  PwmCh_num  PWM_CH_NUM[4]; /**< \brief (Pwm Offset: 0x200) ch_num = 0 .. 3 */
} Pwm;
#endif /* __ASSEMBLY__ */
/* -------- PWM_CLK : (PWM Offset: 0x00) PWM Clock Register -------- */
#define PWM_CLK_DIVA (0xff << 0) /**< \brief (PWM_CLK) CLKA, CLKB Divide Factor */
#define PWM_CLK_PREA (0xf << 8) /**< \brief (PWM_CLK) CLKA, CLKB Source Clock Selection */
#define PWM_CLK_DIVB (0xff << 16) /**< \brief (PWM_CLK) CLKA, CLKB Divide Factor */
#define PWM_CLK_PREB (0xf << 24) /**< \brief (PWM_CLK) CLKA, CLKB Source Clock Selection */
/* -------- PWM_ENA : (PWM Offset: 0x04) PWM Enable Register -------- */
#define PWM_ENA_CHID0 (0x1 << 0) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID1 (0x1 << 1) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID2 (0x1 << 2) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID3 (0x1 << 3) /**< \brief (PWM_ENA) Channel ID */
/* -------- PWM_DIS : (PWM Offset: 0x08) PWM Disable Register -------- */
#define PWM_DIS_CHID0 (0x1 << 0) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID1 (0x1 << 1) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID2 (0x1 << 2) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID3 (0x1 << 3) /**< \brief (PWM_DIS) Channel ID */
/* -------- PWM_SR : (PWM Offset: 0x0C) PWM Status Register -------- */
#define PWM_SR_CHID0 (0x1 << 0) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID1 (0x1 << 1) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID2 (0x1 << 2) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID3 (0x1 << 3) /**< \brief (PWM_SR) Channel ID */
/* -------- PWM_IER1 : (PWM Offset: 0x10) PWM Interrupt Enable Register 1 -------- */
#define PWM_IER1_CHID0 (0x1 << 0) /**< \brief (PWM_IER1) Counter Event on Channel 0 Interrupt Enable */
#define PWM_IER1_CHID1 (0x1 << 1) /**< \brief (PWM_IER1) Counter Event on Channel 1 Interrupt Enable */
#define PWM_IER1_CHID2 (0x1 << 2) /**< \brief (PWM_IER1) Counter Event on Channel 2 Interrupt Enable */
#define PWM_IER1_CHID3 (0x1 << 3) /**< \brief (PWM_IER1) Counter Event on Channel 3 Interrupt Enable */
#define PWM_IER1_FCHID0 (0x1 << 16) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 0 Interrupt Enable */
#define PWM_IER1_FCHID1 (0x1 << 17) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 1 Interrupt Enable */
#define PWM_IER1_FCHID2 (0x1 << 18) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 2 Interrupt Enable */
#define PWM_IER1_FCHID3 (0x1 << 19) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 3 Interrupt Enable */
/* -------- PWM_IDR1 : (PWM Offset: 0x14) PWM Interrupt Disable Register 1 -------- */
#define PWM_IDR1_CHID0 (0x1 << 0) /**< \brief (PWM_IDR1) Counter Event on Channel 0 Interrupt Disable */
#define PWM_IDR1_CHID1 (0x1 << 1) /**< \brief (PWM_IDR1) Counter Event on Channel 1 Interrupt Disable */
#define PWM_IDR1_CHID2 (0x1 << 2) /**< \brief (PWM_IDR1) Counter Event on Channel 2 Interrupt Disable */
#define PWM_IDR1_CHID3 (0x1 << 3) /**< \brief (PWM_IDR1) Counter Event on Channel 3 Interrupt Disable */
#define PWM_IDR1_FCHID0 (0x1 << 16) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 0 Interrupt Disable */
#define PWM_IDR1_FCHID1 (0x1 << 17) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 1 Interrupt Disable */
#define PWM_IDR1_FCHID2 (0x1 << 18) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 2 Interrupt Disable */
#define PWM_IDR1_FCHID3 (0x1 << 19) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 3 Interrupt Disable */
/* -------- PWM_IMR1 : (PWM Offset: 0x18) PWM Interrupt Mask Register 1 -------- */
#define PWM_IMR1_CHID0 (0x1 << 0) /**< \brief (PWM_IMR1) Counter Event on Channel 0 Interrupt Mask */
#define PWM_IMR1_CHID1 (0x1 << 1) /**< \brief (PWM_IMR1) Counter Event on Channel 1 Interrupt Mask */
#define PWM_IMR1_CHID2 (0x1 << 2) /**< \brief (PWM_IMR1) Counter Event on Channel 2 Interrupt Mask */
#define PWM_IMR1_CHID3 (0x1 << 3) /**< \brief (PWM_IMR1) Counter Event on Channel 3 Interrupt Mask */
#define PWM_IMR1_FCHID0 (0x1 << 16) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 0 Interrupt Mask */
#define PWM_IMR1_FCHID1 (0x1 << 17) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 1 Interrupt Mask */
#define PWM_IMR1_FCHID2 (0x1 << 18) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 2 Interrupt Mask */
#define PWM_IMR1_FCHID3 (0x1 << 19) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 3 Interrupt Mask */
/* -------- PWM_ISR1 : (PWM Offset: 0x1C) PWM Interrupt Status Register 1 -------- */
#define PWM_ISR1_CHID0 (0x1 << 0) /**< \brief (PWM_ISR1) Counter Event on Channel 0 */
#define PWM_ISR1_CHID1 (0x1 << 1) /**< \brief (PWM_ISR1) Counter Event on Channel 1 */
#define PWM_ISR1_CHID2 (0x1 << 2) /**< \brief (PWM_ISR1) Counter Event on Channel 2 */
#define PWM_ISR1_CHID3 (0x1 << 3) /**< \brief (PWM_ISR1) Counter Event on Channel 3 */
#define PWM_ISR1_FCHID0 (0x1 << 16) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 0 */
#define PWM_ISR1_FCHID1 (0x1 << 17) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 1 */
#define PWM_ISR1_FCHID2 (0x1 << 18) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 2 */
#define PWM_ISR1_FCHID3 (0x1 << 19) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 3 */
/* -------- PWM_SCM : (PWM Offset: 0x20) PWM Sync Channels Mode Register -------- */
#define PWM_SCM_SYNC0 (0x1 << 0) /**< \brief (PWM_SCM) Synchronous Channel 0 */
#define PWM_SCM_SYNC1 (0x1 << 1) /**< \brief (PWM_SCM) Synchronous Channel 1 */
#define PWM_SCM_SYNC2 (0x1 << 2) /**< \brief (PWM_SCM) Synchronous Channel 2 */
#define PWM_SCM_SYNC3 (0x1 << 3) /**< \brief (PWM_SCM) Synchronous Channel 3 */
#define PWM_SCM_UPDM (0x3 << 16) /**< \brief (PWM_SCM) Synchronous Channels Update Mode */
#define 	PWM_SCM_UPDM_MODE0                (0x0 << 16) // (PWMC) Manual write of data and manual trigger of the update
#define 	PWM_SCM_UPDM_MODE1                (0x1 << 16) // (PWMC) Manual write of data and automatic trigger of the update
#define 	PWM_SCM_UPDM_MODE2                (0x2 << 16) // (PWMC) Automatic write of data and automatic trigger of the update
#define PWM_SCM_PTRM (0x1 << 20) /**< \brief (PWM_SCM) PDC Transfer Request Mode */
#define PWM_SCM_PTRCS (0x7 << 21) /**< \brief (PWM_SCM) PDC Transfer Request Comparison Selection */
/* -------- PWM_SCUC : (PWM Offset: 0x28) PWM Sync Channels Update Control Register -------- */
#define PWM_SCUC_UPDULOCK (0x1 << 0) /**< \brief (PWM_SCUC) Synchronous Channels Update Unlock */
/* -------- PWM_SCUP : (PWM Offset: 0x2C) PWM Sync Channels Update Period Register -------- */
#define PWM_SCUP_UPR (0xf << 0) /**< \brief (PWM_SCUP) Update Period */
#define PWM_SCUP_UPRCNT (0xf << 4) /**< \brief (PWM_SCUP) Update Period Counter */
/* -------- PWM_SCUPUPD : (PWM Offset: 0x30) PWM Sync Channels Update Period Update Register -------- */
#define PWM_SCUPUPD_UPRUPD (0xf << 0) /**< \brief (PWM_SCUPUPD) Update Period Update */
/* -------- PWM_IER2 : (PWM Offset: 0x34) PWM Interrupt Enable Register 2 -------- */
#define PWM_IER2_WRDY (0x1 << 0) /**< \brief (PWM_IER2) Write Ready for Synchronous Channels Update Interrupt Enable */
#define PWM_IER2_ENDTX (0x1 << 1) /**< \brief (PWM_IER2) PDC End of TX Buffer Interrupt Enable */
#define PWM_IER2_TXBUFE (0x1 << 2) /**< \brief (PWM_IER2) PDC TX Buffer Empty Interrupt Enable */
#define PWM_IER2_UNRE (0x1 << 3) /**< \brief (PWM_IER2) Synchronous Channels Update Underrun Error Interrupt Enable */
#define PWM_IER2_CMPM0 (0x1 << 8) /**< \brief (PWM_IER2) Comparison 0 Match Interrupt Enable */
#define PWM_IER2_CMPM1 (0x1 << 9) /**< \brief (PWM_IER2) Comparison 1 Match Interrupt Enable */
#define PWM_IER2_CMPM2 (0x1 << 10) /**< \brief (PWM_IER2) Comparison 2 Match Interrupt Enable */
#define PWM_IER2_CMPM3 (0x1 << 11) /**< \brief (PWM_IER2) Comparison 3 Match Interrupt Enable */
#define PWM_IER2_CMPM4 (0x1 << 12) /**< \brief (PWM_IER2) Comparison 4 Match Interrupt Enable */
#define PWM_IER2_CMPM5 (0x1 << 13) /**< \brief (PWM_IER2) Comparison 5 Match Interrupt Enable */
#define PWM_IER2_CMPM6 (0x1 << 14) /**< \brief (PWM_IER2) Comparison 6 Match Interrupt Enable */
#define PWM_IER2_CMPM7 (0x1 << 15) /**< \brief (PWM_IER2) Comparison 7 Match Interrupt Enable */
#define PWM_IER2_CMPU0 (0x1 << 16) /**< \brief (PWM_IER2) Comparison 0 Update Interrupt Enable */
#define PWM_IER2_CMPU1 (0x1 << 17) /**< \brief (PWM_IER2) Comparison 1 Update Interrupt Enable */
#define PWM_IER2_CMPU2 (0x1 << 18) /**< \brief (PWM_IER2) Comparison 2 Update Interrupt Enable */
#define PWM_IER2_CMPU3 (0x1 << 19) /**< \brief (PWM_IER2) Comparison 3 Update Interrupt Enable */
#define PWM_IER2_CMPU4 (0x1 << 20) /**< \brief (PWM_IER2) Comparison 4 Update Interrupt Enable */
#define PWM_IER2_CMPU5 (0x1 << 21) /**< \brief (PWM_IER2) Comparison 5 Update Interrupt Enable */
#define PWM_IER2_CMPU6 (0x1 << 22) /**< \brief (PWM_IER2) Comparison 6 Update Interrupt Enable */
#define PWM_IER2_CMPU7 (0x1 << 23) /**< \brief (PWM_IER2) Comparison 7 Update Interrupt Enable */
/* -------- PWM_IDR2 : (PWM Offset: 0x38) PWM Interrupt Disable Register 2 -------- */
#define PWM_IDR2_WRDY (0x1 << 0) /**< \brief (PWM_IDR2) Write Ready for Synchronous Channels Update Interrupt Disable */
#define PWM_IDR2_ENDTX (0x1 << 1) /**< \brief (PWM_IDR2) PDC End of TX Buffer Interrupt Disable */
#define PWM_IDR2_TXBUFE (0x1 << 2) /**< \brief (PWM_IDR2) PDC TX Buffer Empty Interrupt Disable */
#define PWM_IDR2_UNRE (0x1 << 3) /**< \brief (PWM_IDR2) Synchronous Channels Update Underrun Error Interrupt Disable */
#define PWM_IDR2_CMPM0 (0x1 << 8) /**< \brief (PWM_IDR2) Comparison 0 Match Interrupt Disable */
#define PWM_IDR2_CMPM1 (0x1 << 9) /**< \brief (PWM_IDR2) Comparison 1 Match Interrupt Disable */
#define PWM_IDR2_CMPM2 (0x1 << 10) /**< \brief (PWM_IDR2) Comparison 2 Match Interrupt Disable */
#define PWM_IDR2_CMPM3 (0x1 << 11) /**< \brief (PWM_IDR2) Comparison 3 Match Interrupt Disable */
#define PWM_IDR2_CMPM4 (0x1 << 12) /**< \brief (PWM_IDR2) Comparison 4 Match Interrupt Disable */
#define PWM_IDR2_CMPM5 (0x1 << 13) /**< \brief (PWM_IDR2) Comparison 5 Match Interrupt Disable */
#define PWM_IDR2_CMPM6 (0x1 << 14) /**< \brief (PWM_IDR2) Comparison 6 Match Interrupt Disable */
#define PWM_IDR2_CMPM7 (0x1 << 15) /**< \brief (PWM_IDR2) Comparison 7 Match Interrupt Disable */
#define PWM_IDR2_CMPU0 (0x1 << 16) /**< \brief (PWM_IDR2) Comparison 0 Update Interrupt Disable */
#define PWM_IDR2_CMPU1 (0x1 << 17) /**< \brief (PWM_IDR2) Comparison 1 Update Interrupt Disable */
#define PWM_IDR2_CMPU2 (0x1 << 18) /**< \brief (PWM_IDR2) Comparison 2 Update Interrupt Disable */
#define PWM_IDR2_CMPU3 (0x1 << 19) /**< \brief (PWM_IDR2) Comparison 3 Update Interrupt Disable */
#define PWM_IDR2_CMPU4 (0x1 << 20) /**< \brief (PWM_IDR2) Comparison 4 Update Interrupt Disable */
#define PWM_IDR2_CMPU5 (0x1 << 21) /**< \brief (PWM_IDR2) Comparison 5 Update Interrupt Disable */
#define PWM_IDR2_CMPU6 (0x1 << 22) /**< \brief (PWM_IDR2) Comparison 6 Update Interrupt Disable */
#define PWM_IDR2_CMPU7 (0x1 << 23) /**< \brief (PWM_IDR2) Comparison 7 Update Interrupt Disable */
/* -------- PWM_IMR2 : (PWM Offset: 0x3C) PWM Interrupt Mask Register 2 -------- */
#define PWM_IMR2_WRDY (0x1 << 0) /**< \brief (PWM_IMR2) Write Ready for Synchronous Channels Update Interrupt Mask */
#define PWM_IMR2_ENDTX (0x1 << 1) /**< \brief (PWM_IMR2) PDC End of TX Buffer Interrupt Mask */
#define PWM_IMR2_TXBUFE (0x1 << 2) /**< \brief (PWM_IMR2) PDC TX Buffer Empty Interrupt Mask */
#define PWM_IMR2_UNRE (0x1 << 3) /**< \brief (PWM_IMR2) Synchronous Channels Update Underrun Error Interrupt Mask */
#define PWM_IMR2_CMPM0 (0x1 << 8) /**< \brief (PWM_IMR2) Comparison 0 Match Interrupt Mask */
#define PWM_IMR2_CMPM1 (0x1 << 9) /**< \brief (PWM_IMR2) Comparison 1 Match Interrupt Mask */
#define PWM_IMR2_CMPM2 (0x1 << 10) /**< \brief (PWM_IMR2) Comparison 2 Match Interrupt Mask */
#define PWM_IMR2_CMPM3 (0x1 << 11) /**< \brief (PWM_IMR2) Comparison 3 Match Interrupt Mask */
#define PWM_IMR2_CMPM4 (0x1 << 12) /**< \brief (PWM_IMR2) Comparison 4 Match Interrupt Mask */
#define PWM_IMR2_CMPM5 (0x1 << 13) /**< \brief (PWM_IMR2) Comparison 5 Match Interrupt Mask */
#define PWM_IMR2_CMPM6 (0x1 << 14) /**< \brief (PWM_IMR2) Comparison 6 Match Interrupt Mask */
#define PWM_IMR2_CMPM7 (0x1 << 15) /**< \brief (PWM_IMR2) Comparison 7 Match Interrupt Mask */
#define PWM_IMR2_CMPU0 (0x1 << 16) /**< \brief (PWM_IMR2) Comparison 0 Update Interrupt Mask */
#define PWM_IMR2_CMPU1 (0x1 << 17) /**< \brief (PWM_IMR2) Comparison 1 Update Interrupt Mask */
#define PWM_IMR2_CMPU2 (0x1 << 18) /**< \brief (PWM_IMR2) Comparison 2 Update Interrupt Mask */
#define PWM_IMR2_CMPU3 (0x1 << 19) /**< \brief (PWM_IMR2) Comparison 3 Update Interrupt Mask */
#define PWM_IMR2_CMPU4 (0x1 << 20) /**< \brief (PWM_IMR2) Comparison 4 Update Interrupt Mask */
#define PWM_IMR2_CMPU5 (0x1 << 21) /**< \brief (PWM_IMR2) Comparison 5 Update Interrupt Mask */
#define PWM_IMR2_CMPU6 (0x1 << 22) /**< \brief (PWM_IMR2) Comparison 6 Update Interrupt Mask */
#define PWM_IMR2_CMPU7 (0x1 << 23) /**< \brief (PWM_IMR2) Comparison 7 Update Interrupt Mask */
/* -------- PWM_ISR2 : (PWM Offset: 0x40) PWM Interrupt Status Register 2 -------- */
#define PWM_ISR2_WRDY (0x1 << 0) /**< \brief (PWM_ISR2) Write Ready for Synchronous Channels Update */
#define PWM_ISR2_ENDTX (0x1 << 1) /**< \brief (PWM_ISR2) PDC End of TX Buffer */
#define PWM_ISR2_TXBUFE (0x1 << 2) /**< \brief (PWM_ISR2) PDC TX Buffer Empty */
#define PWM_ISR2_UNRE (0x1 << 3) /**< \brief (PWM_ISR2) Synchronous Channels Update Underrun Error */
#define PWM_ISR2_CMPM0 (0x1 << 8) /**< \brief (PWM_ISR2) Comparison 0 Match */
#define PWM_ISR2_CMPM1 (0x1 << 9) /**< \brief (PWM_ISR2) Comparison 1 Match */
#define PWM_ISR2_CMPM2 (0x1 << 10) /**< \brief (PWM_ISR2) Comparison 2 Match */
#define PWM_ISR2_CMPM3 (0x1 << 11) /**< \brief (PWM_ISR2) Comparison 3 Match */
#define PWM_ISR2_CMPM4 (0x1 << 12) /**< \brief (PWM_ISR2) Comparison 4 Match */
#define PWM_ISR2_CMPM5 (0x1 << 13) /**< \brief (PWM_ISR2) Comparison 5 Match */
#define PWM_ISR2_CMPM6 (0x1 << 14) /**< \brief (PWM_ISR2) Comparison 6 Match */
#define PWM_ISR2_CMPM7 (0x1 << 15) /**< \brief (PWM_ISR2) Comparison 7 Match */
#define PWM_ISR2_CMPU0 (0x1 << 16) /**< \brief (PWM_ISR2) Comparison 0 Update */
#define PWM_ISR2_CMPU1 (0x1 << 17) /**< \brief (PWM_ISR2) Comparison 1 Update */
#define PWM_ISR2_CMPU2 (0x1 << 18) /**< \brief (PWM_ISR2) Comparison 2 Update */
#define PWM_ISR2_CMPU3 (0x1 << 19) /**< \brief (PWM_ISR2) Comparison 3 Update */
#define PWM_ISR2_CMPU4 (0x1 << 20) /**< \brief (PWM_ISR2) Comparison 4 Update */
#define PWM_ISR2_CMPU5 (0x1 << 21) /**< \brief (PWM_ISR2) Comparison 5 Update */
#define PWM_ISR2_CMPU6 (0x1 << 22) /**< \brief (PWM_ISR2) Comparison 6 Update */
#define PWM_ISR2_CMPU7 (0x1 << 23) /**< \brief (PWM_ISR2) Comparison 7 Update */
/* -------- PWM_OOV : (PWM Offset: 0x44) PWM Output Override Value Register -------- */
#define PWM_OOV_OOVH0 (0x1 << 0) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 0 */
#define PWM_OOV_OOVH1 (0x1 << 1) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 1 */
#define PWM_OOV_OOVH2 (0x1 << 2) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 2 */
#define PWM_OOV_OOVH3 (0x1 << 3) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 3 */
#define PWM_OOV_OOVL0 (0x1 << 16) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 0 */
#define PWM_OOV_OOVL1 (0x1 << 17) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 1 */
#define PWM_OOV_OOVL2 (0x1 << 18) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 2 */
#define PWM_OOV_OOVL3 (0x1 << 19) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 3 */
/* -------- PWM_OS : (PWM Offset: 0x48) PWM Output Selection Register -------- */
#define PWM_OS_OSH0 (0x1 << 0) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 0 */
#define PWM_OS_OSH1 (0x1 << 1) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 1 */
#define PWM_OS_OSH2 (0x1 << 2) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 2 */
#define PWM_OS_OSH3 (0x1 << 3) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 3 */
#define PWM_OS_OSL0 (0x1 << 16) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 0 */
#define PWM_OS_OSL1 (0x1 << 17) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 1 */
#define PWM_OS_OSL2 (0x1 << 18) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 2 */
#define PWM_OS_OSL3 (0x1 << 19) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 3 */
/* -------- PWM_OSS : (PWM Offset: 0x4C) PWM Output Selection Set Register -------- */
#define PWM_OSS_OSSH0 (0x1 << 0) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 0 */
#define PWM_OSS_OSSH1 (0x1 << 1) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 1 */
#define PWM_OSS_OSSH2 (0x1 << 2) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 2 */
#define PWM_OSS_OSSH3 (0x1 << 3) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 3 */
#define PWM_OSS_OSSL0 (0x1 << 16) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 0 */
#define PWM_OSS_OSSL1 (0x1 << 17) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 1 */
#define PWM_OSS_OSSL2 (0x1 << 18) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 2 */
#define PWM_OSS_OSSL3 (0x1 << 19) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 3 */
/* -------- PWM_OSC : (PWM Offset: 0x50) PWM Output Selection Clear Register -------- */
#define PWM_OSC_OSCH0 (0x1 << 0) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 0 */
#define PWM_OSC_OSCH1 (0x1 << 1) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 1 */
#define PWM_OSC_OSCH2 (0x1 << 2) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 2 */
#define PWM_OSC_OSCH3 (0x1 << 3) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 3 */
#define PWM_OSC_OSCL0 (0x1 << 16) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 0 */
#define PWM_OSC_OSCL1 (0x1 << 17) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 1 */
#define PWM_OSC_OSCL2 (0x1 << 18) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 2 */
#define PWM_OSC_OSCL3 (0x1 << 19) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 3 */
/* -------- PWM_OSSUPD : (PWM Offset: 0x54) PWM Output Selection Set Update Register -------- */
#define PWM_OSSUPD_OSSUPH0 (0x1 << 0) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 0 */
#define PWM_OSSUPD_OSSUPH1 (0x1 << 1) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 1 */
#define PWM_OSSUPD_OSSUPH2 (0x1 << 2) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 2 */
#define PWM_OSSUPD_OSSUPH3 (0x1 << 3) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 3 */
#define PWM_OSSUPD_OSSUPL0 (0x1 << 16) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 0 */
#define PWM_OSSUPD_OSSUPL1 (0x1 << 17) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 1 */
#define PWM_OSSUPD_OSSUPL2 (0x1 << 18) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 2 */
#define PWM_OSSUPD_OSSUPL3 (0x1 << 19) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 3 */
/* -------- PWM_OSCUPD : (PWM Offset: 0x58) PWM Output Selection Clear Update Register -------- */
#define PWM_OSCUPD_OSCUPH0 (0x1 << 0) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 0 */
#define PWM_OSCUPD_OSCUPH1 (0x1 << 1) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 1 */
#define PWM_OSCUPD_OSCUPH2 (0x1 << 2) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 2 */
#define PWM_OSCUPD_OSCUPH3 (0x1 << 3) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 3 */
#define PWM_OSCUPD_OSCUPL0 (0x1 << 16) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 0 */
#define PWM_OSCUPD_OSCUPL1 (0x1 << 17) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 1 */
#define PWM_OSCUPD_OSCUPL2 (0x1 << 18) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 2 */
#define PWM_OSCUPD_OSCUPL3 (0x1 << 19) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 3 */
/* -------- PWM_FMR : (PWM Offset: 0x5C) PWM Fault Mode Register -------- */
#define PWM_FMR_FPOL0 (0x1 << 0) /**< \brief (PWM_FMR) Fault 0 Polarity */
#define PWM_FMR_FPOL1 (0x1 << 1) /**< \brief (PWM_FMR) Fault 1 Polarity */
#define PWM_FMR_FPOL2 (0x1 << 2) /**< \brief (PWM_FMR) Fault 2 Polarity */
#define PWM_FMR_FPOL3 (0x1 << 3) /**< \brief (PWM_FMR) Fault 3 Polarity */
#define PWM_FMR_FMOD0 (0x1 << 8) /**< \brief (PWM_FMR) Fault 0 Activation Mode */
#define PWM_FMR_FMOD1 (0x1 << 9) /**< \brief (PWM_FMR) Fault 1 Activation Mode */
#define PWM_FMR_FMOD2 (0x1 << 10) /**< \brief (PWM_FMR) Fault 2 Activation Mode */
#define PWM_FMR_FMOD3 (0x1 << 11) /**< \brief (PWM_FMR) Fault 3 Activation Mode */
#define PWM_FMR_FFIL0 (0x1 << 16) /**< \brief (PWM_FMR) Fault 0 Filtering */
#define PWM_FMR_FFIL1 (0x1 << 17) /**< \brief (PWM_FMR) Fault 1 Filtering */
#define PWM_FMR_FFIL2 (0x1 << 18) /**< \brief (PWM_FMR) Fault 2 Filtering */
#define PWM_FMR_FFIL3 (0x1 << 19) /**< \brief (PWM_FMR) Fault 3 Filtering */
/* -------- PWM_FSR : (PWM Offset: 0x60) PWM Fault Status Register -------- */
#define PWM_FSR_FIV0 (0x1 << 0) /**< \brief (PWM_FSR) Fault Input 0 Value */
#define PWM_FSR_FIV1 (0x1 << 1) /**< \brief (PWM_FSR) Fault Input 1 Value */
#define PWM_FSR_FIV2 (0x1 << 2) /**< \brief (PWM_FSR) Fault Input 2 Value */
#define PWM_FSR_FIV3 (0x1 << 3) /**< \brief (PWM_FSR) Fault Input 3 Value */
#define PWM_FSR_FS0 (0x1 << 8) /**< \brief (PWM_FSR) Fault 0 Status */
#define PWM_FSR_FS1 (0x1 << 9) /**< \brief (PWM_FSR) Fault 1 Status */
#define PWM_FSR_FS2 (0x1 << 10) /**< \brief (PWM_FSR) Fault 2 Status */
#define PWM_FSR_FS3 (0x1 << 11) /**< \brief (PWM_FSR) Fault 3 Status */
/* -------- PWM_FCR : (PWM Offset: 0x64) PWM Fault Clear Register -------- */
#define PWM_FCR_FCLR0 (0x1 << 0) /**< \brief (PWM_FCR) Fault 0 Clear */
#define PWM_FCR_FCLR1 (0x1 << 1) /**< \brief (PWM_FCR) Fault 1 Clear */
#define PWM_FCR_FCLR2 (0x1 << 2) /**< \brief (PWM_FCR) Fault 2 Clear */
#define PWM_FCR_FCLR3 (0x1 << 3) /**< \brief (PWM_FCR) Fault 3 Clear */
/* -------- PWM_FPV : (PWM Offset: 0x68) PWM Fault Protection Value Register -------- */
#define PWM_FPV_FPVH0 (0x1 << 0) /**< \brief (PWM_FPV) Fault Protection Value for PWMH output on channel 0 */
#define PWM_FPV_FPVH1 (0x1 << 1) /**< \brief (PWM_FPV) Fault Protection Value for PWMH output on channel 1 */
#define PWM_FPV_FPVH2 (0x1 << 2) /**< \brief (PWM_FPV) Fault Protection Value for PWMH output on channel 2 */
#define PWM_FPV_FPVH3 (0x1 << 3) /**< \brief (PWM_FPV) Fault Protection Value for PWMH output on channel 3 */
#define PWM_FPV_FPVL0 (0x1 << 16) /**< \brief (PWM_FPV) Fault Protection Value for PWML output on channel 0 */
#define PWM_FPV_FPVL1 (0x1 << 17) /**< \brief (PWM_FPV) Fault Protection Value for PWML output on channel 1 */
#define PWM_FPV_FPVL2 (0x1 << 18) /**< \brief (PWM_FPV) Fault Protection Value for PWML output on channel 2 */
#define PWM_FPV_FPVL3 (0x1 << 19) /**< \brief (PWM_FPV) Fault Protection Value for PWML output on channel 3 */
/* -------- PWM_FPE : (PWM Offset: 0x6C) PWM Fault Protection Enable Register -------- */
#define PWM_FPE_FPE0 (0xff << 0) /**< \brief (PWM_FPE) Fault Protection Enable with Fault 0 for channel x */
#define PWM_FPE_FPE1 (0xff << 8) /**< \brief (PWM_FPE) Fault Protection Enable with Fault 1 for channel x */
#define PWM_FPE_FPE2 (0xff << 16) /**< \brief (PWM_FPE) Fault Protection Enable with Fault 2 for channel x */
#define PWM_FPE_FPE3 (0xff << 24) /**< \brief (PWM_FPE) Fault Protection Enable with Fault 3 for channel x */
/* -------- PWM_ELxMR[2] : (PWM Offset: 0x7C) PWM Event Line 0 Mode Register -------- */
#define PWM_ELxMR_CSEL0 (0x1 << 0) /**< \brief (PWM_ELxMR[2]) Comparison 0 Selection */
#define PWM_ELxMR_CSEL1 (0x1 << 1) /**< \brief (PWM_ELxMR[2]) Comparison 1 Selection */
#define PWM_ELxMR_CSEL2 (0x1 << 2) /**< \brief (PWM_ELxMR[2]) Comparison 2 Selection */
#define PWM_ELxMR_CSEL3 (0x1 << 3) /**< \brief (PWM_ELxMR[2]) Comparison 3 Selection */
#define PWM_ELxMR_CSEL4 (0x1 << 4) /**< \brief (PWM_ELxMR[2]) Comparison 4 Selection */
#define PWM_ELxMR_CSEL5 (0x1 << 5) /**< \brief (PWM_ELxMR[2]) Comparison 5 Selection */
#define PWM_ELxMR_CSEL6 (0x1 << 6) /**< \brief (PWM_ELxMR[2]) Comparison 6 Selection */
#define PWM_ELxMR_CSEL7 (0x1 << 7) /**< \brief (PWM_ELxMR[2]) Comparison 7 Selection */
/* -------- PWM_WPCR : (PWM Offset: 0xE4) PWM Write Protect Control Register -------- */
#define PWM_WPCR_WPCMD (0x3 << 0) /**< \brief (PWM_WPCR) Write Protect Command */
#define PWM_WPCR_WPRG0 (0x1 << 2) /**< \brief (PWM_WPCR) Write Protect Register Group 0 */
#define PWM_WPCR_WPRG1 (0x1 << 3) /**< \brief (PWM_WPCR) Write Protect Register Group 1 */
#define PWM_WPCR_WPRG2 (0x1 << 4) /**< \brief (PWM_WPCR) Write Protect Register Group 2 */
#define PWM_WPCR_WPRG3 (0x1 << 5) /**< \brief (PWM_WPCR) Write Protect Register Group 3 */
#define PWM_WPCR_WPRG4 (0x1 << 6) /**< \brief (PWM_WPCR) Write Protect Register Group 4 */
#define PWM_WPCR_WPRG5 (0x1 << 7) /**< \brief (PWM_WPCR) Write Protect Register Group 5 */
#define PWM_WPCR_WPKEY (0xffffff << 8) /**< \brief (PWM_WPCR) Write Protect Key */
/* -------- PWM_WPSR : (PWM Offset: 0xE8) PWM Write Protect Status Register -------- */
#define PWM_WPSR_WPSWS0 (0x1 << 0) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS1 (0x1 << 1) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS2 (0x1 << 2) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS3 (0x1 << 3) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS4 (0x1 << 4) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS5 (0x1 << 5) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPVS (0x1 << 7) /**< \brief (PWM_WPSR) Write Protect Violation Status */
#define PWM_WPSR_WPHWS0 (0x1 << 8) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS1 (0x1 << 9) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS2 (0x1 << 10) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS3 (0x1 << 11) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS4 (0x1 << 12) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS5 (0x1 << 13) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPVSRC (0xffff << 16) /**< \brief (PWM_WPSR) Write Protect Violation Source */
/* -------- PWM_RPR : (PWM Offset: 0x100) Receive Pointer Register -------- */
#define PWM_RPR_RXPTR (0xffffffff << 0) /**< \brief (PWM_RPR) Receive Pointer Register */
/* -------- PWM_RCR : (PWM Offset: 0x104) Receive Counter Register -------- */
#define PWM_RCR_RXCTR (0xffff << 0) /**< \brief (PWM_RCR) Receive Counter Register */
/* -------- PWM_TPR : (PWM Offset: 0x108) Transmit Pointer Register -------- */
#define PWM_TPR_TXPTR (0xffffffff << 0) /**< \brief (PWM_TPR) Transmit Counter Register */
/* -------- PWM_TCR : (PWM Offset: 0x10C) Transmit Counter Register -------- */
#define PWM_TCR_TXCTR (0xffff << 0) /**< \brief (PWM_TCR) Transmit Counter Register */
/* -------- PWM_RNPR : (PWM Offset: 0x110) Receive Next Pointer Register -------- */
#define PWM_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (PWM_RNPR) Receive Next Pointer */
/* -------- PWM_RNCR : (PWM Offset: 0x114) Receive Next Counter Register -------- */
#define PWM_RNCR_RXNCTR (0xffff << 0) /**< \brief (PWM_RNCR) Receive Next Counter */
/* -------- PWM_TNPR : (PWM Offset: 0x118) Transmit Next Pointer Register -------- */
#define PWM_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (PWM_TNPR) Transmit Next Pointer */
/* -------- PWM_TNCR : (PWM Offset: 0x11C) Transmit Next Counter Register -------- */
#define PWM_TNCR_TXNCTR (0xffff << 0) /**< \brief (PWM_TNCR) Transmit Counter Next */
/* -------- PWM_PTCR : (PWM Offset: 0x120) Transfer Control Register -------- */
#define PWM_PTCR_RXTEN (0x1 << 0) /**< \brief (PWM_PTCR) Receiver Transfer Enable */
#define PWM_PTCR_RXTDIS (0x1 << 1) /**< \brief (PWM_PTCR) Receiver Transfer Disable */
#define PWM_PTCR_TXTEN (0x1 << 8) /**< \brief (PWM_PTCR) Transmitter Transfer Enable */
#define PWM_PTCR_TXTDIS (0x1 << 9) /**< \brief (PWM_PTCR) Transmitter Transfer Disable */
/* -------- PWM_PTSR : (PWM Offset: 0x124) Transfer Status Register -------- */
#define PWM_PTSR_RXTEN (0x1 << 0) /**< \brief (PWM_PTSR) Receiver Transfer Enable */
#define PWM_PTSR_TXTEN (0x1 << 8) /**< \brief (PWM_PTSR) Transmitter Transfer Enable */
/* -------- PWM_CMP0V : (PWM Offset: 0x130) PWM Comparison 0 Value Register -------- */
#define PWM_CMP0V_CV (0xffffff << 0) /**< \brief (PWM_CMP0V) Comparison x Value */
#define PWM_CMP0V_CVM (0x1 << 24) /**< \brief (PWM_CMP0V) Comparison x Value Mode */
/* -------- PWM_CMP0VUPD : (PWM Offset: 0x134) PWM Comparison 0 Value Update Register -------- */
#define PWM_CMP0VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP0VUPD) Comparison x Value Update */
#define PWM_CMP0VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP0VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP0M : (PWM Offset: 0x138) PWM Comparison 0 Mode Register -------- */
#define PWM_CMP0M_CEN (0x1 << 0) /**< \brief (PWM_CMP0M) Comparison x Enable */
#define PWM_CMP0M_CTR (0xf << 4) /**< \brief (PWM_CMP0M) Comparison x Trigger */
#define PWM_CMP0M_CPR (0xf << 8) /**< \brief (PWM_CMP0M) Comparison x Period */
#define PWM_CMP0M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP0M) Comparison x Period Counter */
#define PWM_CMP0M_CUPR (0xf << 16) /**< \brief (PWM_CMP0M) Comparison x Update Period */
#define PWM_CMP0M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP0M) Comparison x Update Period Counter */
/* -------- PWM_CMP0MUPD : (PWM Offset: 0x13C) PWM Comparison 0 Mode Update Register -------- */
#define PWM_CMP0MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP0MUPD) Comparison x Enable Update */
#define PWM_CMP0MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP0MUPD) Comparison x Trigger Update */
#define PWM_CMP0MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP0MUPD) Comparison x Period Update */
#define PWM_CMP0MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP0MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP1V : (PWM Offset: 0x140) PWM Comparison 1 Value Register -------- */
#define PWM_CMP1V_CV (0xffffff << 0) /**< \brief (PWM_CMP1V) Comparison x Value */
#define PWM_CMP1V_CVM (0x1 << 24) /**< \brief (PWM_CMP1V) Comparison x Value Mode */
/* -------- PWM_CMP1VUPD : (PWM Offset: 0x144) PWM Comparison 1 Value Update Register -------- */
#define PWM_CMP1VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP1VUPD) Comparison x Value Update */
#define PWM_CMP1VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP1VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP1M : (PWM Offset: 0x148) PWM Comparison 1 Mode Register -------- */
#define PWM_CMP1M_CEN (0x1 << 0) /**< \brief (PWM_CMP1M) Comparison x Enable */
#define PWM_CMP1M_CTR (0xf << 4) /**< \brief (PWM_CMP1M) Comparison x Trigger */
#define PWM_CMP1M_CPR (0xf << 8) /**< \brief (PWM_CMP1M) Comparison x Period */
#define PWM_CMP1M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP1M) Comparison x Period Counter */
#define PWM_CMP1M_CUPR (0xf << 16) /**< \brief (PWM_CMP1M) Comparison x Update Period */
#define PWM_CMP1M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP1M) Comparison x Update Period Counter */
/* -------- PWM_CMP1MUPD : (PWM Offset: 0x14C) PWM Comparison 1 Mode Update Register -------- */
#define PWM_CMP1MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP1MUPD) Comparison x Enable Update */
#define PWM_CMP1MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP1MUPD) Comparison x Trigger Update */
#define PWM_CMP1MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP1MUPD) Comparison x Period Update */
#define PWM_CMP1MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP1MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP2V : (PWM Offset: 0x150) PWM Comparison 2 Value Register -------- */
#define PWM_CMP2V_CV (0xffffff << 0) /**< \brief (PWM_CMP2V) Comparison x Value */
#define PWM_CMP2V_CVM (0x1 << 24) /**< \brief (PWM_CMP2V) Comparison x Value Mode */
/* -------- PWM_CMP2VUPD : (PWM Offset: 0x154) PWM Comparison 2 Value Update Register -------- */
#define PWM_CMP2VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP2VUPD) Comparison x Value Update */
#define PWM_CMP2VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP2VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP2M : (PWM Offset: 0x158) PWM Comparison 2 Mode Register -------- */
#define PWM_CMP2M_CEN (0x1 << 0) /**< \brief (PWM_CMP2M) Comparison x Enable */
#define PWM_CMP2M_CTR (0xf << 4) /**< \brief (PWM_CMP2M) Comparison x Trigger */
#define PWM_CMP2M_CPR (0xf << 8) /**< \brief (PWM_CMP2M) Comparison x Period */
#define PWM_CMP2M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP2M) Comparison x Period Counter */
#define PWM_CMP2M_CUPR (0xf << 16) /**< \brief (PWM_CMP2M) Comparison x Update Period */
#define PWM_CMP2M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP2M) Comparison x Update Period Counter */
/* -------- PWM_CMP2MUPD : (PWM Offset: 0x15C) PWM Comparison 2 Mode Update Register -------- */
#define PWM_CMP2MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP2MUPD) Comparison x Enable Update */
#define PWM_CMP2MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP2MUPD) Comparison x Trigger Update */
#define PWM_CMP2MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP2MUPD) Comparison x Period Update */
#define PWM_CMP2MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP2MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP3V : (PWM Offset: 0x160) PWM Comparison 3 Value Register -------- */
#define PWM_CMP3V_CV (0xffffff << 0) /**< \brief (PWM_CMP3V) Comparison x Value */
#define PWM_CMP3V_CVM (0x1 << 24) /**< \brief (PWM_CMP3V) Comparison x Value Mode */
/* -------- PWM_CMP3VUPD : (PWM Offset: 0x164) PWM Comparison 3 Value Update Register -------- */
#define PWM_CMP3VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP3VUPD) Comparison x Value Update */
#define PWM_CMP3VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP3VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP3M : (PWM Offset: 0x168) PWM Comparison 3 Mode Register -------- */
#define PWM_CMP3M_CEN (0x1 << 0) /**< \brief (PWM_CMP3M) Comparison x Enable */
#define PWM_CMP3M_CTR (0xf << 4) /**< \brief (PWM_CMP3M) Comparison x Trigger */
#define PWM_CMP3M_CPR (0xf << 8) /**< \brief (PWM_CMP3M) Comparison x Period */
#define PWM_CMP3M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP3M) Comparison x Period Counter */
#define PWM_CMP3M_CUPR (0xf << 16) /**< \brief (PWM_CMP3M) Comparison x Update Period */
#define PWM_CMP3M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP3M) Comparison x Update Period Counter */
/* -------- PWM_CMP3MUPD : (PWM Offset: 0x16C) PWM Comparison 3 Mode Update Register -------- */
#define PWM_CMP3MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP3MUPD) Comparison x Enable Update */
#define PWM_CMP3MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP3MUPD) Comparison x Trigger Update */
#define PWM_CMP3MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP3MUPD) Comparison x Period Update */
#define PWM_CMP3MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP3MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP4V : (PWM Offset: 0x170) PWM Comparison 4 Value Register -------- */
#define PWM_CMP4V_CV (0xffffff << 0) /**< \brief (PWM_CMP4V) Comparison x Value */
#define PWM_CMP4V_CVM (0x1 << 24) /**< \brief (PWM_CMP4V) Comparison x Value Mode */
/* -------- PWM_CMP4VUPD : (PWM Offset: 0x174) PWM Comparison 4 Value Update Register -------- */
#define PWM_CMP4VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP4VUPD) Comparison x Value Update */
#define PWM_CMP4VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP4VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP4M : (PWM Offset: 0x178) PWM Comparison 4 Mode Register -------- */
#define PWM_CMP4M_CEN (0x1 << 0) /**< \brief (PWM_CMP4M) Comparison x Enable */
#define PWM_CMP4M_CTR (0xf << 4) /**< \brief (PWM_CMP4M) Comparison x Trigger */
#define PWM_CMP4M_CPR (0xf << 8) /**< \brief (PWM_CMP4M) Comparison x Period */
#define PWM_CMP4M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP4M) Comparison x Period Counter */
#define PWM_CMP4M_CUPR (0xf << 16) /**< \brief (PWM_CMP4M) Comparison x Update Period */
#define PWM_CMP4M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP4M) Comparison x Update Period Counter */
/* -------- PWM_CMP4MUPD : (PWM Offset: 0x17C) PWM Comparison 4 Mode Update Register -------- */
#define PWM_CMP4MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP4MUPD) Comparison x Enable Update */
#define PWM_CMP4MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP4MUPD) Comparison x Trigger Update */
#define PWM_CMP4MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP4MUPD) Comparison x Period Update */
#define PWM_CMP4MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP4MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP5V : (PWM Offset: 0x180) PWM Comparison 5 Value Register -------- */
#define PWM_CMP5V_CV (0xffffff << 0) /**< \brief (PWM_CMP5V) Comparison x Value */
#define PWM_CMP5V_CVM (0x1 << 24) /**< \brief (PWM_CMP5V) Comparison x Value Mode */
/* -------- PWM_CMP5VUPD : (PWM Offset: 0x184) PWM Comparison 5 Value Update Register -------- */
#define PWM_CMP5VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP5VUPD) Comparison x Value Update */
#define PWM_CMP5VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP5VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP5M : (PWM Offset: 0x188) PWM Comparison 5 Mode Register -------- */
#define PWM_CMP5M_CEN (0x1 << 0) /**< \brief (PWM_CMP5M) Comparison x Enable */
#define PWM_CMP5M_CTR (0xf << 4) /**< \brief (PWM_CMP5M) Comparison x Trigger */
#define PWM_CMP5M_CPR (0xf << 8) /**< \brief (PWM_CMP5M) Comparison x Period */
#define PWM_CMP5M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP5M) Comparison x Period Counter */
#define PWM_CMP5M_CUPR (0xf << 16) /**< \brief (PWM_CMP5M) Comparison x Update Period */
#define PWM_CMP5M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP5M) Comparison x Update Period Counter */
/* -------- PWM_CMP5MUPD : (PWM Offset: 0x18C) PWM Comparison 5 Mode Update Register -------- */
#define PWM_CMP5MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP5MUPD) Comparison x Enable Update */
#define PWM_CMP5MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP5MUPD) Comparison x Trigger Update */
#define PWM_CMP5MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP5MUPD) Comparison x Period Update */
#define PWM_CMP5MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP5MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP6V : (PWM Offset: 0x190) PWM Comparison 6 Value Register -------- */
#define PWM_CMP6V_CV (0xffffff << 0) /**< \brief (PWM_CMP6V) Comparison x Value */
#define PWM_CMP6V_CVM (0x1 << 24) /**< \brief (PWM_CMP6V) Comparison x Value Mode */
/* -------- PWM_CMP6VUPD : (PWM Offset: 0x194) PWM Comparison 6 Value Update Register -------- */
#define PWM_CMP6VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP6VUPD) Comparison x Value Update */
#define PWM_CMP6VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP6VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP6M : (PWM Offset: 0x198) PWM Comparison 6 Mode Register -------- */
#define PWM_CMP6M_CEN (0x1 << 0) /**< \brief (PWM_CMP6M) Comparison x Enable */
#define PWM_CMP6M_CTR (0xf << 4) /**< \brief (PWM_CMP6M) Comparison x Trigger */
#define PWM_CMP6M_CPR (0xf << 8) /**< \brief (PWM_CMP6M) Comparison x Period */
#define PWM_CMP6M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP6M) Comparison x Period Counter */
#define PWM_CMP6M_CUPR (0xf << 16) /**< \brief (PWM_CMP6M) Comparison x Update Period */
#define PWM_CMP6M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP6M) Comparison x Update Period Counter */
/* -------- PWM_CMP6MUPD : (PWM Offset: 0x19C) PWM Comparison 6 Mode Update Register -------- */
#define PWM_CMP6MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP6MUPD) Comparison x Enable Update */
#define PWM_CMP6MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP6MUPD) Comparison x Trigger Update */
#define PWM_CMP6MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP6MUPD) Comparison x Period Update */
#define PWM_CMP6MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP6MUPD) Comparison x Update Period Update */
/* -------- PWM_CMP7V : (PWM Offset: 0x1A0) PWM Comparison 7 Value Register -------- */
#define PWM_CMP7V_CV (0xffffff << 0) /**< \brief (PWM_CMP7V) Comparison x Value */
#define PWM_CMP7V_CVM (0x1 << 24) /**< \brief (PWM_CMP7V) Comparison x Value Mode */
/* -------- PWM_CMP7VUPD : (PWM Offset: 0x1A4) PWM Comparison 7 Value Update Register -------- */
#define PWM_CMP7VUPD_CVUPD (0xffffff << 0) /**< \brief (PWM_CMP7VUPD) Comparison x Value Update */
#define PWM_CMP7VUPD_CVMUPD (0x1 << 24) /**< \brief (PWM_CMP7VUPD) Comparison x Value Mode Update */
/* -------- PWM_CMP7M : (PWM Offset: 0x1A8) PWM Comparison 7 Mode Register -------- */
#define PWM_CMP7M_CEN (0x1 << 0) /**< \brief (PWM_CMP7M) Comparison x Enable */
#define PWM_CMP7M_CTR (0xf << 4) /**< \brief (PWM_CMP7M) Comparison x Trigger */
#define PWM_CMP7M_CPR (0xf << 8) /**< \brief (PWM_CMP7M) Comparison x Period */
#define PWM_CMP7M_CPRCNT (0xf << 12) /**< \brief (PWM_CMP7M) Comparison x Period Counter */
#define PWM_CMP7M_CUPR (0xf << 16) /**< \brief (PWM_CMP7M) Comparison x Update Period */
#define PWM_CMP7M_CUPRCNT (0xf << 20) /**< \brief (PWM_CMP7M) Comparison x Update Period Counter */
/* -------- PWM_CMP7MUPD : (PWM Offset: 0x1AC) PWM Comparison 7 Mode Update Register -------- */
#define PWM_CMP7MUPD_CENUPD (0x1 << 0) /**< \brief (PWM_CMP7MUPD) Comparison x Enable Update */
#define PWM_CMP7MUPD_CTRUPD (0xf << 4) /**< \brief (PWM_CMP7MUPD) Comparison x Trigger Update */
#define PWM_CMP7MUPD_CPRUPD (0xf << 8) /**< \brief (PWM_CMP7MUPD) Comparison x Period Update */
#define PWM_CMP7MUPD_CUPRUPD (0xf << 16) /**< \brief (PWM_CMP7MUPD) Comparison x Update Period Update */
/* -------- PWM_CMR0 : (PWM Offset: 0x200) PWM Channel Mode Register (ch_num = 0) -------- */
#define PWM_CMR0_CPRE (0xf << 0) /**< \brief (PWM_CMR0) Channel Pre-scaler */
#define 	PWM_CMR0_CPRE_MCK_DIV_2            (0x1) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_4            (0x2) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_8            (0x3) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_16           (0x4) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_32           (0x5) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_64           (0x6) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_128          (0x7) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_256          (0x8) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_512          (0x9) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCK_DIV_1024         (0xA) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCKA                 (0xB) // (PWMC_CH) 
#define 	PWM_CMR0_CPRE_MCKB                 (0xC) // (PWMC_CH) 
#define PWM_CMR0_CALG (0x1 << 8) /**< \brief (PWM_CMR0) Channel Alignment */
#define PWM_CMR0_CPOL (0x1 << 9) /**< \brief (PWM_CMR0) Channel Polarity */
#define PWM_CMR0_CES (0x1 << 10) /**< \brief (PWM_CMR0) Counter Event Selection */
#define PWM_CMR0_DTE (0x1 << 16) /**< \brief (PWM_CMR0) Dead-Time Generator Enable */
#define PWM_CMR0_DTHI (0x1 << 17) /**< \brief (PWM_CMR0) Dead-Time PWMHx Output Inverted */
#define PWM_CMR0_DTLI (0x1 << 18) /**< \brief (PWM_CMR0) Dead-Time PWMLx Output Inverted */
/* -------- PWM_CDTY0 : (PWM Offset: 0x204) PWM Channel Duty Cycle Register (ch_num = 0) -------- */
#define PWM_CDTY0_CDTY (0xffffff << 0) /**< \brief (PWM_CDTY0) Channel Duty-Cycle */
/* -------- PWM_CDTYUPD0 : (PWM Offset: 0x208) PWM Channel Duty Cycle Update Register (ch_num = 0) -------- */
#define PWM_CDTYUPD0_CDTYUPD (0xffffff << 0) /**< \brief (PWM_CDTYUPD0) Channel Duty-Cycle Update */
/* -------- PWM_CPRD0 : (PWM Offset: 0x20C) PWM Channel Period Register (ch_num = 0) -------- */
#define PWM_CPRD0_CPRD (0xffffff << 0) /**< \brief (PWM_CPRD0) Channel Period */
/* -------- PWM_CPRDUPD0 : (PWM Offset: 0x210) PWM Channel Period Update Register (ch_num = 0) -------- */
#define PWM_CPRDUPD0_CPRDUPD (0xffffff << 0) /**< \brief (PWM_CPRDUPD0) Channel Period Update */
/* -------- PWM_CCNT0 : (PWM Offset: 0x214) PWM Channel Counter Register (ch_num = 0) -------- */
#define PWM_CCNT0_CNT (0xffffff << 0) /**< \brief (PWM_CCNT0) Channel Counter Register */
/* -------- PWM_DT0 : (PWM Offset: 0x218) PWM Channel Dead Time Register (ch_num = 0) -------- */
#define PWM_DT0_DTH (0xffff << 0) /**< \brief (PWM_DT0) Dead-Time Value for PWMHx Output */
#define PWM_DT0_DTL (0xffff << 16) /**< \brief (PWM_DT0) Dead-Time Value for PWMLx Output */
/* -------- PWM_DTUPD0 : (PWM Offset: 0x21C) PWM Channel Dead Time Update Register (ch_num = 0) -------- */
#define PWM_DTUPD0_DTHUPD (0xffff << 0) /**< \brief (PWM_DTUPD0) Dead-Time Value Update for PWMHx Output */
#define PWM_DTUPD0_DTLUPD (0xffff << 16) /**< \brief (PWM_DTUPD0) Dead-Time Value Update for PWMLx Output */
/* -------- PWM_CMR1 : (PWM Offset: 0x220) PWM Channel Mode Register (ch_num = 1) -------- */
#define PWM_CMR1_CPRE (0xf << 0) /**< \brief (PWM_CMR1) Channel Pre-scaler */
#define 	PWM_CMR1_CPRE_MCK_DIV_2            (0x1) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_4            (0x2) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_8            (0x3) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_16           (0x4) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_32           (0x5) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_64           (0x6) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_128          (0x7) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_256          (0x8) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_512          (0x9) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCK_DIV_1024         (0xA) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCKA                 (0xB) // (PWMC_CH) 
#define 	PWM_CMR1_CPRE_MCKB                 (0xC) // (PWMC_CH) 
#define PWM_CMR1_CALG (0x1 << 8) /**< \brief (PWM_CMR1) Channel Alignment */
#define PWM_CMR1_CPOL (0x1 << 9) /**< \brief (PWM_CMR1) Channel Polarity */
#define PWM_CMR1_CES (0x1 << 10) /**< \brief (PWM_CMR1) Counter Event Selection */
#define PWM_CMR1_DTE (0x1 << 16) /**< \brief (PWM_CMR1) Dead-Time Generator Enable */
#define PWM_CMR1_DTHI (0x1 << 17) /**< \brief (PWM_CMR1) Dead-Time PWMHx Output Inverted */
#define PWM_CMR1_DTLI (0x1 << 18) /**< \brief (PWM_CMR1) Dead-Time PWMLx Output Inverted */
/* -------- PWM_CDTY1 : (PWM Offset: 0x224) PWM Channel Duty Cycle Register (ch_num = 1) -------- */
#define PWM_CDTY1_CDTY (0xffffff << 0) /**< \brief (PWM_CDTY1) Channel Duty-Cycle */
/* -------- PWM_CDTYUPD1 : (PWM Offset: 0x228) PWM Channel Duty Cycle Update Register (ch_num = 1) -------- */
#define PWM_CDTYUPD1_CDTYUPD (0xffffff << 0) /**< \brief (PWM_CDTYUPD1) Channel Duty-Cycle Update */
/* -------- PWM_CPRD1 : (PWM Offset: 0x22C) PWM Channel Period Register (ch_num = 1) -------- */
#define PWM_CPRD1_CPRD (0xffffff << 0) /**< \brief (PWM_CPRD1) Channel Period */
/* -------- PWM_CPRDUPD1 : (PWM Offset: 0x230) PWM Channel Period Update Register (ch_num = 1) -------- */
#define PWM_CPRDUPD1_CPRDUPD (0xffffff << 0) /**< \brief (PWM_CPRDUPD1) Channel Period Update */
/* -------- PWM_CCNT1 : (PWM Offset: 0x234) PWM Channel Counter Register (ch_num = 1) -------- */
#define PWM_CCNT1_CNT (0xffffff << 0) /**< \brief (PWM_CCNT1) Channel Counter Register */
/* -------- PWM_DT1 : (PWM Offset: 0x238) PWM Channel Dead Time Register (ch_num = 1) -------- */
#define PWM_DT1_DTH (0xffff << 0) /**< \brief (PWM_DT1) Dead-Time Value for PWMHx Output */
#define PWM_DT1_DTL (0xffff << 16) /**< \brief (PWM_DT1) Dead-Time Value for PWMLx Output */
/* -------- PWM_DTUPD1 : (PWM Offset: 0x23C) PWM Channel Dead Time Update Register (ch_num = 1) -------- */
#define PWM_DTUPD1_DTHUPD (0xffff << 0) /**< \brief (PWM_DTUPD1) Dead-Time Value Update for PWMHx Output */
#define PWM_DTUPD1_DTLUPD (0xffff << 16) /**< \brief (PWM_DTUPD1) Dead-Time Value Update for PWMLx Output */
/* -------- PWM_CMR2 : (PWM Offset: 0x240) PWM Channel Mode Register (ch_num = 2) -------- */
#define PWM_CMR2_CPRE (0xf << 0) /**< \brief (PWM_CMR2) Channel Pre-scaler */
#define 	PWM_CMR2_CPRE_MCK_DIV_2            (0x1) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_4            (0x2) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_8            (0x3) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_16           (0x4) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_32           (0x5) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_64           (0x6) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_128          (0x7) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_256          (0x8) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_512          (0x9) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCK_DIV_1024         (0xA) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCKA                 (0xB) // (PWMC_CH) 
#define 	PWM_CMR2_CPRE_MCKB                 (0xC) // (PWMC_CH) 
#define PWM_CMR2_CALG (0x1 << 8) /**< \brief (PWM_CMR2) Channel Alignment */
#define PWM_CMR2_CPOL (0x1 << 9) /**< \brief (PWM_CMR2) Channel Polarity */
#define PWM_CMR2_CES (0x1 << 10) /**< \brief (PWM_CMR2) Counter Event Selection */
#define PWM_CMR2_DTE (0x1 << 16) /**< \brief (PWM_CMR2) Dead-Time Generator Enable */
#define PWM_CMR2_DTHI (0x1 << 17) /**< \brief (PWM_CMR2) Dead-Time PWMHx Output Inverted */
#define PWM_CMR2_DTLI (0x1 << 18) /**< \brief (PWM_CMR2) Dead-Time PWMLx Output Inverted */
/* -------- PWM_CDTY2 : (PWM Offset: 0x244) PWM Channel Duty Cycle Register (ch_num = 2) -------- */
#define PWM_CDTY2_CDTY (0xffffff << 0) /**< \brief (PWM_CDTY2) Channel Duty-Cycle */
/* -------- PWM_CDTYUPD2 : (PWM Offset: 0x248) PWM Channel Duty Cycle Update Register (ch_num = 2) -------- */
#define PWM_CDTYUPD2_CDTYUPD (0xffffff << 0) /**< \brief (PWM_CDTYUPD2) Channel Duty-Cycle Update */
/* -------- PWM_CPRD2 : (PWM Offset: 0x24C) PWM Channel Period Register (ch_num = 2) -------- */
#define PWM_CPRD2_CPRD (0xffffff << 0) /**< \brief (PWM_CPRD2) Channel Period */
/* -------- PWM_CPRDUPD2 : (PWM Offset: 0x250) PWM Channel Period Update Register (ch_num = 2) -------- */
#define PWM_CPRDUPD2_CPRDUPD (0xffffff << 0) /**< \brief (PWM_CPRDUPD2) Channel Period Update */
/* -------- PWM_CCNT2 : (PWM Offset: 0x254) PWM Channel Counter Register (ch_num = 2) -------- */
#define PWM_CCNT2_CNT (0xffffff << 0) /**< \brief (PWM_CCNT2) Channel Counter Register */
/* -------- PWM_DT2 : (PWM Offset: 0x258) PWM Channel Dead Time Register (ch_num = 2) -------- */
#define PWM_DT2_DTH (0xffff << 0) /**< \brief (PWM_DT2) Dead-Time Value for PWMHx Output */
#define PWM_DT2_DTL (0xffff << 16) /**< \brief (PWM_DT2) Dead-Time Value for PWMLx Output */
/* -------- PWM_DTUPD2 : (PWM Offset: 0x25C) PWM Channel Dead Time Update Register (ch_num = 2) -------- */
#define PWM_DTUPD2_DTHUPD (0xffff << 0) /**< \brief (PWM_DTUPD2) Dead-Time Value Update for PWMHx Output */
#define PWM_DTUPD2_DTLUPD (0xffff << 16) /**< \brief (PWM_DTUPD2) Dead-Time Value Update for PWMLx Output */
/* -------- PWM_CMR3 : (PWM Offset: 0x260) PWM Channel Mode Register (ch_num = 3) -------- */
#define PWM_CMR3_CPRE (0xf << 0) /**< \brief (PWM_CMR3) Channel Pre-scaler */
#define 	PWM_CMR3_CPRE_MCK_DIV_2            (0x1) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_4            (0x2) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_8            (0x3) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_16           (0x4) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_32           (0x5) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_64           (0x6) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_128          (0x7) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_256          (0x8) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_512          (0x9) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCK_DIV_1024         (0xA) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCKA                 (0xB) // (PWMC_CH) 
#define 	PWM_CMR3_CPRE_MCKB                 (0xC) // (PWMC_CH) 
#define PWM_CMR3_CALG (0x1 << 8) /**< \brief (PWM_CMR3) Channel Alignment */
#define PWM_CMR3_CPOL (0x1 << 9) /**< \brief (PWM_CMR3) Channel Polarity */
#define PWM_CMR3_CES (0x1 << 10) /**< \brief (PWM_CMR3) Counter Event Selection */
#define PWM_CMR3_DTE (0x1 << 16) /**< \brief (PWM_CMR3) Dead-Time Generator Enable */
#define PWM_CMR3_DTHI (0x1 << 17) /**< \brief (PWM_CMR3) Dead-Time PWMHx Output Inverted */
#define PWM_CMR3_DTLI (0x1 << 18) /**< \brief (PWM_CMR3) Dead-Time PWMLx Output Inverted */
/* -------- PWM_CDTY3 : (PWM Offset: 0x264) PWM Channel Duty Cycle Register (ch_num = 3) -------- */
#define PWM_CDTY3_CDTY (0xffffff << 0) /**< \brief (PWM_CDTY3) Channel Duty-Cycle */
/* -------- PWM_CDTYUPD3 : (PWM Offset: 0x268) PWM Channel Duty Cycle Update Register (ch_num = 3) -------- */
#define PWM_CDTYUPD3_CDTYUPD (0xffffff << 0) /**< \brief (PWM_CDTYUPD3) Channel Duty-Cycle Update */
/* -------- PWM_CPRD3 : (PWM Offset: 0x26C) PWM Channel Period Register (ch_num = 3) -------- */
#define PWM_CPRD3_CPRD (0xffffff << 0) /**< \brief (PWM_CPRD3) Channel Period */
/* -------- PWM_CPRDUPD3 : (PWM Offset: 0x270) PWM Channel Period Update Register (ch_num = 3) -------- */
#define PWM_CPRDUPD3_CPRDUPD (0xffffff << 0) /**< \brief (PWM_CPRDUPD3) Channel Period Update */
/* -------- PWM_CCNT3 : (PWM Offset: 0x274) PWM Channel Counter Register (ch_num = 3) -------- */
#define PWM_CCNT3_CNT (0xffffff << 0) /**< \brief (PWM_CCNT3) Channel Counter Register */
/* -------- PWM_DT3 : (PWM Offset: 0x278) PWM Channel Dead Time Register (ch_num = 3) -------- */
#define PWM_DT3_DTH (0xffff << 0) /**< \brief (PWM_DT3) Dead-Time Value for PWMHx Output */
#define PWM_DT3_DTL (0xffff << 16) /**< \brief (PWM_DT3) Dead-Time Value for PWMLx Output */
/* -------- PWM_DTUPD3 : (PWM Offset: 0x27C) PWM Channel Dead Time Update Register (ch_num = 3) -------- */
#define PWM_DTUPD3_DTHUPD (0xffff << 0) /**< \brief (PWM_DTUPD3) Dead-Time Value Update for PWMHx Output */
#define PWM_DTUPD3_DTLUPD (0xffff << 16) /**< \brief (PWM_DTUPD3) Dead-Time Value Update for PWMLx Output */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Reset Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_RSTC Reset Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Rstc hardware registers */
typedef struct {
  WoReg RSTC_CR; /**< \brief (Rstc Offset: 0x00) Control Register */
  RoReg RSTC_SR; /**< \brief (Rstc Offset: 0x04) Status Register */
  RwReg RSTC_MR; /**< \brief (Rstc Offset: 0x08) Mode Register */
} Rstc;
#endif /* __ASSEMBLY__ */
/* -------- RSTC_CR : (RSTC Offset: 0x00) Control Register -------- */
#define RSTC_CR_PROCRST (0x1 << 0) /**< \brief (RSTC_CR) Processor Reset */
#define RSTC_CR_PERRST (0x1 << 2) /**< \brief (RSTC_CR) Peripheral Reset */
#define RSTC_CR_EXTRST (0x1 << 3) /**< \brief (RSTC_CR) External Reset */
#define RSTC_CR_KEY (0xff << 24) /**< \brief (RSTC_CR) Password */
/* -------- RSTC_SR : (RSTC Offset: 0x04) Status Register -------- */
#define RSTC_SR_URSTS (0x1 << 0) /**< \brief (RSTC_SR) User Reset Status */
#define RSTC_SR_RSTTYP (0x7 << 8) /**< \brief (RSTC_SR) Reset Type */
#define RSTC_SR_NRSTL (0x1 << 16) /**< \brief (RSTC_SR) NRST Pin Level */
#define RSTC_SR_SRCMP (0x1 << 17) /**< \brief (RSTC_SR) Software Reset Command in Progress */
/* -------- RSTC_MR : (RSTC Offset: 0x08) Mode Register -------- */
#define RSTC_MR_URSTEN (0x1 << 0) /**< \brief (RSTC_MR) User Reset Enable */
#define RSTC_MR_URSTIEN (0x1 << 4) /**< \brief (RSTC_MR) User Reset Interrupt Enable */
#define RSTC_MR_ERSTL (0xf << 8) /**< \brief (RSTC_MR) External Reset Length */
#define RSTC_MR_KEY (0xff << 24) /**< \brief (RSTC_MR) Password */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Real-time Clock */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_RTC Real-time Clock */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Rtc hardware registers */
typedef struct {
  RwReg RTC_CR;     /**< \brief (Rtc Offset: 0x00) Control Register */
  RwReg RTC_MR;     /**< \brief (Rtc Offset: 0x04) Mode Register */
  RwReg RTC_TIMR;   /**< \brief (Rtc Offset: 0x08) Time Register */
  RwReg RTC_CALR;   /**< \brief (Rtc Offset: 0x0C) Calendar Register */
  RwReg RTC_TIMALR; /**< \brief (Rtc Offset: 0x10) Time Alarm Register */
  RwReg RTC_CALALR; /**< \brief (Rtc Offset: 0x14) Calendar Alarm Register */
  RoReg RTC_SR;     /**< \brief (Rtc Offset: 0x18) Status Register */
  WoReg RTC_SCCR;   /**< \brief (Rtc Offset: 0x1C) Status Clear Command Register */
  WoReg RTC_IER;    /**< \brief (Rtc Offset: 0x20) Interrupt Enable Register */
  WoReg RTC_IDR;    /**< \brief (Rtc Offset: 0x24) Interrupt Disable Register */
  RoReg RTC_IMR;    /**< \brief (Rtc Offset: 0x28) Interrupt Mask Register */
  RoReg RTC_VER;    /**< \brief (Rtc Offset: 0x2C) Valid Entry Register */
} Rtc;
#endif /* __ASSEMBLY__ */
/* -------- RTC_CR : (RTC Offset: 0x00) Control Register -------- */
#define RTC_CR_UPDTIM (0x1 << 0) /**< \brief (RTC_CR) Update Request Time Register */
#define RTC_CR_UPDCAL (0x1 << 1) /**< \brief (RTC_CR) Update Request Calendar Register */
#define RTC_CR_TIMEVSEL (0x3 << 8) /**< \brief (RTC_CR) Time Event Selection */
#define   RTC_CR_TIMEVSEL_MINUTE (0x0 << 8) /**< \brief (RTC_CR) Minute change. */
#define   RTC_CR_TIMEVSEL_HOUR (0x1 << 8) /**< \brief (RTC_CR) Hour change. */
#define   RTC_CR_TIMEVSEL_DAY24 (0x2 << 8) /**< \brief (RTC_CR) Every day at midnight. */
#define   RTC_CR_TIMEVSEL_DAY12 (0x3 << 8) /**< \brief (RTC_CR) Every day at noon. */
#define RTC_CR_CALEVSEL (0x3 << 16) /**< \brief (RTC_CR) Calendar Event Selection */
#define   RTC_CR_CALEVSEL_WEEK (0x0 << 16) /**< \brief (RTC_CR) Week change (every Monday at time 00:00:00). */
#define   RTC_CR_CALEVSEL_MONTH (0x1 << 16) /**< \brief (RTC_CR) Month change (every 01 of each month at time 00:00:00). */
/* -------- RTC_MR : (RTC Offset: 0x04) Mode Register -------- */
#define RTC_MR_HRMOD (0x1 << 0) /**< \brief (RTC_MR) 12-/24-hour Mode */
/* -------- RTC_TIMR : (RTC Offset: 0x08) Time Register -------- */
#define RTC_TIMR_SEC (0x7f << 0) /**< \brief (RTC_TIMR) Current Second */
#define RTC_TIMR_MIN (0x7f << 8) /**< \brief (RTC_TIMR) Current Minute */
#define RTC_TIMR_HOUR (0x3f << 16) /**< \brief (RTC_TIMR) Current Hour */
#define RTC_TIMR_AMPM (0x1 << 22) /**< \brief (RTC_TIMR) Ante Meridiem Post Meridiem Indicator */
/* -------- RTC_CALR : (RTC Offset: 0x0C) Calendar Register -------- */
#define RTC_CALR_CENT (0x7f << 0) /**< \brief (RTC_CALR) Current Century */
#define RTC_CALR_YEAR (0xff << 8) /**< \brief (RTC_CALR) Current Year */
#define RTC_CALR_MONTH (0x1f << 16) /**< \brief (RTC_CALR) Current Month */
#define RTC_CALR_DAY (0x7 << 21) /**< \brief (RTC_CALR) Current Day in Current Week */
#define RTC_CALR_DATE (0x3f << 24) /**< \brief (RTC_CALR) Current Day in Current Month */
/* -------- RTC_TIMALR : (RTC Offset: 0x10) Time Alarm Register -------- */
#define RTC_TIMALR_SEC (0x7f << 0) /**< \brief (RTC_TIMALR) Second Alarm */
#define RTC_TIMALR_SECEN (0x1 << 7) /**< \brief (RTC_TIMALR) Second Alarm Enable */
#define RTC_TIMALR_MIN (0x7f << 8) /**< \brief (RTC_TIMALR) Minute Alarm */
#define RTC_TIMALR_MINEN (0x1 << 15) /**< \brief (RTC_TIMALR) Minute Alarm Enable */
#define RTC_TIMALR_HOUR (0x3f << 16) /**< \brief (RTC_TIMALR) Hour Alarm */
#define RTC_TIMALR_AMPM (0x1 << 22) /**< \brief (RTC_TIMALR) AM/PM Indicator */
#define RTC_TIMALR_HOUREN (0x1 << 23) /**< \brief (RTC_TIMALR) Hour Alarm Enable */
/* -------- RTC_CALALR : (RTC Offset: 0x14) Calendar Alarm Register -------- */
#define RTC_CALALR_MONTH (0x1f << 16) /**< \brief (RTC_CALALR) Month Alarm */
#define RTC_CALALR_MTHEN (0x1 << 23) /**< \brief (RTC_CALALR) Month Alarm Enable */
#define RTC_CALALR_DATE (0x3f << 24) /**< \brief (RTC_CALALR) Date Alarm */
#define RTC_CALALR_DATEEN (0x1 << 31) /**< \brief (RTC_CALALR) Date Alarm Enable */
/* -------- RTC_SR : (RTC Offset: 0x18) Status Register -------- */
#define RTC_SR_ACKUPD (0x1 << 0) /**< \brief (RTC_SR) Acknowledge for Update */
#define RTC_SR_ALARM (0x1 << 1) /**< \brief (RTC_SR) Alarm Flag */
#define RTC_SR_SEC (0x1 << 2) /**< \brief (RTC_SR) Second Event */
#define RTC_SR_TIMEV (0x1 << 3) /**< \brief (RTC_SR) Time Event */
#define RTC_SR_CALEV (0x1 << 4) /**< \brief (RTC_SR) Calendar Event */
/* -------- RTC_SCCR : (RTC Offset: 0x1C) Status Clear Command Register -------- */
#define RTC_SCCR_ACKCLR (0x1 << 0) /**< \brief (RTC_SCCR) Acknowledge Clear */
#define RTC_SCCR_ALRCLR (0x1 << 1) /**< \brief (RTC_SCCR) Alarm Clear */
#define RTC_SCCR_SECCLR (0x1 << 2) /**< \brief (RTC_SCCR) Second Clear */
#define RTC_SCCR_TIMCLR (0x1 << 3) /**< \brief (RTC_SCCR) Time Clear */
#define RTC_SCCR_CALCLR (0x1 << 4) /**< \brief (RTC_SCCR) Calendar Clear */
/* -------- RTC_IER : (RTC Offset: 0x20) Interrupt Enable Register -------- */
#define RTC_IER_ACKEN (0x1 << 0) /**< \brief (RTC_IER) Acknowledge Update Interrupt Enable */
#define RTC_IER_ALREN (0x1 << 1) /**< \brief (RTC_IER) Alarm Interrupt Enable */
#define RTC_IER_SECEN (0x1 << 2) /**< \brief (RTC_IER) Second Event Interrupt Enable */
#define RTC_IER_TIMEN (0x1 << 3) /**< \brief (RTC_IER) Time Event Interrupt Enable */
#define RTC_IER_CALEN (0x1 << 4) /**< \brief (RTC_IER) Calendar Event Interrupt Enable */
/* -------- RTC_IDR : (RTC Offset: 0x24) Interrupt Disable Register -------- */
#define RTC_IDR_ACKDIS (0x1 << 0) /**< \brief (RTC_IDR) Acknowledge Update Interrupt Disable */
#define RTC_IDR_ALRDIS (0x1 << 1) /**< \brief (RTC_IDR) Alarm Interrupt Disable */
#define RTC_IDR_SECDIS (0x1 << 2) /**< \brief (RTC_IDR) Second Event Interrupt Disable */
#define RTC_IDR_TIMDIS (0x1 << 3) /**< \brief (RTC_IDR) Time Event Interrupt Disable */
#define RTC_IDR_CALDIS (0x1 << 4) /**< \brief (RTC_IDR) Calendar Event Interrupt Disable */
/* -------- RTC_IMR : (RTC Offset: 0x28) Interrupt Mask Register -------- */
#define RTC_IMR_ACK (0x1 << 0) /**< \brief (RTC_IMR) Acknowledge Update Interrupt Mask */
#define RTC_IMR_ALR (0x1 << 1) /**< \brief (RTC_IMR) Alarm Interrupt Mask */
#define RTC_IMR_SEC (0x1 << 2) /**< \brief (RTC_IMR) Second Event Interrupt Mask */
#define RTC_IMR_TIM (0x1 << 3) /**< \brief (RTC_IMR) Time Event Interrupt Mask */
#define RTC_IMR_CAL (0x1 << 4) /**< \brief (RTC_IMR) Calendar Event Interrupt Mask */
/* -------- RTC_VER : (RTC Offset: 0x2C) Valid Entry Register -------- */
#define RTC_VER_NVTIM (0x1 << 0) /**< \brief (RTC_VER) Non-valid Time */
#define RTC_VER_NVCAL (0x1 << 1) /**< \brief (RTC_VER) Non-valid Calendar */
#define RTC_VER_NVTIMALR (0x1 << 2) /**< \brief (RTC_VER) Non-valid Time Alarm */
#define RTC_VER_NVCALALR (0x1 << 3) /**< \brief (RTC_VER) Non-valid Calendar Alarm */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Real-time Timer */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_RTT Real-time Timer */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Rtt hardware registers */
typedef struct {
  RwReg RTT_MR; /**< \brief (Rtt Offset: 0x00) Mode Register */
  RwReg RTT_AR; /**< \brief (Rtt Offset: 0x04) Alarm Register */
  RoReg RTT_VR; /**< \brief (Rtt Offset: 0x08) Value Register */
  RoReg RTT_SR; /**< \brief (Rtt Offset: 0x0C) Status Register */
} Rtt;
#endif /* __ASSEMBLY__ */
/* -------- RTT_MR : (RTT Offset: 0x00) Mode Register -------- */
#define RTT_MR_RTPRES (0xffff << 0) /**< \brief (RTT_MR) Real-time Timer Prescaler Value */
#define RTT_MR_ALMIEN (0x1 << 16) /**< \brief (RTT_MR) Alarm Interrupt Enable */
#define RTT_MR_RTTINCIEN (0x1 << 17) /**< \brief (RTT_MR) Real-time Timer Increment Interrupt Enable */
#define RTT_MR_RTTRST (0x1 << 18) /**< \brief (RTT_MR) Real-time Timer Restart */
/* -------- RTT_AR : (RTT Offset: 0x04) Alarm Register -------- */
#define RTT_AR_ALMV (0xffffffff << 0) /**< \brief (RTT_AR) Alarm Value */
/* -------- RTT_VR : (RTT Offset: 0x08) Value Register -------- */
#define RTT_VR_CRTV (0xffffffff << 0) /**< \brief (RTT_VR) Current Real-time Value */
/* -------- RTT_SR : (RTT Offset: 0x0C) Status Register -------- */
#define RTT_SR_ALMS (0x1 << 0) /**< \brief (RTT_SR) Real-time Alarm Status */
#define RTT_SR_RTTINC (0x1 << 1) /**< \brief (RTT_SR) Real-time Timer Increment */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Static Memory Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_SMC Static Memory Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief SmcCs_number hardware registers */
typedef struct {
  RwReg         SMC_SETUP;        /**< \brief (SmcCs_number Offset: 0x0) SMC SETUP Register */
  RwReg         SMC_PULSE;        /**< \brief (SmcCs_number Offset: 0x4) SMC PULSE Register */
  RwReg         SMC_CYCLE;        /**< \brief (SmcCs_number Offset: 0x8) SMC CYCLE Register */
  RwReg         SMC_TIMINGS;      /**< \brief (SmcCs_number Offset: 0xC) SMC TIMINGS Register */
  RwReg         SMC_MODE;         /**< \brief (SmcCs_number Offset: 0x10) SMC MODE Register */
} SmcCs_number;
/** \brief Smc hardware registers */
typedef struct {
  RwReg         SMC_CFG;          /**< \brief (Smc Offset: 0x000) SMC NFC Configuration Register */
  WoReg         SMC_CTRL;         /**< \brief (Smc Offset: 0x004) SMC NFC Control Register */
  RoReg         SMC_SR;           /**< \brief (Smc Offset: 0x008) SMC NFC Status Register */
  WoReg         SMC_IER;          /**< \brief (Smc Offset: 0x00C) SMC NFC Interrupt Enable Register */
  WoReg         SMC_IDR;          /**< \brief (Smc Offset: 0x010) SMC NFC Interrupt Disable Register */
  RoReg         SMC_IMR;          /**< \brief (Smc Offset: 0x014) SMC NFC Interrupt Mask Register */
  RwReg         SMC_ADDR;         /**< \brief (Smc Offset: 0x018) SMC NFC Address Cycle Zero Register */
  RwReg         SMC_BANK;         /**< \brief (Smc Offset: 0x01C) SMC Bank Address Register */
  WoReg         SMC_ECC_CTRL;     /**< \brief (Smc Offset: 0x020) SMC ECC Control Register */
  RwReg         SMC_ECC_MD;       /**< \brief (Smc Offset: 0x024) SMC ECC Mode Register */
  RoReg         SMC_ECC_SR1;      /**< \brief (Smc Offset: 0x028) SMC ECC Status 1 Register */
  RoReg         SMC_ECC_PR0;      /**< \brief (Smc Offset: 0x02C) SMC ECC Parity 0 Register */
  RoReg         SMC_ECC_PR1;      /**< \brief (Smc Offset: 0x030) SMC ECC parity 1 Register */
  RoReg         SMC_ECC_SR2;      /**< \brief (Smc Offset: 0x034) SMC ECC status 2 Register */
  RoReg         SMC_ECC_PR2;      /**< \brief (Smc Offset: 0x038) SMC ECC parity 2 Register */
  RoReg         SMC_ECC_PR3;      /**< \brief (Smc Offset: 0x03C) SMC ECC parity 3 Register */
  RoReg         SMC_ECC_PR4;      /**< \brief (Smc Offset: 0x040) SMC ECC parity 4 Register */
  RoReg         SMC_ECC_PR5;      /**< \brief (Smc Offset: 0x044) SMC ECC parity 5 Register */
  RoReg         SMC_ECC_PR6;      /**< \brief (Smc Offset: 0x048) SMC ECC parity 6 Register */
  RoReg         SMC_ECC_PR7;      /**< \brief (Smc Offset: 0x04C) SMC ECC parity 7 Register */
  RoReg         SMC_ECC_PR8;      /**< \brief (Smc Offset: 0x050) SMC ECC parity 8 Register */
  RoReg         SMC_ECC_PR9;      /**< \brief (Smc Offset: 0x054) SMC ECC parity 9 Register */
  RoReg         SMC_ECC_PR10;     /**< \brief (Smc Offset: 0x058) SMC ECC parity 10 Register */
  RoReg         SMC_ECC_PR11;     /**< \brief (Smc Offset: 0x05C) SMC ECC parity 11 Register */
  RoReg         SMC_ECC_PR12;     /**< \brief (Smc Offset: 0x060) SMC ECC parity 12 Register */
  RoReg         SMC_ECC_PR13;     /**< \brief (Smc Offset: 0x064) SMC ECC parity 13 Register */
  RoReg         SMC_ECC_PR14;     /**< \brief (Smc Offset: 0x068) SMC ECC parity 14 Register */
  RoReg         SMC_ECC_PR15;     /**< \brief (Smc Offset: 0x06C) SMC ECC parity 15 Register */
  SmcCs_number  SMC_CS_NUMBER[4]; /**< \brief (Smc Offset: 0x70) CS_number = 0 .. 3 */
  RwReg         Reserved1[20];   
  RwReg         SMC_OCMS;         /**< \brief (Smc Offset: 0x110) SMC OCMS MODE Register */
  WoReg         SMC_KEY1;         /**< \brief (Smc Offset: 0x114) SMC KEY1 Register */
  WoReg         SMC_KEY2;         /**< \brief (Smc Offset: 0x118) SMC KEY2 Register */
  RwReg         Reserved2[50];   
  WoReg         SMC_WPCR;         /**< \brief (Smc Offset: 0x1E4) Write Protection Control Register */
  RoReg         SMC_WPSR;         /**< \brief (Smc Offset: 0x1E8) Write Protection Status Register */
} Smc;
#endif /* __ASSEMBLY__ */
/* -------- SMC_CFG : (SMC Offset: 0x000) SMC NFC Configuration Register -------- */
#define SMC_CFG_PAGESIZE (0x3 << 0) /**< \brief (SMC_CFG)  */
#define SMC_CFG_WSPARE (0x1 << 8) /**< \brief (SMC_CFG) Write Spare Area */
#define SMC_CFG_RSPARE (0x1 << 9) /**< \brief (SMC_CFG) Read Spare Area */
#define SMC_CFG_EDGECTRL (0x1 << 12) /**< \brief (SMC_CFG) Rising/Falling Edge Detection Control */
#define SMC_CFG_RBEDGE (0x1 << 13) /**< \brief (SMC_CFG) Ready/Busy Signal Edge Detection */
#define SMC_CFG_DTOCYC (0xf << 16) /**< \brief (SMC_CFG) Data Timeout Cycle Number */
#define SMC_CFG_DTOMUL (0x7 << 20) /**< \brief (SMC_CFG) Data Timeout Multiplier */
/* -------- SMC_CTRL : (SMC Offset: 0x004) SMC NFC Control Register -------- */
#define SMC_CTRL_NFCEN (0x1 << 0) /**< \brief (SMC_CTRL) NAND Flash Controller Enable */
#define SMC_CTRL_NFCDIS (0x1 << 1) /**< \brief (SMC_CTRL) NAND Flash Controller Disable */
/* -------- SMC_SR : (SMC Offset: 0x008) SMC NFC Status Register -------- */
#define SMC_SR_SMCSTS (0x1 << 0) /**< \brief (SMC_SR) NAND Flash Controller status (this field cannot be reset) */
#define SMC_SR_RB_RISE (0x1 << 4) /**< \brief (SMC_SR) Selected Ready Busy Rising Edge Detected */
#define SMC_SR_RB_FALL (0x1 << 5) /**< \brief (SMC_SR) Selected Ready Busy Falling Edge Detected */
#define SMC_SR_NFCBUSY (0x1 << 8) /**< \brief (SMC_SR) NFC Busy (this field cannot be reset) */
#define SMC_SR_NFCWR (0x1 << 11) /**< \brief (SMC_SR) NFC Write/Read Operation (this field cannot be reset) */
#define SMC_SR_NFCSID (0x7 << 12) /**< \brief (SMC_SR) NFC Chip Select ID (this field cannot be reset) */
#define SMC_SR_XFRDONE (0x1 << 16) /**< \brief (SMC_SR) NFC Data Transfer Terminated */
#define SMC_SR_CMDDONE (0x1 << 17) /**< \brief (SMC_SR) Command Done */
#define SMC_SR_DTOE (0x1 << 20) /**< \brief (SMC_SR) Data Timeout Error */
#define SMC_SR_UNDEF (0x1 << 21) /**< \brief (SMC_SR) Undefined Area Error */
#define SMC_SR_AWB (0x1 << 22) /**< \brief (SMC_SR) Accessing While Busy */
#define SMC_SR_NFCASE (0x1 << 23) /**< \brief (SMC_SR) NFC Access Size Error */
#define SMC_SR_RB_EDGE0 (0x1 << 24) /**< \brief (SMC_SR) Ready/Busy Line 0 Edge Detected */
/* -------- SMC_IER : (SMC Offset: 0x00C) SMC NFC Interrupt Enable Register -------- */
#define SMC_IER_RB_RISE (0x1 << 4) /**< \brief (SMC_IER) Ready Busy Rising Edge Detection Interrupt Enable */
#define SMC_IER_RB_FALL (0x1 << 5) /**< \brief (SMC_IER) Ready Busy Falling Edge Detection Interrupt Enable */
#define SMC_IER_XFRDONE (0x1 << 16) /**< \brief (SMC_IER) Transfer Done Interrupt Enable */
#define SMC_IER_CMDDONE (0x1 << 17) /**< \brief (SMC_IER) Command Done Interrupt Enable */
#define SMC_IER_DTOE (0x1 << 20) /**< \brief (SMC_IER) Data Timeout Error Interrupt Enable */
#define SMC_IER_UNDEF (0x1 << 21) /**< \brief (SMC_IER) Undefined Area Access Interrupt Enable */
#define SMC_IER_AWB (0x1 << 22) /**< \brief (SMC_IER) Accessing While Busy Interrupt Enable */
#define SMC_IER_NFCASE (0x1 << 23) /**< \brief (SMC_IER) NFC Access Size Error Interrupt Enable */
#define SMC_IER_RB_EDGE0 (0x1 << 24) /**< \brief (SMC_IER) Ready/Busy Line 0 Interrupt Enable */
/* -------- SMC_IDR : (SMC Offset: 0x010) SMC NFC Interrupt Disable Register -------- */
#define SMC_IDR_RB_RISE (0x1 << 4) /**< \brief (SMC_IDR) Ready Busy Rising Edge Detection Interrupt Disable */
#define SMC_IDR_RB_FALL (0x1 << 5) /**< \brief (SMC_IDR) Ready Busy Falling Edge Detection Interrupt Disable */
#define SMC_IDR_XFRDONE (0x1 << 16) /**< \brief (SMC_IDR) Transfer Done Interrupt Disable */
#define SMC_IDR_CMDDONE (0x1 << 17) /**< \brief (SMC_IDR) Command Done Interrupt Disable */
#define SMC_IDR_DTOE (0x1 << 20) /**< \brief (SMC_IDR) Data Timeout Error Interrupt Disable */
#define SMC_IDR_UNDEF (0x1 << 21) /**< \brief (SMC_IDR) Undefined Area Access Interrupt Disable */
#define SMC_IDR_AWB (0x1 << 22) /**< \brief (SMC_IDR) Accessing While Busy Interrupt Disable */
#define SMC_IDR_NFCASE (0x1 << 23) /**< \brief (SMC_IDR) NFC Access Size Error Interrupt Disable */
#define SMC_IDR_RB_EDGE0 (0x1 << 24) /**< \brief (SMC_IDR) Ready/Busy Line 0 Interrupt Disable */
/* -------- SMC_IMR : (SMC Offset: 0x014) SMC NFC Interrupt Mask Register -------- */
#define SMC_IMR_RB_RISE (0x1 << 4) /**< \brief (SMC_IMR) Ready Busy Rising Edge Detection Interrupt Mask */
#define SMC_IMR_RB_FALL (0x1 << 5) /**< \brief (SMC_IMR) Ready Busy Falling Edge Detection Interrupt Mask */
#define SMC_IMR_XFRDONE (0x1 << 16) /**< \brief (SMC_IMR) Transfer Done Interrupt Mask */
#define SMC_IMR_CMDDONE (0x1 << 17) /**< \brief (SMC_IMR) Command Done Interrupt Mask */
#define SMC_IMR_DTOE (0x1 << 20) /**< \brief (SMC_IMR) Data Timeout Error Interrupt Mask */
#define SMC_IMR_UNDEF (0x1 << 21) /**< \brief (SMC_IMR) Undefined Area Access Interrupt Mask5 */
#define SMC_IMR_AWB (0x1 << 22) /**< \brief (SMC_IMR) Accessing While Busy Interrupt Mask */
#define SMC_IMR_NFCASE (0x1 << 23) /**< \brief (SMC_IMR) NFC Access Size Error Interrupt Mask */
#define SMC_IMR_RB_EDGE0 (0x1 << 24) /**< \brief (SMC_IMR) Ready/Busy Line 0 Interrupt Mask */
/* -------- SMC_ADDR : (SMC Offset: 0x018) SMC NFC Address Cycle Zero Register -------- */
#define SMC_ADDR_ADDR_CYCLE0 (0xff << 0) /**< \brief (SMC_ADDR) NAND Flash Array Address cycle 0 */
/* -------- SMC_BANK : (SMC Offset: 0x01C) SMC Bank Address Register -------- */
#define SMC_BANK_BANK (0x7 << 0) /**< \brief (SMC_BANK) Bank Identifier */
/* -------- SMC_ECC_CTRL : (SMC Offset: 0x020) SMC ECC Control Register -------- */
#define SMC_ECC_CTRL_RST (0x1 << 0) /**< \brief (SMC_ECC_CTRL) Reset ECC */
#define SMC_ECC_CTRL_SWRST (0x1 << 1) /**< \brief (SMC_ECC_CTRL) Software Reset */
/* -------- SMC_ECC_MD : (SMC Offset: 0x024) SMC ECC Mode Register -------- */
#define SMC_ECC_MD_ECC_PAGESIZE (0x3 << 0) /**< \brief (SMC_ECC_MD)  */
#define SMC_ECC_MD_TYPCORREC (0x3 << 4) /**< \brief (SMC_ECC_MD) type of correction */
/* -------- SMC_ECC_SR1 : (SMC Offset: 0x028) SMC ECC Status 1 Register -------- */
#define SMC_ECC_SR1_RECERR0 (0x1 << 0) /**< \brief (SMC_ECC_SR1) Recoverable Error */
#define SMC_ECC_SR1_ECCERR0 (0x3 << 1) /**< \brief (SMC_ECC_SR1) ECC Error */
#define SMC_ECC_SR1_RECERR1 (0x1 << 4) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 256th and the 511th bytes or the 512nd and the 1023rd bytes */
#define SMC_ECC_SR1_ECCERR1 (0x1 << 5) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 256th and the 511th bytes or between the 512nd and the 1023rd bytes */
#define SMC_ECC_SR1_MULERR1 (0x1 << 6) /**< \brief (SMC_ECC_SR1) Multiple Error in the page between the 256th and the 511th bytes or between the 512nd and the 1023rd bytes */
#define SMC_ECC_SR1_RECERR2 (0x1 << 8) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes */
#define SMC_ECC_SR1_ECCERR2 (0x1 << 9) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes */
#define SMC_ECC_SR1_MULERR2 (0x1 << 10) /**< \brief (SMC_ECC_SR1) Multiple Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes */
#define SMC_ECC_SR1_RECERR3 (0x1 << 12) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes */
#define SMC_ECC_SR1_ECCERR3 (0x1 << 13) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes */
#define SMC_ECC_SR1_MULERR3 (0x1 << 14) /**< \brief (SMC_ECC_SR1) Multiple Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes */
#define SMC_ECC_SR1_RECERR4 (0x1 << 16) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 1024th and the 1279th bytes or between the 2048th and the 2559th bytes */
#define SMC_ECC_SR1_ECCERR4 (0x3 << 17) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 1024th and the 1279th bytes or between the 2048th and the 2559th bytes */
#define SMC_ECC_SR1_RECERR5 (0x1 << 20) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 1280th and the 1535th bytes or between the 2560th and the 3071st bytes */
#define SMC_ECC_SR1_ECCERR5 (0x3 << 21) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 1280th and the 1535th bytes or between the 2560th and the 3071st bytes */
#define SMC_ECC_SR1_RECERR6 (0x1 << 24) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 1536th and the 1791st bytes or between the 3072nd and the 3583rd bytes */
#define SMC_ECC_SR1_ECCERR6 (0x3 << 25) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 1536th and the 1791st bytes or between the 3072nd and the 3583rd bytes */
#define SMC_ECC_SR1_RECERR7 (0x1 << 28) /**< \brief (SMC_ECC_SR1) Recoverable Error in the page between the 1792nd and the 2047th bytes or between the 3584th and the 4095th bytes */
#define SMC_ECC_SR1_ECCERR7 (0x3 << 29) /**< \brief (SMC_ECC_SR1) ECC Error in the page between the 1792nd and the 2047th bytes or between the 3584th and the 4095th bytes */
/* -------- SMC_ECC_PR0 : (SMC Offset: 0x02C) SMC ECC Parity 0 Register -------- */
#define SMC_ECC_PR0_BITADDR (0xf << 0) /**< \brief (SMC_ECC_PR0) Bit Address */
#define SMC_ECC_PR0_WORDADDR (0xfff << 4) /**< \brief (SMC_ECC_PR0) Word Address */
/* -------- SMC_ECC_PR1 : (SMC Offset: 0x030) SMC ECC parity 1 Register -------- */
#define SMC_ECC_PR1_NPARITY (0xffff << 0) /**< \brief (SMC_ECC_PR1)  */
/* -------- SMC_ECC_SR2 : (SMC Offset: 0x034) SMC ECC status 2 Register -------- */
#define SMC_ECC_SR2_RECERR8 (0x1 << 0) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 2048th and the 2303rd bytes */
#define SMC_ECC_SR2_ECCERR8 (0x3 << 1) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 2048th and the 2303rd bytes */
#define SMC_ECC_SR2_RECERR9 (0x1 << 4) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 2304th and the 2559th bytes */
#define SMC_ECC_SR2_ECCERR9 (0x1 << 5) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 2304th and the 2559th bytes */
#define SMC_ECC_SR2_MULERR9 (0x1 << 6) /**< \brief (SMC_ECC_SR2) Multiple Error in the page between the 2304th and the 2559th bytes */
#define SMC_ECC_SR2_RECERR10 (0x1 << 8) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 2560th and the 2815th bytes */
#define SMC_ECC_SR2_ECCERR10 (0x1 << 9) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 2560th and the 2815th bytes */
#define SMC_ECC_SR2_MULERR10 (0x1 << 10) /**< \brief (SMC_ECC_SR2) Multiple Error in the page between the 2560th and the 2815th bytes */
#define SMC_ECC_SR2_RECERR11 (0x1 << 12) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 2816th and the 3071st bytes */
#define SMC_ECC_SR2_ECCERR11 (0x1 << 13) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 2816th and the 3071st bytes */
#define SMC_ECC_SR2_MULERR11 (0x1 << 14) /**< \brief (SMC_ECC_SR2) Multiple Error in the page between the 2816th and the 3071st bytes */
#define SMC_ECC_SR2_RECERR12 (0x1 << 16) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 3072nd and the 3327th bytes */
#define SMC_ECC_SR2_ECCERR12 (0x3 << 17) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 3072nd and the 3327th bytes */
#define SMC_ECC_SR2_RECERR13 (0x1 << 20) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 3328th and the 3583rd bytes */
#define SMC_ECC_SR2_ECCERR13 (0x3 << 21) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 3328th and the 3583rd bytes */
#define SMC_ECC_SR2_RECERR14 (0x1 << 24) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 3584th and the 3839th bytes */
#define SMC_ECC_SR2_ECCERR14 (0x3 << 25) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 3584th and the 3839th bytes */
#define SMC_ECC_SR2_RECERR15 (0x1 << 28) /**< \brief (SMC_ECC_SR2) Recoverable Error in the page between the 3840th and the 4095th bytes */
#define SMC_ECC_SR2_ECCERR15 (0x3 << 29) /**< \brief (SMC_ECC_SR2) ECC Error in the page between the 3840th and the 4095th bytes */
/* -------- SMC_ECC_PR2 : (SMC Offset: 0x038) SMC ECC parity 2 Register -------- */
/* -------- SMC_ECC_PR3 : (SMC Offset: 0x03C) SMC ECC parity 3 Register -------- */
/* -------- SMC_ECC_PR4 : (SMC Offset: 0x040) SMC ECC parity 4 Register -------- */
/* -------- SMC_ECC_PR5 : (SMC Offset: 0x044) SMC ECC parity 5 Register -------- */
/* -------- SMC_ECC_PR6 : (SMC Offset: 0x048) SMC ECC parity 6 Register -------- */
/* -------- SMC_ECC_PR7 : (SMC Offset: 0x04C) SMC ECC parity 7 Register -------- */
/* -------- SMC_ECC_PR8 : (SMC Offset: 0x050) SMC ECC parity 8 Register -------- */
/* -------- SMC_ECC_PR9 : (SMC Offset: 0x054) SMC ECC parity 9 Register -------- */
/* -------- SMC_ECC_PR10 : (SMC Offset: 0x058) SMC ECC parity 10 Register -------- */
/* -------- SMC_ECC_PR11 : (SMC Offset: 0x05C) SMC ECC parity 11 Register -------- */
/* -------- SMC_ECC_PR12 : (SMC Offset: 0x060) SMC ECC parity 12 Register -------- */
/* -------- SMC_ECC_PR13 : (SMC Offset: 0x064) SMC ECC parity 13 Register -------- */
/* -------- SMC_ECC_PR14 : (SMC Offset: 0x068) SMC ECC parity 14 Register -------- */
/* -------- SMC_ECC_PR15 : (SMC Offset: 0x06C) SMC ECC parity 15 Register -------- */
/* -------- SMC_SETUP0 : (SMC Offset: 0x70) SMC SETUP Register (CS_number = 0) -------- */
#define SMC_SETUP0_NWE_SETUP (0x3f << 0) /**< \brief (SMC_SETUP0) NWE Setup length */
#define SMC_SETUP0_NCS_WR_SETUP (0x3f << 8) /**< \brief (SMC_SETUP0) NCS Setup length in Write access */
#define SMC_SETUP0_NRD_SETUP (0x3f << 16) /**< \brief (SMC_SETUP0) NRD Setup length */
#define SMC_SETUP0_NCS_RD_SETUP (0x3f << 24) /**< \brief (SMC_SETUP0) NCS Setup length in Read access */
/* -------- SMC_PULSE0 : (SMC Offset: 0x74) SMC PULSE Register (CS_number = 0) -------- */
#define SMC_PULSE0_NWE_PULSE (0x3f << 0) /**< \brief (SMC_PULSE0) NWE Pulse Length */
#define SMC_PULSE0_NCS_WR_PULSE (0x3f << 8) /**< \brief (SMC_PULSE0) NCS Pulse Length in WRITE Access */
#define SMC_PULSE0_NRD_PULSE (0x3f << 16) /**< \brief (SMC_PULSE0) NRD Pulse Length */
#define SMC_PULSE0_NCS_RD_PULSE (0x3f << 24) /**< \brief (SMC_PULSE0) NCS Pulse Length in READ Access */
/* -------- SMC_CYCLE0 : (SMC Offset: 0x78) SMC CYCLE Register (CS_number = 0) -------- */
#define SMC_CYCLE0_NWE_CYCLE (0x1ff << 0) /**< \brief (SMC_CYCLE0) Total Write Cycle Length */
#define SMC_CYCLE0_NRD_CYCLE (0x1ff << 16) /**< \brief (SMC_CYCLE0) Total Read Cycle Length */
/* -------- SMC_TIMINGS0 : (SMC Offset: 0x7C) SMC TIMINGS Register (CS_number = 0) -------- */
#define SMC_TIMINGS0_TCLR (0xf << 0) /**< \brief (SMC_TIMINGS0) CLE to REN Low Delay */
#define SMC_TIMINGS0_TADL (0xf << 4) /**< \brief (SMC_TIMINGS0) ALE to Data Start */
#define SMC_TIMINGS0_TAR (0xf << 8) /**< \brief (SMC_TIMINGS0) ALE to REN Low Delay */
#define SMC_TIMINGS0_OCMS (0x1 << 12) /**< \brief (SMC_TIMINGS0) Off Chip Memory Scrambling Enable */
#define SMC_TIMINGS0_TRR (0xf << 16) /**< \brief (SMC_TIMINGS0) Ready to REN Low Delay */
#define SMC_TIMINGS0_TWB (0xf << 24) /**< \brief (SMC_TIMINGS0) WEN High to REN to Busy */
#define SMC_TIMINGS0_RBNSEL (0x7 << 28) /**< \brief (SMC_TIMINGS0) Ready/Busy Line Selection */
#define SMC_TIMINGS0_NFSEL (0x1 << 31) /**< \brief (SMC_TIMINGS0) NAND Flash Selection */
/* -------- SMC_MODE0 : (SMC Offset: 0x80) SMC MODE Register (CS_number = 0) -------- */
#define SMC_MODE0_READ_MODE (0x1 << 0) /**< \brief (SMC_MODE0)  */
#define SMC_MODE0_WRITE_MODE (0x1 << 1) /**< \brief (SMC_MODE0)  */
#define SMC_MODE0_EXNW_MODE (0x3 << 4) /**< \brief (SMC_MODE0) NWAIT Mode */
#define SMC_MODE0_BAT (0x1 << 8) /**< \brief (SMC_MODE0) Byte Access Type */
#define SMC_MODE0_DBW (0x1 << 12) /**< \brief (SMC_MODE0) Data Bus Width */
#define SMC_MODE0_TDF_CYCLES (0xf << 16) /**< \brief (SMC_MODE0) Data Float Time */
#define SMC_MODE0_TDF_MODE (0x1 << 20) /**< \brief (SMC_MODE0) TDF Optimization */
/* -------- SMC_SETUP1 : (SMC Offset: 0x84) SMC SETUP Register (CS_number = 1) -------- */
#define SMC_SETUP1_NWE_SETUP (0x3f << 0) /**< \brief (SMC_SETUP1) NWE Setup length */
#define SMC_SETUP1_NCS_WR_SETUP (0x3f << 8) /**< \brief (SMC_SETUP1) NCS Setup length in Write access */
#define SMC_SETUP1_NRD_SETUP (0x3f << 16) /**< \brief (SMC_SETUP1) NRD Setup length */
#define SMC_SETUP1_NCS_RD_SETUP (0x3f << 24) /**< \brief (SMC_SETUP1) NCS Setup length in Read access */
/* -------- SMC_PULSE1 : (SMC Offset: 0x88) SMC PULSE Register (CS_number = 1) -------- */
#define SMC_PULSE1_NWE_PULSE (0x3f << 0) /**< \brief (SMC_PULSE1) NWE Pulse Length */
#define SMC_PULSE1_NCS_WR_PULSE (0x3f << 8) /**< \brief (SMC_PULSE1) NCS Pulse Length in WRITE Access */
#define SMC_PULSE1_NRD_PULSE (0x3f << 16) /**< \brief (SMC_PULSE1) NRD Pulse Length */
#define SMC_PULSE1_NCS_RD_PULSE (0x3f << 24) /**< \brief (SMC_PULSE1) NCS Pulse Length in READ Access */
/* -------- SMC_CYCLE1 : (SMC Offset: 0x8C) SMC CYCLE Register (CS_number = 1) -------- */
#define SMC_CYCLE1_NWE_CYCLE (0x1ff << 0) /**< \brief (SMC_CYCLE1) Total Write Cycle Length */
#define SMC_CYCLE1_NRD_CYCLE (0x1ff << 16) /**< \brief (SMC_CYCLE1) Total Read Cycle Length */
/* -------- SMC_TIMINGS1 : (SMC Offset: 0x90) SMC TIMINGS Register (CS_number = 1) -------- */
#define SMC_TIMINGS1_TCLR (0xf << 0) /**< \brief (SMC_TIMINGS1) CLE to REN Low Delay */
#define SMC_TIMINGS1_TADL (0xf << 4) /**< \brief (SMC_TIMINGS1) ALE to Data Start */
#define SMC_TIMINGS1_TAR (0xf << 8) /**< \brief (SMC_TIMINGS1) ALE to REN Low Delay */
#define SMC_TIMINGS1_OCMS (0x1 << 12) /**< \brief (SMC_TIMINGS1) Off Chip Memory Scrambling Enable */
#define SMC_TIMINGS1_TRR (0xf << 16) /**< \brief (SMC_TIMINGS1) Ready to REN Low Delay */
#define SMC_TIMINGS1_TWB (0xf << 24) /**< \brief (SMC_TIMINGS1) WEN High to REN to Busy */
#define SMC_TIMINGS1_RBNSEL (0x7 << 28) /**< \brief (SMC_TIMINGS1) Ready/Busy Line Selection */
#define SMC_TIMINGS1_NFSEL (0x1 << 31) /**< \brief (SMC_TIMINGS1) NAND Flash Selection */
/* -------- SMC_MODE1 : (SMC Offset: 0x94) SMC MODE Register (CS_number = 1) -------- */
#define SMC_MODE1_READ_MODE (0x1 << 0) /**< \brief (SMC_MODE1)  */
#define SMC_MODE1_WRITE_MODE (0x1 << 1) /**< \brief (SMC_MODE1)  */
#define SMC_MODE1_EXNW_MODE (0x3 << 4) /**< \brief (SMC_MODE1) NWAIT Mode */
#define SMC_MODE1_BAT (0x1 << 8) /**< \brief (SMC_MODE1) Byte Access Type */
#define SMC_MODE1_DBW (0x1 << 12) /**< \brief (SMC_MODE1) Data Bus Width */
#define SMC_MODE1_TDF_CYCLES (0xf << 16) /**< \brief (SMC_MODE1) Data Float Time */
#define SMC_MODE1_TDF_MODE (0x1 << 20) /**< \brief (SMC_MODE1) TDF Optimization */
/* -------- SMC_SETUP2 : (SMC Offset: 0x98) SMC SETUP Register (CS_number = 2) -------- */
#define SMC_SETUP2_NWE_SETUP (0x3f << 0) /**< \brief (SMC_SETUP2) NWE Setup length */
#define SMC_SETUP2_NCS_WR_SETUP (0x3f << 8) /**< \brief (SMC_SETUP2) NCS Setup length in Write access */
#define SMC_SETUP2_NRD_SETUP (0x3f << 16) /**< \brief (SMC_SETUP2) NRD Setup length */
#define SMC_SETUP2_NCS_RD_SETUP (0x3f << 24) /**< \brief (SMC_SETUP2) NCS Setup length in Read access */
/* -------- SMC_PULSE2 : (SMC Offset: 0x9C) SMC PULSE Register (CS_number = 2) -------- */
#define SMC_PULSE2_NWE_PULSE (0x3f << 0) /**< \brief (SMC_PULSE2) NWE Pulse Length */
#define SMC_PULSE2_NCS_WR_PULSE (0x3f << 8) /**< \brief (SMC_PULSE2) NCS Pulse Length in WRITE Access */
#define SMC_PULSE2_NRD_PULSE (0x3f << 16) /**< \brief (SMC_PULSE2) NRD Pulse Length */
#define SMC_PULSE2_NCS_RD_PULSE (0x3f << 24) /**< \brief (SMC_PULSE2) NCS Pulse Length in READ Access */
/* -------- SMC_CYCLE2 : (SMC Offset: 0xA0) SMC CYCLE Register (CS_number = 2) -------- */
#define SMC_CYCLE2_NWE_CYCLE (0x1ff << 0) /**< \brief (SMC_CYCLE2) Total Write Cycle Length */
#define SMC_CYCLE2_NRD_CYCLE (0x1ff << 16) /**< \brief (SMC_CYCLE2) Total Read Cycle Length */
/* -------- SMC_TIMINGS2 : (SMC Offset: 0xA4) SMC TIMINGS Register (CS_number = 2) -------- */
#define SMC_TIMINGS2_TCLR (0xf << 0) /**< \brief (SMC_TIMINGS2) CLE to REN Low Delay */
#define SMC_TIMINGS2_TADL (0xf << 4) /**< \brief (SMC_TIMINGS2) ALE to Data Start */
#define SMC_TIMINGS2_TAR (0xf << 8) /**< \brief (SMC_TIMINGS2) ALE to REN Low Delay */
#define SMC_TIMINGS2_OCMS (0x1 << 12) /**< \brief (SMC_TIMINGS2) Off Chip Memory Scrambling Enable */
#define SMC_TIMINGS2_TRR (0xf << 16) /**< \brief (SMC_TIMINGS2) Ready to REN Low Delay */
#define SMC_TIMINGS2_TWB (0xf << 24) /**< \brief (SMC_TIMINGS2) WEN High to REN to Busy */
#define SMC_TIMINGS2_RBNSEL (0x7 << 28) /**< \brief (SMC_TIMINGS2) Ready/Busy Line Selection */
#define SMC_TIMINGS2_NFSEL (0x1 << 31) /**< \brief (SMC_TIMINGS2) NAND Flash Selection */
/* -------- SMC_MODE2 : (SMC Offset: 0xA8) SMC MODE Register (CS_number = 2) -------- */
#define SMC_MODE2_READ_MODE (0x1 << 0) /**< \brief (SMC_MODE2)  */
#define SMC_MODE2_WRITE_MODE (0x1 << 1) /**< \brief (SMC_MODE2)  */
#define SMC_MODE2_EXNW_MODE (0x3 << 4) /**< \brief (SMC_MODE2) NWAIT Mode */
#define SMC_MODE2_BAT (0x1 << 8) /**< \brief (SMC_MODE2) Byte Access Type */
#define SMC_MODE2_DBW (0x1 << 12) /**< \brief (SMC_MODE2) Data Bus Width */
#define SMC_MODE2_TDF_CYCLES (0xf << 16) /**< \brief (SMC_MODE2) Data Float Time */
#define SMC_MODE2_TDF_MODE (0x1 << 20) /**< \brief (SMC_MODE2) TDF Optimization */
/* -------- SMC_SETUP3 : (SMC Offset: 0xAC) SMC SETUP Register (CS_number = 3) -------- */
#define SMC_SETUP3_NWE_SETUP (0x3f << 0) /**< \brief (SMC_SETUP3) NWE Setup length */
#define SMC_SETUP3_NCS_WR_SETUP (0x3f << 8) /**< \brief (SMC_SETUP3) NCS Setup length in Write access */
#define SMC_SETUP3_NRD_SETUP (0x3f << 16) /**< \brief (SMC_SETUP3) NRD Setup length */
#define SMC_SETUP3_NCS_RD_SETUP (0x3f << 24) /**< \brief (SMC_SETUP3) NCS Setup length in Read access */
/* -------- SMC_PULSE3 : (SMC Offset: 0xB0) SMC PULSE Register (CS_number = 3) -------- */
#define SMC_PULSE3_NWE_PULSE (0x3f << 0) /**< \brief (SMC_PULSE3) NWE Pulse Length */
#define SMC_PULSE3_NCS_WR_PULSE (0x3f << 8) /**< \brief (SMC_PULSE3) NCS Pulse Length in WRITE Access */
#define SMC_PULSE3_NRD_PULSE (0x3f << 16) /**< \brief (SMC_PULSE3) NRD Pulse Length */
#define SMC_PULSE3_NCS_RD_PULSE (0x3f << 24) /**< \brief (SMC_PULSE3) NCS Pulse Length in READ Access */
/* -------- SMC_CYCLE3 : (SMC Offset: 0xB4) SMC CYCLE Register (CS_number = 3) -------- */
#define SMC_CYCLE3_NWE_CYCLE (0x1ff << 0) /**< \brief (SMC_CYCLE3) Total Write Cycle Length */
#define SMC_CYCLE3_NRD_CYCLE (0x1ff << 16) /**< \brief (SMC_CYCLE3) Total Read Cycle Length */
/* -------- SMC_TIMINGS3 : (SMC Offset: 0xB8) SMC TIMINGS Register (CS_number = 3) -------- */
#define SMC_TIMINGS3_TCLR (0xf << 0) /**< \brief (SMC_TIMINGS3) CLE to REN Low Delay */
#define SMC_TIMINGS3_TADL (0xf << 4) /**< \brief (SMC_TIMINGS3) ALE to Data Start */
#define SMC_TIMINGS3_TAR (0xf << 8) /**< \brief (SMC_TIMINGS3) ALE to REN Low Delay */
#define SMC_TIMINGS3_OCMS (0x1 << 12) /**< \brief (SMC_TIMINGS3) Off Chip Memory Scrambling Enable */
#define SMC_TIMINGS3_TRR (0xf << 16) /**< \brief (SMC_TIMINGS3) Ready to REN Low Delay */
#define SMC_TIMINGS3_TWB (0xf << 24) /**< \brief (SMC_TIMINGS3) WEN High to REN to Busy */
#define SMC_TIMINGS3_RBNSEL (0x7 << 28) /**< \brief (SMC_TIMINGS3) Ready/Busy Line Selection */
#define SMC_TIMINGS3_NFSEL (0x1 << 31) /**< \brief (SMC_TIMINGS3) NAND Flash Selection */
/* -------- SMC_MODE3 : (SMC Offset: 0xBC) SMC MODE Register (CS_number = 3) -------- */
#define SMC_MODE3_READ_MODE (0x1 << 0) /**< \brief (SMC_MODE3)  */
#define SMC_MODE3_WRITE_MODE (0x1 << 1) /**< \brief (SMC_MODE3)  */
#define SMC_MODE3_EXNW_MODE (0x3 << 4) /**< \brief (SMC_MODE3) NWAIT Mode */
#define SMC_MODE3_BAT (0x1 << 8) /**< \brief (SMC_MODE3) Byte Access Type */
#define SMC_MODE3_DBW (0x1 << 12) /**< \brief (SMC_MODE3) Data Bus Width */
#define SMC_MODE3_TDF_CYCLES (0xf << 16) /**< \brief (SMC_MODE3) Data Float Time */
#define SMC_MODE3_TDF_MODE (0x1 << 20) /**< \brief (SMC_MODE3) TDF Optimization */
/* -------- SMC_OCMS : (SMC Offset: 0x110) SMC OCMS MODE Register -------- */
#define SMC_OCMS_SMSE (0x1 << 0) /**< \brief (SMC_OCMS) Static Memory Controller Scrambling Enable */
#define SMC_OCMS_SRSE (0x1 << 1) /**< \brief (SMC_OCMS) SRAM Scrambling Enable */
/* -------- SMC_KEY1 : (SMC Offset: 0x114) SMC KEY1 Register -------- */
#define SMC_KEY1_KEY1 (0xffffffff << 0) /**< \brief (SMC_KEY1) Off Chip Memory Scrambling (OCMS) Key Part 1 */
/* -------- SMC_KEY2 : (SMC Offset: 0x118) SMC KEY2 Register -------- */
#define SMC_KEY2_KEY2 (0xffffffff << 0) /**< \brief (SMC_KEY2) Off Chip Memory Scrambling (OCMS) Key Part 2 */
/* -------- SMC_WPCR : (SMC Offset: 0x1E4) Write Protection Control Register -------- */
#define SMC_WPCR_WP_EN (0x1 << 0) /**< \brief (SMC_WPCR)  */
#define SMC_WPCR_WP_KEY (0xffffff << 8) /**< \brief (SMC_WPCR) Write Protection KEY password */
/* -------- SMC_WPSR : (SMC Offset: 0x1E8) Write Protection Status Register -------- */
#define SMC_WPSR_WP_VS (0xf << 0) /**< \brief (SMC_WPSR) Write Protection Violation Status */
#define SMC_WPSR_WP_VSRC (0xffff << 8) /**< \brief (SMC_WPSR) Write Protection Violation SouRCe */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Serial Peripheral Interface */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_SPI Serial Peripheral Interface */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Spi hardware registers */
typedef struct {
  WoReg SPI_CR;        /**< \brief (Spi Offset: 0x00) Control Register */
  RwReg SPI_MR;        /**< \brief (Spi Offset: 0x04) Mode Register */
  RoReg SPI_RDR;       /**< \brief (Spi Offset: 0x08) Receive Data Register */
  WoReg SPI_TDR;       /**< \brief (Spi Offset: 0x0C) Transmit Data Register */
  RoReg SPI_SR;        /**< \brief (Spi Offset: 0x10) Status Register */
  WoReg SPI_IER;       /**< \brief (Spi Offset: 0x14) Interrupt Enable Register */
  WoReg SPI_IDR;       /**< \brief (Spi Offset: 0x18) Interrupt Disable Register */
  RoReg SPI_IMR;       /**< \brief (Spi Offset: 0x1C) Interrupt Mask Register */
  RwReg Reserved1[4]; 
  RwReg SPI_CSR[4];    /**< \brief (Spi Offset: 0x30) Chip Select Register */
  RwReg Reserved2[41];
  RwReg SPI_WPCR;      /**< \brief (Spi Offset: 0xE4) Write Protection Control Register */
  RoReg SPI_WPSR;      /**< \brief (Spi Offset: 0xE8) Write Protection Status Register */
} Spi;
#endif /* __ASSEMBLY__ */
/* -------- SPI_CR : (SPI Offset: 0x00) Control Register -------- */
#define SPI_CR_SPIEN (0x1 << 0) /**< \brief (SPI_CR) SPI Enable */
#define SPI_CR_SPIDIS (0x1 << 1) /**< \brief (SPI_CR) SPI Disable */
#define SPI_CR_SWRST (0x1 << 7) /**< \brief (SPI_CR) SPI Software Reset */
#define SPI_CR_LASTXFER (0x1 << 24) /**< \brief (SPI_CR) Last Transfer */
/* -------- SPI_MR : (SPI Offset: 0x04) Mode Register -------- */
#define SPI_MR_MSTR (0x1 << 0) /**< \brief (SPI_MR) Master/Slave Mode */
#define SPI_MR_PS (0x1 << 1) /**< \brief (SPI_MR) Peripheral Select */
#define   SPI_MR_PS_FIXED (0x0 << 1) /**< \brief (SPI_MR) Fixed Peripheral Select. */
#define   SPI_MR_PS_VARIABLE (0x1 << 1) /**< \brief (SPI_MR) Variable Peripheral Select. */
#define SPI_MR_PCSDEC (0x1 << 2) /**< \brief (SPI_MR) Chip Select Decode */
#define SPI_MR_MODFDIS (0x1 << 4) /**< \brief (SPI_MR) Mode Fault Detection */
#define SPI_MR_WDRBT (0x1 << 5) /**< \brief (SPI_MR) Wait Data Read Before Transfer */
#define SPI_MR_LLB (0x1 << 7) /**< \brief (SPI_MR) Local Loopback Enable */
#define SPI_MR_PCS (0xf << 16) /**< \brief (SPI_MR) Peripheral Chip Select */
#define SPI_MR_DLYBCS (0xff << 24) /**< \brief (SPI_MR) Delay Between Chip Selects */
/* -------- SPI_RDR : (SPI Offset: 0x08) Receive Data Register -------- */
#define SPI_RDR_RD (0xffff << 0) /**< \brief (SPI_RDR) Receive Data */
#define SPI_RDR_PCS (0xf << 16) /**< \brief (SPI_RDR) Peripheral Chip Select */
/* -------- SPI_TDR : (SPI Offset: 0x0C) Transmit Data Register -------- */
#define SPI_TDR_TD (0xffff << 0) /**< \brief (SPI_TDR) Transmit Data */
#define SPI_TDR_PCS (0xf << 16) /**< \brief (SPI_TDR) Peripheral Chip Select */
#define SPI_TDR_LASTXFER (0x1 << 24) /**< \brief (SPI_TDR) Last Transfer */
/* -------- SPI_SR : (SPI Offset: 0x10) Status Register -------- */
#define SPI_SR_RDRF (0x1 << 0) /**< \brief (SPI_SR) Receive Data Register Full */
#define SPI_SR_TDRE (0x1 << 1) /**< \brief (SPI_SR) Transmit Data Register Empty */
#define SPI_SR_MODF (0x1 << 2) /**< \brief (SPI_SR) Mode Fault Error */
#define SPI_SR_OVRES (0x1 << 3) /**< \brief (SPI_SR) Overrun Error Status */
#define SPI_SR_RXBUFF (0x1 << 6) /**< \brief (SPI_SR)  */
#define SPI_SR_NSSR (0x1 << 8) /**< \brief (SPI_SR) NSS Rising */
#define SPI_SR_TXEMPTY (0x1 << 9) /**< \brief (SPI_SR) Transmission Registers Empty */
#define SPI_SR_UNDES (0x1 << 10) /**< \brief (SPI_SR) Underrun Error Status (Slave Mode Only) */
#define SPI_SR_SPIENS (0x1 << 16) /**< \brief (SPI_SR) SPI Enable Status */
/* -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register -------- */
#define SPI_IER_RDRF (0x1 << 0) /**< \brief (SPI_IER) Receive Data Register Full Interrupt Enable */
#define SPI_IER_TDRE (0x1 << 1) /**< \brief (SPI_IER) SPI Transmit Data Register Empty Interrupt Enable */
#define SPI_IER_MODF (0x1 << 2) /**< \brief (SPI_IER) Mode Fault Error Interrupt Enable */
#define SPI_IER_OVRES (0x1 << 3) /**< \brief (SPI_IER) Overrun Error Interrupt Enable */
#define SPI_IER_RXBUFF (0x1 << 6) /**< \brief (SPI_IER)  */
#define SPI_IER_NSSR (0x1 << 8) /**< \brief (SPI_IER) NSS Rising Interrupt Enable */
#define SPI_IER_TXEMPTY (0x1 << 9) /**< \brief (SPI_IER) Transmission Registers Empty Enable */
#define SPI_IER_UNDES (0x1 << 10) /**< \brief (SPI_IER) Underrun Error Interrupt Enable */
/* -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register -------- */
#define SPI_IDR_RDRF (0x1 << 0) /**< \brief (SPI_IDR) Receive Data Register Full Interrupt Disable */
#define SPI_IDR_TDRE (0x1 << 1) /**< \brief (SPI_IDR) SPI Transmit Data Register Empty Interrupt Disable */
#define SPI_IDR_MODF (0x1 << 2) /**< \brief (SPI_IDR) Mode Fault Error Interrupt Disable */
#define SPI_IDR_OVRES (0x1 << 3) /**< \brief (SPI_IDR) Overrun Error Interrupt Disable */
#define SPI_IDR_RXBUFF (0x1 << 6) /**< \brief (SPI_IDR)  */
#define SPI_IDR_NSSR (0x1 << 8) /**< \brief (SPI_IDR) NSS Rising Interrupt Disable */
#define SPI_IDR_TXEMPTY (0x1 << 9) /**< \brief (SPI_IDR) Transmission Registers Empty Disable */
#define SPI_IDR_UNDES (0x1 << 10) /**< \brief (SPI_IDR) Underrun Error Interrupt Disable */
/* -------- SPI_IMR : (SPI Offset: 0x1C) Interrupt Mask Register -------- */
#define SPI_IMR_RDRF (0x1 << 0) /**< \brief (SPI_IMR) Receive Data Register Full Interrupt Mask */
#define SPI_IMR_TDRE (0x1 << 1) /**< \brief (SPI_IMR) SPI Transmit Data Register Empty Interrupt Mask */
#define SPI_IMR_MODF (0x1 << 2) /**< \brief (SPI_IMR) Mode Fault Error Interrupt Mask */
#define SPI_IMR_OVRES (0x1 << 3) /**< \brief (SPI_IMR) Overrun Error Interrupt Mask */
#define SPI_IMR_RXBUFF (0x1 << 6) /**< \brief (SPI_IMR)  */
#define SPI_IMR_NSSR (0x1 << 8) /**< \brief (SPI_IMR) NSS Rising Interrupt Mask */
#define SPI_IMR_TXEMPTY (0x1 << 9) /**< \brief (SPI_IMR) Transmission Registers Empty Mask */
#define SPI_IMR_UNDES (0x1 << 10) /**< \brief (SPI_IMR) Underrun Error Interrupt Mask */
/* -------- SPI_CSR[4] : (SPI Offset: 0x30) Chip Select Register -------- */
#define SPI_CSR_CPOL (0x1 << 0) /**< \brief (SPI_CSR[4]) Clock Polarity */
#define SPI_CSR_NCPHA (0x1 << 1) /**< \brief (SPI_CSR[4]) Clock Phase */
#define SPI_CSR_CSNAAT (0x1 << 2) /**< \brief (SPI_CSR[4]) Chip Select Not Active After Transfer (Ignored if CSAAT = 1) */
#define SPI_CSR_CSAAT (0x1 << 3) /**< \brief (SPI_CSR[4]) Chip Select Not Active After Transfer (Ignored if CSAAT = 1) */
#define SPI_CSR_BITS (0xf << 4) /**< \brief (SPI_CSR[4]) Bits Per Transfer (See the (Note:) below the register table; Section 9.9 "SPI Chip Select Register" on page 37.) */
#define   SPI_CSR_BITS_8 (0x0 << 4) /**< \brief (SPI_CSR[4]) 8 */
#define   SPI_CSR_BITS_9 (0x1 << 4) /**< \brief (SPI_CSR[4]) 9 */
#define   SPI_CSR_BITS_10 (0x2 << 4) /**< \brief (SPI_CSR[4]) 10 */
#define   SPI_CSR_BITS_11 (0x3 << 4) /**< \brief (SPI_CSR[4]) 11 */
#define   SPI_CSR_BITS_12 (0x4 << 4) /**< \brief (SPI_CSR[4]) 12 */
#define   SPI_CSR_BITS_13 (0x5 << 4) /**< \brief (SPI_CSR[4]) 13 */
#define   SPI_CSR_BITS_14 (0x6 << 4) /**< \brief (SPI_CSR[4]) 14 */
#define   SPI_CSR_BITS_15 (0x7 << 4) /**< \brief (SPI_CSR[4]) 15 */
#define   SPI_CSR_BITS_16 (0x8 << 4) /**< \brief (SPI_CSR[4]) 16 */
#define SPI_CSR_SCBR (0xff << 8) /**< \brief (SPI_CSR[4]) Serial Clock Baud Rate */
#define SPI_CSR_DLYBS (0xff << 16) /**< \brief (SPI_CSR[4]) Delay Before SPCK */
#define SPI_CSR_DLYBCT (0xff << 24) /**< \brief (SPI_CSR[4]) Delay Between Consecutive Transfers */
/* -------- SPI_WPCR : (SPI Offset: 0xE4) Write Protection Control Register -------- */
#define SPI_WPCR_SPIWPEN (0x1 << 0) /**< \brief (SPI_WPCR) SPI Write Protection Enable */
#define SPI_WPCR_SPIWPKEY (0xffffff << 8) /**< \brief (SPI_WPCR) SPI Write Protection Key Password */
/* -------- SPI_WPSR : (SPI Offset: 0xE8) Write Protection Status Register -------- */
#define SPI_WPSR_SPIWPVS (0x7 << 0) /**< \brief (SPI_WPSR) SPI Write Protection Violation Status */
#define SPI_WPSR_SPIWPVSRC (0xff << 8) /**< \brief (SPI_WPSR) SPI Write Protection Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Synchronous Serial Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_SSC Synchronous Serial Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Ssc hardware registers */
typedef struct {
  WoReg SSC_CR;        /**< \brief (Ssc Offset: 0x0) Control Register */
  RwReg SSC_CMR;       /**< \brief (Ssc Offset: 0x4) Clock Mode Register */
  RwReg Reserved1[2]; 
  RwReg SSC_RCMR;      /**< \brief (Ssc Offset: 0x10) Receive Clock Mode Register */
  RwReg SSC_RFMR;      /**< \brief (Ssc Offset: 0x14) Receive Frame Mode Register */
  RwReg SSC_TCMR;      /**< \brief (Ssc Offset: 0x18) Transmit Clock Mode Register */
  RwReg SSC_TFMR;      /**< \brief (Ssc Offset: 0x1C) Transmit Frame Mode Register */
  RoReg SSC_RHR;       /**< \brief (Ssc Offset: 0x20) Receive Holding Register */
  WoReg SSC_THR;       /**< \brief (Ssc Offset: 0x24) Transmit Holding Register */
  RwReg Reserved2[2]; 
  RoReg SSC_RSHR;      /**< \brief (Ssc Offset: 0x30) Receive Sync. Holding Register */
  RwReg SSC_TSHR;      /**< \brief (Ssc Offset: 0x34) Transmit Sync. Holding Register */
  RwReg SSC_RC0R;      /**< \brief (Ssc Offset: 0x38) Receive Compare 0 Register */
  RwReg SSC_RC1R;      /**< \brief (Ssc Offset: 0x3C) Receive Compare 1 Register */
  RoReg SSC_SR;        /**< \brief (Ssc Offset: 0x40) Status Register */
  WoReg SSC_IER;       /**< \brief (Ssc Offset: 0x44) Interrupt Enable Register */
  WoReg SSC_IDR;       /**< \brief (Ssc Offset: 0x48) Interrupt Disable Register */
  RoReg SSC_IMR;       /**< \brief (Ssc Offset: 0x4C) Interrupt Mask Register */
  RwReg Reserved3[37];
  RwReg SSC_WPMR;      /**< \brief (Ssc Offset: 0xE4) Write Protect Mode Register */
  RoReg SSC_WPSR;      /**< \brief (Ssc Offset: 0xE8) Write Protect Status Register */
} Ssc;
#endif /* __ASSEMBLY__ */
/* -------- SSC_CR : (SSC Offset: 0x0) Control Register -------- */
#define SSC_CR_RXEN (0x1 << 0) /**< \brief (SSC_CR) Receive Enable */
#define SSC_CR_RXDIS (0x1 << 1) /**< \brief (SSC_CR) Receive Disable */
#define SSC_CR_TXEN (0x1 << 8) /**< \brief (SSC_CR) Transmit Enable */
#define SSC_CR_TXDIS (0x1 << 9) /**< \brief (SSC_CR) Transmit Disable */
#define SSC_CR_SWRST (0x1 << 15) /**< \brief (SSC_CR) Software Reset */
/* -------- SSC_CMR : (SSC Offset: 0x4) Clock Mode Register -------- */
#define SSC_CMR_DIV (0xfff << 0) /**< \brief (SSC_CMR) Clock Divider */
/* -------- SSC_RCMR : (SSC Offset: 0x10) Receive Clock Mode Register -------- */
#define SSC_RCMR_CKS (0x3 << 0) /**< \brief (SSC_RCMR) Receive Clock Selection */
#define   SSC_RCMR_CKS_DIV (0x0 << 0) /**< \brief (SSC_RCMR) Divided Clock */
#define   SSC_RCMR_CKS_TK (0x1 << 0) /**< \brief (SSC_RCMR) TK Clock signal */
#define   SSC_RCMR_CKS_RK (0x2 << 0) /**< \brief (SSC_RCMR) RK pin */
#define SSC_RCMR_CKO (0x7 << 2) /**< \brief (SSC_RCMR) Receive Clock Output Mode Selection */
#define SSC_RCMR_CKI (0x1 << 5) /**< \brief (SSC_RCMR) Receive Clock Inversion */
#define SSC_RCMR_CKG (0x3 << 6) /**< \brief (SSC_RCMR) Receive Clock Gating Selection */
#define   SSC_RCMR_CKG_NONE (0x0 << 6) /**< \brief (SSC_RCMR) None, continuous clock */
#define   SSC_RCMR_CKG_LOW (0x1 << 6) /**< \brief (SSC_RCMR) Receive Clock enabled only if RF Low */
#define   SSC_RCMR_CKG_HIGH (0x2 << 6) /**< \brief (SSC_RCMR) Receive Clock enabled only if RF High */
#define SSC_RCMR_START (0xf << 8) /**< \brief (SSC_RCMR) Receive Start Selection */
#define SSC_RCMR_STOP (0x1 << 12) /**< \brief (SSC_RCMR) Receive Stop Selection */
#define SSC_RCMR_STTDLY (0xff << 16) /**< \brief (SSC_RCMR) Receive Start Delay */
#define SSC_RCMR_PERIOD (0xff << 24) /**< \brief (SSC_RCMR) Receive Period Divider Selection */
/* -------- SSC_RFMR : (SSC Offset: 0x14) Receive Frame Mode Register -------- */
#define SSC_RFMR_DATLEN (0x1f << 0) /**< \brief (SSC_RFMR) Data Length */
#define SSC_RFMR_LOOP (0x1 << 5) /**< \brief (SSC_RFMR) Loop Mode */
#define SSC_RFMR_MSBF (0x1 << 7) /**< \brief (SSC_RFMR) Most Significant Bit First */
#define SSC_RFMR_DATNB (0xf << 8) /**< \brief (SSC_RFMR) Data Number per Frame */
#define SSC_RFMR_FSLEN (0xf << 16) /**< \brief (SSC_RFMR) Receive Frame Sync Length */
#define SSC_RFMR_FSOS (0x7 << 20) /**< \brief (SSC_RFMR) Receive Frame Sync Output Selection */
#define SSC_RFMR_FSEDGE (0x1 << 24) /**< \brief (SSC_RFMR) Frame Sync Edge Detection */
#define SSC_RFMR_FSLEN_EXT (0xf << 28) /**< \brief (SSC_RFMR) FSLEN Field Extension */
/* -------- SSC_TCMR : (SSC Offset: 0x18) Transmit Clock Mode Register -------- */
#define SSC_TCMR_CKS (0x3 << 0) /**< \brief (SSC_TCMR) Transmit Clock Selection */
#define SSC_TCMR_CKO (0x7 << 2) /**< \brief (SSC_TCMR) Transmit Clock Output Mode Selection */
#define SSC_TCMR_CKI (0x1 << 5) /**< \brief (SSC_TCMR) Transmit Clock Inversion */
#define SSC_TCMR_CKG (0x3 << 6) /**< \brief (SSC_TCMR) Transmit Clock Gating Selection */
#define SSC_TCMR_START (0xf << 8) /**< \brief (SSC_TCMR) Transmit Start Selection */
#define SSC_TCMR_STTDLY (0xff << 16) /**< \brief (SSC_TCMR) Transmit Start Delay */
#define SSC_TCMR_PERIOD (0xff << 24) /**< \brief (SSC_TCMR) Transmit Period Divider Selection */
/* -------- SSC_TFMR : (SSC Offset: 0x1C) Transmit Frame Mode Register -------- */
#define SSC_TFMR_DATLEN (0x1f << 0) /**< \brief (SSC_TFMR) Data Length */
#define SSC_TFMR_DATDEF (0x1 << 5) /**< \brief (SSC_TFMR) Data Default Value */
#define SSC_TFMR_MSBF (0x1 << 7) /**< \brief (SSC_TFMR) Most Significant Bit First */
#define SSC_TFMR_DATNB (0xf << 8) /**< \brief (SSC_TFMR) Data Number per frame */
#define SSC_TFMR_FSLEN (0xf << 16) /**< \brief (SSC_TFMR) Transmit Frame Syn Length */
#define SSC_TFMR_FSOS (0x7 << 20) /**< \brief (SSC_TFMR) Transmit Frame Sync Output Selection */
#define SSC_TFMR_FSDEN (0x1 << 23) /**< \brief (SSC_TFMR) Frame Sync Data Enable */
#define SSC_TFMR_FSEDGE (0x1 << 24) /**< \brief (SSC_TFMR) Frame Sync Edge Detection */
#define SSC_TFMR_FSLEN_EXT (0xf << 28) /**< \brief (SSC_TFMR) FSLEN Field Extension */
/* -------- SSC_RHR : (SSC Offset: 0x20) Receive Holding Register -------- */
#define SSC_RHR_RDAT (0xffffffff << 0) /**< \brief (SSC_RHR) Receive Data */
/* -------- SSC_THR : (SSC Offset: 0x24) Transmit Holding Register -------- */
#define SSC_THR_TDAT (0xffffffff << 0) /**< \brief (SSC_THR) Transmit Data */
/* -------- SSC_RSHR : (SSC Offset: 0x30) Receive Sync. Holding Register -------- */
#define SSC_RSHR_RSDAT (0xffff << 0) /**< \brief (SSC_RSHR) Receive Synchronization Data */
/* -------- SSC_TSHR : (SSC Offset: 0x34) Transmit Sync. Holding Register -------- */
#define SSC_TSHR_TSDAT (0xffff << 0) /**< \brief (SSC_TSHR) Transmit Synchronization Data */
/* -------- SSC_RC0R : (SSC Offset: 0x38) Receive Compare 0 Register -------- */
#define SSC_RC0R_CP0 (0xffff << 0) /**< \brief (SSC_RC0R) Receive Compare Data 0 */
/* -------- SSC_RC1R : (SSC Offset: 0x3C) Receive Compare 1 Register -------- */
#define SSC_RC1R_CP1 (0xffff << 0) /**< \brief (SSC_RC1R) Receive Compare Data 1 */
/* -------- SSC_SR : (SSC Offset: 0x40) Status Register -------- */
#define SSC_SR_TXRDY (0x1 << 0) /**< \brief (SSC_SR) Transmit Ready */
#define SSC_SR_TXEMPTY (0x1 << 1) /**< \brief (SSC_SR) Transmit Empty */
#define SSC_SR_ENDTX (0x1 << 2) /**< \brief (SSC_SR) End of Transmission */
#define SSC_SR_TXBUFE (0x1 << 3) /**< \brief (SSC_SR) Transmit Buffer Empty */
#define SSC_SR_RXRDY (0x1 << 4) /**< \brief (SSC_SR) Receive Ready */
#define SSC_SR_OVRUN (0x1 << 5) /**< \brief (SSC_SR) Receive Overrun */
#define SSC_SR_ENDRX (0x1 << 6) /**< \brief (SSC_SR) End of Reception */
#define SSC_SR_RXBUFF (0x1 << 7) /**< \brief (SSC_SR) Receive Buffer Full */
#define SSC_SR_CP0 (0x1 << 8) /**< \brief (SSC_SR) Compare 0 */
#define SSC_SR_CP1 (0x1 << 9) /**< \brief (SSC_SR) Compare 1 */
#define SSC_SR_TXSYN (0x1 << 10) /**< \brief (SSC_SR) Transmit Sync */
#define SSC_SR_RXSYN (0x1 << 11) /**< \brief (SSC_SR) Receive Sync */
#define SSC_SR_TXEN (0x1 << 16) /**< \brief (SSC_SR) Transmit Enable */
#define SSC_SR_RXEN (0x1 << 17) /**< \brief (SSC_SR) Receive Enable */
/* -------- SSC_IER : (SSC Offset: 0x44) Interrupt Enable Register -------- */
#define SSC_IER_TXRDY (0x1 << 0) /**< \brief (SSC_IER) Transmit Ready Interrupt Enable */
#define SSC_IER_TXEMPTY (0x1 << 1) /**< \brief (SSC_IER) Transmit Empty Interrupt Enable */
#define SSC_IER_ENDTX (0x1 << 2) /**< \brief (SSC_IER) End of Transmission Interrupt Enable */
#define SSC_IER_TXBUFE (0x1 << 3) /**< \brief (SSC_IER) Transmit Buffer Empty Interrupt Enable */
#define SSC_IER_RXRDY (0x1 << 4) /**< \brief (SSC_IER) Receive Ready Interrupt Enable */
#define SSC_IER_OVRUN (0x1 << 5) /**< \brief (SSC_IER) Receive Overrun Interrupt Enable */
#define SSC_IER_ENDRX (0x1 << 6) /**< \brief (SSC_IER) End of Reception Interrupt Enable */
#define SSC_IER_RXBUFF (0x1 << 7) /**< \brief (SSC_IER) Receive Buffer Full Interrupt Enable */
#define SSC_IER_CP0 (0x1 << 8) /**< \brief (SSC_IER) Compare 0 Interrupt Enable */
#define SSC_IER_CP1 (0x1 << 9) /**< \brief (SSC_IER) Compare 1 Interrupt Enable */
#define SSC_IER_TXSYN (0x1 << 10) /**< \brief (SSC_IER) Tx Sync Interrupt Enable */
#define SSC_IER_RXSYN (0x1 << 11) /**< \brief (SSC_IER) Rx Sync Interrupt Enable */
/* -------- SSC_IDR : (SSC Offset: 0x48) Interrupt Disable Register -------- */
#define SSC_IDR_TXRDY (0x1 << 0) /**< \brief (SSC_IDR) Transmit Ready Interrupt Disable */
#define SSC_IDR_TXEMPTY (0x1 << 1) /**< \brief (SSC_IDR) Transmit Empty Interrupt Disable */
#define SSC_IDR_ENDTX (0x1 << 2) /**< \brief (SSC_IDR) End of Transmission Interrupt Disable */
#define SSC_IDR_TXBUFE (0x1 << 3) /**< \brief (SSC_IDR) Transmit Buffer Empty Interrupt Disable */
#define SSC_IDR_RXRDY (0x1 << 4) /**< \brief (SSC_IDR) Receive Ready Interrupt Disable */
#define SSC_IDR_OVRUN (0x1 << 5) /**< \brief (SSC_IDR) Receive Overrun Interrupt Disable */
#define SSC_IDR_ENDRX (0x1 << 6) /**< \brief (SSC_IDR) End of Reception Interrupt Disable */
#define SSC_IDR_RXBUFF (0x1 << 7) /**< \brief (SSC_IDR) Receive Buffer Full Interrupt Disable */
#define SSC_IDR_CP0 (0x1 << 8) /**< \brief (SSC_IDR) Compare 0 Interrupt Disable */
#define SSC_IDR_CP1 (0x1 << 9) /**< \brief (SSC_IDR) Compare 1 Interrupt Disable */
#define SSC_IDR_TXSYN (0x1 << 10) /**< \brief (SSC_IDR) Tx Sync Interrupt Enable */
#define SSC_IDR_RXSYN (0x1 << 11) /**< \brief (SSC_IDR) Rx Sync Interrupt Enable */
/* -------- SSC_IMR : (SSC Offset: 0x4C) Interrupt Mask Register -------- */
#define SSC_IMR_TXRDY (0x1 << 0) /**< \brief (SSC_IMR) Transmit Ready Interrupt Mask */
#define SSC_IMR_TXEMPTY (0x1 << 1) /**< \brief (SSC_IMR) Transmit Empty Interrupt Mask */
#define SSC_IMR_ENDTX (0x1 << 2) /**< \brief (SSC_IMR) End of Transmission Interrupt Mask */
#define SSC_IMR_TXBUFE (0x1 << 3) /**< \brief (SSC_IMR) Transmit Buffer Empty Interrupt Mask */
#define SSC_IMR_RXRDY (0x1 << 4) /**< \brief (SSC_IMR) Receive Ready Interrupt Mask */
#define SSC_IMR_OVRUN (0x1 << 5) /**< \brief (SSC_IMR) Receive Overrun Interrupt Mask */
#define SSC_IMR_ENDRX (0x1 << 6) /**< \brief (SSC_IMR) End of Reception Interrupt Mask */
#define SSC_IMR_RXBUFF (0x1 << 7) /**< \brief (SSC_IMR) Receive Buffer Full Interrupt Mask */
#define SSC_IMR_CP0 (0x1 << 8) /**< \brief (SSC_IMR) Compare 0 Interrupt Mask */
#define SSC_IMR_CP1 (0x1 << 9) /**< \brief (SSC_IMR) Compare 1 Interrupt Mask */
#define SSC_IMR_TXSYN (0x1 << 10) /**< \brief (SSC_IMR) Tx Sync Interrupt Mask */
#define SSC_IMR_RXSYN (0x1 << 11) /**< \brief (SSC_IMR) Rx Sync Interrupt Mask */
/* -------- SSC_WPMR : (SSC Offset: 0xE4) Write Protect Mode Register -------- */
#define SSC_WPMR_WPEN (0x1 << 0) /**< \brief (SSC_WPMR) Write Protect Enable */
#define SSC_WPMR_WPKEY (0xffffff << 8) /**< \brief (SSC_WPMR) Write Protect KEY */
/* -------- SSC_WPSR : (SSC Offset: 0xE8) Write Protect Status Register -------- */
#define SSC_WPSR_WPVS (0x1 << 0) /**< \brief (SSC_WPSR) Write Protect Violation Status */
#define SSC_WPSR_WPVSRC (0xffff << 8) /**< \brief (SSC_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Supply Controller */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_SUPC Supply Controller */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Supc hardware registers */
typedef struct {
  WoReg SUPC_CR;   /**< \brief (Supc Offset: 0x00) Supply Controller Control Register */
  RwReg SUPC_SMMR; /**< \brief (Supc Offset: 0x04) Supply Controller Supply Monitor Mode Register */
  RwReg SUPC_MR;   /**< \brief (Supc Offset: 0x08) Supply Controller Mode Register */
  RwReg SUPC_WUMR; /**< \brief (Supc Offset: 0x0C) Supply Controller Wake Up Mode Register */
  RwReg SUPC_WUIR; /**< \brief (Supc Offset: 0x10) Supply Controller Wake Up Inputs Register */
  RoReg SUPC_SR;   /**< \brief (Supc Offset: 0x14) Supply Controller Status Register */
} Supc;
#endif /* __ASSEMBLY__ */
/* -------- SUPC_CR : (SUPC Offset: 0x00) Supply Controller Control Register -------- */
#define SUPC_CR_VROFF (0x1 << 2) /**< \brief (SUPC_CR) Voltage Regulator Off */
#define   SUPC_CR_VROFF_NO_EFFECT (0x0 << 2) /**< \brief (SUPC_CR) no effect. */
#define   SUPC_CR_VROFF_STOP_VREG (0x1 << 2) /**< \brief (SUPC_CR) if KEY is correct, asserts vddcore_nreset and stops the voltage regulator. */
#define SUPC_CR_XTALSEL (0x1 << 3) /**< \brief (SUPC_CR) Crystal Oscillator Select */
#define   SUPC_CR_XTALSEL_NO_EFFECT (0x0 << 3) /**< \brief (SUPC_CR) no effect. */
#define   SUPC_CR_XTALSEL_CRYSTAL_SEL (0x1 << 3) /**< \brief (SUPC_CR) if KEY is correct, switches the slow clock on the crystal oscillator output. */
#define SUPC_CR_KEY (0xff << 24) /**< \brief (SUPC_CR) Password */
/* -------- SUPC_SMMR : (SUPC Offset: 0x04) Supply Controller Supply Monitor Mode Register -------- */
#define SUPC_SMMR_SMTH (0xf << 0) /**< \brief (SUPC_SMMR) Supply Monitor Threshold */
#define   SUPC_SMMR_SMTH_1_9V (0x0 << 0) /**< \brief (SUPC_SMMR) 1.9 V */
#define   SUPC_SMMR_SMTH_2_0V (0x1 << 0) /**< \brief (SUPC_SMMR) 2.0 V */
#define   SUPC_SMMR_SMTH_2_1V (0x2 << 0) /**< \brief (SUPC_SMMR) 2.1 V */
#define   SUPC_SMMR_SMTH_2_2V (0x3 << 0) /**< \brief (SUPC_SMMR) 2.2 V */
#define   SUPC_SMMR_SMTH_2_3V (0x4 << 0) /**< \brief (SUPC_SMMR) 2.3 V */
#define   SUPC_SMMR_SMTH_2_4V (0x5 << 0) /**< \brief (SUPC_SMMR) 2.4 V */
#define   SUPC_SMMR_SMTH_2_5V (0x6 << 0) /**< \brief (SUPC_SMMR) 2.5 V */
#define   SUPC_SMMR_SMTH_2_6V (0x7 << 0) /**< \brief (SUPC_SMMR) 2.6 V */
#define   SUPC_SMMR_SMTH_2_7V (0x8 << 0) /**< \brief (SUPC_SMMR) 2.7 V */
#define   SUPC_SMMR_SMTH_2_8V (0x9 << 0) /**< \brief (SUPC_SMMR) 2.8 V */
#define   SUPC_SMMR_SMTH_2_9V (0xA << 0) /**< \brief (SUPC_SMMR) 2.9 V */
#define   SUPC_SMMR_SMTH_3_0V (0xB << 0) /**< \brief (SUPC_SMMR) 3.0 V */
#define   SUPC_SMMR_SMTH_3_1V (0xC << 0) /**< \brief (SUPC_SMMR) 3.1 V */
#define   SUPC_SMMR_SMTH_3_2V (0xD << 0) /**< \brief (SUPC_SMMR) 3.2 V */
#define   SUPC_SMMR_SMTH_3_3V (0xE << 0) /**< \brief (SUPC_SMMR) 3.3 V */
#define   SUPC_SMMR_SMTH_3_4V (0xF << 0) /**< \brief (SUPC_SMMR) 3.4 V */
#define SUPC_SMMR_SMSMPL (0x7 << 8) /**< \brief (SUPC_SMMR) Supply Monitor Sampling Period */
#define   SUPC_SMMR_SMSMPL_SMD (0x0 << 8) /**< \brief (SUPC_SMMR) Supply Monitor disabled */
#define   SUPC_SMMR_SMSMPL_CSM (0x1 << 8) /**< \brief (SUPC_SMMR) Continuous Supply Monitor */
#define   SUPC_SMMR_SMSMPL_32SLCK (0x2 << 8) /**< \brief (SUPC_SMMR) Supply Monitor enabled one SLCK period every 32 SLCK periods */
#define   SUPC_SMMR_SMSMPL_256SLCK (0x3 << 8) /**< \brief (SUPC_SMMR) Supply Monitor enabled one SLCK period every 256 SLCK periods */
#define   SUPC_SMMR_SMSMPL_2048SLCK (0x4 << 8) /**< \brief (SUPC_SMMR) Supply Monitor enabled one SLCK period every 2,048 SLCK periods */
#define SUPC_SMMR_SMRSTEN (0x1 << 12) /**< \brief (SUPC_SMMR) Supply Monitor Reset Enable */
#define   SUPC_SMMR_SMRSTEN_NOT_ENABLE (0x0 << 12) /**< \brief (SUPC_SMMR) the core reset signal "vddcore_nreset" is not affected when a supply monitor detection occurs. */
#define   SUPC_SMMR_SMRSTEN_ENABLE (0x1 << 12) /**< \brief (SUPC_SMMR) the core reset signal, vddcore_nreset is asserted when a supply monitor detection occurs. */
#define SUPC_SMMR_SMIEN (0x1 << 13) /**< \brief (SUPC_SMMR) Supply Monitor Interrupt Enable */
#define   SUPC_SMMR_SMIEN_NOT_ENABLE (0x0 << 13) /**< \brief (SUPC_SMMR) the SUPC interrupt signal is not affected when a supply monitor detection occurs. */
#define   SUPC_SMMR_SMIEN_ENABLE (0x1 << 13) /**< \brief (SUPC_SMMR) the SUPC interrupt signal is asserted when a supply monitor detection occurs. */
/* -------- SUPC_MR : (SUPC Offset: 0x08) Supply Controller Mode Register -------- */
#define SUPC_MR_BODRSTEN (0x1 << 12) /**< \brief (SUPC_MR) Brownout Detector Reset Enable */
#define   SUPC_MR_BODRSTEN_NOT_ENABLE (0x0 << 12) /**< \brief (SUPC_MR) the core reset signal "vddcore_nreset" is not affected when a brownout detection occurs. */
#define   SUPC_MR_BODRSTEN_ENABLE (0x1 << 12) /**< \brief (SUPC_MR) the core reset signal, vddcore_nreset is asserted when a brownout detection occurs. */
#define SUPC_MR_BODDIS (0x1 << 13) /**< \brief (SUPC_MR) Brownout Detector Disable */
#define   SUPC_MR_BODDIS_ENABLE (0x0 << 13) /**< \brief (SUPC_MR) the core brownout detector is enabled. */
#define   SUPC_MR_BODDIS_DISABLE (0x1 << 13) /**< \brief (SUPC_MR) the core brownout detector is disabled. */
#define SUPC_MR_VDDIORDY (0x1 << 14) /**< \brief (SUPC_MR) VDDIO Ready */
#define   SUPC_MR_VDDIORDY_VDDIO_REMOVED (0x0 << 14) /**< \brief (SUPC_MR) VDDIO is removed (used before going to backup mode when backup batteries are used) */
#define   SUPC_MR_VDDIORDY_VDDIO_PRESENT (0x1 << 14) /**< \brief (SUPC_MR) VDDIO is present (used before going to backup mode when backup batteries are used) */
#define SUPC_MR_OSCBYPASS (0x1 << 20) /**< \brief (SUPC_MR) Oscillator Bypass */
#define   SUPC_MR_OSCBYPASS_NO_EFFECT (0x0 << 20) /**< \brief (SUPC_MR) no effect. Clock selection depends on XTALSEL value. */
#define   SUPC_MR_OSCBYPASS_BYPASS (0x1 << 20) /**< \brief (SUPC_MR) the 32-KHz XTAL oscillator is selected and is put in bypass mode. */
#define SUPC_MR_KEY (0xff << 24) /**< \brief (SUPC_MR) Password Key */
/* -------- SUPC_WUMR : (SUPC Offset: 0x0C) Supply Controller Wake Up Mode Register -------- */
#define SUPC_WUMR_FWUPEN (0x1 << 0) /**< \brief (SUPC_WUMR) Force Wake Up Enable */
#define   SUPC_WUMR_FWUPEN_NOT_ENABLE (0x0 << 0) /**< \brief (SUPC_WUMR) the Force Wake Up pin has no wake up effect. */
#define   SUPC_WUMR_FWUPEN_ENABLE (0x1 << 0) /**< \brief (SUPC_WUMR) the Force Wake Up pin low forces the wake up of the core power supply. */
#define SUPC_WUMR_SMEN (0x1 << 1) /**< \brief (SUPC_WUMR) Supply Monitor Wake Up Enable */
#define   SUPC_WUMR_SMEN_NOT_ENABLE (0x0 << 1) /**< \brief (SUPC_WUMR) the supply monitor detection has no wake up effect. */
#define   SUPC_WUMR_SMEN_ENABLE (0x1 << 1) /**< \brief (SUPC_WUMR) the supply monitor detection forces the wake up of the core power supply. */
#define SUPC_WUMR_RTTEN (0x1 << 2) /**< \brief (SUPC_WUMR) Real Time Timer Wake Up Enable */
#define   SUPC_WUMR_RTTEN_NOT_ENABLE (0x0 << 2) /**< \brief (SUPC_WUMR) the RTT alarm signal has no wake up effect. */
#define   SUPC_WUMR_RTTEN_ENABLE (0x1 << 2) /**< \brief (SUPC_WUMR) the RTT alarm signal forces the wake up of the core power supply. */
#define SUPC_WUMR_RTCEN (0x1 << 3) /**< \brief (SUPC_WUMR) Real Time Clock Wake Up Enable */
#define   SUPC_WUMR_RTCEN_NOT_ENABLE (0x0 << 3) /**< \brief (SUPC_WUMR) the RTC alarm signal has no wake up effect. */
#define   SUPC_WUMR_RTCEN_ENABLE (0x1 << 3) /**< \brief (SUPC_WUMR) the RTC alarm signal forces the wake up of the core power supply. */
#define SUPC_WUMR_FWUPDBC (0x7 << 8) /**< \brief (SUPC_WUMR) Force Wake Up Debouncer */
#define   SUPC_WUMR_FWUPDBC_1SCLK (0x0 << 8) /**< \brief (SUPC_WUMR) Immediate, no debouncing, detected active at least on one Slow Clock edge. */
#define   SUPC_WUMR_FWUPDBC_3SCLK (0x1 << 8) /**< \brief (SUPC_WUMR) FWUP shall be low for at least 3 SLCK periods */
#define   SUPC_WUMR_FWUPDBC_32SCLK (0x2 << 8) /**< \brief (SUPC_WUMR) FWUP shall be low for at least 32 SLCK periods */
#define   SUPC_WUMR_FWUPDBC_512SCLK (0x3 << 8) /**< \brief (SUPC_WUMR) FWUP shall be low for at least 512 SLCK periods */
#define   SUPC_WUMR_FWUPDBC_4096SCLK (0x4 << 8) /**< \brief (SUPC_WUMR) FWUP shall be low for at least 4,096 SLCK periods */
#define   SUPC_WUMR_FWUPDBC_32768SCLK (0x5 << 8) /**< \brief (SUPC_WUMR) FWUP shall be low for at least 32,768 SLCK periods */
#define SUPC_WUMR_WKUPDBC (0x7 << 12) /**< \brief (SUPC_WUMR) Wake Up Inputs Debouncer */
#define   SUPC_WUMR_WKUPDBC_1SCLK (0x0 << 12) /**< \brief (SUPC_WUMR) Immediate, no debouncing, detected active at least on one Slow Clock edge. */
#define   SUPC_WUMR_WKUPDBC_3SCLK (0x1 << 12) /**< \brief (SUPC_WUMR) An enabled wake-up input shall be active for at least 3 SLCK periods */
#define   SUPC_WUMR_WKUPDBC_32SCLK (0x2 << 12) /**< \brief (SUPC_WUMR) An enabled wake-up input shall be active for at least 32 SLCK periods */
#define   SUPC_WUMR_WKUPDBC_512SCLK (0x3 << 12) /**< \brief (SUPC_WUMR) An enabled wake-up input shall be active for at least 512 SLCK periods */
#define   SUPC_WUMR_WKUPDBC_4096SCLK (0x4 << 12) /**< \brief (SUPC_WUMR) An enabled wake-up input shall be active for at least 4,096 SLCK periods */
#define   SUPC_WUMR_WKUPDBC_32768SCLK (0x5 << 12) /**< \brief (SUPC_WUMR) An enabled wake-up input shall be active for at least 32,768 SLCK periods */
/* -------- SUPC_WUIR : (SUPC Offset: 0x10) Supply Controller Wake Up Inputs Register -------- */
#define SUPC_WUIR_WKUPEN0 (0x1 << 0) /**< \brief (SUPC_WUIR) Wake Up Input Enable 0 */
#define   SUPC_WUIR_WKUPEN0_NOT_ENABLE (0x0 << 0) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN0_ENABLE (0x1 << 0) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN1 (0x1 << 1) /**< \brief (SUPC_WUIR) Wake Up Input Enable 1 */
#define   SUPC_WUIR_WKUPEN1_NOT_ENABLE (0x0 << 1) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN1_ENABLE (0x1 << 1) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN2 (0x1 << 2) /**< \brief (SUPC_WUIR) Wake Up Input Enable 2 */
#define   SUPC_WUIR_WKUPEN2_NOT_ENABLE (0x0 << 2) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN2_ENABLE (0x1 << 2) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN3 (0x1 << 3) /**< \brief (SUPC_WUIR) Wake Up Input Enable 3 */
#define   SUPC_WUIR_WKUPEN3_NOT_ENABLE (0x0 << 3) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN3_ENABLE (0x1 << 3) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN4 (0x1 << 4) /**< \brief (SUPC_WUIR) Wake Up Input Enable 4 */
#define   SUPC_WUIR_WKUPEN4_NOT_ENABLE (0x0 << 4) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN4_ENABLE (0x1 << 4) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN5 (0x1 << 5) /**< \brief (SUPC_WUIR) Wake Up Input Enable 5 */
#define   SUPC_WUIR_WKUPEN5_NOT_ENABLE (0x0 << 5) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN5_ENABLE (0x1 << 5) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN6 (0x1 << 6) /**< \brief (SUPC_WUIR) Wake Up Input Enable 6 */
#define   SUPC_WUIR_WKUPEN6_NOT_ENABLE (0x0 << 6) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN6_ENABLE (0x1 << 6) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN7 (0x1 << 7) /**< \brief (SUPC_WUIR) Wake Up Input Enable 7 */
#define   SUPC_WUIR_WKUPEN7_NOT_ENABLE (0x0 << 7) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN7_ENABLE (0x1 << 7) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN8 (0x1 << 8) /**< \brief (SUPC_WUIR) Wake Up Input Enable 8 */
#define   SUPC_WUIR_WKUPEN8_NOT_ENABLE (0x0 << 8) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN8_ENABLE (0x1 << 8) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN9 (0x1 << 9) /**< \brief (SUPC_WUIR) Wake Up Input Enable 9 */
#define   SUPC_WUIR_WKUPEN9_NOT_ENABLE (0x0 << 9) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN9_ENABLE (0x1 << 9) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN10 (0x1 << 10) /**< \brief (SUPC_WUIR) Wake Up Input Enable 10 */
#define   SUPC_WUIR_WKUPEN10_NOT_ENABLE (0x0 << 10) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN10_ENABLE (0x1 << 10) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN11 (0x1 << 11) /**< \brief (SUPC_WUIR) Wake Up Input Enable 11 */
#define   SUPC_WUIR_WKUPEN11_NOT_ENABLE (0x0 << 11) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN11_ENABLE (0x1 << 11) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN12 (0x1 << 12) /**< \brief (SUPC_WUIR) Wake Up Input Enable 12 */
#define   SUPC_WUIR_WKUPEN12_NOT_ENABLE (0x0 << 12) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN12_ENABLE (0x1 << 12) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN13 (0x1 << 13) /**< \brief (SUPC_WUIR) Wake Up Input Enable 13 */
#define   SUPC_WUIR_WKUPEN13_NOT_ENABLE (0x0 << 13) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN13_ENABLE (0x1 << 13) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN14 (0x1 << 14) /**< \brief (SUPC_WUIR) Wake Up Input Enable 14 */
#define   SUPC_WUIR_WKUPEN14_NOT_ENABLE (0x0 << 14) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN14_ENABLE (0x1 << 14) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPEN15 (0x1 << 15) /**< \brief (SUPC_WUIR) Wake Up Input Enable 15 */
#define   SUPC_WUIR_WKUPEN15_NOT_ENABLE (0x0 << 15) /**< \brief (SUPC_WUIR) the corresponding wake-up input has no wake up effect. */
#define   SUPC_WUIR_WKUPEN15_ENABLE (0x1 << 15) /**< \brief (SUPC_WUIR) the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT0 (0x1 << 16) /**< \brief (SUPC_WUIR) Wake Up Input Transition 0 */
#define   SUPC_WUIR_WKUPT0_HIGH_TO_LOW (0x0 << 16) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT0_LOW_TO_HIGH (0x1 << 16) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT1 (0x1 << 17) /**< \brief (SUPC_WUIR) Wake Up Input Transition 1 */
#define   SUPC_WUIR_WKUPT1_HIGH_TO_LOW (0x0 << 17) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT1_LOW_TO_HIGH (0x1 << 17) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT2 (0x1 << 18) /**< \brief (SUPC_WUIR) Wake Up Input Transition 2 */
#define   SUPC_WUIR_WKUPT2_HIGH_TO_LOW (0x0 << 18) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT2_LOW_TO_HIGH (0x1 << 18) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT3 (0x1 << 19) /**< \brief (SUPC_WUIR) Wake Up Input Transition 3 */
#define   SUPC_WUIR_WKUPT3_HIGH_TO_LOW (0x0 << 19) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT3_LOW_TO_HIGH (0x1 << 19) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT4 (0x1 << 20) /**< \brief (SUPC_WUIR) Wake Up Input Transition 4 */
#define   SUPC_WUIR_WKUPT4_HIGH_TO_LOW (0x0 << 20) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT4_LOW_TO_HIGH (0x1 << 20) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT5 (0x1 << 21) /**< \brief (SUPC_WUIR) Wake Up Input Transition 5 */
#define   SUPC_WUIR_WKUPT5_HIGH_TO_LOW (0x0 << 21) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT5_LOW_TO_HIGH (0x1 << 21) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT6 (0x1 << 22) /**< \brief (SUPC_WUIR) Wake Up Input Transition 6 */
#define   SUPC_WUIR_WKUPT6_HIGH_TO_LOW (0x0 << 22) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT6_LOW_TO_HIGH (0x1 << 22) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT7 (0x1 << 23) /**< \brief (SUPC_WUIR) Wake Up Input Transition 7 */
#define   SUPC_WUIR_WKUPT7_HIGH_TO_LOW (0x0 << 23) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT7_LOW_TO_HIGH (0x1 << 23) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT8 (0x1 << 24) /**< \brief (SUPC_WUIR) Wake Up Input Transition 8 */
#define   SUPC_WUIR_WKUPT8_HIGH_TO_LOW (0x0 << 24) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT8_LOW_TO_HIGH (0x1 << 24) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT9 (0x1 << 25) /**< \brief (SUPC_WUIR) Wake Up Input Transition 9 */
#define   SUPC_WUIR_WKUPT9_HIGH_TO_LOW (0x0 << 25) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT9_LOW_TO_HIGH (0x1 << 25) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT10 (0x1 << 26) /**< \brief (SUPC_WUIR) Wake Up Input Transition 10 */
#define   SUPC_WUIR_WKUPT10_HIGH_TO_LOW (0x0 << 26) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT10_LOW_TO_HIGH (0x1 << 26) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT11 (0x1 << 27) /**< \brief (SUPC_WUIR) Wake Up Input Transition 11 */
#define   SUPC_WUIR_WKUPT11_HIGH_TO_LOW (0x0 << 27) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT11_LOW_TO_HIGH (0x1 << 27) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT12 (0x1 << 28) /**< \brief (SUPC_WUIR) Wake Up Input Transition 12 */
#define   SUPC_WUIR_WKUPT12_HIGH_TO_LOW (0x0 << 28) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT12_LOW_TO_HIGH (0x1 << 28) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT13 (0x1 << 29) /**< \brief (SUPC_WUIR) Wake Up Input Transition 13 */
#define   SUPC_WUIR_WKUPT13_HIGH_TO_LOW (0x0 << 29) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT13_LOW_TO_HIGH (0x1 << 29) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT14 (0x1 << 30) /**< \brief (SUPC_WUIR) Wake Up Input Transition 14 */
#define   SUPC_WUIR_WKUPT14_HIGH_TO_LOW (0x0 << 30) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT14_LOW_TO_HIGH (0x1 << 30) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define SUPC_WUIR_WKUPT15 (0x1 << 31) /**< \brief (SUPC_WUIR) Wake Up Input Transition 15 */
#define   SUPC_WUIR_WKUPT15_HIGH_TO_LOW (0x0 << 31) /**< \brief (SUPC_WUIR) a high to low level transition on the corresponding wake-up input forces the wake up of the core power supply. */
#define   SUPC_WUIR_WKUPT15_LOW_TO_HIGH (0x1 << 31) /**< \brief (SUPC_WUIR) a low to high level transition on the corresponding wake-up input forces the wake up of the core power supply. */
/* -------- SUPC_SR : (SUPC Offset: 0x14) Supply Controller Status Register -------- */
#define SUPC_SR_FWUPS (0x1 << 0) /**< \brief (SUPC_SR) FWUP Wake Up Status */
#define   SUPC_SR_FWUPS_NO (0x0 << 0) /**< \brief (SUPC_SR) no wake up due to the assertion of the FWUP pin has occurred since the last read of SUPC_SR. */
#define   SUPC_SR_FWUPS_PRESENT (0x1 << 0) /**< \brief (SUPC_SR) at least one wake up due to the assertion of the FWUP pin has occurred since the last read of SUPC_SR. */
#define SUPC_SR_WKUPS (0x1 << 1) /**< \brief (SUPC_SR) WKUP Wake Up Status */
#define   SUPC_SR_WKUPS_NO (0x0 << 1) /**< \brief (SUPC_SR) no wake up due to the assertion of the WKUP pins has occurred since the last read of SUPC_SR. */
#define   SUPC_SR_WKUPS_PRESENT (0x1 << 1) /**< \brief (SUPC_SR) at least one wake up due to the assertion of the WKUP pins has occurred since the last read of SUPC_SR. */
#define SUPC_SR_SMWS (0x1 << 2) /**< \brief (SUPC_SR) Supply Monitor Detection Wake Up Status */
#define   SUPC_SR_SMWS_NO (0x0 << 2) /**< \brief (SUPC_SR) no wake up due to a supply monitor detection has occurred since the last read of SUPC_SR. */
#define   SUPC_SR_SMWS_PRESENT (0x1 << 2) /**< \brief (SUPC_SR) at least one wake up due to a supply monitor detection has occurred since the last read of SUPC_SR. */
#define SUPC_SR_BODRSTS (0x1 << 3) /**< \brief (SUPC_SR) Brownout Detector Reset Status */
#define   SUPC_SR_BODRSTS_NO (0x0 << 3) /**< \brief (SUPC_SR) no core brownout rising edge event has been detected since the last read of the SUPC_SR. */
#define   SUPC_SR_BODRSTS_PRESENT (0x1 << 3) /**< \brief (SUPC_SR) at least one brownout output rising edge event has been detected since the last read of the SUPC_SR. */
#define SUPC_SR_SMRSTS (0x1 << 4) /**< \brief (SUPC_SR) Supply Monitor Reset Status */
#define   SUPC_SR_SMRSTS_NO (0x0 << 4) /**< \brief (SUPC_SR) no supply monitor detection has generated a core reset since the last read of the SUPC_SR. */
#define   SUPC_SR_SMRSTS_PRESENT (0x1 << 4) /**< \brief (SUPC_SR) at least one supply monitor detection has generated a core reset since the last read of the SUPC_SR. */
#define SUPC_SR_SMS (0x1 << 5) /**< \brief (SUPC_SR) Supply Monitor Status */
#define   SUPC_SR_SMS_NO (0x0 << 5) /**< \brief (SUPC_SR) no supply monitor detection since the last read of SUPC_SR. */
#define   SUPC_SR_SMS_PRESENT (0x1 << 5) /**< \brief (SUPC_SR) at least one supply monitor detection since the last read of SUPC_SR. */
#define SUPC_SR_SMOS (0x1 << 6) /**< \brief (SUPC_SR) Supply Monitor Output Status */
#define   SUPC_SR_SMOS_HIGH (0x0 << 6) /**< \brief (SUPC_SR) the supply monitor detected VDDUTMI higher than its threshold at its last measurement. */
#define   SUPC_SR_SMOS_LOW (0x1 << 6) /**< \brief (SUPC_SR) the supply monitor detected VDDUTMI lower than its threshold at its last measurement. */
#define SUPC_SR_OSCSEL (0x1 << 7) /**< \brief (SUPC_SR) 32-kHz Oscillator Selection Status */
#define   SUPC_SR_OSCSEL_RC (0x0 << 7) /**< \brief (SUPC_SR) the slow clock, SLCK is generated by the embedded 32-kHz RC oscillator. */
#define   SUPC_SR_OSCSEL_CRYST (0x1 << 7) /**< \brief (SUPC_SR) the slow clock, SLCK is generated by the 32-kHz crystal oscillator. */
#define SUPC_SR_FWUPIS (0x1 << 12) /**< \brief (SUPC_SR) FWUP Input Status */
#define   SUPC_SR_FWUPIS_LOW (0x0 << 12) /**< \brief (SUPC_SR) FWUP input is tied low. */
#define   SUPC_SR_FWUPIS_HIGH (0x1 << 12) /**< \brief (SUPC_SR) FWUP input is tied high. */
#define SUPC_SR_WKUPIS0 (0x1 << 16) /**< \brief (SUPC_SR) WKUP Input Status 0 */
#define   SUPC_SR_WKUPIS0_DIS (0x0 << 16) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS0_EN (0x1 << 16) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS1 (0x1 << 17) /**< \brief (SUPC_SR) WKUP Input Status 1 */
#define   SUPC_SR_WKUPIS1_DIS (0x0 << 17) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS1_EN (0x1 << 17) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS2 (0x1 << 18) /**< \brief (SUPC_SR) WKUP Input Status 2 */
#define   SUPC_SR_WKUPIS2_DIS (0x0 << 18) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS2_EN (0x1 << 18) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS3 (0x1 << 19) /**< \brief (SUPC_SR) WKUP Input Status 3 */
#define   SUPC_SR_WKUPIS3_DIS (0x0 << 19) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS3_EN (0x1 << 19) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS4 (0x1 << 20) /**< \brief (SUPC_SR) WKUP Input Status 4 */
#define   SUPC_SR_WKUPIS4_DIS (0x0 << 20) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS4_EN (0x1 << 20) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS5 (0x1 << 21) /**< \brief (SUPC_SR) WKUP Input Status 5 */
#define   SUPC_SR_WKUPIS5_DIS (0x0 << 21) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS5_EN (0x1 << 21) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS6 (0x1 << 22) /**< \brief (SUPC_SR) WKUP Input Status 6 */
#define   SUPC_SR_WKUPIS6_DIS (0x0 << 22) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS6_EN (0x1 << 22) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS7 (0x1 << 23) /**< \brief (SUPC_SR) WKUP Input Status 7 */
#define   SUPC_SR_WKUPIS7_DIS (0x0 << 23) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS7_EN (0x1 << 23) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS8 (0x1 << 24) /**< \brief (SUPC_SR) WKUP Input Status 8 */
#define   SUPC_SR_WKUPIS8_DIS (0x0 << 24) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS8_EN (0x1 << 24) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS9 (0x1 << 25) /**< \brief (SUPC_SR) WKUP Input Status 9 */
#define   SUPC_SR_WKUPIS9_DIS (0x0 << 25) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS9_EN (0x1 << 25) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS10 (0x1 << 26) /**< \brief (SUPC_SR) WKUP Input Status 10 */
#define   SUPC_SR_WKUPIS10_DIS (0x0 << 26) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS10_EN (0x1 << 26) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS11 (0x1 << 27) /**< \brief (SUPC_SR) WKUP Input Status 11 */
#define   SUPC_SR_WKUPIS11_DIS (0x0 << 27) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS11_EN (0x1 << 27) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS12 (0x1 << 28) /**< \brief (SUPC_SR) WKUP Input Status 12 */
#define   SUPC_SR_WKUPIS12_DIS (0x0 << 28) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS12_EN (0x1 << 28) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS13 (0x1 << 29) /**< \brief (SUPC_SR) WKUP Input Status 13 */
#define   SUPC_SR_WKUPIS13_DIS (0x0 << 29) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS13_EN (0x1 << 29) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS14 (0x1 << 30) /**< \brief (SUPC_SR) WKUP Input Status 14 */
#define   SUPC_SR_WKUPIS14_DIS (0x0 << 30) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS14_EN (0x1 << 30) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */
#define SUPC_SR_WKUPIS15 (0x1 << 31) /**< \brief (SUPC_SR) WKUP Input Status 15 */
#define   SUPC_SR_WKUPIS15_DIS (0x0 << 31) /**< \brief (SUPC_SR) the corresponding wake-up input is disabled, or was inactive at the time the debouncer triggered a wake up event. */
#define   SUPC_SR_WKUPIS15_EN (0x1 << 31) /**< \brief (SUPC_SR) the corresponding wake-up input was active at the time the debouncer triggered a wake up event. */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Timer Counter */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_TC Timer Counter */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief TcChannel hardware registers */
typedef struct {
  RwReg      TC_CCR;        /**< \brief (TcChannel Offset: 0x0) Channel Control Register */
  RwReg      TC_CMR;        /**< \brief (TcChannel Offset: 0x4) Channel Mode Register */
  RwReg      Reserved1[2]; 
  RwReg      TC_CV;         /**< \brief (TcChannel Offset: 0x10) Counter Value */
  RwReg      TC_RA;         /**< \brief (TcChannel Offset: 0x14) Register A */
  RwReg      TC_RB;         /**< \brief (TcChannel Offset: 0x18) Register B */
  RwReg      TC_RC;         /**< \brief (TcChannel Offset: 0x1C) Register C */
  RwReg      TC_SR;         /**< \brief (TcChannel Offset: 0x20) Status Register */
  RwReg      TC_IER;        /**< \brief (TcChannel Offset: 0x24) Interrupt Enable Register */
  RwReg      TC_IDR;        /**< \brief (TcChannel Offset: 0x28) Interrupt Disable Register */
  RwReg      TC_IMR;        /**< \brief (TcChannel Offset: 0x2C) Interrupt Mask Register */
  RwReg      Reserved2[4]; 
} TcChannel;
/** \brief Tc hardware registers */
typedef struct {
  TcChannel  TC_CHANNEL[3]; /**< \brief (Tc Offset: 0x0) channel = 0 .. 2 */
  WoReg      TC_BCR;        /**< \brief (Tc Offset: 0xC0) Block Control Register */
  RwReg      TC_BMR;        /**< \brief (Tc Offset: 0xC4) Block Mode Register */
  WoReg      TC_QIER;       /**< \brief (Tc Offset: 0xC8) QDEC Interrupt Enable Register */
  WoReg      TC_QIDR;       /**< \brief (Tc Offset: 0xCC) QDEC Interrupt Disable Register */
  RoReg      TC_QIMR;       /**< \brief (Tc Offset: 0xD0) QDEC Interrupt Mask Register */
  RoReg      TC_QISR;       /**< \brief (Tc Offset: 0xD4) QDEC Interrupt Status Register */
  RwReg      Reserved1[9]; 
  RoReg      TC_VER;        /**< \brief (Tc Offset: 0xFC) Version Register */
} Tc;
#endif /* __ASSEMBLY__ */
/* -------- TC_CCR0 : (TC Offset: 0x0) Channel Control Register (channel = 0) -------- */
#define TC_CCR0_CLKEN (0x1 << 0) /**< \brief (TC_CCR0) Counter Clock Enable Command */
#define TC_CCR0_CLKDIS (0x1 << 1) /**< \brief (TC_CCR0) Counter Clock Disable Command */
#define TC_CCR0_SWTRG (0x1 << 2) /**< \brief (TC_CCR0) Software Trigger Command */
/* -------- TC_CMR0 : (TC Offset: 0x4) Channel Mode Register (channel = 0) -------- */
#define TC_CMR0_TCCLKS (0x7 << 0) /**< \brief (TC_CMR0) Clock Selection */
#define TC_CMR0_CLKI (0x1 << 3) /**< \brief (TC_CMR0) Clock Invert */
#define TC_CMR0_BURST (0x3 << 4) /**< \brief (TC_CMR0) Burst Signal Selection */
#define   TC_CMR0_BURST_NONE (0x0 << 4) /**< \brief (TC_CMR0) The clock is not gated by an external signal. */
#define   TC_CMR0_BURST_XC0 (0x1 << 4) /**< \brief (TC_CMR0) XC0 is ANDed with the selected clock. */
#define   TC_CMR0_BURST_XC1 (0x2 << 4) /**< \brief (TC_CMR0) XC1 is ANDed with the selected clock. */
#define   TC_CMR0_BURST_XC2 (0x3 << 4) /**< \brief (TC_CMR0) XC2 is ANDed with the selected clock. */
#define TC_CMR0_LDBSTOP (0x1 << 6) /**< \brief (TC_CMR0) Counter Clock Stopped with RB Loading */
#define TC_CMR0_LDBDIS (0x1 << 7) /**< \brief (TC_CMR0) Counter Clock Disable with RB Loading */
#define TC_CMR0_ETRGEDG (0x3 << 8) /**< \brief (TC_CMR0) External Trigger Edge Selection */
#define   TC_CMR0_ETRGEDG_NONE (0x0 << 8) /**< \brief (TC_CMR0) none */
#define   TC_CMR0_ETRGEDG_RISING (0x1 << 8) /**< \brief (TC_CMR0) rising edge */
#define   TC_CMR0_ETRGEDG_FALLING (0x2 << 8) /**< \brief (TC_CMR0) falling edge */
#define   TC_CMR0_ETRGEDG_BOTH (0x3 << 8) /**< \brief (TC_CMR0) each edge */
#define TC_CMR0_ABETRG (0x1 << 10) /**< \brief (TC_CMR0) TIOA or TIOB External Trigger Selection */
#define TC_CMR0_CPCTRG (0x1 << 14) /**< \brief (TC_CMR0) RC Compare Trigger Enable */
#define TC_CMR0_WAVE (0x1 << 15) /**< \brief (TC_CMR0)  */
#define TC_CMR0_LDRA (0x3 << 16) /**< \brief (TC_CMR0) RA Loading Selection */
#define   TC_CMR0_LDRA_NONE (0x0 << 16) /**< \brief (TC_CMR0) none */
#define   TC_CMR0_LDRA_RISING (0x1 << 16) /**< \brief (TC_CMR0) rising edge of TIOA */
#define   TC_CMR0_LDRA_FALLING (0x2 << 16) /**< \brief (TC_CMR0) falling edge of TIOA */
#define   TC_CMR0_LDRA_BOTH (0x3 << 16) /**< \brief (TC_CMR0) each edge of TIOA */
#define TC_CMR0_LDRB (0x3 << 18) /**< \brief (TC_CMR0) RB Loading Selection */
#define   TC_CMR0_LDRB_NONE (0x0 << 18) /**< \brief (TC_CMR0) none */
#define   TC_CMR0_LDRB_RISING (0x1 << 18) /**< \brief (TC_CMR0) rising edge of TIOA */
#define   TC_CMR0_LDRB_FALLING (0x2 << 18) /**< \brief (TC_CMR0) falling edge of TIOA */
#define   TC_CMR0_LDRB_BOTH (0x3 << 18) /**< \brief (TC_CMR0) each edge of TIOA */
/* -------- TC_CV0 : (TC Offset: 0x10) Counter Value (channel = 0) -------- */
#define TC_CV0_CV (0xffff << 0) /**< \brief (TC_CV0) Counter Value */
/* -------- TC_RA0 : (TC Offset: 0x14) Register A (channel = 0) -------- */
#define TC_RA0_RA (0xffff << 0) /**< \brief (TC_RA0) Register A */
/* -------- TC_RB0 : (TC Offset: 0x18) Register B (channel = 0) -------- */
#define TC_RB0_RB (0xffff << 0) /**< \brief (TC_RB0) Register B */
/* -------- TC_RC0 : (TC Offset: 0x1C) Register C (channel = 0) -------- */
#define TC_RC0_RC (0xffff << 0) /**< \brief (TC_RC0) Register C */
/* -------- TC_SR0 : (TC Offset: 0x20) Status Register (channel = 0) -------- */
#define TC_SR0_COVFS (0x1 << 0) /**< \brief (TC_SR0) Counter Overflow Status */
#define TC_SR0_LOVRS (0x1 << 1) /**< \brief (TC_SR0) Load Overrun Status */
#define TC_SR0_CPAS (0x1 << 2) /**< \brief (TC_SR0) RA Compare Status */
#define TC_SR0_CPBS (0x1 << 3) /**< \brief (TC_SR0) RB Compare Status */
#define TC_SR0_CPCS (0x1 << 4) /**< \brief (TC_SR0) RC Compare Status */
#define TC_SR0_LDRAS (0x1 << 5) /**< \brief (TC_SR0) RA Loading Status */
#define TC_SR0_LDRBS (0x1 << 6) /**< \brief (TC_SR0) RB Loading Status */
#define TC_SR0_ETRGS (0x1 << 7) /**< \brief (TC_SR0) External Trigger Status */
#define TC_SR0_CLKSTA (0x1 << 16) /**< \brief (TC_SR0) Clock Enabling Status */
#define TC_SR0_MTIOA (0x1 << 17) /**< \brief (TC_SR0) TIOA Mirror */
#define TC_SR0_MTIOB (0x1 << 18) /**< \brief (TC_SR0) TIOB Mirror */
/* -------- TC_IER0 : (TC Offset: 0x24) Interrupt Enable Register (channel = 0) -------- */
#define TC_IER0_COVFS (0x1 << 0) /**< \brief (TC_IER0) Counter Overflow */
#define TC_IER0_LOVRS (0x1 << 1) /**< \brief (TC_IER0) Load Overrun */
#define TC_IER0_CPAS (0x1 << 2) /**< \brief (TC_IER0) RA Compare */
#define TC_IER0_CPBS (0x1 << 3) /**< \brief (TC_IER0) RB Compare */
#define TC_IER0_CPCS (0x1 << 4) /**< \brief (TC_IER0) RC Compare */
#define TC_IER0_LDRAS (0x1 << 5) /**< \brief (TC_IER0) RA Loading */
#define TC_IER0_LDRBS (0x1 << 6) /**< \brief (TC_IER0) RB Loading */
#define TC_IER0_ETRGS (0x1 << 7) /**< \brief (TC_IER0) External Trigger */
/* -------- TC_IDR0 : (TC Offset: 0x28) Interrupt Disable Register (channel = 0) -------- */
#define TC_IDR0_COVFS (0x1 << 0) /**< \brief (TC_IDR0) Counter Overflow */
#define TC_IDR0_LOVRS (0x1 << 1) /**< \brief (TC_IDR0) Load Overrun */
#define TC_IDR0_CPAS (0x1 << 2) /**< \brief (TC_IDR0) RA Compare */
#define TC_IDR0_CPBS (0x1 << 3) /**< \brief (TC_IDR0) RB Compare */
#define TC_IDR0_CPCS (0x1 << 4) /**< \brief (TC_IDR0) RC Compare */
#define TC_IDR0_LDRAS (0x1 << 5) /**< \brief (TC_IDR0) RA Loading */
#define TC_IDR0_LDRBS (0x1 << 6) /**< \brief (TC_IDR0) RB Loading */
#define TC_IDR0_ETRGS (0x1 << 7) /**< \brief (TC_IDR0) External Trigger */
/* -------- TC_IMR0 : (TC Offset: 0x2C) Interrupt Mask Register (channel = 0) -------- */
#define TC_IMR0_COVFS (0x1 << 0) /**< \brief (TC_IMR0) Counter Overflow */
#define TC_IMR0_LOVRS (0x1 << 1) /**< \brief (TC_IMR0) Load Overrun */
#define TC_IMR0_CPAS (0x1 << 2) /**< \brief (TC_IMR0) RA Compare */
#define TC_IMR0_CPBS (0x1 << 3) /**< \brief (TC_IMR0) RB Compare */
#define TC_IMR0_CPCS (0x1 << 4) /**< \brief (TC_IMR0) RC Compare */
#define TC_IMR0_LDRAS (0x1 << 5) /**< \brief (TC_IMR0) RA Loading */
#define TC_IMR0_LDRBS (0x1 << 6) /**< \brief (TC_IMR0) RB Loading */
#define TC_IMR0_ETRGS (0x1 << 7) /**< \brief (TC_IMR0) External Trigger */
/* -------- TC_CCR1 : (TC Offset: 0x40) Channel Control Register (channel = 1) -------- */
#define TC_CCR1_CLKEN (0x1 << 0) /**< \brief (TC_CCR1) Counter Clock Enable Command */
#define TC_CCR1_CLKDIS (0x1 << 1) /**< \brief (TC_CCR1) Counter Clock Disable Command */
#define TC_CCR1_SWTRG (0x1 << 2) /**< \brief (TC_CCR1) Software Trigger Command */
/* -------- TC_CMR1 : (TC Offset: 0x44) Channel Mode Register (channel = 1) -------- */
#define TC_CMR1_TCCLKS (0x7 << 0) /**< \brief (TC_CMR1) Clock Selection */
#define TC_CMR1_CLKI (0x1 << 3) /**< \brief (TC_CMR1) Clock Invert */
#define TC_CMR1_BURST (0x3 << 4) /**< \brief (TC_CMR1) Burst Signal Selection */
#define   TC_CMR1_BURST_NONE (0x0 << 4) /**< \brief (TC_CMR1) The clock is not gated by an external signal. */
#define   TC_CMR1_BURST_XC0 (0x1 << 4) /**< \brief (TC_CMR1) XC0 is ANDed with the selected clock. */
#define   TC_CMR1_BURST_XC1 (0x2 << 4) /**< \brief (TC_CMR1) XC1 is ANDed with the selected clock. */
#define   TC_CMR1_BURST_XC2 (0x3 << 4) /**< \brief (TC_CMR1) XC2 is ANDed with the selected clock. */
#define TC_CMR1_LDBSTOP (0x1 << 6) /**< \brief (TC_CMR1) Counter Clock Stopped with RB Loading */
#define TC_CMR1_LDBDIS (0x1 << 7) /**< \brief (TC_CMR1) Counter Clock Disable with RB Loading */
#define TC_CMR1_ETRGEDG (0x3 << 8) /**< \brief (TC_CMR1) External Trigger Edge Selection */
#define   TC_CMR1_ETRGEDG_NONE (0x0 << 8) /**< \brief (TC_CMR1) none */
#define   TC_CMR1_ETRGEDG_RISING (0x1 << 8) /**< \brief (TC_CMR1) rising edge */
#define   TC_CMR1_ETRGEDG_FALLING (0x2 << 8) /**< \brief (TC_CMR1) falling edge */
#define   TC_CMR1_ETRGEDG_BOTH (0x3 << 8) /**< \brief (TC_CMR1) each edge */
#define TC_CMR1_ABETRG (0x1 << 10) /**< \brief (TC_CMR1) TIOA or TIOB External Trigger Selection */
#define TC_CMR1_CPCTRG (0x1 << 14) /**< \brief (TC_CMR1) RC Compare Trigger Enable */
#define TC_CMR1_WAVE (0x1 << 15) /**< \brief (TC_CMR1)  */
#define TC_CMR1_LDRA (0x3 << 16) /**< \brief (TC_CMR1) RA Loading Selection */
#define   TC_CMR1_LDRA_NONE (0x0 << 16) /**< \brief (TC_CMR1) none */
#define   TC_CMR1_LDRA_RISING (0x1 << 16) /**< \brief (TC_CMR1) rising edge of TIOA */
#define   TC_CMR1_LDRA_FALLING (0x2 << 16) /**< \brief (TC_CMR1) falling edge of TIOA */
#define   TC_CMR1_LDRA_BOTH (0x3 << 16) /**< \brief (TC_CMR1) each edge of TIOA */
#define TC_CMR1_LDRB (0x3 << 18) /**< \brief (TC_CMR1) RB Loading Selection */
#define   TC_CMR1_LDRB_NONE (0x0 << 18) /**< \brief (TC_CMR1) none */
#define   TC_CMR1_LDRB_RISING (0x1 << 18) /**< \brief (TC_CMR1) rising edge of TIOA */
#define   TC_CMR1_LDRB_FALLING (0x2 << 18) /**< \brief (TC_CMR1) falling edge of TIOA */
#define   TC_CMR1_LDRB_BOTH (0x3 << 18) /**< \brief (TC_CMR1) each edge of TIOA */
/* -------- TC_CV1 : (TC Offset: 0x50) Counter Value (channel = 1) -------- */
#define TC_CV1_CV (0xffff << 0) /**< \brief (TC_CV1) Counter Value */
/* -------- TC_RA1 : (TC Offset: 0x54) Register A (channel = 1) -------- */
#define TC_RA1_RA (0xffff << 0) /**< \brief (TC_RA1) Register A */
/* -------- TC_RB1 : (TC Offset: 0x58) Register B (channel = 1) -------- */
#define TC_RB1_RB (0xffff << 0) /**< \brief (TC_RB1) Register B */
/* -------- TC_RC1 : (TC Offset: 0x5C) Register C (channel = 1) -------- */
#define TC_RC1_RC (0xffff << 0) /**< \brief (TC_RC1) Register C */
/* -------- TC_SR1 : (TC Offset: 0x60) Status Register (channel = 1) -------- */
#define TC_SR1_COVFS (0x1 << 0) /**< \brief (TC_SR1) Counter Overflow Status */
#define TC_SR1_LOVRS (0x1 << 1) /**< \brief (TC_SR1) Load Overrun Status */
#define TC_SR1_CPAS (0x1 << 2) /**< \brief (TC_SR1) RA Compare Status */
#define TC_SR1_CPBS (0x1 << 3) /**< \brief (TC_SR1) RB Compare Status */
#define TC_SR1_CPCS (0x1 << 4) /**< \brief (TC_SR1) RC Compare Status */
#define TC_SR1_LDRAS (0x1 << 5) /**< \brief (TC_SR1) RA Loading Status */
#define TC_SR1_LDRBS (0x1 << 6) /**< \brief (TC_SR1) RB Loading Status */
#define TC_SR1_ETRGS (0x1 << 7) /**< \brief (TC_SR1) External Trigger Status */
#define TC_SR1_CLKSTA (0x1 << 16) /**< \brief (TC_SR1) Clock Enabling Status */
#define TC_SR1_MTIOA (0x1 << 17) /**< \brief (TC_SR1) TIOA Mirror */
#define TC_SR1_MTIOB (0x1 << 18) /**< \brief (TC_SR1) TIOB Mirror */
/* -------- TC_IER1 : (TC Offset: 0x64) Interrupt Enable Register (channel = 1) -------- */
#define TC_IER1_COVFS (0x1 << 0) /**< \brief (TC_IER1) Counter Overflow */
#define TC_IER1_LOVRS (0x1 << 1) /**< \brief (TC_IER1) Load Overrun */
#define TC_IER1_CPAS (0x1 << 2) /**< \brief (TC_IER1) RA Compare */
#define TC_IER1_CPBS (0x1 << 3) /**< \brief (TC_IER1) RB Compare */
#define TC_IER1_CPCS (0x1 << 4) /**< \brief (TC_IER1) RC Compare */
#define TC_IER1_LDRAS (0x1 << 5) /**< \brief (TC_IER1) RA Loading */
#define TC_IER1_LDRBS (0x1 << 6) /**< \brief (TC_IER1) RB Loading */
#define TC_IER1_ETRGS (0x1 << 7) /**< \brief (TC_IER1) External Trigger */
/* -------- TC_IDR1 : (TC Offset: 0x68) Interrupt Disable Register (channel = 1) -------- */
#define TC_IDR1_COVFS (0x1 << 0) /**< \brief (TC_IDR1) Counter Overflow */
#define TC_IDR1_LOVRS (0x1 << 1) /**< \brief (TC_IDR1) Load Overrun */
#define TC_IDR1_CPAS (0x1 << 2) /**< \brief (TC_IDR1) RA Compare */
#define TC_IDR1_CPBS (0x1 << 3) /**< \brief (TC_IDR1) RB Compare */
#define TC_IDR1_CPCS (0x1 << 4) /**< \brief (TC_IDR1) RC Compare */
#define TC_IDR1_LDRAS (0x1 << 5) /**< \brief (TC_IDR1) RA Loading */
#define TC_IDR1_LDRBS (0x1 << 6) /**< \brief (TC_IDR1) RB Loading */
#define TC_IDR1_ETRGS (0x1 << 7) /**< \brief (TC_IDR1) External Trigger */
/* -------- TC_IMR1 : (TC Offset: 0x6C) Interrupt Mask Register (channel = 1) -------- */
#define TC_IMR1_COVFS (0x1 << 0) /**< \brief (TC_IMR1) Counter Overflow */
#define TC_IMR1_LOVRS (0x1 << 1) /**< \brief (TC_IMR1) Load Overrun */
#define TC_IMR1_CPAS (0x1 << 2) /**< \brief (TC_IMR1) RA Compare */
#define TC_IMR1_CPBS (0x1 << 3) /**< \brief (TC_IMR1) RB Compare */
#define TC_IMR1_CPCS (0x1 << 4) /**< \brief (TC_IMR1) RC Compare */
#define TC_IMR1_LDRAS (0x1 << 5) /**< \brief (TC_IMR1) RA Loading */
#define TC_IMR1_LDRBS (0x1 << 6) /**< \brief (TC_IMR1) RB Loading */
#define TC_IMR1_ETRGS (0x1 << 7) /**< \brief (TC_IMR1) External Trigger */
/* -------- TC_CCR2 : (TC Offset: 0x80) Channel Control Register (channel = 2) -------- */
#define TC_CCR2_CLKEN (0x1 << 0) /**< \brief (TC_CCR2) Counter Clock Enable Command */
#define TC_CCR2_CLKDIS (0x1 << 1) /**< \brief (TC_CCR2) Counter Clock Disable Command */
#define TC_CCR2_SWTRG (0x1 << 2) /**< \brief (TC_CCR2) Software Trigger Command */
/* -------- TC_CMR2 : (TC Offset: 0x84) Channel Mode Register (channel = 2) -------- */
#define TC_CMR2_TCCLKS (0x7 << 0) /**< \brief (TC_CMR2) Clock Selection */
#define TC_CMR2_CLKI (0x1 << 3) /**< \brief (TC_CMR2) Clock Invert */
#define TC_CMR2_BURST (0x3 << 4) /**< \brief (TC_CMR2) Burst Signal Selection */
#define   TC_CMR2_BURST_NONE (0x0 << 4) /**< \brief (TC_CMR2) The clock is not gated by an external signal. */
#define   TC_CMR2_BURST_XC0 (0x1 << 4) /**< \brief (TC_CMR2) XC0 is ANDed with the selected clock. */
#define   TC_CMR2_BURST_XC1 (0x2 << 4) /**< \brief (TC_CMR2) XC1 is ANDed with the selected clock. */
#define   TC_CMR2_BURST_XC2 (0x3 << 4) /**< \brief (TC_CMR2) XC2 is ANDed with the selected clock. */
#define TC_CMR2_LDBSTOP (0x1 << 6) /**< \brief (TC_CMR2) Counter Clock Stopped with RB Loading */
#define TC_CMR2_LDBDIS (0x1 << 7) /**< \brief (TC_CMR2) Counter Clock Disable with RB Loading */
#define TC_CMR2_ETRGEDG (0x3 << 8) /**< \brief (TC_CMR2) External Trigger Edge Selection */
#define   TC_CMR2_ETRGEDG_NONE (0x0 << 8) /**< \brief (TC_CMR2) none */
#define   TC_CMR2_ETRGEDG_RISING (0x1 << 8) /**< \brief (TC_CMR2) rising edge */
#define   TC_CMR2_ETRGEDG_FALLING (0x2 << 8) /**< \brief (TC_CMR2) falling edge */
#define   TC_CMR2_ETRGEDG_BOTH (0x3 << 8) /**< \brief (TC_CMR2) each edge */
#define TC_CMR2_ABETRG (0x1 << 10) /**< \brief (TC_CMR2) TIOA or TIOB External Trigger Selection */
#define TC_CMR2_CPCTRG (0x1 << 14) /**< \brief (TC_CMR2) RC Compare Trigger Enable */
#define TC_CMR2_WAVE (0x1 << 15) /**< \brief (TC_CMR2)  */
#define TC_CMR2_LDRA (0x3 << 16) /**< \brief (TC_CMR2) RA Loading Selection */
#define   TC_CMR2_LDRA_NONE (0x0 << 16) /**< \brief (TC_CMR2) none */
#define   TC_CMR2_LDRA_RISING (0x1 << 16) /**< \brief (TC_CMR2) rising edge of TIOA */
#define   TC_CMR2_LDRA_FALLING (0x2 << 16) /**< \brief (TC_CMR2) falling edge of TIOA */
#define   TC_CMR2_LDRA_BOTH (0x3 << 16) /**< \brief (TC_CMR2) each edge of TIOA */
#define TC_CMR2_LDRB (0x3 << 18) /**< \brief (TC_CMR2) RB Loading Selection */
#define   TC_CMR2_LDRB_NONE (0x0 << 18) /**< \brief (TC_CMR2) none */
#define   TC_CMR2_LDRB_RISING (0x1 << 18) /**< \brief (TC_CMR2) rising edge of TIOA */
#define   TC_CMR2_LDRB_FALLING (0x2 << 18) /**< \brief (TC_CMR2) falling edge of TIOA */
#define   TC_CMR2_LDRB_BOTH (0x3 << 18) /**< \brief (TC_CMR2) each edge of TIOA */
/* -------- TC_CV2 : (TC Offset: 0x90) Counter Value (channel = 2) -------- */
#define TC_CV2_CV (0xffff << 0) /**< \brief (TC_CV2) Counter Value */
/* -------- TC_RA2 : (TC Offset: 0x94) Register A (channel = 2) -------- */
#define TC_RA2_RA (0xffff << 0) /**< \brief (TC_RA2) Register A */
/* -------- TC_RB2 : (TC Offset: 0x98) Register B (channel = 2) -------- */
#define TC_RB2_RB (0xffff << 0) /**< \brief (TC_RB2) Register B */
/* -------- TC_RC2 : (TC Offset: 0x9C) Register C (channel = 2) -------- */
#define TC_RC2_RC (0xffff << 0) /**< \brief (TC_RC2) Register C */
/* -------- TC_SR2 : (TC Offset: 0xA0) Status Register (channel = 2) -------- */
#define TC_SR2_COVFS (0x1 << 0) /**< \brief (TC_SR2) Counter Overflow Status */
#define TC_SR2_LOVRS (0x1 << 1) /**< \brief (TC_SR2) Load Overrun Status */
#define TC_SR2_CPAS (0x1 << 2) /**< \brief (TC_SR2) RA Compare Status */
#define TC_SR2_CPBS (0x1 << 3) /**< \brief (TC_SR2) RB Compare Status */
#define TC_SR2_CPCS (0x1 << 4) /**< \brief (TC_SR2) RC Compare Status */
#define TC_SR2_LDRAS (0x1 << 5) /**< \brief (TC_SR2) RA Loading Status */
#define TC_SR2_LDRBS (0x1 << 6) /**< \brief (TC_SR2) RB Loading Status */
#define TC_SR2_ETRGS (0x1 << 7) /**< \brief (TC_SR2) External Trigger Status */
#define TC_SR2_CLKSTA (0x1 << 16) /**< \brief (TC_SR2) Clock Enabling Status */
#define TC_SR2_MTIOA (0x1 << 17) /**< \brief (TC_SR2) TIOA Mirror */
#define TC_SR2_MTIOB (0x1 << 18) /**< \brief (TC_SR2) TIOB Mirror */
/* -------- TC_IER2 : (TC Offset: 0xA4) Interrupt Enable Register (channel = 2) -------- */
#define TC_IER2_COVFS (0x1 << 0) /**< \brief (TC_IER2) Counter Overflow */
#define TC_IER2_LOVRS (0x1 << 1) /**< \brief (TC_IER2) Load Overrun */
#define TC_IER2_CPAS (0x1 << 2) /**< \brief (TC_IER2) RA Compare */
#define TC_IER2_CPBS (0x1 << 3) /**< \brief (TC_IER2) RB Compare */
#define TC_IER2_CPCS (0x1 << 4) /**< \brief (TC_IER2) RC Compare */
#define TC_IER2_LDRAS (0x1 << 5) /**< \brief (TC_IER2) RA Loading */
#define TC_IER2_LDRBS (0x1 << 6) /**< \brief (TC_IER2) RB Loading */
#define TC_IER2_ETRGS (0x1 << 7) /**< \brief (TC_IER2) External Trigger */
/* -------- TC_IDR2 : (TC Offset: 0xA8) Interrupt Disable Register (channel = 2) -------- */
#define TC_IDR2_COVFS (0x1 << 0) /**< \brief (TC_IDR2) Counter Overflow */
#define TC_IDR2_LOVRS (0x1 << 1) /**< \brief (TC_IDR2) Load Overrun */
#define TC_IDR2_CPAS (0x1 << 2) /**< \brief (TC_IDR2) RA Compare */
#define TC_IDR2_CPBS (0x1 << 3) /**< \brief (TC_IDR2) RB Compare */
#define TC_IDR2_CPCS (0x1 << 4) /**< \brief (TC_IDR2) RC Compare */
#define TC_IDR2_LDRAS (0x1 << 5) /**< \brief (TC_IDR2) RA Loading */
#define TC_IDR2_LDRBS (0x1 << 6) /**< \brief (TC_IDR2) RB Loading */
#define TC_IDR2_ETRGS (0x1 << 7) /**< \brief (TC_IDR2) External Trigger */
/* -------- TC_IMR2 : (TC Offset: 0xAC) Interrupt Mask Register (channel = 2) -------- */
#define TC_IMR2_COVFS (0x1 << 0) /**< \brief (TC_IMR2) Counter Overflow */
#define TC_IMR2_LOVRS (0x1 << 1) /**< \brief (TC_IMR2) Load Overrun */
#define TC_IMR2_CPAS (0x1 << 2) /**< \brief (TC_IMR2) RA Compare */
#define TC_IMR2_CPBS (0x1 << 3) /**< \brief (TC_IMR2) RB Compare */
#define TC_IMR2_CPCS (0x1 << 4) /**< \brief (TC_IMR2) RC Compare */
#define TC_IMR2_LDRAS (0x1 << 5) /**< \brief (TC_IMR2) RA Loading */
#define TC_IMR2_LDRBS (0x1 << 6) /**< \brief (TC_IMR2) RB Loading */
#define TC_IMR2_ETRGS (0x1 << 7) /**< \brief (TC_IMR2) External Trigger */
/* -------- TC_BCR : (TC Offset: 0xC0) Block Control Register -------- */
#define TC_BCR_SYNC (0x1 << 0) /**< \brief (TC_BCR) Synchro Command */
/* -------- TC_BMR : (TC Offset: 0xC4) Block Mode Register -------- */
#define TC_BMR_TC0XC0S (0x3 << 0) /**< \brief (TC_BMR) External Clock Signal 0 Selection */
#define   TC_BMR_TC0XC0S_TCLK0 (0x0 << 0) /**< \brief (TC_BMR) TCLK0 */
#define   TC_BMR_TC0XC0S_NONE (0x1 << 0) /**< \brief (TC_BMR) none */
#define   TC_BMR_TC0XC0S_TIOA1 (0x2 << 0) /**< \brief (TC_BMR) TIOA1 */
#define   TC_BMR_TC0XC0S_TIOA2 (0x3 << 0) /**< \brief (TC_BMR) TIOA2 */
#define TC_BMR_TC1XC1S (0x3 << 2) /**< \brief (TC_BMR) External Clock Signal 1 Selection */
#define   TC_BMR_TC1XC1S_TCLK1 (0x0 << 2) /**< \brief (TC_BMR) TCLK1 */
#define   TC_BMR_TC1XC1S_NONE (0x1 << 2) /**< \brief (TC_BMR) none */
#define   TC_BMR_TC1XC1S_TIOA0 (0x2 << 2) /**< \brief (TC_BMR) TIOA0 */
#define   TC_BMR_TC1XC1S_TIOA2 (0x3 << 2) /**< \brief (TC_BMR) TIOA2 */
#define TC_BMR_TC2XC2S (0x3 << 4) /**< \brief (TC_BMR) External Clock Signal 2 Selection */
#define   TC_BMR_TC2XC2S_TCLK2 (0x0 << 4) /**< \brief (TC_BMR) TCLK2 */
#define   TC_BMR_TC2XC2S_NONE (0x1 << 4) /**< \brief (TC_BMR) none */
#define   TC_BMR_TC2XC2S_TIOA0 (0x2 << 4) /**< \brief (TC_BMR) TIOA0 */
#define   TC_BMR_TC2XC2S_TIOA1 (0x3 << 4) /**< \brief (TC_BMR) TIOA1 */
#define TC_BMR_QDEN (0x1 << 8) /**< \brief (TC_BMR) Quadrature Decoder ENabled */
#define TC_BMR_POSEN (0x1 << 9) /**< \brief (TC_BMR) POSition ENabled */
#define TC_BMR_SPEEDEN (0x1 << 10) /**< \brief (TC_BMR) SPEED ENabled */
#define TC_BMR_QDTRANS (0x1 << 11) /**< \brief (TC_BMR) Quadrature Decoding TRANSparent */
#define TC_BMR_EDGPHA (0x1 << 12) /**< \brief (TC_BMR) EDGe on PHA count mode */
#define TC_BMR_INVA (0x1 << 13) /**< \brief (TC_BMR) INVerted phA */
#define TC_BMR_INVB (0x1 << 14) /**< \brief (TC_BMR) INVerted phB */
#define TC_BMR_INVIDX (0x1 << 15) /**< \brief (TC_BMR) INVerted InDeX */
#define TC_BMR_SWAP (0x1 << 16) /**< \brief (TC_BMR) SWAP PHA and PHB */
#define TC_BMR_IDXPHB (0x1 << 17) /**< \brief (TC_BMR) InDeX pin is PHB pin */
#define TC_BMR_FILTER (0x1 << 19) /**< \brief (TC_BMR)  */
#define TC_BMR_MAXFILT (0x3f << 20) /**< \brief (TC_BMR) MAXimum FILTer */
/* -------- TC_QIER : (TC Offset: 0xC8) QDEC Interrupt Enable Register -------- */
#define TC_QIER_IDX (0x1 << 0) /**< \brief (TC_QIER) InDeX */
#define TC_QIER_DIRCHG (0x1 << 1) /**< \brief (TC_QIER) DIRection CHanGe */
#define TC_QIER_QERR (0x1 << 2) /**< \brief (TC_QIER) Quadrature ERRor */
/* -------- TC_QIDR : (TC Offset: 0xCC) QDEC Interrupt Disable Register -------- */
#define TC_QIDR_IDX (0x1 << 0) /**< \brief (TC_QIDR) InDeX */
#define TC_QIDR_DIRCHG (0x1 << 1) /**< \brief (TC_QIDR) DIRection CHanGe */
#define TC_QIDR_QERR (0x1 << 2) /**< \brief (TC_QIDR) Quadrature ERRor */
/* -------- TC_QIMR : (TC Offset: 0xD0) QDEC Interrupt Mask Register -------- */
#define TC_QIMR_IDX (0x1 << 0) /**< \brief (TC_QIMR) InDeX */
#define TC_QIMR_DIRCHG (0x1 << 1) /**< \brief (TC_QIMR) DIRection CHanGe */
#define TC_QIMR_QERR (0x1 << 2) /**< \brief (TC_QIMR) Quadrature ERRor */
/* -------- TC_QISR : (TC Offset: 0xD4) QDEC Interrupt Status Register -------- */
#define TC_QISR_IDX (0x1 << 0) /**< \brief (TC_QISR) InDeX */
#define TC_QISR_DIRCHG (0x1 << 1) /**< \brief (TC_QISR) DIRection CHanGe */
#define TC_QISR_QERR (0x1 << 2) /**< \brief (TC_QISR) Quadrature ERRor */
#define TC_QISR_DIR (0x1 << 8) /**< \brief (TC_QISR) Direction */
/* -------- TC_VER : (TC Offset: 0xFC) Version Register -------- */
#define TC_VER_VERSION (0xfff << 0) /**< \brief (TC_VER)  */
#define TC_VER_MFN (0x7 << 16) /**< \brief (TC_VER)  */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Two-wire Interface */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_TWI Two-wire Interface */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Twi hardware registers */
typedef struct {
  WoReg TWI_CR;        /**< \brief (Twi Offset: 0x00) Control Register */
  RwReg TWI_MMR;       /**< \brief (Twi Offset: 0x04) Master Mode Register */
  RwReg TWI_SMR;       /**< \brief (Twi Offset: 0x08) Slave Mode Register */
  RwReg TWI_IADR;      /**< \brief (Twi Offset: 0x0C) Internal Address Register */
  RwReg TWI_CWGR;      /**< \brief (Twi Offset: 0x10) Clock Waveform Generator Register */
  RwReg Reserved1[3]; 
  RoReg TWI_SR;        /**< \brief (Twi Offset: 0x20) Status Register */
  WoReg TWI_IER;       /**< \brief (Twi Offset: 0x24) Interrupt Enable Register */
  WoReg TWI_IDR;       /**< \brief (Twi Offset: 0x28) Interrupt Disable Register */
  RoReg TWI_IMR;       /**< \brief (Twi Offset: 0x2C) Interrupt Mask Register */
  RoReg TWI_RHR;       /**< \brief (Twi Offset: 0x30) Receive Holding Register */
  WoReg TWI_THR;       /**< \brief (Twi Offset: 0x34) Transmit Holding Register */
  RwReg Reserved2[50];
  RwReg TWI_RPR;       /**< \brief (Twi Offset: 0x100) Receive Pointer Register */
  RwReg TWI_RCR;       /**< \brief (Twi Offset: 0x104) Receive Counter Register */
  RwReg TWI_TPR;       /**< \brief (Twi Offset: 0x108) Transmit Pointer Register */
  RwReg TWI_TCR;       /**< \brief (Twi Offset: 0x10C) Transmit Counter Register */
  RwReg TWI_RNPR;      /**< \brief (Twi Offset: 0x110) Receive Next Pointer Register */
  RwReg TWI_RNCR;      /**< \brief (Twi Offset: 0x114) Receive Next Counter Register */
  RwReg TWI_TNPR;      /**< \brief (Twi Offset: 0x118) Transmit Next Pointer Register */
  RwReg TWI_TNCR;      /**< \brief (Twi Offset: 0x11C) Transmit Next Counter Register */
  WoReg TWI_PTCR;      /**< \brief (Twi Offset: 0x120) Transfer Control Register */
  RoReg TWI_PTSR;      /**< \brief (Twi Offset: 0x124) Transfer Status Register */
} Twi;
#endif /* __ASSEMBLY__ */
/* -------- TWI_CR : (TWI Offset: 0x00) Control Register -------- */
#define TWI_CR_START (0x1 << 0) /**< \brief (TWI_CR) Send a START Condition */
#define TWI_CR_STOP (0x1 << 1) /**< \brief (TWI_CR) Send a STOP Condition */
#define TWI_CR_MSEN (0x1 << 2) /**< \brief (TWI_CR) TWI Master Mode Enabled */
#define TWI_CR_MSDIS (0x1 << 3) /**< \brief (TWI_CR) TWI Master Mode Disabled */
#define TWI_CR_SVEN (0x1 << 4) /**< \brief (TWI_CR) TWI Slave Mode Enabled */
#define TWI_CR_SVDIS (0x1 << 5) /**< \brief (TWI_CR) TWI Slave Mode Disabled */
#define TWI_CR_QUICK (0x1 << 6) /**< \brief (TWI_CR) SMBUS Quick Command */
#define TWI_CR_SWRST (0x1 << 7) /**< \brief (TWI_CR) Software Reset */
/* -------- TWI_MMR : (TWI Offset: 0x04) Master Mode Register -------- */
#define TWI_MMR_IADRSZ (0x3 << 8) /**< \brief (TWI_MMR) Internal Device Address Size */
#define   TWI_MMR_IADRSZ_NO (0x0 << 8) /**< \brief (TWI_MMR) No internal device address */
#define   TWI_MMR_IADRSZ_1_BYTE (0x1 << 8) /**< \brief (TWI_MMR) One-byte internal device address */
#define   TWI_MMR_IADRSZ_2_BYTE (0x2 << 8) /**< \brief (TWI_MMR) Two-byte internal device address */
#define   TWI_MMR_IADRSZ_3_BYTE (0x3 << 8) /**< \brief (TWI_MMR) Three-byte internal device address */
#define TWI_MMR_MREAD (0x1 << 12) /**< \brief (TWI_MMR) Master Read Direction */
#define TWI_MMR_DADR (0x7f << 16) /**< \brief (TWI_MMR) Device Address */
/* -------- TWI_SMR : (TWI Offset: 0x08) Slave Mode Register -------- */
#define TWI_SMR_SADR (0x7f << 16) /**< \brief (TWI_SMR) Slave Address */
/* -------- TWI_IADR : (TWI Offset: 0x0C) Internal Address Register -------- */
#define TWI_IADR_IADR (0xffffff << 0) /**< \brief (TWI_IADR) Internal Address */
/* -------- TWI_CWGR : (TWI Offset: 0x10) Clock Waveform Generator Register -------- */
#define TWI_CWGR_CLDIV (0xff << 0) /**< \brief (TWI_CWGR) Clock Low Divider */
#define TWI_CWGR_CHDIV (0xff << 8) /**< \brief (TWI_CWGR) Clock High Divider */
#define TWI_CWGR_CKDIV (0x7 << 16) /**< \brief (TWI_CWGR) Clock Divider */
/* -------- TWI_SR : (TWI Offset: 0x20) Status Register -------- */
#define TWI_SR_TXCOMP (0x1 << 0) /**< \brief (TWI_SR) Transmission Completed (automatically set / reset) */
#define TWI_SR_RXRDY (0x1 << 1) /**< \brief (TWI_SR) Receive Holding Register Ready (automatically set / reset) */
#define TWI_SR_TXRDY (0x1 << 2) /**< \brief (TWI_SR) Transmit Holding Register Ready (automatically set / reset) */
#define TWI_SR_SVREAD (0x1 << 3) /**< \brief (TWI_SR) Slave Read (automatically set / reset) */
#define TWI_SR_SVACC (0x1 << 4) /**< \brief (TWI_SR) Slave Access (automatically set / reset) */
#define TWI_SR_GACC (0x1 << 5) /**< \brief (TWI_SR) General Call Access (clear on read) */
#define TWI_SR_OVRE (0x1 << 6) /**< \brief (TWI_SR) Overrun Error (clear on read) */
#define TWI_SR_NACK (0x1 << 8) /**< \brief (TWI_SR) Not Acknowledged (clear on read) */
#define TWI_SR_ARBLST (0x1 << 9) /**< \brief (TWI_SR) Arbitration Lost (clear on read) */
#define TWI_SR_SCLWS (0x1 << 10) /**< \brief (TWI_SR) Clock Wait State (automatically set / reset) */
#define TWI_SR_EOSACC (0x1 << 11) /**< \brief (TWI_SR) End Of Slave Access (clear on read) */
#define TWI_SR_ENDRX (0x1 << 12) /**< \brief (TWI_SR) End of RX buffer */
#define TWI_SR_ENDTX (0x1 << 13) /**< \brief (TWI_SR) End of TX buffer */
#define TWI_SR_RXBUFF (0x1 << 14) /**< \brief (TWI_SR) RX Buffer Full */
#define TWI_SR_TXBUFE (0x1 << 15) /**< \brief (TWI_SR) TX Buffer Empty */
/* -------- TWI_IER : (TWI Offset: 0x24) Interrupt Enable Register -------- */
#define TWI_IER_TXCOMP (0x1 << 0) /**< \brief (TWI_IER) Transmission Completed Interrupt Enable */
#define TWI_IER_RXRDY (0x1 << 1) /**< \brief (TWI_IER) Receive Holding Register Ready Interrupt Enable */
#define TWI_IER_TXRDY (0x1 << 2) /**< \brief (TWI_IER) Transmit Holding Register Ready Interrupt Enable */
#define TWI_IER_SVACC (0x1 << 4) /**< \brief (TWI_IER) Slave Access Interrupt Enable */
#define TWI_IER_GACC (0x1 << 5) /**< \brief (TWI_IER) General Call Access Interrupt Enable */
#define TWI_IER_OVRE (0x1 << 6) /**< \brief (TWI_IER) Overrun Error Interrupt Enable */
#define TWI_IER_NACK (0x1 << 8) /**< \brief (TWI_IER) Not Acknowledge Interrupt Enable */
#define TWI_IER_ARBLST (0x1 << 9) /**< \brief (TWI_IER) Arbitration Lost Interrupt Enable */
#define TWI_IER_SCL_WS (0x1 << 10) /**< \brief (TWI_IER) Clock Wait State Interrupt Enable */
#define TWI_IER_EOSACC (0x1 << 11) /**< \brief (TWI_IER) End Of Slave Access Interrupt Enable */
#define TWI_IER_ENDRX (0x1 << 12) /**< \brief (TWI_IER) End of Receive Buffer Interrupt Enable */
#define TWI_IER_ENDTX (0x1 << 13) /**< \brief (TWI_IER) End of Transmit Buffer Interrupt Enable */
#define TWI_IER_RXBUFF (0x1 << 14) /**< \brief (TWI_IER) Receive Buffer Full Interrupt Enable */
#define TWI_IER_TXBUFE (0x1 << 15) /**< \brief (TWI_IER) Transmit Buffer Empty Interrupt Enable */
/* -------- TWI_IDR : (TWI Offset: 0x28) Interrupt Disable Register -------- */
#define TWI_IDR_TXCOMP (0x1 << 0) /**< \brief (TWI_IDR) Transmission Completed Interrupt Disable */
#define TWI_IDR_RXRDY (0x1 << 1) /**< \brief (TWI_IDR) Receive Holding Register Ready Interrupt Disable */
#define TWI_IDR_TXRDY (0x1 << 2) /**< \brief (TWI_IDR) Transmit Holding Register Ready Interrupt Disable */
#define TWI_IDR_SVACC (0x1 << 4) /**< \brief (TWI_IDR) Slave Access Interrupt Disable */
#define TWI_IDR_GACC (0x1 << 5) /**< \brief (TWI_IDR) General Call Access Interrupt Disable */
#define TWI_IDR_OVRE (0x1 << 6) /**< \brief (TWI_IDR) Overrun Error Interrupt Disable */
#define TWI_IDR_NACK (0x1 << 8) /**< \brief (TWI_IDR) Not Acknowledge Interrupt Disable */
#define TWI_IDR_ARBLST (0x1 << 9) /**< \brief (TWI_IDR) Arbitration Lost Interrupt Disable */
#define TWI_IDR_SCL_WS (0x1 << 10) /**< \brief (TWI_IDR) Clock Wait State Interrupt Disable */
#define TWI_IDR_EOSACC (0x1 << 11) /**< \brief (TWI_IDR) End Of Slave Access Interrupt Disable */
#define TWI_IDR_ENDRX (0x1 << 12) /**< \brief (TWI_IDR) End of Receive Buffer Interrupt Disable */
#define TWI_IDR_ENDTX (0x1 << 13) /**< \brief (TWI_IDR) End of Transmit Buffer Interrupt Disable */
#define TWI_IDR_RXBUFF (0x1 << 14) /**< \brief (TWI_IDR) Receive Buffer Full Interrupt Disable */
#define TWI_IDR_TXBUFE (0x1 << 15) /**< \brief (TWI_IDR) Transmit Buffer Empty Interrupt Disable */
/* -------- TWI_IMR : (TWI Offset: 0x2C) Interrupt Mask Register -------- */
#define TWI_IMR_TXCOMP (0x1 << 0) /**< \brief (TWI_IMR) Transmission Completed Interrupt Mask */
#define TWI_IMR_RXRDY (0x1 << 1) /**< \brief (TWI_IMR) Receive Holding Register Ready Interrupt Mask */
#define TWI_IMR_TXRDY (0x1 << 2) /**< \brief (TWI_IMR) Transmit Holding Register Ready Interrupt Mask */
#define TWI_IMR_SVACC (0x1 << 4) /**< \brief (TWI_IMR) Slave Access Interrupt Mask */
#define TWI_IMR_GACC (0x1 << 5) /**< \brief (TWI_IMR) General Call Access Interrupt Mask */
#define TWI_IMR_OVRE (0x1 << 6) /**< \brief (TWI_IMR) Overrun Error Interrupt Mask */
#define TWI_IMR_NACK (0x1 << 8) /**< \brief (TWI_IMR) Not Acknowledge Interrupt Mask */
#define TWI_IMR_ARBLST (0x1 << 9) /**< \brief (TWI_IMR) Arbitration Lost Interrupt Mask */
#define TWI_IMR_SCL_WS (0x1 << 10) /**< \brief (TWI_IMR) Clock Wait State Interrupt Mask */
#define TWI_IMR_EOSACC (0x1 << 11) /**< \brief (TWI_IMR) End Of Slave Access Interrupt Mask */
#define TWI_IMR_ENDRX (0x1 << 12) /**< \brief (TWI_IMR) End of Receive Buffer Interrupt Mask */
#define TWI_IMR_ENDTX (0x1 << 13) /**< \brief (TWI_IMR) End of Transmit Buffer Interrupt Mask */
#define TWI_IMR_RXBUFF (0x1 << 14) /**< \brief (TWI_IMR) Receive Buffer Full Interrupt Mask */
#define TWI_IMR_TXBUFE (0x1 << 15) /**< \brief (TWI_IMR) Transmit Buffer Empty Interrupt Mask */
/* -------- TWI_RHR : (TWI Offset: 0x30) Receive Holding Register -------- */
#define TWI_RHR_RXDATA (0xff << 0) /**< \brief (TWI_RHR) Master or Slave Receive Holding Data */
/* -------- TWI_THR : (TWI Offset: 0x34) Transmit Holding Register -------- */
#define TWI_THR_TXDATA (0xff << 0) /**< \brief (TWI_THR) Master or Slave Transmit Holding Data */
/* -------- TWI_RPR : (TWI Offset: 0x100) Receive Pointer Register -------- */
#define TWI_RPR_RXPTR (0xffffffff << 0) /**< \brief (TWI_RPR) Receive Pointer Register */
/* -------- TWI_RCR : (TWI Offset: 0x104) Receive Counter Register -------- */
#define TWI_RCR_RXCTR (0xffff << 0) /**< \brief (TWI_RCR) Receive Counter Register */
/* -------- TWI_TPR : (TWI Offset: 0x108) Transmit Pointer Register -------- */
#define TWI_TPR_TXPTR (0xffffffff << 0) /**< \brief (TWI_TPR) Transmit Counter Register */
/* -------- TWI_TCR : (TWI Offset: 0x10C) Transmit Counter Register -------- */
#define TWI_TCR_TXCTR (0xffff << 0) /**< \brief (TWI_TCR) Transmit Counter Register */
/* -------- TWI_RNPR : (TWI Offset: 0x110) Receive Next Pointer Register -------- */
#define TWI_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (TWI_RNPR) Receive Next Pointer */
/* -------- TWI_RNCR : (TWI Offset: 0x114) Receive Next Counter Register -------- */
#define TWI_RNCR_RXNCTR (0xffff << 0) /**< \brief (TWI_RNCR) Receive Next Counter */
/* -------- TWI_TNPR : (TWI Offset: 0x118) Transmit Next Pointer Register -------- */
#define TWI_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (TWI_TNPR) Transmit Next Pointer */
/* -------- TWI_TNCR : (TWI Offset: 0x11C) Transmit Next Counter Register -------- */
#define TWI_TNCR_TXNCTR (0xffff << 0) /**< \brief (TWI_TNCR) Transmit Counter Next */
/* -------- TWI_PTCR : (TWI Offset: 0x120) Transfer Control Register -------- */
#define TWI_PTCR_RXTEN (0x1 << 0) /**< \brief (TWI_PTCR) Receiver Transfer Enable */
#define TWI_PTCR_RXTDIS (0x1 << 1) /**< \brief (TWI_PTCR) Receiver Transfer Disable */
#define TWI_PTCR_TXTEN (0x1 << 8) /**< \brief (TWI_PTCR) Transmitter Transfer Enable */
#define TWI_PTCR_TXTDIS (0x1 << 9) /**< \brief (TWI_PTCR) Transmitter Transfer Disable */
/* -------- TWI_PTSR : (TWI Offset: 0x124) Transfer Status Register -------- */
#define TWI_PTSR_RXTEN (0x1 << 0) /**< \brief (TWI_PTSR) Receiver Transfer Enable */
#define TWI_PTSR_TXTEN (0x1 << 8) /**< \brief (TWI_PTSR) Transmitter Transfer Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Universal Asynchronous Receiver Transmitter */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_UART Universal Asynchronous Receiver Transmitter */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Uart hardware registers */
typedef struct {
  WoReg UART_CR;       /**< \brief (Uart Offset: 0x0000) Control Register */
  RwReg UART_MR;       /**< \brief (Uart Offset: 0x0004) Mode Register */
  WoReg UART_IER;      /**< \brief (Uart Offset: 0x0008) Interrupt Enable Register */
  WoReg UART_IDR;      /**< \brief (Uart Offset: 0x000C) Interrupt Disable Register */
  RoReg UART_IMR;      /**< \brief (Uart Offset: 0x0010) Interrupt Mask Register */
  RoReg UART_SR;       /**< \brief (Uart Offset: 0x0014) Status Register */
  RoReg UART_RHR;      /**< \brief (Uart Offset: 0x0018) Receive Holding Register */
  WoReg UART_THR;      /**< \brief (Uart Offset: 0x001C) Transmit Holding Register */
  RwReg UART_BRGR;     /**< \brief (Uart Offset: 0x0020) Baud Rate Generator Register */
  RwReg Reserved1[55];
  RwReg UART_RPR;      /**< \brief (Uart Offset: 0x100) Receive Pointer Register */
  RwReg UART_RCR;      /**< \brief (Uart Offset: 0x104) Receive Counter Register */
  RwReg UART_TPR;      /**< \brief (Uart Offset: 0x108) Transmit Pointer Register */
  RwReg UART_TCR;      /**< \brief (Uart Offset: 0x10C) Transmit Counter Register */
  RwReg UART_RNPR;     /**< \brief (Uart Offset: 0x110) Receive Next Pointer Register */
  RwReg UART_RNCR;     /**< \brief (Uart Offset: 0x114) Receive Next Counter Register */
  RwReg UART_TNPR;     /**< \brief (Uart Offset: 0x118) Transmit Next Pointer Register */
  RwReg UART_TNCR;     /**< \brief (Uart Offset: 0x11C) Transmit Next Counter Register */
  WoReg UART_PTCR;     /**< \brief (Uart Offset: 0x120) Transfer Control Register */
  RoReg UART_PTSR;     /**< \brief (Uart Offset: 0x124) Transfer Status Register */
} Uart;
#endif /* __ASSEMBLY__ */
/* -------- UART_CR : (UART Offset: 0x0000) Control Register -------- */
#define UART_CR_RSTRX (0x1 << 2) /**< \brief (UART_CR) Reset Receiver */
#define UART_CR_RSTTX (0x1 << 3) /**< \brief (UART_CR) Reset Transmitter */
#define UART_CR_RXEN (0x1 << 4) /**< \brief (UART_CR) Receiver Enable */
#define UART_CR_RXDIS (0x1 << 5) /**< \brief (UART_CR) Receiver Disable */
#define UART_CR_TXEN (0x1 << 6) /**< \brief (UART_CR) Transmitter Enable */
#define UART_CR_TXDIS (0x1 << 7) /**< \brief (UART_CR) Transmitter Disable */
#define UART_CR_RSTSTA (0x1 << 8) /**< \brief (UART_CR) Reset Status Bits */
/* -------- UART_MR : (UART Offset: 0x0004) Mode Register -------- */
#define UART_MR_PAR (0x7 << 9) /**< \brief (UART_MR) Parity Type */
#define UART_MR_CHMODE (0x3 << 14) /**< \brief (UART_MR) Channel Mode */
/* -------- UART_IER : (UART Offset: 0x0008) Interrupt Enable Register -------- */
#define UART_IER_RXRDY (0x1 << 0) /**< \brief (UART_IER) Enable RXRDY Interrupt */
#define UART_IER_TXRDY (0x1 << 1) /**< \brief (UART_IER) Enable TXRDY Interrupt */
#define UART_IER_ENDRX (0x1 << 3) /**< \brief (UART_IER) Enable End of Receive Transfer Interrupt */
#define UART_IER_ENDTX (0x1 << 4) /**< \brief (UART_IER) Enable End of Transmit Interrupt */
#define UART_IER_OVRE (0x1 << 5) /**< \brief (UART_IER) Enable Overrun Error Interrupt */
#define UART_IER_FRAME (0x1 << 6) /**< \brief (UART_IER) Enable Framing Error Interrupt */
#define UART_IER_PARE (0x1 << 7) /**< \brief (UART_IER) Enable Parity Error Interrupt */
#define UART_IER_TXEMPTY (0x1 << 9) /**< \brief (UART_IER) Enable TXEMPTY Interrupt */
#define UART_IER_TXBUFE (0x1 << 11) /**< \brief (UART_IER) Enable Buffer Empty Interrupt */
#define UART_IER_RXBUFF (0x1 << 12) /**< \brief (UART_IER) Enable Buffer Full Interrupt */
/* -------- UART_IDR : (UART Offset: 0x000C) Interrupt Disable Register -------- */
#define UART_IDR_RXRDY (0x1 << 0) /**< \brief (UART_IDR) Disable RXRDY Interrupt */
#define UART_IDR_TXRDY (0x1 << 1) /**< \brief (UART_IDR) Disable TXRDY Interrupt */
#define UART_IDR_ENDRX (0x1 << 3) /**< \brief (UART_IDR) Disable End of Receive Transfer Interrupt */
#define UART_IDR_ENDTX (0x1 << 4) /**< \brief (UART_IDR) Disable End of Transmit Interrupt */
#define UART_IDR_OVRE (0x1 << 5) /**< \brief (UART_IDR) Disable Overrun Error Interrupt */
#define UART_IDR_FRAME (0x1 << 6) /**< \brief (UART_IDR) Disable Framing Error Interrupt */
#define UART_IDR_PARE (0x1 << 7) /**< \brief (UART_IDR) Disable Parity Error Interrupt */
#define UART_IDR_TXEMPTY (0x1 << 9) /**< \brief (UART_IDR) Disable TXEMPTY Interrupt */
#define UART_IDR_TXBUFE (0x1 << 11) /**< \brief (UART_IDR) Disable Buffer Empty Interrupt */
#define UART_IDR_RXBUFF (0x1 << 12) /**< \brief (UART_IDR) Disable Buffer Full Interrupt */
/* -------- UART_IMR : (UART Offset: 0x0010) Interrupt Mask Register -------- */
#define UART_IMR_RXRDY (0x1 << 0) /**< \brief (UART_IMR) Mask RXRDY Interrupt */
#define UART_IMR_TXRDY (0x1 << 1) /**< \brief (UART_IMR) Disable TXRDY Interrupt */
#define UART_IMR_ENDRX (0x1 << 3) /**< \brief (UART_IMR) Mask End of Receive Transfer Interrupt */
#define UART_IMR_ENDTX (0x1 << 4) /**< \brief (UART_IMR) Mask End of Transmit Interrupt */
#define UART_IMR_OVRE (0x1 << 5) /**< \brief (UART_IMR) Mask Overrun Error Interrupt */
#define UART_IMR_FRAME (0x1 << 6) /**< \brief (UART_IMR) Mask Framing Error Interrupt */
#define UART_IMR_PARE (0x1 << 7) /**< \brief (UART_IMR) Mask Parity Error Interrupt */
#define UART_IMR_TXEMPTY (0x1 << 9) /**< \brief (UART_IMR) Mask TXEMPTY Interrupt */
#define UART_IMR_TXBUFE (0x1 << 11) /**< \brief (UART_IMR) Mask TXBUFE Interrupt */
#define UART_IMR_RXBUFF (0x1 << 12) /**< \brief (UART_IMR) Mask RXBUFF Interrupt */
/* -------- UART_SR : (UART Offset: 0x0014) Status Register -------- */
#define UART_SR_RXRDY (0x1 << 0) /**< \brief (UART_SR) Receiver Ready */
#define UART_SR_TXRDY (0x1 << 1) /**< \brief (UART_SR) Transmitter Ready */
#define UART_SR_ENDRX (0x1 << 3) /**< \brief (UART_SR) End of Receiver Transfer */
#define UART_SR_ENDTX (0x1 << 4) /**< \brief (UART_SR) End of Transmitter Transfer */
#define UART_SR_OVRE (0x1 << 5) /**< \brief (UART_SR) Overrun Error */
#define UART_SR_FRAME (0x1 << 6) /**< \brief (UART_SR) Framing Error */
#define UART_SR_PARE (0x1 << 7) /**< \brief (UART_SR) Parity Error */
#define UART_SR_TXEMPTY (0x1 << 9) /**< \brief (UART_SR) Transmitter Empty */
#define UART_SR_TXBUFE (0x1 << 11) /**< \brief (UART_SR) Transmission Buffer Empty */
#define UART_SR_RXBUFF (0x1 << 12) /**< \brief (UART_SR) Receive Buffer Full */
/* -------- UART_RHR : (UART Offset: 0x0018) Receive Holding Register -------- */
#define UART_RHR_RXCHR (0xff << 0) /**< \brief (UART_RHR) Received Character */
/* -------- UART_THR : (UART Offset: 0x001C) Transmit Holding Register -------- */
#define UART_THR_TXCHR (0xff << 0) /**< \brief (UART_THR) Character to be Transmitted */
/* -------- UART_BRGR : (UART Offset: 0x0020) Baud Rate Generator Register -------- */
#define UART_BRGR_CD (0xffff << 0) /**< \brief (UART_BRGR) Clock Divisor */
/* -------- UART_RPR : (UART Offset: 0x100) Receive Pointer Register -------- */
#define UART_RPR_RXPTR (0xffffffff << 0) /**< \brief (UART_RPR) Receive Pointer Register */
/* -------- UART_RCR : (UART Offset: 0x104) Receive Counter Register -------- */
#define UART_RCR_RXCTR (0xffff << 0) /**< \brief (UART_RCR) Receive Counter Register */
/* -------- UART_TPR : (UART Offset: 0x108) Transmit Pointer Register -------- */
#define UART_TPR_TXPTR (0xffffffff << 0) /**< \brief (UART_TPR) Transmit Counter Register */
/* -------- UART_TCR : (UART Offset: 0x10C) Transmit Counter Register -------- */
#define UART_TCR_TXCTR (0xffff << 0) /**< \brief (UART_TCR) Transmit Counter Register */
/* -------- UART_RNPR : (UART Offset: 0x110) Receive Next Pointer Register -------- */
#define UART_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (UART_RNPR) Receive Next Pointer */
/* -------- UART_RNCR : (UART Offset: 0x114) Receive Next Counter Register -------- */
#define UART_RNCR_RXNCTR (0xffff << 0) /**< \brief (UART_RNCR) Receive Next Counter */
/* -------- UART_TNPR : (UART Offset: 0x118) Transmit Next Pointer Register -------- */
#define UART_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (UART_TNPR) Transmit Next Pointer */
/* -------- UART_TNCR : (UART Offset: 0x11C) Transmit Next Counter Register -------- */
#define UART_TNCR_TXNCTR (0xffff << 0) /**< \brief (UART_TNCR) Transmit Counter Next */
/* -------- UART_PTCR : (UART Offset: 0x120) Transfer Control Register -------- */
#define UART_PTCR_RXTEN (0x1 << 0) /**< \brief (UART_PTCR) Receiver Transfer Enable */
#define UART_PTCR_RXTDIS (0x1 << 1) /**< \brief (UART_PTCR) Receiver Transfer Disable */
#define UART_PTCR_TXTEN (0x1 << 8) /**< \brief (UART_PTCR) Transmitter Transfer Enable */
#define UART_PTCR_TXTDIS (0x1 << 9) /**< \brief (UART_PTCR) Transmitter Transfer Disable */
/* -------- UART_PTSR : (UART Offset: 0x124) Transfer Status Register -------- */
#define UART_PTSR_RXTEN (0x1 << 0) /**< \brief (UART_PTSR) Receiver Transfer Enable */
#define UART_PTSR_TXTEN (0x1 << 8) /**< \brief (UART_PTSR) Transmitter Transfer Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR USB High Speed Device Port */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_UDPHS USB High Speed Device Port */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief UdphsDma hardware registers */
typedef struct {
  RwReg     UDPHS_DMANXTDSC;  /**< \brief (UdphsDma Offset: 0x0) UDPHS DMA Next Descriptor Address Register */
  RwReg     UDPHS_DMAADDRESS; /**< \brief (UdphsDma Offset: 0x4) UDPHS DMA Channel Address Register */
  RwReg     UDPHS_DMACONTROL; /**< \brief (UdphsDma Offset: 0x8) UDPHS DMA Channel Control Register */
  RwReg     UDPHS_DMASTATUS;  /**< \brief (UdphsDma Offset: 0xC) UDPHS DMA Channel Status Register */
} UdphsDma;
/** \brief UdphsEpt hardware registers */
typedef struct {
  RwReg     UDPHS_EPTCFG;     /**< \brief (UdphsEpt Offset: 0x0) UDPHS Endpoint Configuration Register */
  RwReg     UDPHS_EPTCTLENB;  /**< \brief (UdphsEpt Offset: 0x4) UDPHS Endpoint Control Enable Register */
  RwReg     UDPHS_EPTCTLDIS;  /**< \brief (UdphsEpt Offset: 0x8) UDPHS Endpoint Control Disable Register */
  RwReg     UDPHS_EPTCTL;     /**< \brief (UdphsEpt Offset: 0xC) UDPHS Endpoint Control Register */
  RwReg     Reserved1[1];    
  RwReg     UDPHS_EPTSETSTA;  /**< \brief (UdphsEpt Offset: 0x14) UDPHS Endpoint Set Status Register */
  RwReg     UDPHS_EPTCLRSTA;  /**< \brief (UdphsEpt Offset: 0x18) UDPHS Endpoint Clear Status Register */
  RwReg     UDPHS_EPTSTA;     /**< \brief (UdphsEpt Offset: 0x1C) UDPHS Endpoint Status Register */
} UdphsEpt;
/** \brief Udphs hardware registers */
typedef struct {
  RwReg     UDPHS_CTRL;       /**< \brief (Udphs Offset: 0x00) UDPHS Control Register */
  RoReg     UDPHS_FNUM;       /**< \brief (Udphs Offset: 0x04) UDPHS Frame Number Register */
  RwReg     Reserved1[2];    
  RwReg     UDPHS_IEN;        /**< \brief (Udphs Offset: 0x10) UDPHS Interrupt Enable Register */
  RoReg     UDPHS_INTSTA;     /**< \brief (Udphs Offset: 0x14) UDPHS Interrupt Status Register */
  WoReg     UDPHS_CLRINT;     /**< \brief (Udphs Offset: 0x18) UDPHS Clear Interrupt Register */
  WoReg     UDPHS_EPTRST;     /**< \brief (Udphs Offset: 0x1C) UDPHS Endpoints Reset Register */
  RwReg     Reserved2[48];   
  RwReg     UDPHS_TST;        /**< \brief (Udphs Offset: 0xE0) UDPHS Test Register */
  RwReg     Reserved3[3];    
  RoReg     UDPHS_IPNAME1;    /**< \brief (Udphs Offset: 0xF0) UDPHS Name1 Register */
  RoReg     UDPHS_IPNAME2;    /**< \brief (Udphs Offset: 0xF4) UDPHS Name2 Register */
  RoReg     UDPHS_IPFEATURES; /**< \brief (Udphs Offset: 0xF8) UDPHS Features Register */
  RwReg     Reserved4[1];    
  UdphsEpt  UDPHS_EPT[7];     /**< \brief (Udphs Offset: 0x100) endpoint = 0 .. 6 */
  RwReg     Reserved5[80];   
  UdphsDma  UDPHS_DMA[5];     /**< \brief (Udphs Offset: 0x320) channel = 1 .. 5 */
} Udphs;
#endif /* __ASSEMBLY__ */
/* -------- UDPHS_CTRL : (UDPHS Offset: 0x00) UDPHS Control Register -------- */
#define UDPHS_CTRL_DEV_ADDR (0x7f << 0) /**< \brief (UDPHS_CTRL) UDPHS Address */
#define UDPHS_CTRL_FADDR_EN (0x1 << 7) /**< \brief (UDPHS_CTRL) Function Address Enable */
#define UDPHS_CTRL_EN_UDPHS (0x1 << 8) /**< \brief (UDPHS_CTRL) UDPHS Enable */
#define UDPHS_CTRL_DETACH (0x1 << 9) /**< \brief (UDPHS_CTRL) Detach Command */
#define UDPHS_CTRL_REWAKEUP (0x1 << 10) /**< \brief (UDPHS_CTRL) Send Remote Wake Up */
#define UDPHS_CTRL_PULLD_DIS (0x1 << 11) /**< \brief (UDPHS_CTRL) Pull-Down Disable */
/* -------- UDPHS_FNUM : (UDPHS Offset: 0x04) UDPHS Frame Number Register -------- */
#define UDPHS_FNUM_MICRO_FRAME_NUM (0x7 << 0) /**< \brief (UDPHS_FNUM) Microframe Number */
#define UDPHS_FNUM_FRAME_NUMBER (0x7ff << 3) /**< \brief (UDPHS_FNUM) Frame Number as defined in the Packet Field Formats */
#define UDPHS_FNUM_FNUM_ERR (0x1 << 31) /**< \brief (UDPHS_FNUM) Frame Number CRC Error */
/* -------- UDPHS_IEN : (UDPHS Offset: 0x10) UDPHS Interrupt Enable Register -------- */
#define UDPHS_IEN_DET_SUSPD (0x1 << 1) /**< \brief (UDPHS_IEN) Suspend Interrupt Enable */
#define UDPHS_IEN_MICRO_SOF (0x1 << 2) /**< \brief (UDPHS_IEN) Micro-SOF Interrupt Enable */
#define UDPHS_IEN_INT_SOF (0x1 << 3) /**< \brief (UDPHS_IEN) SOF Interrupt Enable */
#define UDPHS_IEN_ENDRESET (0x1 << 4) /**< \brief (UDPHS_IEN) End Of Reset Interrupt Enable */
#define UDPHS_IEN_WAKE_UP (0x1 << 5) /**< \brief (UDPHS_IEN) Wake Up CPU Interrupt Enable */
#define UDPHS_IEN_ENDOFRSM (0x1 << 6) /**< \brief (UDPHS_IEN) End Of Resume Interrupt Enable */
#define UDPHS_IEN_UPSTR_RES (0x1 << 7) /**< \brief (UDPHS_IEN) Upstream Resume Interrupt Enable */
#define UDPHS_IEN_EPT_0 (0x1 << 8) /**< \brief (UDPHS_IEN) Endpoint 0 Interrupt Enable */
#define UDPHS_IEN_EPT_1 (0x1 << 9) /**< \brief (UDPHS_IEN) Endpoint 1 Interrupt Enable */
#define UDPHS_IEN_EPT_2 (0x1 << 10) /**< \brief (UDPHS_IEN) Endpoint 2 Interrupt Enable */
#define UDPHS_IEN_EPT_3 (0x1 << 11) /**< \brief (UDPHS_IEN) Endpoint 3 Interrupt Enable */
#define UDPHS_IEN_EPT_4 (0x1 << 12) /**< \brief (UDPHS_IEN) Endpoint 4 Interrupt Enable */
#define UDPHS_IEN_EPT_5 (0x1 << 13) /**< \brief (UDPHS_IEN) Endpoint 5 Interrupt Enable */
#define UDPHS_IEN_EPT_6 (0x1 << 14) /**< \brief (UDPHS_IEN) Endpoint 6 Interrupt Enable */
#define UDPHS_IEN_DMA_1 (0x1 << 25) /**< \brief (UDPHS_IEN) DMA Channel 1 Interrupt Enable */
#define UDPHS_IEN_DMA_2 (0x1 << 26) /**< \brief (UDPHS_IEN) DMA Channel 2 Interrupt Enable */
#define UDPHS_IEN_DMA_3 (0x1 << 27) /**< \brief (UDPHS_IEN) DMA Channel 3 Interrupt Enable */
#define UDPHS_IEN_DMA_4 (0x1 << 28) /**< \brief (UDPHS_IEN) DMA Channel 4 Interrupt Enable */
#define UDPHS_IEN_DMA_5 (0x1 << 29) /**< \brief (UDPHS_IEN) DMA Channel 5 Interrupt Enable */
#define UDPHS_IEN_DMA_6 (0x1 << 30) /**< \brief (UDPHS_IEN) DMA Channel 6 Interrupt Enable */
/* -------- UDPHS_INTSTA : (UDPHS Offset: 0x14) UDPHS Interrupt Status Register -------- */
#define UDPHS_INTSTA_SPEED (0x1 << 0) /**< \brief (UDPHS_INTSTA) Speed Status */
#define UDPHS_INTSTA_DET_SUSPD (0x1 << 1) /**< \brief (UDPHS_INTSTA) Suspend Interrupt */
#define UDPHS_INTSTA_MICRO_SOF (0x1 << 2) /**< \brief (UDPHS_INTSTA) Micro Start Of Frame Interrupt */
#define UDPHS_INTSTA_INT_SOF (0x1 << 3) /**< \brief (UDPHS_INTSTA) Start Of Frame Interrupt */
#define UDPHS_INTSTA_ENDRESET (0x1 << 4) /**< \brief (UDPHS_INTSTA) End Of Reset Interrupt */
#define UDPHS_INTSTA_WAKE_UP (0x1 << 5) /**< \brief (UDPHS_INTSTA) Wake Up CPU Interrupt */
#define UDPHS_INTSTA_ENDOFRSM (0x1 << 6) /**< \brief (UDPHS_INTSTA) End Of Resume Interrupt */
#define UDPHS_INTSTA_UPSTR_RES (0x1 << 7) /**< \brief (UDPHS_INTSTA) Upstream Resume Interrupt */
#define UDPHS_INTSTA_EPT_0 (0x1 << 8) /**< \brief (UDPHS_INTSTA) Endpoint 0 Interrupt */
#define UDPHS_INTSTA_EPT_1 (0x1 << 9) /**< \brief (UDPHS_INTSTA) Endpoint 1 Interrupt */
#define UDPHS_INTSTA_EPT_2 (0x1 << 10) /**< \brief (UDPHS_INTSTA) Endpoint 2 Interrupt */
#define UDPHS_INTSTA_EPT_3 (0x1 << 11) /**< \brief (UDPHS_INTSTA) Endpoint 3 Interrupt */
#define UDPHS_INTSTA_EPT_4 (0x1 << 12) /**< \brief (UDPHS_INTSTA) Endpoint 4 Interrupt */
#define UDPHS_INTSTA_EPT_5 (0x1 << 13) /**< \brief (UDPHS_INTSTA) Endpoint 5 Interrupt */
#define UDPHS_INTSTA_EPT_6 (0x1 << 14) /**< \brief (UDPHS_INTSTA) Endpoint 6 Interrupt */
#define UDPHS_INTSTA_DMA_1 (0x1 << 25) /**< \brief (UDPHS_INTSTA) DMA Channel 1 Interrupt */
#define UDPHS_INTSTA_DMA_2 (0x1 << 26) /**< \brief (UDPHS_INTSTA) DMA Channel 2 Interrupt */
#define UDPHS_INTSTA_DMA_3 (0x1 << 27) /**< \brief (UDPHS_INTSTA) DMA Channel 3 Interrupt */
#define UDPHS_INTSTA_DMA_4 (0x1 << 28) /**< \brief (UDPHS_INTSTA) DMA Channel 4 Interrupt */
#define UDPHS_INTSTA_DMA_5 (0x1 << 29) /**< \brief (UDPHS_INTSTA) DMA Channel 5 Interrupt */
#define UDPHS_INTSTA_DMA_6 (0x1 << 30) /**< \brief (UDPHS_INTSTA) DMA Channel 6 Interrupt */
/* -------- UDPHS_CLRINT : (UDPHS Offset: 0x18) UDPHS Clear Interrupt Register -------- */
#define UDPHS_CLRINT_DET_SUSPD (0x1 << 1) /**< \brief (UDPHS_CLRINT) Suspend Interrupt Clear */
#define UDPHS_CLRINT_MICRO_SOF (0x1 << 2) /**< \brief (UDPHS_CLRINT) Micro Start Of Frame Interrupt Clear */
#define UDPHS_CLRINT_INT_SOF (0x1 << 3) /**< \brief (UDPHS_CLRINT) Start Of Frame Interrupt Clear */
#define UDPHS_CLRINT_ENDRESET (0x1 << 4) /**< \brief (UDPHS_CLRINT) End Of Reset Interrupt Clear */
#define UDPHS_CLRINT_WAKE_UP (0x1 << 5) /**< \brief (UDPHS_CLRINT) Wake Up CPU Interrupt Clear */
#define UDPHS_CLRINT_ENDOFRSM (0x1 << 6) /**< \brief (UDPHS_CLRINT) End Of Resume Interrupt Clear */
#define UDPHS_CLRINT_UPSTR_RES (0x1 << 7) /**< \brief (UDPHS_CLRINT) Upstream Resume Interrupt Clear */
/* -------- UDPHS_EPTRST : (UDPHS Offset: 0x1C) UDPHS Endpoints Reset Register -------- */
#define UDPHS_EPTRST_EPT_0 (0x1 << 0) /**< \brief (UDPHS_EPTRST) Endpoint 0 Reset */
#define UDPHS_EPTRST_EPT_1 (0x1 << 1) /**< \brief (UDPHS_EPTRST) Endpoint 1 Reset */
#define UDPHS_EPTRST_EPT_2 (0x1 << 2) /**< \brief (UDPHS_EPTRST) Endpoint 2 Reset */
#define UDPHS_EPTRST_EPT_3 (0x1 << 3) /**< \brief (UDPHS_EPTRST) Endpoint 3 Reset */
#define UDPHS_EPTRST_EPT_4 (0x1 << 4) /**< \brief (UDPHS_EPTRST) Endpoint 4 Reset */
#define UDPHS_EPTRST_EPT_5 (0x1 << 5) /**< \brief (UDPHS_EPTRST) Endpoint 5 Reset */
#define UDPHS_EPTRST_EPT_6 (0x1 << 6) /**< \brief (UDPHS_EPTRST) Endpoint 6 Reset */
/* -------- UDPHS_TST : (UDPHS Offset: 0xE0) UDPHS Test Register -------- */
#define UDPHS_TST_SPEED_CFG (0x3 << 0) /**< \brief (UDPHS_TST) Speed Configuration */
#define UDPHS_TST_TST_J (0x1 << 2) /**< \brief (UDPHS_TST) Test J Mode */
#define UDPHS_TST_TST_K (0x1 << 3) /**< \brief (UDPHS_TST) Test K Mode */
#define UDPHS_TST_TST_PKT (0x1 << 4) /**< \brief (UDPHS_TST) Test Packet Mode */
#define UDPHS_TST_OPMODE2 (0x1 << 5) /**< \brief (UDPHS_TST) OpMode2 */
/* -------- UDPHS_IPNAME1 : (UDPHS Offset: 0xF0) UDPHS Name1 Register -------- */
#define UDPHS_IPNAME1_IP_NAME1 (0xffffffff << 0) /**< \brief (UDPHS_IPNAME1)  */
/* -------- UDPHS_IPNAME2 : (UDPHS Offset: 0xF4) UDPHS Name2 Register -------- */
#define UDPHS_IPNAME2_IP_NAME2 (0xffffffff << 0) /**< \brief (UDPHS_IPNAME2)  */
/* -------- UDPHS_IPFEATURES : (UDPHS Offset: 0xF8) UDPHS Features Register -------- */
#define UDPHS_IPFEATURES_EPT_NBR_MAX (0xf << 0) /**< \brief (UDPHS_IPFEATURES) Max Number of Endpoints */
#define UDPHS_IPFEATURES_DMA_CHANNEL_NBR (0x7 << 4) /**< \brief (UDPHS_IPFEATURES) Number of DMA Channels */
#define UDPHS_IPFEATURES_DMA_B_SIZ (0x1 << 7) /**< \brief (UDPHS_IPFEATURES) DMA Buffer Size */
#define UDPHS_IPFEATURES_DMA_FIFO_WORD_DEPTH (0xf << 8) /**< \brief (UDPHS_IPFEATURES) DMA FIFO Depth in Words */
#define UDPHS_IPFEATURES_FIFO_MAX_SIZE (0x7 << 12) /**< \brief (UDPHS_IPFEATURES) DPRAM Size */
#define UDPHS_IPFEATURES_BW_DPRAM (0x1 << 15) /**< \brief (UDPHS_IPFEATURES) DPRAM Byte Write Capability */
#define UDPHS_IPFEATURES_DATAB16_8 (0x1 << 16) /**< \brief (UDPHS_IPFEATURES) UTMI DataBus16_8 */
#define UDPHS_IPFEATURES_ISO_EPT_1 (0x1 << 17) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_2 (0x1 << 18) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_3 (0x1 << 19) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_4 (0x1 << 20) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_5 (0x1 << 21) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_6 (0x1 << 22) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_7 (0x1 << 23) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_8 (0x1 << 24) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_9 (0x1 << 25) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_10 (0x1 << 26) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_11 (0x1 << 27) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_12 (0x1 << 28) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_13 (0x1 << 29) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_14 (0x1 << 30) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
#define UDPHS_IPFEATURES_ISO_EPT_15 (0x1 << 31) /**< \brief (UDPHS_IPFEATURES) Endpointx High Bandwidth Isochronous Capability */
/* -------- UDPHS_EPTCFG0 : (UDPHS Offset: 0x100) UDPHS Endpoint Configuration Register (endpoint = 0) -------- */
#define UDPHS_EPTCFG0_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG0) Endpoint Size */
#define   UDPHS_EPTCFG0_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG0) 8 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG0) 16 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG0) 32 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG0) 64 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG0) 128 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG0) 256 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG0) 512 bytes */
#define   UDPHS_EPTCFG0_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG0) 1024 bytes */
#define UDPHS_EPTCFG0_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG0) Endpoint Direction */
#define   UDPHS_EPTCFG0_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG0) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG0_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG0) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG0_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG0) Endpoint Type */
#define   UDPHS_EPTCFG0_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG0) Control endpoint */
#define   UDPHS_EPTCFG0_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG0) Isochronous endpoint */
#define   UDPHS_EPTCFG0_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG0) Bulk endpoint */
#define   UDPHS_EPTCFG0_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG0) Interrupt endpoint */
#define UDPHS_EPTCFG0_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG0) Number of Banks */
#define   UDPHS_EPTCFG0_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG0) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG0_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG0) One bank (bank 0) */
#define   UDPHS_EPTCFG0_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG0) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG0_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG0) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG0_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG0) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG0_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG0) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB0 : (UDPHS Offset: 0x104) UDPHS Endpoint Control Enable Register (endpoint = 0) -------- */
#define UDPHS_EPTCTLENB0_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB0) Endpoint Enable */
#define UDPHS_EPTCTLENB0_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB0) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB0_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB0) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB0_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB0) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB0_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB0) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB0_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB0) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB0_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB0) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB0_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB0) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB0_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB0) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB0_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB0) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB0_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB0) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB0_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB0) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB0_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB0) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB0_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB0) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB0_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB0) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB0_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB0) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS0 : (UDPHS Offset: 0x108) UDPHS Endpoint Control Disable Register (endpoint = 0) -------- */
#define UDPHS_EPTCTLDIS0_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS0) Endpoint Disable */
#define UDPHS_EPTCTLDIS0_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS0) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS0_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS0) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS0_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS0) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS0_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS0) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS0_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS0) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS0_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS0) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS0_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS0) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS0_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS0) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS0_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS0) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS0_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS0) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS0_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS0) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS0_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS0) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS0_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS0) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS0_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS0) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS0_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS0) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL0 : (UDPHS Offset: 0x10C) UDPHS Endpoint Control Register (endpoint = 0) -------- */
#define UDPHS_EPTCTL0_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL0) Endpoint Enable */
#define UDPHS_EPTCTL0_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL0) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL0_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL0) Interrupt Disables DMA */
#define UDPHS_EPTCTL0_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL0) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL0_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL0) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL0_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL0) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL0_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL0) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL0_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL0) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL0_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL0) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL0_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL0) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL0_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL0) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL0_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL0) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL0_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL0) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL0_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL0) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL0_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL0) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL0_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL0) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA0 : (UDPHS Offset: 0x114) UDPHS Endpoint Set Status Register (endpoint = 0) -------- */
#define UDPHS_EPTSETSTA0_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA0) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA0_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA0) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA0_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA0) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA0 : (UDPHS Offset: 0x118) UDPHS Endpoint Clear Status Register (endpoint = 0) -------- */
#define UDPHS_EPTCLRSTA0_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA0) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA0_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA0) Data Toggle Clear */
#define UDPHS_EPTCLRSTA0_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA0) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA0_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA0) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA0_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA0) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA0_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA0) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA0_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA0) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA0_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA0) NAKOUT Clear */
/* -------- UDPHS_EPTSTA0 : (UDPHS Offset: 0x11C) UDPHS Endpoint Status Register (endpoint = 0) -------- */
#define UDPHS_EPTSTA0_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA0) Stall Handshake Request */
#define UDPHS_EPTSTA0_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA0) Toggle Sequencing */
#define UDPHS_EPTSTA0_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA0) Overflow Error */
#define UDPHS_EPTSTA0_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA0) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA0_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA0) Transmitted IN Data Complete */
#define UDPHS_EPTSTA0_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA0) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA0_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA0) Received SETUP/Error Flow */
#define UDPHS_EPTSTA0_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA0) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA0_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA0) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA0_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA0) NAK OUT */
#define UDPHS_EPTSTA0_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA0) Current Bank/Control Direction */
#define UDPHS_EPTSTA0_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA0) Busy Bank Number */
#define UDPHS_EPTSTA0_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA0) UDPHS Byte Count */
#define UDPHS_EPTSTA0_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA0) Short Packet */
/* -------- UDPHS_EPTCFG1 : (UDPHS Offset: 0x120) UDPHS Endpoint Configuration Register (endpoint = 1) -------- */
#define UDPHS_EPTCFG1_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG1) Endpoint Size */
#define   UDPHS_EPTCFG1_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG1) 8 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG1) 16 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG1) 32 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG1) 64 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG1) 128 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG1) 256 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG1) 512 bytes */
#define   UDPHS_EPTCFG1_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG1) 1024 bytes */
#define UDPHS_EPTCFG1_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG1) Endpoint Direction */
#define   UDPHS_EPTCFG1_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG1) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG1_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG1) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG1_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG1) Endpoint Type */
#define   UDPHS_EPTCFG1_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG1) Control endpoint */
#define   UDPHS_EPTCFG1_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG1) Isochronous endpoint */
#define   UDPHS_EPTCFG1_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG1) Bulk endpoint */
#define   UDPHS_EPTCFG1_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG1) Interrupt endpoint */
#define UDPHS_EPTCFG1_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG1) Number of Banks */
#define   UDPHS_EPTCFG1_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG1) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG1_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG1) One bank (bank 0) */
#define   UDPHS_EPTCFG1_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG1) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG1_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG1) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG1_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG1) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG1_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG1) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB1 : (UDPHS Offset: 0x124) UDPHS Endpoint Control Enable Register (endpoint = 1) -------- */
#define UDPHS_EPTCTLENB1_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB1) Endpoint Enable */
#define UDPHS_EPTCTLENB1_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB1) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB1_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB1) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB1_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB1) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB1_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB1) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB1_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB1) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB1_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB1) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB1_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB1) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB1_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB1) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB1_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB1) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB1_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB1) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB1_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB1) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB1_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB1) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB1_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB1) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB1_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB1) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB1_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB1) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS1 : (UDPHS Offset: 0x128) UDPHS Endpoint Control Disable Register (endpoint = 1) -------- */
#define UDPHS_EPTCTLDIS1_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS1) Endpoint Disable */
#define UDPHS_EPTCTLDIS1_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS1) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS1_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS1) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS1_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS1) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS1_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS1) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS1_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS1) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS1_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS1) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS1_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS1) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS1_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS1) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS1_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS1) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS1_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS1) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS1_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS1) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS1_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS1) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS1_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS1) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS1_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS1) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS1_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS1) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL1 : (UDPHS Offset: 0x12C) UDPHS Endpoint Control Register (endpoint = 1) -------- */
#define UDPHS_EPTCTL1_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL1) Endpoint Enable */
#define UDPHS_EPTCTL1_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL1) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL1_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL1) Interrupt Disables DMA */
#define UDPHS_EPTCTL1_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL1) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL1_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL1) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL1_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL1) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL1_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL1) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL1_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL1) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL1_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL1) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL1_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL1) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL1_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL1) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL1_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL1) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL1_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL1) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL1_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL1) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL1_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL1) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL1_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL1) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA1 : (UDPHS Offset: 0x134) UDPHS Endpoint Set Status Register (endpoint = 1) -------- */
#define UDPHS_EPTSETSTA1_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA1) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA1_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA1) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA1_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA1) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA1 : (UDPHS Offset: 0x138) UDPHS Endpoint Clear Status Register (endpoint = 1) -------- */
#define UDPHS_EPTCLRSTA1_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA1) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA1_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA1) Data Toggle Clear */
#define UDPHS_EPTCLRSTA1_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA1) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA1_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA1) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA1_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA1) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA1_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA1) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA1_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA1) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA1_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA1) NAKOUT Clear */
/* -------- UDPHS_EPTSTA1 : (UDPHS Offset: 0x13C) UDPHS Endpoint Status Register (endpoint = 1) -------- */
#define UDPHS_EPTSTA1_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA1) Stall Handshake Request */
#define UDPHS_EPTSTA1_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA1) Toggle Sequencing */
#define UDPHS_EPTSTA1_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA1) Overflow Error */
#define UDPHS_EPTSTA1_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA1) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA1_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA1) Transmitted IN Data Complete */
#define UDPHS_EPTSTA1_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA1) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA1_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA1) Received SETUP/Error Flow */
#define UDPHS_EPTSTA1_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA1) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA1_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA1) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA1_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA1) NAK OUT */
#define UDPHS_EPTSTA1_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA1) Current Bank/Control Direction */
#define UDPHS_EPTSTA1_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA1) Busy Bank Number */
#define UDPHS_EPTSTA1_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA1) UDPHS Byte Count */
#define UDPHS_EPTSTA1_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA1) Short Packet */
/* -------- UDPHS_EPTCFG2 : (UDPHS Offset: 0x140) UDPHS Endpoint Configuration Register (endpoint = 2) -------- */
#define UDPHS_EPTCFG2_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG2) Endpoint Size */
#define   UDPHS_EPTCFG2_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG2) 8 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG2) 16 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG2) 32 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG2) 64 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG2) 128 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG2) 256 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG2) 512 bytes */
#define   UDPHS_EPTCFG2_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG2) 1024 bytes */
#define UDPHS_EPTCFG2_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG2) Endpoint Direction */
#define   UDPHS_EPTCFG2_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG2) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG2_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG2) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG2_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG2) Endpoint Type */
#define   UDPHS_EPTCFG2_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG2) Control endpoint */
#define   UDPHS_EPTCFG2_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG2) Isochronous endpoint */
#define   UDPHS_EPTCFG2_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG2) Bulk endpoint */
#define   UDPHS_EPTCFG2_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG2) Interrupt endpoint */
#define UDPHS_EPTCFG2_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG2) Number of Banks */
#define   UDPHS_EPTCFG2_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG2) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG2_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG2) One bank (bank 0) */
#define   UDPHS_EPTCFG2_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG2) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG2_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG2) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG2_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG2) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG2_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG2) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB2 : (UDPHS Offset: 0x144) UDPHS Endpoint Control Enable Register (endpoint = 2) -------- */
#define UDPHS_EPTCTLENB2_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB2) Endpoint Enable */
#define UDPHS_EPTCTLENB2_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB2) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB2_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB2) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB2_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB2) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB2_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB2) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB2_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB2) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB2_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB2) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB2_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB2) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB2_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB2) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB2_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB2) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB2_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB2) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB2_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB2) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB2_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB2) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB2_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB2) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB2_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB2) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB2_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB2) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS2 : (UDPHS Offset: 0x148) UDPHS Endpoint Control Disable Register (endpoint = 2) -------- */
#define UDPHS_EPTCTLDIS2_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS2) Endpoint Disable */
#define UDPHS_EPTCTLDIS2_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS2) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS2_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS2) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS2_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS2) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS2_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS2) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS2_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS2) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS2_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS2) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS2_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS2) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS2_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS2) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS2_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS2) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS2_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS2) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS2_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS2) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS2_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS2) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS2_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS2) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS2_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS2) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS2_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS2) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL2 : (UDPHS Offset: 0x14C) UDPHS Endpoint Control Register (endpoint = 2) -------- */
#define UDPHS_EPTCTL2_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL2) Endpoint Enable */
#define UDPHS_EPTCTL2_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL2) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL2_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL2) Interrupt Disables DMA */
#define UDPHS_EPTCTL2_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL2) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL2_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL2) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL2_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL2) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL2_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL2) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL2_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL2) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL2_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL2) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL2_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL2) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL2_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL2) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL2_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL2) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL2_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL2) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL2_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL2) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL2_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL2) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL2_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL2) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA2 : (UDPHS Offset: 0x154) UDPHS Endpoint Set Status Register (endpoint = 2) -------- */
#define UDPHS_EPTSETSTA2_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA2) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA2_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA2) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA2_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA2) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA2 : (UDPHS Offset: 0x158) UDPHS Endpoint Clear Status Register (endpoint = 2) -------- */
#define UDPHS_EPTCLRSTA2_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA2) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA2_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA2) Data Toggle Clear */
#define UDPHS_EPTCLRSTA2_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA2) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA2_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA2) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA2_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA2) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA2_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA2) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA2_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA2) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA2_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA2) NAKOUT Clear */
/* -------- UDPHS_EPTSTA2 : (UDPHS Offset: 0x15C) UDPHS Endpoint Status Register (endpoint = 2) -------- */
#define UDPHS_EPTSTA2_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA2) Stall Handshake Request */
#define UDPHS_EPTSTA2_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA2) Toggle Sequencing */
#define UDPHS_EPTSTA2_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA2) Overflow Error */
#define UDPHS_EPTSTA2_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA2) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA2_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA2) Transmitted IN Data Complete */
#define UDPHS_EPTSTA2_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA2) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA2_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA2) Received SETUP/Error Flow */
#define UDPHS_EPTSTA2_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA2) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA2_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA2) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA2_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA2) NAK OUT */
#define UDPHS_EPTSTA2_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA2) Current Bank/Control Direction */
#define UDPHS_EPTSTA2_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA2) Busy Bank Number */
#define UDPHS_EPTSTA2_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA2) UDPHS Byte Count */
#define UDPHS_EPTSTA2_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA2) Short Packet */
/* -------- UDPHS_EPTCFG3 : (UDPHS Offset: 0x160) UDPHS Endpoint Configuration Register (endpoint = 3) -------- */
#define UDPHS_EPTCFG3_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG3) Endpoint Size */
#define   UDPHS_EPTCFG3_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG3) 8 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG3) 16 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG3) 32 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG3) 64 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG3) 128 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG3) 256 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG3) 512 bytes */
#define   UDPHS_EPTCFG3_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG3) 1024 bytes */
#define UDPHS_EPTCFG3_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG3) Endpoint Direction */
#define   UDPHS_EPTCFG3_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG3) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG3_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG3) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG3_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG3) Endpoint Type */
#define   UDPHS_EPTCFG3_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG3) Control endpoint */
#define   UDPHS_EPTCFG3_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG3) Isochronous endpoint */
#define   UDPHS_EPTCFG3_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG3) Bulk endpoint */
#define   UDPHS_EPTCFG3_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG3) Interrupt endpoint */
#define UDPHS_EPTCFG3_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG3) Number of Banks */
#define   UDPHS_EPTCFG3_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG3) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG3_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG3) One bank (bank 0) */
#define   UDPHS_EPTCFG3_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG3) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG3_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG3) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG3_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG3) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG3_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG3) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB3 : (UDPHS Offset: 0x164) UDPHS Endpoint Control Enable Register (endpoint = 3) -------- */
#define UDPHS_EPTCTLENB3_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB3) Endpoint Enable */
#define UDPHS_EPTCTLENB3_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB3) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB3_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB3) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB3_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB3) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB3_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB3) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB3_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB3) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB3_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB3) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB3_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB3) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB3_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB3) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB3_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB3) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB3_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB3) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB3_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB3) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB3_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB3) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB3_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB3) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB3_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB3) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB3_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB3) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS3 : (UDPHS Offset: 0x168) UDPHS Endpoint Control Disable Register (endpoint = 3) -------- */
#define UDPHS_EPTCTLDIS3_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS3) Endpoint Disable */
#define UDPHS_EPTCTLDIS3_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS3) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS3_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS3) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS3_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS3) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS3_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS3) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS3_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS3) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS3_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS3) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS3_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS3) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS3_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS3) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS3_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS3) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS3_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS3) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS3_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS3) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS3_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS3) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS3_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS3) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS3_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS3) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS3_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS3) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL3 : (UDPHS Offset: 0x16C) UDPHS Endpoint Control Register (endpoint = 3) -------- */
#define UDPHS_EPTCTL3_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL3) Endpoint Enable */
#define UDPHS_EPTCTL3_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL3) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL3_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL3) Interrupt Disables DMA */
#define UDPHS_EPTCTL3_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL3) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL3_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL3) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL3_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL3) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL3_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL3) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL3_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL3) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL3_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL3) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL3_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL3) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL3_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL3) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL3_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL3) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL3_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL3) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL3_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL3) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL3_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL3) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL3_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL3) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA3 : (UDPHS Offset: 0x174) UDPHS Endpoint Set Status Register (endpoint = 3) -------- */
#define UDPHS_EPTSETSTA3_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA3) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA3_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA3) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA3_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA3) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA3 : (UDPHS Offset: 0x178) UDPHS Endpoint Clear Status Register (endpoint = 3) -------- */
#define UDPHS_EPTCLRSTA3_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA3) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA3_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA3) Data Toggle Clear */
#define UDPHS_EPTCLRSTA3_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA3) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA3_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA3) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA3_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA3) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA3_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA3) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA3_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA3) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA3_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA3) NAKOUT Clear */
/* -------- UDPHS_EPTSTA3 : (UDPHS Offset: 0x17C) UDPHS Endpoint Status Register (endpoint = 3) -------- */
#define UDPHS_EPTSTA3_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA3) Stall Handshake Request */
#define UDPHS_EPTSTA3_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA3) Toggle Sequencing */
#define UDPHS_EPTSTA3_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA3) Overflow Error */
#define UDPHS_EPTSTA3_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA3) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA3_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA3) Transmitted IN Data Complete */
#define UDPHS_EPTSTA3_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA3) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA3_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA3) Received SETUP/Error Flow */
#define UDPHS_EPTSTA3_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA3) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA3_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA3) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA3_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA3) NAK OUT */
#define UDPHS_EPTSTA3_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA3) Current Bank/Control Direction */
#define UDPHS_EPTSTA3_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA3) Busy Bank Number */
#define UDPHS_EPTSTA3_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA3) UDPHS Byte Count */
#define UDPHS_EPTSTA3_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA3) Short Packet */
/* -------- UDPHS_EPTCFG4 : (UDPHS Offset: 0x180) UDPHS Endpoint Configuration Register (endpoint = 4) -------- */
#define UDPHS_EPTCFG4_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG4) Endpoint Size */
#define   UDPHS_EPTCFG4_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG4) 8 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG4) 16 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG4) 32 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG4) 64 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG4) 128 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG4) 256 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG4) 512 bytes */
#define   UDPHS_EPTCFG4_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG4) 1024 bytes */
#define UDPHS_EPTCFG4_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG4) Endpoint Direction */
#define   UDPHS_EPTCFG4_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG4) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG4_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG4) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG4_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG4) Endpoint Type */
#define   UDPHS_EPTCFG4_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG4) Control endpoint */
#define   UDPHS_EPTCFG4_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG4) Isochronous endpoint */
#define   UDPHS_EPTCFG4_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG4) Bulk endpoint */
#define   UDPHS_EPTCFG4_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG4) Interrupt endpoint */
#define UDPHS_EPTCFG4_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG4) Number of Banks */
#define   UDPHS_EPTCFG4_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG4) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG4_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG4) One bank (bank 0) */
#define   UDPHS_EPTCFG4_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG4) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG4_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG4) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG4_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG4) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG4_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG4) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB4 : (UDPHS Offset: 0x184) UDPHS Endpoint Control Enable Register (endpoint = 4) -------- */
#define UDPHS_EPTCTLENB4_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB4) Endpoint Enable */
#define UDPHS_EPTCTLENB4_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB4) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB4_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB4) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB4_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB4) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB4_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB4) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB4_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB4) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB4_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB4) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB4_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB4) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB4_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB4) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB4_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB4) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB4_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB4) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB4_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB4) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB4_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB4) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB4_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB4) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB4_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB4) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB4_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB4) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS4 : (UDPHS Offset: 0x188) UDPHS Endpoint Control Disable Register (endpoint = 4) -------- */
#define UDPHS_EPTCTLDIS4_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS4) Endpoint Disable */
#define UDPHS_EPTCTLDIS4_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS4) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS4_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS4) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS4_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS4) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS4_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS4) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS4_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS4) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS4_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS4) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS4_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS4) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS4_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS4) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS4_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS4) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS4_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS4) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS4_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS4) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS4_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS4) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS4_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS4) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS4_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS4) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS4_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS4) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL4 : (UDPHS Offset: 0x18C) UDPHS Endpoint Control Register (endpoint = 4) -------- */
#define UDPHS_EPTCTL4_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL4) Endpoint Enable */
#define UDPHS_EPTCTL4_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL4) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL4_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL4) Interrupt Disables DMA */
#define UDPHS_EPTCTL4_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL4) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL4_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL4) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL4_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL4) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL4_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL4) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL4_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL4) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL4_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL4) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL4_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL4) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL4_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL4) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL4_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL4) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL4_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL4) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL4_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL4) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL4_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL4) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL4_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL4) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA4 : (UDPHS Offset: 0x194) UDPHS Endpoint Set Status Register (endpoint = 4) -------- */
#define UDPHS_EPTSETSTA4_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA4) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA4_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA4) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA4_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA4) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA4 : (UDPHS Offset: 0x198) UDPHS Endpoint Clear Status Register (endpoint = 4) -------- */
#define UDPHS_EPTCLRSTA4_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA4) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA4_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA4) Data Toggle Clear */
#define UDPHS_EPTCLRSTA4_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA4) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA4_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA4) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA4_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA4) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA4_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA4) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA4_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA4) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA4_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA4) NAKOUT Clear */
/* -------- UDPHS_EPTSTA4 : (UDPHS Offset: 0x19C) UDPHS Endpoint Status Register (endpoint = 4) -------- */
#define UDPHS_EPTSTA4_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA4) Stall Handshake Request */
#define UDPHS_EPTSTA4_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA4) Toggle Sequencing */
#define UDPHS_EPTSTA4_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA4) Overflow Error */
#define UDPHS_EPTSTA4_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA4) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA4_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA4) Transmitted IN Data Complete */
#define UDPHS_EPTSTA4_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA4) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA4_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA4) Received SETUP/Error Flow */
#define UDPHS_EPTSTA4_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA4) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA4_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA4) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA4_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA4) NAK OUT */
#define UDPHS_EPTSTA4_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA4) Current Bank/Control Direction */
#define UDPHS_EPTSTA4_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA4) Busy Bank Number */
#define UDPHS_EPTSTA4_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA4) UDPHS Byte Count */
#define UDPHS_EPTSTA4_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA4) Short Packet */
/* -------- UDPHS_EPTCFG5 : (UDPHS Offset: 0x1A0) UDPHS Endpoint Configuration Register (endpoint = 5) -------- */
#define UDPHS_EPTCFG5_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG5) Endpoint Size */
#define   UDPHS_EPTCFG5_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG5) 8 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG5) 16 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG5) 32 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG5) 64 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG5) 128 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG5) 256 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG5) 512 bytes */
#define   UDPHS_EPTCFG5_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG5) 1024 bytes */
#define UDPHS_EPTCFG5_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG5) Endpoint Direction */
#define   UDPHS_EPTCFG5_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG5) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG5_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG5) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG5_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG5) Endpoint Type */
#define   UDPHS_EPTCFG5_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG5) Control endpoint */
#define   UDPHS_EPTCFG5_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG5) Isochronous endpoint */
#define   UDPHS_EPTCFG5_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG5) Bulk endpoint */
#define   UDPHS_EPTCFG5_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG5) Interrupt endpoint */
#define UDPHS_EPTCFG5_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG5) Number of Banks */
#define   UDPHS_EPTCFG5_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG5) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG5_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG5) One bank (bank 0) */
#define   UDPHS_EPTCFG5_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG5) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG5_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG5) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG5_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG5) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG5_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG5) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB5 : (UDPHS Offset: 0x1A4) UDPHS Endpoint Control Enable Register (endpoint = 5) -------- */
#define UDPHS_EPTCTLENB5_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB5) Endpoint Enable */
#define UDPHS_EPTCTLENB5_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB5) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB5_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB5) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB5_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB5) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB5_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB5) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB5_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB5) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB5_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB5) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB5_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB5) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB5_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB5) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB5_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB5) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB5_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB5) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB5_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB5) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB5_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB5) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB5_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB5) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB5_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB5) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB5_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB5) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS5 : (UDPHS Offset: 0x1A8) UDPHS Endpoint Control Disable Register (endpoint = 5) -------- */
#define UDPHS_EPTCTLDIS5_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS5) Endpoint Disable */
#define UDPHS_EPTCTLDIS5_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS5) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS5_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS5) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS5_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS5) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS5_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS5) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS5_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS5) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS5_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS5) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS5_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS5) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS5_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS5) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS5_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS5) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS5_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS5) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS5_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS5) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS5_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS5) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS5_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS5) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS5_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS5) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS5_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS5) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL5 : (UDPHS Offset: 0x1AC) UDPHS Endpoint Control Register (endpoint = 5) -------- */
#define UDPHS_EPTCTL5_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL5) Endpoint Enable */
#define UDPHS_EPTCTL5_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL5) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL5_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL5) Interrupt Disables DMA */
#define UDPHS_EPTCTL5_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL5) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL5_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL5) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL5_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL5) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL5_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL5) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL5_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL5) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL5_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL5) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL5_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL5) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL5_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL5) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL5_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL5) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL5_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL5) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL5_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL5) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL5_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL5) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL5_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL5) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA5 : (UDPHS Offset: 0x1B4) UDPHS Endpoint Set Status Register (endpoint = 5) -------- */
#define UDPHS_EPTSETSTA5_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA5) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA5_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA5) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA5_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA5) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA5 : (UDPHS Offset: 0x1B8) UDPHS Endpoint Clear Status Register (endpoint = 5) -------- */
#define UDPHS_EPTCLRSTA5_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA5) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA5_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA5) Data Toggle Clear */
#define UDPHS_EPTCLRSTA5_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA5) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA5_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA5) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA5_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA5) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA5_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA5) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA5_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA5) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA5_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA5) NAKOUT Clear */
/* -------- UDPHS_EPTSTA5 : (UDPHS Offset: 0x1BC) UDPHS Endpoint Status Register (endpoint = 5) -------- */
#define UDPHS_EPTSTA5_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA5) Stall Handshake Request */
#define UDPHS_EPTSTA5_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA5) Toggle Sequencing */
#define UDPHS_EPTSTA5_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA5) Overflow Error */
#define UDPHS_EPTSTA5_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA5) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA5_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA5) Transmitted IN Data Complete */
#define UDPHS_EPTSTA5_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA5) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA5_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA5) Received SETUP/Error Flow */
#define UDPHS_EPTSTA5_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA5) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA5_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA5) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA5_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA5) NAK OUT */
#define UDPHS_EPTSTA5_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA5) Current Bank/Control Direction */
#define UDPHS_EPTSTA5_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA5) Busy Bank Number */
#define UDPHS_EPTSTA5_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA5) UDPHS Byte Count */
#define UDPHS_EPTSTA5_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA5) Short Packet */
/* -------- UDPHS_EPTCFG6 : (UDPHS Offset: 0x1C0) UDPHS Endpoint Configuration Register (endpoint = 6) -------- */
#define UDPHS_EPTCFG6_EPT_SIZE (0x7 << 0) /**< \brief (UDPHS_EPTCFG6) Endpoint Size */
#define   UDPHS_EPTCFG6_EPT_SIZE_8 (0x0 << 0) /**< \brief (UDPHS_EPTCFG6) 8 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_16 (0x1 << 0) /**< \brief (UDPHS_EPTCFG6) 16 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_32 (0x2 << 0) /**< \brief (UDPHS_EPTCFG6) 32 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_64 (0x3 << 0) /**< \brief (UDPHS_EPTCFG6) 64 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_128 (0x4 << 0) /**< \brief (UDPHS_EPTCFG6) 128 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_256 (0x5 << 0) /**< \brief (UDPHS_EPTCFG6) 256 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_512 (0x6 << 0) /**< \brief (UDPHS_EPTCFG6) 512 bytes */
#define   UDPHS_EPTCFG6_EPT_SIZE_1024 (0x7 << 0) /**< \brief (UDPHS_EPTCFG6) 1024 bytes */
#define UDPHS_EPTCFG6_EPT_DIR (0x1 << 3) /**< \brief (UDPHS_EPTCFG6) Endpoint Direction */
#define   UDPHS_EPTCFG6_EPT_DIR_OUT (0x0 << 3) /**< \brief (UDPHS_EPTCFG6) Clear this bit to configure OUT direction for Bulk, Interrupt and Isochronous endpoints. */
#define   UDPHS_EPTCFG6_EPT_DIR_IN (0x1 << 3) /**< \brief (UDPHS_EPTCFG6) set this bit to configure IN direction for Bulk, Interrupt and Isochronous endpoints. */
#define UDPHS_EPTCFG6_EPT_TYPE (0x3 << 4) /**< \brief (UDPHS_EPTCFG6) Endpoint Type */
#define   UDPHS_EPTCFG6_EPT_TYPE_CTL_EPT (0x0 << 4) /**< \brief (UDPHS_EPTCFG6) Control endpoint */
#define   UDPHS_EPTCFG6_EPT_TYPE_ISO_EPT (0x1 << 4) /**< \brief (UDPHS_EPTCFG6) Isochronous endpoint */
#define   UDPHS_EPTCFG6_EPT_TYPE_BUL_EPT (0x2 << 4) /**< \brief (UDPHS_EPTCFG6) Bulk endpoint */
#define   UDPHS_EPTCFG6_EPT_TYPE_INT_EPT (0x3 << 4) /**< \brief (UDPHS_EPTCFG6) Interrupt endpoint */
#define UDPHS_EPTCFG6_BK_NUMBER (0x3 << 6) /**< \brief (UDPHS_EPTCFG6) Number of Banks */
#define   UDPHS_EPTCFG6_BK_NUMBER_0 (0x0 << 6) /**< \brief (UDPHS_EPTCFG6) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG6_BK_NUMBER_1 (0x1 << 6) /**< \brief (UDPHS_EPTCFG6) One bank (bank 0) */
#define   UDPHS_EPTCFG6_BK_NUMBER_2 (0x2 << 6) /**< \brief (UDPHS_EPTCFG6) Double bank (Ping-Pong: bank 0/bank 1) */
#define   UDPHS_EPTCFG6_BK_NUMBER_3 (0x3 << 6) /**< \brief (UDPHS_EPTCFG6) Triple bank (bank 0/bank 1/bank 2) */
#define UDPHS_EPTCFG6_NB_TRANS (0x3 << 8) /**< \brief (UDPHS_EPTCFG6) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG6_EPT_MAPD (0x1 << 31) /**< \brief (UDPHS_EPTCFG6) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB6 : (UDPHS Offset: 0x1C4) UDPHS Endpoint Control Enable Register (endpoint = 6) -------- */
#define UDPHS_EPTCTLENB6_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLENB6) Endpoint Enable */
#define UDPHS_EPTCTLENB6_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLENB6) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB6_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLENB6) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB6_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLENB6) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB6_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLENB6) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB6_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLENB6) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB6_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLENB6) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB6_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLENB6) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB6_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLENB6) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB6_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLENB6) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB6_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLENB6) Received SETUP/Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB6_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLENB6) Stall Sent /ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB6_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLENB6) NAKIN/Bank Flush Error Interrupt Enable */
#define UDPHS_EPTCTLENB6_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLENB6) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB6_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLENB6) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB6_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLENB6) Short Packet Send/Short Packet Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS6 : (UDPHS Offset: 0x1C8) UDPHS Endpoint Control Disable Register (endpoint = 6) -------- */
#define UDPHS_EPTCTLDIS6_EPT_DISABL (0x1 << 0) /**< \brief (UDPHS_EPTCTLDIS6) Endpoint Disable */
#define UDPHS_EPTCTLDIS6_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTLDIS6) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS6_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTLDIS6) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS6_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTLDIS6) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS6_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTLDIS6) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS6_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTLDIS6) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS6_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTLDIS6) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS6_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTLDIS6) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS6_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTLDIS6) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS6_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTLDIS6) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS6_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTLDIS6) Received SETUP/Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS6_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTLDIS6) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS6_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTLDIS6) NAKIN/bank flush error Interrupt Disable */
#define UDPHS_EPTCTLDIS6_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTLDIS6) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS6_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTLDIS6) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS6_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTLDIS6) Short Packet Interrupt Disable */
/* -------- UDPHS_EPTCTL6 : (UDPHS Offset: 0x1CC) UDPHS Endpoint Control Register (endpoint = 6) -------- */
#define UDPHS_EPTCTL6_EPT_ENABL (0x1 << 0) /**< \brief (UDPHS_EPTCTL6) Endpoint Enable */
#define UDPHS_EPTCTL6_AUTO_VALID (0x1 << 1) /**< \brief (UDPHS_EPTCTL6) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL6_INTDIS_DMA (0x1 << 3) /**< \brief (UDPHS_EPTCTL6) Interrupt Disables DMA */
#define UDPHS_EPTCTL6_NYET_DIS (0x1 << 4) /**< \brief (UDPHS_EPTCTL6) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL6_DATAX_RX (0x1 << 6) /**< \brief (UDPHS_EPTCTL6) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL6_MDATA_RX (0x1 << 7) /**< \brief (UDPHS_EPTCTL6) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL6_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTCTL6) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL6_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCTL6) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL6_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCTL6) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL6_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTCTL6) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL6_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCTL6) Received SETUP/Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL6_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCTL6) Stall Sent/ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL6_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCTL6) NAKIN/Bank Flush Error Interrupt Enabled */
#define UDPHS_EPTCTL6_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCTL6) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL6_BUSY_BANK (0x1 << 18) /**< \brief (UDPHS_EPTCTL6) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL6_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTCTL6) Short Packet Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA6 : (UDPHS Offset: 0x1D4) UDPHS Endpoint Set Status Register (endpoint = 6) -------- */
#define UDPHS_EPTSETSTA6_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSETSTA6) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA6_KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSETSTA6) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA6_TX_PK_RDY (0x1 << 11) /**< \brief (UDPHS_EPTSETSTA6) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA6 : (UDPHS Offset: 0x1D8) UDPHS Endpoint Clear Status Register (endpoint = 6) -------- */
#define UDPHS_EPTCLRSTA6_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTCLRSTA6) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA6_TOGGLESQ (0x1 << 6) /**< \brief (UDPHS_EPTCLRSTA6) Data Toggle Clear */
#define UDPHS_EPTCLRSTA6_RX_BK_RDY (0x1 << 9) /**< \brief (UDPHS_EPTCLRSTA6) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA6_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTCLRSTA6) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA6_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTCLRSTA6) Received SETUP/Error Flow Clear */
#define UDPHS_EPTCLRSTA6_STALL_SNT__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTCLRSTA6) Stall Sent/Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA6_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTCLRSTA6) NAKIN/Bank Flush Error Clear */
#define UDPHS_EPTCLRSTA6_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTCLRSTA6) NAKOUT Clear */
/* -------- UDPHS_EPTSTA6 : (UDPHS Offset: 0x1DC) UDPHS Endpoint Status Register (endpoint = 6) -------- */
#define UDPHS_EPTSTA6_FRCESTALL (0x1 << 5) /**< \brief (UDPHS_EPTSTA6) Stall Handshake Request */
#define UDPHS_EPTSTA6_TOGGLESQ_STA (0x3 << 6) /**< \brief (UDPHS_EPTSTA6) Toggle Sequencing */
#define UDPHS_EPTSTA6_ERR_OVFLW (0x1 << 8) /**< \brief (UDPHS_EPTSTA6) Overflow Error */
#define UDPHS_EPTSTA6_RX_BK_RDY__KILL_BANK (0x1 << 9) /**< \brief (UDPHS_EPTSTA6) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA6_TX_COMPLT (0x1 << 10) /**< \brief (UDPHS_EPTSTA6) Transmitted IN Data Complete */
#define UDPHS_EPTSTA6_TX_PK_RDY__ERR_TRANS (0x1 << 11) /**< \brief (UDPHS_EPTSTA6) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA6_RX_SETUP__ERR_FL_ISO (0x1 << 12) /**< \brief (UDPHS_EPTSTA6) Received SETUP/Error Flow */
#define UDPHS_EPTSTA6_STALL_SNT__ERR_CRISO__ERR_NBTRA (0x1 << 13) /**< \brief (UDPHS_EPTSTA6) Stall Sent/CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA6_NAK_IN__ERR_FLUSH (0x1 << 14) /**< \brief (UDPHS_EPTSTA6) NAK IN/Bank Flush Error */
#define UDPHS_EPTSTA6_NAK_OUT (0x1 << 15) /**< \brief (UDPHS_EPTSTA6) NAK OUT */
#define UDPHS_EPTSTA6_CURRENT_BANK__CONTROL_DIR (0x3 << 16) /**< \brief (UDPHS_EPTSTA6) Current Bank/Control Direction */
#define UDPHS_EPTSTA6_BUSY_BANK_STA (0x3 << 18) /**< \brief (UDPHS_EPTSTA6) Busy Bank Number */
#define UDPHS_EPTSTA6_BYTE_COUNT (0x7ff << 20) /**< \brief (UDPHS_EPTSTA6) UDPHS Byte Count */
#define UDPHS_EPTSTA6_SHRT_PCKT (0x1 << 31) /**< \brief (UDPHS_EPTSTA6) Short Packet */
/* -------- UDPHS_DMANXTDSC1 : (UDPHS Offset: 0x320) UDPHS DMA Next Descriptor Address Register (channel = 1) -------- */
#define UDPHS_DMANXTDSC1_NXT_DSC_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMANXTDSC1)  */
/* -------- UDPHS_DMAADDRESS1 : (UDPHS Offset: 0x324) UDPHS DMA Channel Address Register (channel = 1) -------- */
#define UDPHS_DMAADDRESS1_BUFF_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMAADDRESS1)  */
/* -------- UDPHS_DMACONTROL1 : (UDPHS Offset: 0x328) UDPHS DMA Channel Control Register (channel = 1) -------- */
#define UDPHS_DMACONTROL1_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMACONTROL1)  */
#define UDPHS_DMACONTROL1_LDNXT_DSC (0x1 << 1) /**< \brief (UDPHS_DMACONTROL1) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL1_END_TR_EN (0x1 << 2) /**< \brief (UDPHS_DMACONTROL1) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL1_END_B_EN (0x1 << 3) /**< \brief (UDPHS_DMACONTROL1) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL1_END_TR_IT (0x1 << 4) /**< \brief (UDPHS_DMACONTROL1) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL1_END_BUFFIT (0x1 << 5) /**< \brief (UDPHS_DMACONTROL1) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL1_DESC_LD_IT (0x1 << 6) /**< \brief (UDPHS_DMACONTROL1) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL1_BURST_LCK (0x1 << 7) /**< \brief (UDPHS_DMACONTROL1) Burst Lock Enable */
#define UDPHS_DMACONTROL1_BUFF_LENGTH (0xffff << 16) /**< \brief (UDPHS_DMACONTROL1) Buffer Byte Length (Write-only) */
/* -------- UDPHS_DMASTATUS1 : (UDPHS Offset: 0x32C) UDPHS DMA Channel Status Register (channel = 1) -------- */
#define UDPHS_DMASTATUS1_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMASTATUS1) Channel Enable Status */
#define UDPHS_DMASTATUS1_CHANN_ACT (0x1 << 1) /**< \brief (UDPHS_DMASTATUS1) Channel Active Status */
#define UDPHS_DMASTATUS1_END_TR_ST (0x1 << 4) /**< \brief (UDPHS_DMASTATUS1) End of Channel Transfer Status */
#define UDPHS_DMASTATUS1_END_BF_ST (0x1 << 5) /**< \brief (UDPHS_DMASTATUS1) End of Channel Buffer Status */
#define UDPHS_DMASTATUS1_DESC_LDST (0x1 << 6) /**< \brief (UDPHS_DMASTATUS1) Descriptor Loaded Status */
#define UDPHS_DMASTATUS1_BUFF_COUNT (0xffff << 16) /**< \brief (UDPHS_DMASTATUS1) Buffer Byte Count */
/* -------- UDPHS_DMANXTDSC2 : (UDPHS Offset: 0x330) UDPHS DMA Next Descriptor Address Register (channel = 2) -------- */
#define UDPHS_DMANXTDSC2_NXT_DSC_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMANXTDSC2)  */
/* -------- UDPHS_DMAADDRESS2 : (UDPHS Offset: 0x334) UDPHS DMA Channel Address Register (channel = 2) -------- */
#define UDPHS_DMAADDRESS2_BUFF_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMAADDRESS2)  */
/* -------- UDPHS_DMACONTROL2 : (UDPHS Offset: 0x338) UDPHS DMA Channel Control Register (channel = 2) -------- */
#define UDPHS_DMACONTROL2_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMACONTROL2)  */
#define UDPHS_DMACONTROL2_LDNXT_DSC (0x1 << 1) /**< \brief (UDPHS_DMACONTROL2) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL2_END_TR_EN (0x1 << 2) /**< \brief (UDPHS_DMACONTROL2) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL2_END_B_EN (0x1 << 3) /**< \brief (UDPHS_DMACONTROL2) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL2_END_TR_IT (0x1 << 4) /**< \brief (UDPHS_DMACONTROL2) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL2_END_BUFFIT (0x1 << 5) /**< \brief (UDPHS_DMACONTROL2) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL2_DESC_LD_IT (0x1 << 6) /**< \brief (UDPHS_DMACONTROL2) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL2_BURST_LCK (0x1 << 7) /**< \brief (UDPHS_DMACONTROL2) Burst Lock Enable */
#define UDPHS_DMACONTROL2_BUFF_LENGTH (0xffff << 16) /**< \brief (UDPHS_DMACONTROL2) Buffer Byte Length (Write-only) */
/* -------- UDPHS_DMASTATUS2 : (UDPHS Offset: 0x33C) UDPHS DMA Channel Status Register (channel = 2) -------- */
#define UDPHS_DMASTATUS2_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMASTATUS2) Channel Enable Status */
#define UDPHS_DMASTATUS2_CHANN_ACT (0x1 << 1) /**< \brief (UDPHS_DMASTATUS2) Channel Active Status */
#define UDPHS_DMASTATUS2_END_TR_ST (0x1 << 4) /**< \brief (UDPHS_DMASTATUS2) End of Channel Transfer Status */
#define UDPHS_DMASTATUS2_END_BF_ST (0x1 << 5) /**< \brief (UDPHS_DMASTATUS2) End of Channel Buffer Status */
#define UDPHS_DMASTATUS2_DESC_LDST (0x1 << 6) /**< \brief (UDPHS_DMASTATUS2) Descriptor Loaded Status */
#define UDPHS_DMASTATUS2_BUFF_COUNT (0xffff << 16) /**< \brief (UDPHS_DMASTATUS2) Buffer Byte Count */
/* -------- UDPHS_DMANXTDSC3 : (UDPHS Offset: 0x340) UDPHS DMA Next Descriptor Address Register (channel = 3) -------- */
#define UDPHS_DMANXTDSC3_NXT_DSC_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMANXTDSC3)  */
/* -------- UDPHS_DMAADDRESS3 : (UDPHS Offset: 0x344) UDPHS DMA Channel Address Register (channel = 3) -------- */
#define UDPHS_DMAADDRESS3_BUFF_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMAADDRESS3)  */
/* -------- UDPHS_DMACONTROL3 : (UDPHS Offset: 0x348) UDPHS DMA Channel Control Register (channel = 3) -------- */
#define UDPHS_DMACONTROL3_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMACONTROL3)  */
#define UDPHS_DMACONTROL3_LDNXT_DSC (0x1 << 1) /**< \brief (UDPHS_DMACONTROL3) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL3_END_TR_EN (0x1 << 2) /**< \brief (UDPHS_DMACONTROL3) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL3_END_B_EN (0x1 << 3) /**< \brief (UDPHS_DMACONTROL3) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL3_END_TR_IT (0x1 << 4) /**< \brief (UDPHS_DMACONTROL3) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL3_END_BUFFIT (0x1 << 5) /**< \brief (UDPHS_DMACONTROL3) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL3_DESC_LD_IT (0x1 << 6) /**< \brief (UDPHS_DMACONTROL3) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL3_BURST_LCK (0x1 << 7) /**< \brief (UDPHS_DMACONTROL3) Burst Lock Enable */
#define UDPHS_DMACONTROL3_BUFF_LENGTH (0xffff << 16) /**< \brief (UDPHS_DMACONTROL3) Buffer Byte Length (Write-only) */
/* -------- UDPHS_DMASTATUS3 : (UDPHS Offset: 0x34C) UDPHS DMA Channel Status Register (channel = 3) -------- */
#define UDPHS_DMASTATUS3_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMASTATUS3) Channel Enable Status */
#define UDPHS_DMASTATUS3_CHANN_ACT (0x1 << 1) /**< \brief (UDPHS_DMASTATUS3) Channel Active Status */
#define UDPHS_DMASTATUS3_END_TR_ST (0x1 << 4) /**< \brief (UDPHS_DMASTATUS3) End of Channel Transfer Status */
#define UDPHS_DMASTATUS3_END_BF_ST (0x1 << 5) /**< \brief (UDPHS_DMASTATUS3) End of Channel Buffer Status */
#define UDPHS_DMASTATUS3_DESC_LDST (0x1 << 6) /**< \brief (UDPHS_DMASTATUS3) Descriptor Loaded Status */
#define UDPHS_DMASTATUS3_BUFF_COUNT (0xffff << 16) /**< \brief (UDPHS_DMASTATUS3) Buffer Byte Count */
/* -------- UDPHS_DMANXTDSC4 : (UDPHS Offset: 0x350) UDPHS DMA Next Descriptor Address Register (channel = 4) -------- */
#define UDPHS_DMANXTDSC4_NXT_DSC_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMANXTDSC4)  */
/* -------- UDPHS_DMAADDRESS4 : (UDPHS Offset: 0x354) UDPHS DMA Channel Address Register (channel = 4) -------- */
#define UDPHS_DMAADDRESS4_BUFF_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMAADDRESS4)  */
/* -------- UDPHS_DMACONTROL4 : (UDPHS Offset: 0x358) UDPHS DMA Channel Control Register (channel = 4) -------- */
#define UDPHS_DMACONTROL4_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMACONTROL4)  */
#define UDPHS_DMACONTROL4_LDNXT_DSC (0x1 << 1) /**< \brief (UDPHS_DMACONTROL4) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL4_END_TR_EN (0x1 << 2) /**< \brief (UDPHS_DMACONTROL4) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL4_END_B_EN (0x1 << 3) /**< \brief (UDPHS_DMACONTROL4) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL4_END_TR_IT (0x1 << 4) /**< \brief (UDPHS_DMACONTROL4) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL4_END_BUFFIT (0x1 << 5) /**< \brief (UDPHS_DMACONTROL4) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL4_DESC_LD_IT (0x1 << 6) /**< \brief (UDPHS_DMACONTROL4) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL4_BURST_LCK (0x1 << 7) /**< \brief (UDPHS_DMACONTROL4) Burst Lock Enable */
#define UDPHS_DMACONTROL4_BUFF_LENGTH (0xffff << 16) /**< \brief (UDPHS_DMACONTROL4) Buffer Byte Length (Write-only) */
/* -------- UDPHS_DMASTATUS4 : (UDPHS Offset: 0x35C) UDPHS DMA Channel Status Register (channel = 4) -------- */
#define UDPHS_DMASTATUS4_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMASTATUS4) Channel Enable Status */
#define UDPHS_DMASTATUS4_CHANN_ACT (0x1 << 1) /**< \brief (UDPHS_DMASTATUS4) Channel Active Status */
#define UDPHS_DMASTATUS4_END_TR_ST (0x1 << 4) /**< \brief (UDPHS_DMASTATUS4) End of Channel Transfer Status */
#define UDPHS_DMASTATUS4_END_BF_ST (0x1 << 5) /**< \brief (UDPHS_DMASTATUS4) End of Channel Buffer Status */
#define UDPHS_DMASTATUS4_DESC_LDST (0x1 << 6) /**< \brief (UDPHS_DMASTATUS4) Descriptor Loaded Status */
#define UDPHS_DMASTATUS4_BUFF_COUNT (0xffff << 16) /**< \brief (UDPHS_DMASTATUS4) Buffer Byte Count */
/* -------- UDPHS_DMANXTDSC5 : (UDPHS Offset: 0x360) UDPHS DMA Next Descriptor Address Register (channel = 5) -------- */
#define UDPHS_DMANXTDSC5_NXT_DSC_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMANXTDSC5)  */
/* -------- UDPHS_DMAADDRESS5 : (UDPHS Offset: 0x364) UDPHS DMA Channel Address Register (channel = 5) -------- */
#define UDPHS_DMAADDRESS5_BUFF_ADD (0xffffffff << 0) /**< \brief (UDPHS_DMAADDRESS5)  */
/* -------- UDPHS_DMACONTROL5 : (UDPHS Offset: 0x368) UDPHS DMA Channel Control Register (channel = 5) -------- */
#define UDPHS_DMACONTROL5_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMACONTROL5)  */
#define UDPHS_DMACONTROL5_LDNXT_DSC (0x1 << 1) /**< \brief (UDPHS_DMACONTROL5) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL5_END_TR_EN (0x1 << 2) /**< \brief (UDPHS_DMACONTROL5) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL5_END_B_EN (0x1 << 3) /**< \brief (UDPHS_DMACONTROL5) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL5_END_TR_IT (0x1 << 4) /**< \brief (UDPHS_DMACONTROL5) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL5_END_BUFFIT (0x1 << 5) /**< \brief (UDPHS_DMACONTROL5) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL5_DESC_LD_IT (0x1 << 6) /**< \brief (UDPHS_DMACONTROL5) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL5_BURST_LCK (0x1 << 7) /**< \brief (UDPHS_DMACONTROL5) Burst Lock Enable */
#define UDPHS_DMACONTROL5_BUFF_LENGTH (0xffff << 16) /**< \brief (UDPHS_DMACONTROL5) Buffer Byte Length (Write-only) */
/* -------- UDPHS_DMASTATUS5 : (UDPHS Offset: 0x36C) UDPHS DMA Channel Status Register (channel = 5) -------- */
#define UDPHS_DMASTATUS5_CHANN_ENB (0x1 << 0) /**< \brief (UDPHS_DMASTATUS5) Channel Enable Status */
#define UDPHS_DMASTATUS5_CHANN_ACT (0x1 << 1) /**< \brief (UDPHS_DMASTATUS5) Channel Active Status */
#define UDPHS_DMASTATUS5_END_TR_ST (0x1 << 4) /**< \brief (UDPHS_DMASTATUS5) End of Channel Transfer Status */
#define UDPHS_DMASTATUS5_END_BF_ST (0x1 << 5) /**< \brief (UDPHS_DMASTATUS5) End of Channel Buffer Status */
#define UDPHS_DMASTATUS5_DESC_LDST (0x1 << 6) /**< \brief (UDPHS_DMASTATUS5) Descriptor Loaded Status */
#define UDPHS_DMASTATUS5_BUFF_COUNT (0xffff << 16) /**< \brief (UDPHS_DMASTATUS5) Buffer Byte Count */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Universal Synchronous Asynchronous Receiver Transmitter */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_USART Universal Synchronous Asynchronous Receiver Transmitter */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Usart hardware registers */
typedef struct {
  WoReg US_CR;         /**< \brief (Usart Offset: 0x0000) Control Register */
  RwReg US_MR;         /**< \brief (Usart Offset: 0x0004) Mode Register */
  WoReg US_IER;        /**< \brief (Usart Offset: 0x0008) Interrupt Enable Register */
  WoReg US_IDR;        /**< \brief (Usart Offset: 0x000C) Interrupt Disable Register */
  RoReg US_IMR;        /**< \brief (Usart Offset: 0x0010) Interrupt Mask Register */
  RoReg US_CSR;        /**< \brief (Usart Offset: 0x0014) Channel Status Register */
  RoReg US_RHR;        /**< \brief (Usart Offset: 0x0018) Receiver Holding Register */
  WoReg US_THR;        /**< \brief (Usart Offset: 0x001C) Transmitter Holding Register */
  RwReg US_BRGR;       /**< \brief (Usart Offset: 0x0020) Baud Rate Generator Register */
  RwReg US_RTOR;       /**< \brief (Usart Offset: 0x0024) Receiver Time-out Register */
  RwReg US_TTGR;       /**< \brief (Usart Offset: 0x0028) Transmitter Timeguard Register */
  RwReg Reserved1[5]; 
  RwReg US_FIDI;       /**< \brief (Usart Offset: 0x0040) FI DI Ratio Register */
  RoReg US_NER;        /**< \brief (Usart Offset: 0x0044) Number of Errors Register */
  RwReg Reserved2[1]; 
  RwReg US_IF;         /**< \brief (Usart Offset: 0x004C) IrDA Filter Register */
  RwReg US_MAN;        /**< \brief (Usart Offset: 0x0050) Manchester Encoder Decoder Register */
  RwReg Reserved3[36];
  RwReg US_WPMR;       /**< \brief (Usart Offset: 0xE4) Write Protect Mode Register */
  RoReg US_WPSR;       /**< \brief (Usart Offset: 0xE8) Write Protect Status Register */
  RwReg Reserved4[4]; 
  RoReg US_VERSION;    /**< \brief (Usart Offset: 0xFC) Version Register */
  RwReg US_RPR;        /**< \brief (Usart Offset: 0x100) Receive Pointer Register */
  RwReg US_RCR;        /**< \brief (Usart Offset: 0x104) Receive Counter Register */
  RwReg US_TPR;        /**< \brief (Usart Offset: 0x108) Transmit Pointer Register */
  RwReg US_TCR;        /**< \brief (Usart Offset: 0x10C) Transmit Counter Register */
  RwReg US_RNPR;       /**< \brief (Usart Offset: 0x110) Receive Next Pointer Register */
  RwReg US_RNCR;       /**< \brief (Usart Offset: 0x114) Receive Next Counter Register */
  RwReg US_TNPR;       /**< \brief (Usart Offset: 0x118) Transmit Next Pointer Register */
  RwReg US_TNCR;       /**< \brief (Usart Offset: 0x11C) Transmit Next Counter Register */
  WoReg US_PTCR;       /**< \brief (Usart Offset: 0x120) Transfer Control Register */
  RoReg US_PTSR;       /**< \brief (Usart Offset: 0x124) Transfer Status Register */
} Usart;
#endif /* __ASSEMBLY__ */
/* -------- US_CR : (USART Offset: 0x0000) Control Register -------- */
#define US_CR_RSTRX (0x1 << 2) /**< \brief (US_CR) Reset Receiver */
#define US_CR_RSTTX (0x1 << 3) /**< \brief (US_CR) Reset Transmitter */
#define US_CR_RXEN (0x1 << 4) /**< \brief (US_CR) Receiver Enable */
#define US_CR_RXDIS (0x1 << 5) /**< \brief (US_CR) Receiver Disable */
#define US_CR_TXEN (0x1 << 6) /**< \brief (US_CR) Transmitter Enable */
#define US_CR_TXDIS (0x1 << 7) /**< \brief (US_CR) Transmitter Disable */
#define US_CR_RSTSTA (0x1 << 8) /**< \brief (US_CR) Reset Status Bits */
#define US_CR_STTBRK (0x1 << 9) /**< \brief (US_CR) Start Break */
#define US_CR_STPBRK (0x1 << 10) /**< \brief (US_CR) Stop Break */
#define US_CR_STTTO (0x1 << 11) /**< \brief (US_CR) Start Time-out */
#define US_CR_SENDA (0x1 << 12) /**< \brief (US_CR) Send Address */
#define US_CR_RSTIT (0x1 << 13) /**< \brief (US_CR) Reset Iterations */
#define US_CR_RSTNACK (0x1 << 14) /**< \brief (US_CR) Reset Non Acknowledge */
#define US_CR_RETTO (0x1 << 15) /**< \brief (US_CR) Rearm Time-out */
#define US_CR_RTSEN__FCS (0x1 << 18) /**< \brief (US_CR) Request to Send Enable/Force SPI Chip Select */
#define US_CR_RTSDIS__RCS (0x1 << 19) /**< \brief (US_CR) Request to Send Disable/Release SPI Chip Select */
/* -------- US_MR : (USART Offset: 0x0004) Mode Register -------- */
#define US_MR_USART_MODE (0xf << 0) /**< \brief (US_MR)  */
#define US_MR_USCLKS (0x3 << 4) /**< \brief (US_MR) Clock Selection */
#define US_MR_CHRL (0x3 << 6) /**< \brief (US_MR) Character Length. */
#define US_MR_SYNC__CPHA (0x1 << 8) /**< \brief (US_MR) Synchronous Mode Select or SPI Clock Phase */
#define US_MR_PAR (0x7 << 9) /**< \brief (US_MR) Parity Type */
#define US_MR_NBSTOP (0x3 << 12) /**< \brief (US_MR) Number of Stop Bits */
#define US_MR_CHMODE (0x3 << 14) /**< \brief (US_MR) Channel Mode */
#define US_MR_MSBF__CPOL (0x1 << 16) /**< \brief (US_MR) Bit Order or SPI Clock Polarity */
#define US_MR_MODE9 (0x1 << 17) /**< \brief (US_MR) 9-bit Character Length */
#define US_MR_CLKO (0x1 << 18) /**< \brief (US_MR) Clock Output Select */
#define US_MR_OVER (0x1 << 19) /**< \brief (US_MR) Oversampling Mode */
#define US_MR_INACK (0x1 << 20) /**< \brief (US_MR) Inhibit Non Acknowledge */
#define US_MR_DSNACK (0x1 << 21) /**< \brief (US_MR) Disable Successive NACK */
#define US_MR_VAR_SYNC (0x1 << 22) /**< \brief (US_MR) Variable Synchronization of Command/Data Sync Start Frame Delimiter */
#define US_MR_INVDATA (0x1 << 23) /**< \brief (US_MR) INverted Data */
#define US_MR_MAX_ITERATION (0x7 << 24) /**< \brief (US_MR)  */
#define US_MR_FILTER (0x1 << 28) /**< \brief (US_MR) Infrared Receive Line Filter */
#define US_MR_MAN (0x1 << 29) /**< \brief (US_MR) Manchester Encoder/Decoder Enable */
#define US_MR_MODSYNC_ (0x1 << 30) /**< \brief (US_MR)  */
#define US_MR_ONEBIT (0x1 << 31) /**< \brief (US_MR) Start Frame Delimiter Selector */
/* -------- US_IER : (USART Offset: 0x0008) Interrupt Enable Register -------- */
#define US_IER_RXRDY (0x1 << 0) /**< \brief (US_IER) RXRDY Interrupt Enable */
#define US_IER_TXRDY (0x1 << 1) /**< \brief (US_IER) TXRDY Interrupt Enable */
#define US_IER_RXBRK (0x1 << 2) /**< \brief (US_IER) Receiver Break Interrupt Enable */
#define US_IER_ENDRX (0x1 << 3) /**< \brief (US_IER) End of Receive Transfer Interrupt Enable */
#define US_IER_ENDTX (0x1 << 4) /**< \brief (US_IER) End of Transmit Interrupt Enable */
#define US_IER_OVRE (0x1 << 5) /**< \brief (US_IER) Overrun Error Interrupt Enable */
#define US_IER_FRAME (0x1 << 6) /**< \brief (US_IER) Framing Error Interrupt Enable */
#define US_IER_PARE (0x1 << 7) /**< \brief (US_IER) Parity Error Interrupt Enable */
#define US_IER_TIMEOUT (0x1 << 8) /**< \brief (US_IER) Time-out Interrupt Enable */
#define US_IER_TXEMPTY (0x1 << 9) /**< \brief (US_IER) TXEMPTY Interrupt Enable */
#define US_IER_ITER__UNRE (0x1 << 10) /**< \brief (US_IER) Iteration or SPI Underrun Error Interrupt Enable */
#define US_IER_TXBUFE (0x1 << 11) /**< \brief (US_IER) Buffer Empty Interrupt Enable */
#define US_IER_RXBUFF (0x1 << 12) /**< \brief (US_IER) Buffer Full Interrupt Enable */
#define US_IER_NACK (0x1 << 13) /**< \brief (US_IER) Non Acknowledge  Interrupt Enable */
#define US_IER_CTSIC (0x1 << 19) /**< \brief (US_IER) Clear to Send Input Change Interrupt Enable */
#define US_IER_MANE (0x1 << 24) /**< \brief (US_IER) Manchester Error Interrupt Enable */
/* -------- US_IDR : (USART Offset: 0x000C) Interrupt Disable Register -------- */
#define US_IDR_RXRDY (0x1 << 0) /**< \brief (US_IDR) RXRDY Interrupt Disable */
#define US_IDR_TXRDY (0x1 << 1) /**< \brief (US_IDR) TXRDY Interrupt Disable */
#define US_IDR_RXBRK (0x1 << 2) /**< \brief (US_IDR) Receiver Break Interrupt Disable */
#define US_IDR_ENDRX (0x1 << 3) /**< \brief (US_IDR) End of Receive Transfer Interrupt Disable */
#define US_IDR_ENDTX (0x1 << 4) /**< \brief (US_IDR) End of Transmit Interrupt Disable */
#define US_IDR_OVRE (0x1 << 5) /**< \brief (US_IDR) Overrun Error Interrupt Disable */
#define US_IDR_FRAME (0x1 << 6) /**< \brief (US_IDR) Framing Error Interrupt Disable */
#define US_IDR_PARE (0x1 << 7) /**< \brief (US_IDR) Parity Error Interrupt Disable */
#define US_IDR_TIMEOUT (0x1 << 8) /**< \brief (US_IDR) Time-out Interrupt Disable */
#define US_IDR_TXEMPTY (0x1 << 9) /**< \brief (US_IDR) TXEMPTY Interrupt Disable */
#define US_IDR_ITER__UNRE (0x1 << 10) /**< \brief (US_IDR) Iteration or SPI Underrun Error Interrupt Enable */
#define US_IDR_TXBUFE (0x1 << 11) /**< \brief (US_IDR) Buffer Empty Interrupt Disable */
#define US_IDR_RXBUFF (0x1 << 12) /**< \brief (US_IDR) Buffer Full Interrupt Disable */
#define US_IDR_NACK (0x1 << 13) /**< \brief (US_IDR) Non Acknowledge  Interrupt Disable */
#define US_IDR_CTSIC (0x1 << 19) /**< \brief (US_IDR) Clear to Send Input Change Interrupt Disable */
#define US_IDR_MANE (0x1 << 24) /**< \brief (US_IDR) Manchester Error Interrupt Disable */
/* -------- US_IMR : (USART Offset: 0x0010) Interrupt Mask Register -------- */
#define US_IMR_RXRDY (0x1 << 0) /**< \brief (US_IMR) RXRDY Interrupt Mask */
#define US_IMR_TXRDY (0x1 << 1) /**< \brief (US_IMR) TXRDY Interrupt Mask */
#define US_IMR_RXBRK (0x1 << 2) /**< \brief (US_IMR) Receiver Break Interrupt Mask */
#define US_IMR_ENDRX (0x1 << 3) /**< \brief (US_IMR) End of Receive Transfer Interrupt Mask */
#define US_IMR_ENDTX (0x1 << 4) /**< \brief (US_IMR) End of Transmit Interrupt Mask */
#define US_IMR_OVRE (0x1 << 5) /**< \brief (US_IMR) Overrun Error Interrupt Mask */
#define US_IMR_FRAME (0x1 << 6) /**< \brief (US_IMR) Framing Error Interrupt Mask */
#define US_IMR_PARE (0x1 << 7) /**< \brief (US_IMR) Parity Error Interrupt Mask */
#define US_IMR_TIMEOUT (0x1 << 8) /**< \brief (US_IMR) Time-out Interrupt Mask */
#define US_IMR_TXEMPTY (0x1 << 9) /**< \brief (US_IMR) TXEMPTY Interrupt Mask */
#define US_IMR_ITER__UNRE (0x1 << 10) /**< \brief (US_IMR) Iteration or SPI Underrun Error Interrupt Enable */
#define US_IMR_TXBUFE (0x1 << 11) /**< \brief (US_IMR) Buffer Empty Interrupt Mask */
#define US_IMR_RXBUFF (0x1 << 12) /**< \brief (US_IMR) Buffer Full Interrupt Mask */
#define US_IMR_NACK (0x1 << 13) /**< \brief (US_IMR) Non Acknowledge  Interrupt Mask */
#define US_IMR_CTSIC (0x1 << 19) /**< \brief (US_IMR) Clear to Send Input Change Interrupt Mask */
#define US_IMR_MANE (0x1 << 24) /**< \brief (US_IMR) Manchester Error Interrupt Mask */
/* -------- US_CSR : (USART Offset: 0x0014) Channel Status Register -------- */
#define US_CSR_RXRDY (0x1 << 0) /**< \brief (US_CSR) Receiver Ready */
#define US_CSR_TXRDY (0x1 << 1) /**< \brief (US_CSR) Transmitter Ready */
#define US_CSR_RXBRK (0x1 << 2) /**< \brief (US_CSR) Break Received/End of Break */
#define US_CSR_ENDRX (0x1 << 3) /**< \brief (US_CSR) End of Receiver Transfer */
#define US_CSR_ENDTX (0x1 << 4) /**< \brief (US_CSR) End of Transmitter Transfer */
#define US_CSR_OVRE (0x1 << 5) /**< \brief (US_CSR) Overrun Error */
#define US_CSR_FRAME (0x1 << 6) /**< \brief (US_CSR) Framing Error */
#define US_CSR_PARE (0x1 << 7) /**< \brief (US_CSR) Parity Error */
#define US_CSR_TIMEOUT (0x1 << 8) /**< \brief (US_CSR) Receiver Time-out */
#define US_CSR_TXEMPTY (0x1 << 9) /**< \brief (US_CSR) Transmitter Empty */
#define US_CSR_ITER__UNRE (0x1 << 10) /**< \brief (US_CSR) Max number of Repetitions Reached or SPI Underrun Error */
#define US_CSR_TXBUFE (0x1 << 11) /**< \brief (US_CSR) Transmission Buffer Empty */
#define US_CSR_RXBUFF (0x1 << 12) /**< \brief (US_CSR) Reception Buffer Full */
#define US_CSR_NACK (0x1 << 13) /**< \brief (US_CSR)  */
#define US_CSR_CTSIC (0x1 << 19) /**< \brief (US_CSR) Clear to Send Input Change Flag */
#define US_CSR_CTS (0x1 << 23) /**< \brief (US_CSR) Image of CTS Input */
#define US_CSR_MANERR (0x1 << 24) /**< \brief (US_CSR) Manchester Error */
/* -------- US_RHR : (USART Offset: 0x0018) Receiver Holding Register -------- */
#define US_RHR_RXCHR (0x1ff << 0) /**< \brief (US_RHR) Received Character */
#define US_RHR_RXSYNH (0x1 << 15) /**< \brief (US_RHR) Received Sync */
/* -------- US_THR : (USART Offset: 0x001C) Transmitter Holding Register -------- */
#define US_THR_TXCHR (0x1ff << 0) /**< \brief (US_THR) Character to be Transmitted */
#define US_THR_TXSYNH (0x1 << 15) /**< \brief (US_THR) Sync Field to be transmitted */
/* -------- US_BRGR : (USART Offset: 0x0020) Baud Rate Generator Register -------- */
#define US_BRGR_CD (0xffff << 0) /**< \brief (US_BRGR) Clock Divider */
#define US_BRGR_FP (0x7 << 16) /**< \brief (US_BRGR) Fractional Part */
/* -------- US_RTOR : (USART Offset: 0x0024) Receiver Time-out Register -------- */
#define US_RTOR_TO (0xffff << 0) /**< \brief (US_RTOR) Time-out Value */
/* -------- US_TTGR : (USART Offset: 0x0028) Transmitter Timeguard Register -------- */
#define US_TTGR_TG (0xff << 0) /**< \brief (US_TTGR) Timeguard Value */
/* -------- US_FIDI : (USART Offset: 0x0040) FI DI Ratio Register -------- */
#define US_FIDI_FI_DI_RATIO (0x7ff << 0) /**< \brief (US_FIDI) FI Over DI Ratio Value */
/* -------- US_NER : (USART Offset: 0x0044) Number of Errors Register -------- */
#define US_NER_NB_ERRORS (0xff << 0) /**< \brief (US_NER) Number of Errors */
/* -------- US_IF : (USART Offset: 0x004C) IrDA Filter Register -------- */
#define US_IF_IRDA_FILTER (0xff << 0) /**< \brief (US_IF) IrDA Filter */
/* -------- US_MAN : (USART Offset: 0x0050) Manchester Encoder Decoder Register -------- */
#define US_MAN_TX_PL (0xf << 0) /**< \brief (US_MAN) Transmitter Preamble Length */
#define US_MAN_TX_PP (0x3 << 8) /**< \brief (US_MAN) Transmitter Preamble Pattern */
#define US_MAN_TX_MPOL (0x1 << 12) /**< \brief (US_MAN) Transmitter Manchester Polarity */
#define US_MAN_RX_PL (0xf << 16) /**< \brief (US_MAN) Receiver Preamble Length */
#define US_MAN_RX_PP (0x3 << 24) /**< \brief (US_MAN) Receiver Preamble Pattern detected */
#define US_MAN_RX_MPOL (0x1 << 28) /**< \brief (US_MAN) Receiver Manchester Polarity */
#define US_MAN_STUCKTO1 (0x1 << 29) /**< \brief (US_MAN)  */
#define US_MAN_DRIFT (0x1 << 30) /**< \brief (US_MAN) Drift compensation */
/* -------- US_WPMR : (USART Offset: 0xE4) Write Protect Mode Register -------- */
#define US_WPMR_WPEN (0x1 << 0) /**< \brief (US_WPMR) Write Protect Enable */
#define US_WPMR_WPKEY (0xffffff << 8) /**< \brief (US_WPMR) Write Protect KEY */
/* -------- US_WPSR : (USART Offset: 0xE8) Write Protect Status Register -------- */
#define US_WPSR_WPVS (0x1 << 0) /**< \brief (US_WPSR) Write Protect Violation Status */
#define US_WPSR_WPVSRC (0xffff << 8) /**< \brief (US_WPSR) Write Protect Violation Source */
/* -------- US_VERSION : (USART Offset: 0xFC) Version Register -------- */
#define US_VERSION_VERSION (0xfff << 0) /**< \brief (US_VERSION)  */
#define US_VERSION_MFN (0x7 << 16) /**< \brief (US_VERSION)  */
/* -------- US_RPR : (USART Offset: 0x100) Receive Pointer Register -------- */
#define US_RPR_RXPTR (0xffffffff << 0) /**< \brief (US_RPR) Receive Pointer Register */
/* -------- US_RCR : (USART Offset: 0x104) Receive Counter Register -------- */
#define US_RCR_RXCTR (0xffff << 0) /**< \brief (US_RCR) Receive Counter Register */
/* -------- US_TPR : (USART Offset: 0x108) Transmit Pointer Register -------- */
#define US_TPR_TXPTR (0xffffffff << 0) /**< \brief (US_TPR) Transmit Counter Register */
/* -------- US_TCR : (USART Offset: 0x10C) Transmit Counter Register -------- */
#define US_TCR_TXCTR (0xffff << 0) /**< \brief (US_TCR) Transmit Counter Register */
/* -------- US_RNPR : (USART Offset: 0x110) Receive Next Pointer Register -------- */
#define US_RNPR_RXNPTR (0xffffffff << 0) /**< \brief (US_RNPR) Receive Next Pointer */
/* -------- US_RNCR : (USART Offset: 0x114) Receive Next Counter Register -------- */
#define US_RNCR_RXNCTR (0xffff << 0) /**< \brief (US_RNCR) Receive Next Counter */
/* -------- US_TNPR : (USART Offset: 0x118) Transmit Next Pointer Register -------- */
#define US_TNPR_TXNPTR (0xffffffff << 0) /**< \brief (US_TNPR) Transmit Next Pointer */
/* -------- US_TNCR : (USART Offset: 0x11C) Transmit Next Counter Register -------- */
#define US_TNCR_TXNCTR (0xffff << 0) /**< \brief (US_TNCR) Transmit Counter Next */
/* -------- US_PTCR : (USART Offset: 0x120) Transfer Control Register -------- */
#define US_PTCR_RXTEN (0x1 << 0) /**< \brief (US_PTCR) Receiver Transfer Enable */
#define US_PTCR_RXTDIS (0x1 << 1) /**< \brief (US_PTCR) Receiver Transfer Disable */
#define US_PTCR_TXTEN (0x1 << 8) /**< \brief (US_PTCR) Transmitter Transfer Enable */
#define US_PTCR_TXTDIS (0x1 << 9) /**< \brief (US_PTCR) Transmitter Transfer Disable */
/* -------- US_PTSR : (USART Offset: 0x124) Transfer Status Register -------- */
#define US_PTSR_RXTEN (0x1 << 0) /**< \brief (US_PTSR) Receiver Transfer Enable */
#define US_PTSR_TXTEN (0x1 << 8) /**< \brief (US_PTSR) Transmitter Transfer Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Watchdog Timer */
/* ============================================================================= */
/** \addtogroup AT91SAM3U_WDT Watchdog Timer */
/*@{*/

#ifndef __ASSEMBLY__
/** \brief Wdt hardware registers */
typedef struct {
  WoReg WDT_CR; /**< \brief (Wdt Offset: 0x00) Control Register */
  RwReg WDT_MR; /**< \brief (Wdt Offset: 0x04) Mode Register */
  RoReg WDT_SR; /**< \brief (Wdt Offset: 0x08) Status Register */
} Wdt;
#endif /* __ASSEMBLY__ */
/* -------- WDT_CR : (WDT Offset: 0x00) Control Register -------- */
#define WDT_CR_WDRSTT (0x1 << 0) /**< \brief (WDT_CR) Watchdog Restart */
#define WDT_CR_KEY (0xff << 24) /**< \brief (WDT_CR) Password */
/* -------- WDT_MR : (WDT Offset: 0x04) Mode Register -------- */
#define WDT_MR_WDV (0xfff << 0) /**< \brief (WDT_MR) Watchdog Counter Value */
#define WDT_MR_WDFIEN (0x1 << 12) /**< \brief (WDT_MR) Watchdog Fault Interrupt Enable */
#define WDT_MR_WDRSTEN (0x1 << 13) /**< \brief (WDT_MR) Watchdog Reset Enable */
#define WDT_MR_WDRPROC (0x1 << 14) /**< \brief (WDT_MR) Watchdog Reset Processor */
#define WDT_MR_WDDIS (0x1 << 15) /**< \brief (WDT_MR) Watchdog Disable */
#define WDT_MR_WDD (0xfff << 16) /**< \brief (WDT_MR) Watchdog Delta Value */
#define WDT_MR_WDDBGHLT (0x1 << 28) /**< \brief (WDT_MR) Watchdog Debug Halt */
#define WDT_MR_WDIDLEHLT (0x1 << 29) /**< \brief (WDT_MR) Watchdog Idle Halt */
/* -------- WDT_SR : (WDT Offset: 0x08) Status Register -------- */
#define WDT_SR_WDUNF (0x1 << 0) /**< \brief (WDT_SR) Watchdog Underflow */
#define WDT_SR_WDERR (0x1 << 1) /**< \brief (WDT_SR) Watchdog Error */

/*@}*/

/*@}*/

/* ***************************************************************************** */
/*   REGISTER ACCESS DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_reg Registers Access Definitions */
/*@{*/

/* ========== Register definition for HSMCI peripheral ========== */
#define REG_HSMCI_CR          REG_ACCESS(WoReg, 0x40000000U) /**< \brief (HSMCI) Control Register */
#define REG_HSMCI_MR          REG_ACCESS(RwReg, 0x40000004U) /**< \brief (HSMCI) Mode Register */
#define REG_HSMCI_DTOR        REG_ACCESS(RwReg, 0x40000008U) /**< \brief (HSMCI) Data Timeout Register */
#define REG_HSMCI_SDCR        REG_ACCESS(RwReg, 0x4000000CU) /**< \brief (HSMCI) SD/SDIO Card Register */
#define REG_HSMCI_ARGR        REG_ACCESS(RwReg, 0x40000010U) /**< \brief (HSMCI) Argument Register */
#define REG_HSMCI_CMDR        REG_ACCESS(WoReg, 0x40000014U) /**< \brief (HSMCI) Command Register */
#define REG_HSMCI_BLKR        REG_ACCESS(RwReg, 0x40000018U) /**< \brief (HSMCI) Block Register */
#define REG_HSMCI_CSTOR       REG_ACCESS(RwReg, 0x4000001CU) /**< \brief (HSMCI) Completion Signal Timeout Register */
#define REG_HSMCI_RSPR        REG_ACCESS(RoReg, 0x40000020U) /**< \brief (HSMCI) Response Register */
#define REG_HSMCI_RDR         REG_ACCESS(RoReg, 0x40000030U) /**< \brief (HSMCI) Receive Data Register */
#define REG_HSMCI_TDR         REG_ACCESS(WoReg, 0x40000034U) /**< \brief (HSMCI) Transmit Data Register */
#define REG_HSMCI_SR          REG_ACCESS(RoReg, 0x40000040U) /**< \brief (HSMCI) Status Register */
#define REG_HSMCI_IER         REG_ACCESS(WoReg, 0x40000044U) /**< \brief (HSMCI) Interrupt Enable Register */
#define REG_HSMCI_IDR         REG_ACCESS(WoReg, 0x40000048U) /**< \brief (HSMCI) Interrupt Disable Register */
#define REG_HSMCI_IMR         REG_ACCESS(RoReg, 0x4000004CU) /**< \brief (HSMCI) Interrupt Mask Register */
#define REG_HSMCI_DMA         REG_ACCESS(RwReg, 0x40000050U) /**< \brief (HSMCI) DMA Configuration Register */
#define REG_HSMCI_CFG         REG_ACCESS(RwReg, 0x40000054U) /**< \brief (HSMCI) Configuration Register */
#define REG_HSMCI_WPMR        REG_ACCESS(RwReg, 0x400000E4U) /**< \brief (HSMCI) Write Protection Mode Register */
#define REG_HSMCI_WPSR        REG_ACCESS(RoReg, 0x400000E8U) /**< \brief (HSMCI) Write Protection Status Register */
/* ========== Register definition for SSC peripheral ========== */
#define REG_SSC_CR            REG_ACCESS(WoReg, 0x40004000U) /**< \brief (SSC) Control Register */
#define REG_SSC_CMR           REG_ACCESS(RwReg, 0x40004004U) /**< \brief (SSC) Clock Mode Register */
#define REG_SSC_RCMR          REG_ACCESS(RwReg, 0x40004010U) /**< \brief (SSC) Receive Clock Mode Register */
#define REG_SSC_RFMR          REG_ACCESS(RwReg, 0x40004014U) /**< \brief (SSC) Receive Frame Mode Register */
#define REG_SSC_TCMR          REG_ACCESS(RwReg, 0x40004018U) /**< \brief (SSC) Transmit Clock Mode Register */
#define REG_SSC_TFMR          REG_ACCESS(RwReg, 0x4000401CU) /**< \brief (SSC) Transmit Frame Mode Register */
#define REG_SSC_RHR           REG_ACCESS(RoReg, 0x40004020U) /**< \brief (SSC) Receive Holding Register */
#define REG_SSC_THR           REG_ACCESS(WoReg, 0x40004024U) /**< \brief (SSC) Transmit Holding Register */
#define REG_SSC_RSHR          REG_ACCESS(RoReg, 0x40004030U) /**< \brief (SSC) Receive Sync. Holding Register */
#define REG_SSC_TSHR          REG_ACCESS(RwReg, 0x40004034U) /**< \brief (SSC) Transmit Sync. Holding Register */
#define REG_SSC_RC0R          REG_ACCESS(RwReg, 0x40004038U) /**< \brief (SSC) Receive Compare 0 Register */
#define REG_SSC_RC1R          REG_ACCESS(RwReg, 0x4000403CU) /**< \brief (SSC) Receive Compare 1 Register */
#define REG_SSC_SR            REG_ACCESS(RoReg, 0x40004040U) /**< \brief (SSC) Status Register */
#define REG_SSC_IER           REG_ACCESS(WoReg, 0x40004044U) /**< \brief (SSC) Interrupt Enable Register */
#define REG_SSC_IDR           REG_ACCESS(WoReg, 0x40004048U) /**< \brief (SSC) Interrupt Disable Register */
#define REG_SSC_IMR           REG_ACCESS(RoReg, 0x4000404CU) /**< \brief (SSC) Interrupt Mask Register */
#define REG_SSC_WPMR          REG_ACCESS(RwReg, 0x400040E4U) /**< \brief (SSC) Write Protect Mode Register */
#define REG_SSC_WPSR          REG_ACCESS(RoReg, 0x400040E8U) /**< \brief (SSC) Write Protect Status Register */
/* ========== Register definition for SPI peripheral ========== */
#define REG_SPI_CR            REG_ACCESS(WoReg, 0x40008000U) /**< \brief (SPI) Control Register */
#define REG_SPI_MR            REG_ACCESS(RwReg, 0x40008004U) /**< \brief (SPI) Mode Register */
#define REG_SPI_RDR           REG_ACCESS(RoReg, 0x40008008U) /**< \brief (SPI) Receive Data Register */
#define REG_SPI_TDR           REG_ACCESS(WoReg, 0x4000800CU) /**< \brief (SPI) Transmit Data Register */
#define REG_SPI_SR            REG_ACCESS(RoReg, 0x40008010U) /**< \brief (SPI) Status Register */
#define REG_SPI_IER           REG_ACCESS(WoReg, 0x40008014U) /**< \brief (SPI) Interrupt Enable Register */
#define REG_SPI_IDR           REG_ACCESS(WoReg, 0x40008018U) /**< \brief (SPI) Interrupt Disable Register */
#define REG_SPI_IMR           REG_ACCESS(RoReg, 0x4000801CU) /**< \brief (SPI) Interrupt Mask Register */
#define REG_SPI_CSR           REG_ACCESS(RwReg, 0x40008030U) /**< \brief (SPI) Chip Select Register */
#define REG_SPI_WPCR          REG_ACCESS(RwReg, 0x400080E4U) /**< \brief (SPI) Write Protection Control Register */
#define REG_SPI_WPSR          REG_ACCESS(RoReg, 0x400080E8U) /**< \brief (SPI) Write Protection Status Register */
/* ========== Register definition for TC0 peripheral ========== */
#define REG_TC0_CCR0          REG_ACCESS(WoReg, 0x40080000U) /**< \brief (TC0) Channel Control Register (channel = 0) */
#define REG_TC0_CMR0          REG_ACCESS(RwReg, 0x40080004U) /**< \brief (TC0) Channel Mode Register (channel = 0) */
#define REG_TC0_CV0           REG_ACCESS(RoReg, 0x40080010U) /**< \brief (TC0) Counter Value (channel = 0) */
#define REG_TC0_RA0           REG_ACCESS(RwReg, 0x40080014U) /**< \brief (TC0) Register A (channel = 0) */
#define REG_TC0_RB0           REG_ACCESS(RwReg, 0x40080018U) /**< \brief (TC0) Register B (channel = 0) */
#define REG_TC0_RC0           REG_ACCESS(RwReg, 0x4008001CU) /**< \brief (TC0) Register C (channel = 0) */
#define REG_TC0_SR0           REG_ACCESS(RoReg, 0x40080020U) /**< \brief (TC0) Status Register (channel = 0) */
#define REG_TC0_IER0          REG_ACCESS(WoReg, 0x40080024U) /**< \brief (TC0) Interrupt Enable Register (channel = 0) */
#define REG_TC0_IDR0          REG_ACCESS(WoReg, 0x40080028U) /**< \brief (TC0) Interrupt Disable Register (channel = 0) */
#define REG_TC0_IMR0          REG_ACCESS(RoReg, 0x4008002CU) /**< \brief (TC0) Interrupt Mask Register (channel = 0) */
#define REG_TC0_CCR1          REG_ACCESS(WoReg, 0x40080040U) /**< \brief (TC0) Channel Control Register (channel = 1) */
#define REG_TC0_CMR1          REG_ACCESS(RwReg, 0x40080044U) /**< \brief (TC0) Channel Mode Register (channel = 1) */
#define REG_TC0_CV1           REG_ACCESS(RoReg, 0x40080050U) /**< \brief (TC0) Counter Value (channel = 1) */
#define REG_TC0_RA1           REG_ACCESS(RwReg, 0x40080054U) /**< \brief (TC0) Register A (channel = 1) */
#define REG_TC0_RB1           REG_ACCESS(RwReg, 0x40080058U) /**< \brief (TC0) Register B (channel = 1) */
#define REG_TC0_RC1           REG_ACCESS(RwReg, 0x4008005CU) /**< \brief (TC0) Register C (channel = 1) */
#define REG_TC0_SR1           REG_ACCESS(RoReg, 0x40080060U) /**< \brief (TC0) Status Register (channel = 1) */
#define REG_TC0_IER1          REG_ACCESS(WoReg, 0x40080064U) /**< \brief (TC0) Interrupt Enable Register (channel = 1) */
#define REG_TC0_IDR1          REG_ACCESS(WoReg, 0x40080068U) /**< \brief (TC0) Interrupt Disable Register (channel = 1) */
#define REG_TC0_IMR1          REG_ACCESS(RoReg, 0x4008006CU) /**< \brief (TC0) Interrupt Mask Register (channel = 1) */
#define REG_TC0_CCR2          REG_ACCESS(WoReg, 0x40080080U) /**< \brief (TC0) Channel Control Register (channel = 2) */
#define REG_TC0_CMR2          REG_ACCESS(RwReg, 0x40080084U) /**< \brief (TC0) Channel Mode Register (channel = 2) */
#define REG_TC0_CV2           REG_ACCESS(RoReg, 0x40080090U) /**< \brief (TC0) Counter Value (channel = 2) */
#define REG_TC0_RA2           REG_ACCESS(RwReg, 0x40080094U) /**< \brief (TC0) Register A (channel = 2) */
#define REG_TC0_RB2           REG_ACCESS(RwReg, 0x40080098U) /**< \brief (TC0) Register B (channel = 2) */
#define REG_TC0_RC2           REG_ACCESS(RwReg, 0x4008009CU) /**< \brief (TC0) Register C (channel = 2) */
#define REG_TC0_SR2           REG_ACCESS(RoReg, 0x400800A0U) /**< \brief (TC0) Status Register (channel = 2) */
#define REG_TC0_IER2          REG_ACCESS(WoReg, 0x400800A4U) /**< \brief (TC0) Interrupt Enable Register (channel = 2) */
#define REG_TC0_IDR2          REG_ACCESS(WoReg, 0x400800A8U) /**< \brief (TC0) Interrupt Disable Register (channel = 2) */
#define REG_TC0_IMR2          REG_ACCESS(RoReg, 0x400800ACU) /**< \brief (TC0) Interrupt Mask Register (channel = 2) */
#define REG_TC0_BCR           REG_ACCESS(WoReg, 0x400800C0U) /**< \brief (TC0) Block Control Register */
#define REG_TC0_BMR           REG_ACCESS(RwReg, 0x400800C4U) /**< \brief (TC0) Block Mode Register */
#define REG_TC0_QIER          REG_ACCESS(WoReg, 0x400800C8U) /**< \brief (TC0) QDEC Interrupt Enable Register */
#define REG_TC0_QIDR          REG_ACCESS(WoReg, 0x400800CCU) /**< \brief (TC0) QDEC Interrupt Disable Register */
#define REG_TC0_QIMR          REG_ACCESS(RoReg, 0x400800D0U) /**< \brief (TC0) QDEC Interrupt Mask Register */
#define REG_TC0_QISR          REG_ACCESS(RoReg, 0x400800D4U) /**< \brief (TC0) QDEC Interrupt Status Register */
#define REG_TC0_VER           REG_ACCESS(RoReg, 0x400800FCU) /**< \brief (TC0) Version Register */
/* ========== Register definition for TWI0 peripheral ========== */
#define REG_TWI0_CR           REG_ACCESS(WoReg, 0x40084000U) /**< \brief (TWI0) Control Register */
#define REG_TWI0_MMR          REG_ACCESS(RwReg, 0x40084004U) /**< \brief (TWI0) Master Mode Register */
#define REG_TWI0_SMR          REG_ACCESS(RwReg, 0x40084008U) /**< \brief (TWI0) Slave Mode Register */
#define REG_TWI0_IADR         REG_ACCESS(RwReg, 0x4008400CU) /**< \brief (TWI0) Internal Address Register */
#define REG_TWI0_CWGR         REG_ACCESS(RwReg, 0x40084010U) /**< \brief (TWI0) Clock Waveform Generator Register */
#define REG_TWI0_SR           REG_ACCESS(RoReg, 0x40084020U) /**< \brief (TWI0) Status Register */
#define REG_TWI0_IER          REG_ACCESS(WoReg, 0x40084024U) /**< \brief (TWI0) Interrupt Enable Register */
#define REG_TWI0_IDR          REG_ACCESS(WoReg, 0x40084028U) /**< \brief (TWI0) Interrupt Disable Register */
#define REG_TWI0_IMR          REG_ACCESS(RoReg, 0x4008402CU) /**< \brief (TWI0) Interrupt Mask Register */
#define REG_TWI0_RHR          REG_ACCESS(RoReg, 0x40084030U) /**< \brief (TWI0) Receive Holding Register */
#define REG_TWI0_THR          REG_ACCESS(WoReg, 0x40084034U) /**< \brief (TWI0) Transmit Holding Register */
#define REG_TWI0_RPR          REG_ACCESS(RwReg, 0x40084100U) /**< \brief (TWI0) Receive Pointer Register */
#define REG_TWI0_RCR          REG_ACCESS(RwReg, 0x40084104U) /**< \brief (TWI0) Receive Counter Register */
#define REG_TWI0_TPR          REG_ACCESS(RwReg, 0x40084108U) /**< \brief (TWI0) Transmit Pointer Register */
#define REG_TWI0_TCR          REG_ACCESS(RwReg, 0x4008410CU) /**< \brief (TWI0) Transmit Counter Register */
#define REG_TWI0_RNPR         REG_ACCESS(RwReg, 0x40084110U) /**< \brief (TWI0) Receive Next Pointer Register */
#define REG_TWI0_RNCR         REG_ACCESS(RwReg, 0x40084114U) /**< \brief (TWI0) Receive Next Counter Register */
#define REG_TWI0_TNPR         REG_ACCESS(RwReg, 0x40084118U) /**< \brief (TWI0) Transmit Next Pointer Register */
#define REG_TWI0_TNCR         REG_ACCESS(RwReg, 0x4008411CU) /**< \brief (TWI0) Transmit Next Counter Register */
#define REG_TWI0_PTCR         REG_ACCESS(WoReg, 0x40084120U) /**< \brief (TWI0) Transfer Control Register */
#define REG_TWI0_PTSR         REG_ACCESS(RoReg, 0x40084124U) /**< \brief (TWI0) Transfer Status Register */
/* ========== Register definition for TWI1 peripheral ========== */
#define REG_TWI1_CR           REG_ACCESS(WoReg, 0x40088000U) /**< \brief (TWI1) Control Register */
#define REG_TWI1_MMR          REG_ACCESS(RwReg, 0x40088004U) /**< \brief (TWI1) Master Mode Register */
#define REG_TWI1_SMR          REG_ACCESS(RwReg, 0x40088008U) /**< \brief (TWI1) Slave Mode Register */
#define REG_TWI1_IADR         REG_ACCESS(RwReg, 0x4008800CU) /**< \brief (TWI1) Internal Address Register */
#define REG_TWI1_CWGR         REG_ACCESS(RwReg, 0x40088010U) /**< \brief (TWI1) Clock Waveform Generator Register */
#define REG_TWI1_SR           REG_ACCESS(RoReg, 0x40088020U) /**< \brief (TWI1) Status Register */
#define REG_TWI1_IER          REG_ACCESS(WoReg, 0x40088024U) /**< \brief (TWI1) Interrupt Enable Register */
#define REG_TWI1_IDR          REG_ACCESS(WoReg, 0x40088028U) /**< \brief (TWI1) Interrupt Disable Register */
#define REG_TWI1_IMR          REG_ACCESS(RoReg, 0x4008802CU) /**< \brief (TWI1) Interrupt Mask Register */
#define REG_TWI1_RHR          REG_ACCESS(RoReg, 0x40088030U) /**< \brief (TWI1) Receive Holding Register */
#define REG_TWI1_THR          REG_ACCESS(WoReg, 0x40088034U) /**< \brief (TWI1) Transmit Holding Register */
#define REG_TWI1_RPR          REG_ACCESS(RwReg, 0x40088100U) /**< \brief (TWI1) Receive Pointer Register */
#define REG_TWI1_RCR          REG_ACCESS(RwReg, 0x40088104U) /**< \brief (TWI1) Receive Counter Register */
#define REG_TWI1_TPR          REG_ACCESS(RwReg, 0x40088108U) /**< \brief (TWI1) Transmit Pointer Register */
#define REG_TWI1_TCR          REG_ACCESS(RwReg, 0x4008810CU) /**< \brief (TWI1) Transmit Counter Register */
#define REG_TWI1_RNPR         REG_ACCESS(RwReg, 0x40088110U) /**< \brief (TWI1) Receive Next Pointer Register */
#define REG_TWI1_RNCR         REG_ACCESS(RwReg, 0x40088114U) /**< \brief (TWI1) Receive Next Counter Register */
#define REG_TWI1_TNPR         REG_ACCESS(RwReg, 0x40088118U) /**< \brief (TWI1) Transmit Next Pointer Register */
#define REG_TWI1_TNCR         REG_ACCESS(RwReg, 0x4008811CU) /**< \brief (TWI1) Transmit Next Counter Register */
#define REG_TWI1_PTCR         REG_ACCESS(WoReg, 0x40088120U) /**< \brief (TWI1) Transfer Control Register */
#define REG_TWI1_PTSR         REG_ACCESS(RoReg, 0x40088124U) /**< \brief (TWI1) Transfer Status Register */
/* ========== Register definition for PWM peripheral ========== */
#define REG_PWM_CLK           REG_ACCESS(RwReg, 0x4008C000U) /**< \brief (PWM) PWM Clock Register */
#define REG_PWM_ENA           REG_ACCESS(WoReg, 0x4008C004U) /**< \brief (PWM) PWM Enable Register */
#define REG_PWM_DIS           REG_ACCESS(WoReg, 0x4008C008U) /**< \brief (PWM) PWM Disable Register */
#define REG_PWM_SR            REG_ACCESS(RoReg, 0x4008C00CU) /**< \brief (PWM) PWM Status Register */
#define REG_PWM_IER1          REG_ACCESS(WoReg, 0x4008C010U) /**< \brief (PWM) PWM Interrupt Enable Register 1 */
#define REG_PWM_IDR1          REG_ACCESS(WoReg, 0x4008C014U) /**< \brief (PWM) PWM Interrupt Disable Register 1 */
#define REG_PWM_IMR1          REG_ACCESS(RoReg, 0x4008C018U) /**< \brief (PWM) PWM Interrupt Mask Register 1 */
#define REG_PWM_ISR1          REG_ACCESS(RoReg, 0x4008C01CU) /**< \brief (PWM) PWM Interrupt Status Register 1 */
#define REG_PWM_SCM           REG_ACCESS(RwReg, 0x4008C020U) /**< \brief (PWM) PWM Sync Channels Mode Register */
#define REG_PWM_SCUC          REG_ACCESS(RwReg, 0x4008C028U) /**< \brief (PWM) PWM Sync Channels Update Control Register */
#define REG_PWM_SCUP          REG_ACCESS(RwReg, 0x4008C02CU) /**< \brief (PWM) PWM Sync Channels Update Period Register */
#define REG_PWM_SCUPUPD       REG_ACCESS(WoReg, 0x4008C030U) /**< \brief (PWM) PWM Sync Channels Update Period Update Register */
#define REG_PWM_IER2          REG_ACCESS(WoReg, 0x4008C034U) /**< \brief (PWM) PWM Interrupt Enable Register 2 */
#define REG_PWM_IDR2          REG_ACCESS(WoReg, 0x4008C038U) /**< \brief (PWM) PWM Interrupt Disable Register 2 */
#define REG_PWM_IMR2          REG_ACCESS(RoReg, 0x4008C03CU) /**< \brief (PWM) PWM Interrupt Mask Register 2 */
#define REG_PWM_ISR2          REG_ACCESS(RoReg, 0x4008C040U) /**< \brief (PWM) PWM Interrupt Status Register 2 */
#define REG_PWM_OOV           REG_ACCESS(RwReg, 0x4008C044U) /**< \brief (PWM) PWM Output Override Value Register */
#define REG_PWM_OS            REG_ACCESS(RwReg, 0x4008C048U) /**< \brief (PWM) PWM Output Selection Register */
#define REG_PWM_OSS           REG_ACCESS(WoReg, 0x4008C04CU) /**< \brief (PWM) PWM Output Selection Set Register */
#define REG_PWM_OSC           REG_ACCESS(WoReg, 0x4008C050U) /**< \brief (PWM) PWM Output Selection Clear Register */
#define REG_PWM_OSSUPD        REG_ACCESS(WoReg, 0x4008C054U) /**< \brief (PWM) PWM Output Selection Set Update Register */
#define REG_PWM_OSCUPD        REG_ACCESS(WoReg, 0x4008C058U) /**< \brief (PWM) PWM Output Selection Clear Update Register */
#define REG_PWM_FMR           REG_ACCESS(RwReg, 0x4008C05CU) /**< \brief (PWM) PWM Fault Mode Register */
#define REG_PWM_FSR           REG_ACCESS(RoReg, 0x4008C060U) /**< \brief (PWM) PWM Fault Status Register */
#define REG_PWM_FCR           REG_ACCESS(WoReg, 0x4008C064U) /**< \brief (PWM) PWM Fault Clear Register */
#define REG_PWM_FPV           REG_ACCESS(RwReg, 0x4008C068U) /**< \brief (PWM) PWM Fault Protection Value Register */
#define REG_PWM_FPE           REG_ACCESS(RwReg, 0x4008C06CU) /**< \brief (PWM) PWM Fault Protection Enable Register */
#define REG_PWM_ELxMR         REG_ACCESS(RwReg, 0x4008C07CU) /**< \brief (PWM) PWM Event Line 0 Mode Register */
#define REG_PWM_WPCR          REG_ACCESS(WoReg, 0x4008C0E4U) /**< \brief (PWM) PWM Write Protect Control Register */
#define REG_PWM_WPSR          REG_ACCESS(RoReg, 0x4008C0E8U) /**< \brief (PWM) PWM Write Protect Status Register */
#define REG_PWM_RPR           REG_ACCESS(RwReg, 0x4008C100U) /**< \brief (PWM) Receive Pointer Register */
#define REG_PWM_RCR           REG_ACCESS(RwReg, 0x4008C104U) /**< \brief (PWM) Receive Counter Register */
#define REG_PWM_TPR           REG_ACCESS(RwReg, 0x4008C108U) /**< \brief (PWM) Transmit Pointer Register */
#define REG_PWM_TCR           REG_ACCESS(RwReg, 0x4008C10CU) /**< \brief (PWM) Transmit Counter Register */
#define REG_PWM_RNPR          REG_ACCESS(RwReg, 0x4008C110U) /**< \brief (PWM) Receive Next Pointer Register */
#define REG_PWM_RNCR          REG_ACCESS(RwReg, 0x4008C114U) /**< \brief (PWM) Receive Next Counter Register */
#define REG_PWM_TNPR          REG_ACCESS(RwReg, 0x4008C118U) /**< \brief (PWM) Transmit Next Pointer Register */
#define REG_PWM_TNCR          REG_ACCESS(RwReg, 0x4008C11CU) /**< \brief (PWM) Transmit Next Counter Register */
#define REG_PWM_PTCR          REG_ACCESS(WoReg, 0x4008C120U) /**< \brief (PWM) Transfer Control Register */
#define REG_PWM_PTSR          REG_ACCESS(RoReg, 0x4008C124U) /**< \brief (PWM) Transfer Status Register */
#define REG_PWM_CMP0V         REG_ACCESS(RwReg, 0x4008C130U) /**< \brief (PWM) PWM Comparison 0 Value Register */
#define REG_PWM_CMP0VUPD      REG_ACCESS(WoReg, 0x4008C134U) /**< \brief (PWM) PWM Comparison 0 Value Update Register */
#define REG_PWM_CMP0M         REG_ACCESS(RwReg, 0x4008C138U) /**< \brief (PWM) PWM Comparison 0 Mode Register */
#define REG_PWM_CMP0MUPD      REG_ACCESS(WoReg, 0x4008C13CU) /**< \brief (PWM) PWM Comparison 0 Mode Update Register */
#define REG_PWM_CMP1V         REG_ACCESS(RwReg, 0x4008C140U) /**< \brief (PWM) PWM Comparison 1 Value Register */
#define REG_PWM_CMP1VUPD      REG_ACCESS(WoReg, 0x4008C144U) /**< \brief (PWM) PWM Comparison 1 Value Update Register */
#define REG_PWM_CMP1M         REG_ACCESS(RwReg, 0x4008C148U) /**< \brief (PWM) PWM Comparison 1 Mode Register */
#define REG_PWM_CMP1MUPD      REG_ACCESS(WoReg, 0x4008C14CU) /**< \brief (PWM) PWM Comparison 1 Mode Update Register */
#define REG_PWM_CMP2V         REG_ACCESS(RwReg, 0x4008C150U) /**< \brief (PWM) PWM Comparison 2 Value Register */
#define REG_PWM_CMP2VUPD      REG_ACCESS(WoReg, 0x4008C154U) /**< \brief (PWM) PWM Comparison 2 Value Update Register */
#define REG_PWM_CMP2M         REG_ACCESS(RwReg, 0x4008C158U) /**< \brief (PWM) PWM Comparison 2 Mode Register */
#define REG_PWM_CMP2MUPD      REG_ACCESS(WoReg, 0x4008C15CU) /**< \brief (PWM) PWM Comparison 2 Mode Update Register */
#define REG_PWM_CMP3V         REG_ACCESS(RwReg, 0x4008C160U) /**< \brief (PWM) PWM Comparison 3 Value Register */
#define REG_PWM_CMP3VUPD      REG_ACCESS(WoReg, 0x4008C164U) /**< \brief (PWM) PWM Comparison 3 Value Update Register */
#define REG_PWM_CMP3M         REG_ACCESS(RwReg, 0x4008C168U) /**< \brief (PWM) PWM Comparison 3 Mode Register */
#define REG_PWM_CMP3MUPD      REG_ACCESS(WoReg, 0x4008C16CU) /**< \brief (PWM) PWM Comparison 3 Mode Update Register */
#define REG_PWM_CMP4V         REG_ACCESS(RwReg, 0x4008C170U) /**< \brief (PWM) PWM Comparison 4 Value Register */
#define REG_PWM_CMP4VUPD      REG_ACCESS(WoReg, 0x4008C174U) /**< \brief (PWM) PWM Comparison 4 Value Update Register */
#define REG_PWM_CMP4M         REG_ACCESS(RwReg, 0x4008C178U) /**< \brief (PWM) PWM Comparison 4 Mode Register */
#define REG_PWM_CMP4MUPD      REG_ACCESS(WoReg, 0x4008C17CU) /**< \brief (PWM) PWM Comparison 4 Mode Update Register */
#define REG_PWM_CMP5V         REG_ACCESS(RwReg, 0x4008C180U) /**< \brief (PWM) PWM Comparison 5 Value Register */
#define REG_PWM_CMP5VUPD      REG_ACCESS(WoReg, 0x4008C184U) /**< \brief (PWM) PWM Comparison 5 Value Update Register */
#define REG_PWM_CMP5M         REG_ACCESS(RwReg, 0x4008C188U) /**< \brief (PWM) PWM Comparison 5 Mode Register */
#define REG_PWM_CMP5MUPD      REG_ACCESS(WoReg, 0x4008C18CU) /**< \brief (PWM) PWM Comparison 5 Mode Update Register */
#define REG_PWM_CMP6V         REG_ACCESS(RwReg, 0x4008C190U) /**< \brief (PWM) PWM Comparison 6 Value Register */
#define REG_PWM_CMP6VUPD      REG_ACCESS(WoReg, 0x4008C194U) /**< \brief (PWM) PWM Comparison 6 Value Update Register */
#define REG_PWM_CMP6M         REG_ACCESS(RwReg, 0x4008C198U) /**< \brief (PWM) PWM Comparison 6 Mode Register */
#define REG_PWM_CMP6MUPD      REG_ACCESS(WoReg, 0x4008C19CU) /**< \brief (PWM) PWM Comparison 6 Mode Update Register */
#define REG_PWM_CMP7V         REG_ACCESS(RwReg, 0x4008C1A0U) /**< \brief (PWM) PWM Comparison 7 Value Register */
#define REG_PWM_CMP7VUPD      REG_ACCESS(WoReg, 0x4008C1A4U) /**< \brief (PWM) PWM Comparison 7 Value Update Register */
#define REG_PWM_CMP7M         REG_ACCESS(RwReg, 0x4008C1A8U) /**< \brief (PWM) PWM Comparison 7 Mode Register */
#define REG_PWM_CMP7MUPD      REG_ACCESS(WoReg, 0x4008C1ACU) /**< \brief (PWM) PWM Comparison 7 Mode Update Register */
#define REG_PWM_CMR0          REG_ACCESS(RwReg, 0x4008C200U) /**< \brief (PWM) PWM Channel Mode Register (ch_num = 0) */
#define REG_PWM_CDTY0         REG_ACCESS(RwReg, 0x4008C204U) /**< \brief (PWM) PWM Channel Duty Cycle Register (ch_num = 0) */
#define REG_PWM_CDTYUPD0      REG_ACCESS(WoReg, 0x4008C208U) /**< \brief (PWM) PWM Channel Duty Cycle Update Register (ch_num = 0) */
#define REG_PWM_CPRD0         REG_ACCESS(RwReg, 0x4008C20CU) /**< \brief (PWM) PWM Channel Period Register (ch_num = 0) */
#define REG_PWM_CPRDUPD0      REG_ACCESS(WoReg, 0x4008C210U) /**< \brief (PWM) PWM Channel Period Update Register (ch_num = 0) */
#define REG_PWM_CCNT0         REG_ACCESS(RoReg, 0x4008C214U) /**< \brief (PWM) PWM Channel Counter Register (ch_num = 0) */
#define REG_PWM_DT0           REG_ACCESS(RwReg, 0x4008C218U) /**< \brief (PWM) PWM Channel Dead Time Register (ch_num = 0) */
#define REG_PWM_DTUPD0        REG_ACCESS(WoReg, 0x4008C21CU) /**< \brief (PWM) PWM Channel Dead Time Update Register (ch_num = 0) */
#define REG_PWM_CMR1          REG_ACCESS(RwReg, 0x4008C220U) /**< \brief (PWM) PWM Channel Mode Register (ch_num = 1) */
#define REG_PWM_CDTY1         REG_ACCESS(RwReg, 0x4008C224U) /**< \brief (PWM) PWM Channel Duty Cycle Register (ch_num = 1) */
#define REG_PWM_CDTYUPD1      REG_ACCESS(WoReg, 0x4008C228U) /**< \brief (PWM) PWM Channel Duty Cycle Update Register (ch_num = 1) */
#define REG_PWM_CPRD1         REG_ACCESS(RwReg, 0x4008C22CU) /**< \brief (PWM) PWM Channel Period Register (ch_num = 1) */
#define REG_PWM_CPRDUPD1      REG_ACCESS(WoReg, 0x4008C230U) /**< \brief (PWM) PWM Channel Period Update Register (ch_num = 1) */
#define REG_PWM_CCNT1         REG_ACCESS(RoReg, 0x4008C234U) /**< \brief (PWM) PWM Channel Counter Register (ch_num = 1) */
#define REG_PWM_DT1           REG_ACCESS(RwReg, 0x4008C238U) /**< \brief (PWM) PWM Channel Dead Time Register (ch_num = 1) */
#define REG_PWM_DTUPD1        REG_ACCESS(WoReg, 0x4008C23CU) /**< \brief (PWM) PWM Channel Dead Time Update Register (ch_num = 1) */
#define REG_PWM_CMR2          REG_ACCESS(RwReg, 0x4008C240U) /**< \brief (PWM) PWM Channel Mode Register (ch_num = 2) */
#define REG_PWM_CDTY2         REG_ACCESS(RwReg, 0x4008C244U) /**< \brief (PWM) PWM Channel Duty Cycle Register (ch_num = 2) */
#define REG_PWM_CDTYUPD2      REG_ACCESS(WoReg, 0x4008C248U) /**< \brief (PWM) PWM Channel Duty Cycle Update Register (ch_num = 2) */
#define REG_PWM_CPRD2         REG_ACCESS(RwReg, 0x4008C24CU) /**< \brief (PWM) PWM Channel Period Register (ch_num = 2) */
#define REG_PWM_CPRDUPD2      REG_ACCESS(WoReg, 0x4008C250U) /**< \brief (PWM) PWM Channel Period Update Register (ch_num = 2) */
#define REG_PWM_CCNT2         REG_ACCESS(RoReg, 0x4008C254U) /**< \brief (PWM) PWM Channel Counter Register (ch_num = 2) */
#define REG_PWM_DT2           REG_ACCESS(RwReg, 0x4008C258U) /**< \brief (PWM) PWM Channel Dead Time Register (ch_num = 2) */
#define REG_PWM_DTUPD2        REG_ACCESS(WoReg, 0x4008C25CU) /**< \brief (PWM) PWM Channel Dead Time Update Register (ch_num = 2) */
#define REG_PWM_CMR3          REG_ACCESS(RwReg, 0x4008C260U) /**< \brief (PWM) PWM Channel Mode Register (ch_num = 3) */
#define REG_PWM_CDTY3         REG_ACCESS(RwReg, 0x4008C264U) /**< \brief (PWM) PWM Channel Duty Cycle Register (ch_num = 3) */
#define REG_PWM_CDTYUPD3      REG_ACCESS(WoReg, 0x4008C268U) /**< \brief (PWM) PWM Channel Duty Cycle Update Register (ch_num = 3) */
#define REG_PWM_CPRD3         REG_ACCESS(RwReg, 0x4008C26CU) /**< \brief (PWM) PWM Channel Period Register (ch_num = 3) */
#define REG_PWM_CPRDUPD3      REG_ACCESS(WoReg, 0x4008C270U) /**< \brief (PWM) PWM Channel Period Update Register (ch_num = 3) */
#define REG_PWM_CCNT3         REG_ACCESS(RoReg, 0x4008C274U) /**< \brief (PWM) PWM Channel Counter Register (ch_num = 3) */
#define REG_PWM_DT3           REG_ACCESS(RwReg, 0x4008C278U) /**< \brief (PWM) PWM Channel Dead Time Register (ch_num = 3) */
#define REG_PWM_DTUPD3        REG_ACCESS(WoReg, 0x4008C27CU) /**< \brief (PWM) PWM Channel Dead Time Update Register (ch_num = 3) */
/* ========== Register definition for USART0 peripheral ========== */
#define REG_USART0_CR         REG_ACCESS(WoReg, 0x40090000U) /**< \brief (USART0) Control Register */
#define REG_USART0_MR         REG_ACCESS(RwReg, 0x40090004U) /**< \brief (USART0) Mode Register */
#define REG_USART0_IER        REG_ACCESS(WoReg, 0x40090008U) /**< \brief (USART0) Interrupt Enable Register */
#define REG_USART0_IDR        REG_ACCESS(WoReg, 0x4009000CU) /**< \brief (USART0) Interrupt Disable Register */
#define REG_USART0_IMR        REG_ACCESS(RoReg, 0x40090010U) /**< \brief (USART0) Interrupt Mask Register */
#define REG_USART0_CSR        REG_ACCESS(RoReg, 0x40090014U) /**< \brief (USART0) Channel Status Register */
#define REG_USART0_RHR        REG_ACCESS(RoReg, 0x40090018U) /**< \brief (USART0) Receiver Holding Register */
#define REG_USART0_THR        REG_ACCESS(WoReg, 0x4009001CU) /**< \brief (USART0) Transmitter Holding Register */
#define REG_USART0_BRGR       REG_ACCESS(RwReg, 0x40090020U) /**< \brief (USART0) Baud Rate Generator Register */
#define REG_USART0_RTOR       REG_ACCESS(RwReg, 0x40090024U) /**< \brief (USART0) Receiver Time-out Register */
#define REG_USART0_TTGR       REG_ACCESS(RwReg, 0x40090028U) /**< \brief (USART0) Transmitter Timeguard Register */
#define REG_USART0_FIDI       REG_ACCESS(RwReg, 0x40090040U) /**< \brief (USART0) FI DI Ratio Register */
#define REG_USART0_NER        REG_ACCESS(RoReg, 0x40090044U) /**< \brief (USART0) Number of Errors Register */
#define REG_USART0_IF         REG_ACCESS(RwReg, 0x4009004CU) /**< \brief (USART0) IrDA Filter Register */
#define REG_USART0_MAN        REG_ACCESS(RwReg, 0x40090050U) /**< \brief (USART0) Manchester Encoder Decoder Register */
#define REG_USART0_WPMR       REG_ACCESS(RwReg, 0x400900E4U) /**< \brief (USART0) Write Protect Mode Register */
#define REG_USART0_WPSR       REG_ACCESS(RoReg, 0x400900E8U) /**< \brief (USART0) Write Protect Status Register */
#define REG_USART0_VERSION    REG_ACCESS(RoReg, 0x400900FCU) /**< \brief (USART0) Version Register */
#define REG_USART0_RPR        REG_ACCESS(RwReg, 0x40090100U) /**< \brief (USART0) Receive Pointer Register */
#define REG_USART0_RCR        REG_ACCESS(RwReg, 0x40090104U) /**< \brief (USART0) Receive Counter Register */
#define REG_USART0_TPR        REG_ACCESS(RwReg, 0x40090108U) /**< \brief (USART0) Transmit Pointer Register */
#define REG_USART0_TCR        REG_ACCESS(RwReg, 0x4009010CU) /**< \brief (USART0) Transmit Counter Register */
#define REG_USART0_RNPR       REG_ACCESS(RwReg, 0x40090110U) /**< \brief (USART0) Receive Next Pointer Register */
#define REG_USART0_RNCR       REG_ACCESS(RwReg, 0x40090114U) /**< \brief (USART0) Receive Next Counter Register */
#define REG_USART0_TNPR       REG_ACCESS(RwReg, 0x40090118U) /**< \brief (USART0) Transmit Next Pointer Register */
#define REG_USART0_TNCR       REG_ACCESS(RwReg, 0x4009011CU) /**< \brief (USART0) Transmit Next Counter Register */
#define REG_USART0_PTCR       REG_ACCESS(WoReg, 0x40090120U) /**< \brief (USART0) Transfer Control Register */
#define REG_USART0_PTSR       REG_ACCESS(RoReg, 0x40090124U) /**< \brief (USART0) Transfer Status Register */
/* ========== Register definition for USART1 peripheral ========== */
#define REG_USART1_CR         REG_ACCESS(WoReg, 0x40094000U) /**< \brief (USART1) Control Register */
#define REG_USART1_MR         REG_ACCESS(RwReg, 0x40094004U) /**< \brief (USART1) Mode Register */
#define REG_USART1_IER        REG_ACCESS(WoReg, 0x40094008U) /**< \brief (USART1) Interrupt Enable Register */
#define REG_USART1_IDR        REG_ACCESS(WoReg, 0x4009400CU) /**< \brief (USART1) Interrupt Disable Register */
#define REG_USART1_IMR        REG_ACCESS(RoReg, 0x40094010U) /**< \brief (USART1) Interrupt Mask Register */
#define REG_USART1_CSR        REG_ACCESS(RoReg, 0x40094014U) /**< \brief (USART1) Channel Status Register */
#define REG_USART1_RHR        REG_ACCESS(RoReg, 0x40094018U) /**< \brief (USART1) Receiver Holding Register */
#define REG_USART1_THR        REG_ACCESS(WoReg, 0x4009401CU) /**< \brief (USART1) Transmitter Holding Register */
#define REG_USART1_BRGR       REG_ACCESS(RwReg, 0x40094020U) /**< \brief (USART1) Baud Rate Generator Register */
#define REG_USART1_RTOR       REG_ACCESS(RwReg, 0x40094024U) /**< \brief (USART1) Receiver Time-out Register */
#define REG_USART1_TTGR       REG_ACCESS(RwReg, 0x40094028U) /**< \brief (USART1) Transmitter Timeguard Register */
#define REG_USART1_FIDI       REG_ACCESS(RwReg, 0x40094040U) /**< \brief (USART1) FI DI Ratio Register */
#define REG_USART1_NER        REG_ACCESS(RoReg, 0x40094044U) /**< \brief (USART1) Number of Errors Register */
#define REG_USART1_IF         REG_ACCESS(RwReg, 0x4009404CU) /**< \brief (USART1) IrDA Filter Register */
#define REG_USART1_MAN        REG_ACCESS(RwReg, 0x40094050U) /**< \brief (USART1) Manchester Encoder Decoder Register */
#define REG_USART1_WPMR       REG_ACCESS(RwReg, 0x400940E4U) /**< \brief (USART1) Write Protect Mode Register */
#define REG_USART1_WPSR       REG_ACCESS(RoReg, 0x400940E8U) /**< \brief (USART1) Write Protect Status Register */
#define REG_USART1_VERSION    REG_ACCESS(RoReg, 0x400940FCU) /**< \brief (USART1) Version Register */
#define REG_USART1_RPR        REG_ACCESS(RwReg, 0x40094100U) /**< \brief (USART1) Receive Pointer Register */
#define REG_USART1_RCR        REG_ACCESS(RwReg, 0x40094104U) /**< \brief (USART1) Receive Counter Register */
#define REG_USART1_TPR        REG_ACCESS(RwReg, 0x40094108U) /**< \brief (USART1) Transmit Pointer Register */
#define REG_USART1_TCR        REG_ACCESS(RwReg, 0x4009410CU) /**< \brief (USART1) Transmit Counter Register */
#define REG_USART1_RNPR       REG_ACCESS(RwReg, 0x40094110U) /**< \brief (USART1) Receive Next Pointer Register */
#define REG_USART1_RNCR       REG_ACCESS(RwReg, 0x40094114U) /**< \brief (USART1) Receive Next Counter Register */
#define REG_USART1_TNPR       REG_ACCESS(RwReg, 0x40094118U) /**< \brief (USART1) Transmit Next Pointer Register */
#define REG_USART1_TNCR       REG_ACCESS(RwReg, 0x4009411CU) /**< \brief (USART1) Transmit Next Counter Register */
#define REG_USART1_PTCR       REG_ACCESS(WoReg, 0x40094120U) /**< \brief (USART1) Transfer Control Register */
#define REG_USART1_PTSR       REG_ACCESS(RoReg, 0x40094124U) /**< \brief (USART1) Transfer Status Register */
/* ========== Register definition for USART2 peripheral ========== */
#define REG_USART2_CR         REG_ACCESS(WoReg, 0x40098000U) /**< \brief (USART2) Control Register */
#define REG_USART2_MR         REG_ACCESS(RwReg, 0x40098004U) /**< \brief (USART2) Mode Register */
#define REG_USART2_IER        REG_ACCESS(WoReg, 0x40098008U) /**< \brief (USART2) Interrupt Enable Register */
#define REG_USART2_IDR        REG_ACCESS(WoReg, 0x4009800CU) /**< \brief (USART2) Interrupt Disable Register */
#define REG_USART2_IMR        REG_ACCESS(RoReg, 0x40098010U) /**< \brief (USART2) Interrupt Mask Register */
#define REG_USART2_CSR        REG_ACCESS(RoReg, 0x40098014U) /**< \brief (USART2) Channel Status Register */
#define REG_USART2_RHR        REG_ACCESS(RoReg, 0x40098018U) /**< \brief (USART2) Receiver Holding Register */
#define REG_USART2_THR        REG_ACCESS(WoReg, 0x4009801CU) /**< \brief (USART2) Transmitter Holding Register */
#define REG_USART2_BRGR       REG_ACCESS(RwReg, 0x40098020U) /**< \brief (USART2) Baud Rate Generator Register */
#define REG_USART2_RTOR       REG_ACCESS(RwReg, 0x40098024U) /**< \brief (USART2) Receiver Time-out Register */
#define REG_USART2_TTGR       REG_ACCESS(RwReg, 0x40098028U) /**< \brief (USART2) Transmitter Timeguard Register */
#define REG_USART2_FIDI       REG_ACCESS(RwReg, 0x40098040U) /**< \brief (USART2) FI DI Ratio Register */
#define REG_USART2_NER        REG_ACCESS(RoReg, 0x40098044U) /**< \brief (USART2) Number of Errors Register */
#define REG_USART2_IF         REG_ACCESS(RwReg, 0x4009804CU) /**< \brief (USART2) IrDA Filter Register */
#define REG_USART2_MAN        REG_ACCESS(RwReg, 0x40098050U) /**< \brief (USART2) Manchester Encoder Decoder Register */
#define REG_USART2_WPMR       REG_ACCESS(RwReg, 0x400980E4U) /**< \brief (USART2) Write Protect Mode Register */
#define REG_USART2_WPSR       REG_ACCESS(RoReg, 0x400980E8U) /**< \brief (USART2) Write Protect Status Register */
#define REG_USART2_VERSION    REG_ACCESS(RoReg, 0x400980FCU) /**< \brief (USART2) Version Register */
#define REG_USART2_RPR        REG_ACCESS(RwReg, 0x40098100U) /**< \brief (USART2) Receive Pointer Register */
#define REG_USART2_RCR        REG_ACCESS(RwReg, 0x40098104U) /**< \brief (USART2) Receive Counter Register */
#define REG_USART2_TPR        REG_ACCESS(RwReg, 0x40098108U) /**< \brief (USART2) Transmit Pointer Register */
#define REG_USART2_TCR        REG_ACCESS(RwReg, 0x4009810CU) /**< \brief (USART2) Transmit Counter Register */
#define REG_USART2_RNPR       REG_ACCESS(RwReg, 0x40098110U) /**< \brief (USART2) Receive Next Pointer Register */
#define REG_USART2_RNCR       REG_ACCESS(RwReg, 0x40098114U) /**< \brief (USART2) Receive Next Counter Register */
#define REG_USART2_TNPR       REG_ACCESS(RwReg, 0x40098118U) /**< \brief (USART2) Transmit Next Pointer Register */
#define REG_USART2_TNCR       REG_ACCESS(RwReg, 0x4009811CU) /**< \brief (USART2) Transmit Next Counter Register */
#define REG_USART2_PTCR       REG_ACCESS(WoReg, 0x40098120U) /**< \brief (USART2) Transfer Control Register */
#define REG_USART2_PTSR       REG_ACCESS(RoReg, 0x40098124U) /**< \brief (USART2) Transfer Status Register */
/* ========== Register definition for USART3 peripheral ========== */
#define REG_USART3_CR         REG_ACCESS(WoReg, 0x4009C000U) /**< \brief (USART3) Control Register */
#define REG_USART3_MR         REG_ACCESS(RwReg, 0x4009C004U) /**< \brief (USART3) Mode Register */
#define REG_USART3_IER        REG_ACCESS(WoReg, 0x4009C008U) /**< \brief (USART3) Interrupt Enable Register */
#define REG_USART3_IDR        REG_ACCESS(WoReg, 0x4009C00CU) /**< \brief (USART3) Interrupt Disable Register */
#define REG_USART3_IMR        REG_ACCESS(RoReg, 0x4009C010U) /**< \brief (USART3) Interrupt Mask Register */
#define REG_USART3_CSR        REG_ACCESS(RoReg, 0x4009C014U) /**< \brief (USART3) Channel Status Register */
#define REG_USART3_RHR        REG_ACCESS(RoReg, 0x4009C018U) /**< \brief (USART3) Receiver Holding Register */
#define REG_USART3_THR        REG_ACCESS(WoReg, 0x4009C01CU) /**< \brief (USART3) Transmitter Holding Register */
#define REG_USART3_BRGR       REG_ACCESS(RwReg, 0x4009C020U) /**< \brief (USART3) Baud Rate Generator Register */
#define REG_USART3_RTOR       REG_ACCESS(RwReg, 0x4009C024U) /**< \brief (USART3) Receiver Time-out Register */
#define REG_USART3_TTGR       REG_ACCESS(RwReg, 0x4009C028U) /**< \brief (USART3) Transmitter Timeguard Register */
#define REG_USART3_FIDI       REG_ACCESS(RwReg, 0x4009C040U) /**< \brief (USART3) FI DI Ratio Register */
#define REG_USART3_NER        REG_ACCESS(RoReg, 0x4009C044U) /**< \brief (USART3) Number of Errors Register */
#define REG_USART3_IF         REG_ACCESS(RwReg, 0x4009C04CU) /**< \brief (USART3) IrDA Filter Register */
#define REG_USART3_MAN        REG_ACCESS(RwReg, 0x4009C050U) /**< \brief (USART3) Manchester Encoder Decoder Register */
#define REG_USART3_WPMR       REG_ACCESS(RwReg, 0x4009C0E4U) /**< \brief (USART3) Write Protect Mode Register */
#define REG_USART3_WPSR       REG_ACCESS(RoReg, 0x4009C0E8U) /**< \brief (USART3) Write Protect Status Register */
#define REG_USART3_VERSION    REG_ACCESS(RoReg, 0x4009C0FCU) /**< \brief (USART3) Version Register */
#define REG_USART3_RPR        REG_ACCESS(RwReg, 0x4009C100U) /**< \brief (USART3) Receive Pointer Register */
#define REG_USART3_RCR        REG_ACCESS(RwReg, 0x4009C104U) /**< \brief (USART3) Receive Counter Register */
#define REG_USART3_TPR        REG_ACCESS(RwReg, 0x4009C108U) /**< \brief (USART3) Transmit Pointer Register */
#define REG_USART3_TCR        REG_ACCESS(RwReg, 0x4009C10CU) /**< \brief (USART3) Transmit Counter Register */
#define REG_USART3_RNPR       REG_ACCESS(RwReg, 0x4009C110U) /**< \brief (USART3) Receive Next Pointer Register */
#define REG_USART3_RNCR       REG_ACCESS(RwReg, 0x4009C114U) /**< \brief (USART3) Receive Next Counter Register */
#define REG_USART3_TNPR       REG_ACCESS(RwReg, 0x4009C118U) /**< \brief (USART3) Transmit Next Pointer Register */
#define REG_USART3_TNCR       REG_ACCESS(RwReg, 0x4009C11CU) /**< \brief (USART3) Transmit Next Counter Register */
#define REG_USART3_PTCR       REG_ACCESS(WoReg, 0x4009C120U) /**< \brief (USART3) Transfer Control Register */
#define REG_USART3_PTSR       REG_ACCESS(RoReg, 0x4009C124U) /**< \brief (USART3) Transfer Status Register */
/* ========== Register definition for UDPHS peripheral ========== */
#define REG_UDPHS_CTRL        REG_ACCESS(RwReg, 0x400A4000U) /**< \brief (UDPHS) UDPHS Control Register */
#define REG_UDPHS_FNUM        REG_ACCESS(RoReg, 0x400A4004U) /**< \brief (UDPHS) UDPHS Frame Number Register */
#define REG_UDPHS_IEN         REG_ACCESS(RwReg, 0x400A4010U) /**< \brief (UDPHS) UDPHS Interrupt Enable Register */
#define REG_UDPHS_INTSTA      REG_ACCESS(RoReg, 0x400A4014U) /**< \brief (UDPHS) UDPHS Interrupt Status Register */
#define REG_UDPHS_CLRINT      REG_ACCESS(WoReg, 0x400A4018U) /**< \brief (UDPHS) UDPHS Clear Interrupt Register */
#define REG_UDPHS_EPTRST      REG_ACCESS(WoReg, 0x400A401CU) /**< \brief (UDPHS) UDPHS Endpoints Reset Register */
#define REG_UDPHS_TST         REG_ACCESS(RwReg, 0x400A40E0U) /**< \brief (UDPHS) UDPHS Test Register */
#define REG_UDPHS_IPNAME1     REG_ACCESS(RoReg, 0x400A40F0U) /**< \brief (UDPHS) UDPHS Name1 Register */
#define REG_UDPHS_IPNAME2     REG_ACCESS(RoReg, 0x400A40F4U) /**< \brief (UDPHS) UDPHS Name2 Register */
#define REG_UDPHS_IPFEATURES  REG_ACCESS(RoReg, 0x400A40F8U) /**< \brief (UDPHS) UDPHS Features Register */
#define REG_UDPHS_EPTCFG0     REG_ACCESS(RwReg, 0x400A4100U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 0) */
#define REG_UDPHS_EPTCTLENB0  REG_ACCESS(WoReg, 0x400A4104U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 0) */
#define REG_UDPHS_EPTCTLDIS0  REG_ACCESS(WoReg, 0x400A4108U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 0) */
#define REG_UDPHS_EPTCTL0     REG_ACCESS(RoReg, 0x400A410CU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 0) */
#define REG_UDPHS_EPTSETSTA0  REG_ACCESS(WoReg, 0x400A4114U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 0) */
#define REG_UDPHS_EPTCLRSTA0  REG_ACCESS(WoReg, 0x400A4118U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 0) */
#define REG_UDPHS_EPTSTA0     REG_ACCESS(RoReg, 0x400A411CU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 0) */
#define REG_UDPHS_EPTCFG1     REG_ACCESS(RwReg, 0x400A4120U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 1) */
#define REG_UDPHS_EPTCTLENB1  REG_ACCESS(WoReg, 0x400A4124U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 1) */
#define REG_UDPHS_EPTCTLDIS1  REG_ACCESS(WoReg, 0x400A4128U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 1) */
#define REG_UDPHS_EPTCTL1     REG_ACCESS(RoReg, 0x400A412CU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 1) */
#define REG_UDPHS_EPTSETSTA1  REG_ACCESS(WoReg, 0x400A4134U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 1) */
#define REG_UDPHS_EPTCLRSTA1  REG_ACCESS(WoReg, 0x400A4138U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 1) */
#define REG_UDPHS_EPTSTA1     REG_ACCESS(RoReg, 0x400A413CU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 1) */
#define REG_UDPHS_EPTCFG2     REG_ACCESS(RwReg, 0x400A4140U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 2) */
#define REG_UDPHS_EPTCTLENB2  REG_ACCESS(WoReg, 0x400A4144U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 2) */
#define REG_UDPHS_EPTCTLDIS2  REG_ACCESS(WoReg, 0x400A4148U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 2) */
#define REG_UDPHS_EPTCTL2     REG_ACCESS(RoReg, 0x400A414CU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 2) */
#define REG_UDPHS_EPTSETSTA2  REG_ACCESS(WoReg, 0x400A4154U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 2) */
#define REG_UDPHS_EPTCLRSTA2  REG_ACCESS(WoReg, 0x400A4158U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 2) */
#define REG_UDPHS_EPTSTA2     REG_ACCESS(RoReg, 0x400A415CU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 2) */
#define REG_UDPHS_EPTCFG3     REG_ACCESS(RwReg, 0x400A4160U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 3) */
#define REG_UDPHS_EPTCTLENB3  REG_ACCESS(WoReg, 0x400A4164U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 3) */
#define REG_UDPHS_EPTCTLDIS3  REG_ACCESS(WoReg, 0x400A4168U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 3) */
#define REG_UDPHS_EPTCTL3     REG_ACCESS(RoReg, 0x400A416CU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 3) */
#define REG_UDPHS_EPTSETSTA3  REG_ACCESS(WoReg, 0x400A4174U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 3) */
#define REG_UDPHS_EPTCLRSTA3  REG_ACCESS(WoReg, 0x400A4178U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 3) */
#define REG_UDPHS_EPTSTA3     REG_ACCESS(RoReg, 0x400A417CU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 3) */
#define REG_UDPHS_EPTCFG4     REG_ACCESS(RwReg, 0x400A4180U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 4) */
#define REG_UDPHS_EPTCTLENB4  REG_ACCESS(WoReg, 0x400A4184U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 4) */
#define REG_UDPHS_EPTCTLDIS4  REG_ACCESS(WoReg, 0x400A4188U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 4) */
#define REG_UDPHS_EPTCTL4     REG_ACCESS(RoReg, 0x400A418CU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 4) */
#define REG_UDPHS_EPTSETSTA4  REG_ACCESS(WoReg, 0x400A4194U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 4) */
#define REG_UDPHS_EPTCLRSTA4  REG_ACCESS(WoReg, 0x400A4198U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 4) */
#define REG_UDPHS_EPTSTA4     REG_ACCESS(RoReg, 0x400A419CU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 4) */
#define REG_UDPHS_EPTCFG5     REG_ACCESS(RwReg, 0x400A41A0U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 5) */
#define REG_UDPHS_EPTCTLENB5  REG_ACCESS(WoReg, 0x400A41A4U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 5) */
#define REG_UDPHS_EPTCTLDIS5  REG_ACCESS(WoReg, 0x400A41A8U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 5) */
#define REG_UDPHS_EPTCTL5     REG_ACCESS(RoReg, 0x400A41ACU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 5) */
#define REG_UDPHS_EPTSETSTA5  REG_ACCESS(WoReg, 0x400A41B4U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 5) */
#define REG_UDPHS_EPTCLRSTA5  REG_ACCESS(WoReg, 0x400A41B8U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 5) */
#define REG_UDPHS_EPTSTA5     REG_ACCESS(RoReg, 0x400A41BCU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 5) */
#define REG_UDPHS_EPTCFG6     REG_ACCESS(RwReg, 0x400A41C0U) /**< \brief (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 6) */
#define REG_UDPHS_EPTCTLENB6  REG_ACCESS(WoReg, 0x400A41C4U) /**< \brief (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 6) */
#define REG_UDPHS_EPTCTLDIS6  REG_ACCESS(WoReg, 0x400A41C8U) /**< \brief (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 6) */
#define REG_UDPHS_EPTCTL6     REG_ACCESS(RoReg, 0x400A41CCU) /**< \brief (UDPHS) UDPHS Endpoint Control Register (endpoint = 6) */
#define REG_UDPHS_EPTSETSTA6  REG_ACCESS(WoReg, 0x400A41D4U) /**< \brief (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 6) */
#define REG_UDPHS_EPTCLRSTA6  REG_ACCESS(WoReg, 0x400A41D8U) /**< \brief (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 6) */
#define REG_UDPHS_EPTSTA6     REG_ACCESS(RoReg, 0x400A41DCU) /**< \brief (UDPHS) UDPHS Endpoint Status Register (endpoint = 6) */
#define REG_UDPHS_DMANXTDSC1  REG_ACCESS(RwReg, 0x400A4320U) /**< \brief (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 1) */
#define REG_UDPHS_DMAADDRESS1 REG_ACCESS(RwReg, 0x400A4324U) /**< \brief (UDPHS) UDPHS DMA Channel Address Register (channel = 1) */
#define REG_UDPHS_DMACONTROL1 REG_ACCESS(RwReg, 0x400A4328U) /**< \brief (UDPHS) UDPHS DMA Channel Control Register (channel = 1) */
#define REG_UDPHS_DMASTATUS1  REG_ACCESS(RwReg, 0x400A432CU) /**< \brief (UDPHS) UDPHS DMA Channel Status Register (channel = 1) */
#define REG_UDPHS_DMANXTDSC2  REG_ACCESS(RwReg, 0x400A4330U) /**< \brief (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 2) */
#define REG_UDPHS_DMAADDRESS2 REG_ACCESS(RwReg, 0x400A4334U) /**< \brief (UDPHS) UDPHS DMA Channel Address Register (channel = 2) */
#define REG_UDPHS_DMACONTROL2 REG_ACCESS(RwReg, 0x400A4338U) /**< \brief (UDPHS) UDPHS DMA Channel Control Register (channel = 2) */
#define REG_UDPHS_DMASTATUS2  REG_ACCESS(RwReg, 0x400A433CU) /**< \brief (UDPHS) UDPHS DMA Channel Status Register (channel = 2) */
#define REG_UDPHS_DMANXTDSC3  REG_ACCESS(RwReg, 0x400A4340U) /**< \brief (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 3) */
#define REG_UDPHS_DMAADDRESS3 REG_ACCESS(RwReg, 0x400A4344U) /**< \brief (UDPHS) UDPHS DMA Channel Address Register (channel = 3) */
#define REG_UDPHS_DMACONTROL3 REG_ACCESS(RwReg, 0x400A4348U) /**< \brief (UDPHS) UDPHS DMA Channel Control Register (channel = 3) */
#define REG_UDPHS_DMASTATUS3  REG_ACCESS(RwReg, 0x400A434CU) /**< \brief (UDPHS) UDPHS DMA Channel Status Register (channel = 3) */
#define REG_UDPHS_DMANXTDSC4  REG_ACCESS(RwReg, 0x400A4350U) /**< \brief (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 4) */
#define REG_UDPHS_DMAADDRESS4 REG_ACCESS(RwReg, 0x400A4354U) /**< \brief (UDPHS) UDPHS DMA Channel Address Register (channel = 4) */
#define REG_UDPHS_DMACONTROL4 REG_ACCESS(RwReg, 0x400A4358U) /**< \brief (UDPHS) UDPHS DMA Channel Control Register (channel = 4) */
#define REG_UDPHS_DMASTATUS4  REG_ACCESS(RwReg, 0x400A435CU) /**< \brief (UDPHS) UDPHS DMA Channel Status Register (channel = 4) */
#define REG_UDPHS_DMANXTDSC5  REG_ACCESS(RwReg, 0x400A4360U) /**< \brief (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 5) */
#define REG_UDPHS_DMAADDRESS5 REG_ACCESS(RwReg, 0x400A4364U) /**< \brief (UDPHS) UDPHS DMA Channel Address Register (channel = 5) */
#define REG_UDPHS_DMACONTROL5 REG_ACCESS(RwReg, 0x400A4368U) /**< \brief (UDPHS) UDPHS DMA Channel Control Register (channel = 5) */
#define REG_UDPHS_DMASTATUS5  REG_ACCESS(RwReg, 0x400A436CU) /**< \brief (UDPHS) UDPHS DMA Channel Status Register (channel = 5) */
/* ========== Register definition for ADC12B peripheral ========== */
#define REG_ADC12B_CR         REG_ACCESS(WoReg, 0x400A8000U) /**< \brief (ADC12B) Control Register */
#define REG_ADC12B_MR         REG_ACCESS(RwReg, 0x400A8004U) /**< \brief (ADC12B) Mode Register */
#define REG_ADC12B_CHER       REG_ACCESS(WoReg, 0x400A8010U) /**< \brief (ADC12B) Channel Enable Register */
#define REG_ADC12B_CHDR       REG_ACCESS(WoReg, 0x400A8014U) /**< \brief (ADC12B) Channel Disable Register */
#define REG_ADC12B_CHSR       REG_ACCESS(RoReg, 0x400A8018U) /**< \brief (ADC12B) Channel Status Register */
#define REG_ADC12B_SR         REG_ACCESS(RoReg, 0x400A801CU) /**< \brief (ADC12B) Status Register */
#define REG_ADC12B_LCDR       REG_ACCESS(RoReg, 0x400A8020U) /**< \brief (ADC12B) Last Converted Data Register */
#define REG_ADC12B_IER        REG_ACCESS(WoReg, 0x400A8024U) /**< \brief (ADC12B) Interrupt Enable Register */
#define REG_ADC12B_IDR        REG_ACCESS(WoReg, 0x400A8028U) /**< \brief (ADC12B) Interrupt Disable Register */
#define REG_ADC12B_IMR        REG_ACCESS(RoReg, 0x400A802CU) /**< \brief (ADC12B) Interrupt Mask Register */
#define REG_ADC12B_CDR        REG_ACCESS(RoReg, 0x400A8030U) /**< \brief (ADC12B) Channel Data Register */
#define REG_ADC12B_ACR        REG_ACCESS(RwReg, 0x400A8064U) /**< \brief (ADC12B) Analog Control Register */
#define REG_ADC12B_EMR        REG_ACCESS(RwReg, 0x400A8068U) /**< \brief (ADC12B) Extended Mode Register */
#define REG_ADC12B_RPR        REG_ACCESS(RwReg, 0x400A8100U) /**< \brief (ADC12B) Receive Pointer Register */
#define REG_ADC12B_RCR        REG_ACCESS(RwReg, 0x400A8104U) /**< \brief (ADC12B) Receive Counter Register */
#define REG_ADC12B_TPR        REG_ACCESS(RwReg, 0x400A8108U) /**< \brief (ADC12B) Transmit Pointer Register */
#define REG_ADC12B_TCR        REG_ACCESS(RwReg, 0x400A810CU) /**< \brief (ADC12B) Transmit Counter Register */
#define REG_ADC12B_RNPR       REG_ACCESS(RwReg, 0x400A8110U) /**< \brief (ADC12B) Receive Next Pointer Register */
#define REG_ADC12B_RNCR       REG_ACCESS(RwReg, 0x400A8114U) /**< \brief (ADC12B) Receive Next Counter Register */
#define REG_ADC12B_TNPR       REG_ACCESS(RwReg, 0x400A8118U) /**< \brief (ADC12B) Transmit Next Pointer Register */
#define REG_ADC12B_TNCR       REG_ACCESS(RwReg, 0x400A811CU) /**< \brief (ADC12B) Transmit Next Counter Register */
#define REG_ADC12B_PTCR       REG_ACCESS(WoReg, 0x400A8120U) /**< \brief (ADC12B) Transfer Control Register */
#define REG_ADC12B_PTSR       REG_ACCESS(RoReg, 0x400A8124U) /**< \brief (ADC12B) Transfer Status Register */
/* ========== Register definition for ADC peripheral ========== */
#define REG_ADC_CR            REG_ACCESS(WoReg, 0x400AC000U) /**< \brief (ADC) Control Register */
#define REG_ADC_MR            REG_ACCESS(RwReg, 0x400AC004U) /**< \brief (ADC) Mode Register */
#define REG_ADC_CHER          REG_ACCESS(WoReg, 0x400AC010U) /**< \brief (ADC) Channel Enable Register */
#define REG_ADC_CHDR          REG_ACCESS(WoReg, 0x400AC014U) /**< \brief (ADC) Channel Disable Register */
#define REG_ADC_CHSR          REG_ACCESS(RoReg, 0x400AC018U) /**< \brief (ADC) Channel Status Register */
#define REG_ADC_SR            REG_ACCESS(RoReg, 0x400AC01CU) /**< \brief (ADC) Status Register */
#define REG_ADC_LCDR          REG_ACCESS(RoReg, 0x400AC020U) /**< \brief (ADC) Last Converted Data Register */
#define REG_ADC_IER           REG_ACCESS(WoReg, 0x400AC024U) /**< \brief (ADC) Interrupt Enable Register */
#define REG_ADC_IDR           REG_ACCESS(WoReg, 0x400AC028U) /**< \brief (ADC) Interrupt Disable Register */
#define REG_ADC_IMR           REG_ACCESS(RoReg, 0x400AC02CU) /**< \brief (ADC) Interrupt Mask Register */
#define REG_ADC_CDR           REG_ACCESS(RoReg, 0x400AC030U) /**< \brief (ADC) Channel Data Register */
#define REG_ADC_RPR           REG_ACCESS(RwReg, 0x400AC100U) /**< \brief (ADC) Receive Pointer Register */
#define REG_ADC_RCR           REG_ACCESS(RwReg, 0x400AC104U) /**< \brief (ADC) Receive Counter Register */
#define REG_ADC_TPR           REG_ACCESS(RwReg, 0x400AC108U) /**< \brief (ADC) Transmit Pointer Register */
#define REG_ADC_TCR           REG_ACCESS(RwReg, 0x400AC10CU) /**< \brief (ADC) Transmit Counter Register */
#define REG_ADC_RNPR          REG_ACCESS(RwReg, 0x400AC110U) /**< \brief (ADC) Receive Next Pointer Register */
#define REG_ADC_RNCR          REG_ACCESS(RwReg, 0x400AC114U) /**< \brief (ADC) Receive Next Counter Register */
#define REG_ADC_TNPR          REG_ACCESS(RwReg, 0x400AC118U) /**< \brief (ADC) Transmit Next Pointer Register */
#define REG_ADC_TNCR          REG_ACCESS(RwReg, 0x400AC11CU) /**< \brief (ADC) Transmit Next Counter Register */
#define REG_ADC_PTCR          REG_ACCESS(WoReg, 0x400AC120U) /**< \brief (ADC) Transfer Control Register */
#define REG_ADC_PTSR          REG_ACCESS(RoReg, 0x400AC124U) /**< \brief (ADC) Transfer Status Register */
/* ========== Register definition for DMAC peripheral ========== */
#define REG_DMAC_GCFG         REG_ACCESS(RwReg, 0x400B0000U) /**< \brief (DMAC) DMAC Global Configuration Register */
#define REG_DMAC_EN           REG_ACCESS(RwReg, 0x400B0004U) /**< \brief (DMAC) DMAC Enable Register */
#define REG_DMAC_SREQ         REG_ACCESS(RwReg, 0x400B0008U) /**< \brief (DMAC) DMAC Software Single Request Register */
#define REG_DMAC_CREQ         REG_ACCESS(RwReg, 0x400B000CU) /**< \brief (DMAC) DMAC Software Chunk Transfer Request Register */
#define REG_DMAC_LAST         REG_ACCESS(RwReg, 0x400B0010U) /**< \brief (DMAC) DMAC Software Last Transfer Flag Register */
#define REG_DMAC_EBCIER       REG_ACCESS(WoReg, 0x400B0018U) /**< \brief (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register. */
#define REG_DMAC_EBCIDR       REG_ACCESS(WoReg, 0x400B001CU) /**< \brief (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register. */
#define REG_DMAC_EBCIMR       REG_ACCESS(RoReg, 0x400B0020U) /**< \brief (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register. */
#define REG_DMAC_EBCISR       REG_ACCESS(RoReg, 0x400B0024U) /**< \brief (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register. */
#define REG_DMAC_CHER         REG_ACCESS(WoReg, 0x400B0028U) /**< \brief (DMAC) DMAC Channel Handler Enable Register */
#define REG_DMAC_CHDR         REG_ACCESS(WoReg, 0x400B002CU) /**< \brief (DMAC) DMAC Channel Handler Disable Register */
#define REG_DMAC_CHSR         REG_ACCESS(RoReg, 0x400B0030U) /**< \brief (DMAC) DMAC Channel Handler Status Register */
#define REG_DMAC_SADDR0       REG_ACCESS(RwReg, 0x400B003CU) /**< \brief (DMAC) DMAC Channel Source Address Register (ch_num = 0) */
#define REG_DMAC_DADDR0       REG_ACCESS(RwReg, 0x400B0040U) /**< \brief (DMAC) DMAC Channel Destination Address Register (ch_num = 0) */
#define REG_DMAC_DSCR0        REG_ACCESS(RwReg, 0x400B0044U) /**< \brief (DMAC) DMAC Channel Descriptor Address Register (ch_num = 0) */
#define REG_DMAC_CTRLA0       REG_ACCESS(RwReg, 0x400B0048U) /**< \brief (DMAC) DMAC Channel Control A Register (ch_num = 0) */
#define REG_DMAC_CTRLB0       REG_ACCESS(RwReg, 0x400B004CU) /**< \brief (DMAC) DMAC Channel Control B Register (ch_num = 0) */
#define REG_DMAC_CFG0         REG_ACCESS(RwReg, 0x400B0050U) /**< \brief (DMAC) DMAC Channel Configuration Register (ch_num = 0) */
#define REG_DMAC_SADDR1       REG_ACCESS(RwReg, 0x400B0064U) /**< \brief (DMAC) DMAC Channel Source Address Register (ch_num = 1) */
#define REG_DMAC_DADDR1       REG_ACCESS(RwReg, 0x400B0068U) /**< \brief (DMAC) DMAC Channel Destination Address Register (ch_num = 1) */
#define REG_DMAC_DSCR1        REG_ACCESS(RwReg, 0x400B006CU) /**< \brief (DMAC) DMAC Channel Descriptor Address Register (ch_num = 1) */
#define REG_DMAC_CTRLA1       REG_ACCESS(RwReg, 0x400B0070U) /**< \brief (DMAC) DMAC Channel Control A Register (ch_num = 1) */
#define REG_DMAC_CTRLB1       REG_ACCESS(RwReg, 0x400B0074U) /**< \brief (DMAC) DMAC Channel Control B Register (ch_num = 1) */
#define REG_DMAC_CFG1         REG_ACCESS(RwReg, 0x400B0078U) /**< \brief (DMAC) DMAC Channel Configuration Register (ch_num = 1) */
#define REG_DMAC_SADDR2       REG_ACCESS(RwReg, 0x400B008CU) /**< \brief (DMAC) DMAC Channel Source Address Register (ch_num = 2) */
#define REG_DMAC_DADDR2       REG_ACCESS(RwReg, 0x400B0090U) /**< \brief (DMAC) DMAC Channel Destination Address Register (ch_num = 2) */
#define REG_DMAC_DSCR2        REG_ACCESS(RwReg, 0x400B0094U) /**< \brief (DMAC) DMAC Channel Descriptor Address Register (ch_num = 2) */
#define REG_DMAC_CTRLA2       REG_ACCESS(RwReg, 0x400B0098U) /**< \brief (DMAC) DMAC Channel Control A Register (ch_num = 2) */
#define REG_DMAC_CTRLB2       REG_ACCESS(RwReg, 0x400B009CU) /**< \brief (DMAC) DMAC Channel Control B Register (ch_num = 2) */
#define REG_DMAC_CFG2         REG_ACCESS(RwReg, 0x400B00A0U) /**< \brief (DMAC) DMAC Channel Configuration Register (ch_num = 2) */
#define REG_DMAC_SADDR3       REG_ACCESS(RwReg, 0x400B00B4U) /**< \brief (DMAC) DMAC Channel Source Address Register (ch_num = 3) */
#define REG_DMAC_DADDR3       REG_ACCESS(RwReg, 0x400B00B8U) /**< \brief (DMAC) DMAC Channel Destination Address Register (ch_num = 3) */
#define REG_DMAC_DSCR3        REG_ACCESS(RwReg, 0x400B00BCU) /**< \brief (DMAC) DMAC Channel Descriptor Address Register (ch_num = 3) */
#define REG_DMAC_CTRLA3       REG_ACCESS(RwReg, 0x400B00C0U) /**< \brief (DMAC) DMAC Channel Control A Register (ch_num = 3) */
#define REG_DMAC_CTRLB3       REG_ACCESS(RwReg, 0x400B00C4U) /**< \brief (DMAC) DMAC Channel Control B Register (ch_num = 3) */
#define REG_DMAC_CFG3         REG_ACCESS(RwReg, 0x400B00C8U) /**< \brief (DMAC) DMAC Channel Configuration Register (ch_num = 3) */
/* ========== Register definition for SMC peripheral ========== */
#define REG_SMC_CFG           REG_ACCESS(RwReg, 0x400E0000U) /**< \brief (SMC) SMC NFC Configuration Register */
#define REG_SMC_CTRL          REG_ACCESS(WoReg, 0x400E0004U) /**< \brief (SMC) SMC NFC Control Register */
#define REG_SMC_SR            REG_ACCESS(RoReg, 0x400E0008U) /**< \brief (SMC) SMC NFC Status Register */
#define REG_SMC_IER           REG_ACCESS(WoReg, 0x400E000CU) /**< \brief (SMC) SMC NFC Interrupt Enable Register */
#define REG_SMC_IDR           REG_ACCESS(WoReg, 0x400E0010U) /**< \brief (SMC) SMC NFC Interrupt Disable Register */
#define REG_SMC_IMR           REG_ACCESS(RoReg, 0x400E0014U) /**< \brief (SMC) SMC NFC Interrupt Mask Register */
#define REG_SMC_ADDR          REG_ACCESS(RwReg, 0x400E0018U) /**< \brief (SMC) SMC NFC Address Cycle Zero Register */
#define REG_SMC_BANK          REG_ACCESS(RwReg, 0x400E001CU) /**< \brief (SMC) SMC Bank Address Register */
#define REG_SMC_ECC_CTRL      REG_ACCESS(WoReg, 0x400E0020U) /**< \brief (SMC) SMC ECC Control Register */
#define REG_SMC_ECC_MD        REG_ACCESS(RwReg, 0x400E0024U) /**< \brief (SMC) SMC ECC Mode Register */
#define REG_SMC_ECC_SR1       REG_ACCESS(RoReg, 0x400E0028U) /**< \brief (SMC) SMC ECC Status 1 Register */
#define REG_SMC_ECC_PR0       REG_ACCESS(RoReg, 0x400E002CU) /**< \brief (SMC) SMC ECC Parity 0 Register */
#define REG_SMC_ECC_PR1       REG_ACCESS(RoReg, 0x400E0030U) /**< \brief (SMC) SMC ECC parity 1 Register */
#define REG_SMC_ECC_SR2       REG_ACCESS(RoReg, 0x400E0034U) /**< \brief (SMC) SMC ECC status 2 Register */
#define REG_SMC_ECC_PR2       REG_ACCESS(RoReg, 0x400E0038U) /**< \brief (SMC) SMC ECC parity 2 Register */
#define REG_SMC_ECC_PR3       REG_ACCESS(RoReg, 0x400E003CU) /**< \brief (SMC) SMC ECC parity 3 Register */
#define REG_SMC_ECC_PR4       REG_ACCESS(RoReg, 0x400E0040U) /**< \brief (SMC) SMC ECC parity 4 Register */
#define REG_SMC_ECC_PR5       REG_ACCESS(RoReg, 0x400E0044U) /**< \brief (SMC) SMC ECC parity 5 Register */
#define REG_SMC_ECC_PR6       REG_ACCESS(RoReg, 0x400E0048U) /**< \brief (SMC) SMC ECC parity 6 Register */
#define REG_SMC_ECC_PR7       REG_ACCESS(RoReg, 0x400E004CU) /**< \brief (SMC) SMC ECC parity 7 Register */
#define REG_SMC_ECC_PR8       REG_ACCESS(RoReg, 0x400E0050U) /**< \brief (SMC) SMC ECC parity 8 Register */
#define REG_SMC_ECC_PR9       REG_ACCESS(RoReg, 0x400E0054U) /**< \brief (SMC) SMC ECC parity 9 Register */
#define REG_SMC_ECC_PR10      REG_ACCESS(RoReg, 0x400E0058U) /**< \brief (SMC) SMC ECC parity 10 Register */
#define REG_SMC_ECC_PR11      REG_ACCESS(RoReg, 0x400E005CU) /**< \brief (SMC) SMC ECC parity 11 Register */
#define REG_SMC_ECC_PR12      REG_ACCESS(RoReg, 0x400E0060U) /**< \brief (SMC) SMC ECC parity 12 Register */
#define REG_SMC_ECC_PR13      REG_ACCESS(RoReg, 0x400E0064U) /**< \brief (SMC) SMC ECC parity 13 Register */
#define REG_SMC_ECC_PR14      REG_ACCESS(RoReg, 0x400E0068U) /**< \brief (SMC) SMC ECC parity 14 Register */
#define REG_SMC_ECC_PR15      REG_ACCESS(RoReg, 0x400E006CU) /**< \brief (SMC) SMC ECC parity 15 Register */
#define REG_SMC_SETUP0        REG_ACCESS(RwReg, 0x400E0070U) /**< \brief (SMC) SMC SETUP Register (CS_number = 0) */
#define REG_SMC_PULSE0        REG_ACCESS(RwReg, 0x400E0074U) /**< \brief (SMC) SMC PULSE Register (CS_number = 0) */
#define REG_SMC_CYCLE0        REG_ACCESS(RwReg, 0x400E0078U) /**< \brief (SMC) SMC CYCLE Register (CS_number = 0) */
#define REG_SMC_TIMINGS0      REG_ACCESS(RwReg, 0x400E007CU) /**< \brief (SMC) SMC TIMINGS Register (CS_number = 0) */
#define REG_SMC_MODE0         REG_ACCESS(RwReg, 0x400E0080U) /**< \brief (SMC) SMC MODE Register (CS_number = 0) */
#define REG_SMC_SETUP1        REG_ACCESS(RwReg, 0x400E0084U) /**< \brief (SMC) SMC SETUP Register (CS_number = 1) */
#define REG_SMC_PULSE1        REG_ACCESS(RwReg, 0x400E0088U) /**< \brief (SMC) SMC PULSE Register (CS_number = 1) */
#define REG_SMC_CYCLE1        REG_ACCESS(RwReg, 0x400E008CU) /**< \brief (SMC) SMC CYCLE Register (CS_number = 1) */
#define REG_SMC_TIMINGS1      REG_ACCESS(RwReg, 0x400E0090U) /**< \brief (SMC) SMC TIMINGS Register (CS_number = 1) */
#define REG_SMC_MODE1         REG_ACCESS(RwReg, 0x400E0094U) /**< \brief (SMC) SMC MODE Register (CS_number = 1) */
#define REG_SMC_SETUP2        REG_ACCESS(RwReg, 0x400E0098U) /**< \brief (SMC) SMC SETUP Register (CS_number = 2) */
#define REG_SMC_PULSE2        REG_ACCESS(RwReg, 0x400E009CU) /**< \brief (SMC) SMC PULSE Register (CS_number = 2) */
#define REG_SMC_CYCLE2        REG_ACCESS(RwReg, 0x400E00A0U) /**< \brief (SMC) SMC CYCLE Register (CS_number = 2) */
#define REG_SMC_TIMINGS2      REG_ACCESS(RwReg, 0x400E00A4U) /**< \brief (SMC) SMC TIMINGS Register (CS_number = 2) */
#define REG_SMC_MODE2         REG_ACCESS(RwReg, 0x400E00A8U) /**< \brief (SMC) SMC MODE Register (CS_number = 2) */
#define REG_SMC_SETUP3        REG_ACCESS(RwReg, 0x400E00ACU) /**< \brief (SMC) SMC SETUP Register (CS_number = 3) */
#define REG_SMC_PULSE3        REG_ACCESS(RwReg, 0x400E00B0U) /**< \brief (SMC) SMC PULSE Register (CS_number = 3) */
#define REG_SMC_CYCLE3        REG_ACCESS(RwReg, 0x400E00B4U) /**< \brief (SMC) SMC CYCLE Register (CS_number = 3) */
#define REG_SMC_TIMINGS3      REG_ACCESS(RwReg, 0x400E00B8U) /**< \brief (SMC) SMC TIMINGS Register (CS_number = 3) */
#define REG_SMC_MODE3         REG_ACCESS(RwReg, 0x400E00BCU) /**< \brief (SMC) SMC MODE Register (CS_number = 3) */
#define REG_SMC_OCMS          REG_ACCESS(RwReg, 0x400E0110U) /**< \brief (SMC) SMC OCMS MODE Register */
#define REG_SMC_KEY1          REG_ACCESS(WoReg, 0x400E0114U) /**< \brief (SMC) SMC KEY1 Register */
#define REG_SMC_KEY2          REG_ACCESS(WoReg, 0x400E0118U) /**< \brief (SMC) SMC KEY2 Register */
#define REG_SMC_WPCR          REG_ACCESS(WoReg, 0x400E01E4U) /**< \brief (SMC) Write Protection Control Register */
#define REG_SMC_WPSR          REG_ACCESS(RoReg, 0x400E01E8U) /**< \brief (SMC) Write Protection Status Register */
/* ========== Register definition for MATRIX peripheral ========== */
#define REG_MATRIX_MCFG       REG_ACCESS(RwReg, 0x400E0200U) /**< \brief (MATRIX) Master Configuration Register */
#define REG_MATRIX_SCFG       REG_ACCESS(RwReg, 0x400E0240U) /**< \brief (MATRIX) Slave Configuration Register */
#define REG_MATRIX_PRAS0      REG_ACCESS(RwReg, 0x400E0280U) /**< \brief (MATRIX) Priority Register A for Slave 0 */
#define REG_MATRIX_PRAS1      REG_ACCESS(RwReg, 0x400E0288U) /**< \brief (MATRIX) Priority Register A for Slave 1 */
#define REG_MATRIX_PRAS2      REG_ACCESS(RwReg, 0x400E0290U) /**< \brief (MATRIX) Priority Register A for Slave 2 */
#define REG_MATRIX_PRAS3      REG_ACCESS(RwReg, 0x400E0298U) /**< \brief (MATRIX) Priority Register A for Slave 3 */
#define REG_MATRIX_PRAS4      REG_ACCESS(RwReg, 0x400E02A0U) /**< \brief (MATRIX) Priority Register A for Slave 4 */
#define REG_MATRIX_PRAS5      REG_ACCESS(RwReg, 0x400E02A8U) /**< \brief (MATRIX) Priority Register A for Slave 5 */
#define REG_MATRIX_PRAS6      REG_ACCESS(RwReg, 0x400E02B0U) /**< \brief (MATRIX) Priority Register A for Slave 6 */
#define REG_MATRIX_PRAS7      REG_ACCESS(RwReg, 0x400E02B8U) /**< \brief (MATRIX) Priority Register A for Slave 7 */
#define REG_MATRIX_PRAS8      REG_ACCESS(RwReg, 0x400E02C0U) /**< \brief (MATRIX) Priority Register A for Slave 8 */
#define REG_MATRIX_PRAS9      REG_ACCESS(RwReg, 0x400E02C8U) /**< \brief (MATRIX) Priority Register A for Slave 9 */
#define REG_MATRIX_MRCR       REG_ACCESS(RwReg, 0x400E0300U) /**< \brief (MATRIX) Master Remap Control Register */
/* ========== Register definition for PMC peripheral ========== */
#define REG_PMC_SCER          REG_ACCESS(WoReg, 0x400E0400U) /**< \brief (PMC) System Clock Enable Register */
#define REG_PMC_SCDR          REG_ACCESS(WoReg, 0x400E0404U) /**< \brief (PMC) System Clock Disable Register */
#define REG_PMC_SCSR          REG_ACCESS(RoReg, 0x400E0408U) /**< \brief (PMC) System Clock Status Register */
#define REG_PMC_PCER          REG_ACCESS(WoReg, 0x400E0410U) /**< \brief (PMC) Peripheral Clock Enable Register */
#define REG_PMC_PCDR          REG_ACCESS(WoReg, 0x400E0414U) /**< \brief (PMC) Peripheral Clock Disable Register */
//#define REG_PMC_PCSR          REG_ACCESS(RoReg, 0x400E0418U) /**< \brief (PMC) Peripheral Clock Status Register */
#define REG_PMC_UCKR          REG_ACCESS(RwReg, 0x400E041CU) /**< \brief (PMC) UTMI Clock Register */
#define REG_PMC_MOR           REG_ACCESS(RwReg, 0x400E0420U) /**< \brief (PMC) Main Oscillator Register */
#define REG_PMC_MCFR          REG_ACCESS(RoReg, 0x400E0424U) /**< \brief (PMC) Main Clock Frequency Register */
#define REG_PMC_PLLAR         REG_ACCESS(RwReg, 0x400E0428U) /**< \brief (PMC) PLLA Register */
#define REG_PMC_MCKR          REG_ACCESS(RwReg, 0x400E0430U) /**< \brief (PMC) Master Clock Register */
#define REG_PMC_PCK           REG_ACCESS(RwReg, 0x400E0440U) /**< \brief (PMC) Programmable Clock 0 Register */
#define REG_PMC_IER           REG_ACCESS(WoReg, 0x400E0460U) /**< \brief (PMC) Interrupt Enable Register */
#define REG_PMC_IDR           REG_ACCESS(WoReg, 0x400E0464U) /**< \brief (PMC) Interrupt Disable Register */
#define REG_PMC_SR            REG_ACCESS(RoReg, 0x400E0468U) /**< \brief (PMC) Status Register */
#define REG_PMC_IMR           REG_ACCESS(RoReg, 0x400E046CU) /**< \brief (PMC) Interrupt Mask Register */
#define REG_PMC_FSMR          REG_ACCESS(RwReg, 0x400E0470U) /**< \brief (PMC) Fast Startup Mode Register */
#define REG_PMC_FSPR          REG_ACCESS(RwReg, 0x400E0474U) /**< \brief (PMC) Fast Startup Polarity Register */
#define REG_PMC_FOCR          REG_ACCESS(WoReg, 0x400E0478U) /**< \brief (PMC) Fault Output Clear Register */
/* ========== Register definition for UART peripheral ========== */
#define REG_UART_CR           REG_ACCESS(WoReg, 0x400E0600U) /**< \brief (UART) Control Register */
#define REG_UART_MR           REG_ACCESS(RwReg, 0x400E0604U) /**< \brief (UART) Mode Register */
#define REG_UART_IER          REG_ACCESS(WoReg, 0x400E0608U) /**< \brief (UART) Interrupt Enable Register */
#define REG_UART_IDR          REG_ACCESS(WoReg, 0x400E060CU) /**< \brief (UART) Interrupt Disable Register */
#define REG_UART_IMR          REG_ACCESS(RoReg, 0x400E0610U) /**< \brief (UART) Interrupt Mask Register */
#define REG_UART_SR           REG_ACCESS(RoReg, 0x400E0614U) /**< \brief (UART) Status Register */
#define REG_UART_RHR          REG_ACCESS(RoReg, 0x400E0618U) /**< \brief (UART) Receive Holding Register */
#define REG_UART_THR          REG_ACCESS(WoReg, 0x400E061CU) /**< \brief (UART) Transmit Holding Register */
#define REG_UART_BRGR         REG_ACCESS(RwReg, 0x400E0620U) /**< \brief (UART) Baud Rate Generator Register */
#define REG_UART_RPR          REG_ACCESS(RwReg, 0x400E0700U) /**< \brief (UART) Receive Pointer Register */
#define REG_UART_RCR          REG_ACCESS(RwReg, 0x400E0704U) /**< \brief (UART) Receive Counter Register */
#define REG_UART_TPR          REG_ACCESS(RwReg, 0x400E0708U) /**< \brief (UART) Transmit Pointer Register */
#define REG_UART_TCR          REG_ACCESS(RwReg, 0x400E070CU) /**< \brief (UART) Transmit Counter Register */
#define REG_UART_RNPR         REG_ACCESS(RwReg, 0x400E0710U) /**< \brief (UART) Receive Next Pointer Register */
#define REG_UART_RNCR         REG_ACCESS(RwReg, 0x400E0714U) /**< \brief (UART) Receive Next Counter Register */
#define REG_UART_TNPR         REG_ACCESS(RwReg, 0x400E0718U) /**< \brief (UART) Transmit Next Pointer Register */
#define REG_UART_TNCR         REG_ACCESS(RwReg, 0x400E071CU) /**< \brief (UART) Transmit Next Counter Register */
#define REG_UART_PTCR         REG_ACCESS(WoReg, 0x400E0720U) /**< \brief (UART) Transfer Control Register */
#define REG_UART_PTSR         REG_ACCESS(RoReg, 0x400E0724U) /**< \brief (UART) Transfer Status Register */
/* ========== Register definition for CHIPID peripheral ========== */
#define REG_CHIPID_CIDR       REG_ACCESS(RoReg, 0x400E0740U) /**< \brief (CHIPID) Chip ID Register */
#define REG_CHIPID_EXID       REG_ACCESS(RoReg, 0x400E0744U) /**< \brief (CHIPID) Chip ID Extension Register */
/* ========== Register definition for EFC0 peripheral ========== */
#define REG_EFC0_FMR          REG_ACCESS(RwReg, 0x400E0800U) /**< \brief (EFC0) EEFC Flash Mode Register */
#define REG_EFC0_FCR          REG_ACCESS(WoReg, 0x400E0804U) /**< \brief (EFC0) EEFC Flash Command Register */
#define REG_EFC0_FSR          REG_ACCESS(RoReg, 0x400E0808U) /**< \brief (EFC0) EEFC Flash Status Register */
#define REG_EFC0_FRR          REG_ACCESS(RoReg, 0x400E080CU) /**< \brief (EFC0) EEFC Flash Result Register */
/* ========== Register definition for EFC1 peripheral ========== */
#define REG_EFC1_FMR          REG_ACCESS(RwReg, 0x400E0A00U) /**< \brief (EFC1) EEFC Flash Mode Register */
#define REG_EFC1_FCR          REG_ACCESS(WoReg, 0x400E0A04U) /**< \brief (EFC1) EEFC Flash Command Register */
#define REG_EFC1_FSR          REG_ACCESS(RoReg, 0x400E0A08U) /**< \brief (EFC1) EEFC Flash Status Register */
#define REG_EFC1_FRR          REG_ACCESS(RoReg, 0x400E0A0CU) /**< \brief (EFC1) EEFC Flash Result Register */
/* ========== Register definition for PIOA peripheral ========== */
#define REG_PIOA_PER          REG_ACCESS(WoReg, 0x400E0C00U) /**< \brief (PIOA) PIO Enable Register */
#define REG_PIOA_PDR          REG_ACCESS(WoReg, 0x400E0C04U) /**< \brief (PIOA) PIO Disable Register */
#define REG_PIOA_PSR          REG_ACCESS(RoReg, 0x400E0C08U) /**< \brief (PIOA) PIO Status Register */
#define REG_PIOA_OER          REG_ACCESS(WoReg, 0x400E0C10U) /**< \brief (PIOA) Output Enable Register */
#define REG_PIOA_ODR          REG_ACCESS(WoReg, 0x400E0C14U) /**< \brief (PIOA) Output Disable Register */
#define REG_PIOA_OSR          REG_ACCESS(RoReg, 0x400E0C18U) /**< \brief (PIOA) Output Status Register */
#define REG_PIOA_IFER         REG_ACCESS(WoReg, 0x400E0C20U) /**< \brief (PIOA) Glitch Input Filter Enable Register */
#define REG_PIOA_IFDR         REG_ACCESS(WoReg, 0x400E0C24U) /**< \brief (PIOA) Glitch Input Filter Disable Register */
#define REG_PIOA_IFSR         REG_ACCESS(RoReg, 0x400E0C28U) /**< \brief (PIOA) Glitch Input Filter Status Register */
#define REG_PIOA_SODR         REG_ACCESS(WoReg, 0x400E0C30U) /**< \brief (PIOA) Set Output Data Register */
#define REG_PIOA_CODR         REG_ACCESS(WoReg, 0x400E0C34U) /**< \brief (PIOA) Clear Output Data Register */
#define REG_PIOA_ODSR         REG_ACCESS(RwReg, 0x400E0C38U) /**< \brief (PIOA) Output Data Status Register */
#define REG_PIOA_PDSR         REG_ACCESS(RoReg, 0x400E0C3CU) /**< \brief (PIOA) Pin Data Status Register */
#define REG_PIOA_IER          REG_ACCESS(WoReg, 0x400E0C40U) /**< \brief (PIOA) Interrupt Enable Register */
#define REG_PIOA_IDR          REG_ACCESS(WoReg, 0x400E0C44U) /**< \brief (PIOA) Interrupt Disable Register */
#define REG_PIOA_IMR          REG_ACCESS(RoReg, 0x400E0C48U) /**< \brief (PIOA) Interrupt Mask Register */
#define REG_PIOA_ISR          REG_ACCESS(RoReg, 0x400E0C4CU) /**< \brief (PIOA) Interrupt Status Register */
#define REG_PIOA_MDER         REG_ACCESS(WoReg, 0x400E0C50U) /**< \brief (PIOA) Multi-driver Enable Register */
#define REG_PIOA_MDDR         REG_ACCESS(WoReg, 0x400E0C54U) /**< \brief (PIOA) Multi-driver Disable Register */
#define REG_PIOA_MDSR         REG_ACCESS(RoReg, 0x400E0C58U) /**< \brief (PIOA) Multi-driver Status Register */
#define REG_PIOA_PUDR         REG_ACCESS(WoReg, 0x400E0C60U) /**< \brief (PIOA) Pull-up Disable Register */
#define REG_PIOA_PUER         REG_ACCESS(WoReg, 0x400E0C64U) /**< \brief (PIOA) Pull-up Enable Register */
#define REG_PIOA_PUSR         REG_ACCESS(RoReg, 0x400E0C68U) /**< \brief (PIOA) Pad Pull-up Status Register */
#define REG_PIOA_ABSR         REG_ACCESS(RwReg, 0x400E0C70U) /**< \brief (PIOA) Peripheral AB Select Register */
#define REG_PIOA_SCIFSR       REG_ACCESS(WoReg, 0x400E0C80U) /**< \brief (PIOA) System Clock Glitch Input Filter Select Register */
#define REG_PIOA_DIFSR        REG_ACCESS(WoReg, 0x400E0C84U) /**< \brief (PIOA) Debouncing Input Filter Select Register */
#define REG_PIOA_IFDGSR       REG_ACCESS(RoReg, 0x400E0C88U) /**< \brief (PIOA) Glitch or Debouncing Input Filter Clock Selection Status Register */
#define REG_PIOA_SCDR         REG_ACCESS(RwReg, 0x400E0C8CU) /**< \brief (PIOA) Slow Clock Divider Debouncing Register */
#define REG_PIOA_OWER         REG_ACCESS(WoReg, 0x400E0CA0U) /**< \brief (PIOA) Output Write Enable */
#define REG_PIOA_OWDR         REG_ACCESS(WoReg, 0x400E0CA4U) /**< \brief (PIOA) Output Write Disable */
#define REG_PIOA_OWSR         REG_ACCESS(RoReg, 0x400E0CA8U) /**< \brief (PIOA) Output Write Status Register */
#define REG_PIOA_AIMER        REG_ACCESS(WoReg, 0x400E0CB0U) /**< \brief (PIOA) Additional Interrupt Modes Enable Register */
#define REG_PIOA_AIMDR        REG_ACCESS(WoReg, 0x400E0CB4U) /**< \brief (PIOA) Additional Interrupt Modes Disables Register */
#define REG_PIOA_AIMMR        REG_ACCESS(RoReg, 0x400E0CB8U) /**< \brief (PIOA) Additional Interrupt Modes Mask Register */
#define REG_PIOA_ESR          REG_ACCESS(WoReg, 0x400E0CC0U) /**< \brief (PIOA) Edge Select Register */
#define REG_PIOA_LSR          REG_ACCESS(WoReg, 0x400E0CC4U) /**< \brief (PIOA) Level Select Register */
#define REG_PIOA_ELSR         REG_ACCESS(RoReg, 0x400E0CC8U) /**< \brief (PIOA) Edge/Level Status Register */
#define REG_PIOA_FELLSR       REG_ACCESS(WoReg, 0x400E0CD0U) /**< \brief (PIOA) Falling Edge/Low Level Select Register */
#define REG_PIOA_REHLSR       REG_ACCESS(WoReg, 0x400E0CD4U) /**< \brief (PIOA) Rising Edge/ High Level Select Register */
#define REG_PIOA_FRLHSR       REG_ACCESS(RoReg, 0x400E0CD8U) /**< \brief (PIOA) Fall/Rise - Low/High Status Register */
#define REG_PIOA_LOCKSR       REG_ACCESS(RoReg, 0x400E0CE0U) /**< \brief (PIOA) Lock Status */
#define REG_PIOA_WPMR         REG_ACCESS(RwReg, 0x400E0CE4U) /**< \brief (PIOA) Write Protect Mode Register */
#define REG_PIOA_WPSR         REG_ACCESS(RoReg, 0x400E0CE8U) /**< \brief (PIOA) Write Protect Status Register */
/* ========== Register definition for PIOB peripheral ========== */
#define REG_PIOB_PER          REG_ACCESS(WoReg, 0x400E0E00U) /**< \brief (PIOB) PIO Enable Register */
#define REG_PIOB_PDR          REG_ACCESS(WoReg, 0x400E0E04U) /**< \brief (PIOB) PIO Disable Register */
#define REG_PIOB_PSR          REG_ACCESS(RoReg, 0x400E0E08U) /**< \brief (PIOB) PIO Status Register */
#define REG_PIOB_OER          REG_ACCESS(WoReg, 0x400E0E10U) /**< \brief (PIOB) Output Enable Register */
#define REG_PIOB_ODR          REG_ACCESS(WoReg, 0x400E0E14U) /**< \brief (PIOB) Output Disable Register */
#define REG_PIOB_OSR          REG_ACCESS(RoReg, 0x400E0E18U) /**< \brief (PIOB) Output Status Register */
#define REG_PIOB_IFER         REG_ACCESS(WoReg, 0x400E0E20U) /**< \brief (PIOB) Glitch Input Filter Enable Register */
#define REG_PIOB_IFDR         REG_ACCESS(WoReg, 0x400E0E24U) /**< \brief (PIOB) Glitch Input Filter Disable Register */
#define REG_PIOB_IFSR         REG_ACCESS(RoReg, 0x400E0E28U) /**< \brief (PIOB) Glitch Input Filter Status Register */
#define REG_PIOB_SODR         REG_ACCESS(WoReg, 0x400E0E30U) /**< \brief (PIOB) Set Output Data Register */
#define REG_PIOB_CODR         REG_ACCESS(WoReg, 0x400E0E34U) /**< \brief (PIOB) Clear Output Data Register */
#define REG_PIOB_ODSR         REG_ACCESS(RwReg, 0x400E0E38U) /**< \brief (PIOB) Output Data Status Register */
#define REG_PIOB_PDSR         REG_ACCESS(RoReg, 0x400E0E3CU) /**< \brief (PIOB) Pin Data Status Register */
#define REG_PIOB_IER          REG_ACCESS(WoReg, 0x400E0E40U) /**< \brief (PIOB) Interrupt Enable Register */
#define REG_PIOB_IDR          REG_ACCESS(WoReg, 0x400E0E44U) /**< \brief (PIOB) Interrupt Disable Register */
#define REG_PIOB_IMR          REG_ACCESS(RoReg, 0x400E0E48U) /**< \brief (PIOB) Interrupt Mask Register */
#define REG_PIOB_ISR          REG_ACCESS(RoReg, 0x400E0E4CU) /**< \brief (PIOB) Interrupt Status Register */
#define REG_PIOB_MDER         REG_ACCESS(WoReg, 0x400E0E50U) /**< \brief (PIOB) Multi-driver Enable Register */
#define REG_PIOB_MDDR         REG_ACCESS(WoReg, 0x400E0E54U) /**< \brief (PIOB) Multi-driver Disable Register */
#define REG_PIOB_MDSR         REG_ACCESS(RoReg, 0x400E0E58U) /**< \brief (PIOB) Multi-driver Status Register */
#define REG_PIOB_PUDR         REG_ACCESS(WoReg, 0x400E0E60U) /**< \brief (PIOB) Pull-up Disable Register */
#define REG_PIOB_PUER         REG_ACCESS(WoReg, 0x400E0E64U) /**< \brief (PIOB) Pull-up Enable Register */
#define REG_PIOB_PUSR         REG_ACCESS(RoReg, 0x400E0E68U) /**< \brief (PIOB) Pad Pull-up Status Register */
#define REG_PIOB_ABSR         REG_ACCESS(RwReg, 0x400E0E70U) /**< \brief (PIOB) Peripheral AB Select Register */
#define REG_PIOB_SCIFSR       REG_ACCESS(WoReg, 0x400E0E80U) /**< \brief (PIOB) System Clock Glitch Input Filter Select Register */
#define REG_PIOB_DIFSR        REG_ACCESS(WoReg, 0x400E0E84U) /**< \brief (PIOB) Debouncing Input Filter Select Register */
#define REG_PIOB_IFDGSR       REG_ACCESS(RoReg, 0x400E0E88U) /**< \brief (PIOB) Glitch or Debouncing Input Filter Clock Selection Status Register */
#define REG_PIOB_SCDR         REG_ACCESS(RwReg, 0x400E0E8CU) /**< \brief (PIOB) Slow Clock Divider Debouncing Register */
#define REG_PIOB_OWER         REG_ACCESS(WoReg, 0x400E0EA0U) /**< \brief (PIOB) Output Write Enable */
#define REG_PIOB_OWDR         REG_ACCESS(WoReg, 0x400E0EA4U) /**< \brief (PIOB) Output Write Disable */
#define REG_PIOB_OWSR         REG_ACCESS(RoReg, 0x400E0EA8U) /**< \brief (PIOB) Output Write Status Register */
#define REG_PIOB_AIMER        REG_ACCESS(WoReg, 0x400E0EB0U) /**< \brief (PIOB) Additional Interrupt Modes Enable Register */
#define REG_PIOB_AIMDR        REG_ACCESS(WoReg, 0x400E0EB4U) /**< \brief (PIOB) Additional Interrupt Modes Disables Register */
#define REG_PIOB_AIMMR        REG_ACCESS(RoReg, 0x400E0EB8U) /**< \brief (PIOB) Additional Interrupt Modes Mask Register */
#define REG_PIOB_ESR          REG_ACCESS(WoReg, 0x400E0EC0U) /**< \brief (PIOB) Edge Select Register */
#define REG_PIOB_LSR          REG_ACCESS(WoReg, 0x400E0EC4U) /**< \brief (PIOB) Level Select Register */
#define REG_PIOB_ELSR         REG_ACCESS(RoReg, 0x400E0EC8U) /**< \brief (PIOB) Edge/Level Status Register */
#define REG_PIOB_FELLSR       REG_ACCESS(WoReg, 0x400E0ED0U) /**< \brief (PIOB) Falling Edge/Low Level Select Register */
#define REG_PIOB_REHLSR       REG_ACCESS(WoReg, 0x400E0ED4U) /**< \brief (PIOB) Rising Edge/ High Level Select Register */
#define REG_PIOB_FRLHSR       REG_ACCESS(RoReg, 0x400E0ED8U) /**< \brief (PIOB) Fall/Rise - Low/High Status Register */
#define REG_PIOB_LOCKSR       REG_ACCESS(RoReg, 0x400E0EE0U) /**< \brief (PIOB) Lock Status */
#define REG_PIOB_WPMR         REG_ACCESS(RwReg, 0x400E0EE4U) /**< \brief (PIOB) Write Protect Mode Register */
#define REG_PIOB_WPSR         REG_ACCESS(RoReg, 0x400E0EE8U) /**< \brief (PIOB) Write Protect Status Register */
/* ========== Register definition for PIOC peripheral ========== */
#define REG_PIOC_PER          REG_ACCESS(WoReg, 0x400E1000U) /**< \brief (PIOC) PIO Enable Register */
#define REG_PIOC_PDR          REG_ACCESS(WoReg, 0x400E1004U) /**< \brief (PIOC) PIO Disable Register */
#define REG_PIOC_PSR          REG_ACCESS(RoReg, 0x400E1008U) /**< \brief (PIOC) PIO Status Register */
#define REG_PIOC_OER          REG_ACCESS(WoReg, 0x400E1010U) /**< \brief (PIOC) Output Enable Register */
#define REG_PIOC_ODR          REG_ACCESS(WoReg, 0x400E1014U) /**< \brief (PIOC) Output Disable Register */
#define REG_PIOC_OSR          REG_ACCESS(RoReg, 0x400E1018U) /**< \brief (PIOC) Output Status Register */
#define REG_PIOC_IFER         REG_ACCESS(WoReg, 0x400E1020U) /**< \brief (PIOC) Glitch Input Filter Enable Register */
#define REG_PIOC_IFDR         REG_ACCESS(WoReg, 0x400E1024U) /**< \brief (PIOC) Glitch Input Filter Disable Register */
#define REG_PIOC_IFSR         REG_ACCESS(RoReg, 0x400E1028U) /**< \brief (PIOC) Glitch Input Filter Status Register */
#define REG_PIOC_SODR         REG_ACCESS(WoReg, 0x400E1030U) /**< \brief (PIOC) Set Output Data Register */
#define REG_PIOC_CODR         REG_ACCESS(WoReg, 0x400E1034U) /**< \brief (PIOC) Clear Output Data Register */
#define REG_PIOC_ODSR         REG_ACCESS(RwReg, 0x400E1038U) /**< \brief (PIOC) Output Data Status Register */
#define REG_PIOC_PDSR         REG_ACCESS(RoReg, 0x400E103CU) /**< \brief (PIOC) Pin Data Status Register */
#define REG_PIOC_IER          REG_ACCESS(WoReg, 0x400E1040U) /**< \brief (PIOC) Interrupt Enable Register */
#define REG_PIOC_IDR          REG_ACCESS(WoReg, 0x400E1044U) /**< \brief (PIOC) Interrupt Disable Register */
#define REG_PIOC_IMR          REG_ACCESS(RoReg, 0x400E1048U) /**< \brief (PIOC) Interrupt Mask Register */
#define REG_PIOC_ISR          REG_ACCESS(RoReg, 0x400E104CU) /**< \brief (PIOC) Interrupt Status Register */
#define REG_PIOC_MDER         REG_ACCESS(WoReg, 0x400E1050U) /**< \brief (PIOC) Multi-driver Enable Register */
#define REG_PIOC_MDDR         REG_ACCESS(WoReg, 0x400E1054U) /**< \brief (PIOC) Multi-driver Disable Register */
#define REG_PIOC_MDSR         REG_ACCESS(RoReg, 0x400E1058U) /**< \brief (PIOC) Multi-driver Status Register */
#define REG_PIOC_PUDR         REG_ACCESS(WoReg, 0x400E1060U) /**< \brief (PIOC) Pull-up Disable Register */
#define REG_PIOC_PUER         REG_ACCESS(WoReg, 0x400E1064U) /**< \brief (PIOC) Pull-up Enable Register */
#define REG_PIOC_PUSR         REG_ACCESS(RoReg, 0x400E1068U) /**< \brief (PIOC) Pad Pull-up Status Register */
#define REG_PIOC_ABSR         REG_ACCESS(RwReg, 0x400E1070U) /**< \brief (PIOC) Peripheral AB Select Register */
#define REG_PIOC_SCIFSR       REG_ACCESS(WoReg, 0x400E1080U) /**< \brief (PIOC) System Clock Glitch Input Filter Select Register */
#define REG_PIOC_DIFSR        REG_ACCESS(WoReg, 0x400E1084U) /**< \brief (PIOC) Debouncing Input Filter Select Register */
#define REG_PIOC_IFDGSR       REG_ACCESS(RoReg, 0x400E1088U) /**< \brief (PIOC) Glitch or Debouncing Input Filter Clock Selection Status Register */
#define REG_PIOC_SCDR         REG_ACCESS(RwReg, 0x400E108CU) /**< \brief (PIOC) Slow Clock Divider Debouncing Register */
#define REG_PIOC_OWER         REG_ACCESS(WoReg, 0x400E10A0U) /**< \brief (PIOC) Output Write Enable */
#define REG_PIOC_OWDR         REG_ACCESS(WoReg, 0x400E10A4U) /**< \brief (PIOC) Output Write Disable */
#define REG_PIOC_OWSR         REG_ACCESS(RoReg, 0x400E10A8U) /**< \brief (PIOC) Output Write Status Register */
#define REG_PIOC_AIMER        REG_ACCESS(WoReg, 0x400E10B0U) /**< \brief (PIOC) Additional Interrupt Modes Enable Register */
#define REG_PIOC_AIMDR        REG_ACCESS(WoReg, 0x400E10B4U) /**< \brief (PIOC) Additional Interrupt Modes Disables Register */
#define REG_PIOC_AIMMR        REG_ACCESS(RoReg, 0x400E10B8U) /**< \brief (PIOC) Additional Interrupt Modes Mask Register */
#define REG_PIOC_ESR          REG_ACCESS(WoReg, 0x400E10C0U) /**< \brief (PIOC) Edge Select Register */
#define REG_PIOC_LSR          REG_ACCESS(WoReg, 0x400E10C4U) /**< \brief (PIOC) Level Select Register */
#define REG_PIOC_ELSR         REG_ACCESS(RoReg, 0x400E10C8U) /**< \brief (PIOC) Edge/Level Status Register */
#define REG_PIOC_FELLSR       REG_ACCESS(WoReg, 0x400E10D0U) /**< \brief (PIOC) Falling Edge/Low Level Select Register */
#define REG_PIOC_REHLSR       REG_ACCESS(WoReg, 0x400E10D4U) /**< \brief (PIOC) Rising Edge/ High Level Select Register */
#define REG_PIOC_FRLHSR       REG_ACCESS(RoReg, 0x400E10D8U) /**< \brief (PIOC) Fall/Rise - Low/High Status Register */
#define REG_PIOC_LOCKSR       REG_ACCESS(RoReg, 0x400E10E0U) /**< \brief (PIOC) Lock Status */
#define REG_PIOC_WPMR         REG_ACCESS(RwReg, 0x400E10E4U) /**< \brief (PIOC) Write Protect Mode Register */
#define REG_PIOC_WPSR         REG_ACCESS(RoReg, 0x400E10E8U) /**< \brief (PIOC) Write Protect Status Register */
/* ========== Register definition for RSTC peripheral ========== */
#define REG_RSTC_CR           REG_ACCESS(WoReg, 0x400E1200U) /**< \brief (RSTC) Control Register */
#define REG_RSTC_SR           REG_ACCESS(RoReg, 0x400E1204U) /**< \brief (RSTC) Status Register */
#define REG_RSTC_MR           REG_ACCESS(RwReg, 0x400E1208U) /**< \brief (RSTC) Mode Register */
/* ========== Register definition for SUPC peripheral ========== */
#define REG_SUPC_CR           REG_ACCESS(WoReg, 0x400E1210U) /**< \brief (SUPC) Supply Controller Control Register */
#define REG_SUPC_SMMR         REG_ACCESS(RwReg, 0x400E1214U) /**< \brief (SUPC) Supply Controller Supply Monitor Mode Register */
#define REG_SUPC_MR           REG_ACCESS(RwReg, 0x400E1218U) /**< \brief (SUPC) Supply Controller Mode Register */
#define REG_SUPC_WUMR         REG_ACCESS(RwReg, 0x400E121CU) /**< \brief (SUPC) Supply Controller Wake Up Mode Register */
#define REG_SUPC_WUIR         REG_ACCESS(RwReg, 0x400E1220U) /**< \brief (SUPC) Supply Controller Wake Up Inputs Register */
#define REG_SUPC_SR           REG_ACCESS(RoReg, 0x400E1224U) /**< \brief (SUPC) Supply Controller Status Register */
/* ========== Register definition for RTT peripheral ========== */
#define REG_RTT_MR            REG_ACCESS(RwReg, 0x400E1230U) /**< \brief (RTT) Mode Register */
#define REG_RTT_AR            REG_ACCESS(RwReg, 0x400E1234U) /**< \brief (RTT) Alarm Register */
#define REG_RTT_VR            REG_ACCESS(RoReg, 0x400E1238U) /**< \brief (RTT) Value Register */
#define REG_RTT_SR            REG_ACCESS(RoReg, 0x400E123CU) /**< \brief (RTT) Status Register */
/* ========== Register definition for WDT peripheral ========== */
#define REG_WDT_CR            REG_ACCESS(WoReg, 0x400E1250U) /**< \brief (WDT) Control Register */
#define REG_WDT_MR            REG_ACCESS(RwReg, 0x400E1254U) /**< \brief (WDT) Mode Register */
#define REG_WDT_SR            REG_ACCESS(RoReg, 0x400E1258U) /**< \brief (WDT) Status Register */
/* ========== Register definition for RTC peripheral ========== */
#define REG_RTC_CR            REG_ACCESS(RwReg, 0x400E1260U) /**< \brief (RTC) Control Register */
#define REG_RTC_MR            REG_ACCESS(RwReg, 0x400E1264U) /**< \brief (RTC) Mode Register */
#define REG_RTC_TIMR          REG_ACCESS(RwReg, 0x400E1268U) /**< \brief (RTC) Time Register */
#define REG_RTC_CALR          REG_ACCESS(RwReg, 0x400E126CU) /**< \brief (RTC) Calendar Register */
#define REG_RTC_TIMALR        REG_ACCESS(RwReg, 0x400E1270U) /**< \brief (RTC) Time Alarm Register */
#define REG_RTC_CALALR        REG_ACCESS(RwReg, 0x400E1274U) /**< \brief (RTC) Calendar Alarm Register */
#define REG_RTC_SR            REG_ACCESS(RoReg, 0x400E1278U) /**< \brief (RTC) Status Register */
#define REG_RTC_SCCR          REG_ACCESS(WoReg, 0x400E127CU) /**< \brief (RTC) Status Clear Command Register */
#define REG_RTC_IER           REG_ACCESS(WoReg, 0x400E1280U) /**< \brief (RTC) Interrupt Enable Register */
#define REG_RTC_IDR           REG_ACCESS(WoReg, 0x400E1284U) /**< \brief (RTC) Interrupt Disable Register */
#define REG_RTC_IMR           REG_ACCESS(RoReg, 0x400E1288U) /**< \brief (RTC) Interrupt Mask Register */
#define REG_RTC_VER           REG_ACCESS(RoReg, 0x400E128CU) /**< \brief (RTC) Valid Entry Register */
/* ========== Register definition for GPBR peripheral ========== */
#define REG_GPBR_GPBR0        REG_ACCESS(RwReg, 0x400E1290U) /**< \brief (GPBR) General Purpose Backup Register 0 */
#define REG_GPBR_GPBR1        REG_ACCESS(RwReg, 0x400E1294U) /**< \brief (GPBR) General Purpose Backup Register 1 */
#define REG_GPBR_GPBR2        REG_ACCESS(RwReg, 0x400E1298U) /**< \brief (GPBR) General Purpose Backup Register 2 */
#define REG_GPBR_GPBR3        REG_ACCESS(RwReg, 0x400E129CU) /**< \brief (GPBR) General Purpose Backup Register 3 */
/*@}*/

/* ***************************************************************************** */
/*   PERIPHERAL ID DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_id Peripheral Ids Definitions */
/*@{*/

#define ID_SUPC   ( 0) /**< \brief Supply Controller (SUPC) */
#define ID_RSTC   ( 1) /**< \brief Reset Controller (RSTC) */
#define ID_RTC    ( 2) /**< \brief Real Time Clock (RTC) */
#define ID_RTT    ( 3) /**< \brief Real Time Timer (RTT) */
#define ID_WDT    ( 4) /**< \brief Watchdog Timer (WDT) */
#define ID_PMC    ( 5) /**< \brief Power Management Controller (PMC) */
#define ID_EFC0   ( 6) /**< \brief Enhanced Embedded Flash Controller 0 (EFC0) */
#define ID_EFC1   ( 7) /**< \brief Enhanced Embedded Flash Controller 1 (EFC1) */
#define ID_UART   ( 8) /**< \brief Universal Asynchronous Receiver Transmitter (UART) */
#define ID_SMC    ( 9) /**< \brief Static Memory Controller (SMC) */
#define ID_PIOA   (10) /**< \brief Parallel I/O Controller A, (PIOA) */
#define ID_PIOB   (11) /**< \brief Parallel I/O Controller B (PIOB) */
#define ID_PIOC   (12) /**< \brief Parallel I/O Controller C (PIOC) */
#define ID_USART0 (13) /**< \brief USART 0 (USART0) */
#define ID_USART1 (14) /**< \brief USART 1 (USART1) */
#define ID_USART2 (15) /**< \brief USART 2 (USART2) */
#define ID_USART3 (16) /**< \brief USART 3 (USART3) */
#define ID_HSMCI  (17) /**< \brief High Speed Multimedia Card Interface (HSMCI) */
#define ID_TWI0   (18) /**< \brief Two-Wire Interface 0 (TWI0) */
#define ID_TWI1   (19) /**< \brief Two-Wire Interface 1 (TWI1) */
#define ID_SPI    (20) /**< \brief Serial Peripheral Interface (SPI) */
#define ID_SSC    (21) /**< \brief Synchronous Serial Controller (SSC) */
#define ID_TC0    (22) /**< \brief Timer Counter 0 (TC0) */
#define ID_TC1    (23) /**< \brief Timer Counter 1 (TC1) */
#define ID_TC2    (24) /**< \brief Timer Counter 2 (TC2) */
#define ID_PWM    (25) /**< \brief Pulse Width Modulation Controller (PWM) */
#define ID_ADC12B (26) /**< \brief 12-bit ADC Controller (ADC12B) */
#define ID_ADC    (27) /**< \brief 10-bit ADC Controller (ADC) */
#define ID_DMAC   (28) /**< \brief DMA Controller (DMAC) */
#define ID_UDPHS  (29) /**< \brief USB Device High Speed (UDPHS) */
/*@}*/

/* ***************************************************************************** */
/*   BASE ADDRESS DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_base Peripheral Base Address Definitions */
/*@{*/

#define HSMCI      CAST(Hsmci     , 0x40000000U) /**< \brief (HSMCI     ) Base Address */
#define SSC        CAST(Ssc       , 0x40004000U) /**< \brief (SSC       ) Base Address */
#define SPI        CAST(Spi       , 0x40008000U) /**< \brief (SPI       ) Base Address */
#define TC0        CAST(Tc        , 0x40080000U) /**< \brief (TC0       ) Base Address */
#define TWI0       CAST(Twi       , 0x40084000U) /**< \brief (TWI0      ) Base Address */
#define PDC_TWI0   CAST(Pdc       , 0x40084100U) /**< \brief (PDC_TWI0  ) Base Address */
#define TWI1       CAST(Twi       , 0x40088000U) /**< \brief (TWI1      ) Base Address */
#define PDC_TWI1   CAST(Pdc       , 0x40088100U) /**< \brief (PDC_TWI1  ) Base Address */
#define PWM        CAST(Pwm       , 0x4008C000U) /**< \brief (PWM       ) Base Address */
#define PDC_PWM    CAST(Pdc       , 0x4008C100U) /**< \brief (PDC_PWM   ) Base Address */
#define USART0     CAST(Usart     , 0x40090000U) /**< \brief (USART0    ) Base Address */
#define PDC_USART0 CAST(Pdc       , 0x40090100U) /**< \brief (PDC_USART0) Base Address */
#define USART1     CAST(Usart     , 0x40094000U) /**< \brief (USART1    ) Base Address */
#define PDC_USART1 CAST(Pdc       , 0x40094100U) /**< \brief (PDC_USART1) Base Address */
#define USART2     CAST(Usart     , 0x40098000U) /**< \brief (USART2    ) Base Address */
#define PDC_USART2 CAST(Pdc       , 0x40098100U) /**< \brief (PDC_USART2) Base Address */
#define USART3     CAST(Usart     , 0x4009C000U) /**< \brief (USART3    ) Base Address */
#define PDC_USART3 CAST(Pdc       , 0x4009C100U) /**< \brief (PDC_USART3) Base Address */
#define UDPHS      CAST(Udphs     , 0x400A4000U) /**< \brief (UDPHS     ) Base Address */
#define ADC12B     CAST(Adc12b    , 0x400A8000U) /**< \brief (ADC12B    ) Base Address */
#define PDC_ADC12B CAST(Pdc       , 0x400A8100U) /**< \brief (PDC_ADC12B) Base Address */
#define ADC        CAST(Adc       , 0x400AC000U) /**< \brief (ADC       ) Base Address */
#define PDC_ADC    CAST(Pdc       , 0x400AC100U) /**< \brief (PDC_ADC   ) Base Address */
#define DMAC       CAST(Dmac      , 0x400B0000U) /**< \brief (DMAC      ) Base Address */
#define SMC        CAST(Smc       , 0x400E0000U) /**< \brief (SMC       ) Base Address */
#define MATRIX     CAST(Matrix    , 0x400E0200U) /**< \brief (MATRIX    ) Base Address */
#define PMC        CAST(Pmc       , 0x400E0400U) /**< \brief (PMC       ) Base Address */
#define UART       CAST(Uart      , 0x400E0600U) /**< \brief (UART      ) Base Address */
#define PDC_UART   CAST(Pdc       , 0x400E0700U) /**< \brief (PDC_UART  ) Base Address */
#define CHIPID     CAST(Chipid    , 0x400E0740U) /**< \brief (CHIPID    ) Base Address */
#define EFC0       CAST(Efc       , 0x400E0800U) /**< \brief (EFC0      ) Base Address */
#define EFC1       CAST(Efc       , 0x400E0A00U) /**< \brief (EFC1      ) Base Address */
#define PIOA       CAST(Pio       , 0x400E0C00U) /**< \brief (PIOA      ) Base Address */
#define PIOB       CAST(Pio       , 0x400E0E00U) /**< \brief (PIOB      ) Base Address */
#define PIOC       CAST(Pio       , 0x400E1000U) /**< \brief (PIOC      ) Base Address */
#define RSTC       CAST(Rstc      , 0x400E1200U) /**< \brief (RSTC      ) Base Address */
#define SUPC       CAST(Supc      , 0x400E1210U) /**< \brief (SUPC      ) Base Address */
#define RTT        CAST(Rtt       , 0x400E1230U) /**< \brief (RTT       ) Base Address */
#define WDT        CAST(Wdt       , 0x400E1250U) /**< \brief (WDT       ) Base Address */
#define RTC        CAST(Rtc       , 0x400E1260U) /**< \brief (RTC       ) Base Address */
#define GPBR       CAST(Gpbr      , 0x400E1290U) /**< \brief (GPBR      ) Base Address */
/*@}*/

/* ***************************************************************************** */
/*   PIO DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */
/** \addtogroup AT91SAM3U_pio Peripheral Pio Definitions */
/*@{*/

#define PIO_PA0                (1 << 0) /**< \brief Pin Controlled by PA0 */
#define PIO_PA1                (1 << 1) /**< \brief Pin Controlled by PA1 */
#define PIO_PA2                (1 << 2) /**< \brief Pin Controlled by PA2 */
#define PIO_PA3                (1 << 3) /**< \brief Pin Controlled by PA3 */
#define PIO_PA4                (1 << 4) /**< \brief Pin Controlled by PA4 */
#define PIO_PA5                (1 << 5) /**< \brief Pin Controlled by PA5 */
#define PIO_PA6                (1 << 6) /**< \brief Pin Controlled by PA6 */
#define PIO_PA7                (1 << 7) /**< \brief Pin Controlled by PA7 */
#define PIO_PA8                (1 << 8) /**< \brief Pin Controlled by PA8 */
#define PIO_PA9                (1 << 9) /**< \brief Pin Controlled by PA9 */
#define PIO_PA10               (1 << 10) /**< \brief Pin Controlled by PA10 */
#define PIO_PA11               (1 << 11) /**< \brief Pin Controlled by PA11 */
#define PIO_PA12               (1 << 12) /**< \brief Pin Controlled by PA12 */
#define PIO_PA13               (1 << 13) /**< \brief Pin Controlled by PA13 */
#define PIO_PA14               (1 << 14) /**< \brief Pin Controlled by PA14 */
#define PIO_PA15               (1 << 15) /**< \brief Pin Controlled by PA15 */
#define PIO_PA16               (1 << 16) /**< \brief Pin Controlled by PA16 */
#define PIO_PA17               (1 << 17) /**< \brief Pin Controlled by PA17 */
#define PIO_PA18               (1 << 18) /**< \brief Pin Controlled by PA18 */
#define PIO_PA19               (1 << 19) /**< \brief Pin Controlled by PA19 */
#define PIO_PA20               (1 << 20) /**< \brief Pin Controlled by PA20 */
#define PIO_PA21               (1 << 21) /**< \brief Pin Controlled by PA21 */
#define PIO_PA22               (1 << 22) /**< \brief Pin Controlled by PA22 */
#define PIO_PA23               (1 << 23) /**< \brief Pin Controlled by PA23 */
#define PIO_PA24               (1 << 24) /**< \brief Pin Controlled by PA24 */
#define PIO_PA25               (1 << 25) /**< \brief Pin Controlled by PA25 */
#define PIO_PA26               (1 << 26) /**< \brief Pin Controlled by PA26 */
#define PIO_PA27               (1 << 27) /**< \brief Pin Controlled by PA27 */
#define PIO_PA28               (1 << 28) /**< \brief Pin Controlled by PA28 */
#define PIO_PA29               (1 << 29) /**< \brief Pin Controlled by PA29 */
#define PIO_PA30               (1 << 30) /**< \brief Pin Controlled by PA30 */
#define PIO_PA31               (1 << 31) /**< \brief Pin Controlled by PA31 */
#define PIO_PB0                (1 << 0) /**< \brief Pin Controlled by PB0 */
#define PIO_PB1                (1 << 1) /**< \brief Pin Controlled by PB1 */
#define PIO_PB2                (1 << 2) /**< \brief Pin Controlled by PB2 */
#define PIO_PB3                (1 << 3) /**< \brief Pin Controlled by PB3 */
#define PIO_PB4                (1 << 4) /**< \brief Pin Controlled by PB4 */
#define PIO_PB5                (1 << 5) /**< \brief Pin Controlled by PB5 */
#define PIO_PB6                (1 << 6) /**< \brief Pin Controlled by PB6 */
#define PIO_PB7                (1 << 7) /**< \brief Pin Controlled by PB7 */
#define PIO_PB8                (1 << 8) /**< \brief Pin Controlled by PB8 */
#define PIO_PB9                (1 << 9) /**< \brief Pin Controlled by PB9 */
#define PIO_PB10               (1 << 10) /**< \brief Pin Controlled by PB10 */
#define PIO_PB11               (1 << 11) /**< \brief Pin Controlled by PB11 */
#define PIO_PB12               (1 << 12) /**< \brief Pin Controlled by PB12 */
#define PIO_PB13               (1 << 13) /**< \brief Pin Controlled by PB13 */
#define PIO_PB14               (1 << 14) /**< \brief Pin Controlled by PB14 */
#define PIO_PB15               (1 << 15) /**< \brief Pin Controlled by PB15 */
#define PIO_PB16               (1 << 16) /**< \brief Pin Controlled by PB16 */
#define PIO_PB17               (1 << 17) /**< \brief Pin Controlled by PB17 */
#define PIO_PB18               (1 << 18) /**< \brief Pin Controlled by PB18 */
#define PIO_PB19               (1 << 19) /**< \brief Pin Controlled by PB19 */
#define PIO_PB20               (1 << 20) /**< \brief Pin Controlled by PB20 */
#define PIO_PB21               (1 << 21) /**< \brief Pin Controlled by PB21 */
#define PIO_PB22               (1 << 22) /**< \brief Pin Controlled by PB22 */
#define PIO_PB23               (1 << 23) /**< \brief Pin Controlled by PB23 */
#define PIO_PB24               (1 << 24) /**< \brief Pin Controlled by PB24 */
#define PIO_PB25               (1 << 25) /**< \brief Pin Controlled by PB25 */
#define PIO_PB26               (1 << 26) /**< \brief Pin Controlled by PB26 */
#define PIO_PB27               (1 << 27) /**< \brief Pin Controlled by PB27 */
#define PIO_PB28               (1 << 28) /**< \brief Pin Controlled by PB28 */
#define PIO_PB29               (1 << 29) /**< \brief Pin Controlled by PB29 */
#define PIO_PB30               (1 << 30) /**< \brief Pin Controlled by PB30 */
#define PIO_PB31               (1 << 31) /**< \brief Pin Controlled by PB31 */
#define PIO_PC0                (1 << 0) /**< \brief Pin Controlled by PC0 */
#define PIO_PC1                (1 << 1) /**< \brief Pin Controlled by PC1 */
#define PIO_PC2                (1 << 2) /**< \brief Pin Controlled by PC2 */
#define PIO_PC3                (1 << 3) /**< \brief Pin Controlled by PC3 */
#define PIO_PC4                (1 << 4) /**< \brief Pin Controlled by PC4 */
#define PIO_PC5                (1 << 5) /**< \brief Pin Controlled by PC5 */
#define PIO_PC6                (1 << 6) /**< \brief Pin Controlled by PC6 */
#define PIO_PC7                (1 << 7) /**< \brief Pin Controlled by PC7 */
#define PIO_PC8                (1 << 8) /**< \brief Pin Controlled by PC8 */
#define PIO_PC9                (1 << 9) /**< \brief Pin Controlled by PC9 */
#define PIO_PC10               (1 << 10) /**< \brief Pin Controlled by PC10 */
#define PIO_PC11               (1 << 11) /**< \brief Pin Controlled by PC11 */
#define PIO_PC12               (1 << 12) /**< \brief Pin Controlled by PC12 */
#define PIO_PC13               (1 << 13) /**< \brief Pin Controlled by PC13 */
#define PIO_PC14               (1 << 14) /**< \brief Pin Controlled by PC14 */
#define PIO_PC15               (1 << 15) /**< \brief Pin Controlled by PC15 */
#define PIO_PC16               (1 << 16) /**< \brief Pin Controlled by PC16 */
#define PIO_PC17               (1 << 17) /**< \brief Pin Controlled by PC17 */
#define PIO_PC18               (1 << 18) /**< \brief Pin Controlled by PC18 */
#define PIO_PC19               (1 << 19) /**< \brief Pin Controlled by PC19 */
#define PIO_PC20               (1 << 20) /**< \brief Pin Controlled by PC20 */
#define PIO_PC21               (1 << 21) /**< \brief Pin Controlled by PC21 */
#define PIO_PC22               (1 << 22) /**< \brief Pin Controlled by PC22 */
#define PIO_PC23               (1 << 23) /**< \brief Pin Controlled by PC23 */
#define PIO_PC24               (1 << 24) /**< \brief Pin Controlled by PC24 */
#define PIO_PC25               (1 << 25) /**< \brief Pin Controlled by PC25 */
#define PIO_PC26               (1 << 26) /**< \brief Pin Controlled by PC26 */
#define PIO_PC27               (1 << 27) /**< \brief Pin Controlled by PC27 */
#define PIO_PC28               (1 << 28) /**< \brief Pin Controlled by PC28 */
#define PIO_PC29               (1 << 29) /**< \brief Pin Controlled by PC29 */
#define PIO_PC30               (1 << 30) /**< \brief Pin Controlled by PC30 */
#define PIO_PC31               (1 << 31) /**< \brief Pin Controlled by PC31 */
/* ========== Pio definition for HSMCI peripheral ========== */
#define PIO_PA4A_MCCDA       (1 << 4)    /**< \brief Hsmci signal: MCCDA */
#define PIO_PA3A_MCCK        (1 << 3)    /**< \brief Hsmci signal: MCCK */
#define PIO_PA5A_MCDA0       (1 << 5)    /**< \brief Hsmci signal: MCDA0 */
#define PIO_PA6A_MCDA1       (1 << 6)    /**< \brief Hsmci signal: MCDA1 */
#define PIO_PA7A_MCDA2       (1 << 7)    /**< \brief Hsmci signal: MCDA2 */
#define PIO_PA8A_MCDA3       (1 << 8)    /**< \brief Hsmci signal: MCDA3 */
#define PIO_PC28B_MCDA4      (1 << 28)   /**< \brief Hsmci signal: MCDA4 */
#define PIO_PC29B_MCDA5      (1 << 29)   /**< \brief Hsmci signal: MCDA5 */
#define PIO_PC30B_MCDA6      (1 << 30)   /**< \brief Hsmci signal: MCDA6 */
#define PIO_PC31B_MCDA7      (1 << 31)   /**< \brief Hsmci signal: MCDA7 */
/* ========== Pio definition for SSC peripheral ========== */
#define PIO_PA27A_RD         (1 << 27)   /**< \brief Ssc signal: RD */
#define PIO_PA31A_RF         (1 << 31)   /**< \brief Ssc signal: RF */
#define PIO_PA29A_RK         (1 << 29)   /**< \brief Ssc signal: RK */
#define PIO_PA26A_TD         (1 << 26)   /**< \brief Ssc signal: TD */
#define PIO_PA30A_TF         (1 << 30)   /**< \brief Ssc signal: TF */
#define PIO_PA28A_TK         (1 << 28)   /**< \brief Ssc signal: TK */
/* ========== Pio definition for SPI peripheral ========== */
#define PIO_PA13A_MISO       (1 << 13)   /**< \brief Spi signal: MISO */
#define PIO_PA14A_MOSI       (1 << 14)   /**< \brief Spi signal: MOSI */
#define PIO_PA16A_NPCS0      (1 << 16)   /**< \brief Spi signal: NPCS0 */
#define PIO_PA0B_NPCS1       (1 << 0)    /**< \brief Spi signal: NPCS1 */
#define PIO_PC19B_NPCS1      (1 << 19)   /**< \brief Spi signal: NPCS1 */
#define PIO_PC3B_NPCS1       (1 << 3)    /**< \brief Spi signal: NPCS1 */
#define PIO_PA1B_NPCS2       (1 << 1)    /**< \brief Spi signal: NPCS2 */
#define PIO_PC14B_NPCS2      (1 << 14)   /**< \brief Spi signal: NPCS2 */
#define PIO_PC4B_NPCS2       (1 << 4)    /**< \brief Spi signal: NPCS2 */
#define PIO_PA19B_NPCS3      (1 << 19)   /**< \brief Spi signal: NPCS3 */
#define PIO_PC5B_NPCS3       (1 << 5)    /**< \brief Spi signal: NPCS3 */
#define PIO_PA15A_SPCK       (1 << 15)   /**< \brief Spi signal: SPCK */
/* ========== Pio definition for TC0 peripheral ========== */
#define PIO_PA2A_TCLK0       (1 << 2)    /**< \brief Tc0 signal: TCLK0 */
#define PIO_PB4A_TCLK1       (1 << 4)    /**< \brief Tc0 signal: TCLK1 */
#define PIO_PA26B_TCLK2      (1 << 26)   /**< \brief Tc0 signal: TCLK2 */
#define PIO_PA1A_TIOA0       (1 << 1)    /**< \brief Tc0 signal: TIOA0 */
#define PIO_PB5A_TIOA1       (1 << 5)    /**< \brief Tc0 signal: TIOA1 */
#define PIO_PA30B_TIOA2      (1 << 30)   /**< \brief Tc0 signal: TIOA2 */
#define PIO_PA0A_TIOB0       (1 << 0)    /**< \brief Tc0 signal: TIOB0 */
#define PIO_PB6A_TIOB1       (1 << 6)    /**< \brief Tc0 signal: TIOB1 */
#define PIO_PA31B_TIOB2      (1 << 31)   /**< \brief Tc0 signal: TIOB2 */
/* ========== Pio definition for TWI0 peripheral ========== */
#define PIO_PA10A_TWCK0      (1 << 10)   /**< \brief Twi0 signal: TWCK0 */
#define PIO_PA9A_TWD0        (1 << 9)    /**< \brief Twi0 signal: TWD0 */
/* ========== Pio definition for TWI1 peripheral ========== */
#define PIO_PA25A_TWCK1      (1 << 25)   /**< \brief Twi1 signal: TWCK1 */
#define PIO_PA24A_TWD1       (1 << 24)   /**< \brief Twi1 signal: TWD1 */
/* ========== Pio definition for PWM peripheral ========== */
#define PIO_PA11B_PWMFI0     (1 << 11)   /**< \brief Pwm signal: PWMFI0 */
#define PIO_PA12B_PWMFI1     (1 << 12)   /**< \brief Pwm signal: PWMFI1 */
#define PIO_PA18B_PWMFI2     (1 << 18)   /**< \brief Pwm signal: PWMFI2 */
#define PIO_PA28B_PWMH0      (1 << 28)   /**< \brief Pwm signal: PWMH0 */
#define PIO_PA4B_PWMH0       (1 << 4)    /**< \brief Pwm signal: PWMH0 */
#define PIO_PB0A_PWMH0       (1 << 0)    /**< \brief Pwm signal: PWMH0 */
#define PIO_PB13B_PWMH0      (1 << 13)   /**< \brief Pwm signal: PWMH0 */
#define PIO_PC24B_PWMH0      (1 << 24)   /**< \brief Pwm signal: PWMH0 */
#define PIO_PA29B_PWMH1      (1 << 29)   /**< \brief Pwm signal: PWMH1 */
#define PIO_PA5B_PWMH1       (1 << 5)    /**< \brief Pwm signal: PWMH1 */
#define PIO_PB1A_PWMH1       (1 << 1)    /**< \brief Pwm signal: PWMH1 */
#define PIO_PB14B_PWMH1      (1 << 14)   /**< \brief Pwm signal: PWMH1 */
#define PIO_PC25B_PWMH1      (1 << 25)   /**< \brief Pwm signal: PWMH1 */
#define PIO_PA15B_PWMH2      (1 << 15)   /**< \brief Pwm signal: PWMH2 */
#define PIO_PA6B_PWMH2       (1 << 6)    /**< \brief Pwm signal: PWMH2 */
#define PIO_PB15B_PWMH2      (1 << 15)   /**< \brief Pwm signal: PWMH2 */
#define PIO_PB2A_PWMH2       (1 << 2)    /**< \brief Pwm signal: PWMH2 */
#define PIO_PC26B_PWMH2      (1 << 26)   /**< \brief Pwm signal: PWMH2 */
#define PIO_PA20B_PWMH3      (1 << 20)   /**< \brief Pwm signal: PWMH3 */
#define PIO_PB16B_PWMH3      (1 << 16)   /**< \brief Pwm signal: PWMH3 */
#define PIO_PB3A_PWMH3       (1 << 3)    /**< \brief Pwm signal: PWMH3 */
#define PIO_PC27B_PWMH3      (1 << 27)   /**< \brief Pwm signal: PWMH3 */
#define PIO_PA7B_PWML0       (1 << 7)    /**< \brief Pwm signal: PWML0 */
#define PIO_PB17B_PWML0      (1 << 17)   /**< \brief Pwm signal: PWML0 */
#define PIO_PB25B_PWML0      (1 << 25)   /**< \brief Pwm signal: PWML0 */
#define PIO_PC29A_PWML0      (1 << 29)   /**< \brief Pwm signal: PWML0 */
#define PIO_PC6B_PWML0       (1 << 6)    /**< \brief Pwm signal: PWML0 */
#define PIO_PA8B_PWML1       (1 << 8)    /**< \brief Pwm signal: PWML1 */
#define PIO_PB18B_PWML1      (1 << 18)   /**< \brief Pwm signal: PWML1 */
#define PIO_PB26B_PWML1      (1 << 26)   /**< \brief Pwm signal: PWML1 */
#define PIO_PC30A_PWML1      (1 << 30)   /**< \brief Pwm signal: PWML1 */
#define PIO_PC7B_PWML1       (1 << 7)    /**< \brief Pwm signal: PWML1 */
#define PIO_PA9B_PWML2       (1 << 9)    /**< \brief Pwm signal: PWML2 */
#define PIO_PB19B_PWML2      (1 << 19)   /**< \brief Pwm signal: PWML2 */
#define PIO_PB27B_PWML2      (1 << 27)   /**< \brief Pwm signal: PWML2 */
#define PIO_PC31A_PWML2      (1 << 31)   /**< \brief Pwm signal: PWML2 */
#define PIO_PC8B_PWML2       (1 << 8)    /**< \brief Pwm signal: PWML2 */
#define PIO_PA10B_PWML3      (1 << 10)   /**< \brief Pwm signal: PWML3 */
#define PIO_PB20B_PWML3      (1 << 20)   /**< \brief Pwm signal: PWML3 */
#define PIO_PB28B_PWML3      (1 << 28)   /**< \brief Pwm signal: PWML3 */
#define PIO_PC16B_PWML3      (1 << 16)   /**< \brief Pwm signal: PWML3 */
#define PIO_PC9B_PWML3       (1 << 9)    /**< \brief Pwm signal: PWML3 */
/* ========== Pio definition for USART0 peripheral ========== */
#define PIO_PB8A_CTS0        (1 << 8)    /**< \brief Usart0 signal: CTS0 */
#define PIO_PB11B_DCD0       (1 << 11)   /**< \brief Usart0 signal: DCD0 */
#define PIO_PB10B_DSR0       (1 << 10)   /**< \brief Usart0 signal: DSR0 */
#define PIO_PB9B_DTR0        (1 << 9)    /**< \brief Usart0 signal: DTR0 */
#define PIO_PB12B_RI0        (1 << 12)   /**< \brief Usart0 signal: RI0 */
#define PIO_PB7A_RTS0        (1 << 7)    /**< \brief Usart0 signal: RTS0 */
#define PIO_PA19A_RXD0       (1 << 19)   /**< \brief Usart0 signal: RXD0 */
#define PIO_PA17A_SCK0       (1 << 17)   /**< \brief Usart0 signal: SCK0 */
#define PIO_PA18A_TXD0       (1 << 18)   /**< \brief Usart0 signal: TXD0 */
/* ========== Pio definition for USART1 peripheral ========== */
#define PIO_PA23B_CTS1       (1 << 23)   /**< \brief Usart1 signal: CTS1 */
#define PIO_PA22B_RTS1       (1 << 22)   /**< \brief Usart1 signal: RTS1 */
#define PIO_PA21A_RXD1       (1 << 21)   /**< \brief Usart1 signal: RXD1 */
#define PIO_PA24B_SCK1       (1 << 24)   /**< \brief Usart1 signal: SCK1 */
#define PIO_PA20A_TXD1       (1 << 20)   /**< \brief Usart1 signal: TXD1 */
/* ========== Pio definition for USART2 peripheral ========== */
#define PIO_PB22B_CTS2       (1 << 22)   /**< \brief Usart2 signal: CTS2 */
#define PIO_PB21B_RTS2       (1 << 21)   /**< \brief Usart2 signal: RTS2 */
#define PIO_PA23A_RXD2       (1 << 23)   /**< \brief Usart2 signal: RXD2 */
#define PIO_PA25B_SCK2       (1 << 25)   /**< \brief Usart2 signal: SCK2 */
#define PIO_PA22A_TXD2       (1 << 22)   /**< \brief Usart2 signal: TXD2 */
/* ========== Pio definition for USART3 peripheral ========== */
#define PIO_PC10B_CTS3       (1 << 10)   /**< \brief Usart3 signal: CTS3 */
#define PIO_PC11B_RTS3       (1 << 11)   /**< \brief Usart3 signal: RTS3 */
#define PIO_PC13B_RXD3       (1 << 13)   /**< \brief Usart3 signal: RXD3 */
#define PIO_PC19A_SCK3       (1 << 19)   /**< \brief Usart3 signal: SCK3 */
#define PIO_PC12B_TXD3       (1 << 12)   /**< \brief Usart3 signal: TXD3 */
/* ========== Pio definition for ADC12B peripheral ========== */
#define PIO_PA2B_AD12BTRG    (1 << 2)    /**< \brief Adc12b signal: AD12BTRG */
/* ========== Pio definition for ADC peripheral ========== */
#define PIO_PA17B_ADTRG      (1 << 17)   /**< \brief Adc signal: ADTRG */
/* ========== Pio definition for PMC peripheral ========== */
#define PIO_PA21B_PCK0       (1 << 21)   /**< \brief Pmc signal: PCK0 */
#define PIO_PA27B_PCK0       (1 << 27)   /**< \brief Pmc signal: PCK0 */
#define PIO_PA3B_PCK1        (1 << 3)    /**< \brief Pmc signal: PCK1 */
#define PIO_PB24B_PCK1       (1 << 24)   /**< \brief Pmc signal: PCK1 */
#define PIO_PB23B_PCK2       (1 << 23)   /**< \brief Pmc signal: PCK2 */
/* ========== Pio definition for UART peripheral ========== */
#define PIO_PA11A_URXD       (1 << 11)   /**< \brief Uart signal: URXD */
#define PIO_PA12A_UTXD       (1 << 12)   /**< \brief Uart signal: UTXD */
/*@}*/

/* ***************************************************************************** */
/*   MEMORY MAPPING DEFINITIONS FOR AT91SAM3U */
/* ***************************************************************************** */

#define AT91C_IRAM   (0x20000000) /**< Internal RAM base address */
#define AT91C_IFLASH (0x00080000) /**< Internal Flash base address */
//#define AT91C_IFLASH (0x00100000) /**< Internal Flash base address */
#define AT91C_IROM   (0x00180000) /**< Internal ROM base address */
//#define AT91C_IRAM   (0x20000000) /**< Internal RAM base address */
//#define AT91C_IRAM   (0x20080000) /**< Internal RAM base address */

#ifdef __cplusplus
}
#endif

/*@}*/

#endif /* AT91SAM3U_H */
