package jp.sourceforge.freegantt.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.sourceforge.freegantt.locale.Resource;

public class VersionDialog extends JDialog {
	private static final long serialVersionUID = -413258717427967377L;

	Application app;
	Image background;
	
	public VersionDialog(Application app) {
		super(app, true);
		this.app = app;
		
		setContentPane(new ContentPane());
		getContentPane().setPreferredSize(new Dimension(300, 78));
		setTitle(Resource.get("versionTitle"));
		setIconImage(app.getApplicationIconImage());
		setResizable(false);
		pack();
		
		background = Toolkit.getDefaultToolkit().getImage(getClass().getResource("versionBg.png"));
	}
	
	class ContentPane extends JPanel {
		private static final long serialVersionUID = 8765155079195232710L;
		
		public ContentPane() {
			setLayout(null);
			
			JLabel label = new JLabel("<html><u>version " + Application.VERSION + "<u></html>");
			label.setBounds(12, 42, 100, 20);
			label.addMouseListener(new LabelMouseListener());
			add(label);
			label.setSize(label.getPreferredSize());
		}
		
		@Override
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);
			g.drawImage(background, 0, 0, this);
		}
		
		class LabelMouseListener implements MouseListener {
			CursorState cursorState = new CursorState(ContentPane.this);

			@Override
			public void mouseClicked(MouseEvent e) {
				app.openSiteRoot();
			}

			@Override
			public void mousePressed(MouseEvent e) {
			}

			@Override
			public void mouseReleased(MouseEvent e) {
			}

			@Override
			public void mouseEntered(MouseEvent e) {
				cursorState.setCursor(Cursor.HAND_CURSOR);
			}

			@Override
			public void mouseExited(MouseEvent e) {
				cursorState.setDefaultCursor();
			}
		}
	}
}
