package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import jp.sourceforge.freegantt.data.model.ProjectInfoChangedListener;
import jp.sourceforge.freegantt.locale.Resource;

public class ProjectRootPane extends JPanel {
	private static final long serialVersionUID = -189324575838088163L;

	Application app;
	JScrollPane summaryScrollPane;
	JTextField nameField;
	JTextArea summaryTextArea;
	
	public ProjectRootPane(final Application app) {
		super();
		this.app = app;

		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(new EmptyBorder(10, 10, 10, 10));
		app.getProject().getProjectInfoModel().addProjectInfoChangedListener(new ProjectInfoChangedHandler());
		
		JLabel titleLabel = new JLabel(Resource.get("infoName"));
		titleLabel.setAlignmentX(LEFT_ALIGNMENT);
		add(titleLabel);
		
		nameField = new JTextField();
		nameField.setBounds(0, 0, 100, 16);
		nameField.setPreferredSize(new Dimension(Integer.MAX_VALUE, 16));
		nameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
		nameField.setAlignmentX(LEFT_ALIGNMENT);
		nameField.setText(app.getProject().getName());
		nameField.addFocusListener(new FocusListener(){
			@Override
			public void focusGained(FocusEvent e) {
			}
			@Override
			public void focusLost(FocusEvent e) {
				app.getProject().getController().setName(nameField.getText());
			}
		});
		add(nameField);
		
		JLabel summaryLabel = new JLabel(Resource.get("infoSummary"));
		summaryLabel.setAlignmentX(LEFT_ALIGNMENT);
		add(summaryLabel);

		summaryTextArea = new JTextArea();
		summaryTextArea.setLineWrap(true);
		summaryTextArea.setText(app.getProject().getSummary());
		summaryTextArea.addFocusListener(new FocusListener(){
			@Override
			public void focusGained(FocusEvent e) {
			}
			@Override
			public void focusLost(FocusEvent e) {
				app.getProject().getController().setSummary(summaryTextArea.getText());
			}
		});
		
		summaryScrollPane = new JScrollPane(summaryTextArea);
		summaryScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
		summaryScrollPane.setMinimumSize(new Dimension(1, 120));
		summaryScrollPane.setAlignmentX(LEFT_ALIGNMENT);
		add(summaryScrollPane);
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		int otherHeight = 0;
		for (Component c: getComponents()) {
			if (c != summaryScrollPane) otherHeight += c.getHeight();
		}
		Rectangle r = summaryScrollPane.getBounds();
		summaryScrollPane.setBounds(r.x, r.y, r.width, getHeight() - 20 - otherHeight);
	}
	
	class ProjectInfoChangedHandler implements ProjectInfoChangedListener {

		@Override
		public void projectInfoChanged() {
			nameField.setText(app.getProject().getName());
			summaryTextArea.setText(app.getProject().getSummary());
		}
		
	}
}
