package jp.sourceforge.freegantt.swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

import jp.sourceforge.freegantt.data.model.ProjectViewChangedListener;


public class GanttChartPane extends JPanel {
	private static final long serialVersionUID = -968483593747003051L;
	
	Application app;
	
	GanttChartSplitPane ganttChartSplitPane;
	TaskLineRootPane taskLineRootPane;
	TaskListRootPane taskListRootPane;
	
	public GanttChartPane(Application app) {
		super(new BorderLayout());
		
		this.app = app;
		setBackground(Color.blue);
		app.getProject().getProjectViewModel().addProjectViewChangedListener(new ProjectViewChangedHandler());
		
		ganttChartSplitPane = new GanttChartSplitPane(app, JSplitPane.HORIZONTAL_SPLIT);
		ganttChartSplitPane.setBounds(0, 0, 300, 200);
		ganttChartSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setDividerSize(4);
		ganttChartSplitPane.setContinuousLayout(true);
		add(ganttChartSplitPane, BorderLayout.CENTER);
		
		taskListRootPane = new TaskListRootPane(app);
		taskListRootPane.setBounds(0, 0, 100, 200);
		taskListRootPane.setMinimumSize(new Dimension(0, 0));
		ganttChartSplitPane.add(taskListRootPane);
		
		taskLineRootPane = new TaskLineRootPane(app);
		taskLineRootPane.setBounds(0, 0, 500, 200);
		taskLineRootPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		ganttChartSplitPane.add(taskLineRootPane);
		
		ganttChartSplitPane.setDividerLocation(app.getProject().getView().getTaskTableWidth());
		
		updateDividerLocation();
	}

	public TaskLineRootPane getTaskLineRootPane() {
		return taskLineRootPane;
	}

	public TaskListRootPane getTaskListRootPane() {
		return taskListRootPane;
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		ganttChartSplitPane.setSize(getSize());
	}
	
	public void updateDividerLocation() {
		int max = ganttChartSplitPane.getMaximumDividerLocation();
		if (ganttChartSplitPane.getDividerLocation() > max) {
			int oldLocation = ganttChartSplitPane.getDividerLocation();
			ganttChartSplitPane.setDividerLocation(max);
			app.getProject().getController().setTaskTableWidth(app.getProject(), oldLocation, max);
		}
	}
	
	class ProjectViewChangedHandler implements ProjectViewChangedListener {

		@Override
		public void projectViewChanged() {
			updateDividerLocation();
		}
		
	}
}
