package jp.sourceforge.freegantt.data.undo;

import java.util.ArrayList;
import java.util.List;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Project;

public class UpdateViewTaskTableColumnsEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 2456337537476720660L;

	Project project;
	List<Column> oldColumns = new ArrayList<Column>();
	List<Column> newColumns = new ArrayList<Column>();
	
	public UpdateViewTaskTableColumnsEdit(Project project,
			List<Column> oldColumns, 
			List<Column> newColumns) {
		this.project = project;
		for (Column column: oldColumns) {
			this.oldColumns.add(column.clone());
		}
		for (Column column: newColumns) {
			this.newColumns.add(column.clone());
		}
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setViewTaskTableColumns(project, newColumns, oldColumns);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setViewTaskTableColumns(project, oldColumns, newColumns);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldColumns = null;
		newColumns = null;
	}
}
