package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateTaskCriticalPathEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 5320839625323953628L;

	Project project;
	boolean oldCriticalPath;
	boolean newCriticalPath;
	int index;
	
	public UpdateTaskCriticalPathEdit(Project project, boolean newCriticalPath, int index) {
		this.project = project;
		this.oldCriticalPath = project.getTaskAtIndex(index).isCriticalPath();
		this.newCriticalPath = newCriticalPath;
		this.index = index;
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setTaskCriticalPath(oldCriticalPath, index);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setTaskCriticalPath(newCriticalPath, index);
	}

	@Override
	public void die() {
		super.die();
		project = null;
	}
}
