package jp.sourceforge.freegantt.data.undo;

import java.awt.Dimension;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdatePrintCellSizeEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -3573084016242143261L;
	
	Project project;
	Dimension oldPrintCellSize;
	Dimension newPrintCellSize;
	
	public UpdatePrintCellSizeEdit(Project project, Dimension newPrintCellSize) {
		this.project = project;

		this.oldPrintCellSize = project.getPrint().getPrintCellSize();
		this.newPrintCellSize = (Dimension)newPrintCellSize.clone();
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setPrintCellSize(oldPrintCellSize);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setPrintCellSize(newPrintCellSize);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldPrintCellSize = null;
		newPrintCellSize = null;
	}

}
