package jp.sourceforge.freegantt.data.undo;

import java.util.ArrayList;
import java.util.List;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveMemberEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 6210197762255608085L;

	Project project;
	Member oldMember;
	int index;
	List<Integer> srcTasks = new ArrayList<Integer>();
	
	public RemoveMemberEdit(Project project, int index) {
		this.project = project;
		this.oldMember = project.getMembers().get(index);
		this.index = index;
		for (int i=0; i<project.getTasks().size(); i++) {
			Task task = project.getTasks().get(i);
			if (task.getMember() == oldMember) srcTasks.add(i);
		}
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().addMember(oldMember, index);
		for (Integer index: srcTasks) {
			Task task = project.getTasks().get(index);
			task.setMember(oldMember);
		}
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().removeMember(index);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldMember = null;
		srcTasks = null;
	}
	
}
