package jp.sourceforge.freegantt.swing;

import java.awt.Dimension;
import java.util.Calendar;

import javax.swing.JPanel;

import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskLinePane extends JPanel {
	private static final long serialVersionUID = 843023457646014650L;
	
	Application app;
	
	public TaskLinePane(Application app) {
		this.app = app;
		Calendar fromDate = app.getProject().getChartFromDate();
		Calendar toDate = app.getProject().getChartToDate();
		int taskSize = app.getProject().getMaxIndex();
		
		int width = CalendarUtil.subDate(toDate, fromDate) * getCellWidth();
		int height = taskSize * getCellHeight() + getHeaderHeight();
		setBounds(0, 0, width, height);
		setPreferredSize(new Dimension(width, height));
	}
	
	public void updateWidth() {
		Calendar fromDate = app.getProject().getChartFromDate();
		Calendar toDate = app.getProject().getChartToDate();
		setSize(CalendarUtil.subDate(toDate, fromDate) * getCellWidth(), getHeight());
		setPreferredSize(getSize());
	}
	
	public int getCellWidth() {
		return app.getProject().getCellSize().width;
	}
	
	public int getCellHeight() {
		return app.getProject().getCellSize().height;
	}
	
	public int getHeaderHeight() {
		return getCellHeight() * 2;
	}
}
