package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import jp.sourceforge.freegantt.locale.Resource;

public class ProjectRootPane extends JPanel {
	private static final long serialVersionUID = -189324575838088163L;

	Application app;
	JScrollPane summaryScrollPane;
	
	public ProjectRootPane(Application app) {
		super();
		this.app = app;

		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(new EmptyBorder(10, 10, 10, 10));
		
		JLabel titleLabel = new JLabel(Resource.get("infoName"));
		titleLabel.setAlignmentX(LEFT_ALIGNMENT);
		add(titleLabel);
		
		final JTextField titleField = new JTextField();
		titleField.setBounds(0, 0, 100, 16);
		titleField.setPreferredSize(new Dimension(Integer.MAX_VALUE, 16));
		titleField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
		titleField.setAlignmentX(LEFT_ALIGNMENT);
		titleField.setText(app.getProject().getName());
		titleField.addFocusListener(new FocusListener(){
			@Override
			public void focusGained(FocusEvent e) {
			}
			@Override
			public void focusLost(FocusEvent e) {
				ProjectRootPane.this.app.getProject().setName(titleField.getText());
			}
		});
		add(titleField);
		
		JLabel summaryLabel = new JLabel(Resource.get("infoSummary"));
		summaryLabel.setAlignmentX(LEFT_ALIGNMENT);
		add(summaryLabel);

		final JTextArea summaryArea = new JTextArea();
		summaryArea.setLineWrap(true);
		summaryArea.setText(app.getProject().getSummary());
		summaryArea.addFocusListener(new FocusListener(){
			@Override
			public void focusGained(FocusEvent e) {
			}
			@Override
			public void focusLost(FocusEvent e) {
				ProjectRootPane.this.app.getProject().setSummary(summaryArea.getText());
			}
		});
		
		summaryScrollPane = new JScrollPane(summaryArea);
		summaryScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
		summaryScrollPane.setMinimumSize(new Dimension(1, 120));
		summaryScrollPane.setAlignmentX(LEFT_ALIGNMENT);
		add(summaryScrollPane);
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		int otherHeight = 0;
		for (Component c: getComponents()) {
			if (c != summaryScrollPane) otherHeight += c.getHeight();
		}
		Rectangle r = summaryScrollPane.getBounds();
		summaryScrollPane.setBounds(r.x, r.y, r.width, getHeight() - 20 - otherHeight);
	}
}
