package jp.sourceforge.freegantt.swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumn;


public class GanttChartPane extends JPanel {
	private static final long serialVersionUID = -968483593747003051L;
	
	Application app;
	
	GanttChartSplitPane ganttChartSplitPane;
	TaskLineRootPane taskLineRootPane;
	TaskListRootPane taskListRootPane;
	
	public GanttChartPane(Application app) {
		super(new BorderLayout());
		
		this.app = app;
		setBackground(Color.blue);
		
		ganttChartSplitPane = new GanttChartSplitPane(app, JSplitPane.HORIZONTAL_SPLIT);
		ganttChartSplitPane.setBounds(0, 0, 300, 200);
		ganttChartSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setDividerSize(4);
		ganttChartSplitPane.setContinuousLayout(true);
		add(ganttChartSplitPane, BorderLayout.CENTER);
		
		taskListRootPane = new TaskListRootPane(app);
		taskListRootPane.setBounds(0, 0, 100, 200);
		ganttChartSplitPane.add(taskListRootPane);
		
		taskLineRootPane = new TaskLineRootPane(app);
		taskLineRootPane.setBounds(0, 0, 500, 200);
		taskLineRootPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		ganttChartSplitPane.add(taskLineRootPane);
		
		ganttChartSplitPane.setDividerLocation(app.getProject().getView().getTaskTableWidth());
		
		HeaderChanged headerChanged = new HeaderChanged();
		taskListRootPane.getTaskListTable().addHeaderChangedListener(headerChanged);
		taskListRootPane.getTaskListTable().fireHeaderChangedEvent();
	}

	public TaskLineRootPane getTaskLineRootPane() {
		return taskLineRootPane;
	}

	public TaskListRootPane getTaskListRootPane() {
		return taskListRootPane;
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		ganttChartSplitPane.setSize(getSize());
	}
	
	class HeaderChanged implements HeaderChangedListener {
		@Override
		public void headerChanged(HeaderChangedEvent e) {
			List<TableColumn> columns = Collections.list(e.getTable().getColumnModel().getColumns());
			
			int width = 1;
			System.out.println("GanttChartPane headerChanged ->");
			for (TableColumn column: columns) {
				width += column.getWidth();
			}
			JScrollBar bar = taskListRootPane.getVerticalScrollBar();
			width += bar.getWidth();
			ganttChartSplitPane.setMaximumDividerLocation(width);
			if (ganttChartSplitPane.getDividerLocation() > width) {
				ganttChartSplitPane.setDividerLocation(width);
			}
		}
	}
}
