package jp.sourceforge.freegantt.data;

import java.util.Arrays;
import java.util.List;

public class View {
	/** タスクテーブルの幅 */
	int taskTableWidth = 351;
	/** タスクテーブルのカラム状態 */
	List<Column> columns = getDefaultColumns();
	
	
	
	public int getTaskTableWidth() {
		return taskTableWidth;
	}

	public void setTaskTableWidth(int taskTableWidth) {
		this.taskTableWidth = taskTableWidth;
	}

	public List<Column> getColumns() {
		return columns;
	}
	
	public Column getColumn(String key) {
		for (Column column: columns) {
			if (!column.getKey().equals(key)) continue;
			return column;
		}
		return null;
	}

	public void setColumns(List<Column> columns) {
		this.columns = columns;
	}

	public List<Column> getDefaultColumns() {
		Column[] columns = {
			new Column("name", 120),
			new Column("resource", 60),
			new Column("period", 30),
			new Column("completion", 30),
			new Column("startDate", 80)
		};
		return Arrays.asList(columns);
	}
	
	public Column getDefaultColumn(String key) {
		List<Column> columns = getDefaultColumns();
		for (Column column: columns) {
			if (column.getKey().equals(key)) return column;
		}
		return new Column("", 0);
	}
}
