package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.locale.Resource;

public class TaskListTable extends JTable implements MouseListener {
	private static final long serialVersionUID = -2059641956588584594L;

	Application app;
	Project project;
	TaskListTableModel tableModel;
	TaskNameCellRenderer taskNameCellRenderer;
	
	
	Color borderColor = new Color(0xC0, 0xC0, 0xC0);
	
	public TaskListTableModel getTaskListTableModel() {
		return tableModel;
	}

	public TaskListTable(Application app) {
		super();
		this.app = app;
		this.project = app.getProject();
		
		setGridColor(borderColor);
		setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		addMouseListener(this);
		
		tableModel = project.getTaskTableModel();
		setModel(tableModel);
		for (int i=0; i<TaskListTableModel.COLOMN_KEYS.length; i++) {
			getColumnModel().getColumn(i).setIdentifier(TaskListTableModel.COLOMN_KEYS[i]);
		}

		TableColumnModel columnModel = getColumnModel();
//		
//		JComboBox cellEditor = new TaskListMemberCellRenderer(project);
//		columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(cellEditor));
//		columnModel.getColumn(2).setCellRenderer(cellRenderer);
		columnModel.getColumn(2).setCellRenderer(new TaskMemberCellRenderer());
		columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(new TaskMemberCellEditor(project)));
		
		taskNameCellRenderer = new TaskNameCellRenderer(project);
		columnModel.getColumn(0).setCellRenderer(getTableHeader().getDefaultRenderer());
		columnModel.getColumn(0).setPreferredWidth(30);
		columnModel.getColumn(0).setMaxWidth(30);
		columnModel.getColumn(0).setMinWidth(30);
		columnModel.getColumn(1).setPreferredWidth(120);
		columnModel.getColumn(1).setMinWidth(0);
		columnModel.getColumn(1).setCellRenderer(taskNameCellRenderer);
		columnModel.getColumn(2).setPreferredWidth(60);
		columnModel.getColumn(3).setPreferredWidth(30);
		columnModel.getColumn(4).setPreferredWidth(30);
		columnModel.getColumn(5).setPreferredWidth(80);
	}
	
	@Override
	public void tableChanged(TableModelEvent e) {
		super.tableChanged(e);
		
		if (app == null) return;
		
		// チャートペインの高さをタスクリストテーブルの高さと同じに設定する
		TaskLineDataPane taskLineDataPane = app.getTaskLineDataPane();
		if (taskLineDataPane != null) {
			taskLineDataPane.setSize(new Dimension(taskLineDataPane.getWidth(), getTaskListTableModel().getRowCount() * 16));
			taskLineDataPane.setPreferredSize(new Dimension(taskLineDataPane.getWidth(), getTaskListTableModel().getRowCount() * 16));
			System.out.println("DataPane setPreferredSize: " + taskLineDataPane.getWidth() + "," +  getTaskListTableModel().getRowCount() * 16);
		}

		
		if (app.getTaskListScrollPane() != null) {
			app.getTaskListScrollPane().getViewport().validate();
		}
		
		if (app.getTaskLineDataPane() != null) {
			app.getTaskLineDataPane().repaint();
		}
		
		if (app.getTaskListPane() != null) {
			app.getTaskListPane().repaint();
		}
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) triggerPopup(e);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) triggerPopup(e);
	}

	private void triggerPopup(MouseEvent e) {
		final int row = TaskListTable.this.rowAtPoint(e.getPoint());
		if (row < 0) return;
		
		boolean found = false;
		int[] selectedRows = getSelectedRows();
		for (int s: selectedRows) {
			if (s == row) found = true;
		}
		if (!found) {
			setRowSelectionInterval(row, row);
			repaint();
		}
		
		final Task task = project.findTask(row);
		boolean isAvailableLevelUp = (task != null);
		boolean isAvailableLevelDown = (task != null && task.getLevel() > 0);
		
		JPopupMenu menu = new JPopupMenu();
		JMenuItem item = new JMenuItem(Resource.get("listRemoveTask"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				int deleted = 0;
				int[] selectedRows = getSelectedRows();
				for (int s: selectedRows) {
					project.removeRow(s - deleted);
					deleted ++;
				}
			}
		});
		menu.add(item);
		item = new JMenuItem(Resource.get("listInsertTask"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				int inserted = 0;
				int chained = 0;
				int preSelected = -1;
				int[] selectedRows = getSelectedRows();
				for (int s: selectedRows) {
					if (preSelected + 1 == s) chained ++; else chained = 0;
					project.insertRow(s + inserted - chained);
					inserted ++;
					preSelected = s;
				}
			}
		});
		menu.add(item);
		menu.addSeparator();
		item = new JMenuItem(Resource.get("listLevelUp"));
		item.setEnabled(isAvailableLevelUp);
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				task.setLevel(task.getLevel() + 1);
				project.update();
				tableModel.fireTableChanged();
			}
		});
		menu.add(item);
		item = new JMenuItem(Resource.get("listLevelDown"));
		item.setEnabled(isAvailableLevelDown);
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				task.setLevel(task.getLevel() - 1);
				project.update();
				tableModel.fireTableChanged();
			}
		});
		menu.add(item);
		menu.show(this, e.getX(), e.getY());
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}

	@Override
	public void doLayout() {
		JTableHeader header = getTableHeader();
		TableColumn resizingColumn = header.getResizingColumn();
		if (resizingColumn != null) {
			resizingColumn.setPreferredWidth(resizingColumn.getWidth());
		}
		
		TableColumnModel model = getColumnModel();
		for (int i=0; i<model.getColumnCount(); i++) {
			TableColumn column = model.getColumn(i);
			column.setWidth(column.getPreferredWidth());
		}
	}
}
