package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import jp.sourceforge.freegantt.locale.Resource;

public class MemberRootPane extends JPanel {
	private static final long serialVersionUID = 3997661648912790931L;

	Application app;
	MemberTable memberListPane;
	JScrollPane innerScrollPane;
	
	public MemberRootPane(Application app) {
		this.app = app;
		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(new EmptyBorder(10, 10, 10, 10));
		
		JLabel titleLabel = new JLabel(Resource.get("rsourceCaption"));
		titleLabel.setAlignmentX(LEFT_ALIGNMENT);
		add(titleLabel);

		MemberTableModel tableModel = app.getProject().getMemberTableModel();
		tableModel.addTableModelListener(new TableModelListener() {
			@Override
			public void tableChanged(TableModelEvent e) {
				MemberRootPane.this.app.getProject().getTaskMemberComboBoxModel().fireListDataListener();
				if (memberListPane != null) memberListPane.repaint();
				
			}
		});
		
		memberListPane = new MemberTable(app, tableModel);
		innerScrollPane = new JScrollPane(memberListPane);
		innerScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		innerScrollPane.setAlignmentX(LEFT_ALIGNMENT);
		add(innerScrollPane);
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		int otherHeight = 0;
		for (Component c: getComponents()) {
			if (c != innerScrollPane) otherHeight += c.getHeight();
		}
		Rectangle r = innerScrollPane.getBounds();
		innerScrollPane.setBounds(r.x, r.y, r.width, getHeight() - 20 - otherHeight);
	}
	
}
