package jp.sourceforge.freegantt.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class GanttChartSplitPane extends JSplitPane implements MouseListener {
	private static final long serialVersionUID = -8567327389185691533L;

	Integer maximumDividerLocation;
	int openedDividerLocation = 0;
	
	public GanttChartSplitPane(int newOrientation) {
		super(newOrientation);
		GanttChartSplitPaneUI ui = new GanttChartSplitPaneUI();
		setUI(ui);
		ui.getDivider().addMouseListener(this);
		addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if (evt.getPropertyName().equals(JSplitPane.DIVIDER_LOCATION_PROPERTY) &&
						maximumDividerLocation != null && 
						(Integer)evt.getNewValue() > maximumDividerLocation) {
					setDividerLocation(maximumDividerLocation);
				}
			}
		});
	}
	
	@Override
	public void setDividerLocation(int location) {
		super.setDividerLocation(location);
		
		if (location > 10) {
			openedDividerLocation = location;
		}
	}



	public void setMaximumDividerLocation(int location) {
		maximumDividerLocation = location;
	}

	@Override
	public int getMaximumDividerLocation() {
		if (maximumDividerLocation != null) return maximumDividerLocation;
		return super.getMaximumDividerLocation();
	}
	
	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.getClickCount() == 2) {
			setDividerLocation(getDividerLocation() < 10 ? openedDividerLocation : 0);
		}
	}

	@Override
	public void mousePressed(MouseEvent e) {
	}

	@Override
	public void mouseReleased(MouseEvent e) {
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}


	class GanttChartSplitPaneUI extends BasicSplitPaneUI {
		public BasicSplitPaneDivider getDivider() {
			return divider;
		}
	}

}
