package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class TaskNameCellRenderer extends DefaultTableCellRenderer {
	private static final long serialVersionUID = -1820480136651683438L;

	final public static int INDENT_WIDTH = 16;
	Project project;
	
	public TaskNameCellRenderer(Project project) {
		this.project = project;
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		Border border = getBorder();
		Insets i = border.getBorderInsets(this);
		
		Task task = project.findTask(row);
		if (task != null) {
			int indent = (project.getMaxLevel() - task.getLevel()) * INDENT_WIDTH;
			((TaskNameCellRenderer)component).setBorder(BorderFactory.createEmptyBorder(i.top, i.left + indent, i.bottom, i.right));
		}
		return component;
	}
	
	
}
