package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;

public class CursorState {
	
	final public static int RESTRICTION_CURSOR = Integer.MAX_VALUE - 1;
	final public static int COMPLETION_CURSOR = Integer.MAX_VALUE - 2;
	
	Component component = null;
	Cursor currentCursor = null;
	Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
	
	public CursorState(Component component) {
		this.component = component;
		
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		
		Image image = toolkit.getImage(getClass().getResource("restriction.png"));
		Cursor cursor = toolkit.createCustomCursor(image, new Point(15, 15), "restriction");
		cursors.put(RESTRICTION_CURSOR, cursor);
		
		image = toolkit.getImage(getClass().getResource("completion.png"));
		cursor = toolkit.createCustomCursor(image, new Point(15, 15), "completion");
		cursors.put(COMPLETION_CURSOR, cursor);		
	}
	
	public void setCursor(int type) {
		Cursor cursor = cursors.get(type);
		if (cursor == null) {
			cursor = createCursor(type);
		}
		if (cursor != currentCursor) {
			component.setCursor(cursor);
			currentCursor = cursor;
		}
	}
	
	public void setDefaultCursor() {
		if (currentCursor != null) {
			component.setCursor(Cursor.getDefaultCursor());
			currentCursor = null;
		}
	}

	private Cursor createCursor(int type) {
		return new Cursor(type);
	}
}
