package jp.sourceforge.freegantt.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.ResolutionSyntax;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.GanttChartPrintable;

public class ApplicationMenu extends JMenuBar {
	private static final long serialVersionUID = -8682706642684252609L;

	Application application;
	
	public ApplicationMenu(final Application application) {
		super();
		this.application = application;
		
		JMenu menu = new JMenu(Resource.get("menuFile"));
		JMenuItem item = new JMenuItem(Resource.get("menuFileNew"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.newFile();
			}
		});
		menu.add(item);
		item = new JMenuItem(Resource.get("menuFileOpen"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.loadData();
			}
		});
		menu.add(item);
		item = new JMenuItem(Resource.get("menuFileSave"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.saveData();
			}
		});
		menu.add(item);
		item = new JMenuItem(Resource.get("menuFileSaveAs"));
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.saveAsData();
			}
		});
		menu.add(item);
		menu.addSeparator();
		item = new JMenuItem("ページ設定");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				PrinterJob printerJob = PrinterJob.getPrinterJob();
				PageFormat pageFormat = printerJob.defaultPage();
				PrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
				attr.add(OrientationRequested.LANDSCAPE);
				attr.add(new PrinterResolution(600, 600, ResolutionSyntax.DPI));
				pageFormat = printerJob.pageDialog(attr);
				application.getProject().setPageFormat(pageFormat);
			}
		});
		menu.add(item);
		item = new JMenuItem("印刷");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				PrinterJob job = PrinterJob.getPrinterJob();
				GanttChartPrintable printable = new GanttChartPrintable(application);
				job.setPrintable(printable);
				job.setPageable(printable);
				
				PrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
				attr.add(OrientationRequested.LANDSCAPE);
				attr.add(new PrinterResolution(600, 600, ResolutionSyntax.DPI));
				
				if (job.printDialog(attr)) {
					try {
						job.print(attr);
					} catch (PrinterException e1) {
						e1.printStackTrace();
					}
				}
			}
		});
		menu.add(item);
		add(menu);
		
		menu = new JMenu("表示");
		item = new JMenuItem("プロジェクト情報");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.openConfig(Application.CONFIG_PROJECT);
			}
		});
		menu.add(item);
		item = new JMenuItem("リソース");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.openConfig(Application.CONFIG_MEMBER);
			}
		});
		menu.add(item);
		item = new JMenuItem("休日");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.openConfig(Application.CONFIG_HOLIDAY);
			}
		});
		menu.add(item);
		menu.addSeparator();
		item = new JMenuItem("ページ範囲");
		item.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				application.getTaskLineDataPane().setPrintRangeMode(!application.getTaskLineDataPane().isPrintRangeMode());
				application.getTaskLineDataPane().repaint();
			}
		});
		menu.add(item);
		add(menu);
	}
}
