library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;
--use ieee.numeric_std.all;

library gaisler;
use gaisler.sim.all;
use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library techmap;
use techmap.gencomp.all;
library grlib;
use grlib.stdlib.all;
library kuri;
use kuri.mjpeg.all;

use work.debug.all;
use work.config.all;

entity sim_huff is
  generic (
    clkperiod : integer := 20);
end ;

architecture behav of sim_huff is

  component bus_huff
    port(
      rstn : in std_ulogic;
      clk : in std_ulogic;
      ctrl_in1 : in ahbtbm_ctrl_in_type;
      ctrl_out1 : out ahbtbm_ctrl_out_type;
      data : out std_logic_vector(11 downto 0);
      add : out std_logic_vector(5 downto 0);
      effect : out std_logic
      );
    
  end component;

signal clk : std_ulogic := '0';
signal rst : std_ulogic := '0';
signal ctrl1 : ahbtb_ctrl_type;
signal data_in : std_logic_vector(31 downto 0);
signal data : std_logic_vector(11 downto 0);
signal add : std_logic_vector(5 downto 0);
signal effect : std_logic;

constant numx : integer := 80;
constant numy : integer := 80;
constant disx : integer := 120;

--constant numy : integer := 3;

file in_acfile : text open read_mode is "in_accache.txt";
file in_dcfile : text open read_mode is "in_dccache.txt";
file in_maxcfile : text open read_mode is "in_maxcode.txt";
file in_offsfile : text open read_mode is "in_valoffs.txt";
file in_huffvfile : text open read_mode is "in_huffval.txt";
file in_scanfile : text open read_mode is "in_scan.txt";
file out_file : text open write_mode is "out_sim_huff.txt";

begin  -- behav
  --clk  <= not clk after ct * 1 ns;
  b0 : bus_huff
    port map (rst,clk,ctrl1.i,ctrl1.o,data,add,effect);
   
    tictak : process
    begin
        clk <= '0';
        wait for 10 ns;
        clk <= '1';
        wait for 10 ns;
    end process;
    
    outvalue : process
        variable lc : line;
        variable add8 : std_logic_vector(7 downto 0);
        variable add32 : std_logic_vector(31 downto 0);
        variable data32 : std_logic_vector(31 downto 0);
    begin
        add8 := "00" & add;
        add32 := x"000000" & add8;
        if(data(11) = '1')then
            data32 := x"fffff" & data;
        else
            data32 := x"00000" & data;
        end if;
        if(effect = '1')then
            hwrite(lc, data32, RIGHT, 8);
            hwrite(lc, add32, RIGHT, 9);
            writeline(out_file, lc);
        end if;
    wait for 20 ns;
    end process;
    
    stim: process
       variable li : line;
       variable lc : line;
       variable i,j : integer;
       variable scan : std_logic_vector(31 downto 0);
       variable indata : std_logic_vector(31 downto 0);
       variable radd : std_logic_vector(31 downto 0);
       variable wadd : std_logic_vector(31 downto 0);
       variable cdata32 : std_logic_vector(31 downto 0);
       
    begin

      report " stimulus process start ";
      
      rst  <= '0';   
      wait for 100 ns;
      rst <= '1';


    -- initialize
      ahbtbminit(ctrl1);

-- Write Control registers through APB bus
-- figure size 80x80, screen size 120 x 100, FB address a0000000
      ahbwrite(x"80000200", x"a0000000", "10", "10", '1', 2, false , ctrl1);
--      ahbwrite(x"80000204", x"00500050", "10", "10", '1', 2, false , ctrl1);
      ahbwrite(x"80000204", x"00100050", "10", "10", '1', 2, false , ctrl1);
      ahbwrite(x"80000208", x"00000050", "10", "10", '1', 2, false , ctrl1);
      ahbwrite(x"8000020c", x"f0000000", "10", "10", '1', 2, false , ctrl1);
 
 -- setting cache memory
      for i in 0 to 1023 loop
          readline(in_acfile, li);
          hread(li, wadd);
          hread(li, cdata32);    
          wadd := wadd(29 downto 0) & "00";
          wadd := wadd  +"100000000000000";
          wadd := wadd + x"90000000";
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      for i in 0 to 1023 loop
          readline(in_dcfile, li);
          hread(li, wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := wadd  + "1000000000000000";
          wadd := wadd + x"90000000";
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;          
      for i in 0 to 71 loop
          readline(in_maxcfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90000400" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      for i in 0 to 71 loop
          readline(in_offsfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90000800" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;      
      for i in 0 to 1023 loop
          readline(in_huffvfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90002000" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      
    ahbtbmidle(true,ctrl1);
    wait for 100 ns;   

      radd := x"90000400";       
      for i in 0 to 16 loop
          ahbread(radd, x"00000000", "10", 2, false, ctrl1);
          radd := radd + x"00000004";      
      end loop;
      radd := x"90004000";
--     ahbwrite(radd, cdata32, "10", "10", '1', 2, false , ctrl1);       
      for i in 0 to 32 loop
          ahbread(radd, x"00000000", "10", 2, false, ctrl1);
          radd := radd + x"00000004";      
      end loop;       
      for i in 0 to 333 loop
          readline(in_scanfile,li);
          wadd := x"90000000";
           hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
          ahbtbmidle(true, ctrl1);
          wait for 350 ns;
      end loop;                 
      

 ahbtbmidle(true,ctrl1);
 wait for 200 ns;    
 
    -- Stop simulation

      ahbtbmdone(0, ctrl1);
      wait for 300 ns;

      report "stimulus process end" severity failure;
    wait;
    end process;

end behav;
