library ieee;
use ieee.std_logic_1164.all;

library grlib,techmap;
use grlib.amba.all;
use grlib.stdlib.all;
use techmap.gencomp.all;
library gaisler;
use gaisler.misc.all;
--use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library kuri;
use kuri.mjpeg.all;

use work.config.all;

entity bus_huff is
  port (
    rstn : in std_ulogic;
    clk : in std_ulogic;
    ctrl_in1 : in ahbtbm_ctrl_in_type; 
    ctrl_out1 : out ahbtbm_ctrl_out_type;
    data : out std_logic_vector(11 downto 0); 
    add : out std_logic_vector(5 downto 0);
    effect : out std_logic);
end;

architecture rtl of bus_huff is

  type control_reg is record
      out_cnt : std_logic_vector(31 downto 0);
  end record;
 
  signal apbi  : apb_slv_in_type;
  signal apbo  : apb_slv_out_vector := (others => apb_none);
  signal ahbsi : ahb_slv_in_type;
  signal ahbso : ahb_slv_out_vector := (others => ahbs_none);
  signal ahbmi : ahb_mst_in_type;
  signal ahbmo : ahb_mst_out_vector := (others => ahbm_none);
  
  signal kready : std_logic;
  signal kstrobe : std_logic;
  signal kdata : std_logic_vector(11 downto 0);
  signal kaddress : std_logic_vector(5 downto 0); 
  signal error : std_logic_vector(2 downto 0);
  signal jpg_setting : jpg_set_type;
  signal startgen : std_logic;
  signal kstrobeq : std_logic;
  signal kdataq : std_logic_vector(7 downto 0);
  signal kaddq : std_logic_vector(7 downto 0);
  signal krddataq : std_logic_vector(7 downto 0);
  signal krdq : std_logic;  
--  signal rst : std_ulogic;

  signal r,rin : control_reg;

begin  -- rtl

--  rst <= not rstn;
  kready <= '1';
  error <= (others => '0');
  huffinst : huff
     generic map(shindex => 2, haddr => 16#900#, pindex => 2, paddr => 2, mhindex => 3, hirq => 2)
     port map (rstn, clk, ahbsi, ahbso(2), apbi, apbo(2), kready, kstrobe, kdata,
                kaddress, jpg_setting, error, startgen, kstrobeq, kdataq, kaddq, krddataq, krdq);         
  data <= kdata;
  add <= kaddress;
  effect <= kstrobe;
  apb0 : apbctrl
     generic map (hindex => 4, haddr => 16#800#)
     port map(rstn, clk, ahbsi, ahbso(4), apbi, apbo);
   
  ahbcontroller : ahbctrl                -- AHB arbiter/multiplexer
     generic map (defmast => CFG_DEFMST, split => CFG_SPLIT, 
        enbusmon => 0,rrobin => CFG_RROBIN, ioaddr => CFG_AHBIO)
     port map (rstn, clk, ahbmi, ahbmo, ahbsi, ahbso);

--  ram0 : ahbram 
--     generic map (hindex => 7, haddr => 16#a00#, tech => CFG_MEMTECH, kbytes => 24) 
--     port map (rstn, clk, ahbsi, ahbso(7));

  mast_em : ahbtbm
     generic map(hindex => 0)
     port map (rstn, clk, ctrl_in1, ctrl_out1, ahbmi, ahbmo(0));
 
   cnt_comb : process(r, rstn, kstrobe)
   variable v : control_reg;
   begin
       v := r;
       if(kstrobe = '1')then
           v.out_cnt := v.out_cnt + 1;
       end if;
       
       if(rstn = '0')then
           v.out_cnt := (others => '0');
       end if;
       rin <= v;       
   end process;
   
   reg : process(clk)
   begin
       if rising_edge(clk) then
           r <= rin;
       end if;
   end process;
end rtl;
  
