#include <linux/init.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/sched.h>
#include <asm/current.h>
#include <asm/uaccess.h>
#include <asm/io.h>

#include <linux/io.h>
#include <linux/ioport.h>

#include <linux/interrupt.h>
#include <linux/fcntl.h>
#include <linux/slab.h>

#include "kmjpeg.h"

MODULE_LICENSE("GPL");

#define DRIVER_NAME "kmjpeg"


#define AHBADD   0xa0000000
#define RDYADD   0xa0000200
#define APBADD   0x80000c00
#define QTBLADD  0xa000c000 
#define ACADD    0xa0004000
#define DCADD    0xa0008000
#define MAXADD   0xa0000400
#define OFFSADD  0xa0000800
#define HUFFVADD 0xa0002000

/* Physical address for NEEK*/
/*#define AHBADD   0xb0000000
#define RDYADD   0xb0000200
#define APBADD   0x80000700
#define QTBLADD  0xb000c000
#define ACADD    0xb0004000
#define DCADD    0xb0008000
#define MAXADD   0xb0000400
#define OFFSADD  0xb0000800
#define HUFFVADD 0xb0002000*/

static struct kmjpeg_priv *kmjpeg_devices;

static unsigned int kmjpeg_major = 0;
module_param(kmjpeg_major, uint, 0);

struct kmjpeg_sregs_t {
  volatile unsigned int fbadd;
  volatile unsigned int size_info;
  volatile unsigned int incadd;
  volatile unsigned int reset;
};

struct kmjpeg_sregs_t * kmjpeg_sregs;

//volatile unsigned int *apb_regs;

volatile unsigned int *hdata;
volatile unsigned int *rdyadd;
volatile unsigned int *qdata;
volatile unsigned int *acadd;
volatile unsigned int *dcadd;
volatile unsigned int *maxadd;
volatile unsigned int *offsadd;
volatile unsigned int *huffvadd;


int kmjpeg_ioctl(struct inode *inode, struct file *filep, unsigned int cmd, unsigned long arg)
{
  int retval = 0;
 
  struct ioctl_cmdreg datareg;
  struct ioctl_cmdwrite datawrite;
  struct ioctl_cmdq dataq;
  struct ioctl_cmdd datad;
  struct ioctl_offdata dataoff;

  unsigned int tmp;
  int i;

  memset(&datareg, 0, sizeof(datareg));
  memset(&datawrite, 0, sizeof(datawrite));
  memset(&dataq, 0, sizeof(dataq));
  memset(&datad, 0, sizeof(datad));
  memset(&dataoff, 0, sizeof(dataoff));

  retval = 0;
  switch(cmd){

  case IOCTL_WRITE :
   if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
   }
   if(copy_from_user(&datawrite, (int __user *)arg, sizeof(datawrite))){
      retval = -EFAULT;
      goto done;
   }
   
   while(1){
     tmp = *rdyadd;
     if((tmp & 0x80000000) == 0x80000000)break;
     for(i=0;i<800;i++);
     }
   //  *hdata = datawrite.pixeldata;
   for(i=0;i<64;i++){
     *hdata = datawrite.fourbdata[i];
   }
   break;
  
  case IOCTL_REGSET :
    //    printk("IOCTL_REGSET\n");
   if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      printk("ACCESS_NG\n");
      goto done;
    }
   //   printk("end of access_ok\n");
    if(copy_from_user(&datareg, (int __user *)arg, sizeof(datareg))){
      retval = -EFAULT;
      printk("COPY_NG\n");
      goto done;
    }
    //    printk("IOCTL regset ..............................\n");
    kmjpeg_sregs = ioremap_nocache(APBADD,12);
    //   printk("IOCTL regset2 ..............................\n");
    kmjpeg_sregs->fbadd = datareg.fb;
    kmjpeg_sregs->size_info = datareg.size_info;
    kmjpeg_sregs->incadd = datareg.incadd;
    kmjpeg_sregs->reset = 0x0;
    kmjpeg_sregs->reset =0x80004000;
    iounmap(kmjpeg_sregs);
    //    printk("IOCTL regset3 ..............................\n");
 
    break;

  case IOCTL_MAP :
    qdata = ioremap_nocache(QTBLADD,768);
    if(qdata==NULL){
      printk("ioremap for QTBL Failure!\n");
      retval = -EFAULT;
      goto done;
    }
    acadd = ioremap_nocache(ACADD,4096);
    if(acadd==NULL){
      printk("ioremap for ACCACHE Failure!\n");
      retval = -EFAULT;
      goto done;
    }
    dcadd = ioremap_nocache(DCADD,4096);
    if(dcadd==NULL){
      printk("ioremap for DCCACHE Failure!\n");
      retval = -EFAULT;
      goto done;
    }
    maxadd = ioremap_nocache(MAXADD,512);
    if(maxadd==NULL){
      printk("ioremap for MAX Failure!\n");
      retval = -EFAULT;
      goto done;
    }
    offsadd = ioremap_nocache(OFFSADD,512);
    if(offsadd==NULL){
      printk("ioremap for OFFSET Failure!\n");
      retval = -EFAULT;
      goto done;
    }
    huffvadd = ioremap_nocache(HUFFVADD,4096);
    if(huffvadd==NULL){
      printk("ioremap for HUFFVAL Failure!\n");
      retval = -EFAULT;
      goto done;
    }

    break;

  case IOCTL_UNMAP :
    iounmap(qdata);
    iounmap(acadd);
    iounmap(dcadd);
    iounmap(maxadd);
    iounmap(offsadd);
    iounmap(huffvadd);

    break;

  case IOCTL_QTBL :
    printk("IOCTL_QTBL");
    if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&dataq, (int __user *)arg, sizeof(dataq))){
      retval = -EFAULT;
      goto done;
    }
    //  printk("IOCTL QTBL start.............................\n");
    for(i=0;i<192;i++){
      //      printk("..%x..",dataq.quant[i]);
      *(qdata+i)  = dataq.quant[i];
    }
    //    printk("IOCTL QTBL end.............................\n");
    break;

  case IOCTL_ACCACHE :
    //   printk("IOCTL accache start .......................\n");
    if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&dataoff, (int __user *)arg, sizeof(dataoff))){
      retval = -EFAULT;
      goto done;
    }
    for(i=0;i<128;i++){
      *(acadd + dataoff.offset[i])=dataoff.data[i];
    }
    //    printk("IOCTL accache is ending...........................\n");
    break;

  case IOCTL_DCCACHE :
    //   printk("IOCTL dccache start .......................\n");
    if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&dataoff, (int __user *)arg, sizeof(dataoff))){
      retval = -EFAULT;
      goto done;
    }
    for(i=0;i<128;i++){
      *(dcadd + dataoff.offset[i])=dataoff.data[i];
    }
    //    printk("IOCTL accache is ending...........................\n");
    break;

  case IOCTL_MAXC :
    printk("IOCTL maxc is starting..............................\n");
     if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&datad, (int __user *)arg, sizeof(datad))){
      retval = -EFAULT;
      goto done;
    }
    for(i=0;i<128;i++){
      *(maxadd+i) = datad.data[i];
    }
    printk("IOCTL maxc is ending....................................\n");
    break;

  case IOCTL_OFFS :
    printk("IOCTL maxc is starting..............................\n");
     if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&datad, (int __user *)arg, sizeof(datad))){
      retval = -EFAULT;
      goto done;
    }
    for(i=0;i<128;i++){
      *(offsadd+i) = datad.data[i];
    }
    printk("IOCTL maxc is ending....................................\n");
    break;

  case IOCTL_HUFFV :
    //   printk("IOCTL huffval start .......................\n");
    if(!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))){
      retval = -EFAULT;
      goto done;
    }
    if(copy_from_user(&dataoff, (int __user *)arg, sizeof(dataoff))){
      retval = -EFAULT;
      goto done;
    }
    for(i=0;i<128;i++){
      *(huffvadd + dataoff.offset[i])=dataoff.data[i];
    }
    //    printk("IOCTL huffval is ending...........................\n");
    break;

  default :
    retval = -EFAULT;
    break;
  }

 done :
  return(retval);
}

ssize_t kmjpeg_write(struct file *filp, const char __user *buf, size_t count, loff_t *f_pos)
{
  int retval = 0;
  unsigned int ycc;
  unsigned char dbuf[3];

  if(count != 3){
    retval = -EFAULT;
    goto out;
  }
  if(copy_from_user(dbuf, buf, 3)){
    retval = -EFAULT;
    goto out;
  }
  ycc = (unsigned int)(((unsigned int)dbuf[2]<<16)|((unsigned int)dbuf[1]<<8)|((unsigned int)dbuf[0]));
  *hdata = ycc;
  retval = count;
 out:
  return(retval);
} 

static ssize_t kmjpeg_read(struct file* pFile, char __user* pBuf, size_t len, loff_t* offset)
{
   return 0;
}




static int kmjpeg_open(struct inode *inode, struct file *file)
{
   
  printk("%s: major %d minor %d (pid %d)\n", __func__,imajor(inode),iminor(inode),current->pid);
 
  inode->i_private = inode;
  file->private_data = file;
  printk(" i_private=%p private_data=%p\n",inode->i_private, file->private_data);
  //  printk("kmjpeg_open ending\n");
  return 0;
}

static int kmjpeg_close(struct inode *inode, struct file *file)
{
  printk("%s: major %d minor %d (pid %d)\n", __func__,imajor(inode),iminor(inode),current->pid);
  printk(" i_private=%p private_data=%p\n",inode->i_private, file->private_data);

  return 0;
}

struct file_operations kmjpeg_fops ={
  .owner = THIS_MODULE,
  .open = kmjpeg_open,
  .release = kmjpeg_close,
  .read = kmjpeg_read,
  .write = kmjpeg_write,
  .ioctl = kmjpeg_ioctl,
};

 static int kmjpeg_init(void)
{
  int major;
  int ret = 0;

  major = register_chrdev(kmjpeg_major, DRIVER_NAME, &kmjpeg_fops);

  if((kmjpeg_major > 0 && major != 0) || (kmjpeg_major == 0 && major < 0) || major < 0){
    printk("%s driver registration error\n", DRIVER_NAME);
    ret = major;
    goto error;
  }
  if (kmjpeg_major == 0){
    kmjpeg_major = major;
  }

  hdata = ioremap_nocache(AHBADD,4);
  if(hdata==NULL){
    printk("ioremap miss!\n");
    return(0);
  }
  rdyadd = ioremap_nocache(RDYADD,4);
  if(rdyadd==NULL){
    printk("ioremap miss!\n");
    return(0);
  }
  printk("%s driver[major %d] installed.\n", DRIVER_NAME, kmjpeg_major);

 error:
  return(ret);
}

static void kmjpeg_exit(void)
{
  iounmap(hdata);
  iounmap(rdyadd);
  //  kfree(kmjpeg_devices);

  unregister_chrdev(kmjpeg_major, DRIVER_NAME);
  printk("%s driver unloaded\n", DRIVER_NAME);
}

module_init(kmjpeg_init);
module_exit(kmjpeg_exit);
