------------------------------------------------------------------------------
--  Copyright (C) 20011 , Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------
-- Entity:      mjpeg package 
-- File:        mjpeg.vhd
-- Author:      Kenichi Kurimoto 
-- Description: motion JPEG package
------------------------------------------------------------------------------



library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library grlib;
use grlib.stdlib.all;
use grlib.amba.all;
use grlib.devices.all;

library techmap;
use techmap.gencomp.all;

package mjpeg is

type jpg_set_type is record
  samp_fact : std_logic;
  xmcumax   : std_logic_vector(5 downto 0);
  ymcumax   : std_logic_vector(4 downto 0);
  incaddy   : std_logic_vector(15 downto 0);
  incaddmcux : std_logic_vector(15 downto 0);
  incaddmcuy : std_logic_vector(10 downto 0);
  fbstartadd : std_logic_vector(31 downto 0);
end record;

component huffdctycc is
   generic (
      memtech : integer := DEFMEMTECH;
      shindex : integer := 0;
      haddr  : integer := 0;
      hmask  : integer := 16#fff#;
      hirq   : integer := 0;      
      pindex : integer := 0;
      paddr  : integer := 0;
      pmask  : integer := 16#fff#;
      mhindex : integer := 0;
      chprot : integer := 3);      

   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      ahbmi : in ahb_mst_in_type;
      ahbmo : out ahb_mst_out_type;
      ahbsi : in ahb_slv_in_type;
      ahbso : out ahb_slv_out_type;
      apbi  : in apb_slv_in_type;
      apbo  : out apb_slv_out_type
   );
end component;

component huff  is
   generic (
      memtech : integer := DEFMEMTECH;
      shindex : integer := 0;
      haddr  : integer := 0;
      hmask  : integer := 16#fff#;
      hirq   : integer := 0;      
      pindex : integer := 0;
      paddr  : integer := 0;
      pmask  : integer := 16#fff#;
      mhindex : integer := 0;
      chprot : integer := 3);      
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      ahbsi : in ahb_slv_in_type;
      ahbso : out ahb_slv_out_type;
      apbi  : in apb_slv_in_type;
      apbo  : out apb_slv_out_type;
      kready : in std_logic;
      kstrobe : out std_logic;
      kdata   : out std_logic_vector(11 downto 0);
      kaddress : out std_logic_vector(5 downto 0);
      jpg_setting : out jpg_set_type;
      error : in std_logic_vector(2 downto 0);
      startgen : out std_logic;
      kstrobeq : out std_logic;
      kdataq : out std_logic_vector(7 downto 0);
      kaddq : out std_logic_vector(7 downto 0);
      krddataq : in std_logic_vector(7 downto 0);
      krdq : out std_logic      
   );
end component;

component huffmemcont is
   generic (
      memtech : integer := DEFMEMTECH);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      kready1  : out std_logic;
      kstrobe1 : in std_logic;
      kaddress1 : in std_logic_vector(5 downto 0);
      kdata1   : in std_logic_vector(11 downto 0);
      kready2  : in std_logic;
      kstrobe2 : out std_logic;
      kdata2   : out std_logic_vector(11 downto 0);
      error    : out std_logic;
      samp_fact : in std_logic;
      kstrobeq1 : in std_logic;
      kdataq1   : in std_logic_vector(7 downto 0);
      kdataq2   : out std_logic_vector(7 downto 0);      
      kaddq : in std_logic_vector(7 downto 0);
      krdq : in std_logic;
      krddataq : out std_logic_vector(7 downto 0);
      startgen : in std_logic
   );
end component;

component dctmem1cont is
   generic (
      memtech : integer := DEFMEMTECH);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      kready1  : out std_logic;
      kstrobe1 : in std_logic;
      kdata1   : in std_logic_vector(11 downto 0);
      kready2  : in std_logic;
      kstrobe2 : out std_logic;
      kdata2   : out std_logic_vector(11 downto 0);
      error    : out std_logic;
      samp_fact : in std_logic;
      kstrobeq1 : in std_logic;
      kdataq1   : in std_logic_vector(7 downto 0);
      kdataq2   : out std_logic_vector(7 downto 0)
   );
end component;

component dctmem2cont is
   generic (
      memtech : integer := DEFMEMTECH);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      kready1  : out std_logic;
      kstrobe1 : in std_logic;
      kdata1   : in std_logic_vector(15 downto 0);
      kready2  : in std_logic;
      kstrobe2 : out std_logic;
      kdata2   : out std_logic_vector(15 downto 0);
      error     : out std_logic;
      startgen  : in std_logic
   );
end component;

component idct1 is
    port ( rst : in  std_ulogic;
           clk : in  std_ulogic;
           ready1 : out std_logic;
           strobe1 : in std_logic;
           coeffin : in  std_logic_vector (11 downto 0);
           quantin : in  std_logic_vector (7 downto 0);
           outdata : out  std_logic_vector (15 downto 0);
           ready2 : in std_logic;
           strobe2 : out std_logic;
           startgen : in std_logic
           );
end component;

component idct2 is
    port ( rst : in  std_ulogic;
           clk : in  std_ulogic;
           ready1 : out std_logic;
           strobe1 : in std_logic;
           coeffin : in  std_logic_vector (15 downto 0);
           outdata : out  std_logic_vector (7 downto 0);
           ready2 : in std_logic;
           strobe2 : out std_logic;
           startgen : in std_logic
           );
end component;

component yccambaif
     generic (
      memtech : integer := DEFMEMTECH;
      shindex : integer := 0;
      haddr  : integer := 0;
      hmask  : integer := 16#fff#;
      hirq   : integer := 0;      
      pindex : integer := 0;
      paddr  : integer := 0;
      pmask  : integer := 16#fff#);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      ahbsi : in ahb_slv_in_type;
      ahbso : out ahb_slv_out_type;
      apbi  : in apb_slv_in_type;
      apbo  : out apb_slv_out_type;
      kready : in std_logic;
      kstrobe : out std_logic;
      kdata   : out std_logic_vector(11 downto 0);
      samp_fact : out std_logic;
      error : in std_logic_vector(2 downto 0);
      xmcumax : out std_logic_vector(5 downto 0);
      ymcumax : out std_logic_vector(4 downto 0);
      incaddy  : out std_logic_vector(15 downto 0);
      incaddmcux : out std_logic_vector(15 downto 0);
      incaddmcuy : out std_logic_vector(10 downto 0);
      fbstartadd : out std_logic_vector(31 downto 0);
      startgen : out std_logic;
      kstrobeq : out std_logic;
      kdataq : out std_logic_vector(7 downto 0)
   );
end component;

component yccmemcont
   generic (
      memtech : integer := DEFMEMTECH);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      kready1  : out std_logic;
      kstrobe1 : in std_logic;
      kdata1   : in std_logic_vector(7 downto 0);
      kready2  : in std_logic;
      kstrobe2 : out std_logic;
      kdata2   : out std_logic_vector(23 downto 0);
      samp_fact : in std_logic;
      error     : out std_logic;
      startgen  : in std_logic
   );
end component;

component yccrgb
   generic (
      memtech : integer := DEFMEMTECH;
      hirq   : integer := 0;       
      mhindex : integer := 0;
      chprot : integer := 3);
   port (
      rst   : in std_ulogic;
      clk   : in std_ulogic;
      ahbmi : in ahb_mst_in_type;
      ahbmo : out ahb_mst_out_type;
      kready  : out std_logic;
      kstrobe : in std_logic;
      kdata   : in std_logic_vector(23 downto 0);
      xmcumax : in std_logic_vector(5 downto 0);
      ymcumax : in std_logic_vector(4 downto 0);
      incaddy  : in std_logic_vector(15 downto 0);
      incaddmcux : in std_logic_vector(15 downto 0);      
      incaddmcuy : in std_logic_vector(10 downto 0);
      fbstartadd : in std_logic_vector(31 downto 0);
      startgen   : in std_logic
   );
end component;

end;
