------------------------------------------------------------------------------
--  Copyright (C) 2010, Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------





library ieee;
use ieee.std_logic_1164.all;

library grlib,techmap;
use grlib.amba.all;
use grlib.stdlib.all;
use techmap.gencomp.all;
library gaisler;
use gaisler.misc.all;
--use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library kuri;
use kuri.mjpeg.all;

use work.config.all;

entity bus_yccrgbs is
  port (
    rstn : in std_ulogic;
    clk : in std_ulogic;
    ctrl_in1 : in ahbtbm_ctrl_in_type; 
    ctrl_out1 : out ahbtbm_ctrl_out_type);
end;

architecture rtl of bus_yccrgbs is


  signal apbi  : apb_slv_in_type;
  signal apbo  : apb_slv_out_vector := (others => apb_none);
  signal ahbsi : ahb_slv_in_type;
  signal ahbso : ahb_slv_out_vector := (others => ahbs_none);
  signal ahbmi : ahb_mst_in_type;
  signal ahbmo : ahb_mst_out_vector := (others => ahbm_none);

--  signal rst : std_ulogic;



begin  -- rtl

  
--  rst <= not rstn;
   
  yccinst : dctycc
     generic map(shindex => 2, haddr => 16#900#, pindex => 2, paddr => 2, mhindex => 3, hirq => 2)
     port map (rstn, clk, ahbmi, ahbmo(3), ahbsi, ahbso(2), apbi, apbo(2));
         
  apb0 : apbctrl
     generic map (hindex => 4, haddr => 16#800#)
     port map(rstn, clk, ahbsi, ahbso(4), apbi, apbo);
   
  ahbcontroller : ahbctrl                -- AHB arbiter/multiplexer
     generic map (defmast => CFG_DEFMST, split => CFG_SPLIT, 
        enbusmon => 0,rrobin => CFG_RROBIN, ioaddr => CFG_AHBIO)
     port map (rstn, clk, ahbmi, ahbmo, ahbsi, ahbso);

  ram0 : ahbram 
     generic map (hindex => 7, haddr => 16#a00#, tech => CFG_MEMTECH, kbytes => 24) 
     port map (rstn, clk, ahbsi, ahbso(7));

  mast_em : ahbtbm
     generic map(hindex => 0)
     port map (rstn, clk, ctrl_in1, ctrl_out1, ahbmi, ahbmo(0));
 


--  mast_em2 : ahbtbm
--    generic map(hindex => 1)
--    port map (rstn, clk, ctrl_in2, ctrl_out2, ahbmi, ahbmo(1));

end rtl;
  
