------------------------------------------------------------------------------
--  Copyright (C) 2010, Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------



library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;
--use ieee.numeric_std.all;


library gaisler;
use gaisler.sim.all;
use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library techmap;
use techmap.gencomp.all;
library grlib;
use grlib.stdlib.all;
library kuri;
use kuri.mjpeg.all;

use work.debug.all;
use work.config.all;



entity sim_yccrgbs is
  
  generic (
    clkperiod : integer := 20);

end ;

architecture behav of sim_yccrgbs is



  component bus_yccrgbs
    port(
      rstn : in std_ulogic;
      clk : in std_ulogic;
      ctrl_in1 : in ahbtbm_ctrl_in_type;
      ctrl_out1 : out ahbtbm_ctrl_out_type
      );
    
  end component;

signal clk : std_ulogic := '0';
signal rst : std_ulogic := '0';
signal ctrl1 : ahbtb_ctrl_type;
-- signal data_in : std_logic_vector(31 downto 0);

file in_file : text open read_mode is "in_yccrgbs.txt";
file compare_file : text open read_mode is "out_yccrgbs.txt";

begin  -- behav

    b0 : bus_yccrgbs
    port map (rst,clk,ctrl1.i,ctrl1.o);
   
    tictak : process
    begin
        clk <= '0';
        wait for 10 ns;
        clk <= '1';
        wait for 10 ns;
    end process;
    
    stim: process
       variable li : line;
       variable lc : line;
       variable i,j : integer;
  --     variable ycc : std_logic_vector(23 downto 0);
       variable indata : std_logic_vector(31 downto 0);
       variable radd : std_logic_vector(31 downto 0);
  --     variable cdata1, cdata2 : std_logic_vector(15 downto 0);
       variable cdata32 : std_logic_vector(31 downto 0);
       
    begin

      report " stimulus process start ";
      
      rst  <= '0';   
      wait for 100 ns;
      rst <= '1';

    -- initialize
      ahbtbminit(ctrl1);

-- Write Control registers through APB bus

ahbwrite(x"80000200", x"a0000000", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"80000204", x"028001e0", "10", "10", '1', 2, false , ctrl1);
--ahbwrite(x"80000204", x"00500050", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"80000208", x"00000000", "10", "10", '1', 2, false , ctrl1);
--ahbwrite(x"80000208", x"00000460", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"8000020c", x"00000000", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"8000020c", x"ffffffff", "10", "10", '1', 2, false , ctrl1);

-- Write YCC data for IP core      
--      for i in 0 to 33821 loop
      for i in 0 to 3999 loop
        readline(in_file,li);
        hread(li, indata);
        ahbwrite(x"90000000", indata, "10", "10", '1', 2, false , ctrl1);                   
        ahbtbmidle(true, ctrl1);
        wait for 20 ns;
      end loop;
      
      radd := x"a0000000";  
--      for i in 0 to 16910 loop
      for i in 0 to 1999 loop
        readline(compare_file, lc);
        hread(lc, cdata32);
        ahbread(radd, cdata32, "10", 2, false, ctrl1);
        radd := radd + x"004";
      end loop;
      
      ahbtbmidle(true,ctrl1);
      wait for 100 ns; 
  
       
      ahbtbmdone(0, ctrl1);
      wait for 300 ns;

      report "stimulus process end" severity failure;
      wait;
   end process;

end behav;
