------------------------------------------------------------------------------
--  Copyright (C) 2010, Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;

library gaisler;
use gaisler.sim.all;
use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library techmap;
use techmap.gencomp.all;
library grlib;
use grlib.stdlib.all;
library kuri;
use kuri.mjpeg.all;

use work.debug.all;
use work.config.all;

entity sim_amba1 is
  
  generic (
    clkperiod : integer := 20);

end ;

architecture behav of sim_amba1 is

  component bus_amba
    port(
      rstn : in std_ulogic;
      clk : in std_ulogic;
      ctrl_in1 : in ahbtbm_ctrl_in_type;
      ctrl_out1 : out ahbtbm_ctrl_out_type;
      ctrl_in2 : in ahbtbm_ctrl_in_type;
      ctrl_out2 : out ahbtbm_ctrl_out_type
      );    
  end component;

signal clk : std_ulogic := '0';
signal rst : std_ulogic := '0';
signal ctrl1 : ahbtb_ctrl_type;
signal ctrl2 : ahbtb_ctrl_type;

begin  -- behav

    b0 : bus_amba
    port map (rst,clk,ctrl1.i,ctrl1.o,ctrl2.i,ctrl2.o);
   
    tictak : process
    begin
        clk <= '0';
        wait for 10 ns;
        clk <= '1';
        wait for 10 ns;
    end process;
    
    stim: process
       variable i : integer;
       variable indata : std_logic_vector(31 downto 0);
       variable radd : std_logic_vector(31 downto 0);
       variable cdata32 : std_logic_vector(31 downto 0);
       
    begin

      report " stimulus process start ";
      
      rst  <= '0';   
      wait for 100 ns;
      rst <= '1';

    -- initialize
      ahbtbminit(ctrl1);
      ahbtbminit(ctrl2);

    -- Write Control registers through APB bus

      ahbwrite(x"80000200", x"a0000000", "10", "10", '1', 2, false , ctrl2);
      ahbwrite(x"80000204", x"ffffffff", "10", "10", '1', 2, false , ctrl2);
    
    -- Write data  from amba master emulator2  
        indata := x"00000001";
      for i in 0 to 100 loop
        ahbwrite(x"90000000", indata, "10", "10", '1', 2, false , ctrl2);                   
        ahbtbmidle(true, ctrl2);
        indata := indata + 1;
        wait for 60 ns;
      end loop;
      
    -- Read from AHBRAM and compare data 
      radd := x"a0000000";  
      cdata32 := x"00000000";
      for i in 0 to 80 loop
        ahbread(radd, cdata32, "10", 2, false, ctrl2);
        radd := radd + x"004";
      end loop;
      
      ahbtbmidle(true,ctrl2);
      wait for 100 ns; 
  
      ahbtbmdone(0, ctrl1);
      ahbtbmdone(0, ctrl2);
      wait for 300 ns;

      report "stimulus process end" severity failure;
      wait;
   end process;

end behav;
