#include <asm/ptrace.h>

enum registers_offset {
    GDB_REGNUM_G0 = 0, GDB_REGNUM_G1, GDB_REGNUM_G2, GDB_REGNUM_G3, GDB_REGNUM_G4, GDB_REGNUM_G5, GDB_REGNUM_G6, GDB_REGNUM_G7,
    GDB_REGNUM_O0, GDB_REGNUM_O1, GDB_REGNUM_O2, GDB_REGNUM_O3, GDB_REGNUM_O4, GDB_REGNUM_O5, GDB_REGNUM_SP, GDB_REGNUM_O7,
    GDB_REGNUM_L0, GDB_REGNUM_L1, GDB_REGNUM_L2, GDB_REGNUM_L3, GDB_REGNUM_L4, GDB_REGNUM_L5, GDB_REGNUM_L6, GDB_REGNUM_L7,
    GDB_REGNUM_I0, GDB_REGNUM_I1, GDB_REGNUM_I2, GDB_REGNUM_I3, GDB_REGNUM_I4, GDB_REGNUM_I5, GDB_REGNUM_FP, GDB_REGNUM_I7,
    
    GDB_REGNUM_F0, GDB_REGNUM_F1, GDB_REGNUM_F2, GDB_REGNUM_F3, GDB_REGNUM_F4, GDB_REGNUM_F5, GDB_REGNUM_F6, GDB_REGNUM_F7,
    GDB_REGNUM_F8, GDB_REGNUM_F9, GDB_REGNUM_F10, GDB_REGNUM_F11, GDB_REGNUM_F12, GDB_REGNUM_F13, GDB_REGNUM_F14, GDB_REGNUM_F15,
    GDB_REGNUM_F16, GDB_REGNUM_F17, GDB_REGNUM_F18, GDB_REGNUM_F19, GDB_REGNUM_F20, GDB_REGNUM_F21, GDB_REGNUM_F22, GDB_REGNUM_F23,
    GDB_REGNUM_F24, GDB_REGNUM_F25, GDB_REGNUM_F26, GDB_REGNUM_F27, GDB_REGNUM_F28, GDB_REGNUM_F29, GDB_REGNUM_F30, GDB_REGNUM_F31,
    
    GDB_REGNUM_Y, GDB_REGNUM_PSR, GDB_REGNUM_WIM, GDB_REGNUM_TBR, GDB_REGNUM_PC, GDB_REGNUM_NPC, GDB_REGNUM_FPSR, GDB_REGNUM_CPSR,
    GDB_REGNUM_SIZE
};

#define REGISTER_BYTES (GDB_REGNUM_SIZE * 4) 

#define NUM_REGS   GDB_REGNUM_SIZE
#define NUM_FREGS  32

#define PC_REGNUM  GDB_REGNUM_PC
#define FP_REGNUM  GDB_REGNUM_FP
#define SP_REGNUM  GDB_REGNUM_SP
#define NPC_REGNUM GDB_REGNUM_NPC
#define O7_REGNUM  GDB_REGNUM_O7

#define REGISTER_BYTE(n) (n*4)
#define REGISTER_RAW_SIZE(n) 4
