------------------------------------------------------------------------------
--  Copyright (C) 2010, Kenichi Kurimoto
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
-----------------------------------------------------------------------------



library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;
--use ieee.numeric_std.all;


library gaisler;
use gaisler.sim.all;
use gaisler.ambatest.all;
use gaisler.ahbtbp.all;
library techmap;
use techmap.gencomp.all;
library grlib;
use grlib.stdlib.all;
library kuri;
use kuri.mjpeg.all;

use work.debug.all;
use work.config.all;



entity sim_huffdctycc is
  
  generic (
    clkperiod : integer := 20);

end ;

architecture behav of sim_huffdctycc is



  component bus_huffdctycc
    port(
      rstn : in std_ulogic;
      clk : in std_ulogic;
      ctrl_in1 : in ahbtbm_ctrl_in_type;
      ctrl_out1 : out ahbtbm_ctrl_out_type
      );
    
  end component;

signal clk : std_ulogic := '0';
signal rst : std_ulogic := '0';
signal ctrl1 : ahbtb_ctrl_type;
-- signal data_in : std_logic_vector(31 downto 0);

file in_file : text open read_mode is "in_huff.txt";
file in_quantfile : text open read_mode is "in_qtbl.txt";
file compare_file : text open read_mode is "out_upycc.txt";
file in_acfile : text open read_mode is "in_accache.txt";
file in_dcfile : text open read_mode is "in_dccache.txt";
file in_maxcfile : text open read_mode is "in_maxcode.txt";
file in_offsfile : text open read_mode is "in_valoffs.txt";
file in_huffvfile : text open read_mode is "in_huffval.txt";

begin  -- behav

    b0 : bus_huffdctycc
    port map (rst,clk,ctrl1.i,ctrl1.o);
   
    tictak : process
    begin
        clk <= '0';
        wait for 10 ns;
        clk <= '1';
        wait for 10 ns;
    end process;
    
    stim: process
       variable li : line;
       variable lc : line;
       variable i,j : integer;
 --      variable dctindata : std_logic_vector(11 downto 0);
       variable indata : std_logic_vector(31 downto 0);
       variable radd : std_logic_vector(31 downto 0);
  --     variable cdata1, cdata2 : std_logic_vector(15 downto 0);
       variable cdata32 : std_logic_vector(31 downto 0);
       variable quantvec : std_logic_vector(7 downto 0);
       variable wadd : std_logic_vector(31 downto 0);

    begin

      report " stimulus process start ";      
      rst  <= '0';   
      wait for 100 ns;
      rst <= '1';

    -- initialize
      ahbtbminit(ctrl1);

-- Write Control registers through APB bus

ahbwrite(x"80000200", x"a0000000", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"80000204", x"00082464", "10", "10", '1', 2, false , ctrl1);
--ahbwrite(x"80000204", x"005c9a84", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"80000208", x"04E4B504", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"8000020C", x"00000000", "10", "10", '1', 2, false , ctrl1);
ahbwrite(x"8000020C", x"f0000000", "10", "10", '1', 2, false , ctrl1);

     ahbtbmidle(true, ctrl1);
     wait for 100 ns;
     wadd := x"9000c000";
     for i in 0 to 191 loop
         readline(in_quantfile, li);
         hread(li, quantvec);
         ahbwrite(wadd, x"000000" & quantvec, "10", "10", '1', 2, false, ctrl1);
         wadd := wadd + x"00000004";
     end loop;
     ahbtbmidle(true, ctrl1);


      for i in 0 to 1023 loop
          readline(in_acfile, li);
          hread(li, wadd);
          hread(li, cdata32);    
          wadd := wadd(29 downto 0) & "00";
          wadd := wadd  +"100000000000000";
          wadd := wadd + x"90000000";
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      for i in 0 to 1023 loop
          readline(in_dcfile, li);
          hread(li, wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := wadd  + "1000000000000000";
          wadd := wadd + x"90000000";
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;          
      for i in 0 to 71 loop
          readline(in_maxcfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90000400" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      for i in 0 to 71 loop
          readline(in_offsfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90000800" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;      
      for i in 0 to 1023 loop
          readline(in_huffvfile,li);
          hread(li,wadd);
          wadd := wadd(29 downto 0) & "00";
          wadd := x"90002000" + wadd ;
          hread(li, cdata32);
          ahbwrite(wadd, cdata32, "10", "10", '1', 2, false , ctrl1);
      end loop;
      
    ahbtbmidle(true,ctrl1);
    wait for 100 ns;   


-- Write scan data for IP core
--      for i in 0 to 2718 loop

      for i in 0 to 30 loop
--      for i in 0 to 120 loop
        readline(in_file,li);
        hread(li, cdata32);
        ahbwrite(x"90000000", cdata32, "10", "10", '1', 2, false , ctrl1);                   
        ahbtbmidle(true, ctrl1);
        wait for 40000 ns;
      end loop;

ahbtbmidle(true,ctrl1);
wait for 100000 ns;   


      radd := x"a0000000";  
--      for i in 0 to 79 loop
      for i in 0 to 16 loop
        for j in 0 to 39 loop
--        for j in 0 to 160 loop
          readline(compare_file, lc);
          hread(lc, cdata32);
          ahbread(radd, cdata32, "10", 2, false, ctrl1);
          radd := radd + x"004";
        end loop;
        radd := radd + x"460";
--        radd := radd + x"280";
      end loop;

      ahbtbmidle(true,ctrl1);
      wait for 100 ns; 

      ahbtbmdone(0, ctrl1);
      wait for 300 ns;

      report "stimulus process end" severity failure;
      wait;
   end process;

end behav;
