-- *************************************************************************
-- ***** BLANCA 周辺入出力プロセッサ(IOP)用  (Spartan3/400)
-- ***** I/Oプロセッサ トップモジュール
-- ***** 実インターフェース信号A/Vプロセッサ直結版
-- *************************************************************************

library ieee;
use ieee.std_logic_1164.all;


entity iop is
	port (


	-- ***** A/Vプロセッサ直結信号 ***** --

	-- COMポート信号ピン
		AV_COM1_TxD		: in	std_logic;						-- TxD
		AV_COM1_RxD		: out	std_logic;						-- RxD
		AV_COM1_RTS		: in	std_logic;						-- RTS
		AV_COM1_CTS		: out	std_logic;						-- CTS

	-- LAN信号ピン
		AV_LAN_TxCLK	: out	std_logic;						-- 送信クロック
		AV_LAN_TxERR	: in	std_logic;						-- 送信エラー
		AV_LAN_TxEN		: in	std_logic;						-- 送信イネーブル
		AV_LAN_TxD		: in	std_logic_vector( 3 downto 0);	-- 送信データ
		AV_LAN_RxCLK	: out	std_logic;						-- 受信クロック
		AV_LAN_RxERR	: out	std_logic;						-- 受信エラー
		AV_LAN_RxDV		: out	std_logic;						-- 受信イネーブル
		AV_LAN_RxD		: out	std_logic_vector( 3 downto 0);	-- 受信データ
		AV_LAN_COL		: out	std_logic;						-- 衝突検出
		AV_LAN_CRS		: out	std_logic;						-- キャリアセンス
		AV_LAN_MDC		: in	std_logic;						-- PHYチップ通信クロック
		AV_LAN_MDIO_i	: out	std_logic;						-- PHYチップ通信データ入力
		AV_LAN_MDIO_o	: in	std_logic;						-- PHYチップ通信データ出力
		AV_LAN_MDIO_t	: in	std_logic;						-- PHYチップ通信データ制御

	-- PS/2インターフェース信号ピン
		AV_PS2a_CLK_i	: out	std_logic;						-- ポートa クロック入力
		AV_PS2a_CLK_o	: in	std_logic;						-- ポートa クロック出力
		AV_PS2a_CLK_t	: in	std_logic;						-- ポートa クロック制御
		AV_PS2a_DATA_i	: out	std_logic;						-- ポートa データ入力
		AV_PS2a_DATA_o	: in	std_logic;						-- ポートa データ出力
		AV_PS2a_DATA_t	: in	std_logic;						-- ポートa データ制御
		AV_PS2b_CLK_i	: out	std_logic;						-- ポートb クロック入力
		AV_PS2b_CLK_o	: in	std_logic;						-- ポートb クロック出力
		AV_PS2b_CLK_t	: in	std_logic;						-- ポートb クロック制御
		AV_PS2b_DATA_i	: out	std_logic;						-- ポートb データ入力
		AV_PS2b_DATA_o	: in	std_logic;						-- ポートb データ出力
		AV_PS2b_DATA_t	: in	std_logic;						-- ポートb データ制御

	-- IDE信号ピン
		AV_IDE_nRST		: in	std_logic;						-- リセット
		AV_IDE_nDIOR	: in	std_logic;						-- リード
		AV_IDE_nDIOW	: in	std_logic;						-- ライト
		AV_IDE_INTRQ	: out	std_logic;						-- 割り込み
		AV_IDE_IORDY	: out	std_logic;						-- I/Oレディ
		AV_IDE_DMARQ	: out	std_logic;						-- DMAリクエスト
		AV_IDE_DMACK	: in	std_logic;						-- DMAアクノリッジ
		AV_IDE_nCS		: in	std_logic_vector( 1 downto 0);	-- チップセレクト
		AV_IDE_DA		: in	std_logic_vector( 2 downto 0);	-- アドレス
		AV_IDE_DD_i		: out	std_logic_vector(15 downto 0);	-- データバス入力
		AV_IDE_DD_o		: in	std_logic_vector(15 downto 0);	-- データバス出力
		AV_IDE_DD_t		: in	std_logic;						-- データバス制御
		AV_IDE_DIR		: in	std_logic;						-- データバスバッファ方向制御

	-- USBホスト/ターゲット信号ピン
		AV_USB1_Dp_i	: out	std_logic;						-- USBホスト1 D+入力
		AV_USB1_Dp_o	: in	std_logic;						-- USBホスト1 D+出力
		AV_USB1_Dp_t	: in	std_logic;						-- USBホスト1 D+制御
		AV_USB1_Dn_i	: out	std_logic;						-- USBホスト1 D-入力
		AV_USB1_Dn_o	: in	std_logic;						-- USBホスト1 D-出力
		AV_USB1_Dn_t	: in	std_logic;						-- USBホスト1 D-制御
		AV_USB3_Dp_i	: out	std_logic;						-- USBターゲット D+入力
		AV_USB3_Dp_o	: in	std_logic;						-- USBターゲット D+出力
		AV_USB3_Dp_t	: in	std_logic;						-- USBターゲット D+制御
		AV_USB3_Dn_i	: out	std_logic;						-- USBターゲット D-入力
		AV_USB3_Dn_o	: in	std_logic;						-- USBターゲット D-出力
		AV_USB3_Dn_t	: in	std_logic;						-- USBターゲット D-制御
		AV_USB3_DISCON	: in	std_logic;						-- USBターゲットイネーブル



	-- ***** 実インターフェース信号 ***** --

	-- LAN信号ピン
		LAN_TxCLK		: in	std_logic;						-- 送信クロック
		LAN_TxERR		: out	std_logic;						-- 送信エラー
		LAN_TxEN		: out	std_logic;						-- 送信イネーブル
		LAN_TxD			: out	std_logic_vector( 3 downto 0);	-- 送信データ
		LAN_RxCLK		: in	std_logic;						-- 受信クロック
		LAN_RxERR		: in	std_logic;						-- 受信エラー
		LAN_RxDV		: in	std_logic;						-- 受信イネーブル
		LAN_RxD			: in	std_logic_vector( 3 downto 0);	-- 受信データ
		LAN_COL			: in	std_logic;						-- 衝突検出
		LAN_CRS			: in	std_logic;						-- キャリアセンス
		LAN_MDC			: out	std_logic;						-- PHYチップ通信クロック
		LAN_MDIO		: inout	std_logic;						-- PHYチップ通信データ

	-- IDE信号ピン
		IDE_nRST		: out	std_logic;						-- リセット
		IDE_nDIOR		: out	std_logic;						-- リード
		IDE_nDIOW		: out	std_logic;						-- ライト
		IDE_INTRQ		: in	std_logic;						-- 割り込み
		IDE_IORDY		: in	std_logic;						-- I/Oレディ
		IDE_DMARQ		: in	std_logic;						-- DMAリクエスト
		IDE_DMACK		: out	std_logic;						-- DMAアクノリッジ
		IDE_nCS			: out	std_logic_vector( 1 downto 0);	-- チップセレクト
		IDE_DA			: out	std_logic_vector( 2 downto 0);	-- アドレス
		IDE_DD			: inout	std_logic_vector(15 downto 0);	-- データバス
		IDE_DIR			: out	std_logic;						-- データバスバッファ方向制御

	-- USBホスト/ターゲット信号ピン
		U_F48M			: in	std_logic;						-- USBクロック(48MHz)
		USB1_Dp			: inout	std_logic;						-- USBホスト1 D+
		USB1_Dn			: inout	std_logic;						-- USBホスト1 D-
		USB3_Dp			: inout	std_logic;						-- USBターゲット D+
		USB3_Dn			: inout	std_logic;						-- USBターゲット D-
		USB3_DISCON		: out	std_logic;						-- USBターゲットイネーブル

	-- PS/2インターフェース信号ピン
		PS2a_CLK		: inout	std_logic;						-- ポートa クロック
		PS2a_DATA		: inout	std_logic;						-- ポートa データ
		PS2b_CLK		: inout	std_logic;						-- ポートb クロック
		PS2b_DATA		: inout	std_logic;						-- ポートb データ

	-- COMポート信号ピン
		COM1_TxD		: out	std_logic;						-- TxD
		COM1_RxD		: in	std_logic;						-- RxD
		COM1_RTS		: out	std_logic;						-- RTS
		COM1_CTS		: in	std_logic;						-- CTS


	-- ***** 未使用信号 ***** --

	-- システムリセット
		SYS_nRST		: in	std_logic;						-- リセット(リセットスイッチ)

	-- USBホスト信号ピン
		USB2_Dp			: inout	std_logic;						-- USBホスト2 D+
		USB2_Dn			: inout	std_logic;						-- USBホスト2 D-

	-- CompactFlash信号ピン
		CF_nBUFEN		: out	std_logic;						-- バスバッファイネーブル
		CF_nPOWEN		: out	std_logic;						-- 電源イネーブル
		-- 以下省略

	-- PCIバス信号ピン
		-- 全省略

	-- アナログRGB信号ピン
		V_nHSYNC		: in	std_logic;						-- 将来拡張用
		V_nVSYNC		: in	std_logic						-- 将来拡張用

	);
end iop;

architecture RTL of iop is
component IOBUF
   port (O : out STD_ULOGIC;
         IO : inout STD_ULOGIC;
         I : in STD_ULOGIC;
         T : in STD_ULOGIC);
end component;

	signal LAN_MDIO_i	: std_logic;
	signal LAN_MDIO_o	: std_logic;
	signal LAN_MDIO_t	: std_logic;
	signal LAN_MDIO_t_v : std_logic;

	signal IDE_DD_i		: std_logic_vector(15 downto 0);
	signal IDE_DD_o		: std_logic_vector(15 downto 0);
	signal IDE_DD_t		: std_logic;

	signal USB1_Dp_i	: std_logic;
	signal USB1_Dp_o	: std_logic;
	signal USB1_Dp_t	: std_logic;
	signal USB1_Dn_i	: std_logic;
	signal USB1_Dn_o	: std_logic;
	signal USB1_Dn_t	: std_logic;
	signal USB3_Dp_i	: std_logic;
	signal USB3_Dp_o	: std_logic;
	signal USB3_Dp_t	: std_logic;
	signal USB3_Dn_i	: std_logic;
	signal USB3_Dn_o	: std_logic;
	signal USB3_Dn_t	: std_logic;

	signal PS2a_CLK_i	: std_logic;
	signal PS2a_CLK_o	: std_logic;
	signal PS2a_CLK_t	: std_logic;
	signal PS2a_DATA_i	: std_logic;
	signal PS2a_DATA_o	: std_logic;
	signal PS2a_DATA_t	: std_logic;
	signal PS2b_CLK_i	: std_logic;
	signal PS2b_CLK_o	: std_logic;
	signal PS2b_CLK_t	: std_logic;
	signal PS2b_DATA_i	: std_logic;
	signal PS2b_DATA_o	: std_logic;
	signal PS2b_DATA_t	: std_logic;


begin




	-- ***** A/Vプロセッサ直結信号接続 ***** --

	-- COMポート信号ピン(IOP→AVP方向)
	AV_COM1_RxD		<= COM1_RxD;
	AV_COM1_CTS		<= COM1_CTS;

	-- COMポート信号ピン(AVP→IOP方向)
	COM1_TxD		<= AV_COM1_TxD;
	COM1_RTS		<= AV_COM1_RTS;


	-- LAN信号ピン接続(IOP→AVP方向)
	AV_LAN_TxCLK	<= LAN_TxCLK;
	AV_LAN_RxCLK	<= LAN_RxCLK;
	AV_LAN_RxERR	<= LAN_RxERR;
	AV_LAN_RxDV		<= LAN_RxDV;
	AV_LAN_RxD		<= LAN_RxD;
	AV_LAN_COL		<= LAN_COL;
	AV_LAN_CRS		<= LAN_CRS;
	AV_LAN_MDIO_i	<= LAN_MDIO_i;

	-- LAN信号ピン接続(AVP→IOP方向)
	LAN_TxERR		<= AV_LAN_TxERR;
	LAN_TxEN		<= AV_LAN_TxEN;
	LAN_TxD			<= AV_LAN_TxD;
	LAN_MDC			<= AV_LAN_MDC;
	LAN_MDIO_o		<= AV_LAN_MDIO_o;
	LAN_MDIO_t		<= AV_LAN_MDIO_t;


	-- PS/2インターフェース信号ピン(IOP→AVP方向)
	AV_PS2a_CLK_i	<= PS2a_CLK_i;
	AV_PS2a_DATA_i	<= PS2a_DATA_i;
	AV_PS2b_CLK_i	<= PS2b_CLK_i;
	AV_PS2b_DATA_i	<= PS2b_DATA_i;

	-- PS/2インターフェース信号ピン(AVP→IOP方向)
	PS2a_CLK_o		<= AV_PS2a_CLK_o;
	PS2a_CLK_t		<= AV_PS2a_CLK_t;
	PS2a_DATA_o		<= AV_PS2a_DATA_o;
	PS2a_DATA_t		<= AV_PS2a_DATA_t;
	PS2b_CLK_o		<= AV_PS2b_CLK_o;
	PS2b_CLK_t		<= AV_PS2b_CLK_t;
	PS2b_DATA_o		<= AV_PS2b_DATA_o;
	PS2b_DATA_t		<= AV_PS2b_DATA_t;


	-- IDE信号ピン(IOP→AVP方向)
	AV_IDE_INTRQ	<= IDE_INTRQ;
	AV_IDE_IORDY	<= IDE_IORDY;
	AV_IDE_DMARQ	<= IDE_DMARQ;
	AV_IDE_DD_i		<= IDE_DD_i;

	-- IDE信号ピン(AVP→IOP方向)
	IDE_nRST		<= AV_IDE_nRST;
	IDE_nDIOR		<= AV_IDE_nDIOR;
	IDE_nDIOW		<= AV_IDE_nDIOW;
	IDE_DMACK		<= AV_IDE_DMACK;
	IDE_nCS			<= AV_IDE_nCS;
	IDE_DA			<= AV_IDE_DA;
	IDE_DD_o		<= AV_IDE_DD_o;
	IDE_DD_t		<= AV_IDE_DD_t;
	IDE_DIR			<= AV_IDE_DIR;


	-- USBホスト/ターゲット信号ピン(IOP→AVP方向)
	AV_USB1_Dp_i	<= USB1_Dp_i;
	AV_USB1_Dn_i	<= USB1_Dn_i;
	AV_USB3_Dp_i	<= USB3_Dp_i;
	AV_USB3_Dn_i	<= USB3_Dn_i;

	-- USBホスト/ターゲット信号ピン(AVP→IOP方向)
	USB1_Dp_o		<= AV_USB1_Dp_o;
	USB1_Dp_t		<= AV_USB1_Dp_t;
	USB1_Dn_o		<= AV_USB1_Dn_o;
	USB1_Dn_t		<= AV_USB1_Dn_t;
	USB3_Dp_o		<= AV_USB3_Dp_o;
	USB3_Dp_t		<= AV_USB3_Dp_t;
	USB3_Dn_o		<= AV_USB3_Dn_o;
	USB3_Dn_t		<= AV_USB3_Dn_t;
	USB3_DISCON		<= AV_USB3_DISCON;




	-- ***** 実インターフェース双方向信号接続 ***** --

	-- ***** PS/2信号 双方向制御 ***** --
--	PS2a_CLK	<= PS2a_CLK_o when (PS2a_CLK_t = '1') else 'Z';
--	PS2a_CLK_i	<= PS2a_CLK;
--	PS2a_DATA	<= PS2a_DATA_o when (PS2a_DATA_t = '1') else 'Z';
--	PS2a_DATA_i	<= PS2a_DATA;

      ioinst1 : IOBUF
                port map ( O => PS2a_CLK_i, IO => PS2a_CLK, I => PS2a_CLK_o, T => PS2a_CLK_t);
      ioinst2 : IOBUF
                port map ( O => PS2a_DATA_i, IO => PS2a_DATA, I => PS2a_DATA_o, T => PS2a_DATA_t);
    

--	PS2b_CLK	<= PS2b_CLK_o when (PS2b_CLK_t = '1') else 'Z';
--	PS2b_CLK_i	<= PS2b_CLK;
--	PS2b_DATA	<= PS2b_DATA_o when (PS2b_DATA_t = '1') else 'Z';
--	PS2b_DATA_i	<= PS2b_DATA;

      ioinst3 : IOBUF
                port map ( O => PS2b_CLK_i, IO => PS2b_CLK, I => PS2b_CLK_o, T => PS2b_CLK_t);
      ioinst4 : IOBUF
                port map ( O => PS2b_DATA_i, IO => PS2b_DATA, I => PS2b_DATA_o, T => PS2b_DATA_t);


	-- ***** LAN MDIO 双方向制御 ***** --
--	LAN_MDIO	<= LAN_MDIO_o when (LAN_MDIO_t = '1') else 'Z';
--	LAN_MDIO_i	<= LAN_MDIO;
--   LAN_MDIO_t_v <= not LAN_MDIO_t;
      ioinst5 : IOBUF
                port map ( O => LAN_MDIO_i, IO => LAN_MDIO, I => LAN_MDIO_o, T => LAN_MDIO_t);


	-- ***** IDEデータバス 双方向制御 ***** --
	IDE_DD		<= IDE_DD_o when (IDE_DD_t = '1') else (others => 'Z');
	IDE_DD_i	<= IDE_DD;

	-- ***** USB信号 双方向制御 ***** --
	USB1_Dp		<= USB1_Dp_o when (USB1_Dp_t = '1') else 'Z';
	USB1_Dp_i	<= USB1_Dp;
	USB1_Dn		<= USB1_Dn_o when (USB1_Dn_t = '1') else 'Z';
	USB1_Dn_i	<= USB1_Dn;

	USB3_Dp		<= USB3_Dp_o when (USB3_Dp_t = '1') else 'Z';
	USB3_Dp_i	<= USB3_Dp;
	USB3_Dn		<= USB3_Dn_o when (USB3_Dn_t = '1') else 'Z';
	USB3_Dn_i	<= USB3_Dn;




	-- ***** 未使用信号処理 ***** --
	CF_nBUFEN	<= '1';
	CF_nPOWEN	<= '1';

	USB2_Dp		<= 'Z';
	USB2_Dn		<= 'Z';



end RTL;
