﻿using System;
using System.Text;
using System.Xml.Serialization;
using System.Collections.ObjectModel;
using System.IO;
using Windows.ApplicationModel.DataTransfer;
using Windows.Foundation;
using Windows.Graphics.Printing;
using Windows.Storage;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Media;
using System.Threading.Tasks;
using FooEditEngine;
using FooEditEngine.Metro;
using EncodeDetect;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class DocumentControl : UserControl, IXmlSerializable,IDisposable
    {
        DocumentControlViewModel vm;
        public DocumentControl()
        {
            this.InitializeComponent();
            this.vm = new DocumentControlViewModel(this.TextBox);
            this.DataContext = this.vm;
        }

        public FooTextBox TextBox
        {
            get
            {
                return this.Textbox;
            }
        }

        public string Title
        {
            get
            {
                return this.vm.Title;
            }
            set
            {
                this.vm.Title = value;
            }
        }

        public bool IsDirty
        {
            get
            {
                return this.vm.IsDirty;
            }
        }

        public FileType DocumentType
        {
            get
            {
                return this.vm.DocumentType;
            }
        }

        public Encoding Encode
        {
            get
            {
                return this.vm.Encode;
            }
            set
            {
                this.vm.Encode = value;
            }
        }

        public LineFeedType LineFeed
        {
            get
            {
                return this.vm.LineFeed;
            }
            set
            {
                this.vm.LineFeed = value;
            }
        }

        public bool IsHitTextArea(Point point)
        {
            return this.vm.IsHitTextArea(point);
        }

        public void Print(PrintTaskRequestedEventArgs args)
        {
            this.vm.Print(args);
        }

        public void GetData(DataRequestedEventArgs args)
        {
            this.vm.GetData(args);
        }

        public void ApplySetting(AppSettings setting)
        {
            this.vm.ApplySetting(setting);
        }

        public void ApplyDocumentSetting(AppSettings setting, FileType type)
        {
            this.vm.ApplyDocumentSetting(setting, type);
        }

        public async Task SetDocumentType(FileType type)
        {
            await this.vm.SetDocumentType(type);
        }

        public async Task LoadFile(StorageFile file, Encoding enc = null)
        {
            await this.vm.LoadFile(file, enc);
        }

        public async Task ReloadFile(Encoding enc)
        {
            await this.vm.ReloadFile(enc);
        }

        public Popup CreatePopup(Type t)
        {
            return this.vm.CreatePopup(t);
        }

        public async Task SaveFile(StorageFile file)
        {
            await this.vm.SaveFile(file);
        }

        public void Undo()
        {
            this.vm.Undo();
        }

        public void Redo()
        {
            this.vm.Redo();
        }

        public System.Xml.Schema.XmlSchema GetSchema()
        {
            return null;
        }

        public async void ReadXml(System.Xml.XmlReader reader)
        {
            await this.vm.ReadXml(reader);
        }

        public async void WriteXml(System.Xml.XmlWriter writer)
        {
            await this.vm.WriteXml(writer);
        }

        public void Dispose()
        {
            this.vm.Dispose();
        }
    }
}
