﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using FooEditor.UWP.ViewModels;

// コンテンツ ダイアログの項目テンプレートについては、https://go.microsoft.com/fwlink/?LinkId=234238 を参照してください

namespace FooEditor.UWP.Views
{
    public sealed partial class OpenRecentlyView : ContentDialog
    {
        public OpenRecentlyView()
        {
            this.InitializeComponent();
            this.Loaded += OpenRecentlyView_Loaded;
        }

        public string SelectedFilePath
        {
            get;
            private set;
        }

        private async void OpenRecentlyView_Loaded(object sender, RoutedEventArgs e)
        {
            var vm = this.DataContext as OpenRecentlyViewModel;
            if (vm != null)
                await vm.Initalize();
        }

        private void ContentDialog_PrimaryButtonClick(ContentDialog sender, ContentDialogButtonClickEventArgs args)
        {
            var vm = this.DataContext as OpenRecentlyViewModel;
            this.SelectedFilePath = vm.FilePath.FilePath;
        }

        private void ContentDialog_SecondaryButtonClick(ContentDialog sender, ContentDialogButtonClickEventArgs args)
        {
        }
    }
}
