﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.Storage;
using Windows.Storage.Pickers;
using Windows.Storage.AccessCache;
using Windows.UI.Popups;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Navigation;
using Windows.Graphics.Printing;
using Windows.System.Threading;

namespace FooEditor.UWP.Services
{
    public interface IMainViewService
    {
        Task<bool> ConfirmReload();
        Task<bool> ConfirmRestoreUserState();
    }

    public class MainViewService : IMainViewService
    {
        public async Task<bool> ConfirmRestoreUserState()
        {
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            var msg = new MessageDialog(loader.GetString("RestoreUsareStateMessage"), "");
            msg.Commands.Add(new UICommand(loader.GetString("YesButton")));
            msg.Commands.Add(new UICommand(loader.GetString("NoButton")));
            var res = await msg.ShowAsync();
            return res.Label == loader.GetString("YesButton");
        }

        public async Task<bool> ConfirmReload()
        {
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            var msg = new MessageDialog(loader.GetString("ReloadMessage"), "");
            msg.Commands.Add(new UICommand(loader.GetString("YesButton")));
            msg.Commands.Add(new UICommand(loader.GetString("NoButton")));
            var res = await msg.ShowAsync();
            return res.Label == loader.GetString("YesButton");
        }
    }
}
