﻿using System;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;
using Windows.ApplicationModel.Resources;
using Windows.UI.Popups;
using Windows.UI.Xaml.Controls;
using System.Runtime.CompilerServices;
using EncodeDetect;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class PropertyFlyout : Page
    {
        PropertyFlyoutViewModel vm;
        DocumentControl CurrentDocument;

        public PropertyFlyout()
        {
            this.InitializeComponent();
        }

        public PropertyFlyout(DocumentControl document)
            : this()
        {
            this.vm = new PropertyFlyoutViewModel();
            this.FlyoutContent.DataContext = this.vm;

            this.vm.Encode = document.Encode;
            this.vm.DocumentType = document.DocumentType;
            this.vm.LineFeed = document.LineFeed;

            this.vm.SetFileType = document.SetDocumentType;

            this.vm.SetEncode = async (enc) =>
            {
                ResourceLoader loader = new ResourceLoader();
                MessageDialog dialog = new MessageDialog(loader.GetString("ReloadMessage"));
                dialog.Commands.Add(new UICommand(loader.GetString("YesButton"), async (p) =>
                {
                    await this.CurrentDocument.ReloadFile(enc);
                }));
                dialog.Commands.Add(new UICommand(loader.GetString("NoButton"), (p) =>
                {
                    this.CurrentDocument.Encode = enc;
                }));
                await dialog.ShowAsync();
            };

            this.vm.SetLineFeed = (linefeed) => {
                this.CurrentDocument.LineFeed = linefeed;
            };

            this.CurrentDocument = document;
        }

    }
    class PropertyFlyoutViewModel : ViewModelBase
    {
        FileType _FileType;
        Encoding _Encode;
        LineFeedType _LineFeed;

        static ObservableCollection<Encoding> encodeCollection = new ObservableCollection<Encoding>();
        static ObservableCollection<LineFeedType> lineFeedCollection = new ObservableCollection<LineFeedType>();

        public PropertyFlyoutViewModel()
        {
            if (encodeCollection.Count == 0)
            {
                encodeCollection.Add(Encoding.GetEncoding("utf-32"));
                encodeCollection.Add(Encoding.GetEncoding("utf-32BE"));
                encodeCollection.Add(Encoding.GetEncoding("utf-16"));
                encodeCollection.Add(Encoding.GetEncoding("unicodeFFFE"));
                encodeCollection.Add(Encoding.GetEncoding("iso-2022-jp"));
                encodeCollection.Add(Encoding.GetEncoding("us-ascii"));
                encodeCollection.Add(Encoding.GetEncoding("euc-jp"));
                encodeCollection.Add(Encoding.GetEncoding("shift_jis"));
                encodeCollection.Add(new UTF8Encoding());
            }
            if (lineFeedCollection.Count == 0)
            {
                lineFeedCollection.Add(LineFeedType.CR);
                lineFeedCollection.Add(LineFeedType.CRLF);
                lineFeedCollection.Add(LineFeedType.LF);
            }
        }

        public Func<FileType,System.Threading.Tasks.Task> SetFileType;

        public Func<Encoding, System.Threading.Tasks.Task> SetEncode;

        public Action<LineFeedType> SetLineFeed;

        public FileType DocumentType
        {
            get
            {
                return this._FileType;
            }
            set
            {
                this._FileType = value;
                if(this.SetFileType != null)
                    this.SetFileType(value);
                this.OnPropertyChanged();
            }
        }

        public Encoding Encode
        {
            get
            {
                return this._Encode;
            }
            set
            {
                this._Encode = value;
                if(this.SetEncode != null)
                    this.SetEncode(value);
                this.OnPropertyChanged();
            }
        }

        public LineFeedType LineFeed
        {
            get
            {
                return this._LineFeed;
            }
            set
            {
                this._LineFeed = value;
                if(this.SetLineFeed != null)
                    this.SetLineFeed(value);
                this.OnPropertyChanged();
            }
        }

        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return AppSettings.Current.FileTypeCollection;
            }
        }

        public ObservableCollection<Encoding> EncodeCollection
        {
            get
            {
                return encodeCollection;
            }
        }

        public ObservableCollection<LineFeedType> LineFeedCollection
        {
            get
            {
                return lineFeedCollection;
            }
        }
    }
}
