﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;

namespace FooEditor.Plugin
{
    public class FormCollection : IEnumerable<Form>
    {
        private DockPanel Panel;
        public FormCollection(DockPanel panel)
        {
            this.Panel = panel;
        }

        /// <summary>
        /// 
        /// </summary>
        public int Count
        {
            get { return this.Panel.Contents.Count; }
        }

        /// <summary>
        /// Formを取得する
        /// </summary>
        /// <param name="n">インデックス</param>
        public Form this[int n]
        {
            get { return (Form)this.Panel.Contents[n]; }
        }

        public IEnumerator<Form> GetEnumerator()
        {
            for (int i = 0; i < this.Panel.Contents.Count; i++)
                yield return this[i];
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }
    }
}
