﻿using System;
using System.IO;
using System.IO.Pipes;
using FooEditor.Properties;

namespace FooEditor
{
    sealed class IPCClient
    {
        public IPCClient()
        {
        }

        public void Send(string pipeName,string str)
        {
            string result = string.Empty;
            using (NamedPipeClientStream pipeClient = new NamedPipeClientStream(".", pipeName, PipeDirection.Out))
            {
                pipeClient.Connect();
                using (StreamWriter sw = new StreamWriter(pipeClient))
                {
                    sw.WriteLine(str);
                    sw.Flush();
                }
            }
        }
    }
}
