﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using System.Windows.Input;

// 基本ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234237 を参照してください

namespace FooEditor
{
    /// <summary>
    /// 多くのアプリケーションに共通の特性を指定する基本ページ。
    /// </summary>
    public sealed partial class FileTypeDetailFlyout : FooEditor.Common.LayoutAwarePage
    {
        public FileTypeDetailFlyout()
        {
            this.InitializeComponent();
            this.LineBreakMethodCollection.ItemsSource = LineBreakMethodEnumCollection.Get();
            this.FlyLayoutCotent.DataContext = this;
            this.FileType = new FileType();
        }

        /// <summary>
        /// このページがフレームに表示されるときに呼び出されます。
        /// </summary>
        /// <param name="e">このページにどのように到達したかを説明するイベント データ。Parameter 
        /// プロパティは、通常、ページを構成するために使用します。</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            this.FileType = (FileType)e.Parameter;
            base.OnNavigatedTo(e);
        }

        /// <summary>
        /// このページには、移動中に渡されるコンテンツを設定します。前のセッションからページを
        /// 再作成する場合は、保存状態も指定されます。
        /// </summary>
        /// <param name="navigationParameter">このページが最初に要求されたときに
        /// <see cref="Frame.Navigate(Type, Object)"/> に渡されたパラメーター値。
        /// </param>
        /// <param name="pageState">前のセッションでこのページによって保存された状態の
        /// ディクショナリ。ページに初めてアクセスするとき、状態は null になります。</param>
        protected override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
        }

        /// <summary>
        /// アプリケーションが中断される場合、またはページがナビゲーション キャッシュから破棄される場合、
        /// このページに関連付けられた状態を保存します。値は、
        /// <see cref="SuspensionManager.SessionState"/> のシリアル化の要件に準拠する必要があります。
        /// </summary>
        /// <param name="pageState">シリアル化可能な状態で作成される空のディクショナリ。</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
        }

        public FileType FileType
        {
            get { return (FileType)GetValue(FileTypeProperty); }
            set { SetValue(FileTypeProperty, value); }
        }

        // Using a DependencyProperty as the backing store for FileType.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty FileTypeProperty =
            DependencyProperty.Register("FileType", typeof(FileType), typeof(FileTypeDetailFlyout), new PropertyMetadata(null));
        
        public ICommand RemoveCommand
        {
            get
            {
                return new DelegateCommand<string>((e) =>
                {
                    this.FileType.ExtensionCollection.Remove(e);
                });
            }
        }

        public ICommand AddCommand
        {
            get
            {
                return new DelegateCommand<string>((e) =>
                {
                    this.FileType.ExtensionCollection.Add(this.NewExtension.Text);
                });
            }
        }
    }
}
