﻿using System;
using System.ComponentModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using System.Runtime.CompilerServices;
using FooEditEngine.Metro;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class GoToFlyout : UserControl,ILineJumpView
    {
        LineJumpViewModel model;
        FooTextBox Textbox;
        public GoToFlyout()
        {
            this.InitializeComponent();
            this.DataContext = this;
        }

        public GoToFlyout(FooTextBox textbox)
            :this()
        {
            this.Textbox = textbox;
            this.model = new LineJumpViewModel(this);
            this.DataContext = this.model;
        }

        private void Button_Click(object sender, Windows.UI.Xaml.RoutedEventArgs e)
        {
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            if (this.model.JumpCaretCommand())
            {
                this.model.Result = string.Format(loader.GetString("LineNumberOutOutOfRange"), 1,this.model.MaxRow);
                return;
            }
            Popup parent = this.Parent as Popup;
            if (parent != null)
                parent.IsOpen = false;
        }

        public int CaretPostionRow
        {
            get { return this.Textbox.CaretPostion.row; }
        }

        public int AvailableMaxRow
        {
            get { return this.Textbox.LayoutLineCollection.Count; }
        }

        public void JumpCaret(int row)
        {
            this.Textbox.JumpCaret(row, 0);
            this.Textbox.Refresh();
        }

    }
}
