﻿using System;
using System.Collections.Generic;

namespace FooEditEngine
{
    /*
    /// <summary>
    /// 新しく作成されるフォールティングアイテムを表す
    /// </summary>
    public struct FoldingItem
    {
        /// <summary>
        /// 開始インデックス
        /// </summary>
        public int Start;
        /// <summary>
        /// 終了インデックス
        /// </summary>
        public int End;
        /// <summary>
        /// コンストラクター
        /// </summary>
        /// <param name="start">開始インデックス</param>
        /// <param name="end">終了インデックス</param>
        public FoldingItem(int start, int end)
        {
            this.Start = start;
            this.End = end;
        }
    }
     */
    /// <summary>
    /// フォールティング作成の方法を表す
    /// </summary>
    public interface IFoldingStrategy
    {
        /// <summary>
        /// ドキュメントを解析する
        /// </summary>
        /// <param name="doc">ドキュメント</param>
        /// <param name="start">開始インデックス</param>
        /// <param name="end">終了インデックス</param>
        /// <returns>作成したフォールディングを表すイテレーター</returns>
        IEnumerable<FoldingItem> AnalyzeDocument(Document doc,int start,int end);
    }
}
