﻿using System;
using System.Collections.Generic;
using SharpDX;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class MyTextLayout : DW.TextLayout
    {
        public MyTextLayout(DW.Factory factory, string str, DW.TextFormat format, Size size)
            : base(factory, str, format, (float)size.Width, (float)size.Height)
        {
            this.Drew = false;
        }

        public bool Drew;
        private LinkedList<DW.InlineObject> inllineObjects = new LinkedList<DW.InlineObject>();

        public new Result SetInlineObject(DW.InlineObject inlineObject, DW.TextRange textRange)
        {
            this.inllineObjects.AddLast(inlineObject);
            return base.SetInlineObject(inlineObject, textRange);
        }

        protected override void Dispose(bool disposing)
        {
            foreach (DW.InlineObject inline in this.inllineObjects)
                inline.Dispose();
            base.Dispose(disposing);
        }
    }
}
