﻿using System;
using System.Collections.Generic;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class MyTextLayout : ITextLayout
    {
        internal MyTextLayout(DW.TextLayout layout)
        {
            this.layout = layout;
            this.Disposed = false;
        }

        DW.TextLayout layout;

        public bool Drew;

        public bool Disposed
        {
            get;
            private set;
        }

        public bool Invaild
        {
            get;
            set;
        }

        public int GetIndexFromX(double x)
        {
            SharpDX.Bool isTrailing, isInsed;
            DW.HitTestMetrics metrics;
            metrics = this.layout.HitTestPoint((float)x, 0, out isTrailing, out isInsed);
            if (isTrailing)
                return Util.RoundUp(metrics.TextPosition + metrics.Length);
            else
                return Util.RoundUp(metrics.TextPosition);
        }

        public double GetWidthFromIndex(int index)
        {
            float x, y;
            DW.HitTestMetrics metrics;
            metrics = this.layout.HitTestTextPosition(index, false, out x, out y);
            float x2;
            layout.HitTestTextPosition(index, true, out x2, out y);

            return x2 - x;
        }

        public double GetXFromIndex(int index)
        {
            float x, y;
            DW.HitTestMetrics metrics;
            metrics = this.layout.HitTestTextPosition(index, false, out x, out y);
            return x;
        }

        public int AlignIndexToNearestCluster(int index, AlignDirection flow)
        {
            float x, y;
            DW.HitTestMetrics metrics;
            metrics = this.layout.HitTestTextPosition(index, false, out x, out y);

            if (flow == AlignDirection.Forward)
                return Util.RoundUp(metrics.TextPosition + metrics.Length);
            else if (flow == AlignDirection.Back)
                return Util.RoundUp(metrics.TextPosition);
            throw new ArgumentOutOfRangeException();
        }

        public double Width
        {
            get
            {
                return Util.RoundUp(this.layout.Metrics.WidthIncludingTrailingWhitespace);
            }
        }

        public double Height
        {
            get
            {
                double height = 0;
                DW.LineMetrics[] metrics = this.layout.GetLineMetrics();
                if (metrics != null && metrics.Length > 0)
                    height = metrics[0].Height;
                return height;
            }
        }

        public void Draw(DW.TextRenderer render, float x, float y)
        {
            this.layout.Draw(render, x, y);
        }

        public void Dispose()
        {
            this.layout.Dispose();
            this.Disposed = true;
        }

        public void SetDrawingEffect(ComObject resource, DW.TextRange range)
        {
            this.layout.SetDrawingEffect(resource, range);
        }

        public void SetUnderline(bool underline, DW.TextRange range)
        {
            this.layout.SetUnderline(underline, range);
        }

        public DW.HitTestMetrics[] HitTestTextRange(int start, int length, float x, float y)
        {
            return this.layout.HitTestTextRange(start, length, x, y);
        }

        public void SetInlineObject(DW.InlineObject o, DW.TextRange range)
        {
            this.layout.SetInlineObject(o, range);
        }
    }
}
