﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;
using FooEditEngine;
using DotNetTextStore;
using DotNetTextStore.UnmanagedAPI.TSF;
using DotNetTextStore.UnmanagedAPI.WinDef;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using D3D10 = SharpDX.Direct3D10;
using D3D9 = SharpDX.Direct3D9;
using DXGI = SharpDX.DXGI;
using System.Runtime.InteropServices;

namespace FooEditEngine.WPF
{

    class WPFRender : ITextRender, IDisposable
    {
        D2DRenderCommon common;
        Color ForegroundColor, BackgroundColor, HilightColor, Keyword1Color, Keyword2Color, LiteralColor, UrlColor, ControlCharColor, CommentColor, InsertCaretColor,OverwriteCaretColor,LineMarkerColor;
        TextStore store;
        D3D10.Texture2D texture;
        DXGI.Surface surface;
        D3D10.Device device;
        D3D9.Device device9;
        D3D9.Surface surface9;
        D2D.RenderTarget render;
        double fontSize;
        FontFamily fontFamily;

        public WPFRender(FooTextBox textbox, double width, double height)
        {
            this.fontFamily = textbox.FontFamily;
            this.fontSize = textbox.FontSize;
            this.ForegroundColor = textbox.Foreground;
            this.BackgroundColor = textbox.Background;
            this.ControlCharColor = textbox.ControlChar;
            this.HilightColor = textbox.Hilight;
            this.CommentColor = textbox.Comment;
            this.UrlColor = textbox.URL;
            this.Keyword1Color = textbox.Keyword1;
            this.Keyword2Color = textbox.Keyword2;
            this.LiteralColor = textbox.Literal;
            this.InsertCaretColor = textbox.InsertCaret;
            this.OverwriteCaretColor = textbox.OverwriteCaret;
            this.LineMarkerColor = textbox.LineMarker;
            this.store = textbox.TextStore;

            this.CreateDevice();

            this.common = new D2DRenderCommon(textbox, width, height);
            this.common.ConstructRender = ConstructRenderHandler;
            this.common.ConstrctedResource = ConstructedResourceHandler;
            this.common.DestructRender = this.DestructRenderHandler;
            this.common.ReCreateTarget = this.ReCreateTarget;
            this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize);
            this.common.ConstructDeviceResource(width, height);
        }

        public D3D9.Surface Surface
        {
            get { return this.surface9; }
        }

        public bool ShowFullSpace
        {
            get
            {
                return this.common.ShowFullSpace;
            }
            set
            {
                this.common.ShowFullSpace = value;
            }
        }

        public bool ShowHalfSpace
        {
            get
            {
                return this.common.ShowHalfSpace;
            }
            set
            {
                this.common.ShowHalfSpace = value;
            }
        }

        public bool ShowTab
        {
            get
            {
                return this.common.ShowTab;
            }
            set
            {
                this.common.ShowTab = value;
            }
        }

        public FontFamily FontFamily
        {
            get { return this.fontFamily; }
            set
            {
                this.fontFamily = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize);
                this.TabWidthChar = this.TabWidthChar;
                this.ChangedRenderResource(this, null);
            }
        }

        public double FontSize
        {
            get { return this.fontSize; }
            set
            {
                this.fontSize = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)value);
                this.TabWidthChar = this.TabWidthChar;
                this.ChangedRenderResource(this, null);
            }
        }

        Color4 ToColor4(Color color)
        {
            return new Color4(color.R / 255.0f, color.G / 255.0f, color.B / 255.0f, color.A / 255.0f);
        }

        public Color Foreground
        {
            get
            {
                return this.ForegroundColor;
            }
            set
            {
                this.ForegroundColor = value;
                this.common.Foreground = this.ToColor4(value);
            }
        }

        public Color Background
        {
            get
            {
                return this.BackgroundColor;
            }
            set
            {
                this.BackgroundColor = value;
                this.common.Background = this.ToColor4(value);
            }
        }

        public Color InsertCaret
        {
            get
            {
                return this.InsertCaretColor;
            }
            set
            {
                this.InsertCaretColor = value;
                this.common.InsertCaret = this.ToColor4(value);
            }
        }

        public Color OverwriteCaret
        {
            get
            {
                return this.OverwriteCaretColor;
            }
            set
            {
                this.OverwriteCaretColor = value;
                this.common.OverwriteCaret = this.ToColor4(value);
            }
        }

        public Color LineMarker
        {
            get
            {
                return this.LineMarkerColor;
            }
            set
            {
                this.LineMarkerColor = value;
                this.common.LineMarker = this.ToColor4(value);
            }
        }

        public Color ControlChar
        {
            get
            {
                return this.ControlCharColor;
            }
            set
            {
                this.ControlCharColor = value;
                this.common.ControlChar = this.ToColor4(value);
            }
        }
        
        public Color Url
        {
            get
            {
                return this.UrlColor;
            }
            set
            {
                this.UrlColor = value;
                this.common.Url = this.ToColor4(value);
            }
        }

        public Color Hilight
        {
            get
            {
                return this.HilightColor;
            }
            set
            {
                this.HilightColor = value;
                this.common.Hilight = this.ToColor4(value);
            }
        }

        public Color Comment
        {
            get
            {
                return this.CommentColor;
            }
            set
            {
                this.CommentColor = value;
                this.common.Comment = this.ToColor4(value);
            }
        }

        public Color Literal
        {
            get
            {
                return this.LiteralColor;
            }
            set
            {
                this.LiteralColor = value;
                this.common.Literal = this.ToColor4(value);
            }
        }

        public Color Keyword1
        {
            get
            {
                return this.Keyword1Color;
            }
            set
            {
                this.Keyword1Color = value;
                this.common.Keyword1 = this.ToColor4(value);
            }
        }

        public Color Keyword2
        {
            get
            {
                return this.Keyword2Color;
            }
            set
            {
                this.Keyword2Color = value;
                this.common.Keyword2 = this.ToColor4(value);
            }
        }

        public Rectangle ClipRect
        {
            get { return this.common.ClipRect; }
            set { this.common.ClipRect = value; }
        }

        public double LineNemberWidth
        {
            get
            {
                return this.common.LineNemberWidth;
            }
        }

        public int TabWidthChar
        {
            get { return this.common.TabWidthChar; }
            set
            {
                this.common.TabWidthChar = value;
            }
        }

        public event ChangedRenderResourceEventHandler ChangedRenderResource;

        public void Resize(double width,double height)
        {
            this.common.ReConstructDeviceResource(width, height);
        }

        public void ClearLayoutCache()
        {
            this.common.ClearLayoutCache();
        }

        public void DrawCachedBitmap(Rectangle rect)
        {
            this.common.DrawCachedBitmap(rect);
        }

        public void CacheContent()
        {
            this.common.CacheContent();
        }

        public bool IsVaildCache()
        {
            return this.common.IsVaildCache();
        }

        public void BegineDraw()
        {
            this.common.BegineDraw();
        }

        public void EndDraw()
        {
            this.common.EndDraw();
            this.device.Flush();
        }

        public void DrawLineNumber(int lineNumber, double x, double y)
        {
            this.common.DrawLineNumber(lineNumber, x, y);
        }

        public void DrawLineMarker(Rectangle rect)
        {
            this.common.DrawLineMarker(rect);
        }

        public void DrawCaret(Rectangle rect, bool transparent)
        {
            this.common.DrawCaret(rect, transparent);
        }

        public void FillBackground(Rectangle rect)
        {
            this.common.FillBackground(rect);
        }

        public void DrawOneLine(LineToIndexTable lti, int row, double x, double y, IEnumerable<Selection> SelectRanges, IEnumerable<Marker> MarkerRanges)
        {
            PreDrawOneLineHandler PreDrawOneLine = (layout) => {
                using (Unlocker locker = this.store.LockDocument(false))
                {
                    foreach (TextDisplayAttribute attr in this.store.EnumAttributes())
                    {
                        if (attr.startIndex == attr.endIndex)
                            continue;
                        int lineIndex = lti.GetIndexFromLineNumber(row);
                        int lineLength = lti.GetLengthFromLineNumber(row);
                        int length = attr.endIndex - attr.startIndex;
                        int start = attr.startIndex - lineIndex;
                        if (start < 0)
                        {
                            if (attr.endIndex > lineIndex && attr.endIndex < lineIndex + lineLength)
                            {
                                start = 0;
                                length = attr.endIndex - lineIndex;
                            }
                            else if (attr.endIndex >= lineIndex + lineLength)
                            {
                                start = 0;
                                length = lineLength;
                            }
                            else
                            {
                                continue;
                            }
                        }
                        else if (start > lineLength)
                        {
                            continue;
                        }

                        HilightType type = HilightType.None;
                        switch (attr.attribute.lsStyle)
                        {
                            case TF_DA_LINESTYLE.TF_LS_DOT:
                                type = HilightType.Dot;
                                break;
                            case TF_DA_LINESTYLE.TF_LS_SOLID:
                                type = HilightType.Sold;
                                break;
                            case TF_DA_LINESTYLE.TF_LS_DASH:
                                type = HilightType.Dash;
                                break;
                            case TF_DA_LINESTYLE.TF_LS_SQUIGGLE:
                                type = HilightType.Squiggle;
                                break;
                            default:
                                type = HilightType.Select;
                                break;
                        }

                        this.common.ApplyEffect(layout, type, start, length, x, y, attr.attribute.fBoldLine);
                    }
                }
            };
            this.common.DrawOneLine(lti,
                row,
                x,
                y,
                SelectRanges,
                MarkerRanges,
                PreDrawOneLine);
        }

        public int GetIndexFromX(string str, double x)
        {
            return this.common.GetIndexFromX(str, x);
        }

        public double GetWidthFromIndex(string str, int index)
        {
            return this.common.GetWidthFromIndex(str, index);
        }

        public double GetWidth(string str)
        {
            return this.common.GetWidth(str);
        }

        public double GetXFromIndex(string str, int index)
        {
            return this.common.GetXFromIndex(str, index);
        }

        public double GetHeight(string str)
        {
            return this.common.GetHeight(str);
        }

        public int AlignIndexToNearestCluster(string str, int index, AlignDirection flow)
        {
            return this.common.AlignIndexToNearestCluster(str, index, flow);
        }

        public List<LineToIndexTableData> BreakLine(Document doc, int startIndex, int endIndex, double wrapwidth)
        {
            return this.common.BreakLine(doc, startIndex, endIndex, wrapwidth);
        }

        public void Dispose()
        {
            this.common.Dispose();
            this.DestructDevice();
        }

        void ReCreateTarget()
        {
            System.Diagnostics.Debug.WriteLine("ReCreatedDevice");
            this.DestructDevice();
            this.CreateDevice();
            this.common.ReConstructDeviceResource();
        }

        void CreateDevice()
        {
            this.device = new D3D10.Device1(D3D10.DriverType.Hardware, D3D10.DeviceCreationFlags.BgraSupport);

            IntPtr DesktopWnd = GetDesktopWindow();
            D3D9.PresentParameters param = new D3D9.PresentParameters();
            param.Windowed = true;
            param.SwapEffect = D3D9.SwapEffect.Discard;
            param.DeviceWindowHandle = DesktopWnd;
            param.PresentationInterval = D3D9.PresentInterval.Immediate;
            D3D9.Direct3DEx d3dex = new D3D9.Direct3DEx();
            this.device9 = new D3D9.DeviceEx(
                d3dex,
                0,
                D3D9.DeviceType.Hardware,
                DesktopWnd,
                D3D9.CreateFlags.HardwareVertexProcessing | D3D9.CreateFlags.Multithreaded | D3D9.CreateFlags.FpuPreserve,
                param);
            d3dex.Dispose();
        }

        void DestructDevice()
        {
            if (this.device != null)
                this.device.Dispose();
            if (this.device9 != null)
                this.device9.Dispose();
        }

        [DllImport("user32.dll", SetLastError = false)]
        static extern IntPtr GetDesktopWindow();

        D2D.RenderTarget ConstructRenderHandler(D2D.Factory factory, D2D.RenderTargetProperties prop, double width, double height)
        {
            D3D10.Texture2DDescription desc = new D3D10.Texture2DDescription();
            desc.Width = (int)width;
            desc.Height = (int)height;
            desc.MipLevels = 1;
            desc.ArraySize = 1;
            desc.Format = DXGI.Format.B8G8R8A8_UNorm;
            desc.SampleDescription = new DXGI.SampleDescription(1, 0);
            desc.Usage = D3D10.ResourceUsage.Default;
            desc.BindFlags = D3D10.BindFlags.RenderTarget | D3D10.BindFlags.ShaderResource;
            desc.CpuAccessFlags = D3D10.CpuAccessFlags.None;
            desc.OptionFlags = D3D10.ResourceOptionFlags.Shared;
            this.texture = new D3D10.Texture2D(this.device, desc);

            this.surface = this.texture.QueryInterface<DXGI.Surface>();

            DXGI.Resource resource = this.texture.QueryInterface<DXGI.Resource>();
            IntPtr handel = resource.SharedHandle;
            D3D9.Texture texture = new D3D9.Texture(
                this.device9,
                this.texture.Description.Width,
                this.texture.Description.Height,
                1,
                D3D9.Usage.RenderTarget,
                D3D9.Format.A8R8G8B8,
                D3D9.Pool.Default,
                ref handel);
            this.surface9 = texture.GetSurfaceLevel(0);
            resource.Dispose();
            texture.Dispose();

            this.render = new D2D.RenderTarget(factory, this.surface, prop);
            return this.render;
        }

        void ConstructedResourceHandler()
        {
            this.common.Foreground = this.ToColor4(this.ForegroundColor);
            this.common.Background = this.ToColor4(this.BackgroundColor);
            this.common.ControlChar = this.ToColor4(this.ControlCharColor);
            this.common.Url = this.ToColor4(this.UrlColor);
            this.common.Keyword1 = this.ToColor4(this.Keyword1Color);
            this.common.Keyword2 = this.ToColor4(this.Keyword2Color);
            this.common.Literal = this.ToColor4(this.LiteralColor);
            this.common.Comment = this.ToColor4(this.CommentColor);
            this.common.Hilight = this.ToColor4(this.HilightColor);
            this.common.LineMarker = this.ToColor4(this.LineMarkerColor);
            this.common.InsertCaret = this.ToColor4(this.InsertCaretColor);
            this.common.OverwriteCaret = this.ToColor4(this.OverwriteCaretColor); 
        }

        void DestructRenderHandler()
        {
            if (this.texture != null)
                this.texture.Dispose();
            if (this.surface != null)
                this.surface.Dispose();
            if (this.surface9 != null)
                this.surface9.Dispose();
            if (this.render != null)
                this.render.Dispose();
        }
    }
}
