﻿using System;
using System.Windows;
using FooProject.WPFHost;
using DWriteWarpper;

namespace Test3
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        DFactory factory = new DFactory();
        DWindowRender render;
        DTextFormat format;
        DTextLayout layout;
        DDrawingEffect effect;
        DColorBrush fore, control;
        WPFHost Host;

        public MainWindow()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(MainWindow_Loaded);
            Dispatcher.ShutdownStarted += new EventHandler(Dispatcher_ShutdownStarted);
        }

        void Dispatcher_ShutdownStarted(object sender, EventArgs e)
        {
            effect.Dispose();
            control.Dispose();
            fore.Dispose();
            format.Dispose();
            render.Dispose();
            factory.Dispose();
        }

        void MainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            this.Host = new WPFHost();
            this.Host.SizeChanged += new SizeChangedEventHandler(Host_SizeChanged);
            this.ControlHost.Children.Add(this.Host);

            render = factory.CreateWindowRender(this.Host.Handle, true);
            fore = render.CreateBrush(new Color2F(0, 0, 0, 255));
            control = render.CreateBrush(new Color2F(128, 128, 128, 255));
            effect = new DDrawingEffect(render.CreateBrush(new Color2F(0, 0, 255, 255)), null, factory.CrateStrokeStyke(DLineStyle.Dash));
            render.InitTextRender(fore, control);
            render.AddControlSymbol('\n', 0x2193);
            render.AddControlSymbol('\t', 0x3e);
            render.AddControlSymbol((char)0x1a, 0xFFE9);
            render.AddControlSymbol('　', 0x25A1);
            format = factory.CreateTextFormat(this.FontFamily.Source, (float)this.FontSize);
            format.TabWidth = 24;
        }

        void Host_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            this.render.Resize((uint)e.NewSize.Width, (uint)e.NewSize.Height);
            this.Refresh();
        }

        void Refresh()
        {
            const string message = "\thello　 world\n\u001a";

            render.BeginDraw();

            render.Clear(new Color2F(240, 240, 240, 255));
            layout = factory.CreateGdiTextLayout(format, message, (float)this.ControlHost.ActualWidth, (float)this.ControlHost.ActualHeight, true);
            layout.SetTextEffect(1, 2, control);
            layout.SetUnderline(1, 2, true);
            layout.SetTextEffect(3, 4, effect);
            layout.SetUnderline(3, 4, true);
            render.DrawTextLayout(layout, 0, 0);

            layout.Dispose();

            render.Flush();

            DBitmap bmp = render.CreateBitmap(new SizeU(20, 20));
            bmp.CopyFromRenderTarget(new Point2U(), render, new RectU(0, 0, 20, 20));
            render.DrawBitmap(bmp, new RectF(100, 100, 120, 120), 1.0f, new RectF(0, 0, 20, 20));
            bmp.Dispose();

            render.EndDraw();
        }
    }
}
