﻿using System;
using System.Drawing;
using System.Windows.Forms;
using DWriteWarpper;

namespace Test
{
    public partial class Form1 : Form
    {
        DFactory factory = new DFactory();
        DWindowRender render;
        DTextFormat format;
        DTextLayout layout;
        DDrawingEffect effect;
        DColorBrush fore,control;
        public Form1()
        {
            InitializeComponent();
            render = factory.CreateWindowRender(this.Handle,true);
            fore = render.CreateBrush(new Color2F(0, 0, 0, 255));
            control = render.CreateBrush(new Color2F(128, 128, 128, 255));
            effect = new DDrawingEffect(render.CreateBrush(new Color2F(0, 0, 255, 255)), null, factory.CrateStrokeStyke(DLineStyle.Dash));
            render.InitTextRender(fore, control);
            render.AddControlSymbol('\n', 0x2193);
            render.AddControlSymbol('\t', 0x3e);
            render.AddControlSymbol((char)0x1a, 0xFFE9);
            render.AddControlSymbol('　', 0x25A1);
            format = factory.CreateTextFormat(this.Font.Name,this.Font.Size);
            format.TabWidth = 24;
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            const string message = "\thello　 world\n\u001a";
            
            render.BeginDraw();
            
            render.Clear(new Color2F(240, 240, 240, 255));
            layout = factory.CreateGdiTextLayout(format, message, this.ClientSize.Width,this.ClientSize.Height,true);
            layout.SetTextEffect(1, 2,control);
            layout.SetUnderline(1, 2, true);
            layout.SetTextEffect(3, 4, effect);
            layout.SetUnderline(3, 4, true);
            DHitTestMetrics[] metrics = layout.HitTestTextRange(1, 3, 0, 0);
            render.DrawTextLayout(layout, 0, 0);

            layout.Dispose();

            render.Flush();

            DBitmap bmp = render.CreateBitmap(new SizeU(20, 20));
            bmp.CopyFromRenderTarget(new Point2U(), render, new RectU(0, 0, 20, 20));
            render.DrawBitmap(bmp, new RectF(100, 100, 120, 120), 1.0f, new RectF(0, 0, 20, 20));
            bmp.Dispose();

            render.EndDraw();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            DestructResource();
        }

        private void DestructResource()
        {
            effect.Dispose();
            control.Dispose();
            fore.Dispose();
            format.Dispose();
            render.Dispose();
            factory.Dispose();
        }

        private void Form1_ClientSizeChanged(object sender, EventArgs e)
        {
            render.Resize((uint)this.ClientSize.Width, (uint)this.ClientSize.Height);
        }
    }
}
