#pragma once

#include "StdAfx.h"
#include "Common.h"
#include "Util.h"
#include "DTextFormat.h"
#include "DTextLayout.h"
#include "DStrokeStyle.h"
#include "DWindowRender.h"
#include "DRenderingParams.h"
#include "DXGISurface.h"
#include <vcclr.h>

using namespace System;

namespace DWriteWarpper {
	public ref class DFactory
	{
	private:
		ID2D1Factory* pD2DFactory_;
		IDWriteFactory* pDWriteFactory_;
		float dpiScaleX_;
		float dpiScaleY_;
		bool disposed;
	public:
		DFactory();

		DWindowRender^ CreateWindowRender(IntPtr handel,bool vsync);

		DTextFormat^ CreateTextFormat(String^ fontName,float point);

		DTextLayout^ CreateTextLayout(DTextFormat^ format,String^ str,float width,float height);

		DTextLayout^ CreateGdiTextLayout(DTextFormat^ format,String^ str,float width,float height,bool useGdiNatural);

		DRenderBase^ CreateDxgiSurfaceRenderTarget(DXGISurface^ surface);

		DStrokeStyle^ CrateStrokeStyke(DLineStyle style);

		DRenderingParams^ CreateMonitorRenderingParams(IntPtr hmonitor);

		~DFactory();

		!DFactory();
	};
}
