#include "Stdafx.h"
#include "D3D10Device.h"

using namespace DWriteWarpper;

D3D10Device::D3D10Device(void)
{
	HRESULT hr;
	D3D10_FEATURE_LEVEL1 featureLevels[] = {D3D10_FEATURE_LEVEL_10_1,
		D3D10_FEATURE_LEVEL_10_0,
		D3D10_FEATURE_LEVEL_9_3,
		D3D10_FEATURE_LEVEL_9_2,
		D3D10_FEATURE_LEVEL_9_1};
	
	for(int i = 0; i < sizeof(featureLevels)/sizeof(D3D_FEATURE_LEVEL); i++)
	{
		ID3D10Device1* pDevice;
		hr = D3D10CreateDevice1(NULL,
			D3D10_DRIVER_TYPE_HARDWARE,
			NULL,
			D3D11_CREATE_DEVICE_BGRA_SUPPORT,
			featureLevels[i],
			D3D10_1_SDK_VERSION,
			&pDevice);
		this->device = pDevice;
		if(hr == S_OK)
			return;
	}
	throw "Fail D3D11CreateDevice";
}

D2DTexture^ D3D10Device::CreateTexture2D(int width,int height)
{
	DXGI_SAMPLE_DESC sample;
	sample.Count = 1;
	sample.Quality = 0;

	D3D10_TEXTURE2D_DESC desc;
	desc.Width = width;
	desc.Height = height;
	desc.MipLevels = 1;
	desc.ArraySize = 1;
	desc.Format = DXGI_FORMAT_B8G8R8A8_UNORM;
	desc.SampleDesc = sample;
	desc.Usage = D3D10_USAGE_DEFAULT;
	desc.BindFlags = D3D10_BIND_RENDER_TARGET | D3D10_BIND_SHADER_RESOURCE;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = D3D10_RESOURCE_MISC_SHARED;

	ID3D10Texture2D* texture;

	this->device->CreateTexture2D(&desc,NULL,&texture);

	return gcnew D2DTexture(texture);
}

void D3D10Device::Flush()
{
	this->device->Flush();
}

D3D10Device::~D3D10Device(void)
{
	GC::SuppressFinalize(this);
	this->!D3D10Device();
}

D3D10Device::!D3D10Device()
{
	if(this->device != NULL)
	{
		this->device->Release();
		this->device = NULL;
	}
}
