﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FooEditEngine
{
    enum GripperType
    {
        First,
        Second,
    }
    class GripperManager
    {
        Controller Controller;
        EditView View;
        D2DRender Render;
        public GripperManager(Controller controller, EditView view,D2DRender render)
        {
            this.Controller = controller;
            this.View = view;
            this.Render = render;
            this.Enabled = false;
        }

        public bool Enabled
        {
            get;
            set;
        }

        public Rectangle HitTest(GripperType type,Point p)
        {
            Rectangle gripperRect = this.GetGripperPoint(type);
            if (this.Enabled && gripperRect.IsHit(p))
                return gripperRect;
            return Rectangle.Empty;
        }

        public Rectangle GetGripperPoint(GripperType type)
        {
            TextPoint tp;
            Point point;
            double radius = D2DRender.CramToFitWidth / 2;
            if (type == GripperType.Second)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart + this.Controller.SelectionLength);
                point = this.View.GetPostionFromTextPoint(tp);
                double lineHeight = this.View.LayoutLines.GetData(tp.row).Layout.Height;
                return new Rectangle(point.X - radius, point.Y + lineHeight, D2DRender.CramToFitWidth, D2DRender.CramToFitWidth);
            }
            else if (type == GripperType.First)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart);
                point = this.View.GetPostionFromTextPoint(tp);
                return new Rectangle(point.X - radius, point.Y - D2DRender.CramToFitWidth, D2DRender.CramToFitWidth, D2DRender.CramToFitWidth);
            }
            else
            {
                throw new ArgumentOutOfRangeException();
            }
        }

        public Point GetPointOnGripper(GripperType type,Rectangle gripperRect, Point p)
        {
            if (type == GripperType.First)
            {
                if (gripperRect.IsHit(p))
                    p.Y = gripperRect.Bottom + 1;
                else
                    p.Y += gripperRect.Height;
            }
            else
            {
                if (gripperRect.IsHit(p))
                    p.Y = gripperRect.Y - 1;
                else
                    p.Y -= gripperRect.Height;
            }
            if (p.Y < this.Render.TextArea.Y)
                p.Y = this.Render.TextArea.Y;
            return p;
        }

        public void DrawGrippers()
        {
            if (!this.Enabled)
                return;
            DrawGripper(GripperType.First);
            DrawGripper(GripperType.Second);
        }
        void DrawGripper(GripperType type)
        {
            Rectangle gripperRect = GetGripperPoint(type);
            double radius = gripperRect.Width / 2;
            Point point;
            if(type == GripperType.First)
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            else
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            this.Render.DrawGripper(point, radius);
        }
    }
}
