
LANGUAGES = ja

qtPrepareTool(LRELEASE, lrelease)
qtPrepareTool(LCONVERT, lconvert)
qtPrepareTool(LUPDATE, lupdate)
LUPDATE += -locations relative -no-ui-lines

defineReplace(prependAll) {
    for(a,$$1):result += $$2$${a}$$3
    return($$result)
}

wd = $$replace(SOURCE_TREE_ROOT, /, $$QMAKE_DIR_SEP)
sources = . qml/fontmanager

TRANSLATIONS = $$prependAll(LANGUAGES, $$PWD/fontmanager_,.ts)

files = $$files($$PWD/*_??.ts) $$PWD/fontmanager_untranslated.ts
for(file, files) {
    lang = $$replace(file, .*_([^/]*)\\.ts, \\1)
    v = ts-$${lang}.commands
    $$v = cd $$wd && $$LUPDATE $$sources -ts $$file
    QMAKE_EXTRA_TARGETS += ts-$$lang
}
ts-all.commands = cd $$wd && $$LUPDATE $$sources -ts $$files
QMAKE_EXTRA_TARGETS += ts-all

updateqm.input = TRANSLATIONS
updateqm.output = $${BUILD_TREE_ROOT}/translations/${QMAKE_FILE_BASE}.qm
isEmpty(vcproj):updateqm.variable_out = PRE_TARGETDEPS
updateqm.commands = $$LRELEASE ${QMAKE_FILE_IN} -qm ${QMAKE_FILE_OUT}
updateqm.name = LRELEASE ${QMAKE_FILE_IN}
updateqm.CONFIG += no_link
QMAKE_EXTRA_COMPILERS += updateqm

installPrefix = /opt/fontmanager

qmfiles.files = $$prependAll(LANGUAGES, $$OUT_PWD/translations/fontmanager_,.qm)
qmfiles.path = $${installPrefix}/i18n
qmfiles.CONFIG += no_check_exist
INSTALLS += qmfiles
