/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

PageStackWindow {
    id: appWindow

    initialPage: mainPage

    MainPage {
        id: mainPage
    }

    property string filePath
    property string alertMessage

    Connections {
        target: controller
        onAlertDialog: {
            alertMessage = message
            openAlertDialog()
        }

        onInstallFinished: {
            filePath = fontpath
            openInstallFinishedDialog()
        }

        onUninstallFinished: {
            filePath = fontpath
            openUninstallFinishedDialog()
        }

        onBackupConfigFinished: {
            filePath = filepath
            openBackupConfigFinishedDialog()
        }

        onRestoreConfigFinished: {
            filePath = filepath
            openRestoreConfigFinishedDialog()
        }

        onClearInstallableFamilyListFor: {
            installableFamilyListModel.clear()
            installableFamilyListModel.family = family;
        }

        onAppendInstallableFamily: {
            installableFamilyListModel.append( { "name": family, "enfamily": enfamily, "systemFont": systemFont } )
        }
    }

    ListModel {
        id: installableFamilyListModel
        property string family
    }

    Component {
        id: fontSelectionPage
        FontSelectionPage {
        }
    }

    function openAlertDialog()
    {
        queryDialog.statusChanged.disconnect(openAlertDialog)
        if (queryDialog.status !== DialogStatus.Closed) {
            queryDialog.statusChanged.connect(openAlertDialog)
            return
        }
        queryDialog.titleText = qsTr("Alert")
        queryDialog.message = alertMessage
        queryDialog.acceptButtonText = qsTr("Close")
        queryDialog.rejectButtonText = ""
        queryDialog.open()
    }

    function openFinishedDialog()
    {
        queryDialog.acceptButtonText = qsTr("Close")
        queryDialog.rejectButtonText = ""
        queryDialog.accepted.connect(popToMainPage)
        queryDialog.rejected.connect(popToMainPage)
        queryDialog.open()
    }

    function openInstallFinishedDialog()
    {
        queryDialog.statusChanged.disconnect(openInstallFinishedDialog)
        if (queryDialog.status !== DialogStatus.Closed) {
            queryDialog.statusChanged.connect(openInstallFinishedDialog)
            return
        }
        queryDialog.titleText = qsTr("Install finished")
        queryDialog.message = qsTr("Font '%1' is installed successfully.").arg(filePath)
        openFinishedDialog()
    }

    function openUninstallFinishedDialog()
    {
        queryDialog.statusChanged.disconnect(openUninstallFinishedDialog)
        if (queryDialog.status !== DialogStatus.Closed) {
            queryDialog.statusChanged.connect(openUninstallFinishedDialog)
            return
        }
        queryDialog.titleText = qsTr("Uninstall finished")
        queryDialog.message = qsTr("Font '%1' is uninstalled successfully.").arg(filePath)
        openFinishedDialog()
    }

    function openBackupConfigFinishedDialog()
    {
        queryDialog.statusChanged.disconnect(openBackupConfigFinishedDialog)
        if (queryDialog.status !== DialogStatus.Closed) {
            queryDialog.statusChanged.connect(openBackupConfigFinishedDialog)
            return
        }
        queryDialog.titleText = qsTr("Backup finished")
        queryDialog.message = qsTr("Fonts Config is backuped as '%1' successfully.").arg(controller.path4display(filePath))
        openFinishedDialog()
    }

    function openRestoreConfigFinishedDialog()
    {
        queryDialog.statusChanged.disconnect(openRestoreConfigFinishedDialog)
        if (queryDialog.status !== DialogStatus.Closed) {
            queryDialog.statusChanged.connect(openRestoreConfigFinishedDialog)
            return
        }
        queryDialog.titleText = qsTr("Restore finished")
        queryDialog.message = qsTr("Fonts Config is restored from '%1' successfully.").arg(controller.path4display(filePath))
        openFinishedDialog()
    }

    function popToMainPage()
    {
        queryDialog.accepted.disconnect(popToMainPage)
        queryDialog.rejected.disconnect(popToMainPage)
        if (pageStack.currentPage !== mainPage)
            pageStack.pop(mainPage)
    }

    QueryDialog {
        id: queryDialog
    }

}
