/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import com.nokia.meego 1.0
import Qt.labs.folderlistmodel 1.0
import 'UIConstants.js' as UI

FileSelectionPage {

    pageTitle: qsTr("Restore Fonts Config")
    folder: controller.backupDir
    nameFilters: [ "*.conf" ]

    property url restoreFilePath

    onClicked: {
        restoreFilePath = filePath
        if (controller.localFontsConfExists)
            openRestoreConfirmDialog()
        else
            restoreFontsConf()
    }

    function openRestoreConfirmDialog()
    {
        queryDialog.titleText = qsTr("Restore it?")
        queryDialog.message = qsTr("Existing Fonts Config will be replaced by '%1'.  Are you sure?").arg(controller.path4display(controller.url2path(restoreFilePath)))
        queryDialog.acceptButtonText = qsTr("OK")
        queryDialog.rejectButtonText = qsTr("Cancel")
        queryDialog.accepted.connect(restoreFontsConf)
        queryDialog.open()
    }

    function restoreFontsConf()
    {
        queryDialog.accepted.disconnect(restoreFontsConf)
        controller.restoreConfig(restoreFilePath)
    }

}
