/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import com.nokia.meego 1.0
import 'functions.js' as Tool
import 'UIConstants.js' as UI

Page {
    tools: installedFontTools
    property variant fontInfo

    function saveConfig()
    {
        if (fontProperty.modified) {
            fontProperty.save()
            controller.updateFontsConf(fontInfo)
//            controller.saveFontsConf()
        }
    }

    PageHeader {
        id: pageHeader
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        text: qsTr("Installed Font Info")
    }

    Flickable {
        id: view
        anchors.top: pageHeader.bottom
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.margins: UI.DEFAULT_MARGIN / 2
        clip: true

//        contentWidth: contentColumn.width
        contentHeight: contentColumn.height

        Column {
            id: contentColumn
            width: parent.width
            spacing: UI.DEFAULT_MARGIN
            Label {
                width: parent.width
                text: qsTr("<b>Family</b>: %1").arg(fontInfo.localefamily)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Example</b>: ")
            }
            Label {
                width: parent.width - UI.DEFAULT_MARGIN * 2
                x: UI.DEFAULT_MARGIN
                text: qsTr("The quick brown fox jumps over the lazy dog")
                font.family: fontInfo.enfamily
                font.bold: /*(fontInfo.enstyle.match(/bold/i) ? true : false) ||*/  (fontInfo.weight >= 200)
                font.italic: /*(fontInfo.enstyle.match(/italic/i) ? true : false) ||*/ (fontInfo.slant !== 0)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Style</b>: %1").arg(fontInfo.localestyle)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Full Name</b>: %1").arg(fontInfo.localefullname)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Slant</b>: %1").arg(fontInfo.slant)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Weight</b>: %1").arg(fontInfo.weight)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Width</b>: %1").arg(fontInfo.width)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Foundry</b>: %1").arg(fontInfo.foundry)
            }
            Label {
                width: parent.width
                text: qsTr("<b>File</b>: %1").arg(fontInfo.file)
            }
            Label {
                width: parent.width
                text: qsTr("<b>Outline</b>: %1").arg(Tool.boolToString(fontInfo.outline))
            }
            Label {
                width: parent.width
                text: qsTr("<b>Scalable</b>: %1").arg(Tool.boolToString(fontInfo.scalable))
            }
            Label {
                width: parent.width
                text: qsTr("<b>Language</b>: %1").arg(Tool.toString(fontInfo.lang))
            }
            Item { width: 1; height: 10 }
            Label {
                width: parent.width
                text: qsTr("<b>System Font</b>: %1").arg(Tool.boolToString(fontInfo.systemFont))
            }
            Item { width: 1; height: 10 }
            Label {
                width: parent.width
                text: qsTr("<b>Fonts Config</b>")
            }
            FontsConfProperties {
                id: fontProperty
                width: parent.width
                fontconf: fontInfo.fontProperty()
            }
        }
    }

    function openDeleteConfirmDialog(fontcount, fontlist)
    {
        queryDialog.titleText = qsTr("Delete Font?")
        if (fontcount > 1)
            queryDialog.message = qsTr("This Font has %1 families(%2).  Do you really want to remove these fonts now?").arg(fontcount).arg(fontlist ? fontlist.join(qsTr(', ')) : qsTr("Unknown"))
        else
            queryDialog.message = qsTr("Do you really want to remove this font now?")
        queryDialog.acceptButtonText = qsTr("OK")
        queryDialog.rejectButtonText = qsTr("Cancel")
        queryDialog.accepted.connect(uninstallFont)
        queryDialog.open()
    }

    function uninstallFont()
    {
        queryDialog.accepted.disconnect(uninstallFont)
        controller.uninstallFont(fontInfo.file)
    }

    ToolBarLayout {
        id: installedFontTools
        visible: true
        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: {
                saveConfig()
                pageStack.pop()
            }
        }
        ToolIcon {
            platformIconId: "toolbar-delete"
            anchors.horizontalCenter: parent.horizontalCenter
            onClicked: {
                var fontlist = controller.fontCount(fontInfo.file)
                openDeleteConfirmDialog(fontlist.length, fontlist)
            }
        }
    }

}
